/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dan200.computercraft.client.model.LecternPocketModel;
import dan200.computercraft.client.model.LecternPrintoutModel;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.util.ARGB32;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CustomLecternRenderer
implements BlockEntityRenderer<CustomLecternBlockEntity> {
    private static final int POCKET_TERMINAL_RENDER_DISTANCE = 32;
    private final BlockEntityRenderDispatcher berDispatcher;
    private final LecternPrintoutModel printoutModel;
    private final LecternPocketModel pocketModel;

    public CustomLecternRenderer(BlockEntityRendererProvider.Context context) {
        this.berDispatcher = context.m_173581_();
        this.printoutModel = new LecternPrintoutModel();
        this.pocketModel = new LecternPocketModel();
    }

    public void render(CustomLecternBlockEntity lectern, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 1.0625f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-((Direction)lectern.m_58900_().m_61143_((Property)LecternBlock.f_54465_)).m_122427_().m_122435_()));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(67.5f));
        poseStack.m_252880_(0.0f, -0.125f, 0.0f);
        ItemStack item = lectern.getItem();
        if (item.m_41720_() instanceof PrintoutItem) {
            VertexConsumer vertexConsumer = LecternPrintoutModel.MATERIAL.m_119194_(buffer, RenderType::m_110446_);
            if (item.m_150930_((Item)ModRegistry.Items.PRINTED_BOOK.get())) {
                this.printoutModel.renderBook(poseStack, vertexConsumer, packedLight, packedOverlay);
            } else {
                this.printoutModel.renderPages(poseStack, vertexConsumer, packedLight, packedOverlay, PrintoutItem.getPageCount(item));
            }
        } else {
            Item vertexConsumer = item.m_41720_();
            if (vertexConsumer instanceof PocketComputerItem) {
                PocketComputerItem pocket = (PocketComputerItem)vertexConsumer;
                PocketComputerData computer = ClientPocketComputers.get(item);
                this.pocketModel.render(poseStack, buffer, packedLight, packedOverlay, pocket.getFamily(), pocket.getColour(item), ARGB32.opaque(computer == null || computer.getLightState() == -1 ? Colour.BLACK.getHex() : computer.getLightState()));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                poseStack.m_85837_(-0.1875, 0.25, 0.0625);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                NetworkedTerminal terminal = computer == null ? null : computer.getTerminal();
                FixedWidthFontRenderer.QuadEmitter quadEmitter = FixedWidthFontRenderer.toVertexConsumer(poseStack, buffer.m_6299_(RenderTypes.TERMINAL));
                if (terminal != null && Vec3.m_82512_((Vec3i)lectern.m_58899_()).m_82509_((Position)this.berDispatcher.f_112249_.m_90583_(), 32.0)) {
                    CustomLecternRenderer.renderPocketTerminal(poseStack, quadEmitter, terminal);
                } else {
                    FixedWidthFontRenderer.drawEmptyTerminal(quadEmitter, 0.0f, 0.0f, 0.375f, 0.4375f);
                }
            }
        }
        poseStack.m_85849_();
    }

    private static void renderPocketTerminal(PoseStack poseStack, FixedWidthFontRenderer.QuadEmitter quadEmitter, Terminal terminal) {
        int width = terminal.getWidth() * 6;
        int height = terminal.getHeight() * 9;
        float scaleX = 0.375f / (float)(width + 4);
        float scaleY = 0.4375f / (float)(height + 4);
        float scale = Math.min(scaleX, scaleY);
        poseStack.m_85841_(scale, scale, -1.0f);
        float marginX = (0.375f / scale - (float)width) / 2.0f;
        float marginY = (0.4375f / scale - (float)height) / 2.0f;
        FixedWidthFontRenderer.drawTerminal(quadEmitter, marginX, marginY, terminal, marginY, marginY, marginX, marginX);
    }
}

