/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.lectern;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jspecify.annotations.Nullable;

public class CustomLecternBlock
extends LecternBlock {
    private static final BlockEntityTicker<CustomLecternBlockEntity> serverTicker = (level, pos, state, lectern) -> lectern.tick();

    public CustomLecternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)f_54467_, (Comparable)Boolean.valueOf(true)));
    }

    public static void replaceLectern(Level level, BlockPos pos, BlockState blockState, ItemStack item) {
        level.m_46597_(pos, (BlockState)((BlockState)((BlockState)((CustomLecternBlock)((Object)ModRegistry.Blocks.LECTERN.get())).m_49966_().m_61124_((Property)f_54467_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54465_, (Comparable)((Direction)blockState.m_61143_((Property)f_54465_)))).m_61124_((Property)f_54466_, (Comparable)((Boolean)blockState.m_61143_((Property)f_54466_))));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CustomLecternBlockEntity) {
            CustomLecternBlockEntity be = (CustomLecternBlockEntity)blockEntity;
            be.setItem(item.m_41620_(1));
        }
    }

    public static InteractionResult defaultUseItemOn(UseOnContext context) {
        BlockPos blockPos;
        Level level = context.m_43725_();
        BlockState blockState = level.m_8055_(blockPos = context.m_8083_());
        if (blockState.m_60713_(Blocks.f_50624_) && !((Boolean)blockState.m_61143_((Property)LecternBlock.f_54467_)).booleanValue()) {
            if (!level.f_46443_) {
                CustomLecternBlock.replaceLectern(level, blockPos, blockState, context.m_43722_());
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    static void clearLectern(Level level, BlockPos pos, BlockState blockState) {
        level.m_46597_(pos, (BlockState)((BlockState)((BlockState)Blocks.f_50624_.m_49966_().m_61124_((Property)f_54467_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54465_, (Comparable)((Direction)blockState.m_61143_((Property)f_54465_)))).m_61124_((Property)f_54466_, (Comparable)((Boolean)blockState.m_61143_((Property)f_54466_))));
    }

    @Deprecated
    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)Items.f_42774_);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        CustomLecternBlockEntity lectern;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CustomLecternBlockEntity && (lectern = (CustomLecternBlockEntity)blockEntity).getItem().m_41619_()) {
            CustomLecternBlock.clearLectern((Level)level, pos, state);
            return;
        }
        super.m_213897_(state, level, pos, random);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CustomLecternBlockEntity) {
            CustomLecternBlockEntity lectern = (CustomLecternBlockEntity)blockEntity;
            CustomLecternBlock.dropItem(level, pos, state, lectern.getItem().m_41777_());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private static void dropItem(Level level, BlockPos pos, BlockState state, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)f_54465_);
        double dx = 0.25 * (double)direction.m_122429_();
        double dz = 0.25 * (double)direction.m_122431_();
        ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5 + dx, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5 + dz, stack);
        entity.m_32060_();
        level.m_7967_((Entity)entity);
    }

    public String m_7705_() {
        return Blocks.f_50624_.m_7705_();
    }

    public CustomLecternBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CustomLecternBlockEntity(pos, state);
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        int n;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CustomLecternBlockEntity) {
            CustomLecternBlockEntity lectern = (CustomLecternBlockEntity)blockEntity;
            n = lectern.getRedstoneSignal();
        } else {
            n = 0;
        }
        return n;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof CustomLecternBlockEntity) {
            CustomLecternBlockEntity lectern = (CustomLecternBlockEntity)blockEntity;
            if (player.m_36341_()) {
                CustomLecternBlock.clearLectern(level, pos, state);
            } else {
                lectern.openMenu(player);
            }
            player.m_36220_(Stats.f_12974_);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : BlockEntityHelpers.createTickerHelper(type, (BlockEntityType)ModRegistry.BlockEntities.LECTERN.get(), serverTicker);
    }
}

