/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import org.jspecify.annotations.Nullable;

public class PocketComputerDataMessage
implements NetworkMessage<ClientNetworkContext> {
    private final UUID clientId;
    private final ComputerState state;
    private final int lightState;
    private final @Nullable TerminalState terminal;

    public PocketComputerDataMessage(PocketServerComputer computer, boolean sendTerminal) {
        this.clientId = computer.getInstanceUUID();
        this.state = computer.getState();
        this.lightState = computer.getBrain().getLight();
        this.terminal = sendTerminal ? computer.getTerminalState() : null;
    }

    public PocketComputerDataMessage(FriendlyByteBuf buf) {
        this.clientId = buf.m_130259_();
        this.state = (ComputerState)buf.m_130066_(ComputerState.class);
        this.lightState = buf.m_130242_();
        this.terminal = (TerminalState)buf.m_236868_(TerminalState::new);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.clientId);
        buf.m_130068_((Enum)this.state);
        buf.m_130130_(this.lightState);
        buf.m_236821_((Object)this.terminal, (b, t) -> t.write((FriendlyByteBuf)b));
    }

    @Override
    public void handle(ClientNetworkContext context) {
        context.handlePocketComputerData(this.clientId, this.state, this.lightState, this.terminal);
    }

    @Override
    public MessageType<PocketComputerDataMessage> type() {
        return NetworkMessages.POCKET_COMPUTER_DATA;
    }
}

