/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralType;
import dan200.computercraft.core.methods.NamedMethod;
import dan200.computercraft.core.methods.PeripheralMethod;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheral;
import dan200.computercraft.shared.peripheral.generic.SaturatedMethod;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GenericPeripheralBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GenericPeripheralBuilder.class);
    private @Nullable String name;
    private final Set<String> additionalTypes = new HashSet<String>(0);
    private final ArrayList<SaturatedMethod> methods = new ArrayList();

    GenericPeripheralBuilder() {
    }

    @Nullable IPeripheral toPeripheral(BlockEntity blockEntity, Direction side) {
        String type;
        if (this.methods.isEmpty()) {
            return null;
        }
        if (this.name == null) {
            ResourceLocation typeId = BlockEntityType.m_58954_((BlockEntityType)blockEntity.m_58903_());
            if (typeId == null) {
                LOG.error("Block entity {} for {} was not registered. Skipping creating a generic peripheral for it.", (Object)blockEntity, (Object)blockEntity.m_58900_().m_60734_());
                return null;
            }
            type = typeId.toString();
        } else {
            type = this.name;
        }
        this.methods.trimToSize();
        return new GenericPeripheral(blockEntity, side, type, this.additionalTypes, this.methods);
    }

    void addMethod(Object target, String name, PeripheralMethod method, @Nullable NamedMethod<PeripheralMethod> info) {
        PeripheralType type;
        this.methods.add(new SaturatedMethod(target, name, method));
        PeripheralType peripheralType = type = info == null ? null : info.genericType();
        if (type != null && type.getPrimaryType() != null) {
            String primaryType = type.getPrimaryType();
            if (this.name == null || this.name.compareTo(primaryType) > 0) {
                this.name = primaryType;
            }
        }
        if (type != null) {
            this.additionalTypes.addAll(type.getAdditionalTypes());
        }
    }
}

