/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;
import com.badlogic.gdx.utils.Null;

public class FloatAction
extends TemporalAction {
    private float start;
    private float end;
    private float value;

    public FloatAction() {
        this.start = 0.0f;
        this.end = 1.0f;
    }

    public FloatAction(float start2, float end2) {
        this.start = start2;
        this.end = end2;
    }

    public FloatAction(float start2, float end2, float duration) {
        super(duration);
        this.start = start2;
        this.end = end2;
    }

    public FloatAction(float start2, float end2, float duration, @Null Interpolation interpolation) {
        super(duration, interpolation);
        this.start = start2;
        this.end = end2;
    }

    @Override
    protected void begin() {
        this.value = this.start;
    }

    @Override
    protected void update(float percent) {
        this.value = percent == 0.0f ? this.start : (percent == 1.0f ? this.end : this.start + (this.end - this.start) * percent);
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float getStart() {
        return this.start;
    }

    public void setStart(float start2) {
        this.start = start2;
    }

    public float getEnd() {
        return this.end;
    }

    public void setEnd(float end2) {
        this.end = end2;
    }
}

