/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.civilization;

import com.unciv.logic.automation.civilization.MotivationToAttackAutomation;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.models.ruleset.nation.PersonalityValue;
import com.unciv.ui.screens.victoryscreen.RankingType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\tJ-\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\fJ-\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\fJ%\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\tJ-\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/unciv/logic/automation/civilization/DeclareWarPlanEvaluator;", "", "()V", "evaluateDeclareWarPlan", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "target", "givenMotivation", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/civilization/Civilization;Ljava/lang/Float;)F", "evaluateJoinOurWarPlan", "civToJoin", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/civilization/Civilization;Ljava/lang/Float;)F", "evaluateJoinWarPlan", "evaluateStartPreparingWarPlan", "evaluateTeamWarPlan", "teamCiv", "core"})
@SourceDebugExtension(value={"SMAP\nDeclareWarPlanEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclareWarPlanEvaluator.kt\ncom/unciv/logic/automation/civilization/DeclareWarPlanEvaluator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class DeclareWarPlanEvaluator {
    @NotNull
    public static final DeclareWarPlanEvaluator INSTANCE = new DeclareWarPlanEvaluator();

    private DeclareWarPlanEvaluator() {
    }

    public final float evaluateTeamWarPlan(@NotNull Civilization civInfo, @NotNull Civilization target, @NotNull Civilization teamCiv, @Nullable Float givenMotivation) {
        float multiplier;
        float motivation;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(teamCiv, "teamCiv");
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(teamCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager teamCivDiplo = diplomacyManager;
        if (civInfo.getPersonality().get(PersonalityValue.DeclareWar) == 0.0f) {
            return -1000.0f;
        }
        if (teamCivDiplo.isRelationshipLevelLT(RelationshipLevel.Neutral)) {
            return -1000.0f;
        }
        Float f = givenMotivation;
        float f2 = motivation = f != null ? f.floatValue() : MotivationToAttackAutomation.INSTANCE.hasAtLeastMotivationToAttack(civInfo, target, 0.0f);
        if (teamCivDiplo.isRelationshipLevelEQ(RelationshipLevel.Neutral)) {
            motivation -= 5.0f;
        }
        if (!teamCiv.getThreatManager().getNeighboringCivilizations().contains(target)) {
            motivation -= 40.0f;
        }
        int civForce = civInfo.getStatForRanking(RankingType.Force);
        int targetForce = target.getStatForRanking(RankingType.Force);
        float teamCivForce = RangesKt.coerceAtLeast((float)teamCiv.getStatForRanking(RankingType.Force) - 0.8f * (float)teamCiv.getThreatManager().getCombinedForceOfWarringCivs(), 100.0f);
        float f3 = motivation < 5.0f ? 1.2f : (motivation < 10.0f ? 1.1f : (multiplier = motivation < 20.0f ? 1.0f : 0.8f));
        if ((float)civForce + teamCivForce < (float)targetForce * multiplier) {
            motivation -= (float)30 * ((float)targetForce * multiplier / (teamCivForce + (float)civForce) - 1.0f);
        } else if ((float)civForce + teamCivForce > (float)(targetForce * 2)) {
            motivation -= (float)20 * (((float)civForce + teamCivForce) / (float)targetForce * (float)2) - 1.0f;
        }
        int civScore = civInfo.getStatForRanking(RankingType.Score);
        int teamCivScore = teamCiv.getStatForRanking(RankingType.Score);
        int targetCivScore = target.getStatForRanking(RankingType.Score);
        if ((float)teamCivScore > (float)civScore * 1.4f && teamCivScore >= targetCivScore) {
            motivation -= (float)20 * ((float)teamCivScore / ((float)civScore * 1.4f) - 1.0f);
        }
        return motivation - 20.0f;
    }

    /*
     * WARNING - void declaration
     */
    public final float evaluateJoinWarPlan(@NotNull Civilization civInfo, @NotNull Civilization target, @NotNull Civilization civToJoin, @Nullable Float givenMotivation) {
        float multiplier;
        int n;
        int n2;
        Object object;
        float motivation;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(civToJoin, "civToJoin");
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(civToJoin);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager thirdCivDiplo = diplomacyManager;
        if (civInfo.getPersonality().get(PersonalityValue.DeclareWar) == 0.0f) {
            return -1000.0f;
        }
        if (thirdCivDiplo.isRelationshipLevelLE(RelationshipLevel.Favorable)) {
            return -1000.0f;
        }
        Float f = givenMotivation;
        float f2 = motivation = f != null ? f.floatValue() : MotivationToAttackAutomation.INSTANCE.hasAtLeastMotivationToAttack(civInfo, target, 0.0f);
        if (thirdCivDiplo.getDiplomaticStatus() != DiplomaticStatus.DefensivePact && thirdCivDiplo.opinionOfOtherCiv() + motivation * (float)2 < 80.0f) {
            motivation -= 80.0f - thirdCivDiplo.opinionOfOtherCiv() + motivation * (float)2;
        }
        if (!civToJoin.getThreatManager().getNeighboringCivilizations().contains(target)) {
            motivation -= 20.0f;
        }
        Iterable iterable = target.getCivsAtWarWith();
        float f3 = 0.8f;
        float f4 = target.getStatForRanking(RankingType.Force);
        int n3 = 0;
        for (Object t : iterable) {
            void it;
            object = (Civilization)t;
            n2 = n3;
            boolean bl = false;
            n = it.getStatForRanking(RankingType.Force);
            n3 = n2 + n;
        }
        n2 = n3;
        float targetForce = f4 - f3 * (float)RangesKt.coerceAtLeast(n2, 100);
        int civForce = civInfo.getStatForRanking(RankingType.Force);
        Iterable iterable2 = civToJoin.getCivsAtWarWith();
        f3 = 0.8f;
        f4 = civToJoin.getStatForRanking(RankingType.Force);
        int n4 = 0;
        object = iterable2.iterator();
        while (object.hasNext()) {
            void it;
            Object e = object.next();
            Civilization civilization = (Civilization)e;
            n2 = n4;
            boolean bl = false;
            n = it.getStatForRanking(RankingType.Force);
            n4 = n2 + n;
        }
        n2 = n4;
        float civToJoinForce = RangesKt.coerceAtLeast(f4 - f3 * (float)n2, 100.0f);
        if (civToJoinForce < targetForce / (float)2) {
            motivation -= (float)10 * RangesKt.coerceIn(targetForce / civToJoinForce, -1000.0f, 1000.0f);
        }
        float f5 = motivation < 10.0f ? 1.4f : (motivation < 15.0f ? 1.3f : (motivation < 20.0f ? 1.2f : (multiplier = motivation < 25.0f ? 1.0f : 0.8f)));
        if (civToJoinForce + (float)civForce < targetForce * multiplier) {
            motivation -= (float)20 * (targetForce * multiplier) / RangesKt.coerceIn(civToJoinForce + (float)civForce, -1000.0f, 1000.0f);
        }
        return motivation - (float)15;
    }

    /*
     * WARNING - void declaration
     */
    public final float evaluateJoinOurWarPlan(@NotNull Civilization civInfo, @NotNull Civilization target, @NotNull Civilization civToJoin, @Nullable Float givenMotivation) {
        int n;
        float motivation;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(civToJoin, "civToJoin");
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(civToJoin);
        Intrinsics.checkNotNull(diplomacyManager);
        if (diplomacyManager.isRelationshipLevelLT(RelationshipLevel.Favorable)) {
            return -1000.0f;
        }
        Float f = givenMotivation;
        float f2 = motivation = f != null ? f.floatValue() : 0.0f;
        if (!civToJoin.getThreatManager().getNeighboringCivilizations().contains(target)) {
            motivation -= 50.0f;
        }
        int targetForce = target.getStatForRanking(RankingType.Force);
        int civForce = civInfo.getStatForRanking(RankingType.Force);
        if (civForce - civInfo.getThreatManager().getCombinedForceOfWarringCivs() > targetForce * 2) {
            return 0.0f;
        }
        Iterable iterable = civToJoin.getCivsAtWarWith();
        float f3 = 0.8f;
        float f4 = civToJoin.getStatForRanking(RankingType.Force);
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            Civilization civilization = (Civilization)t;
            n = n2;
            boolean bl = false;
            int n3 = it.getStatForRanking(RankingType.Force);
            n2 = n + n3;
        }
        n = n2;
        float thirdCivForce = RangesKt.coerceAtLeast(f4 - f3 * (float)n, 100.0f);
        motivation += RangesKt.coerceAtMost((float)20 * (1.0f - thirdCivForce / (float)targetForce), 40.0f);
        return (motivation += (float)20 * RangesKt.coerceIn(1.0f - (float)civForce / (float)targetForce, -40.0f, 40.0f)) - (float)20;
    }

    public final float evaluateDeclareWarPlan(@NotNull Civilization civInfo, @NotNull Civilization target, @Nullable Float givenMotivation) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(target, "target");
        if (civInfo.getPersonality().get(PersonalityValue.DeclareWar) == 0.0f) {
            return -1000.0f;
        }
        Float f = givenMotivation;
        float motivation = f != null ? f.floatValue() : MotivationToAttackAutomation.INSTANCE.hasAtLeastMotivationToAttack(civInfo, target, 0.0f);
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(target);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diploManager = diplomacyManager;
        if (diploManager.hasFlag(DiplomacyFlags.WaryOf) && diploManager.getFlag(DiplomacyFlags.WaryOf) < 0) {
            float turnsToPlan = RangesKt.coerceAtLeast((float)10 - motivation / (float)10, 3.0f);
            float turnsToWait = turnsToPlan + (float)diploManager.getFlag(DiplomacyFlags.WaryOf);
            return motivation - turnsToWait * (float)3;
        }
        return motivation - (float)40;
    }

    public final float evaluateStartPreparingWarPlan(@NotNull Civilization civInfo, @NotNull Civilization target, @Nullable Float givenMotivation) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(target, "target");
        Float f = givenMotivation;
        float motivation = f != null ? f.floatValue() : MotivationToAttackAutomation.INSTANCE.hasAtLeastMotivationToAttack(civInfo, target, 0.0f);
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(target);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diploManager = diplomacyManager;
        if (diploManager.hasFlag(DiplomacyFlags.WaryOf)) {
            return 0.0f;
        }
        return motivation - (float)15;
    }
}

