/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.civilization;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.ThreatLevel;
import com.unciv.logic.automation.civilization.BarbarianAutomation;
import com.unciv.logic.automation.civilization.DiplomacyAutomation;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.automation.civilization.ReligionAutomation;
import com.unciv.logic.automation.civilization.TradeAutomation;
import com.unciv.logic.automation.civilization.UseGoldAutomation;
import com.unciv.logic.automation.unit.EspionageAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.CityStateFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.managers.GreatPersonManager;
import com.unciv.logic.civilization.managers.PolicyManager;
import com.unciv.logic.civilization.managers.ThreatManager;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.MilestoneType;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.PersonalityValue;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.INamed;
import com.unciv.models.stats.Stat;
import com.unciv.ui.screens.victoryscreen.RankingType;
import com.unciv.utils.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J\u0016\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eJ\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0006H\u0002J'\u0010(\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00062\b\b\u0002\u0010*\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b+\u00a8\u0006-"}, d2={"Lcom/unciv/logic/automation/civilization/NextTurnAutomation;", "", "()V", "adoptPolicy", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "automateCities", "automateCityBombardment", "automateCityConquer", "city", "Lcom/unciv/logic/city/City;", "automateCivMoves", "tradeAndChangeState", "", "automateGoldToSciencePercentage", "automateUnits", "bullyCityStates", "chooseGreatPerson", "chooseTechToResearch", "freeUpSpaceResources", "getClosestCities", "Lcom/unciv/logic/automation/civilization/NextTurnAutomation$CityDistance;", "civ1", "civ2", "getMinDistanceBetweenCities", "", "getUnitPriority", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "isAtWar", "issueRequests", "onCitySettledNearBorders", "otherCiv", "onReligionSpreadInOurCity", "protectCityStates", "respondToPopupAlerts", "trainSettler", "tryVoteForDiplomaticVictory", "civ", "valueCityStateAlliance", "cityState", "includeQuests", "valueCityStateAlliance$core", "CityDistance", "core"})
@SourceDebugExtension(value={"SMAP\nNextTurnAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextTurnAutomation.kt\ncom/unciv/logic/automation/civilization/NextTurnAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,663:1\n1774#2,3:664\n1549#2:667\n1620#2,3:668\n1777#2:671\n533#2,4:672\n1747#2,3:676\n538#2:679\n288#2:680\n1747#2,3:681\n289#2:684\n766#2:685\n857#2,2:686\n766#2:688\n857#2,2:689\n1477#2:698\n1502#2,3:699\n1505#2,3:709\n766#2:713\n857#2,2:714\n766#2:716\n857#2,2:717\n288#2,2:719\n288#2,2:721\n766#2:740\n857#2,2:741\n766#2:744\n857#2,2:745\n766#2:747\n857#2,2:748\n766#2:750\n857#2,2:751\n1054#2:753\n1940#2,14:754\n766#2:768\n857#2,2:769\n1747#2,3:773\n766#2:776\n857#2:777\n858#2:780\n1747#2,3:784\n819#2:787\n847#2,2:788\n766#2:790\n857#2:791\n858#2:797\n1963#2,14:798\n2333#2,14:812\n478#3,7:691\n372#3,7:702\n372#3,7:830\n1#4:712\n553#5,3:723\n1839#6,14:726\n603#6:743\n1247#6,2:771\n2159#6,2:778\n1268#6,3:781\n1268#6,3:792\n1247#6,2:795\n988#6:826\n1017#6,3:827\n1020#6,3:837\n*S KotlinDebug\n*F\n+ 1 NextTurnAutomation.kt\ncom/unciv/logic/automation/civilization/NextTurnAutomation\n*L\n217#1:664,3\n219#1:667\n219#1:668,3\n217#1:671\n267#1:672,4\n269#1:676,3\n267#1:679\n278#1:680\n280#1:681,3\n278#1:684\n332#1:685\n332#1:686,2\n337#1:688\n337#1:689,2\n346#1:698\n346#1:699,3\n346#1:709,3\n351#1:713\n351#1:714,2\n363#1:716\n363#1:717,2\n368#1:719,2\n372#1:721,2\n401#1:740\n401#1:741,2\n444#1:744\n444#1:745,2\n448#1:747\n448#1:748,2\n456#1:750\n456#1:751,2\n457#1:753\n466#1:754,14\n501#1:768\n501#1:769,2\n535#1:773,3\n540#1:776\n540#1:777\n540#1:780\n547#1:784,3\n552#1:787\n552#1:788,2\n555#1:790\n555#1:791\n555#1:797\n559#1:798,14\n562#1:812,14\n342#1:691,7\n346#1:702,7\n258#1:830,7\n385#1:723,3\n395#1:726,14\n418#1:743\n534#1:771,2\n542#1:778,2\n545#1:781,3\n557#1:792,3\n558#1:795,2\n258#1:826\n258#1:827,3\n258#1:837,3\n*E\n"})
public final class NextTurnAutomation {
    @NotNull
    public static final NextTurnAutomation INSTANCE = new NextTurnAutomation();

    private NextTurnAutomation() {
    }

    public final void automateCivMoves(@NotNull Civilization civInfo, boolean tradeAndChangeState) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        if (civInfo.isBarbarian()) {
            new BarbarianAutomation(civInfo).automate();
            return;
        }
        if (civInfo.isSpectator()) {
            return;
        }
        this.respondToPopupAlerts(civInfo);
        TradeAutomation.INSTANCE.respondToTradeRequests(civInfo, tradeAndChangeState);
        if (tradeAndChangeState && civInfo.isMajorCiv()) {
            if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)civInfo.getGameInfo().getRuleset().getModOptions(), UniqueType.DiplomaticRelationshipsCannotChange, null, 2, null)) {
                DiplomacyAutomation.INSTANCE.declareWar$core(civInfo);
                DiplomacyAutomation.INSTANCE.offerPeaceTreaty$core(civInfo);
                DiplomacyAutomation.INSTANCE.askForHelp$core(civInfo);
                DiplomacyAutomation.INSTANCE.offerDeclarationOfFriendship$core(civInfo);
            }
            if (civInfo.getGameInfo().isReligionEnabled()) {
                ReligionAutomation.INSTANCE.spendFaithOnReligion(civInfo);
            }
            DiplomacyAutomation.INSTANCE.offerOpenBorders$core(civInfo);
            DiplomacyAutomation.INSTANCE.offerResearchAgreement$core(civInfo);
            DiplomacyAutomation.INSTANCE.offerDefensivePact$core(civInfo);
            TradeAutomation.INSTANCE.exchangeLuxuries(civInfo);
            this.issueRequests(civInfo);
            this.adoptPolicy(civInfo);
            this.freeUpSpaceResources(civInfo);
        } else if (civInfo.isCityState()) {
            civInfo.getCityStateFunctions().getFreeTechForCityState();
            civInfo.getCityStateFunctions().updateDiplomaticRelationshipForCityState();
        }
        this.chooseTechToResearch(civInfo);
        this.automateCityBombardment(civInfo);
        if (tradeAndChangeState) {
            UseGoldAutomation.INSTANCE.useGold(civInfo);
        }
        if (tradeAndChangeState && !civInfo.isCityState()) {
            this.protectCityStates(civInfo);
            this.bullyCityStates(civInfo);
        }
        this.automateUnits(civInfo);
        if (tradeAndChangeState && civInfo.isMajorCiv()) {
            if (civInfo.getGameInfo().isReligionEnabled()) {
                ReligionAutomation.INSTANCE.chooseReligiousBeliefs$core(civInfo);
            }
            if (civInfo.getGameInfo().isEspionageEnabled()) {
                new EspionageAutomation(civInfo).automateSpies();
            }
        }
        this.automateCities(civInfo);
        if (tradeAndChangeState) {
            this.trainSettler(civInfo);
        }
        this.tryVoteForDiplomaticVictory(civInfo);
    }

    public static /* synthetic */ void automateCivMoves$default(NextTurnAutomation nextTurnAutomation, Civilization civilization, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        nextTurnAutomation.automateCivMoves(civilization, bl);
    }

    public final void automateGoldToSciencePercentage(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        int estimatedIncome = (int)civInfo.getStats().getStatsForNextTurn().getGold();
        int projectedGold = civInfo.getGold() + estimatedIncome;
        int pissPoor = civInfo.getTech().getEra().getBaseUnitBuyCost();
        int stinkingRich = civInfo.getTech().getEra().getStartingGold() * 10 + civInfo.getCities().size() * 2 * pissPoor;
        float maxPercent = 0.8f;
        civInfo.getTech().setGoldPercentConvertedToScience(civInfo.getGold() <= 0 ? 0.0f : (projectedGold <= pissPoor ? 0.0f : RangesKt.coerceAtMost((float)(projectedGold - pissPoor) * maxPercent / (float)stinkingRich, maxPercent)));
    }

    private final void respondToPopupAlerts(Civilization civInfo) {
        for (PopupAlert popupAlert : CollectionsKt.toList((Iterable)civInfo.getPopupAlerts())) {
            String[] stringArray;
            DiplomacyManager diploManager;
            Civilization demandingCiv;
            if (popupAlert.getType() == AlertType.DemandToStopSettlingCitiesNear) {
                demandingCiv = civInfo.getGameInfo().getCivilization(popupAlert.getValue());
                Intrinsics.checkNotNull(civInfo.getDiplomacyManager(demandingCiv));
                if (Automation.INSTANCE.threatAssessment(civInfo, demandingCiv).compareTo((Enum)ThreatLevel.High) >= 0) {
                    diploManager.agreeNotToSettleNear();
                } else {
                    diploManager.refuseDemandNotToSettleNear();
                }
            }
            if (popupAlert.getType() == AlertType.DemandToStopSpreadingReligion) {
                demandingCiv = civInfo.getGameInfo().getCivilization(popupAlert.getValue());
                Intrinsics.checkNotNull(civInfo.getDiplomacyManager(demandingCiv));
                if (Automation.INSTANCE.threatAssessment(civInfo, demandingCiv).compareTo((Enum)ThreatLevel.High) >= 0 || diploManager.isRelationshipLevelGT(RelationshipLevel.Ally)) {
                    diploManager.agreeNotToSpreadReligionTo();
                } else {
                    diploManager.refuseNotToSpreadReligionTo();
                }
            }
            if (popupAlert.getType() != AlertType.DeclarationOfFriendship) continue;
            Civilization requestingCiv = civInfo.getGameInfo().getCivilization(popupAlert.getValue());
            Intrinsics.checkNotNull(civInfo.getDiplomacyManager(requestingCiv));
            if (civInfo.getDiplomacyFunctions().canSignDeclarationOfFriendshipWith(requestingCiv) && DiplomacyAutomation.INSTANCE.wantsToSignDeclarationOfFrienship$core(civInfo, requestingCiv)) {
                diploManager.signDeclarationOfFriendship();
                stringArray = new String[]{"OtherIcons/Diplomacy", civInfo.getCivName()};
                requestingCiv.addNotification("We have signed a Declaration of Friendship with [" + civInfo.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray);
                continue;
            }
            diploManager.otherCivDiplomacy().setFlag(DiplomacyFlags.DeclinedDeclarationOfFriendship, 10);
            stringArray = new String[]{"OtherIcons/Diplomacy", civInfo.getCivName()};
            requestingCiv.addNotification('[' + civInfo.getCivName() + "] has denied our Declaration of Friendship!", Notification.NotificationCategory.Diplomacy, stringArray);
        }
        civInfo.getPopupAlerts().clear();
    }

    /*
     * Unable to fully structure code
     */
    public final int valueCityStateAlliance$core(@NotNull Civilization civInfo, @NotNull Civilization cityState, boolean includeQuests) {
        block27: {
            block26: {
                Intrinsics.checkNotNullParameter(civInfo, "civInfo");
                Intrinsics.checkNotNullParameter(cityState, "cityState");
                value = 0;
                civPersonality = civInfo.getPersonality();
                if (cityState.getCityStateFunctions().canProvideStat(Stat.Culture)) {
                    if (civInfo.wantsToFocusOn(Victory.Focus.Culture)) {
                        value += 10;
                    }
                    value += (int)civPersonality.get(PersonalityValue.Culture) - 5;
                }
                if (cityState.getCityStateFunctions().canProvideStat(Stat.Faith)) {
                    if (civInfo.wantsToFocusOn(Victory.Focus.Faith)) {
                        value += 10;
                    }
                    value += (int)civPersonality.get(PersonalityValue.Faith) - 5;
                }
                if (cityState.getCityStateFunctions().canProvideStat(Stat.Production)) {
                    if (civInfo.wantsToFocusOn(Victory.Focus.Production)) {
                        value += 10;
                    }
                    value += (int)civPersonality.get(PersonalityValue.Production) - 5;
                }
                if (cityState.getCityStateFunctions().canProvideStat(Stat.Science)) {
                    if (civInfo.wantsToFocusOn(Victory.Focus.Science)) {
                        value += 10;
                    }
                    value += (int)civPersonality.get(PersonalityValue.Science) - 5;
                }
                if (civInfo.wantsToFocusOn(Victory.Focus.Military)) {
                    if (!cityState.isAlive()) {
                        value -= 5;
                    } else {
                        distance = this.getMinDistanceBetweenCities(civInfo, cityState);
                        if (distance < 20) {
                            value -= (20 - distance) / 4;
                        }
                    }
                }
                if (civInfo.wantsToFocusOn(Victory.Focus.CityStates)) {
                    value += 5;
                }
                if (cityState.getCityStateFunctions().canProvideStat(Stat.Happiness)) {
                    if (civInfo.getHappiness() < 10) {
                        value += 10 - civInfo.getHappiness();
                    }
                    value += (int)civPersonality.get(PersonalityValue.Happiness) - 5;
                }
                if (cityState.getCityStateFunctions().canProvideStat(Stat.Food)) {
                    value += 5;
                    value += (int)civPersonality.get(PersonalityValue.Food) - 5;
                }
                if (!cityState.isAlive() || cityState.getCities().isEmpty() || civInfo.getCities().isEmpty()) {
                    return value;
                }
                if (civInfo.knows(cityState)) {
                    v0 = cityState.getDiplomacyManager(civInfo);
                    Intrinsics.checkNotNull(v0);
                    v1 = (int)v0.getInfluence();
                } else {
                    v1 = 0;
                }
                ourInfluence = v1;
                value += Math.min(10, ourInfluence / 10);
                if (ourInfluence < 30) {
                    value -= 5;
                }
                if (cityState.getAllyCivName() != null && !Intrinsics.areEqual(cityState.getAllyCivName(), civInfo.getCivName())) {
                    v2 = cityState.getAllyCivName();
                    Intrinsics.checkNotNull(v2);
                    v3 = cityState.getDiplomacyManager(v2);
                    Intrinsics.checkNotNull(v3);
                    thirdCivInfluence = (int)v3.getInfluence();
                    value -= (thirdCivInfluence - 30) / 10;
                }
                thirdCivInfluence = cityState.getDetailedCivResources();
                var24_9 = value;
                $i$f$count = false;
                if (!($this$count$iv instanceof Collection) || !((Collection)$this$count$iv).isEmpty()) break block26;
                v4 = 0;
                break block27;
            }
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = (ResourceSupplyList.ResourceSupply)element$iv;
                $i$a$-count-NextTurnAutomation$valueCityStateAlliance$1 = false;
                if (it.getResource().getResourceType() != ResourceType.Luxury) ** GOTO lbl-1000
                $this$map$iv = civInfo.getDetailedCivResources();
                $i$f$map = false;
                var16_18 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var21_23 = (ResourceSupplyList.ResourceSupply)item$iv$iv;
                    var22_24 = destination$iv$iv;
                    $i$a$-map-NextTurnAutomation$valueCityStateAlliance$1$1 = false;
                    var22_24.add(supply.getResource());
                }
                if (!((List)destination$iv$iv).contains(it.getResource())) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                if (!v5 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v4 = count$iv;
        }
        var25_26 = v4;
        value = var24_9 + var25_26;
        if (includeQuests) {
            value += (int)(cityState.getQuestManager().getInvestmentMultiplier(civInfo.getCivName()) * (float)10) - 10;
        }
        return value;
    }

    public static /* synthetic */ int valueCityStateAlliance$core$default(NextTurnAutomation nextTurnAutomation, Civilization civilization, Civilization civilization2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return nextTurnAutomation.valueCityStateAlliance$core(civilization, civilization2, bl);
    }

    private final void protectCityStates(Civilization civInfo) {
        Iterator<Civilization> iterator2 = SequencesKt.filter(civInfo.getKnownCivs(), protectCityStates.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            Civilization state = iterator2.next();
            if (!state.getCityStateFunctions().otherCivCanPledgeProtection(civInfo)) continue;
            state.getCityStateFunctions().addProtectorCiv(civInfo);
        }
    }

    private final void bullyCityStates(Civilization civInfo) {
        for (Civilization state : SequencesKt.toList(SequencesKt.filter(civInfo.getKnownCivs(), bullyCityStates.1.INSTANCE))) {
            DiplomacyManager diplomacyManager;
            Intrinsics.checkNotNull(state.getDiplomacyManager(civInfo.getCivName()));
            if (!diplomacyManager.isRelationshipLevelLT(RelationshipLevel.Friend) || diplomacyManager.getDiplomaticStatus() != DiplomaticStatus.Peace || NextTurnAutomation.valueCityStateAlliance$core$default(this, civInfo, state, false, 4, null) > 0 || CityStateFunctions.getTributeWillingness$default(state.getCityStateFunctions(), civInfo, false, 2, null) < 0) continue;
            if (state.getCityStateFunctions().getTributeWillingness(civInfo, true) > 0) {
                state.getCityStateFunctions().tributeWorker(civInfo);
                continue;
            }
            state.getCityStateFunctions().tributeGold(civInfo);
        }
    }

    private final void chooseTechToResearch(Civilization civInfo) {
        Technology it;
        boolean $i$f$any;
        Iterable $this$any$iv;
        List<Technology> it2;
        List<Technology> element$iv;
        List<List<Technology>> costs;
        StateForConditionals stateForConditionals = civInfo.getState();
        while (civInfo.getTech().getFreeTechs() > 0) {
            List<Technology> list2;
            List<Technology> list3;
            block17: {
                costs = NextTurnAutomation.chooseTechToResearch$getGroupedResearchableTechs(civInfo);
                if (costs.isEmpty()) {
                    return;
                }
                List<List<Technology>> $this$lastOrNull$iv = costs;
                boolean $i$f$lastOrNull = false;
                ListIterator<List<Technology>> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    boolean bl;
                    block16: {
                        it2 = element$iv = iterator$iv.previous();
                        boolean bl2 = false;
                        $this$any$iv = it2;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it = (Technology)element$iv2;
                                boolean bl3 = false;
                                if (!(it.getWeightForAiDecision(stateForConditionals) > 0.0f)) continue;
                                bl = true;
                                break block16;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    list3 = element$iv;
                    break block17;
                }
                list3 = null;
            }
            if ((list2 = (List<Technology>)list3) == null) {
                list2 = CollectionsKt.last(costs);
            }
            List<Technology> mostExpensiveTechs = list2;
            Technology chosenTech2 = (Technology)CollectionExtensionsKt.randomWeighted$default(mostExpensiveTechs, null, new Function1<Technology, Float>(stateForConditionals){
                final /* synthetic */ StateForConditionals $stateForConditionals;
                {
                    this.$stateForConditionals = $stateForConditionals;
                    super(1);
                }

                @NotNull
                public final Float invoke(@NotNull Technology it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Float.valueOf(it.getWeightForAiDecision(this.$stateForConditionals));
                }
            }, 1, null);
            civInfo.getTech().getFreeTechnology(chosenTech2.getName());
        }
        if (civInfo.getTech().getTechsToResearch().isEmpty()) {
            Technology technology2;
            List<Technology> cheapestTechs;
            List<Technology> list4;
            List<Technology> list5;
            block19: {
                costs = NextTurnAutomation.chooseTechToResearch$getGroupedResearchableTechs(civInfo);
                if (costs.isEmpty()) {
                    return;
                }
                Iterable $this$firstOrNull$iv = costs;
                boolean $i$f$firstOrNull = false;
                Iterator iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    boolean bl;
                    block18: {
                        it2 = element$iv = iterator2.next();
                        boolean bl4 = false;
                        $this$any$iv = it2;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it = (Technology)element$iv2;
                                boolean bl5 = false;
                                if (!(it.getWeightForAiDecision(stateForConditionals) > 0.0f)) continue;
                                bl = true;
                                break block18;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    list5 = element$iv;
                    break block19;
                }
                list5 = null;
            }
            if ((list4 = (List<Technology>)list5) == null) {
                list4 = CollectionsKt.first(costs);
            }
            if ((cheapestTechs = list4).size() == 1 || costs.size() == 1) {
                technology2 = (Technology)CollectionExtensionsKt.randomWeighted$default(cheapestTechs, null, new Function1<Technology, Float>(stateForConditionals){
                    final /* synthetic */ StateForConditionals $stateForConditionals;
                    {
                        this.$stateForConditionals = $stateForConditionals;
                        super(1);
                    }

                    @NotNull
                    public final Float invoke(@NotNull Technology it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return Float.valueOf(it.getWeightForAiDecision(this.$stateForConditionals));
                    }
                }, 1, null);
            } else {
                List<Technology> techsAdvanced = costs.get(1);
                technology2 = (Technology)CollectionExtensionsKt.randomWeighted$default(CollectionsKt.plus((Collection)cheapestTechs, (Iterable)techsAdvanced), null, new Function1<Technology, Float>(stateForConditionals){
                    final /* synthetic */ StateForConditionals $stateForConditionals;
                    {
                        this.$stateForConditionals = $stateForConditionals;
                        super(1);
                    }

                    @NotNull
                    public final Float invoke(@NotNull Technology it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return Float.valueOf(it.getWeightForAiDecision(this.$stateForConditionals));
                    }
                }, 1, null);
            }
            Technology techToResearch2 = technology2;
            civInfo.getTech().getTechsToResearch().add(techToResearch2.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void adoptPolicy(Civilization civInfo) {
        while (civInfo.getPolicies().canAdoptPolicy()) {
            Policy policy2;
            Object object;
            Iterator $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            Set set2;
            Iterable $this$filterTo$iv$iv;
            boolean $i$f$filterTo;
            Collection destination$iv$iv;
            boolean $i$f$filter;
            Iterable $this$filter$iv;
            Set<PolicyBranch> incompleteBranches = civInfo.getPolicies().getIncompleteBranches();
            Set<PolicyBranch> adoptableBranches = civInfo.getPolicies().getAdoptableBranches();
            if (incompleteBranches.isEmpty() && adoptableBranches.isEmpty()) {
                return;
            }
            Map<PolicyBranch, Integer> priorityMap = civInfo.getPolicies().getPriorityMap();
            Integer maxIncompletePriority = null;
            maxIncompletePriority = civInfo.getPolicies().getMaxPriority(incompleteBranches);
            Integer maxAdoptablePriority = null;
            maxAdoptablePriority = civInfo.getPolicies().getMaxPriority(adoptableBranches);
            if (maxIncompletePriority == null) {
                Integer n = maxAdoptablePriority;
                Intrinsics.checkNotNull(n);
                maxIncompletePriority = ((Number)n).intValue() - 1;
            }
            if (maxAdoptablePriority == null) {
                maxAdoptablePriority = ((Number)maxIncompletePriority).intValue() - 1;
            }
            if (((Number)maxAdoptablePriority).intValue() <= ((Number)maxIncompletePriority).intValue()) {
                $this$filter$iv = incompleteBranches;
                $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PolicyBranch it = (PolicyBranch)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(priorityMap.get(it), maxIncompletePriority)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set2 = CollectionsKt.toSet((List)destination$iv$iv);
            } else {
                $this$filter$iv = adoptableBranches;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PolicyBranch it = (PolicyBranch)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(priorityMap.get(it), maxAdoptablePriority)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set2 = CollectionsKt.toSet((List)destination$iv$iv);
            }
            Set candidates2 = set2;
            Map<PolicyBranch, Integer> $this$filterKeys$iv = civInfo.getPolicies().getBranchCompletionMap();
            boolean $i$f$filterKeys22 = false;
            LinkedHashMap<PolicyBranch, Integer> result$iv = new LinkedHashMap<PolicyBranch, Integer>();
            for (Map.Entry<PolicyBranch, Integer> entry$iv : $this$filterKeys$iv.entrySet()) {
                PolicyBranch key = entry$iv.getKey();
                boolean bl = false;
                if (!candidates2.contains(key)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map candidateCompletionMap = result$iv;
            Iterable $i$f$filterKeys22 = candidateCompletionMap.entrySet();
            boolean $i$f$groupBy22 = false;
            Iterator<Map.Entry<PolicyBranch, Integer>> $i$f$filterTo2 = $this$groupBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator bl = $this$groupByTo$iv$iv.iterator();
            while (bl.hasNext()) {
                Object object2;
                Object element$iv$iv = bl.next();
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                Integer key$iv$iv = ((PolicyBranch)it.getKey()).getPolicies().size() - ((Number)it.getValue()).intValue();
                Map<Integer, List> $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$groupBy22 = destination$iv$iv2.entrySet();
            $this$groupByTo$iv$iv = $i$f$groupBy22.iterator();
            if (!$this$groupByTo$iv$iv.hasNext()) {
                object = null;
            } else {
                destination$iv$iv2 = $this$groupByTo$iv$iv.next();
                if (!$this$groupByTo$iv$iv.hasNext()) {
                    object = destination$iv$iv2;
                } else {
                    Map.Entry it22 = (Map.Entry)destination$iv$iv2;
                    boolean bl42 = false;
                    int it22 = ((Number)it22.getKey()).intValue();
                    do {
                        Object bl42 = $this$groupByTo$iv$iv.next();
                        Map.Entry it = (Map.Entry)bl42;
                        boolean $i$a$-minByOrNull-NextTurnAutomation$adoptPolicy$targetBranch$3 = false;
                        int n = ((Number)it.getKey()).intValue();
                        if (it22 <= n) continue;
                        destination$iv$iv2 = bl42;
                        it22 = n;
                    } while ($this$groupByTo$iv$iv.hasNext());
                    object = destination$iv$iv2;
                }
            }
            Map.Entry entry = (Map.Entry)object;
            Intrinsics.checkNotNull(entry);
            PolicyBranch targetBranch = (PolicyBranch)((Map.Entry)CollectionsKt.random((Collection)entry.getValue(), Random.Default)).getKey();
            if (PolicyManager.isAdoptable$default(civInfo.getPolicies(), targetBranch, false, 2, null)) {
                policy2 = targetBranch;
            } else {
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = targetBranch.getPolicies();
                boolean $i$f$filter2 = false;
                destination$iv$iv2 = $this$filter$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    Policy it = (Policy)element$iv$iv;
                    boolean bl5 = false;
                    if (!PolicyManager.isAdoptable$default(civInfo.getPolicies(), it, false, 2, null)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                policy2 = (Policy)CollectionExtensionsKt.randomWeighted$default((List)destination$iv$iv3, null, new Function1<Policy, Float>(civInfo){
                    final /* synthetic */ Civilization $civInfo;
                    {
                        this.$civInfo = $civInfo;
                        super(1);
                    }

                    @NotNull
                    public final Float invoke(@NotNull Policy it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return Float.valueOf(it.getWeightForAiDecision(this.$civInfo.getState()));
                    }
                }, 1, null);
            }
            Policy policyToAdopt2 = policy2;
            PolicyManager.adopt$default(civInfo.getPolicies(), policyToAdopt2, false, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void chooseGreatPerson(@NotNull Civilization civInfo) {
        Object v3;
        UnitManager unitManager;
        BaseUnit baseUnit;
        BaseUnit greatPerson;
        Object object;
        boolean mayanGreatPerson;
        block10: {
            Object v2;
            INamed it;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            block9: {
                Collection greatPeople;
                Collection collection;
                Intrinsics.checkNotNullParameter(civInfo, "civInfo");
                if (civInfo.getGreatPeople().getFreeGreatPeople() == 0) {
                    return;
                }
                boolean bl = mayanGreatPerson = civInfo.getGreatPeople().getMayaLimitedFreeGP() > 0;
                if (mayanGreatPerson) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = civInfo.getGreatPeople().getGreatPeople();
                    boolean $i$f$filter = false;
                    object = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        BaseUnit it2 = (BaseUnit)element$iv$iv;
                        boolean bl2 = false;
                        if (!civInfo.getGreatPeople().getLongCountGPPool().contains(it2.getName())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    collection = (List)destination$iv$iv;
                } else {
                    collection = greatPeople = (Collection)civInfo.getGreatPeople().getGreatPeople();
                }
                if (greatPeople.isEmpty()) {
                    return;
                }
                greatPerson = (BaseUnit)CollectionsKt.random(greatPeople, Random.Default);
                $this$firstOrNull$iv = greatPeople;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (BaseUnit)element$iv;
                    boolean bl3 = false;
                    if (!((RulesetObject)it).getUniques().contains("Great Person - [Science]")) continue;
                    v2 = element$iv;
                    break block9;
                }
                v2 = null;
            }
            BaseUnit scienceGP = v2;
            if (scienceGP != null) {
                greatPerson = scienceGP;
            }
            $this$firstOrNull$iv = civInfo.getCities();
            baseUnit = greatPerson;
            unitManager = civInfo.getUnits();
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (City)element$iv;
                boolean bl = false;
                if (!((City)it).isCapital()) continue;
                v3 = element$iv;
                break block10;
            }
            v3 = null;
        }
        Object var15_20 = v3;
        unitManager.addUnit(baseUnit, (City)var15_20);
        object = civInfo.getGreatPeople();
        int n = ((GreatPersonManager)object).getFreeGreatPeople();
        ((GreatPersonManager)object).setFreeGreatPeople(n + -1);
        if (mayanGreatPerson) {
            civInfo.getGreatPeople().getLongCountGPPool().remove(greatPerson.getName());
            object = civInfo.getGreatPeople();
            n = ((GreatPersonManager)object).getMayaLimitedFreeGP();
            ((GreatPersonManager)object).setMayaLimitedFreeGP(n + -1);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void freeUpSpaceResources(Civilization civInfo) {
        block15: {
            $this$none$iv = civInfo.getGameInfo().getRuleset().getVictories();
            $i$f$none = false;
            if ($this$none$iv.isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$none$iv.entrySet()) {
                    it = element$iv;
                    $i$a$-none-NextTurnAutomation$freeUpSpaceResources$1 = false;
                    v1 = civInfo.getVictoryManager().getNextMilestone((Victory)it.getValue());
                    if (!((v1 != null ? v1.getType() : null) == MilestoneType.AddedSSPartsInCapital)) continue;
                    v0 = false;
                    break block15;
                }
                v0 = true;
            }
        }
        if (v0) {
            return;
        }
        block1: for (String resource : civInfo.getGameInfo().getSpaceResources()) {
            Intrinsics.checkNotNull(resource);
            if (civInfo.getResourceAmount(resource) >= Automation.INSTANCE.getReservedSpaceResourceAmount(civInfo)) continue;
            element$iv = SequencesKt.filter(civInfo.getUnits().getCivUnits(), (Function1)new Function1<MapUnit, Boolean>(resource){
                final /* synthetic */ String $resource;
                {
                    this.$resource = $resource;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull MapUnit it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    String string = this.$resource;
                    Intrinsics.checkNotNullExpressionValue(string, "$resource");
                    return it.requiresResource(string);
                }
            });
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = minElem$iv;
                } else {
                    it = (MapUnit)minElem$iv;
                    $i$a$-minByOrNull-NextTurnAutomation$freeUpSpaceResources$unitToDisband$2 = false;
                    minValue$iv = it.getForceEvaluation();
                    do {
                        e$iv /* !! */  = iterator$iv.next();
                        it = (MapUnit)e$iv /* !! */ ;
                        $i$a$-minByOrNull-NextTurnAutomation$freeUpSpaceResources$unitToDisband$2 = false;
                        v$iv = it.getForceEvaluation();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv /* !! */ ;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = minElem$iv;
                }
            }
            v3 = unitToDisband = (MapUnit)v2;
            if (v3 != null) {
                v3.disband();
            }
            for (City city : civInfo.getCities()) {
                if (city.getHasSoldBuildingThisTurn()) continue;
                v4 = civInfo.getGameInfo().getRuleset().getBuildings().values();
                Intrinsics.checkNotNullExpressionValue(v4, "<get-values>(...)");
                $this$filter$iv = v4;
                $i$f$filter = false;
                e$iv /* !! */  = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Building)element$iv$iv;
                    $i$a$-filter-NextTurnAutomation$freeUpSpaceResources$buildingToSell$1 = false;
                    if (!city.getCityConstructions().isBuilt(it.getName()) || !it.requiredResources(city.getState()).contains(resource) || !it.isSellable()) ** GOTO lbl-1000
                    v5 = civInfo.getCivConstructions();
                    Intrinsics.checkNotNull(it);
                    if (!v5.hasFreeBuilding(city, it)) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    if (!v6) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                buildingToSell = (Building)CollectionsKt.randomOrNull((List)destination$iv$iv, Random.Default);
                if (buildingToSell == null) continue;
                city.sellBuilding(buildingToSell);
                continue block1;
            }
        }
    }

    private final void automateUnits(Civilization civInfo) {
        boolean isAtWar = civInfo.isAtWar();
        Sequence<MapUnit> $this$sortedBy$iv = civInfo.getUnits().getCivUnits();
        boolean $i$f$sortedBy = false;
        Sequence<MapUnit> sortedUnits2 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(isAtWar){
            final /* synthetic */ boolean $isAtWar$inlined;
            {
                this.$isAtWar$inlined = bl;
            }

            public final int compare(T a, T b) {
                MapUnit unit = (MapUnit)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(NextTurnAutomation.INSTANCE.getUnitPriority(unit, this.$isAtWar$inlined));
                unit = (MapUnit)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, NextTurnAutomation.INSTANCE.getUnitPriority(unit, this.$isAtWar$inlined));
            }
        });
        List<City> citiesRequiringManualPlacement2 = SequencesKt.toList(SequencesKt.filter(SequencesKt.flatMapIterable(SequencesKt.filter(civInfo.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(civInfo){
            final /* synthetic */ Civilization $civInfo;
            {
                this.$civInfo = $civInfo;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isAtWarWith(this.$civInfo);
            }
        }), automateUnits.citiesRequiringManualPlacement.2.INSTANCE), (Function1)new Function1<City, Boolean>(civInfo){
            final /* synthetic */ Civilization $civInfo;
            {
                this.$civInfo = $civInfo;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull City it) {
                void $this$count$iv;
                Intrinsics.checkNotNullParameter(it, "it");
                Sequence<Tile> sequence = it.getCenterTile().getTilesInDistance(4);
                Civilization civilization = this.$civInfo;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (T element$iv : $this$count$iv) {
                    Tile it2 = (Tile)element$iv;
                    boolean bl = false;
                    MapUnit mapUnit = it2.getMilitaryUnit();
                    if (!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, civilization) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                return count$iv > 4;
            }
        }));
        for (City city2 : citiesRequiringManualPlacement2) {
            this.automateCityConquer(civInfo, city2);
        }
        Iterator<IsPartOfGameInfoSerialization> iterator2 = sortedUnits2.iterator();
        while (iterator2.hasNext()) {
            MapUnit unit = (MapUnit)iterator2.next();
            UnitAutomation.INSTANCE.automateUnitMoves(unit);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void automateCityConquer(@NotNull Civilization civInfo, @NotNull City city2) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        boolean bl;
        MapUnit it;
        Iterable $this$filterTo$iv$iv22;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(city2, "city");
        Object $this$filter$iv = NextTurnAutomation.automateCityConquer$ourUnitsInRange(city2, civInfo, 7);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv22) {
            it = (MapUnit)element$iv$iv;
            bl = false;
            if (!it.getBaseUnit().isAirUnit()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (MapUnit unit : (List)destination$iv$iv) {
            UnitAutomation.INSTANCE.automateUnitMoves(unit);
        }
        $this$filter$iv = NextTurnAutomation.automateCityConquer$ourUnitsInRange(city2, civInfo, 4);
        $i$f$filter = false;
        $this$filterTo$iv$iv22 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (MapUnit)element$iv$iv;
            bl = false;
            if (!it.getBaseUnit().isProbablySiegeUnit()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List seigeUnits = (List)destination$iv$iv;
        for (MapUnit unit : seigeUnits) {
            if (MapUnit.hasUnique$default(unit, UniqueType.MustSetUp, null, false, 6, null) && !unit.isSetUpForSiege()) continue;
            NextTurnAutomation.automateCityConquer$attackIfPossible(unit, city2.getCenterTile());
        }
        Iterable $this$filter$iv2 = NextTurnAutomation.automateCityConquer$ourUnitsInRange(city2, civInfo, 5);
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MapUnit it2 = (MapUnit)element$iv$iv;
            boolean bl2 = false;
            if (!it2.getBaseUnit().isMelee()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List meleeUnits = (List)destination$iv$iv2;
        Iterable $this$sortedByDescending$iv = meleeUnits;
        boolean $i$f$sortedByDescending = false;
        for (MapUnit unit : CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                MapUnit it = (MapUnit)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getBaseUnit().getForceEvaluation());
                it = (MapUnit)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getBaseUnit().getForceEvaluation());
            }
        })) {
            Object t;
            if (city2.getHealth() < city2.getMaxHealth$core() / 5) {
                NextTurnAutomation.automateCityConquer$attackIfPossible(unit, city2.getCenterTile());
            }
            List<Tile> tilesToTarget = SequencesKt.toList(city2.getCenterTile().getTilesInDistance(4));
            ArrayList attackableEnemies = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null), tilesToTarget, false, 8, null);
            if (attackableEnemies.isEmpty()) continue;
            Iterable $this$maxBy$iv = attackableEnemies;
            boolean $i$f$maxByOrThrow = false;
            Iterator iterator$iv = $this$maxBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = maxElem$iv;
            } else {
                AttackableTile it3 = (AttackableTile)maxElem$iv;
                boolean bl3 = false;
                ICombatant iCombatant = new MapUnitCombatant(unit);
                ICombatant iCombatant2 = it3.getCombatant();
                Intrinsics.checkNotNull(iCombatant2);
                int maxValue$iv = BattleDamage.INSTANCE.calculateDamageToDefender(iCombatant, iCombatant2, it3.getTileToAttackFrom(), 0.5f);
                do {
                    Object e$iv = iterator$iv.next();
                    AttackableTile it4 = (AttackableTile)e$iv;
                    boolean bl4 = false;
                    ICombatant iCombatant3 = new MapUnitCombatant(unit);
                    ICombatant iCombatant4 = it4.getCombatant();
                    Intrinsics.checkNotNull(iCombatant4);
                    int v$iv = BattleDamage.INSTANCE.calculateDamageToDefender(iCombatant3, iCombatant4, it4.getTileToAttackFrom(), 0.5f);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = maxElem$iv;
            }
            AttackableTile enemyWeWillDamageMost = (AttackableTile)t;
            Battle.INSTANCE.moveAndAttack(new MapUnitCombatant(unit), enemyWeWillDamageMost);
        }
    }

    public final int getUnitPriority(@NotNull MapUnit unit, boolean isAtWar) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (unit.isCivilian() && !unit.isGreatPersonOfType("War")) {
            return 1;
        }
        if (unit.getBaseUnit().isAirUnit()) {
            return unit.canIntercept() ? 2 : (unit.isNuclearWeapon() ? 3 : (!MapUnit.hasUnique$default(unit, UniqueType.SelfDestructs, null, false, 6, null) ? 4 : 5));
        }
        int distance = !isAtWar ? 0 : ThreatManager.getDistanceToClosestEnemyUnit$default(unit.getCiv().getThreatManager(), unit.getTile(), 6, false, 4, null);
        return distance + unit.getHealth() / 10 + (unit.getBaseUnit().isRanged() ? 10 : (unit.getBaseUnit().isMelee() ? 30 : (unit.isGreatPersonOfType("War") ? 100 : 1)));
    }

    public final void automateCityBombardment(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        for (City city2 : civInfo.getCities()) {
            UnitAutomation.INSTANCE.tryBombardEnemy(city2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void automateCities(@NotNull Civilization civInfo) {
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        int ownMilitaryStrength = civInfo.getStatForRanking(RankingType.Force);
        Iterable iterable = civInfo.getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it, civInfo) && !it.isBarbarian() && civInfo.isAtWarWith(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        int n = 0;
        for (Object t : $this$filter$iv) {
            void it;
            Civilization $i$f$filterTo2 = (Civilization)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getStatForRanking(RankingType.Force);
            n = n2 + n3;
        }
        int sumOfEnemiesMilitaryStrength = n;
        boolean civHasSignificantlyWeakerMilitaryThanEnemies = (float)ownMilitaryStrength < (float)sumOfEnemiesMilitaryStrength * 0.66f;
        for (City city2 : civInfo.getCities()) {
            if (city2.isPuppet() && city2.getPopulation().getPopulation() > 9 && !city2.isInResistance() && !Civilization.hasUnique$default(civInfo, UniqueType.MayNotAnnexCities, null, 2, null)) {
                city2.annexCity();
            }
            city2.reassignAllPopulation();
            if (city2.getHealth() < city2.getMaxHealth$core() || civHasSignificantlyWeakerMilitaryThanEnemies) {
                Automation.INSTANCE.tryTrainMilitaryUnit(city2);
                if (!((Collection)city2.getCityConstructions().getConstructionQueue()).isEmpty()) continue;
            }
            city2.getCityConstructions().chooseNextConstruction();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void trainSettler(Civilization civInfo) {
        block42: {
            block40: {
                block39: {
                    personality = civInfo.getPersonality();
                    if (civInfo.isCityState()) {
                        return;
                    }
                    if (civInfo.isOneCityChallenger()) {
                        return;
                    }
                    if (civInfo.isAtWar()) {
                        return;
                    }
                    if (CollectionsKt.none((Iterable)civInfo.getCities())) {
                        return;
                    }
                    if (civInfo.getHappiness() <= civInfo.getCities().size()) {
                        return;
                    }
                    $this$any$iv = civInfo.getUnits().getCivUnits();
                    $i$f$any = false;
                    var5_7 = $this$any$iv.iterator();
                    while (var5_7.hasNext()) {
                        element$iv = var5_7.next();
                        it = element$iv;
                        $i$a$-any-NextTurnAutomation$trainSettler$1 = false;
                        if (!MapUnit.hasUnique$default((MapUnit)it, UniqueType.FoundCity, StateForConditionals.Companion.getIgnoreConditionals(), false, 4, null)) continue;
                        v0 = true;
                        break block39;
                    }
                    v0 = false;
                }
                if (v0) {
                    return;
                }
                $this$any$iv = civInfo.getCities();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    var5_7 = $this$any$iv.iterator();
                    while (var5_7.hasNext()) {
                        element$iv = var5_7.next();
                        it = (City)element$iv;
                        $i$a$-any-NextTurnAutomation$trainSettler$2 = false;
                        currentConstruction = it.getCityConstructions().getCurrentConstruction();
                        if (!(currentConstruction instanceof BaseUnit != false && ((BaseUnit)currentConstruction).isCityFounder() != false)) continue;
                        v1 = true;
                        break block40;
                    }
                    v1 = false;
                }
            }
            if (v1) {
                return;
            }
            v2 = civInfo.getGameInfo().getRuleset().getUnits().values();
            Intrinsics.checkNotNullExpressionValue(v2, "<get-values>(...)");
            $i$f$any = v2;
            $i$f$filter = false;
            element$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                block41: {
                    it = (BaseUnit)element$iv$iv;
                    $i$a$-filter-NextTurnAutomation$trainSettler$settlerUnits$1 = false;
                    if (!it.isCityFounder() || !it.isBuildable(civInfo)) ** GOTO lbl-1000
                    var13_37 = personality.getMatchingUniques(UniqueType.WillNotBuild, civInfo.getState());
                    $i$f$none = false;
                    for (T element$iv : $this$none$iv) {
                        unique = (Unique)element$iv;
                        $i$a$-none-NextTurnAutomation$trainSettler$settlerUnits$1$1 = false;
                        Intrinsics.checkNotNull(it);
                        if (!BaseUnit.matchesFilter$default(it, unique.getParams().get(0), civInfo.getState(), false, 4, null)) continue;
                        v3 = false;
                        break block41;
                    }
                    v3 = true;
                }
                if (v3) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            settlerUnits = (List)destination$iv$iv;
            if (settlerUnits.isEmpty()) {
                return;
            }
            $this$count$iv = civInfo.getUnits().getCivUnits();
            $i$f$count = false;
            count$iv = 0;
            destination$iv$iv = $this$count$iv.iterator();
            while (destination$iv$iv.hasNext()) {
                element$iv = destination$iv$iv.next();
                it = (MapUnit)element$iv;
                $i$a$-count-NextTurnAutomation$trainSettler$3 = false;
                if (!it.isMilitary() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            if (count$iv < civInfo.getCities().size()) {
                return;
            }
            v5 = civInfo.getGameInfo().getRuleset().getUnits().values();
            Intrinsics.checkNotNullExpressionValue(v5, "<get-values>(...)");
            $this$any$iv = v5;
            $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                v6 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (BaseUnit)element$iv;
                    $i$a$-any-NextTurnAutomation$trainSettler$workersBuildableForThisCiv$1 = false;
                    Intrinsics.checkNotNull(it);
                    v7 = IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.BuildImprovements, null, 2, null) && it.isBuildable(civInfo);
                    if (!v7) continue;
                    v6 = true;
                    break block42;
                }
                v6 = false;
            }
        }
        workersBuildableForThisCiv = v6;
        $this$filterNot$iv = civInfo.getCities();
        $i$f$filterNot = false;
        it = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (City)element$iv$iv;
            $i$a$-filterNot-NextTurnAutomation$trainSettler$bestCity$1 = false;
            if (it.isPuppet()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block43: {
                city = (City)element$iv$iv;
                $i$a$-filter-NextTurnAutomation$trainSettler$bestCity$2 = false;
                if (!workersBuildableForThisCiv) ** GOTO lbl-1000
                $this$count$iv = city.getCenterTile().getTilesInDistance(civInfo.getModConstants().getCityWorkRange() - 1);
                $i$f$count = false;
                count$iv = 0;
                var19_54 = $this$count$iv.iterator();
                while (var19_54.hasNext()) {
                    it = element$iv = var19_54.next();
                    $i$a$-count-NextTurnAutomation$trainSettler$bestCity$2$1 = false;
                    if (!(it.getImprovement() != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                if (count$iv > true) ** GOTO lbl-1000
                $this$any$iv = city.getCenterTile().getTilesInDistance(civInfo.getModConstants().getCityWorkRange());
                $i$f$any = false;
                var18_53 = $this$any$iv.iterator();
                while (var18_53.hasNext()) {
                    it = element$iv = var18_53.next();
                    $i$a$-any-NextTurnAutomation$trainSettler$bestCity$2$2 = false;
                    v8 = it.getCivilianUnit();
                    v9 = v8 != null ? MapUnit.hasUnique$default(v8, UniqueType.BuildImprovements, null, false, 6, null) : false;
                    if (!v9) continue;
                    v10 = true;
                    break block43;
                }
                v10 = false;
            }
            if (v10) lbl-1000:
            // 3 sources

            {
                v11 = true;
            } else {
                v11 = false;
            }
            if (!v11) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$maxByOrNull = false;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v12 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v12 = maxElem$iv;
            } else {
                it = (City)maxElem$iv;
                $i$a$-maxByOrNull-NextTurnAutomation$trainSettler$bestCity$3 = false;
                maxValue$iv = it.getCityStats().getCurrentCityStats().getProduction();
                do {
                    e$iv = iterator$iv.next();
                    it = (City)e$iv;
                    $i$a$-maxByOrNull-NextTurnAutomation$trainSettler$bestCity$3 = false;
                    v$iv = it.getCityStats().getCurrentCityStats().getProduction();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v12 = maxElem$iv;
            }
        }
        v13 = v12;
        if (v13 == null) {
            return;
        }
        bestCity = v13;
        if (SequencesKt.count(bestCity.getCityConstructions().getBuiltBuildings()) > 1) {
            $i$f$any = settlerUnits;
            var23_59 = bestCity.getCityConstructions();
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v14 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v14 = minElem$iv;
                } else {
                    it = (BaseUnit)minElem$iv;
                    $i$a$-minByOrNull-NextTurnAutomation$trainSettler$4 = false;
                    minValue$iv = it.getCost();
                    do {
                        e$iv = iterator$iv.next();
                        it = (BaseUnit)e$iv;
                        $i$a$-minByOrNull-NextTurnAutomation$trainSettler$4 = false;
                        v$iv = it.getCost();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v14 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v14);
            var23_59.setCurrentConstructionFromQueue(((BaseUnit)v14).getName());
        }
    }

    private final void tryVoteForDiplomaticVictory(Civilization civ) {
        Object object;
        if (!civ.mayVoteForDiplomaticVictory()) {
            return;
        }
        if (civ.isMajorCiv()) {
            Float highestOpinion;
            Float f;
            Sequence<Civilization> knownMajorCivs2 = SequencesKt.filter(civ.getKnownCivs(), tryVoteForDiplomaticVictory.chosenCiv.knownMajorCivs.1.INSTANCE);
            Iterator<Civilization> iterator2 = knownMajorCivs2.iterator();
            if (!iterator2.hasNext()) {
                f = null;
            } else {
                Civilization it = iterator2.next();
                boolean bl = false;
                DiplomacyManager diplomacyManager = civ.getDiplomacyManager(it);
                Intrinsics.checkNotNull(diplomacyManager);
                float f2 = diplomacyManager.opinionOfOtherCiv();
                while (iterator2.hasNext()) {
                    Civilization it2 = iterator2.next();
                    $i$a$-maxOfOrNull-NextTurnAutomation$tryVoteForDiplomaticVictory$chosenCiv$highestOpinion$1 = false;
                    DiplomacyManager diplomacyManager2 = civ.getDiplomacyManager(it2);
                    Intrinsics.checkNotNull(diplomacyManager2);
                    float f3 = diplomacyManager2.opinionOfOtherCiv();
                    f2 = Math.max(f2, f3);
                }
                f = highestOpinion = Float.valueOf(f2);
            }
            object = highestOpinion == null ? null : (highestOpinion.floatValue() < -80.0f || highestOpinion.floatValue() < -40.0f && highestOpinion.floatValue() + (float)Random.Default.nextInt(40) < -40.0f ? null : ((Civilization)CollectionsKt.random((Collection)SequencesKt.toList(SequencesKt.filter(knownMajorCivs2, (Function1)new Function1<Civilization, Boolean>(civ, highestOpinion){
                final /* synthetic */ Civilization $civ;
                final /* synthetic */ Float $highestOpinion;
                {
                    this.$civ = $civ;
                    this.$highestOpinion = $highestOpinion;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Civilization it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    DiplomacyManager diplomacyManager = this.$civ.getDiplomacyManager(it);
                    Intrinsics.checkNotNull(diplomacyManager);
                    return Intrinsics.areEqual(diplomacyManager.opinionOfOtherCiv(), this.$highestOpinion);
                }
            })), Random.Default)).getCivName());
        } else {
            object = civ.getAllyCivName();
        }
        String chosenCiv2 = object;
        civ.diplomaticVoteForCiv(chosenCiv2);
    }

    private final void issueRequests(Civilization civInfo) {
        Iterator<Civilization> iterator2 = SequencesKt.filter(civInfo.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(civInfo){
            final /* synthetic */ Civilization $civInfo;
            {
                this.$civInfo = $civInfo;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isMajorCiv() && !this.$civInfo.isAtWarWith(it);
            }
        }).iterator();
        while (iterator2.hasNext()) {
            DiplomacyManager diploManager;
            Civilization otherCiv = iterator2.next();
            Intrinsics.checkNotNull(civInfo.getDiplomacyManager(otherCiv));
            if (diploManager.hasFlag(DiplomacyFlags.SettledCitiesNearUs)) {
                this.onCitySettledNearBorders(civInfo, otherCiv);
            }
            if (!diploManager.hasFlag(DiplomacyFlags.SpreadReligionInOurCities)) continue;
            this.onReligionSpreadInOurCity(civInfo, otherCiv);
        }
    }

    private final void onCitySettledNearBorders(Civilization civInfo, Civilization otherCiv) {
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacyManager2 = diplomacyManager;
        if (!diplomacyManager2.hasFlag(DiplomacyFlags.IgnoreThemSettlingNearUs)) {
            if (diplomacyManager2.hasFlag(DiplomacyFlags.AgreedToNotSettleNearUs)) {
                otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.CitySettledNearOtherCivDespiteOurPromise, civInfo.getCivName()));
                diplomacyManager2.setFlag(DiplomacyFlags.IgnoreThemSettlingNearUs, 100);
                diplomacyManager2.setModifier(DiplomaticModifiers.BetrayedPromiseToNotSettleCitiesNearUs, -20.0f);
                diplomacyManager2.removeFlag(DiplomacyFlags.AgreedToNotSettleNearUs);
            } else {
                ThreatLevel threatLevel = Automation.INSTANCE.threatAssessment(civInfo, otherCiv);
                if (threatLevel.compareTo((Enum)ThreatLevel.High) < 0) {
                    otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.DemandToStopSettlingCitiesNear, civInfo.getCivName()));
                }
            }
        }
        diplomacyManager2.removeFlag(DiplomacyFlags.SettledCitiesNearUs);
    }

    private final void onReligionSpreadInOurCity(Civilization civInfo, Civilization otherCiv) {
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacyManager2 = diplomacyManager;
        if (!diplomacyManager2.hasFlag(DiplomacyFlags.IgnoreThemSpreadingReligion)) {
            if (diplomacyManager2.hasFlag(DiplomacyFlags.AgreedToNotSpreadReligion)) {
                otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.ReligionSpreadDespiteOurPromise, civInfo.getCivName()));
                diplomacyManager2.setFlag(DiplomacyFlags.IgnoreThemSpreadingReligion, 100);
                diplomacyManager2.setModifier(DiplomaticModifiers.BetrayedPromiseToNotSpreadReligionToUs, -20.0f);
                diplomacyManager2.removeFlag(DiplomacyFlags.AgreedToNotSpreadReligion);
            } else {
                ThreatLevel threatLevel = Automation.INSTANCE.threatAssessment(civInfo, otherCiv);
                if (threatLevel.compareTo((Enum)ThreatLevel.High) < 0) {
                    otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.DemandToStopSpreadingReligion, civInfo.getCivName()));
                }
            }
        }
        diplomacyManager2.removeFlag(DiplomacyFlags.SpreadReligionInOurCities);
    }

    public final int getMinDistanceBetweenCities(@NotNull Civilization civ1, @NotNull Civilization civ2) {
        Intrinsics.checkNotNullParameter(civ1, "civ1");
        Intrinsics.checkNotNullParameter(civ2, "civ2");
        CityDistance cityDistance = this.getClosestCities(civ1, civ2);
        return cityDistance != null ? cityDistance.getAerialDistance() : Integer.MAX_VALUE;
    }

    @Nullable
    public final CityDistance getClosestCities(@NotNull Civilization civ1, @NotNull Civilization civ2) {
        Intrinsics.checkNotNullParameter(civ1, "civ1");
        Intrinsics.checkNotNullParameter(civ2, "civ2");
        if (civ1.getCities().isEmpty() || civ2.getCities().isEmpty()) {
            return null;
        }
        CityDistance minDistance = null;
        for (City civ1city : civ1.getCities()) {
            for (City civ2city : civ2.getCities()) {
                int currentDistance = civ1city.getCenterTile().aerialDistanceTo(civ2city.getCenterTile());
                if (minDistance != null && currentDistance >= minDistance.getAerialDistance()) continue;
                minDistance = new CityDistance(civ1city, civ2city, currentDistance);
            }
        }
        return minDistance;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<List<Technology>> chooseTechToResearch$getGroupedResearchableTechs(Civilization $civInfo) {
        void $this$groupByTo$iv$iv;
        Collection<Technology> collection = $civInfo.getGameInfo().getRuleset().getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Sequence $this$groupBy$iv = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<Technology, Boolean>($civInfo){
            final /* synthetic */ Civilization $civInfo;
            {
                this.$civInfo = $civInfo;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Technology it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$civInfo.getTech().canBeResearched(it.getName());
            }
        });
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Technology it = (Technology)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getCost();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map researchableTechs2 = destination$iv$iv;
        Collection collection2 = MapsKt.toSortedMap(researchableTechs2).values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        return CollectionsKt.toList(collection2);
    }

    private static final List<MapUnit> automateCityConquer$ourUnitsInRange(City $city, Civilization $civInfo, int range) {
        return SequencesKt.toList(SequencesKt.filter(SequencesKt.mapNotNull($city.getCenterTile().getTilesInDistance(range), automateCityConquer.ourUnitsInRange.1.INSTANCE), (Function1)new Function1<MapUnit, Boolean>($civInfo){
            final /* synthetic */ Civilization $civInfo;
            {
                this.$civInfo = $civInfo;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MapUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getCiv(), this.$civInfo);
            }
        }));
    }

    private static final void automateCityConquer$attackIfPossible(MapUnit unit, Tile tile) {
        AttackableTile attackableTile = (AttackableTile)CollectionsKt.firstOrNull(TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null), CollectionsKt.listOf(tile), false, 8, null));
        if (attackableTile != null) {
            Battle.INSTANCE.moveAndAttack(new MapUnitCombatant(unit), attackableTile);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/unciv/logic/automation/civilization/NextTurnAutomation$CityDistance;", "", "city1", "Lcom/unciv/logic/city/City;", "city2", "aerialDistance", "", "(Lcom/unciv/logic/city/City;Lcom/unciv/logic/city/City;I)V", "getAerialDistance", "()I", "getCity1", "()Lcom/unciv/logic/city/City;", "getCity2", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    public static final class CityDistance {
        @NotNull
        private final City city1;
        @NotNull
        private final City city2;
        private final int aerialDistance;

        public CityDistance(@NotNull City city1, @NotNull City city2, int aerialDistance) {
            Intrinsics.checkNotNullParameter(city1, "city1");
            Intrinsics.checkNotNullParameter(city2, "city2");
            this.city1 = city1;
            this.city2 = city2;
            this.aerialDistance = aerialDistance;
        }

        @NotNull
        public final City getCity1() {
            return this.city1;
        }

        @NotNull
        public final City getCity2() {
            return this.city2;
        }

        public final int getAerialDistance() {
            return this.aerialDistance;
        }

        @NotNull
        public final City component1() {
            return this.city1;
        }

        @NotNull
        public final City component2() {
            return this.city2;
        }

        public final int component3() {
            return this.aerialDistance;
        }

        @NotNull
        public final CityDistance copy(@NotNull City city1, @NotNull City city2, int aerialDistance) {
            Intrinsics.checkNotNullParameter(city1, "city1");
            Intrinsics.checkNotNullParameter(city2, "city2");
            return new CityDistance(city1, city2, aerialDistance);
        }

        public static /* synthetic */ CityDistance copy$default(CityDistance cityDistance, City city2, City city3, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                city2 = cityDistance.city1;
            }
            if ((n2 & 2) != 0) {
                city3 = cityDistance.city2;
            }
            if ((n2 & 4) != 0) {
                n = cityDistance.aerialDistance;
            }
            return cityDistance.copy(city2, city3, n);
        }

        @NotNull
        public String toString() {
            return "CityDistance(city1=" + this.city1 + ", city2=" + this.city2 + ", aerialDistance=" + this.aerialDistance + ')';
        }

        public int hashCode() {
            int result2 = this.city1.hashCode();
            result2 = result2 * 31 + this.city2.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.aerialDistance);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CityDistance)) {
                return false;
            }
            CityDistance cityDistance = (CityDistance)other;
            if (!Intrinsics.areEqual(this.city1, cityDistance.city1)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.city2, cityDistance.city2)) {
                return false;
            }
            return this.aerialDistance == cityDistance.aerialDistance;
        }
    }
}

