/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.civilization;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.civilization.MotivationToAttackAutomation;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.automation.civilization.UseGoldAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tJ\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/unciv/logic/automation/civilization/UseGoldAutomation;", "", "()V", "getHighlyDesirableTilesToCityMap", "Ljava/util/SortedMap;", "Lcom/unciv/logic/map/tile/Tile;", "", "Lcom/unciv/logic/city/City;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "isHighlyDesirableTile", "", "it", "city", "maybeBuyCityTiles", "", "tryGainInfluence", "cityState", "useGold", "civ", "useGoldForCityStates", "core"})
@SourceDebugExtension(value={"SMAP\nUseGoldAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseGoldAutomation.kt\ncom/unciv/logic/automation/civilization/UseGoldAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,171:1\n1054#2:172\n766#2:173\n857#2,2:174\n1271#2,2:176\n1285#2,4:178\n2310#2,14:183\n766#2:197\n857#2,2:198\n766#2:200\n857#2,2:201\n1#3:182\n372#4,7:203\n2159#5,2:210\n*S KotlinDebug\n*F\n+ 1 UseGoldAutomation.kt\ncom/unciv/logic/automation/civilization/UseGoldAutomation\n*L\n25#1:172\n54#1:173\n54#1:174,2\n55#1:176,2\n55#1:178,4\n76#1:183,14\n125#1:197\n125#1:198,2\n126#1:200\n126#1:201,2\n130#1:203,7\n140#1:210,2\n*E\n"})
public final class UseGoldAutomation {
    @NotNull
    public static final UseGoldAutomation INSTANCE = new UseGoldAutomation();

    private UseGoldAutomation() {
    }

    public final void useGold(@NotNull Civilization civ) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        Iterator<IsPartOfGameInfoSerialization> iterator2 = civ.getUnits().getCivUnits().iterator();
        while (iterator2.hasNext()) {
            MapUnit unit = iterator2.next();
            UnitAutomation.INSTANCE.tryUpgradeUnit$core(unit);
        }
        if (civ.isMajorCiv()) {
            this.useGoldForCityStates(civ);
        }
        Iterable $this$sortedByDescending$iv = civ.getCities();
        boolean $i$f$sortedByDescending = false;
        for (City city2 : CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                City it = (City)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPopulation().getPopulation());
                it = (City)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getPopulation().getPopulation());
            }
        })) {
            IConstruction construction2 = city2.getCityConstructions().getCurrentConstruction();
            if (!(construction2 instanceof INonPerpetualConstruction)) continue;
            Integer n = ((INonPerpetualConstruction)construction2).getStatBuyCost(city2, Stat.Gold);
            if (n == null) {
                continue;
            }
            int statBuyCost = n;
            if (!city2.getCityConstructions().isConstructionPurchaseAllowed((INonPerpetualConstruction)construction2, Stat.Gold, statBuyCost) || civ.getGold() < statBuyCost * 3) continue;
            CityConstructions.purchaseConstruction$default(city2.getCityConstructions(), (INonPerpetualConstruction)construction2, 0, true, null, null, 24, null);
        }
        this.maybeBuyCityTiles(civ);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void useGoldForCityStates(Civilization civ) {
        Object v0;
        void $this$associateWith$iv;
        Civilization it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List<Civilization> knownCityStates2 = SequencesKt.toList(SequencesKt.filter(civ.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(civ){
            final /* synthetic */ Civilization $civ;
            {
                this.$civ = $civ;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isCityState() && MotivationToAttackAutomation.INSTANCE.hasAtLeastMotivationToAttack(this.$civ, it, 0.0f) <= 0.0f;
            }
        }));
        if (civ.getGold() >= 330 && civ.getHappiness() > 0 && Civilization.hasUnique$default(civ, UniqueType.CityStateCanBeBoughtForGold, null, 2, null)) {
            for (Civilization cityState : CollectionsKt.toList((Iterable)knownCityStates2)) {
                if (cityState.getCityStateFunctions().canBeMarriedBy(civ)) {
                    cityState.getCityStateFunctions().diplomaticMarriage(civ);
                }
                if (civ.getHappiness() > 0) continue;
            }
        }
        if (civ.getGold() < 500) return;
        if (CollectionsKt.none((Iterable)knownCityStates2)) {
            return;
        }
        Iterable iterable = knownCityStates2;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getAllyCivName(), civ.getCivName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        Object result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Object $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = (Map)result$iv;
            boolean bl = false;
            Integer n = NextTurnAutomation.INSTANCE.valueCityStateAlliance$core(civ, it, true);
            map2.put(t, n);
        }
        Object object = ((Map)result$iv).entrySet();
        if (!(result$iv = object.iterator()).hasNext()) {
            v0 = null;
        } else {
            $this$associateWithTo$iv$iv = result$iv.next();
            if (!result$iv.hasNext()) {
                v0 = $this$associateWithTo$iv$iv;
            } else {
                Map.Entry it2 = (Map.Entry)$this$associateWithTo$iv$iv;
                boolean bl = false;
                int n = ((Number)it2.getValue()).intValue();
                do {
                    Object e = result$iv.next();
                    Map.Entry it3 = (Map.Entry)e;
                    $i$a$-maxByOrNull-UseGoldAutomation$useGoldForCityStates$cityState$3 = false;
                    int n2 = ((Number)it3.getValue()).intValue();
                    if (n >= n2) continue;
                    $this$associateWithTo$iv$iv = e;
                    n = n2;
                } while (result$iv.hasNext());
                v0 = $this$associateWithTo$iv$iv;
            }
        }
        Map.Entry entry = v0;
        Object object2 = entry;
        if (entry == null) return;
        Object it4 = object = object2;
        boolean bl = false;
        if (((Number)it4.getValue()).intValue() <= 0) return;
        boolean bl2 = true;
        if (!bl2) return;
        Object object3 = object;
        object2 = object3;
        if (object3 == null) return;
        Civilization civilization = (Civilization)object2.getKey();
        Civilization cityState = civilization;
        if (cityState == null) return;
        this.tryGainInfluence(civ, cityState);
    }

    private final void maybeBuyCityTiles(Civilization civInfo) {
        if (civInfo.getGold() <= 0) {
            return;
        }
        if (civInfo.getGameInfo().getTurns() < (int)(civInfo.getGameInfo().getSpeed().getScienceCostModifier() * (float)20)) {
            return;
        }
        SortedMap<Tile, Set<City>> highlyDesirableTiles = this.getHighlyDesirableTilesToCityMap(civInfo);
        for (Map.Entry highlyDesirableTile : ((Map)highlyDesirableTiles).entrySet()) {
            Object t;
            Object v = highlyDesirableTile.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
            Iterable $this$minBy$iv = (Iterable)v;
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                City it = (City)minElem$iv;
                boolean bl = false;
                Tile tile = it.getCenterTile();
                Object k = highlyDesirableTile.getKey();
                Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
                int minValue$iv = tile.aerialDistanceTo((Tile)k);
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    boolean bl2 = false;
                    Tile tile2 = it2.getCenterTile();
                    Object k2 = highlyDesirableTile.getKey();
                    Intrinsics.checkNotNullExpressionValue(k2, "<get-key>(...)");
                    int v$iv = tile2.aerialDistanceTo((Tile)k2);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
            City cityWithLeastCostToBuy = (City)t;
            BFS bfs2 = new BFS(cityWithLeastCostToBuy.getCenterTile(), (Function1<? super Tile, Boolean>)new Function1<Tile, Boolean>(cityWithLeastCostToBuy){
                final /* synthetic */ City $cityWithLeastCostToBuy;
                {
                    this.$cityWithLeastCostToBuy = $cityWithLeastCostToBuy;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getOwner() == null || Intrinsics.areEqual(it.getOwningCity(), this.$cityWithLeastCostToBuy);
                }
            });
            Object k = highlyDesirableTile.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
            bfs2.stepUntilDestination((Tile)k);
            Object k3 = highlyDesirableTile.getKey();
            Intrinsics.checkNotNullExpressionValue(k3, "<get-key>(...)");
            List<Tile> tilesThatNeedBuying2 = CollectionsKt.reversed((Iterable)SequencesKt.toList(SequencesKt.filter(bfs2.getPathTo((Tile)k3), maybeBuyCityTiles.tilesThatNeedBuying.1.INSTANCE)));
            boolean ranOutOfMoney = false;
            int goldSpent = 0;
            for (Tile tileThatNeedsBuying : tilesThatNeedBuying2) {
                int goldCostOfTile = cityWithLeastCostToBuy.getExpansion().getGoldCostOfTile(tileThatNeedsBuying);
                if (civInfo.getGold() >= goldCostOfTile) {
                    cityWithLeastCostToBuy.getExpansion().buyTile(tileThatNeedsBuying);
                    goldSpent += goldCostOfTile;
                    continue;
                }
                ranOutOfMoney = true;
                break;
            }
            if (!ranOutOfMoney) continue;
            for (Tile tileThatNeedsBuying : tilesThatNeedBuying2) {
                cityWithLeastCostToBuy.getExpansion().relinquishOwnership(tileThatNeedsBuying);
            }
            civInfo.addGold(goldSpent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SortedMap<Tile, Set<City>> getHighlyDesirableTilesToCityMap(Civilization civInfo) {
        void $this$filterTo$iv$iv;
        Object object = new Comparator(){

            public final int compare(T a, T b) {
                Tile it = (Tile)b;
                boolean bl = false;
                Tile tile = it;
                it = (Tile)a;
                Comparable comparable = Boolean.valueOf((tile != null ? tile.getNaturalWonder() : null) != null);
                bl = false;
                Tile tile2 = it;
                return ComparisonsKt.compareValues(comparable, (tile2 != null ? tile2.getNaturalWonder() : null) != null);
            }
        };
        object = new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Tile it = (Tile)b;
                    boolean bl = false;
                    Tile tile = it;
                    boolean bl2 = (tile != null ? tile.getResource() : null) != null && it.getTileResource().getResourceType() == ResourceType.Luxury;
                    it = (Tile)a;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    Tile tile2 = it;
                    n = ComparisonsKt.compareValues(comparable, (tile2 != null ? tile2.getResource() : null) != null && it.getTileResource().getResourceType() == ResourceType.Luxury);
                }
                return n;
            }
        };
        object = new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Tile it = (Tile)b;
                    boolean bl = false;
                    Tile tile = it;
                    boolean bl2 = (tile != null ? tile.getResource() : null) != null && it.getTileResource().getResourceType() == ResourceType.Strategic;
                    it = (Tile)a;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    Tile tile2 = it;
                    n = ComparisonsKt.compareValues(comparable, (tile2 != null ? tile2.getResource() : null) != null && it.getTileResource().getResourceType() == ResourceType.Strategic);
                }
                return n;
            }
        };
        SortedMap highlyDesirableTiles = new TreeMap(new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Tile tile = it;
                    it = (Tile)b;
                    Comparable comparable = Integer.valueOf(tile != null ? tile.hashCode() : 0);
                    bl = false;
                    Tile tile2 = it;
                    n = ComparisonsKt.compareValues(comparable, tile2 != null ? tile2.hashCode() : 0);
                }
                return n;
            }
        });
        Iterable $this$filter$iv = civInfo.getCities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            City it = (City)element$iv$iv;
            boolean bl = false;
            if (!(!it.isPuppet() && !it.isBeingRazed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (City city2 : (List)destination$iv$iv) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = city2.getTilesInRange();
            boolean $i$f$filter2 = false;
            Iterable $i$f$filterTo2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Tile it = (Tile)element$iv$iv;
                boolean bl = false;
                if (!INSTANCE.isHighlyDesirableTile(it, civInfo, city2)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List highlyDesirableTilesInCity = (List)destination$iv$iv2;
            for (Tile highlyDesirableTileInCity : highlyDesirableTilesInCity) {
                Object object2;
                Map $this$getOrPut$iv = highlyDesirableTiles;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(highlyDesirableTileInCity);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(highlyDesirableTileInCity, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((Set)object2).add(city2);
            }
        }
        return highlyDesirableTiles;
    }

    private final boolean isHighlyDesirableTile(Tile it, Civilization civInfo, City city2) {
        boolean bl;
        block4: {
            if (!it.isVisible(civInfo)) {
                return false;
            }
            if (it.getOwner() != null) {
                return false;
            }
            Sequence<Tile> $this$none$iv = it.getNeighbors();
            boolean $i$f$none = false;
            Iterator<Tile> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile neighbor = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(neighbor.getCity(), city2)) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (bl) {
            return false;
        }
        return UseGoldAutomation.isHighlyDesirableTile$hasNaturalWonder(it) || UseGoldAutomation.isHighlyDesirableTile$hasLuxuryCivDoesntOwn(it, civInfo) || UseGoldAutomation.isHighlyDesirableTile$hasResourceCivHasNoneOrLittle(it, civInfo);
    }

    private final void tryGainInfluence(Civilization civInfo, Civilization cityState) {
        boolean stopSpending;
        if (civInfo.getGold() < 500) {
            return;
        }
        DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(civInfo);
        Intrinsics.checkNotNull(diplomacyManager);
        float influence = diplomacyManager.getInfluence();
        boolean bl = stopSpending = influence > (float)(60 + 2 * NextTurnAutomation.INSTANCE.valueCityStateAlliance$core(civInfo, cityState, true));
        if (influence < 10.0f || stopSpending) {
            return;
        }
        if (civInfo.getGold() >= 1000) {
            cityState.getCityStateFunctions().receiveGoldGift(civInfo, 1000);
        } else {
            cityState.getCityStateFunctions().receiveGoldGift(civInfo, 500);
        }
    }

    private static final boolean isHighlyDesirableTile$hasNaturalWonder(Tile $it) {
        return $it.getNaturalWonder() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isHighlyDesirableTile$hasLuxuryCivDoesntOwn(Tile $it, Civilization $civInfo) {
        if (!$it.hasViewableResource($civInfo)) return false;
        if ($it.getTileResource().getResourceType() != ResourceType.Luxury) return false;
        String string = $it.getResource();
        Intrinsics.checkNotNull(string);
        if ($civInfo.hasResource(string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isHighlyDesirableTile$hasResourceCivHasNoneOrLittle(Tile $it, Civilization $civInfo) {
        if (!$it.hasViewableResource($civInfo)) return false;
        if ($it.getTileResource().getResourceType() != ResourceType.Strategic) return false;
        String string = $it.getResource();
        Intrinsics.checkNotNull(string);
        if ($civInfo.getResourceAmount(string) > 3) return false;
        return true;
    }
}

