/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.models.Spy;
import com.unciv.models.SpyAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/unciv/logic/automation/unit/EspionageAutomation;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/civilization/Civilization;)V", "cityStatesToRig", "", "getCityStatesToRig", "()Ljava/util/List;", "cityStatesToRig$delegate", "Lkotlin/Lazy;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "civsToStealFrom", "getCivsToStealFrom", "civsToStealFrom$delegate", "getCivsToStealFromSorted", "automateSpies", "", "automateSpyCounterInteligence", "", "spy", "Lcom/unciv/models/Spy;", "automateSpyRigElection", "automateSpyStealTech", "checkIfShouldStageCoup", "core"})
@SourceDebugExtension(value={"SMAP\nEspionageAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EspionageAutomation.kt\ncom/unciv/logic/automation/unit/EspionageAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1045#2:98\n766#2:99\n857#2,2:100\n1855#2,2:102\n766#2:104\n857#2,2:105\n1963#2,14:107\n1360#2:121\n1446#2,5:122\n766#2:127\n857#2,2:128\n1963#2,14:130\n766#2:144\n857#2,2:145\n*S KotlinDebug\n*F\n+ 1 EspionageAutomation.kt\ncom/unciv/logic/automation/unit/EspionageAutomation\n*L\n17#1:98\n27#1:99\n27#1:100,2\n52#1:102,2\n62#1:104\n62#1:105,2\n62#1:107,14\n71#1:121\n71#1:122,5\n71#1:127\n71#1:128,2\n72#1:130,14\n81#1:144\n81#1:145,2\n*E\n"})
public final class EspionageAutomation {
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private final Lazy civsToStealFrom$delegate;
    @NotNull
    private final List<Civilization> getCivsToStealFromSorted;
    @NotNull
    private final Lazy cityStatesToRig$delegate;

    public EspionageAutomation(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.civsToStealFrom$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Civilization>>(this){
            final /* synthetic */ EspionageAutomation this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Civilization> invoke() {
                return SequencesKt.toList(SequencesKt.filter(this.this$0.getCivInfo().getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(this.this$0){
                    final /* synthetic */ EspionageAutomation this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull Civilization otherCiv) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
                        if (otherCiv.isMajorCiv()) {
                            boolean bl2;
                            block5: {
                                void $this$any$iv;
                                Iterable iterable = otherCiv.getCities();
                                EspionageAutomation espionageAutomation = this.this$0;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        City it = (City)element$iv;
                                        boolean bl3 = false;
                                        if (!(it.getCenterTile().isExplored(espionageAutomation.getCivInfo()) && espionageAutomation.getCivInfo().getEspionageManager().getSpyAssignedToCity(it) == null)) continue;
                                        bl2 = true;
                                        break block5;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (bl2 && !((Collection)this.this$0.getCivInfo().getEspionageManager().getTechsToSteal(otherCiv)).isEmpty()) {
                                bl = true;
                                return bl;
                            }
                        }
                        bl = false;
                        return bl;
                    }
                }));
            }
        });
        Iterable $this$sortedBy$iv = this.getCivsToStealFrom();
        boolean $i$f$sortedBy = false;
        this.getCivsToStealFromSorted = CollectionsKt.toList(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(this){
            final /* synthetic */ EspionageAutomation this$0;
            {
                this.this$0 = espionageAutomation;
            }

            /*
             * Unable to fully structure code
             */
            public final int compare(T a, T b) {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                otherCiv = (Civilization)a;
                                $i$a$-sortedBy-EspionageAutomation$getCivsToStealFromSorted$1 = false;
                                var5_5 = this.this$0.getCivInfo().getEspionageManager().getSpyList();
                                $i$f$count = false;
                                if (!($this$count$iv instanceof Collection) || !((Collection)$this$count$iv).isEmpty()) break block6;
                                v0 = 0;
                                break block7;
                            }
                            count$iv = 0;
                            for (T element$iv : $this$count$iv) {
                                it = (Spy)element$iv;
                                $i$a$-count-EspionageAutomation$getCivsToStealFromSorted$1$1 = false;
                                if (!it.isDoingWork()) ** GOTO lbl-1000
                                v1 = it.getCityOrNull();
                                if (Intrinsics.areEqual(v1 != null ? v1.getCiv() : null, otherCiv)) {
                                    v2 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v2 = false;
                                }
                                if (!v2 || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            v0 = count$iv;
                        }
                        otherCiv = (Civilization)b;
                        var12_12 = Integer.valueOf(v0);
                        $i$a$-sortedBy-EspionageAutomation$getCivsToStealFromSorted$1 = false;
                        $this$count$iv = this.this$0.getCivInfo().getEspionageManager().getSpyList();
                        $i$f$count = false;
                        if (!($this$count$iv instanceof Collection) || !((Collection)$this$count$iv).isEmpty()) break block8;
                        v3 = 0;
                        break block9;
                    }
                    count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        it = (Spy)element$iv;
                        $i$a$-count-EspionageAutomation$getCivsToStealFromSorted$1$1 = false;
                        if (!it.isDoingWork()) ** GOTO lbl-1000
                        v4 = it.getCityOrNull();
                        if (Intrinsics.areEqual(v4 != null ? v4.getCiv() : null, otherCiv)) {
                            v5 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v5 = false;
                        }
                        if (!v5 || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v3 = count$iv;
                }
                return ComparisonsKt.compareValues(var12_12, v3);
            }
        }));
        this.cityStatesToRig$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Civilization>>(this){
            final /* synthetic */ EspionageAutomation this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Civilization> invoke() {
                return SequencesKt.toList(SequencesKt.filter(this.this$0.getCivInfo().getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(this.this$0){
                    final /* synthetic */ EspionageAutomation this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Civilization otherCiv) {
                        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
                        return otherCiv.isMinorCiv() && otherCiv.knows(this.this$0.getCivInfo()) && !this.this$0.getCivInfo().isAtWarWith(otherCiv);
                    }
                }));
            }
        });
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    private final List<Civilization> getCivsToStealFrom() {
        Lazy lazy = this.civsToStealFrom$delegate;
        return (List)lazy.getValue();
    }

    private final List<Civilization> getCityStatesToRig() {
        Lazy lazy = this.cityStatesToRig$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void automateSpies() {
        void $this$filterTo$iv$iv;
        ArrayList<Spy> spies = this.civInfo.getEspionageManager().getSpyList();
        Iterable $this$filter$iv = spies;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Spy it = (Spy)element$iv$iv;
            boolean bl = false;
            if (!(it.isAlive() && !it.isDoingWork())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List spiesToMove = (List)destination$iv$iv;
        for (Spy spy : spiesToMove) {
            int randomSeed = spies.size() + spies.indexOf(spy) + this.civInfo.getGameInfo().getTurns();
            int randomAction = RandomKt.Random(randomSeed).nextInt(10);
            if (randomAction <= 7 && this.automateSpyStealTech(spy) || randomAction <= 9 && this.automateSpyRigElection(spy) || this.automateSpyCounterInteligence(spy) || spy.isDoingWork() || this.automateSpyStealTech(spy) || this.automateSpyRigElection(spy) || this.automateSpyCounterInteligence(spy)) continue;
            City randomCity2 = (City)CollectionsKt.randomOrNull((Collection)SequencesKt.toList(SequencesKt.filter(this.civInfo.getGameInfo().getCities(), (Function1)new Function1<City, Boolean>(spy){
                final /* synthetic */ Spy $spy;
                {
                    this.$spy = $spy;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull City it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$spy.canMoveTo(it);
                }
            })), Random.Default);
            spy.moveTo(randomCity2);
        }
        Iterable $this$forEach$iv = spies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Spy it = (Spy)element$iv;
            boolean bl = false;
            this.checkIfShouldStageCoup(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean automateSpyStealTech(@NotNull Spy spy) {
        Object v0;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(spy, "spy");
        if (this.getCivsToStealFrom().isEmpty()) {
            return false;
        }
        Iterable $this$filter$iv = CollectionsKt.first(this.getCivsToStealFromSorted).getCities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            City it = (City)element$iv$iv;
            boolean bl = false;
            if (!spy.canMoveTo(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                City it = (City)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getPopulation().getPopulation();
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    $i$a$-maxByOrNull-EspionageAutomation$automateSpyStealTech$cityToMoveTo$2 = false;
                    int v$iv = it2.getPopulation().getPopulation();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        City cityToMoveTo = v0;
        spy.moveTo(cityToMoveTo);
        return cityToMoveTo != null;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean automateSpyRigElection(Spy spy) {
        $this$flatMap$iv = this.getCityStatesToRig();
        $i$f$flatMap = false;
        var5_4 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            $i$a$-flatMap-EspionageAutomation$automateSpyRigElection$cityToMoveTo$1 = false;
            list$iv$iv = it.getCities();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (City)element$iv$iv;
            $i$a$-filter-EspionageAutomation$automateSpyRigElection$cityToMoveTo$2 = false;
            if (it.isBeingRazed() || !spy.canMoveTo((City)it)) ** GOTO lbl-1000
            v0 = it.getCiv().getDiplomacyManager(this.civInfo);
            Intrinsics.checkNotNull(v0);
            if (v0.getInfluence() < 150.0f || !Intrinsics.areEqual(it.getCiv().getAllyCivName(), this.civInfo.getCivName())) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$maxByOrNull$iv = (List)destination$iv$iv;
        $i$f$maxByOrNull = false;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                it = (City)maxElem$iv;
                $i$a$-maxByOrNull-EspionageAutomation$automateSpyRigElection$cityToMoveTo$3 = false;
                v3 = it.getCiv().getDiplomacyManager(this.civInfo);
                Intrinsics.checkNotNull(v3);
                maxValue$iv = v3.getInfluence();
                do {
                    e$iv = iterator$iv.next();
                    it = (City)e$iv;
                    $i$a$-maxByOrNull-EspionageAutomation$automateSpyRigElection$cityToMoveTo$3 = false;
                    v4 = it.getCiv().getDiplomacyManager(this.civInfo);
                    Intrinsics.checkNotNull(v4);
                    v$iv = v4.getInfluence();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        cityToMoveTo = v2;
        spy.moveTo(cityToMoveTo);
        return cityToMoveTo != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean automateSpyCounterInteligence(Spy spy) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.civInfo.getCities();
        Spy spy2 = spy;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            City it = (City)element$iv$iv;
            boolean bl = false;
            if (!spy.canMoveTo(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        spy2.moveTo((City)CollectionsKt.randomOrNull((List)destination$iv$iv, Random.Default));
        return spy.getAction() == SpyAction.CounterIntelligence;
    }

    private final void checkIfShouldStageCoup(Spy spy) {
        ArrayList<Spy> spies;
        int randomSeed;
        int randomAction;
        if (!spy.canDoCoup()) {
            return;
        }
        if ((double)spy.getCoupChanceOfSuccess(false) < 0.7) {
            return;
        }
        Civilization allyCiv = spy.getCity().getCiv().getAllyCiv();
        if (allyCiv != null) {
            DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(allyCiv);
            boolean bl = diplomacyManager != null ? diplomacyManager.isRelationshipLevelGE(RelationshipLevel.Friend) : false;
            if (bl) {
                return;
            }
        }
        if ((randomAction = RandomKt.Random(randomSeed = (spies = this.civInfo.getEspionageManager().getSpyList()).size() + spies.indexOf(spy) + this.civInfo.getGameInfo().getTurns()).nextInt(100)) < 20) {
            spy.setAction(SpyAction.Coup, 1);
        }
    }
}

