/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.automation.unit.HeadTowardsEnemyCityAutomation;
import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\nH\u0002J$\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014J(\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/unciv/logic/automation/unit/HeadTowardsEnemyCityAutomation;", "", "()V", "maxDistanceFromCityToConsiderForLandingArea", "", "minDistanceFromCityToConsiderForLandingArea", "cannotTakeCitySoon", "", "ourUnitsAroundEnemyCity", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/map/mapunit/MapUnit;", "city", "Lcom/unciv/logic/city/City;", "getEnemyCitiesByPriority", "unit", "headToLandingGrounds", "closestReachableEnemyCity", "Lcom/unciv/logic/map/tile/Tile;", "headTowardsEnemyCity", "shortestPath", "", "headTowardsEnemyCityLongRange", "unitDistanceToTiles", "Lcom/unciv/logic/map/mapunit/movement/PathsToTilesWithinTurn;", "unitRange", "tryHeadTowardsEnemyCity", "core"})
@SourceDebugExtension(value={"SMAP\nHeadTowardsEnemyCityAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeadTowardsEnemyCityAutomation.kt\ncom/unciv/logic/automation/unit/HeadTowardsEnemyCityAutomation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n179#2,2:147\n1839#2,14:149\n603#2:169\n603#2:171\n179#2,2:172\n1839#2,14:174\n1271#3,2:163\n1285#3,4:165\n1#4:170\n*S KotlinDebug\n*F\n+ 1 HeadTowardsEnemyCityAutomation.kt\ncom/unciv/logic/automation/unit/HeadTowardsEnemyCityAutomation\n*L\n20#1:147,2\n37#1:149,14\n44#1:169\n116#1:171\n117#1:172,2\n139#1:174,14\n42#1:163,2\n42#1:165,4\n*E\n"})
public final class HeadTowardsEnemyCityAutomation {
    @NotNull
    public static final HeadTowardsEnemyCityAutomation INSTANCE = new HeadTowardsEnemyCityAutomation();
    private static final int maxDistanceFromCityToConsiderForLandingArea = 5;
    private static final int minDistanceFromCityToConsiderForLandingArea = 3;

    private HeadTowardsEnemyCityAutomation() {
    }

    public final boolean tryHeadTowardsEnemyCity(@NotNull MapUnit unit) {
        City city2;
        block3: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            if (unit.getCiv().getCities().isEmpty()) {
                return false;
            }
            Sequence<City> $this$firstOrNull$iv = this.getEnemyCitiesByPriority(unit);
            boolean $i$f$firstOrNull = false;
            Iterator<City> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                City element$iv;
                City it = element$iv = iterator2.next();
                boolean bl = false;
                if (!unit.getMovement().canReach(it.getCenterTile())) continue;
                city2 = element$iv;
                break block3;
            }
            city2 = null;
        }
        City city3 = city2;
        if (city3 == null) {
            return false;
        }
        City closestReachableEnemyCity = city3;
        return this.headTowardsEnemyCity(unit, closestReachableEnemyCity.getCenterTile(), UnitMovement.getShortestPath$default(unit.getMovement(), closestReachableEnemyCity.getCenterTile(), false, 2, null));
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<City> getEnemyCitiesByPriority(MapUnit unit) {
        void $this$sortedBy$iv;
        Sequence $this$associateWith$iv;
        Object object;
        Object v0;
        Iterable $this$minByOrNull$iv;
        Sequence<Civilization> enemies2 = SequencesKt.filter(unit.getCiv().getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$unit.getCiv().isAtWarWith(it) && !((Collection)it.getCities()).isEmpty();
            }
        });
        Sequence sequence = SequencesKt.mapNotNull(enemies2, (Function1)new Function1<Civilization, NextTurnAutomation.CityDistance>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            @Nullable
            public final NextTurnAutomation.CityDistance invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return NextTurnAutomation.INSTANCE.getClosestCities(this.$unit.getCiv(), it);
            }
        });
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                NextTurnAutomation.CityDistance it = (NextTurnAutomation.CityDistance)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getAerialDistance();
                do {
                    Object e$iv = iterator$iv.next();
                    NextTurnAutomation.CityDistance it2 = (NextTurnAutomation.CityDistance)e$iv;
                    city2 = false;
                    int v$iv = it2.getAerialDistance();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        if ((object = (NextTurnAutomation.CityDistance)v0) == null || (object = ((NextTurnAutomation.CityDistance)object).getCity2()) == null) {
            return SequencesKt.emptySequence();
        }
        Object closestEnemyCity2 = object;
        $this$minByOrNull$iv = ((City)closestEnemyCity2).getCiv().getCities();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            City city2 = (City)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Integer n = it.getCenterTile().aerialDistanceTo(((City)closestEnemyCity2).getCenterTile());
            map2.put(t, n);
        }
        $this$associateWith$iv = SequencesKt.filterNot(MapsKt.asSequence(result$iv), getEnemyCitiesByPriority.enemyCitiesByPriority.2.INSTANCE);
        boolean $i$f$sortedBy = false;
        Sequence<City> enemyCitiesByPriority2 = SequencesKt.map(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getValue()));
            }
        }), getEnemyCitiesByPriority.enemyCitiesByPriority.4.INSTANCE);
        if (unit.getBaseUnit().isRanged()) {
            enemyCitiesByPriority2 = SequencesKt.filterNot(enemyCitiesByPriority2, getEnemyCitiesByPriority.1.INSTANCE);
        }
        return enemyCitiesByPriority2;
    }

    public final boolean headTowardsEnemyCity(@NotNull MapUnit unit, @NotNull Tile closestReachableEnemyCity, @NotNull List<Tile> shortestPath) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(closestReachableEnemyCity, "closestReachableEnemyCity");
        Intrinsics.checkNotNullParameter(shortestPath, "shortestPath");
        PathsToTilesWithinTurn unitDistanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
        int unitRange = unit.getRange();
        if (unitRange > 2) {
            return this.headTowardsEnemyCityLongRange(closestReachableEnemyCity, unitDistanceToTiles, unitRange, unit);
        }
        Tile nextTileInPath = shortestPath.get(0);
        if (unit.getCurrentTile().aerialDistanceTo(closestReachableEnemyCity) > 5 && shortestPath.size() > 3) {
            UnitMovement.moveToTile$default(unit.getMovement(), nextTileInPath, false, 2, null);
            return true;
        }
        Sequence<MapUnit> ourUnitsAroundEnemyCity2 = SequencesKt.filter(SequencesKt.flatMap(closestReachableEnemyCity.getTilesInDistance(6), headTowardsEnemyCity.ourUnitsAroundEnemyCity.1.INSTANCE), (Function1)new Function1<MapUnit, Boolean>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MapUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isMilitary() && Intrinsics.areEqual(it.getCiv(), this.$unit.getCiv());
            }
        });
        City city2 = closestReachableEnemyCity.getCity();
        Intrinsics.checkNotNull(city2);
        City city3 = city2;
        if (this.cannotTakeCitySoon(ourUnitsAroundEnemyCity2, city3)) {
            return this.headToLandingGrounds(closestReachableEnemyCity, unit);
        }
        UnitMovement.moveToTile$default(unit.getMovement(), nextTileInPath, false, 2, null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean cannotTakeCitySoon(Sequence<MapUnit> ourUnitsAroundEnemyCity2, City city2) {
        CityCombatant cityCombatant = new CityCombatant(city2);
        Sequence<MapUnit> sequence = ourUnitsAroundEnemyCity2;
        int n = 0;
        Iterator<MapUnit> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            MapUnit mapUnit;
            MapUnit mapUnit2 = mapUnit = iterator2.next();
            int n2 = n;
            boolean bl = false;
            int n3 = BattleDamage.calculateDamageToDefender$default(BattleDamage.INSTANCE, new MapUnitCombatant((MapUnit)it), cityCombatant, null, 0.0f, 12, null);
            n = n2 + n3;
        }
        int expectedDamagePerTurn = n;
        int cityHealingPerTurn = 20;
        return expectedDamagePerTurn < city2.getHealth() && (expectedDamagePerTurn <= cityHealingPerTurn || city2.getHealth() / (expectedDamagePerTurn - cityHealingPerTurn) > 5);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean headToLandingGrounds(Tile closestReachableEnemyCity, MapUnit unit) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Sequence $this$sortedBy$iv;
            Sequence<Tile> sequence = SequencesKt.filter(closestReachableEnemyCity.getTilesInDistanceRange(new IntRange(3, 5)), (Function1)new Function1<Tile, Boolean>(unit){
                final /* synthetic */ MapUnit $unit;
                {
                    this.$unit = $unit;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.isLand() && this.$unit.getDamageFromTerrain(it) <= 0;
                }
            });
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!((UnitMovement.canMoveTo$default(unit.getMovement(), it, false, false, false, 14, null) || Intrinsics.areEqual(it, unit.getCurrentTile())) && unit.getMovement().canReach(it))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Tile tileToHeadTo2 = v0;
        if (tileToHeadTo2 != null) {
            unit.getMovement().headTowards(tileToHeadTo2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean headTowardsEnemyCityLongRange(Tile closestReachableEnemyCity, PathsToTilesWithinTurn unitDistanceToTiles, int unitRange, MapUnit unit) {
        Object object;
        Object v0;
        void $this$minByOrNull$iv;
        Set<Tile> tilesInBombardRange = SequencesKt.toSet(closestReachableEnemyCity.getTilesInDistance(2));
        Sequence sequence = SequencesKt.filter(MapsKt.asSequence(unitDistanceToTiles), (Function1)new Function1<Map.Entry<? extends Tile, ? extends UnitMovement.ParentTileAndTotalMovement>, Boolean>(closestReachableEnemyCity, unitRange, tilesInBombardRange, unit){
            final /* synthetic */ Tile $closestReachableEnemyCity;
            final /* synthetic */ int $unitRange;
            final /* synthetic */ Set<Tile> $tilesInBombardRange;
            final /* synthetic */ MapUnit $unit;
            {
                this.$closestReachableEnemyCity = $closestReachableEnemyCity;
                this.$unitRange = $unitRange;
                this.$tilesInBombardRange = $tilesInBombardRange;
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<Tile, UnitMovement.ParentTileAndTotalMovement> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getKey().aerialDistanceTo(this.$closestReachableEnemyCity) <= this.$unitRange && !this.$tilesInBombardRange.contains(it.getKey()) && this.$unit.getDamageFromTerrain(it.getKey()) <= 0;
            }
        });
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                Map.Entry it = (Map.Entry)minElem$iv;
                boolean bl = false;
                float minValue$iv = ((UnitMovement.ParentTileAndTotalMovement)it.getValue()).getTotalMovement();
                do {
                    Object e$iv = iterator$iv.next();
                    Map.Entry it2 = (Map.Entry)e$iv;
                    $i$a$-minByOrNull-HeadTowardsEnemyCityAutomation$headTowardsEnemyCityLongRange$tileToMoveTo$2 = false;
                    float v$iv = ((UnitMovement.ParentTileAndTotalMovement)it2.getValue()).getTotalMovement();
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        if ((object = (Map.Entry)v0) == null || (object = (Tile)object.getKey()) == null) {
            return false;
        }
        Object tileToMoveTo2 = object;
        unit.getMovement().headTowards((Tile)tileToMoveTo2);
        return true;
    }
}

