/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.map.MapPathing;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/unciv/logic/automation/unit/RoadToAutomation;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/civilization/Civilization;)V", "actualBestRoadAvailable", "Lcom/unciv/logic/map/tile/RoadStatus;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "automateConnectRoad", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "tilesWhereWeWillBeCaptured", "", "Lcom/unciv/logic/map/tile/Tile;", "shouldBuildRoadOnTile", "", "tile", "stopAndCleanAutomation", "core"})
@SourceDebugExtension(value={"SMAP\nRoadToAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoadToAutomation.kt\ncom/unciv/logic/automation/unit/RoadToAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1549#2:152\n1620#2,3:153\n*S KotlinDebug\n*F\n+ 1 RoadToAutomation.kt\ncom/unciv/logic/automation/unit/RoadToAutomation\n*L\n63#1:152\n63#1:153,3\n*E\n"})
public final class RoadToAutomation {
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private final RoadStatus actualBestRoadAvailable;

    public RoadToAutomation(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.actualBestRoadAvailable = this.civInfo.getTech().getBestRoadAvailable();
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    /*
     * WARNING - void declaration
     */
    public final void automateConnectRoad(@NotNull MapUnit unit, @NotNull Set<Tile> tilesWhereWeWillBeCaptured) {
        int currTileIndex;
        Object[] $this$map$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tilesWhereWeWillBeCaptured, "tilesWhereWeWillBeCaptured");
        if (this.actualBestRoadAvailable == RoadStatus.None) {
            return;
        }
        Tile currentTile = unit.getTile();
        if (unit.getAutomatedRoadConnectionDestination() == null) {
            this.stopAndCleanAutomation(unit);
            return;
        }
        TileMap tileMap = unit.getCiv().getGameInfo().getTileMap();
        Vector2 vector2 = unit.getAutomatedRoadConnectionDestination();
        Intrinsics.checkNotNull(vector2);
        Tile destinationTile2 = tileMap.get(vector2);
        List pathToDest = unit.getAutomatedRoadConnectionPath();
        if (pathToDest == null) {
            void $this$mapTo$iv$iv;
            List<Tile> foundPath = MapPathing.INSTANCE.getRoadPath(unit, currentTile, destinationTile2);
            if (foundPath == null) {
                Log.INSTANCE.debug("WorkerAutomation: " + unit + " -> connect road failed", new Object[0]);
                this.stopAndCleanAutomation(unit);
                String[] stringArray = new String[]{"StatIcons/Production"};
                unit.getCiv().addNotification("Connect road failed!", new MapUnitAction(unit), Notification.NotificationCategory.Units, stringArray);
                return;
            }
            Iterable iterable = foundPath;
            boolean $i$f$map = false;
            void var9_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Tile tile = (Tile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPosition());
            }
            pathToDest = (List)destination$iv$iv;
            unit.setAutomatedRoadConnectionPath(pathToDest);
            $this$map$iv = new Object[]{destinationTile2, pathToDest};
            LogKt.debug("WorkerAutomation: " + unit + " -> found connect road path to destination tile: %s, %s", $this$map$iv);
        }
        if ((currTileIndex = pathToDest.indexOf(currentTile.getPosition())) == -1) {
            Log.INSTANCE.debug(unit + " -> was moved off its connect road path. Operation cancelled.", new Object[0]);
            this.stopAndCleanAutomation(unit);
            $this$map$iv = new String[]{unit.getName()};
            unit.getCiv().addNotification("Connect road cancelled!", new MapUnitAction(unit), Notification.NotificationCategory.Units, (String[])$this$map$iv);
            return;
        }
        if (unit.hasMovement() && !this.shouldBuildRoadOnTile(currentTile)) {
            if (currTileIndex == pathToDest.size() - 1) {
                this.stopAndCleanAutomation(unit);
                $this$map$iv = new String[]{unit.getName()};
                unit.getCiv().addNotification("Connect road completed", new MapUnitAction(unit), Notification.NotificationCategory.Units, (String[])$this$map$iv);
                return;
            }
            if (currTileIndex < pathToDest.size() - 1) {
                TileMap tileMap2 = unit.getCiv().getGameInfo().getTileMap();
                Tile nextTile = currentTile;
                Sequence futureTiles2 = SequencesKt.map(SequencesKt.drop(SequencesKt.dropWhile(CollectionsKt.asSequence(pathToDest), (Function1)new Function1<Vector2, Boolean>(unit){
                    final /* synthetic */ MapUnit $unit;
                    {
                        this.$unit = $unit;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Vector2 it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return !Intrinsics.areEqual(it, this.$unit.getCurrentTile().getPosition());
                    }
                }), 1), (Function1)new Function1<Vector2, Tile>(tileMap2){
                    final /* synthetic */ TileMap $tileMap;
                    {
                        this.$tileMap = $tileMap;
                        super(1);
                    }

                    @NotNull
                    public final Tile invoke(@NotNull Vector2 it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$tileMap.get(it);
                    }
                });
                Iterator iterator2 = futureTiles2.iterator();
                while (iterator2.hasNext()) {
                    Tile futureTile = (Tile)iterator2.next();
                    if (!unit.getMovement().canReachInCurrentTurn(futureTile) || !UnitMovement.canMoveTo$default(unit.getMovement(), futureTile, false, false, false, 14, null)) continue;
                    nextTile = futureTile;
                    if (!this.shouldBuildRoadOnTile(futureTile)) continue;
                }
                UnitMovement.moveToTile$default(unit.getMovement(), nextTile, false, 2, null);
                currentTile = unit.getTile();
            }
        }
        if (unit.hasMovement()) {
            if (currentTile.getRoadStatus() != RoadStatus.None && currentTile.getRoadIsPillaged()) {
                currentTile.setRepaired();
                return;
            }
            if (this.shouldBuildRoadOnTile(currentTile) && !Intrinsics.areEqual(currentTile.getImprovementInProgress(), this.actualBestRoadAvailable.name())) {
                TileImprovement tileImprovement = this.actualBestRoadAvailable.improvement(this.civInfo.getGameInfo().getRuleset());
                Intrinsics.checkNotNull(tileImprovement);
                TileImprovement improvement2 = tileImprovement;
                currentTile.startWorkingOnImprovement(improvement2, this.civInfo, unit);
                return;
            }
        }
    }

    public final void stopAndCleanAutomation(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        unit.setAutomated(false);
        unit.setAction(null);
        unit.setAutomatedRoadConnectionDestination(null);
        unit.setAutomatedRoadConnectionPath(null);
        unit.getCurrentTile().stopWorkingOnImprovement();
    }

    public final boolean shouldBuildRoadOnTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (tile.getRoadIsPillaged()) {
            return true;
        }
        return !tile.isCityCenter() && (!tile.hasConnection(this.civInfo) || this.actualBestRoadAvailable != RoadStatus.Road) && tile.getRoadStatus() != this.actualBestRoadAvailable;
    }
}

