/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.unit.CityLocationTileRanker;
import com.unciv.logic.automation.unit.CivilianUnitAutomation;
import com.unciv.logic.automation.unit.SpecificUnitAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.battle.GreatGeneralImplementation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActions;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsFromUniques;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0017"}, d2={"Lcom/unciv/logic/automation/unit/SpecificUnitAutomation;", "", "()V", "automateAddInCapital", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "automateCitadelPlacer", "", "automateGreatGeneral", "automateGreatGeneralFallback", "automateImprovementPlacer", "automateSettlerActions", "dangerousTiles", "Ljava/util/HashSet;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/collections/HashSet;", "conductTradeMission", "getWonderThatWouldBenefitFromBeingSpedUp", "Lcom/unciv/models/ruleset/Building;", "city", "Lcom/unciv/logic/city/City;", "speedupWonderConstruction", "core"})
@SourceDebugExtension(value={"SMAP\nSpecificUnitAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecificUnitAutomation.kt\ncom/unciv/logic/automation/unit/SpecificUnitAutomation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,368:1\n1268#2,3:369\n603#2:372\n179#2,2:373\n603#2:375\n179#2,2:376\n179#2,2:378\n1433#2,14:380\n614#2:401\n179#2,2:402\n1247#2:433\n1247#2,2:434\n1248#2:436\n614#2:437\n179#2,2:438\n603#2:509\n1268#2,3:510\n526#3:394\n511#3,6:395\n1963#4,14:404\n1963#4,14:418\n1054#4:432\n766#4:440\n857#4,2:441\n1373#4:443\n1461#4,5:444\n766#4:449\n857#4,2:450\n1603#4,9:452\n1855#4:461\n1856#4:463\n1612#4:464\n2333#4,14:465\n766#4:479\n857#4,2:480\n1603#4,9:482\n1855#4:491\n1856#4:493\n1612#4:494\n2333#4,14:495\n1#5:462\n1#5:492\n*S KotlinDebug\n*F\n+ 1 SpecificUnitAutomation.kt\ncom/unciv/logic/automation/unit/SpecificUnitAutomation\n*L\n34#1:369,3\n48#1:372\n57#1:373,2\n82#1:375\n83#1:376,2\n92#1:378,2\n125#1:380,14\n161#1:401\n162#1:402,2\n243#1:433\n244#1:434,2\n243#1:436\n255#1:437\n262#1:438,2\n354#1:509\n178#1:510,3\n136#1:394\n136#1:395,6\n180#1:404,14\n213#1:418,14\n215#1:432\n285#1:440\n285#1:441,2\n291#1:443\n291#1:444,5\n292#1:449\n292#1:450,2\n293#1:452,9\n293#1:461\n293#1:463\n293#1:464\n298#1:465,14\n320#1:479\n320#1:480,2\n327#1:482,9\n327#1:491\n327#1:493\n327#1:494\n330#1:495,14\n293#1:462\n327#1:492\n*E\n"})
public final class SpecificUnitAutomation {
    @NotNull
    public static final SpecificUnitAutomation INSTANCE = new SpecificUnitAutomation();

    private SpecificUnitAutomation() {
    }

    public final boolean automateGreatGeneral(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Tile tile = GreatGeneralImplementation.INSTANCE.getBestAffectedTroopsTile(unit);
        if (tile == null) {
            return false;
        }
        Tile maxAffectedTroopsTile = tile;
        unit.getMovement().headTowards(maxAffectedTroopsTile);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean automateCitadelPlacer(@NotNull MapUnit unit) {
        Object v0;
        block8: {
            void $this$firstOrNull$iv;
            Sequence $this$sortedBy$iv;
            Intrinsics.checkNotNullParameter(unit, "unit");
            if (MapUnit.hasUnique$default(unit, UniqueType.StrengthBonusInRadius, null, false, 6, null)) {
                Sequence<MapUnit> $this$count$iv = unit.getCiv().getUnits().getCivUnits();
                boolean $i$f$count = false;
                int count$iv = 0;
                Iterator<MapUnit> iterator2 = $this$count$iv.iterator();
                while (iterator2.hasNext()) {
                    MapUnit element$iv;
                    MapUnit it = element$iv = iterator2.next();
                    boolean bl = false;
                    if (!MapUnit.hasUnique$default(it, UniqueType.StrengthBonusInRadius, null, false, 6, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                if (count$iv < 3) {
                    return false;
                }
            }
            Sequence enemyCities2 = SequencesKt.flatMapIterable(SequencesKt.filter(unit.getCiv().getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(unit){
                final /* synthetic */ MapUnit $unit;
                {
                    this.$unit = $unit;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Civilization it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    DiplomacyManager diplomacyManager = this.$unit.getCiv().getDiplomacyManager(it);
                    Intrinsics.checkNotNull(diplomacyManager);
                    return diplomacyManager.hasModifier(DiplomaticModifiers.StealingTerritory);
                }
            }), automateCitadelPlacer.enemyCities.2.INSTANCE);
            Sequence count$iv = SequencesKt.filter(SequencesKt.flatMap(SequencesKt.filter(SequencesKt.flatMap(enemyCities2, automateCitadelPlacer.tileToSteal.1.INSTANCE), (Function1)new Function1<Tile, Boolean>(unit){
                final /* synthetic */ MapUnit $unit;
                {
                    this.$unit = $unit;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    boolean bl;
                    block1: {
                        void $this$any$iv;
                        Intrinsics.checkNotNullParameter(it, "it");
                        Sequence<Tile> sequence = it.getNeighbors();
                        MapUnit mapUnit = this.$unit;
                        boolean $i$f$any = false;
                        for (T element$iv : $this$any$iv) {
                            Tile tile = (Tile)element$iv;
                            boolean bl2 = false;
                            if (!(!Intrinsics.areEqual(tile.getOwner(), mapUnit.getCiv()))) continue;
                            bl = true;
                            break block1;
                        }
                        bl = false;
                    }
                    return bl;
                }
            }), automateCitadelPlacer.tileToSteal.3.INSTANCE), (Function1)new Function1<Tile, Boolean>(unit){
                final /* synthetic */ MapUnit $unit;
                {
                    this.$unit = $unit;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (this.$unit.getCiv().getViewableTiles().contains(it)) {
                        boolean bl2;
                        block3: {
                            void $this$any$iv;
                            Sequence<Tile> sequence = it.getNeighbors();
                            MapUnit mapUnit = this.$unit;
                            boolean $i$f$any = false;
                            for (T element$iv : $this$any$iv) {
                                Tile tile = (Tile)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual(tile.getOwner(), mapUnit.getCiv())) continue;
                                bl2 = true;
                                break block3;
                            }
                            bl2 = false;
                        }
                        if (bl2) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                }
            });
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    int distance = it.aerialDistanceTo(this.$unit$inlined.getCurrentTile());
                    Civilization owner = it.getOwner();
                    int n = owner != null ? distance - MathKt.roundToInt(owner.getWorkerAutomation().getBasePriority(it, this.$unit$inlined)) : distance;
                    it = (Tile)b;
                    Comparable comparable = Integer.valueOf(n);
                    bl = false;
                    distance = it.aerialDistanceTo(this.$unit$inlined.getCurrentTile());
                    owner = it.getOwner();
                    return ComparisonsKt.compareValues(comparable, owner != null ? distance - MathKt.roundToInt(owner.getWorkerAutomation().getBasePriority(it, this.$unit$inlined)) : distance);
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!unit.getMovement().canReach(it)) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        Tile tileToSteal2 = v0;
        if (tileToSteal2 != null) {
            Object object;
            unit.getMovement().headTowards(tileToSteal2);
            if (unit.hasMovement() && Intrinsics.areEqual(unit.getCurrentTile(), tileToSteal2) && (object = SequencesKt.firstOrNull(UnitActionsFromUniques.INSTANCE.getImprovementConstructionActionsFromGeneralUnique(unit, unit.getCurrentTile()))) != null && (object = ((UnitAction)object).getAction()) != null) {
                object.invoke();
            }
            return true;
        }
        if (unit.getCiv().getWorkerAutomation().evaluateFortPlacement(unit.getCurrentTile(), true)) {
            Object object = SequencesKt.firstOrNull(UnitActionsFromUniques.INSTANCE.getImprovementConstructionActionsFromGeneralUnique(unit, unit.getCurrentTile()));
            if (object != null && (object = ((UnitAction)object).getAction()) != null) {
                object.invoke();
            }
            return true;
        }
        return false;
    }

    public final void automateGreatGeneralFallback(@NotNull MapUnit unit) {
        block7: {
            Object object;
            Object v3;
            Tile cityToGarrison2;
            block6: {
                Object v0;
                Tile it;
                Object element$iv;
                Iterator<Object> iterator2;
                Sequence<Tile> $this$firstOrNull$iv;
                boolean $i$f$firstOrNull;
                Function1 reachableTest2;
                block5: {
                    Sequence $this$sortedBy$iv;
                    Intrinsics.checkNotNullParameter(unit, "unit");
                    reachableTest2 = new Function1<Tile, Boolean>(unit){
                        final /* synthetic */ MapUnit $unit;
                        {
                            this.$unit = $unit;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull Tile it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return it.getCivilianUnit() == null && UnitMovement.canMoveTo$default(this.$unit.getMovement(), it, false, false, false, 14, null) && this.$unit.getMovement().canReach(it);
                        }
                    };
                    Sequence sequence = SequencesKt.map(CollectionsKt.asSequence((Iterable)unit.getCiv().getCities()), automateGreatGeneralFallback.cityToGarrison.1.INSTANCE);
                    boolean $i$f$sortedBy = false;
                    $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                        final /* synthetic */ MapUnit $unit$inlined;
                        {
                            this.$unit$inlined = mapUnit;
                        }

                        public final int compare(T a, T b) {
                            Tile it = (Tile)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                            it = (Tile)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                        }
                    });
                    $i$f$firstOrNull = false;
                    iterator2 = $this$firstOrNull$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        it = (Tile)element$iv;
                        boolean bl = false;
                        if (!((Boolean)reachableTest2.invoke(it)).booleanValue()) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                Tile tile = v0;
                if (tile == null) {
                    return;
                }
                cityToGarrison2 = tile;
                if (!unit.getCache().getHasCitadelPlacementUnique()) {
                    unit.getMovement().headTowards(cityToGarrison2);
                    return;
                }
                $this$firstOrNull$iv = cityToGarrison2.getTilesInDistanceRange(new IntRange(3, 4));
                $i$f$firstOrNull = false;
                iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it = (Tile)element$iv;
                    boolean bl = false;
                    boolean bl2 = ((Boolean)reachableTest2.invoke(it)).booleanValue() && unit.getCiv().getWorkerAutomation().evaluateFortPlacement(it, true);
                    if (!bl2) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            Tile tileForCitadel = v3;
            if (tileForCitadel == null) {
                unit.getMovement().headTowards(cityToGarrison2);
                return;
            }
            unit.getMovement().headTowards(tileForCitadel);
            if (!unit.hasMovement() || !Intrinsics.areEqual(unit.getCurrentTile(), tileForCitadel) || (object = SequencesKt.firstOrNull(UnitActionsFromUniques.INSTANCE.getImprovementConstructionActionsFromGeneralUnique(unit, unit.getCurrentTile()))) == null || (object = ((UnitAction)object).getAction()) == null) break block7;
            object.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void automateSettlerActions(@NotNull MapUnit unit, @NotNull HashSet<Tile> dangerousTiles) {
        boolean shouldSettle;
        UnitAction foundCityAction;
        Sequence<Object> allUnsettledSettlers2;
        Object foundCityAction22;
        Tile bestCityLocation;
        CityLocationTileRanker.BestTilesToFoundCity bestTilesInfo;
        block38: {
            block39: {
                Intrinsics.checkNotNullParameter(unit, "unit");
                Intrinsics.checkNotNullParameter(dangerousTiles, "dangerousTiles");
                Integer rangeToSearch = unit.getCiv().getCities().isEmpty() && unit.getCiv().getGameInfo().getTurns() < 4 ? Integer.valueOf(RangesKt.coerceAtLeast(3 - unit.getCiv().getGameInfo().getTurns(), 1)) : null;
                bestTilesInfo = CityLocationTileRanker.INSTANCE.getBestTilesToFoundCity(unit, rangeToSearch, 50.0f);
                bestCityLocation = null;
                if (unit.getCiv().getGameInfo().getTurns() == 0 && unit.getCiv().getCities().isEmpty() && bestTilesInfo.getTileRankMap().containsKey(unit.getTile())) {
                    Object e$iv;
                    Object object;
                    foundCityAction22 = UnitActionsFromUniques.INSTANCE.getFoundCityAction$core(unit, unit.getTile());
                    allUnsettledSettlers2 = SequencesKt.filter(unit.getCiv().getUnits().getCivUnits(), (Function1)new Function1<MapUnit, Boolean>(unit){
                        final /* synthetic */ MapUnit $unit;
                        {
                            this.$unit = $unit;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull MapUnit it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return it.hasMovement() && Intrinsics.areEqual(it.getBaseUnit(), this.$unit.getBaseUnit());
                        }
                    });
                    Object $this$maxByOrNull$iv = allUnsettledSettlers2;
                    boolean $i$f$maxByOrNull = false;
                    Iterator<Object> iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        object = null;
                    } else {
                        Object maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            object = maxElem$iv;
                        } else {
                            Float f;
                            MapUnit it = (MapUnit)maxElem$iv;
                            boolean bl = false;
                            if (bestTilesInfo.getTileRankMap().containsKey(it.getTile())) {
                                Float f2 = bestTilesInfo.getTileRankMap().get(it.getTile());
                                Intrinsics.checkNotNull(f2);
                                f = f2;
                            } else {
                                f = Float.valueOf(-1.0f);
                            }
                            Float f3 = f;
                            Intrinsics.checkNotNull(f3);
                            Comparable maxValue$iv = Float.valueOf(((Number)f3).floatValue());
                            do {
                                Float f4;
                                e$iv = iterator$iv.next();
                                MapUnit it2 = (MapUnit)e$iv;
                                $i$a$-maxByOrNull-SpecificUnitAutomation$automateSettlerActions$bestSettlerInRange$1 = false;
                                if (bestTilesInfo.getTileRankMap().containsKey(it2.getTile())) {
                                    Float f5 = bestTilesInfo.getTileRankMap().get(it2.getTile());
                                    Intrinsics.checkNotNull(f5);
                                    f4 = f5;
                                } else {
                                    f4 = Float.valueOf(-1.0f);
                                }
                                Float f6 = f4;
                                Intrinsics.checkNotNull(f6);
                                Comparable v$iv = Float.valueOf(((Number)f6).floatValue());
                                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            object = maxElem$iv;
                        }
                    }
                    MapUnit bestSettlerInRange = (MapUnit)object;
                    if (Intrinsics.areEqual(bestSettlerInRange, unit)) {
                        UnitAction unitAction2 = foundCityAction22;
                        if ((unitAction2 != null ? unitAction2.getAction() : null) != null) {
                            ((UnitAction)foundCityAction22).getAction().invoke();
                            return;
                        }
                    }
                    if (bestSettlerInRange != null) {
                        void $this$filterTo$iv$iv;
                        Iterator $this$filter$iv;
                        $this$maxByOrNull$iv = bestTilesInfo.getTileRankMap();
                        CityLocationTileRanker.BestTilesToFoundCity bestTilesToFoundCity = bestTilesInfo;
                        boolean $i$f$filter = false;
                        iterator$iv = $this$filter$iv;
                        Map destination$iv$iv = new LinkedHashMap();
                        boolean $i$f$filterTo = false;
                        e$iv = $this$filterTo$iv$iv.entrySet().iterator();
                        while (e$iv.hasNext()) {
                            Map.Entry element$iv$iv;
                            Map.Entry it = element$iv$iv = (Map.Entry)e$iv.next();
                            boolean bl = false;
                            if (!(((Tile)it.getKey()).aerialDistanceTo(bestSettlerInRange.getTile()) > 4)) continue;
                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                        }
                        Map map2 = destination$iv$iv;
                        bestTilesToFoundCity.setTileRankMap(new HashMap<Tile, Float>(map2));
                    }
                }
                if (!bestTilesInfo.getTileRankMap().containsKey(unit.getTile())) break block38;
                if (bestTilesInfo.getBestTile() == null) break block39;
                Float f = bestTilesInfo.getTileRankMap().get(unit.getTile());
                Intrinsics.checkNotNull(f);
                if (!(((Number)f).floatValue() >= bestTilesInfo.getBestTileRank() - (float)2)) break block38;
            }
            bestCityLocation = unit.getTile();
        }
        if (bestCityLocation == null && bestTilesInfo.getBestTile() != null) {
            UnitMovement unitMovement = unit.getMovement();
            Tile tile = bestTilesInfo.getBestTile();
            Intrinsics.checkNotNull(tile);
            int foundCityAction22 = UnitMovement.getShortestPath$default(unitMovement, tile, false, 2, null).size();
            boolean bl = 1 <= foundCityAction22 ? foundCityAction22 < 4 : false;
            if (bl) {
                bestCityLocation = bestTilesInfo.getBestTile();
            }
        }
        if (bestCityLocation == null) {
            Object v11;
            block37: {
                void $this$firstOrNull$iv;
                Sequence $this$sortedByDescending$iv;
                Set<Map.Entry<Tile, Float>> set2 = bestTilesInfo.getTileRankMap().entrySet();
                Intrinsics.checkNotNullExpressionValue(set2, "<get-entries>(...)");
                allUnsettledSettlers2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)set2), (Function1)new Function1<Map.Entry<Tile, Float>, Boolean>(bestTilesInfo){
                    final /* synthetic */ CityLocationTileRanker.BestTilesToFoundCity $bestTilesInfo;
                    {
                        this.$bestTilesInfo = $bestTilesInfo;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull Map.Entry<Tile, Float> it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (this.$bestTilesInfo.getBestTile() != null) {
                            Float f = it.getValue();
                            Intrinsics.checkNotNullExpressionValue(f, "<get-value>(...)");
                            if (!(((Number)f).floatValue() >= this.$bestTilesInfo.getBestTileRank() - (float)5)) {
                                bl = false;
                                return bl;
                            }
                        }
                        bl = true;
                        return bl;
                    }
                });
                boolean $i$f$sortedByDescending = false;
                $this$sortedByDescending$iv = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)b;
                        boolean bl = false;
                        Comparable comparable = (Float)it.getValue();
                        it = (Map.Entry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getValue()));
                    }
                });
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry p0 = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!SpecificUnitAutomation.automateSettlerActions$isTileRankOK(dangerousTiles, unit, p0)) continue;
                    v11 = element$iv;
                    break block37;
                }
                v11 = null;
            }
            foundCityAction22 = v11;
            Tile tile = bestCityLocation = foundCityAction22 != null ? (Tile)foundCityAction22.getKey() : null;
        }
        if (bestCityLocation == null && bestTilesInfo.getBestTile() != null) {
            UnitMovement unitMovement = unit.getMovement();
            Tile tile = bestTilesInfo.getBestTile();
            Intrinsics.checkNotNull(tile);
            int foundCityAction22 = UnitMovement.getShortestPath$default(unitMovement, tile, false, 2, null).size();
            boolean bl = 1 <= foundCityAction22 ? foundCityAction22 < 9 : false;
            if (bl) {
                bestCityLocation = bestTilesInfo.getBestTile();
            }
        }
        if (bestCityLocation == null) {
            Object v16;
            Iterable $this$maxByOrNull$iv = unit.getCiv().getCities();
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v16 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v16 = maxElem$iv;
                } else {
                    City it = (City)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = SpecificUnitAutomation.automateSettlerActions$getFrontierScore(it);
                    do {
                        Object e$iv = iterator$iv.next();
                        City it3 = (City)e$iv;
                        $i$a$-maxByOrNull-SpecificUnitAutomation$automateSettlerActions$frontierCity$1 = false;
                        int v$iv = SpecificUnitAutomation.automateSettlerActions$getFrontierScore(it3);
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v16 = maxElem$iv;
                }
            }
            City frontierCity = v16;
            if (frontierCity != null && SpecificUnitAutomation.automateSettlerActions$getFrontierScore(frontierCity) > 0 && unit.getMovement().canReach(frontierCity.getCenterTile())) {
                unit.getMovement().headTowards(frontierCity.getCenterTile());
            }
            if (UnitAutomation.INSTANCE.tryExplore$core(unit)) {
                return;
            }
            UnitAutomation.wander$default(UnitAutomation.INSTANCE, unit, false, dangerousTiles, 2, null);
            return;
        }
        UnitAction unitAction3 = foundCityAction = UnitActionsFromUniques.INSTANCE.getFoundCityAction$core(unit, bestCityLocation);
        if ((unitAction3 != null ? unitAction3.getAction() : null) == null) {
            if (unit.hasMovement() && !unit.getCiv().isOneCityChallenger()) {
                throw new Exception("City within distance");
            }
            return;
        }
        boolean bl = shouldSettle = Intrinsics.areEqual(unit.getTile(), bestCityLocation) && unit.hasMovement();
        if (shouldSettle) {
            foundCityAction.getAction().invoke();
            return;
        }
        if (CivilianUnitAutomation.INSTANCE.tryRunAwayIfNeccessary(unit)) {
            return;
        }
        unit.getMovement().headTowards(bestCityLocation);
        if (shouldSettle) {
            foundCityAction.getAction().invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean automateImprovementPlacer(@NotNull MapUnit unit) {
        Object object;
        Object v2;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Unique unique = (Unique)SequencesKt.firstOrNull(MapUnit.getMatchingUniques$default(unit, UniqueType.ConstructImprovementInstantly, null, false, 6, null));
        if (unique == null) {
            return false;
        }
        Unique improvementBuildingUnique = unique;
        String improvementName = improvementBuildingUnique.getParams().get(0);
        TileImprovement tileImprovement = unit.getCiv().getGameInfo().getRuleset().getTileImprovements().get(improvementName);
        if (tileImprovement == null) {
            return false;
        }
        TileImprovement improvement2 = tileImprovement;
        Iterable $this$maxByOrNull$iv = improvement2;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                Stats.StatValuePair it = (Stats.StatValuePair)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = it.getValue();
                do {
                    Object e$iv = iterator$iv.next();
                    Stats.StatValuePair it2 = (Stats.StatValuePair)e$iv;
                    boolean bl2 = false;
                    float v$iv = it2.getValue();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        if ((object = (Stats.StatValuePair)v2) == null || (object = ((Stats.StatValuePair)object).getKey()) == null) {
            object = Stat.Culture;
        }
        Object relatedStat = object;
        Iterable $this$sortedByDescending$iv = unit.getCiv().getCities();
        boolean $i$f$sortedByDescending = false;
        List<City> citiesByStatBoost = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator((Stat)relatedStat){
            final /* synthetic */ Stat $relatedStat$inlined;
            {
                this.$relatedStat$inlined = stat;
            }

            public final int compare(T a, T b) {
                City it = (City)b;
                boolean bl = false;
                Comparable comparable = Float.valueOf(it.getCityStats().getStatPercentBonusTree().getTotalStats().get(this.$relatedStat$inlined));
                it = (City)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)Float.valueOf(it.getCityStats().getStatPercentBonusTree().getTotalStats().get(this.$relatedStat$inlined)));
            }
        });
        Collection<Terrain> collection = unit.getCiv().getGameInfo().getRuleset().getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        double averageTerrainStatsValue2 = SequencesKt.averageOfFloat(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), automateImprovementPlacer.averageTerrainStatsValue.1.INSTANCE), (Function1)new Function1<Terrain, Float>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Float invoke(@NotNull Terrain it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Float.valueOf(Automation.INSTANCE.rankStatsValue(it, this.$unit.getCiv()));
            }
        }));
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        for (City city2 : citiesByStatBoost) {
            Object v7;
            block19: {
                void $this$firstOrNull$iv;
                List pathToCity;
                Sequence<Tile> applicableTiles2 = SequencesKt.filter(city2.getWorkableTiles(), (Function1)new Function1<Tile, Boolean>(unit, improvement2, localUniqueCache, averageTerrainStatsValue2){
                    final /* synthetic */ MapUnit $unit;
                    final /* synthetic */ TileImprovement $improvement;
                    final /* synthetic */ LocalUniqueCache $localUniqueCache;
                    final /* synthetic */ double $averageTerrainStatsValue;
                    {
                        this.$unit = $unit;
                        this.$improvement = $improvement;
                        this.$localUniqueCache = $localUniqueCache;
                        this.$averageTerrainStatsValue = $averageTerrainStatsValue;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Tile it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return it.isLand() && it.getResource() == null && !it.isCityCenter() && (Intrinsics.areEqual(this.$unit.getCurrentTile(), it) || UnitMovement.canMoveTo$default(this.$unit.getMovement(), it, false, false, false, 14, null)) && it.getImprovement() == null && it.getImprovementFunctions().canBuildImprovement(this.$improvement, this.$unit.getCiv()) && (double)Automation.INSTANCE.rankTile$core(it, this.$unit.getCiv(), this.$localUniqueCache) > this.$averageTerrainStatsValue;
                    }
                });
                if (SequencesKt.none(applicableTiles2) || (pathToCity = UnitMovement.getShortestPath$default(unit.getMovement(), city2.getCenterTile(), false, 2, null)).isEmpty()) continue;
                if (pathToCity.size() > 2 && !Intrinsics.areEqual(unit.getTile().getCity(), city2)) {
                    boolean enemyUnitsNearby;
                    block18: {
                        boolean bl;
                        Sequence<Tile> $this$any$iv = unit.getTile().getTilesInDistance(5);
                        boolean $i$f$any = false;
                        Iterator<Tile> iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            boolean bl3;
                            block17: {
                                Tile element$iv;
                                Tile tileNearby = element$iv = iterator2.next();
                                boolean bl32 = false;
                                Sequence<MapUnit> $this$any$iv2 = tileNearby.getUnits();
                                boolean $i$f$any2 = false;
                                Iterator<MapUnit> iterator3 = $this$any$iv2.iterator();
                                while (iterator3.hasNext()) {
                                    MapUnit element$iv2;
                                    MapUnit unitOnTileNearby = element$iv2 = iterator3.next();
                                    boolean bl4 = false;
                                    if (!(unitOnTileNearby.isMilitary() && unitOnTileNearby.getCiv().isAtWarWith(unit.getCiv()))) continue;
                                    bl3 = true;
                                    break block17;
                                }
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            bl = true;
                            break block18;
                        }
                        bl = enemyUnitsNearby = false;
                    }
                    if (unit.getTile().getMilitaryUnit() == null && enemyUnitsNearby) {
                        return true;
                    }
                    unit.getMovement().headTowards(city2.getCenterTile());
                    return true;
                }
                Sequence<Tile> $this$sortedByDescending$iv2 = applicableTiles2;
                boolean $i$f$sortedByDescending2 = false;
                $this$sortedByDescending$iv2 = SequencesKt.sortedWith($this$sortedByDescending$iv2, new Comparator(unit, localUniqueCache){
                    final /* synthetic */ MapUnit $unit$inlined;
                    final /* synthetic */ LocalUniqueCache $localUniqueCache$inlined;
                    {
                        this.$unit$inlined = mapUnit;
                        this.$localUniqueCache$inlined = localUniqueCache;
                    }

                    public final int compare(T a, T b) {
                        Tile it = (Tile)b;
                        boolean bl = false;
                        Comparable comparable = Float.valueOf(Automation.INSTANCE.rankTile$core(it, this.$unit$inlined.getCiv(), this.$localUniqueCache$inlined));
                        it = (Tile)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)Float.valueOf(Automation.INSTANCE.rankTile$core(it, this.$unit$inlined.getCiv(), this.$localUniqueCache$inlined)));
                    }
                });
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Tile it = (Tile)element$iv;
                    boolean bl = false;
                    if (!unit.getMovement().canReach(it)) continue;
                    v7 = element$iv;
                    break block19;
                }
                v7 = null;
            }
            Tile tile = v7;
            if (tile == null) continue;
            Tile chosenTile = tile;
            Tile unitTileBeforeMovement = unit.getCurrentTile();
            unit.getMovement().headTowards(chosenTile);
            if (Intrinsics.areEqual(unit.getCurrentTile(), chosenTile)) {
                if (unit.getCurrentTile().isPillaged()) {
                    UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.Repair);
                } else {
                    UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.CreateImprovement);
                }
                return true;
            }
            return !Intrinsics.areEqual(unitTileBeforeMovement, unit.getCurrentTile());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean conductTradeMission(@NotNull MapUnit unit) {
        Object object;
        Object v1;
        void $this$minByOrNull$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Iterable iterable = unit.getCiv().getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        void var6_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !Intrinsics.areEqual(it, unit.getCiv()) && !unit.getCiv().isAtWarWith((Civilization)it) && ((Civilization)it).isCityState() && !((Collection)((Civilization)it).getCities()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapSequence = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            Sequence<Tile> list$iv$iv = ((Civilization)it).getCities().get(0).getTiles();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tile)element$iv$iv;
            boolean bl = false;
            if (!unit.getCiv().hasExplored((Tile)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Pair<Tile, Integer> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Tile tile = (Tile)element$iv$iv;
            boolean bl3 = false;
            List path = UnitMovement.getShortestPath$default(unit.getMovement(), tile, false, 2, null);
            int n = path.size();
            if (((1 <= n ? n < 11 : false) ? TuplesKt.to(tile, path.size()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                Pair it2 = (Pair)minElem$iv;
                boolean bl = false;
                int minValue$iv = ((Number)it2.getSecond()).intValue();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair it3 = (Pair)e$iv;
                    $i$a$-minByOrNull-SpecificUnitAutomation$conductTradeMission$closestCityStateTile$5 = false;
                    int v$iv = ((Number)it3.getSecond()).intValue();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        if ((object = (Pair)v1) == null || (object = (Tile)((Pair)object).getFirst()) == null) {
            return false;
        }
        Object closestCityStateTile = object;
        boolean conductedTradeMission = UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.ConductTradeMission);
        if (conductedTradeMission) {
            return true;
        }
        Tile unitTileBeforeMovement = unit.getCurrentTile();
        unit.getMovement().headTowards((Tile)closestCityStateTile);
        return !Intrinsics.areEqual(unitTileBeforeMovement, unit.getCurrentTile());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean speedupWonderConstruction(@NotNull MapUnit unit) {
        City city2;
        Object v1;
        void $this$minByOrNull$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object city3;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Iterable $this$filter$iv = unit.getCiv().getCities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            city3 = (City)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((City)city3).getPopulation().getPopulation() >= 3 && (UnitMovement.canMoveTo$default(unit.getMovement(), ((City)city3).getCenterTile(), false, false, false, 14, null) || Intrinsics.areEqual(unit.getCurrentTile(), ((City)city3).getCenterTile())) && INSTANCE.getWonderThatWouldBenefitFromBeingSpedUp((City)city3) != null;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        city3 = $this$forEach$iv$iv$iv.iterator();
        while (city3.hasNext()) {
            Pair<City, Integer> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = city3.next();
            boolean bl = false;
            City city4 = (City)element$iv$iv;
            boolean bl3 = false;
            List path = UnitMovement.getShortestPath$default(unit.getMovement(), city4.getCenterTile(), false, 2, null);
            if ((CollectionsKt.any(path) && path.size() <= 5 ? TuplesKt.to(city4, path.size()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                Pair it = (Pair)minElem$iv;
                boolean bl = false;
                int minValue$iv = ((Number)it.getSecond()).intValue();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair it2 = (Pair)e$iv;
                    $i$a$-minByOrNull-SpecificUnitAutomation$speedupWonderConstruction$nearbyCityWithAvailableWonders$3 = false;
                    int v$iv = ((Number)it2.getSecond()).intValue();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        Pair pair = v1;
        if (pair == null || (city2 = (City)pair.getFirst()) == null) {
            return false;
        }
        City nearbyCityWithAvailableWonders = city2;
        if (Intrinsics.areEqual(unit.getCurrentTile(), nearbyCityWithAvailableWonders.getCenterTile())) {
            Building building = this.getWonderThatWouldBenefitFromBeingSpedUp(nearbyCityWithAvailableWonders);
            Intrinsics.checkNotNull(building);
            Building wonderToHurry = building;
            nearbyCityWithAvailableWonders.getCityConstructions().getConstructionQueue().add(0, wonderToHurry.getName());
            return UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.HurryBuilding) || UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.HurryWonder);
        }
        Tile tileBeforeMoving = unit.getTile();
        unit.getMovement().headTowards(nearbyCityWithAvailableWonders.getCenterTile());
        return !Intrinsics.areEqual(tileBeforeMoving, unit.getCurrentTile());
    }

    private final Building getWonderThatWouldBenefitFromBeingSpedUp(City city2) {
        Sequence<Building> $this$sortedBy$iv = SequencesKt.filter(city2.getCityConstructions().getBuildableBuildings$core(), (Function1)new Function1<Building, Boolean>(city2){
            final /* synthetic */ City $city;
            {
                this.$city = $city;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Building building) {
                Intrinsics.checkNotNullParameter(building, "building");
                return building.isWonder() && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)building, UniqueType.CannotBeHurried, null, 2, null) && CityConstructions.turnsToConstruction$default(this.$city.getCityConstructions(), building.getName(), false, 2, null) >= 5;
            }
        });
        boolean $i$f$sortedBy = false;
        return SequencesKt.firstOrNull(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(city2){
            final /* synthetic */ City $city$inlined;
            {
                this.$city$inlined = city2;
            }

            public final int compare(T a, T b) {
                Building it = (Building)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(-CityConstructions.getRemainingWork$default(this.$city$inlined.getCityConstructions(), it.getName(), false, 2, null));
                it = (Building)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, -CityConstructions.getRemainingWork$default(this.$city$inlined.getCityConstructions(), it.getName(), false, 2, null));
            }
        }));
    }

    public final void automateAddInCapital(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (Civilization.getCapital$default(unit.getCiv(), false, 1, null) == null) {
            return;
        }
        City city2 = Civilization.getCapital$default(unit.getCiv(), false, 1, null);
        Intrinsics.checkNotNull(city2);
        Tile capitalTile = city2.getCenterTile();
        if (unit.getMovement().canReach(capitalTile)) {
            unit.getMovement().headTowards(capitalTile);
        }
        if (Intrinsics.areEqual(unit.getTile(), capitalTile)) {
            UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.AddInCapital);
        }
    }

    private static final boolean automateSettlerActions$isTileRankOK(HashSet<Tile> $dangerousTiles, MapUnit $unit, Map.Entry<Tile, Float> it) {
        if ($dangerousTiles.contains(it.getKey()) && !Intrinsics.areEqual(it.getKey(), $unit.getTile())) {
            return false;
        }
        int pathSize = UnitMovement.getShortestPath$default($unit.getMovement(), it.getKey(), false, 2, null).size();
        return 1 <= pathSize ? pathSize < 4 : false;
    }

    /*
     * WARNING - void declaration
     */
    private static final int automateSettlerActions$getFrontierScore(City city2) {
        void var3_3;
        Sequence<Tile> $this$count$iv = city2.getCenterTile().getTilesAtDistance(city2.getCiv().getGameInfo().getRuleset().getModOptions().getConstants().getMinimalCityDistance() + 1);
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<Tile> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            Tile element$iv;
            Tile it = element$iv = iterator2.next();
            boolean bl = false;
            if (!(it.canBeSettled() && (it.getOwner() == null || Intrinsics.areEqual(it.getOwner(), city2.getCiv()))) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return (int)var3_3;
    }
}

