/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.battle.AirInterception;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J/\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/battle/AirInterception;", "", "()V", "addAirSweepInterceptionNotifications", "", "attacker", "Lcom/unciv/logic/battle/MapUnitCombatant;", "interceptor", "Lcom/unciv/logic/map/mapunit/MapUnit;", "damageDealt", "Lcom/unciv/logic/battle/Battle$DamageDealt;", "locationsInterceptorUnknown", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/civilization/LocationAction;", "locations", "addInterceptionNotifications", "damage", "", "airSweep", "attackedTile", "Lcom/unciv/logic/map/tile/Tile;", "tryInterceptAirAttack", "interceptingCiv", "Lcom/unciv/logic/civilization/Civilization;", "defender", "Lcom/unciv/logic/battle/ICombatant;", "tryInterceptAirAttack$core", "core"})
@SourceDebugExtension(value={"SMAP\nAirInterception.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AirInterception.kt\ncom/unciv/logic/battle/AirInterception\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,223:1\n766#2:224\n857#2,2:225\n1247#3,2:227\n614#3:229\n614#3:230\n179#3:231\n2159#3,2:232\n180#3:234\n*S KotlinDebug\n*F\n+ 1 AirInterception.kt\ncom/unciv/logic/battle/AirInterception\n*L\n41#1:224\n41#1:225,2\n47#1:227,2\n53#1:229\n158#1:230\n159#1:231\n163#1:232,2\n159#1:234\n*E\n"})
public final class AirInterception {
    @NotNull
    public static final AirInterception INSTANCE = new AirInterception();

    private AirInterception() {
    }

    /*
     * WARNING - void declaration
     */
    public final void airSweep(@NotNull MapUnitCombatant attacker, @NotNull Tile attackedTile) {
        void $this$sortedByDescending$iv;
        boolean bl;
        Object element$iv22;
        Iterator $this$any$iv;
        Sequence<Object> potentialInterceptors2;
        String attackerName;
        block9: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter(attacker, "attacker");
            Intrinsics.checkNotNullParameter(attackedTile, "attackedTile");
            MapUnit mapUnit = attacker.getUnit();
            int n = mapUnit.getAttacksThisTurn();
            mapUnit.setAttacksThisTurn(n + 1);
            if (MapUnit.hasUnique$default(attacker.getUnit(), UniqueType.CanMoveAfterAttacking, null, false, 6, null) || attacker.getUnit().maxAttacksPerTurn() > attacker.getUnit().getAttacksThisTurn()) {
                if (!attacker.getUnit().getBaseUnit().getMovesLikeAirUnits()) {
                    attacker.getUnit().useMovementPoints(1.0f);
                }
            } else {
                attacker.getUnit().setCurrentMovement(0.0f);
            }
            attackerName = attacker.getName();
            potentialInterceptors2 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super MapUnit>, Continuation<? super Unit>, Object>(null){
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super MapUnit> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
            Iterable iterable = attacker.getCivInfo().getGameInfo().getCivilizations();
            boolean $i$f$filter22 = false;
            void var8_13 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Civilization it = (Civilization)element$iv$iv;
                boolean bl2 = false;
                if (!attacker.getCivInfo().isAtWarWith(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Civilization interceptingCiv : (List)destination$iv$iv) {
                potentialInterceptors2 = SequencesKt.plus(potentialInterceptors2, SequencesKt.filter(interceptingCiv.getUnits().getCivUnits(), (Function1)new Function1<MapUnit, Boolean>(attackedTile){
                    final /* synthetic */ Tile $attackedTile;
                    {
                        this.$attackedTile = $attackedTile;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull MapUnit it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return it.canIntercept(this.$attackedTile);
                    }
                }));
            }
            $this$any$iv = potentialInterceptors2;
            boolean $i$f$any = false;
            Iterator $i$f$filter22 = $this$any$iv.iterator();
            while ($i$f$filter22.hasNext()) {
                element$iv22 = $i$f$filter22.next();
                MapUnit it = (MapUnit)element$iv22;
                boolean bl3 = false;
                if (!it.getBaseUnit().isAirUnit()) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            potentialInterceptors2 = SequencesKt.filter(potentialInterceptors2, airSweep.4.INSTANCE);
        }
        Sequence $i$f$any = SequencesKt.shuffled(potentialInterceptors2);
        boolean $i$f$sortedByDescending = false;
        $this$any$iv = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                MapUnit it = (MapUnit)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.interceptChance());
                it = (MapUnit)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.interceptChance());
            }
        }).iterator();
        if ($this$any$iv.hasNext()) {
            MapUnit interceptor2 = (MapUnit)$this$any$iv.next();
            element$iv22 = new Vector2[]{interceptor2.getCurrentTile().getPosition(), attacker.getUnit().getCurrentTile().getPosition()};
            Sequence<LocationAction> locations = LocationAction.Companion.invoke((Vector2)element$iv22);
            int element$iv22 = interceptor2.getAttacksThisTurn();
            interceptor2.setAttacksThisTurn(element$iv22 + 1);
            if (!interceptor2.getBaseUnit().isAirUnit()) {
                String interceptorName = interceptor2.getName();
                String attackerText = "Our [" + attackerName + "] ([-0] HP) was attacked by an intercepting [" + interceptorName + "] ([-0] HP)";
                String interceptorText = "Our [" + interceptorName + "] ([-0] HP) intercepted and attacked an enemy [" + attackerName + "] ([-0] HP)";
                String[] stringArray = new String[]{attackerName, "OtherIcons/Pillage", interceptorName};
                attacker.getCivInfo().addNotification(attackerText, locations, Notification.NotificationCategory.War, stringArray);
                stringArray = new String[]{interceptorName, "OtherIcons/Pillage", attackerName};
                interceptor2.getCiv().addNotification(interceptorText, locations, Notification.NotificationCategory.War, stringArray);
                attacker.getUnit().setAction(null);
                return;
            }
            Battle.DamageDealt damageDealt = Battle.INSTANCE.takeDamage$core(attacker, new MapUnitCombatant(interceptor2));
            Battle.INSTANCE.addXp$core(new MapUnitCombatant(interceptor2), 5, attacker);
            Battle.INSTANCE.addXp$core(attacker, 5, new MapUnitCombatant(interceptor2));
            Vector2[] vector2Array = new Vector2[]{attackedTile.getPosition(), attacker.getUnit().getCurrentTile().getPosition()};
            Sequence<LocationAction> locationsInterceptorUnknown = LocationAction.Companion.invoke(vector2Array);
            this.addAirSweepInterceptionNotifications(attacker, interceptor2, damageDealt, locationsInterceptorUnknown, locations);
            attacker.getUnit().setAction(null);
            return;
        }
        String attackerText = "Nothing tried to intercept our [" + attackerName + ']';
        String[] stringArray = new String[]{attackerName};
        attacker.getCivInfo().addNotification(attackerText, Notification.NotificationCategory.War, stringArray);
        attacker.getUnit().setAction(null);
    }

    private final void addAirSweepInterceptionNotifications(MapUnitCombatant attacker, MapUnit interceptor2, Battle.DamageDealt damageDealt, Sequence<LocationAction> locationsInterceptorUnknown, Sequence<LocationAction> locations) {
        String attackerName = attacker.getName();
        String interceptorName = interceptor2.getName();
        String attackerText = attacker.isDefeated() ? (attacker.getCivInfo().getViewableTiles().contains(interceptor2.getTile()) ? "Our [" + attackerName + "] ([-" + damageDealt.getDefenderDealt() + "] HP) was destroyed by an intercepting [" + interceptorName + "] ([-" + damageDealt.getAttackerDealt() + "] HP)" : "Our [" + attackerName + "] ([-" + damageDealt.getDefenderDealt() + "] HP) was destroyed by an unknown interceptor") : (new MapUnitCombatant(interceptor2).isDefeated() ? "Our [" + attackerName + "] ([-" + damageDealt.getDefenderDealt() + "] HP) destroyed an intercepting [" + interceptorName + "] ([-" + damageDealt.getAttackerDealt() + "] HP)" : "Our [" + attackerName + "] ([-" + damageDealt.getDefenderDealt() + "] HP) was attacked by an intercepting [" + interceptorName + "] ([-" + damageDealt.getAttackerDealt() + "] HP)");
        String[] stringArray = new String[]{attackerName, "OtherIcons/Pillage", "OtherIcons/Question"};
        attacker.getCivInfo().addNotification(attackerText, locationsInterceptorUnknown, Notification.NotificationCategory.War, stringArray);
        String interceptorText = attacker.isDefeated() ? "Our [" + interceptorName + "] ([-" + damageDealt.getAttackerDealt() + "] HP) intercepted and destroyed an enemy [" + attackerName + "] ([-" + damageDealt.getDefenderDealt() + "] HP)" : (new MapUnitCombatant(interceptor2).isDefeated() ? (interceptor2.getCiv().getViewableTiles().contains(attacker.getTile()) ? "Our [" + interceptorName + "] ([-" + damageDealt.getAttackerDealt() + "] HP) intercepted and was destroyed by an enemy [" + attackerName + "] ([-" + damageDealt.getDefenderDealt() + "] HP)" : "Our [" + interceptorName + "] ([-" + damageDealt.getAttackerDealt() + "] HP) intercepted and was destroyed by an unknown enemy") : "Our [" + interceptorName + "] ([-" + damageDealt.getAttackerDealt() + "] HP) intercepted and attacked an enemy [" + attackerName + "] ([-" + damageDealt.getDefenderDealt() + "] HP)");
        String[] stringArray2 = new String[]{interceptorName, "OtherIcons/Pillage", attackerName};
        interceptor2.getCiv().addNotification(interceptorText, locations, Notification.NotificationCategory.War, stringArray2);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Battle.DamageDealt tryInterceptAirAttack$core(@NotNull MapUnitCombatant attacker, @NotNull Tile attackedTile, @NotNull Civilization interceptingCiv, @Nullable ICombatant defender) {
        block9: {
            Intrinsics.checkNotNullParameter(attacker, "attacker");
            Intrinsics.checkNotNullParameter(attackedTile, "attackedTile");
            Intrinsics.checkNotNullParameter(interceptingCiv, "interceptingCiv");
            if (MapUnit.hasUnique$default(attacker.getUnit(), UniqueType.CannotBeIntercepted, new StateForConditionals(attacker.getCivInfo(), null, null, null, attacker, defender, attackedTile, null, null, null, false, 1934, null), false, 4, null)) {
                return Battle.DamageDealt.Companion.getNone();
            }
            var7_5 = SequencesKt.filter(interceptingCiv.getUnits().getCivUnits(), (Function1)new Function1<MapUnit, Boolean>(attackedTile){
                final /* synthetic */ Tile $attackedTile;
                {
                    this.$attackedTile = $attackedTile;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull MapUnit it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.canIntercept(this.$attackedTile);
                }
            });
            $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    MapUnit it = (MapUnit)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.interceptChance());
                    it = (MapUnit)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.interceptChance());
                }
            });
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                block8: {
                    unit = (MapUnit)element$iv;
                    $i$a$-firstOrNull-AirInterception$tryInterceptAirAttack$interceptor$3 = false;
                    var13_12 = new MapUnitCombatant(unit);
                    var14_14 = CombatAction.Intercept;
                    conditionalState = new StateForConditionals(interceptingCiv, null, null, null, (ICombatant)var13_12, attacker, attackedTile, var14_14, null, null, false, 1806, null);
                    var13_12 = MapUnit.getMatchingUniques$default(unit, UniqueType.CannotInterceptUnits, conditionalState, false, 4, null);
                    $i$f$none = false;
                    for (T element$iv : $this$none$iv) {
                        it = (Unique)element$iv;
                        $i$a$-none-AirInterception$tryInterceptAirAttack$interceptor$3$1 = false;
                        if (!ICombatant.DefaultImpls.matchesFilter$default(attacker, it.getParams().get(0), false, 2, null)) continue;
                        v0 = false;
                        break block8;
                    }
                    v0 = true;
                }
                if (!v0) ** GOTO lbl-1000
                v1 = defender instanceof MapUnitCombatant != false ? (MapUnitCombatant)defender : null;
                if (!Intrinsics.areEqual(unit, v1 != null ? v1.getUnit() : null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block9;
            }
            v3 = null;
        }
        v4 = v3;
        if (v4 == null) {
            return Battle.DamageDealt.Companion.getNone();
        }
        interceptor = v4;
        var6_21 = interceptor.getAttacksThisTurn();
        interceptor.setAttacksThisTurn(var6_21 + 1);
        if (Random.Default.nextFloat() > (float)interceptor.interceptChance() / 100.0f) {
            return Battle.DamageDealt.Companion.getNone();
        }
        damage = BattleDamage.calculateDamageToDefender$default(BattleDamage.INSTANCE, new MapUnitCombatant(interceptor), attacker, null, 0.0f, 12, null);
        damageFactor = 1.0f + (float)interceptor.interceptDamagePercentBonus() / 100.0f;
        damage = RangesKt.coerceAtMost((int)((float)damage * (damageFactor *= attacker.getUnit().receivedInterceptDamageFactor())), attacker.getUnit().getHealth());
        attacker.takeDamage(damage);
        if (damage > 0) {
            Battle.INSTANCE.addXp$core(new MapUnitCombatant(interceptor), 2, attacker);
        }
        this.addInterceptionNotifications(attacker, interceptor, damage);
        return new Battle.DamageDealt(0, damage);
    }

    private final void addInterceptionNotifications(MapUnitCombatant attacker, MapUnit interceptor2, int damage) {
        String attackerName = attacker.getName();
        String interceptorName = interceptor2.getName();
        Vector2[] vector2Array = new Vector2[]{interceptor2.getCurrentTile().getPosition(), attacker.getUnit().getCurrentTile().getPosition()};
        Sequence<LocationAction> locations = LocationAction.Companion.invoke(vector2Array);
        String attackerText = !attacker.isDefeated() ? "Our [" + attackerName + "] ([-" + damage + "] HP) was attacked by an intercepting [" + interceptorName + "] ([-0] HP)" : (attacker.getCivInfo().getViewableTiles().contains(interceptor2.getTile()) ? "Our [" + attackerName + "] ([-" + damage + "] HP) was destroyed by an intercepting [" + interceptorName + "] ([-0] HP)" : "Our [" + attackerName + "] ([-" + damage + "] HP) was destroyed by an unknown interceptor");
        String[] stringArray = new String[]{attackerName, "OtherIcons/Pillage", interceptorName};
        attacker.getCivInfo().addNotification(attackerText, interceptor2.getCurrentTile().getPosition(), Notification.NotificationCategory.War, stringArray);
        String interceptorText = attacker.isDefeated() ? "Our [" + interceptorName + "] ([-0] HP) intercepted and destroyed an enemy [" + attackerName + "] ([-" + damage + "] HP)" : "Our [" + interceptorName + "] ([-0] HP) intercepted and attacked an enemy [" + attackerName + "] ([-" + damage + "] HP)";
        String[] stringArray2 = new String[]{interceptorName, "OtherIcons/Pillage", attackerName};
        interceptor2.getCiv().addNotification(interceptorText, locations, Notification.NotificationCategory.War, stringArray2);
    }
}

