/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.GreatGeneralImplementation;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.GlobalUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J.\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J6\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0016\u001a\u00020\u0017J*\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0016\u001a\u00020\u0017J \u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\rJ$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010!\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ.\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\rH\u0002J\u0010\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020(H\u0002J \u0010)\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002J \u0010*\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010+\u001a\u00020\u00172\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a8\u0006,"}, d2={"Lcom/unciv/logic/battle/BattleDamage;", "", "()V", "addResourceLackingMalus", "", "combatant", "Lcom/unciv/logic/battle/MapUnitCombatant;", "modifiers", "Lcom/unciv/models/Counter;", "", "addTerrainAttackModifiers", "attacker", "defender", "Lcom/unciv/logic/battle/ICombatant;", "tileToAttackFrom", "Lcom/unciv/logic/map/tile/Tile;", "addUnitUniqueModifiers", "enemy", "conditionalState", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "calculateDamageToAttacker", "", "randomnessFactor", "", "calculateDamageToDefender", "damageModifier", "attackerToDefenderRatio", "damageToAttacker", "", "getAirSweepAttackModifiers", "getAttackModifiers", "getAttackingStrength", "getDefenceModifiers", "getDefendingStrength", "getGeneralModifiers", "combatAction", "Lcom/unciv/logic/battle/CombatAction;", "getHealthDependantDamageRatio", "getModifierStringFromUnique", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "getStateForConditionals", "isMeleeAttackingAcrossRiverWithNoBridge", "modifiersToFinalBonus", "core"})
@SourceDebugExtension(value={"SMAP\nBattleDamage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleDamage.kt\ncom/unciv/logic/battle/BattleDamage\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,329:1\n1247#2,2:330\n1433#2,14:332\n1268#2,3:346\n*S KotlinDebug\n*F\n+ 1 BattleDamage.kt\ncom/unciv/logic/battle/BattleDamage\n*L\n51#1:330,2\n123#1:332,14\n152#1:346,3\n*E\n"})
public final class BattleDamage {
    @NotNull
    public static final BattleDamage INSTANCE = new BattleDamage();

    private BattleDamage() {
    }

    private final String getModifierStringFromUnique(Unique unique) {
        String string;
        UniqueTarget uniqueTarget = unique.getSourceObjectType();
        switch (uniqueTarget == null ? -1 : WhenMappings.$EnumSwitchMapping$0[uniqueTarget.ordinal()]) {
            case 1: {
                string = "Unit ability";
                break;
            }
            case 2: {
                string = "National ability";
                break;
            }
            case 3: {
                string = GlobalUniques.Companion.getUniqueSourceDescription(unique);
                break;
            }
            default: {
                string = '[' + unique.getSourceObjectName() + "] ([" + unique.getSourceNameForUser() + "])";
            }
        }
        String source = TranslationsKt.tr$default(string, false, false, 3, null);
        if (unique.getModifiers().isEmpty()) {
            return source;
        }
        String conditionalsText2 = CollectionsKt.joinToString$default(unique.getModifiers(), null, null, null, 0, null, getModifierStringFromUnique.conditionalsText.1.INSTANCE, 31, null);
        return source + " - " + conditionalsText2;
    }

    private final Counter<String> getGeneralModifiers(ICombatant combatant, ICombatant enemy, CombatAction combatAction, Tile tileToAttackFrom) {
        Counter<String> modifiers = new Counter<String>(null, 1, null);
        StateForConditionals conditionalState = this.getStateForConditionals(combatAction, combatant, enemy);
        Civilization civInfo = combatant.getCivInfo();
        if (combatant instanceof MapUnitCombatant) {
            this.addUnitUniqueModifiers((MapUnitCombatant)combatant, enemy, conditionalState, tileToAttackFrom, modifiers);
            this.addResourceLackingMalus((MapUnitCombatant)combatant, modifiers);
            Pair<String, Integer> pair = GreatGeneralImplementation.INSTANCE.getGreatGeneralBonus((MapUnitCombatant)combatant, enemy, combatAction);
            String greatGeneralName = pair.component1();
            int greatGeneralBonus = ((Number)pair.component2()).intValue();
            if (greatGeneralBonus != 0) {
                Integer n = greatGeneralBonus;
                ((Map)modifiers).put(greatGeneralName, n);
            }
            Iterator iterator2 = MapUnit.getMatchingUniques$default(((MapUnitCombatant)combatant).getUnit(), UniqueType.StrengthWhenStacked, null, false, 6, null).iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                Object object;
                int stackedUnitsBonus;
                Unique unique;
                block9: {
                    unique = (Unique)iterator2.next();
                    stackedUnitsBonus = 0;
                    Sequence<MapUnit> $this$any$iv = ((MapUnitCombatant)combatant).getUnit().getTile().getUnits();
                    boolean $i$f$any = false;
                    object = $this$any$iv.iterator();
                    while (object.hasNext()) {
                        MapUnit element$iv;
                        MapUnit it = element$iv = object.next();
                        boolean bl2 = false;
                        if (!MapUnit.matchesFilter$default(it, unique.getParams().get(1), false, 2, null)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
                if (bl) {
                    stackedUnitsBonus += Integer.parseInt(unique.getParams().get(0));
                }
                if (stackedUnitsBonus <= 0) continue;
                object = stackedUnitsBonus;
                ((Map)modifiers).put("Stacked with [" + unique.getParams().get(1) + ']', object);
            }
        } else if (combatant instanceof CityCombatant) {
            Iterator iterator3 = City.getMatchingUniques$default(((CityCombatant)combatant).getCity(), UniqueType.StrengthForCities, conditionalState, false, 4, null).iterator();
            while (iterator3.hasNext()) {
                Unique unique = (Unique)iterator3.next();
                modifiers.add(this.getModifierStringFromUnique(unique), Integer.parseInt(unique.getParams().get(0)));
            }
        }
        if (enemy.getCivInfo().isBarbarian()) {
            ((Map)modifiers).put("Difficulty", (int)(civInfo.getGameInfo().getDifficulty().getBarbarianBonus() * (float)100));
        }
        return modifiers;
    }

    private final StateForConditionals getStateForConditionals(CombatAction combatAction, ICombatant combatant, ICombatant enemy) {
        Tile attackedTile = combatAction == CombatAction.Attack ? enemy.getTile() : combatant.getTile();
        CityCombatant cityCombatant = combatant instanceof CityCombatant ? (CityCombatant)combatant : null;
        StateForConditionals conditionalState = new StateForConditionals(combatant.getCivInfo(), cityCombatant != null ? cityCombatant.getCity() : null, null, null, combatant, enemy, attackedTile, combatAction, null, null, false, 1804, null);
        return conditionalState;
    }

    /*
     * WARNING - void declaration
     */
    private final void addUnitUniqueModifiers(MapUnitCombatant combatant, ICombatant enemy, StateForConditionals conditionalState, Tile tileToAttackFrom, Counter<String> modifiers) {
        Object v2;
        void $this$maxByOrNull$iv;
        MapUnit[] unique;
        Civilization civInfo = combatant.getCivInfo();
        Iterator<Unique> iterator2 = combatant.getMatchingUniques(UniqueType.Strength, conditionalState, true).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            modifiers.add(this.getModifierStringFromUnique((Unique)unique), Integer.parseInt(unique.getParams().get(0)));
        }
        iterator2 = combatant.getMatchingUniques(UniqueType.StrengthNearCapital, conditionalState, true).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            if (civInfo.getCities().isEmpty() || Civilization.getCapital$default(civInfo, false, 1, null) == null) break;
            Tile tile = combatant.getTile();
            City city2 = Civilization.getCapital$default(civInfo, false, 1, null);
            Intrinsics.checkNotNull(city2);
            int distance = tile.aerialDistanceTo(city2.getCenterTile());
            int effect = Integer.parseInt(unique.getParams().get(0)) - 3 * distance;
            if (effect <= 0) continue;
            modifiers.add(unique.getSourceObjectName() + " (" + unique.getSourceNameForUser() + ')', effect);
        }
        Sequence<Object> adjacentUnits2 = SequencesKt.flatMap(combatant.getTile().getNeighbors(), addUnitUniqueModifiers.adjacentUnits.1.INSTANCE);
        if (!SequencesKt.contains(combatant.getTile().getNeighbors(), enemy.getTile()) && SequencesKt.contains(combatant.getTile().getNeighbors(), tileToAttackFrom) && enemy instanceof MapUnitCombatant) {
            unique = new MapUnit[]{((MapUnitCombatant)enemy).getUnit()};
            adjacentUnits2 = SequencesKt.plus(adjacentUnits2, SequencesKt.sequenceOf(unique));
        }
        Sequence distance = SequencesKt.filter(SequencesKt.flatMap(SequencesKt.filter(adjacentUnits2, (Function1)new Function1<MapUnit, Boolean>(combatant){
            final /* synthetic */ MapUnitCombatant $combatant;
            {
                this.$combatant = $combatant;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MapUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getCiv().isAtWarWith(this.$combatant.getCivInfo());
            }
        }), addUnitUniqueModifiers.strengthMalus.2.INSTANCE), (Function1)new Function1<Unique, Boolean>(combatant){
            final /* synthetic */ MapUnitCombatant $combatant;
            {
                this.$combatant = $combatant;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Unique it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return ICombatant.DefaultImpls.matchesFilter$default(this.$combatant, it.getParams().get(1), false, 2, null) && Tile.matchesFilter$default(this.$combatant.getTile(), it.getParams().get(2), null, 2, null);
            }
        });
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                Unique it = (Unique)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)((Object)it.getParams().get(0));
                do {
                    Object e$iv = iterator$iv.next();
                    Unique it2 = (Unique)e$iv;
                    $i$a$-maxByOrNull-BattleDamage$addUnitUniqueModifiers$strengthMalus$4 = false;
                    Comparable v$iv = (Comparable)((Object)it2.getParams().get(0));
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        Unique strengthMalus2 = v2;
        if (strengthMalus2 != null) {
            modifiers.add("Adjacent enemy units", Integer.parseInt(strengthMalus2.getParams().get(0)));
        }
    }

    private final void addResourceLackingMalus(MapUnitCombatant combatant, Counter<String> modifiers) {
        Civilization civInfo = combatant.getCivInfo();
        HashMap<String, Integer> civResources = civInfo.getCivResourcesByName();
        for (String resource2 : combatant.getUnit().getResourceRequirementsPerTurn().keySet()) {
            Integer n = civResources.get(resource2);
            Intrinsics.checkNotNull(n);
            if (((Number)n).intValue() >= 0 || civInfo.isBarbarian()) continue;
            ((Map)modifiers).put("Missing resource", -25);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final Counter<String> getAttackModifiers(@NotNull ICombatant attacker, @NotNull ICombatant defender, @NotNull Tile tileToAttackFrom) {
        block6: {
            Intrinsics.checkNotNullParameter(attacker, "attacker");
            Intrinsics.checkNotNullParameter(defender, "defender");
            Intrinsics.checkNotNullParameter(tileToAttackFrom, "tileToAttackFrom");
            modifiers = this.getGeneralModifiers(attacker, defender, CombatAction.Attack, tileToAttackFrom);
            if (!(attacker instanceof MapUnitCombatant)) break block6;
            this.addTerrainAttackModifiers((MapUnitCombatant)attacker, defender, tileToAttackFrom, modifiers);
            if (((MapUnitCombatant)attacker).getUnit().isPreparingAirSweep()) {
                modifiers.add(this.getAirSweepAttackModifiers(attacker));
            }
            if (!attacker.isMelee()) break block6;
            $this$count$iv = defender.getTile().getNeighbors();
            $i$f$count = false;
            count$iv = 0;
            var9_11 /* !! */  = $this$count$iv.iterator();
            while (var9_11 /* !! */ .hasNext()) {
                it = element$iv = var9_11 /* !! */ .next();
                $i$a$-count-BattleDamage$getAttackModifiers$numberOfOtherAttackersSurroundingDefender$1 = false;
                if (it.getMilitaryUnit() == null || Intrinsics.areEqual(it.getMilitaryUnit(), ((MapUnitCombatant)attacker).getUnit())) ** GOTO lbl-1000
                v0 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(v0);
                if (!Intrinsics.areEqual(v0.getOwner(), attacker.getCivInfo().getCivName())) ** GOTO lbl-1000
                v1 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(v1);
                if (new MapUnitCombatant(v1).isMelee()) {
                    v2 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v2 = false;
                }
                if (!v2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            numberOfOtherAttackersSurroundingDefender = count$iv;
            if (numberOfOtherAttackersSurroundingDefender > 0) {
                flankingBonus = 10.0f;
                count$iv = ((MapUnitCombatant)attacker).getUnit();
                var9_11 /* !! */  = UniqueType.FlankAttackBonus;
                var10_12 = this.getStateForConditionals(CombatAction.Attack, attacker, defender);
                var7_8 = count$iv.getMatchingUniques((UniqueType)var9_11 /* !! */ , var10_12, true).iterator();
                while (var7_8.hasNext()) {
                    unique = var7_8.next();
                    flankingBonus *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
                }
                ((Map)modifiers).put("Flanking", (int)(flankingBonus * (float)numberOfOtherAttackersSurroundingDefender));
            }
        }
        return modifiers;
    }

    private final void addTerrainAttackModifiers(MapUnitCombatant attacker, ICombatant defender, Tile tileToAttackFrom, Counter<String> modifiers) {
        if (attacker.getUnit().isEmbarked() && defender.getTile().isLand() && !MapUnit.hasUnique$default(attacker.getUnit(), UniqueType.AttackAcrossCoast, null, false, 6, null)) {
            ((Map)modifiers).put("Landing", -50);
        }
        if (attacker.getUnit().getType().isLandUnit() && !attacker.getTile().isWater() && attacker.isMelee() && defender.getTile().isWater() && !MapUnit.hasUnique$default(attacker.getUnit(), UniqueType.AttackAcrossCoast, null, false, 6, null)) {
            ((Map)modifiers).put("Boarding", -50);
        }
        if (!attacker.getUnit().getType().isAirUnit() && attacker.isMelee() && attacker.getTile().isWater() && !defender.getTile().isWater() && !MapUnit.hasUnique$default(attacker.getUnit(), UniqueType.AttackAcrossCoast, null, false, 6, null) && !defender.isCity()) {
            ((Map)modifiers).put("Landing", -50);
        }
        if (this.isMeleeAttackingAcrossRiverWithNoBridge(attacker, tileToAttackFrom, defender)) {
            ((Map)modifiers).put("Across river", -20);
        }
    }

    private final boolean isMeleeAttackingAcrossRiverWithNoBridge(MapUnitCombatant attacker, Tile tileToAttackFrom, ICombatant defender) {
        return attacker.isMelee() && tileToAttackFrom.aerialDistanceTo(defender.getTile()) == 1 && tileToAttackFrom.isConnectedByRiver(defender.getTile()) && !MapUnit.hasUnique$default(attacker.getUnit(), UniqueType.AttackAcrossRiver, null, false, 6, null) && (!tileToAttackFrom.hasConnection(attacker.getCivInfo()) || !defender.getTile().hasConnection(attacker.getCivInfo()) || !attacker.getCivInfo().getTech().getRoadsConnectAcrossRivers());
    }

    @NotNull
    public final Counter<String> getAirSweepAttackModifiers(@NotNull ICombatant attacker) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Counter<String> modifiers = new Counter<String>(null, 1, null);
        if (attacker instanceof MapUnitCombatant) {
            Iterator iterator2 = MapUnit.getMatchingUniques$default(((MapUnitCombatant)attacker).getUnit(), UniqueType.StrengthWhenAirsweep, null, false, 6, null).iterator();
            while (iterator2.hasNext()) {
                Unique unique = (Unique)iterator2.next();
                modifiers.add(this.getModifierStringFromUnique(unique), Integer.parseInt(unique.getParams().get(0)));
            }
        }
        return modifiers;
    }

    @NotNull
    public final Counter<String> getDefenceModifiers(@NotNull ICombatant attacker, @NotNull ICombatant defender, @NotNull Tile tileToAttackFrom) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        Intrinsics.checkNotNullParameter(tileToAttackFrom, "tileToAttackFrom");
        Counter<String> modifiers = this.getGeneralModifiers(defender, attacker, CombatAction.Defend, tileToAttackFrom);
        Tile tile = defender.getTile();
        if (defender instanceof MapUnitCombatant && !((MapUnitCombatant)defender).getUnit().isEmbarked()) {
            float tileDefenceBonus = Tile.getDefensiveBonus$default(tile, false, ((MapUnitCombatant)defender).getUnit(), 1, null);
            if (!MapUnit.hasUnique$default(((MapUnitCombatant)defender).getUnit(), UniqueType.NoDefensiveTerrainBonus, null, true, 2, null) && tileDefenceBonus > 0.0f || !MapUnit.hasUnique$default(((MapUnitCombatant)defender).getUnit(), UniqueType.NoDefensiveTerrainPenalty, null, true, 2, null) && tileDefenceBonus < 0.0f) {
                ((Map)modifiers).put("Tile", (int)(tileDefenceBonus * (float)100));
            }
            if (((MapUnitCombatant)defender).getUnit().isFortified() || ((MapUnitCombatant)defender).getUnit().isGuarding()) {
                ((Map)modifiers).put("Fortification", 20 * ((MapUnitCombatant)defender).getUnit().getFortificationTurns());
            }
        }
        return modifiers;
    }

    private final float modifiersToFinalBonus(Counter<String> modifiers) {
        float finalModifier = 1.0f;
        for (Integer modifierValue : modifiers.values()) {
            finalModifier += (float)modifierValue.intValue() / 100.0f;
        }
        return finalModifier;
    }

    private final float getHealthDependantDamageRatio(ICombatant combatant) {
        return !(combatant instanceof MapUnitCombatant) || MapUnit.hasUnique$default(((MapUnitCombatant)combatant).getUnit(), UniqueType.NoDamagePenaltyWoundedUnits, null, true, 2, null) ? 1.0f : 1.0f - (float)(100 - combatant.getHealth()) / 300.0f;
    }

    public final float getAttackingStrength(@NotNull ICombatant attacker, @NotNull ICombatant defender, @NotNull Tile tileToAttackFrom) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        Intrinsics.checkNotNullParameter(tileToAttackFrom, "tileToAttackFrom");
        float attackModifier = this.modifiersToFinalBonus(this.getAttackModifiers(attacker, defender, tileToAttackFrom));
        return Math.max(1.0f, (float)attacker.getAttackingStrength() * attackModifier);
    }

    public final float getDefendingStrength(@NotNull ICombatant attacker, @NotNull ICombatant defender, @NotNull Tile tileToAttackFrom) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        Intrinsics.checkNotNullParameter(tileToAttackFrom, "tileToAttackFrom");
        float defenceModifier = this.modifiersToFinalBonus(this.getDefenceModifiers(attacker, defender, tileToAttackFrom));
        return Math.max(1.0f, (float)defender.getDefendingStrength(attacker.isRanged()) * defenceModifier);
    }

    public final int calculateDamageToAttacker(@NotNull ICombatant attacker, @NotNull ICombatant defender, @NotNull Tile tileToAttackFrom, float randomnessFactor) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        Intrinsics.checkNotNullParameter(tileToAttackFrom, "tileToAttackFrom");
        if (attacker.isRanged() && !attacker.isAirUnit()) {
            return 0;
        }
        if (defender.isCivilian()) {
            return 0;
        }
        float ratio = this.getAttackingStrength(attacker, defender, tileToAttackFrom) / this.getDefendingStrength(attacker, defender, tileToAttackFrom);
        return MathKt.roundToInt(this.damageModifier(ratio, true, randomnessFactor) * this.getHealthDependantDamageRatio(defender));
    }

    public static /* synthetic */ int calculateDamageToAttacker$default(BattleDamage battleDamage, ICombatant iCombatant, ICombatant iCombatant2, Tile tile, float f, int n, Object object) {
        if ((n & 4) != 0) {
            tile = iCombatant2.getTile();
        }
        if ((n & 8) != 0) {
            f = RandomKt.Random((long)iCombatant.getCivInfo().getGameInfo().getTurns() * (long)iCombatant.getTile().getPosition().hashCode()).nextFloat();
        }
        return battleDamage.calculateDamageToAttacker(iCombatant, iCombatant2, tile, f);
    }

    public final int calculateDamageToDefender(@NotNull ICombatant attacker, @NotNull ICombatant defender, @NotNull Tile tileToAttackFrom, float randomnessFactor) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        Intrinsics.checkNotNullParameter(tileToAttackFrom, "tileToAttackFrom");
        if (defender.isCivilian()) {
            return 40;
        }
        float ratio = this.getAttackingStrength(attacker, defender, tileToAttackFrom) / this.getDefendingStrength(attacker, defender, tileToAttackFrom);
        return MathKt.roundToInt(this.damageModifier(ratio, false, randomnessFactor) * this.getHealthDependantDamageRatio(attacker));
    }

    public static /* synthetic */ int calculateDamageToDefender$default(BattleDamage battleDamage, ICombatant iCombatant, ICombatant iCombatant2, Tile tile, float f, int n, Object object) {
        if ((n & 4) != 0) {
            tile = iCombatant2.getTile();
        }
        if ((n & 8) != 0) {
            f = RandomKt.Random((long)iCombatant2.getCivInfo().getGameInfo().getTurns() * (long)iCombatant2.getTile().getPosition().hashCode()).nextFloat();
        }
        return battleDamage.calculateDamageToDefender(iCombatant, iCombatant2, tile, f);
    }

    private final float damageModifier(float attackerToDefenderRatio, boolean damageToAttacker, float randomnessFactor) {
        float strongerToWeakerRatio = (float)Math.pow(attackerToDefenderRatio, attackerToDefenderRatio < 1.0f ? -1 : 1);
        float ratioModifier = ((float)Math.pow((strongerToWeakerRatio + (float)3) / (float)4, 4) + 1.0f) / (float)2;
        if (damageToAttacker && attackerToDefenderRatio > 1.0f || !damageToAttacker && attackerToDefenderRatio < 1.0f) {
            ratioModifier = (float)Math.pow(ratioModifier, -1);
        }
        float randomCenteredAround30 = (float)24 + (float)12 * randomnessFactor;
        return randomCenteredAround30 * ratioModifier;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UniqueTarget.values().length];
            try {
                nArray[UniqueTarget.Unit.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueTarget.Nation.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueTarget.Global.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

