/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.diplomacy;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.CityStateFunctions;
import com.unciv.logic.civilization.diplomacy.CityStatePersonality;
import com.unciv.logic.civilization.diplomacy.DeclareWar;
import com.unciv.logic.civilization.diplomacy.DeclareWarReason;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.diplomacy.WarType;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeEvaluation;
import com.unciv.logic.trade.TradeLogic;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 \u008e\u00012\u00020\u0001:\u0002\u008e\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u000fJ\u0016\u0010?\u001a\u00020=2\u0006\u0010@\u001a\u00020A2\u0006\u0010>\u001a\u00020\u000fJ\u0006\u0010B\u001a\u00020=J\u0006\u0010C\u001a\u00020=J\u0006\u0010D\u001a\u00020=J\b\u0010E\u001a\u00020 H\u0002J\u0006\u0010F\u001a\u00020 J\u0006\u0010G\u001a\u00020 J\u0006\u0010H\u001a\u00020\u0000J\u0018\u0010I\u001a\u00020 2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u001cH\u0002J\u0010\u0010M\u001a\u00020=2\b\b\u0002\u0010N\u001a\u00020OJ\u0006\u0010P\u001a\u00020=J\r\u0010Q\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\bRJ\r\u0010S\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\bTJ\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00030VJ\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00030VJ\u000e\u0010X\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020ZJ\u0006\u0010[\u001a\u00020\u001cJ\u0006\u0010\\\u001a\u00020\u000fJ\u0015\u0010]\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020AH\u0000\u00a2\u0006\u0002\b^J\u0006\u0010_\u001a\u00020\u001cJ\u0016\u0010`\u001a\u00020=2\u0006\u0010a\u001a\u00020\u001c2\u0006\u0010b\u001a\u00020 J\u0006\u0010c\u001a\u00020\u001cJ\u000e\u0010d\u001a\u00020 2\u0006\u0010Y\u001a\u00020ZJ\u000e\u0010e\u001a\u00020 2\u0006\u0010@\u001a\u00020AJ\u0006\u0010f\u001a\u00020 J\u000e\u0010g\u001a\u00020 2\u0006\u0010J\u001a\u00020KJ\u000e\u0010h\u001a\u00020 2\u0006\u0010J\u001a\u00020KJ\u000e\u0010i\u001a\u00020 2\u0006\u0010J\u001a\u00020KJ\u000e\u0010j\u001a\u00020 2\u0006\u0010J\u001a\u00020KJ\u000e\u0010k\u001a\u00020 2\u0006\u0010J\u001a\u00020KJ\u0006\u0010l\u001a\u00020=J\b\u0010m\u001a\u00020=H\u0002J\u000e\u0010n\u001a\u00020 2\u0006\u0010o\u001a\u00020\u0005J\u0006\u0010p\u001a\u00020\u000fJ\u0006\u0010q\u001a\u00020\u0003J\u0006\u0010r\u001a\u00020\u0000J\u000e\u0010s\u001a\u00020=2\u0006\u0010a\u001a\u00020\u001cJ\u000e\u0010t\u001a\u00020=2\u0006\u0010>\u001a\u00020\u000fJ\u0006\u0010u\u001a\u00020=J\u0006\u0010v\u001a\u00020=J\u0006\u0010w\u001a\u00020KJ\u0006\u0010x\u001a\u00020KJ\u000e\u0010y\u001a\u00020=2\u0006\u0010Y\u001a\u00020ZJ\u0019\u0010z\u001a\u0004\u0018\u00010\u000f2\u0006\u0010@\u001a\u00020AH\u0000\u00a2\u0006\u0004\b{\u0010|J\u0006\u0010}\u001a\u00020~J\u000e\u0010\u007f\u001a\u00020=H\u0000\u00a2\u0006\u0003\b\u0080\u0001J\u0017\u0010\u0081\u0001\u001a\u00020=2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010>\u001a\u00020\u001cJ\u000f\u0010\u0082\u0001\u001a\u00020=H\u0000\u00a2\u0006\u0003\b\u0083\u0001J\u000f\u0010\u0084\u0001\u001a\u00020=2\u0006\u0010>\u001a\u00020\u000fJ\u0017\u0010\u0085\u0001\u001a\u00020=2\u0006\u0010@\u001a\u00020A2\u0006\u0010>\u001a\u00020\u000fJ\u000f\u0010\u0086\u0001\u001a\u00020=H\u0000\u00a2\u0006\u0003\b\u0087\u0001J\u0007\u0010\u0088\u0001\u001a\u00020=J\u0007\u0010\u0089\u0001\u001a\u00020=J\u0010\u0010\u008a\u0001\u001a\u00020=2\u0007\u0010\u008b\u0001\u001a\u00020\u001cJ\u0007\u0010\u008c\u0001\u001a\u00020\u001cJ\u0007\u0010\u008d\u0001\u001a\u00020=R\u001a\u0010\b\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR6\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000ej\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f`\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR6\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001c0\u000ej\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001c`\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0012\"\u0004\b\u001e\u0010\u0014R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R*\u00104\u001a\u0012\u0012\u0004\u0012\u00020605j\b\u0012\u0004\u0012\u000206`7X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;\u00a8\u0006\u008f\u0001"}, d2={"Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "civilization", "Lcom/unciv/logic/civilization/Civilization;", "mOtherCivName", "", "(Lcom/unciv/logic/civilization/Civilization;Ljava/lang/String;)V", "()V", "civInfo", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "diplomaticModifiers", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getDiplomaticModifiers", "()Ljava/util/HashMap;", "setDiplomaticModifiers", "(Ljava/util/HashMap;)V", "diplomaticStatus", "Lcom/unciv/logic/civilization/diplomacy/DiplomaticStatus;", "getDiplomaticStatus", "()Lcom/unciv/logic/civilization/diplomacy/DiplomaticStatus;", "setDiplomaticStatus", "(Lcom/unciv/logic/civilization/diplomacy/DiplomaticStatus;)V", "flagsCountdown", "", "getFlagsCountdown$core", "setFlagsCountdown$core", "hasOpenBorders", "", "getHasOpenBorders", "()Z", "setHasOpenBorders", "(Z)V", "influence", "getInfluence$core", "()F", "setInfluence$core", "(F)V", "otherCivName", "getOtherCivName", "()Ljava/lang/String;", "setOtherCivName", "(Ljava/lang/String;)V", "totalOfScienceDuringRA", "getTotalOfScienceDuringRA$core", "()I", "setTotalOfScienceDuringRA$core", "(I)V", "trades", "Ljava/util/ArrayList;", "Lcom/unciv/logic/trade/Trade;", "Lkotlin/collections/ArrayList;", "getTrades", "()Ljava/util/ArrayList;", "setTrades", "(Ljava/util/ArrayList;)V", "addInfluence", "", "amount", "addModifier", "modifier", "Lcom/unciv/logic/civilization/diplomacy/DiplomaticModifiers;", "agreeNotToSettleNear", "agreeNotToSpreadReligionTo", "becomeWary", "believesSameReligion", "canAttack", "canDeclareWar", "clone", "compareRelationshipLevel", "level", "Lcom/unciv/logic/civilization/diplomacy/RelationshipLevel;", "comparesAs", "declareWar", "declareWarReason", "Lcom/unciv/logic/civilization/diplomacy/DeclareWarReason;", "denounce", "getCityStateInfluenceDegrade", "getCityStateInfluenceDegrade$core", "getCityStateInfluenceRestingPoint", "getCityStateInfluenceRestingPoint$core", "getCommonKnownCivs", "", "getCommonKnownCivsWithSpectators", "getFlag", "flag", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyFlags;", "getGoldGifts", "getInfluence", "getModifier", "getModifier$core", "getTurnsToRelationshipChange", "giftGold", "gold", "isPureGift", "goldPerTurn", "hasFlag", "hasModifier", "isConsideredFriendlyTerritory", "isRelationshipLevelEQ", "isRelationshipLevelGE", "isRelationshipLevelGT", "isRelationshipLevelLE", "isRelationshipLevelLT", "makePeace", "makePeaceOneSide", "matchesCityStateRelationshipFilter", "filter", "opinionOfOtherCiv", "otherCiv", "otherCivDiplomacy", "recieveGoldGifts", "reduceInfluence", "refuseDemandNotToSettleNear", "refuseNotToSpreadReligionTo", "relationshipIgnoreAfraid", "relationshipLevel", "removeFlag", "removeModifier", "removeModifier$core", "(Lcom/unciv/logic/civilization/diplomacy/DiplomaticModifiers;)Ljava/lang/Float;", "resourcesFromTrade", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "setDefensivePactBasedModifier", "setDefensivePactBasedModifier$core", "setFlag", "setFriendshipBasedModifier", "setFriendshipBasedModifier$core", "setInfluence", "setModifier", "setReligionBasedModifier", "setReligionBasedModifier$core", "sideWithCityState", "signDeclarationOfFriendship", "signDefensivePact", "duration", "turnsToPeaceTreaty", "updateHasOpenBorders", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDiplomacyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiplomacyManager.kt\ncom/unciv/logic/civilization/diplomacy/DiplomacyManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,767:1\n1549#2:768\n1620#2,3:769\n766#2:773\n857#2,2:774\n766#2:776\n857#2,2:777\n766#2:779\n857#2,2:780\n766#2:782\n857#2,2:783\n766#2:785\n857#2,2:786\n1360#2:788\n1446#2,5:789\n1747#2,3:794\n766#2:797\n857#2,2:798\n766#2:800\n857#2,2:801\n1855#2,2:803\n1#3:772\n*S KotlinDebug\n*F\n+ 1 DiplomacyManager.kt\ncom/unciv/logic/civilization/diplomacy/DiplomacyManager\n*L\n175#1:768\n175#1:769,3\n399#1:773\n399#1:774,2\n421#1:776\n421#1:777,2\n423#1:779\n423#1:780,2\n439#1:782\n439#1:783,2\n441#1:785\n441#1:786,2\n469#1:788\n469#1:789,5\n469#1:794,3\n577#1:797\n577#1:798,2\n627#1:800\n627#1:801,2\n664#1:803,2\n*E\n"})
public final class DiplomacyManager
implements IsPartOfGameInfoSerialization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public transient Civilization civInfo;
    private transient boolean hasOpenBorders;
    public String otherCivName;
    @NotNull
    private ArrayList<Trade> trades;
    @NotNull
    private DiplomaticStatus diplomaticStatus;
    @NotNull
    private HashMap<String, Integer> flagsCountdown;
    @NotNull
    private HashMap<String, Float> diplomaticModifiers;
    private float influence;
    private int totalOfScienceDuringRA;
    public static final float MINIMUM_INFLUENCE = -60.0f;

    public DiplomacyManager() {
        this.trades = new ArrayList();
        this.diplomaticStatus = DiplomaticStatus.War;
        this.flagsCountdown = new HashMap();
        this.diplomaticModifiers = new HashMap();
    }

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    public final boolean getHasOpenBorders() {
        return this.hasOpenBorders;
    }

    public final void setHasOpenBorders(boolean bl) {
        this.hasOpenBorders = bl;
    }

    @NotNull
    public final String getOtherCivName() {
        String string = this.otherCivName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("otherCivName");
        return null;
    }

    public final void setOtherCivName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.otherCivName = string;
    }

    @NotNull
    public final ArrayList<Trade> getTrades() {
        return this.trades;
    }

    public final void setTrades(@NotNull ArrayList<Trade> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.trades = arrayList;
    }

    @NotNull
    public final DiplomaticStatus getDiplomaticStatus() {
        return this.diplomaticStatus;
    }

    public final void setDiplomaticStatus(@NotNull DiplomaticStatus diplomaticStatus) {
        Intrinsics.checkNotNullParameter(diplomaticStatus, "<set-?>");
        this.diplomaticStatus = diplomaticStatus;
    }

    @NotNull
    public final HashMap<String, Integer> getFlagsCountdown$core() {
        return this.flagsCountdown;
    }

    public final void setFlagsCountdown$core(@NotNull HashMap<String, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.flagsCountdown = hashMap;
    }

    @NotNull
    public final HashMap<String, Float> getDiplomaticModifiers() {
        return this.diplomaticModifiers;
    }

    public final void setDiplomaticModifiers(@NotNull HashMap<String, Float> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.diplomaticModifiers = hashMap;
    }

    public final float getInfluence$core() {
        return this.influence;
    }

    public final void setInfluence$core(float f) {
        this.influence = f;
    }

    public final int getTotalOfScienceDuringRA$core() {
        return this.totalOfScienceDuringRA;
    }

    public final void setTotalOfScienceDuringRA$core(int n) {
        this.totalOfScienceDuringRA = n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DiplomacyManager clone() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DiplomacyManager toReturn = new DiplomacyManager();
        toReturn.setOtherCivName(this.getOtherCivName());
        toReturn.diplomaticStatus = this.diplomaticStatus;
        Iterable iterable = this.trades;
        ArrayList<Trade> arrayList = toReturn.trades;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Trade trade = (Trade)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.clone());
        }
        arrayList.addAll((List)destination$iv$iv);
        toReturn.influence = this.influence;
        toReturn.flagsCountdown.putAll((Map<String, Integer>)this.flagsCountdown);
        toReturn.diplomaticModifiers.putAll((Map<String, Float>)this.diplomaticModifiers);
        toReturn.totalOfScienceDuringRA = this.totalOfScienceDuringRA;
        return toReturn;
    }

    public DiplomacyManager(@NotNull Civilization civilization, @NotNull String mOtherCivName) {
        Intrinsics.checkNotNullParameter(civilization, "civilization");
        Intrinsics.checkNotNullParameter(mOtherCivName, "mOtherCivName");
        this();
        this.setCivInfo(civilization);
        this.setOtherCivName(mOtherCivName);
        this.updateHasOpenBorders();
    }

    @NotNull
    public final Civilization otherCiv() {
        return this.getCivInfo().getGameInfo().getCivilization(this.getOtherCivName());
    }

    @NotNull
    public final DiplomacyManager otherCivDiplomacy() {
        DiplomacyManager diplomacyManager = this.otherCiv().getDiplomacyManager(this.getCivInfo());
        Intrinsics.checkNotNull(diplomacyManager);
        return diplomacyManager;
    }

    public final int turnsToPeaceTreaty() {
        for (Trade trade : this.trades) {
            for (TradeOffer offer : trade.getOurOffers()) {
                if (!Intrinsics.areEqual(offer.getName(), "Peace Treaty") || offer.getDuration() <= 0) continue;
                return offer.getDuration();
            }
        }
        return 0;
    }

    public final float opinionOfOtherCiv() {
        Collection<Float> collection = this.diplomaticModifiers.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        float modifierSum = CollectionsKt.sumOfFloat((Iterable<Float>)collection);
        if (this.hasModifier(DiplomaticModifiers.DestroyedProtectedMinor) && this.hasModifier(DiplomaticModifiers.AttackedProtectedMinor)) {
            modifierSum -= this.getModifier$core(DiplomaticModifiers.AttackedProtectedMinor);
        }
        return modifierSum;
    }

    private final boolean compareRelationshipLevel(RelationshipLevel level, int comparesAs) {
        boolean bl;
        if (!this.getCivInfo().isCityState()) {
            return MathKt.getSign(this.relationshipLevel().compareTo((Enum)level)) == comparesAs;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                if (comparesAs < 0) {
                    if (this.getInfluence() < 0.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (comparesAs > 0) {
                    if (this.getInfluence() >= 30.0f || this.relationshipLevel().compareTo((Enum)level) > 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                float it = this.getInfluence();
                boolean bl2 = false;
                if (it >= 0.0f && it < 30.0f && this.relationshipLevel() == level) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (comparesAs < 0) {
                    if (this.getInfluence() < 0.0f || this.relationshipLevel().compareTo((Enum)level) < 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (comparesAs > 0) {
                    if (this.getInfluence() >= 30.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                float it = this.getInfluence();
                boolean bl3 = false;
                if (it >= 0.0f && it < 30.0f && this.relationshipLevel() == level) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = MathKt.getSign(this.relationshipLevel().compareTo((Enum)level)) == comparesAs;
            }
        }
        return bl;
    }

    public final boolean isRelationshipLevelEQ(@NotNull RelationshipLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, "level");
        return this.compareRelationshipLevel(level, 0);
    }

    public final boolean isRelationshipLevelLT(@NotNull RelationshipLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, "level");
        return this.compareRelationshipLevel(level, -1);
    }

    public final boolean isRelationshipLevelGT(@NotNull RelationshipLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, "level");
        return this.compareRelationshipLevel(level, 1);
    }

    public final boolean isRelationshipLevelLE(@NotNull RelationshipLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, "level");
        return level == RelationshipLevel.Ally ? true : this.compareRelationshipLevel(level.plus(1), -1);
    }

    public final boolean isRelationshipLevelGE(@NotNull RelationshipLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, "level");
        return level == RelationshipLevel.Unforgivable ? true : this.compareRelationshipLevel(level.plus(-1), 1);
    }

    @NotNull
    public final RelationshipLevel relationshipLevel() {
        RelationshipLevel level = this.relationshipIgnoreAfraid();
        return level != RelationshipLevel.Neutral || !this.getCivInfo().isCityState() ? level : (CityStateFunctions.getTributeWillingness$default(this.getCivInfo().getCityStateFunctions(), this.otherCiv(), false, 2, null) > 0 ? RelationshipLevel.Afraid : RelationshipLevel.Neutral);
    }

    @NotNull
    public final RelationshipLevel relationshipIgnoreAfraid() {
        if (this.getCivInfo().isHuman() && this.otherCiv().isHuman()) {
            return RelationshipLevel.Neutral;
        }
        if (this.getCivInfo().isHuman()) {
            return this.otherCivDiplomacy().relationshipLevel();
        }
        if (this.getCivInfo().isCityState()) {
            return this.getInfluence() <= -30.0f ? RelationshipLevel.Unforgivable : (this.getInfluence() < 0.0f ? RelationshipLevel.Enemy : (this.getInfluence() >= 60.0f && Intrinsics.areEqual(this.getCivInfo().getAllyCivName(), this.getOtherCivName()) ? RelationshipLevel.Ally : (this.getInfluence() >= 30.0f ? RelationshipLevel.Friend : RelationshipLevel.Neutral)));
        }
        float opinion = this.opinionOfOtherCiv();
        return opinion <= -80.0f ? RelationshipLevel.Unforgivable : (opinion <= -40.0f || this.getCivInfo().isAtWarWith(this.otherCiv()) ? RelationshipLevel.Enemy : (opinion <= -15.0f ? RelationshipLevel.Competitor : (opinion >= 80.0f ? RelationshipLevel.Ally : (opinion >= 40.0f ? RelationshipLevel.Friend : (opinion >= 15.0f ? RelationshipLevel.Favorable : RelationshipLevel.Neutral)))));
    }

    private final boolean believesSameReligion() {
        Religion religion = this.getCivInfo().getReligionManager().getMajorityReligion();
        if (religion == null) {
            return false;
        }
        Religion civMajorityReligion = religion;
        return this.otherCiv().getReligionManager().isMajorityReligionForCiv(civMajorityReligion);
    }

    public final int getTurnsToRelationshipChange() {
        if (this.otherCiv().isCityState()) {
            return this.otherCivDiplomacy().getTurnsToRelationshipChange();
        }
        if (this.getCivInfo().isCityState() && !this.otherCiv().isCityState()) {
            float dropPerTurn = this.getCityStateInfluenceDegrade$core();
            return dropPerTurn == 0.0f ? 0 : (this.isRelationshipLevelEQ(RelationshipLevel.Ally) ? (int)Math.ceil((this.getInfluence() - 60.0f) / dropPerTurn) + 1 : (this.isRelationshipLevelEQ(RelationshipLevel.Friend) ? (int)Math.ceil((this.getInfluence() - 30.0f) / dropPerTurn) + 1 : 0));
        }
        return 0;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matchesCityStateRelationshipFilter(@NotNull String filter2) {
        block10: {
            RelationshipLevel relationshipLevel;
            block11: {
                block12: {
                    Intrinsics.checkNotNullParameter(filter2, "filter");
                    relationshipLevel = this.relationshipIgnoreAfraid();
                    String string = filter2;
                    switch (string.hashCode()) {
                        case -785992281: {
                            if (!string.equals("Neutral")) {
                                return false;
                            }
                            break block10;
                        }
                        case -1358410549: {
                            if (string.equals("Friendly")) break;
                            return false;
                        }
                        case -911405314: {
                            if (!string.equals("Unforgiving")) {
                                return false;
                            }
                            break block11;
                        }
                        case 67100520: {
                            if (!string.equals("Enemy")) {
                                return false;
                            }
                            break block12;
                        }
                        case 1963956647: {
                            if (!string.equals("Allied")) return false;
                            if (relationshipLevel != RelationshipLevel.Ally) return false;
                            return true;
                        }
                    }
                    if (relationshipLevel != RelationshipLevel.Friend) return false;
                    return true;
                }
                if (relationshipLevel != RelationshipLevel.Enemy) return false;
                return true;
            }
            if (relationshipLevel != RelationshipLevel.Unforgivable) return false;
            return true;
            return false;
        }
        boolean bl = this.isRelationshipLevelEQ(RelationshipLevel.Neutral);
        return bl;
    }

    public final void addInfluence(float amount) {
        this.setInfluence(this.influence + amount);
    }

    public final void reduceInfluence(float amount) {
        if (this.influence <= 0.0f) {
            return;
        }
        this.influence = RangesKt.coerceAtLeast(this.influence - amount, 0.0f);
    }

    public final void setInfluence(float amount) {
        this.influence = Math.max(amount, -60.0f);
        this.getCivInfo().getCityStateFunctions().updateAllyCivForCityState();
    }

    public final float getInfluence() {
        return this.getCivInfo().isAtWarWith(this.otherCiv()) ? -60.0f : this.influence;
    }

    public final float getCityStateInfluenceRestingPoint$core() {
        Unique unique;
        float restingPoint = 0.0f;
        Iterator iterator2 = Civilization.getMatchingUniques$default(this.otherCiv(), UniqueType.CityStateRestingPoint, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            restingPoint += (float)Integer.parseInt(unique.getParams().get(0));
        }
        if (CollectionsKt.any((Iterable)this.getCivInfo().getCities()) && Civilization.getCapital$default(this.getCivInfo(), false, 1, null) != null) {
            iterator2 = Civilization.getMatchingUniques$default(this.otherCiv(), UniqueType.RestingPointOfCityStatesFollowingReligionChange, null, 2, null).iterator();
            while (iterator2.hasNext()) {
                unique = (Unique)iterator2.next();
                Religion religion = this.otherCiv().getReligionManager().getReligion();
                String string = religion != null ? religion.getName() : null;
                City city2 = Civilization.getCapital$default(this.getCivInfo(), false, 1, null);
                Intrinsics.checkNotNull(city2);
                if (!Intrinsics.areEqual(string, city2.getReligion().getMajorityReligionName())) continue;
                restingPoint += (float)Integer.parseInt(unique.getParams().get(0));
            }
        }
        if (this.diplomaticStatus == DiplomaticStatus.Protector) {
            restingPoint += (float)10;
        }
        if (this.hasFlag(DiplomacyFlags.WaryOf)) {
            restingPoint -= (float)20;
        }
        return restingPoint;
    }

    /*
     * WARNING - void declaration
     */
    public final float getCityStateInfluenceDegrade$core() {
        void $this$filterTo$iv$iv;
        String religion;
        String string;
        if (this.getInfluence() <= this.getCityStateInfluenceRestingPoint$core()) {
            return 0.0f;
        }
        float decrement = this.getCivInfo().getCityStatePersonality() == CityStatePersonality.Hostile ? 1.5f : (this.otherCiv().isMinorCivAggressor() ? 2.0f : 1.0f);
        float modifierPercent = 0.0f;
        Iterator iterator2 = Civilization.getMatchingUniques$default(this.otherCiv(), UniqueType.CityStateInfluenceDegradation, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            modifierPercent += Float.parseFloat(unique.getParams().get(0));
        }
        if (this.getCivInfo().getCities().isEmpty() || Civilization.getCapital$default(this.getCivInfo(), false, 1, null) == null) {
            string = null;
        } else {
            City city2 = Civilization.getCapital$default(this.getCivInfo(), false, 1, null);
            Intrinsics.checkNotNull(city2);
            string = religion = city2.getReligion().getMajorityReligionName();
        }
        if (religion != null) {
            Religion religion2 = this.otherCiv().getReligionManager().getReligion();
            if (Intrinsics.areEqual(religion, religion2 != null ? religion2.getName() : null)) {
                modifierPercent -= 25.0f;
            }
        }
        Iterable $this$filter$iv = this.getCivInfo().getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(it.isMajorCiv() && !Intrinsics.areEqual(it, this.otherCiv()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization civ : (List)destination$iv$iv) {
            Iterator iterator3 = Civilization.getMatchingUniques$default(civ, UniqueType.OtherCivsCityStateRelationsDegradeFaster, null, 2, null).iterator();
            while (iterator3.hasNext()) {
                Unique unique = (Unique)iterator3.next();
                modifierPercent += Float.parseFloat(unique.getParams().get(0));
            }
        }
        return Math.max(0.0f, decrement) * FormattingExtensionsKt.toPercent(Math.max(-100.0f, modifierPercent));
    }

    public final boolean canDeclareWar() {
        return !this.getCivInfo().isDefeated() && !this.otherCiv().isDefeated() && this.turnsToPeaceTreaty() == 0 && this.diplomaticStatus != DiplomaticStatus.War;
    }

    public final void declareWar(@NotNull DeclareWarReason declareWarReason) {
        Intrinsics.checkNotNullParameter(declareWarReason, "declareWarReason");
        DeclareWar.INSTANCE.declareWar$core(this, declareWarReason);
    }

    public static /* synthetic */ void declareWar$default(DiplomacyManager diplomacyManager, DeclareWarReason declareWarReason, int n, Object object) {
        if ((n & 1) != 0) {
            declareWarReason = new DeclareWarReason(WarType.DirectWar, null, 2, null);
        }
        diplomacyManager.declareWar(declareWarReason);
    }

    public final boolean canAttack() {
        return this.turnsToPeaceTreaty() == 0;
    }

    public final int goldPerTurn() {
        int goldPerTurnForUs = 0;
        for (Trade trade : this.trades) {
            TradeOffer it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = trade.getOurOffers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TradeOffer)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == TradeOfferType.Gold_Per_Turn)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (TradeOffer offer : (List)destination$iv$iv) {
                goldPerTurnForUs -= offer.getAmount();
            }
            $this$filter$iv = trade.getTheirOffers();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TradeOffer)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == TradeOfferType.Gold_Per_Turn)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (TradeOffer offer : (List)destination$iv$iv) {
                goldPerTurnForUs += offer.getAmount();
            }
        }
        return goldPerTurnForUs;
    }

    @NotNull
    public final ResourceSupplyList resourcesFromTrade() {
        ResourceSupplyList newResourceSupplyList = new ResourceSupplyList(false, 1, null);
        LinkedHashMap<String, TileResource> resourcesMap = this.getCivInfo().getGameInfo().getRuleset().getTileResources();
        Function1 isResourceFilter2 = new Function1<TradeOffer, Boolean>(resourcesMap){
            final /* synthetic */ LinkedHashMap<String, TileResource> $resourcesMap;
            {
                this.$resourcesMap = $resourcesMap;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull TradeOffer it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if ((it.getType() == TradeOfferType.Strategic_Resource || it.getType() == TradeOfferType.Luxury_Resource) && this.$resourcesMap.containsKey(it.getName())) {
                    TileResource tileResource = this.$resourcesMap.get(it.getName());
                    Intrinsics.checkNotNull(tileResource);
                    if (!tileResource.isStockpiled()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
        for (Trade trade : this.trades) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = trade.getOurOffers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)isResourceFilter2.invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (TradeOffer offer : (List)destination$iv$iv) {
                TileResource tileResource = resourcesMap.get(offer.getName());
                Intrinsics.checkNotNull(tileResource);
                newResourceSupplyList.add(tileResource, "Trade", -offer.getAmount());
            }
            $this$filter$iv = trade.getTheirOffers();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)isResourceFilter2.invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (TradeOffer offer : (List)destination$iv$iv) {
                TileResource tileResource = resourcesMap.get(offer.getName());
                Intrinsics.checkNotNull(tileResource);
                newResourceSupplyList.add(tileResource, "Trade", offer.getAmount());
            }
        }
        return newResourceSupplyList;
    }

    @NotNull
    public final Set<Civilization> getCommonKnownCivs() {
        return CollectionsKt.intersect(SequencesKt.asIterable(this.getCivInfo().getKnownCivs()), (Iterable)SequencesKt.toSet(this.otherCiv().getKnownCivs()));
    }

    @NotNull
    public final Set<Civilization> getCommonKnownCivsWithSpectators() {
        return CollectionsKt.intersect(SequencesKt.asIterable(this.getCivInfo().getKnownCivsWithSpectators()), (Iterable)SequencesKt.toSet(this.otherCiv().getKnownCivsWithSpectators()));
    }

    public final boolean isConsideredFriendlyTerritory() {
        if (this.getCivInfo().isCityState() && (this.isRelationshipLevelGE(RelationshipLevel.Friend) || Civilization.hasUnique$default(this.otherCiv(), UniqueType.CityStateTerritoryAlwaysFriendly, null, 2, null))) {
            return true;
        }
        return this.otherCivDiplomacy().hasOpenBorders;
    }

    /*
     * Unable to fully structure code
     */
    public final void updateHasOpenBorders() {
        block8: {
            if (Intrinsics.areEqual(this.getCivInfo().getAllyCivName(), this.getOtherCivName())) ** GOTO lbl-1000
            $this$flatMap$iv = this.trades;
            $i$f$flatMap = false;
            var4_5 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            var7_9 = $this$flatMapTo$iv$iv.iterator();
            while (var7_9.hasNext()) {
                element$iv$iv = var7_9.next();
                it = (Trade)element$iv$iv;
                $i$a$-flatMap-DiplomacyManager$updateHasOpenBorders$newHasOpenBorders$1 = false;
                list$iv$iv = it.getTheirOffers();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            $this$any$iv = (List)destination$iv$iv;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-DiplomacyManager$updateHasOpenBorders$newHasOpenBorders$2 = false;
                    if (!(Intrinsics.areEqual(it.getName(), "Open Borders") != false && it.getDuration() > 0)) continue;
                    v0 = true;
                    break block8;
                }
                v0 = false;
            }
        }
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        newHasOpenBorders = v1;
        bordersWereClosed = this.hasOpenBorders != false && newHasOpenBorders == false;
        this.hasOpenBorders = newHasOpenBorders;
        if (bordersWereClosed) {
            for (MapUnit unit : SequencesKt.toList(SequencesKt.filter(this.getCivInfo().getUnits().getCivUnits(), (Function1)new Function1<MapUnit, Boolean>(this){
                final /* synthetic */ DiplomacyManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull MapUnit it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    Civilization civilization = it.getCurrentTile().getOwner();
                    return Intrinsics.areEqual(civilization != null ? civilization.getCivName() : null, this.this$0.getOtherCivName());
                }
            }))) {
                unit.getMovement().teleportToClosestMoveableTile();
            }
        }
    }

    private final void makePeaceOneSide() {
        this.diplomaticStatus = DiplomaticStatus.Peace;
        Civilization otherCiv = this.otherCiv();
        for (MapUnit unit : SequencesKt.toList(SequencesKt.filter(this.getCivInfo().getUnits().getCivUnits(), (Function1)new Function1<MapUnit, Boolean>(otherCiv){
            final /* synthetic */ Civilization $otherCiv;
            {
                this.$otherCiv = $otherCiv;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MapUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getTile().getOwner(), this.$otherCiv);
            }
        }))) {
            unit.getMovement().teleportToClosestMoveableTile();
        }
        Iterator<IsPartOfGameInfoSerialization> iterator2 = this.getCivInfo().getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            Civilization thirdCiv = (Civilization)iterator2.next();
            if (Intrinsics.areEqual(thirdCiv.getAllyCivName(), this.getCivInfo().getCivName()) && thirdCiv.isAtWarWith(otherCiv)) {
                DiplomacyManager thirdCivDiplo;
                Intrinsics.checkNotNull(thirdCiv.getDiplomacyManager(otherCiv));
                thirdCivDiplo.makePeace();
                TradeLogic tradeLogic = new TradeLogic(thirdCiv, otherCiv);
                tradeLogic.getCurrentTrade().getOurOffers().add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, this.getCivInfo().getGameInfo().getSpeed(), 4, null));
                tradeLogic.getCurrentTrade().getTheirOffers().add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, this.getCivInfo().getGameInfo().getSpeed(), 4, null));
                thirdCivDiplo.trades.add(tradeLogic.getCurrentTrade());
                thirdCivDiplo.otherCivDiplomacy().trades.add(tradeLogic.getCurrentTrade().reverse());
            }
            if (Intrinsics.areEqual(thirdCiv.getAllyCivName(), this.getCivInfo().getCivName()) || !thirdCiv.isAtWarWith(otherCiv)) continue;
            DiplomacyManager diplomacyManager = thirdCiv.getDiplomacyManager(this.getCivInfo());
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.addInfluence(-10.0f);
        }
    }

    public final void makePeace() {
        this.makePeaceOneSide();
        this.otherCivDiplomacy().makePeaceOneSide();
        for (Civilization civ : this.getCommonKnownCivsWithSpectators()) {
            String[] stringArray = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Diplomacy", this.getOtherCivName()};
            civ.addNotification('[' + this.getCivInfo().getCivName() + "] and [" + this.getOtherCivName() + "] have signed a Peace Treaty!", Notification.NotificationCategory.Diplomacy, stringArray);
        }
    }

    public final boolean hasFlag(@NotNull DiplomacyFlags flag) {
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        return this.flagsCountdown.containsKey(flag.name());
    }

    public final void setFlag(@NotNull DiplomacyFlags flag, int amount) {
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        Integer n = amount;
        ((Map)this.flagsCountdown).put(flag.name(), n);
    }

    public final int getFlag(@NotNull DiplomacyFlags flag) {
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        Integer n = this.flagsCountdown.get(flag.name());
        Intrinsics.checkNotNull(n);
        return ((Number)n).intValue();
    }

    public final void removeFlag(@NotNull DiplomacyFlags flag) {
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        this.flagsCountdown.remove(flag.name());
    }

    public final void addModifier(@NotNull DiplomaticModifiers modifier, float amount) {
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        String modifierString = modifier.name();
        if (!this.hasModifier(modifier)) {
            this.setModifier(modifier, 0.0f);
        }
        Map map2 = this.diplomaticModifiers;
        Float f = this.diplomaticModifiers.get(modifierString);
        Intrinsics.checkNotNull(f);
        map2.put(modifierString, Float.valueOf(((Number)f).floatValue() + amount));
        if (Intrinsics.areEqual(this.diplomaticModifiers.get(modifierString), 0.0f)) {
            this.diplomaticModifiers.remove(modifierString);
        }
    }

    public final void setModifier(@NotNull DiplomaticModifiers modifier, float amount) {
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        Float f = Float.valueOf(amount);
        ((Map)this.diplomaticModifiers).put(modifier.name(), f);
    }

    public final float getModifier$core(@NotNull DiplomaticModifiers modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        if (!this.hasModifier(modifier)) {
            return 0.0f;
        }
        Float f = this.diplomaticModifiers.get(modifier.name());
        Intrinsics.checkNotNull(f);
        return ((Number)f).floatValue();
    }

    @Nullable
    public final Float removeModifier$core(@NotNull DiplomaticModifiers modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        return this.diplomaticModifiers.remove(modifier.name());
    }

    public final boolean hasModifier(@NotNull DiplomaticModifiers modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        return this.diplomaticModifiers.containsKey(modifier.name());
    }

    public final void signDeclarationOfFriendship() {
        this.setModifier(DiplomaticModifiers.DeclarationOfFriendship, 35.0f);
        this.otherCivDiplomacy().setModifier(DiplomaticModifiers.DeclarationOfFriendship, 35.0f);
        this.setFlag(DiplomacyFlags.DeclarationOfFriendship, 30);
        this.otherCivDiplomacy().setFlag(DiplomacyFlags.DeclarationOfFriendship, 30);
        for (Civilization thirdCiv : this.getCommonKnownCivsWithSpectators()) {
            String[] stringArray = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Diplomacy", this.getOtherCivName()};
            thirdCiv.addNotification('[' + this.getCivInfo().getCivName() + "] and [" + this.getOtherCivName() + "] have signed the Declaration of Friendship!", Notification.NotificationCategory.Diplomacy, stringArray);
            DiplomacyManager diplomacyManager = thirdCiv.getDiplomacyManager(this.getCivInfo());
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.setFriendshipBasedModifier$core();
            if (thirdCiv.isSpectator()) {
                return;
            }
            DiplomacyManager diplomacyManager2 = thirdCiv.getDiplomacyManager(this.getCivInfo());
            Intrinsics.checkNotNull(diplomacyManager2);
            diplomacyManager2.setFriendshipBasedModifier$core();
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponDeclaringFriendship, StateForConditionals.Companion.getIgnoreConditionals(), null, 4, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.otherCiv(), UniqueType.TriggerUponDeclaringFriendship, StateForConditionals.Companion.getIgnoreConditionals(), null, 4, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.otherCiv(), null, null, null, null, null, 124, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setFriendshipBasedModifier$core() {
        void $this$filterTo$iv$iv;
        this.removeModifier$core(DiplomaticModifiers.DeclaredFriendshipWithOurAllies);
        this.removeModifier$core(DiplomaticModifiers.DeclaredFriendshipWithOurEnemies);
        Iterable $this$filter$iv = this.getCommonKnownCivs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            DiplomacyManager diplomacyManager = it.getDiplomacyManager(this.otherCiv());
            Intrinsics.checkNotNull(diplomacyManager);
            if (!diplomacyManager.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List civsOtherCivHasDeclaredFriendshipWith = (List)destination$iv$iv;
        for (Civilization thirdCiv : civsOtherCivHasDeclaredFriendshipWith) {
            float f;
            DiplomaticModifiers diplomaticModifiers;
            DiplomacyManager diplomacyManager = this.getCivInfo().getDiplomacyManager(thirdCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            RelationshipLevel ourRelationshipWithThirdCiv = diplomacyManager.relationshipIgnoreAfraid();
            switch (WhenMappings.$EnumSwitchMapping$0[ourRelationshipWithThirdCiv.ordinal()]) {
                case 3: 
                case 4: {
                    diplomaticModifiers = DiplomaticModifiers.DeclaredFriendshipWithOurEnemies;
                    break;
                }
                default: {
                    diplomaticModifiers = DiplomaticModifiers.DeclaredFriendshipWithOurAllies;
                }
            }
            DiplomaticModifiers modifierType = diplomaticModifiers;
            switch (WhenMappings.$EnumSwitchMapping$0[ourRelationshipWithThirdCiv.ordinal()]) {
                case 3: {
                    f = -15.0f;
                    break;
                }
                case 4: {
                    f = -5.0f;
                    break;
                }
                case 5: {
                    f = 5.0f;
                    break;
                }
                case 6: {
                    f = 15.0f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            float modifierValue = f;
            this.addModifier(modifierType, modifierValue);
        }
    }

    public final void signDefensivePact(int duration) {
        this.setModifier(DiplomaticModifiers.DefensivePact, 10.0f);
        this.otherCivDiplomacy().setModifier(DiplomaticModifiers.DefensivePact, 10.0f);
        this.setFlag(DiplomacyFlags.DefensivePact, duration);
        this.otherCivDiplomacy().setFlag(DiplomacyFlags.DefensivePact, duration);
        this.diplomaticStatus = DiplomaticStatus.DefensivePact;
        this.otherCivDiplomacy().diplomaticStatus = DiplomaticStatus.DefensivePact;
        for (Civilization thirdCiv : this.getCommonKnownCivsWithSpectators()) {
            String[] stringArray = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Diplomacy", this.getOtherCivName()};
            thirdCiv.addNotification('[' + this.getCivInfo().getCivName() + "] and [" + this.getOtherCivName() + "] have signed a Defensive Pact!", Notification.NotificationCategory.Diplomacy, stringArray);
            if (thirdCiv.isSpectator()) {
                return;
            }
            DiplomacyManager diplomacyManager = thirdCiv.getDiplomacyManager(this.getCivInfo());
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.setDefensivePactBasedModifier$core();
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponSigningDefensivePact, StateForConditionals.Companion.getIgnoreConditionals(), null, 4, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.otherCiv(), UniqueType.TriggerUponSigningDefensivePact, StateForConditionals.Companion.getIgnoreConditionals(), null, 4, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.otherCiv(), null, null, null, null, null, 124, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setDefensivePactBasedModifier$core() {
        void $this$filterTo$iv$iv;
        this.removeModifier$core(DiplomaticModifiers.SignedDefensivePactWithOurAllies);
        this.removeModifier$core(DiplomaticModifiers.SignedDefensivePactWithOurEnemies);
        Iterable $this$filter$iv = this.getCommonKnownCivs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            DiplomacyManager diplomacyManager = it.getDiplomacyManager(this.getCivInfo());
            Intrinsics.checkNotNull(diplomacyManager);
            if (!diplomacyManager.hasFlag(DiplomacyFlags.DefensivePact)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization thirdCiv : (List)destination$iv$iv) {
            float f;
            DiplomaticModifiers diplomaticModifiers;
            RelationshipLevel relationshipLevel = this.otherCivDiplomacy().relationshipIgnoreAfraid();
            switch (WhenMappings.$EnumSwitchMapping$0[relationshipLevel.ordinal()]) {
                case 3: 
                case 4: {
                    diplomaticModifiers = DiplomaticModifiers.SignedDefensivePactWithOurEnemies;
                    break;
                }
                default: {
                    diplomaticModifiers = DiplomaticModifiers.SignedDefensivePactWithOurAllies;
                }
            }
            DiplomaticModifiers modifierType = diplomaticModifiers;
            switch (WhenMappings.$EnumSwitchMapping$0[relationshipLevel.ordinal()]) {
                case 3: {
                    f = -15.0f;
                    break;
                }
                case 4: {
                    f = -10.0f;
                    break;
                }
                case 5: {
                    f = 2.0f;
                    break;
                }
                case 6: {
                    f = 5.0f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            float modifierValue = f;
            this.addModifier(modifierType, modifierValue);
        }
    }

    public final void setReligionBasedModifier$core() {
        if (this.otherCivDiplomacy().believesSameReligion()) {
            this.setModifier(DiplomaticModifiers.BelieveSameReligion, 5.0f);
        } else {
            this.removeModifier$core(DiplomaticModifiers.BelieveSameReligion);
        }
    }

    public final void denounce() {
        this.setModifier(DiplomaticModifiers.Denunciation, -35.0f);
        this.otherCivDiplomacy().setModifier(DiplomaticModifiers.Denunciation, -35.0f);
        this.setFlag(DiplomacyFlags.Denunciation, 30);
        this.otherCivDiplomacy().setFlag(DiplomacyFlags.Denunciation, 30);
        String[] stringArray = new String[]{"OtherIcons/Diplomacy", this.getCivInfo().getCivName()};
        this.otherCiv().addNotification('[' + this.getCivInfo().getCivName() + "] has denounced us!", Notification.NotificationCategory.Diplomacy, stringArray);
        Iterable $this$forEach$iv = this.getCommonKnownCivsWithSpectators();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Civilization thirdCiv = (Civilization)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Diplomacy", this.getOtherCivName()};
            thirdCiv.addNotification('[' + this.getCivInfo().getCivName() + "] has denounced [" + this.getOtherCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray2);
            if (thirdCiv.isSpectator()) continue;
            DiplomacyManager diplomacyManager = thirdCiv.getDiplomacyManager(this.otherCiv());
            Intrinsics.checkNotNull(diplomacyManager);
            RelationshipLevel thirdCivRelationshipWithOtherCiv = diplomacyManager.relationshipIgnoreAfraid();
            Intrinsics.checkNotNull(thirdCiv.getDiplomacyManager(this.getCivInfo()));
            switch (WhenMappings.$EnumSwitchMapping$0[thirdCivRelationshipWithOtherCiv.ordinal()]) {
                case 3: {
                    DiplomacyManager thirdCivDiplomacyManager;
                    thirdCivDiplomacyManager.addModifier(DiplomaticModifiers.DenouncedOurEnemies, 15.0f);
                    break;
                }
                case 4: {
                    DiplomacyManager thirdCivDiplomacyManager;
                    thirdCivDiplomacyManager.addModifier(DiplomaticModifiers.DenouncedOurEnemies, 5.0f);
                    break;
                }
                case 5: {
                    DiplomacyManager thirdCivDiplomacyManager;
                    thirdCivDiplomacyManager.addModifier(DiplomaticModifiers.DenouncedOurAllies, -5.0f);
                    break;
                }
                case 6: {
                    DiplomacyManager thirdCivDiplomacyManager;
                    thirdCivDiplomacyManager.addModifier(DiplomaticModifiers.DenouncedOurAllies, -15.0f);
                }
            }
        }
    }

    public final void agreeNotToSettleNear() {
        this.otherCivDiplomacy().setFlag(DiplomacyFlags.AgreedToNotSettleNearUs, 100);
        this.addModifier(DiplomaticModifiers.UnacceptableDemands, -10.0f);
        String[] stringArray = new String[]{"OtherIcons/Diplomacy", this.getCivInfo().getCivName()};
        this.otherCiv().addNotification('[' + this.getCivInfo().getCivName() + "] agreed to stop settling cities near us!", Notification.NotificationCategory.Diplomacy, stringArray);
    }

    public final void refuseDemandNotToSettleNear() {
        this.addModifier(DiplomaticModifiers.UnacceptableDemands, -20.0f);
        this.otherCivDiplomacy().setFlag(DiplomacyFlags.IgnoreThemSettlingNearUs, 100);
        this.otherCivDiplomacy().addModifier(DiplomaticModifiers.RefusedToNotSettleCitiesNearUs, -15.0f);
        String[] stringArray = new String[]{"OtherIcons/Diplomacy", this.getCivInfo().getCivName()};
        this.otherCiv().addNotification('[' + this.getCivInfo().getCivName() + "] refused to stop settling cities near us!", Notification.NotificationCategory.Diplomacy, stringArray);
    }

    public final void agreeNotToSpreadReligionTo() {
        this.otherCivDiplomacy().setFlag(DiplomacyFlags.AgreedToNotSpreadReligion, 100);
        this.addModifier(DiplomaticModifiers.UnacceptableDemands, -10.0f);
        String[] stringArray = new String[]{"OtherIcons/Diplomacy", this.getCivInfo().getCivName()};
        this.otherCiv().addNotification('[' + this.getCivInfo().getCivName() + "] agreed to stop spreading religion to us!", Notification.NotificationCategory.Diplomacy, stringArray);
    }

    public final void refuseNotToSpreadReligionTo() {
        this.addModifier(DiplomaticModifiers.UnacceptableDemands, -20.0f);
        this.otherCivDiplomacy().setFlag(DiplomacyFlags.IgnoreThemSpreadingReligion, 100);
        this.otherCivDiplomacy().addModifier(DiplomaticModifiers.RefusedToNotSpreadReligionToUs, -15.0f);
        String[] stringArray = new String[]{"OtherIcons/Diplomacy", this.getCivInfo().getCivName()};
        this.otherCiv().addNotification('[' + this.getCivInfo().getCivName() + "] refused to stop spreading religion to us!", Notification.NotificationCategory.Diplomacy, stringArray);
    }

    public final void sideWithCityState() {
        this.otherCivDiplomacy().setModifier(DiplomaticModifiers.SidedWithProtectedMinor, -5.0f);
        this.otherCivDiplomacy().setFlag(DiplomacyFlags.RememberSidedWithProtectedMinor, 25);
    }

    public final void becomeWary() {
        if (this.hasFlag(DiplomacyFlags.WaryOf)) {
            return;
        }
        this.setFlag(DiplomacyFlags.WaryOf, -1);
        String[] stringArray = new String[]{this.getCivInfo().getCivName()};
        this.otherCiv().addNotification("City-States grow wary of your aggression. The resting point for Influence has decreased by [20] for [" + this.getCivInfo().getCivName() + "].", Notification.NotificationCategory.Diplomacy, stringArray);
    }

    public final void giftGold(int gold, boolean isPureGift) {
        int currentGold = isPureGift ? MathKt.roundToInt((float)gold * this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getGoldGiftMultiplier()) : MathKt.roundToInt((float)gold * this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getGoldGiftTradeMultiplier());
        int otherGold = this.otherCivDiplomacy().getGoldGifts();
        if (otherGold > currentGold) {
            this.otherCivDiplomacy().recieveGoldGifts(-currentGold);
        } else {
            this.otherCivDiplomacy().removeModifier$core(DiplomaticModifiers.GaveUsGifts);
            this.recieveGoldGifts(currentGold - otherGold);
        }
    }

    public final void recieveGoldGifts(int gold) {
        double diplomaticValueOfTrade = (double)gold * new TradeEvaluation().getGoldInflation(this.getCivInfo()) / (double)(this.getCivInfo().getGameInfo().getSpeed().getGoldGiftModifier() * (float)100);
        this.addModifier(DiplomaticModifiers.GaveUsGifts, (float)diplomaticValueOfTrade);
    }

    public final int getGoldGifts() {
        float giftAmount = this.getModifier$core(DiplomaticModifiers.GaveUsGifts);
        return (int)((double)(giftAmount * this.getCivInfo().getGameInfo().getSpeed().getGoldGiftModifier() * (float)100) / new TradeEvaluation().getGoldInflation(this.getCivInfo()));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager$Companion;", "", "()V", "MINIMUM_INFLUENCE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RelationshipLevel.values().length];
            try {
                nArray[RelationshipLevel.Afraid.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Neutral.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Unforgivable.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Enemy.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Friend.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Ally.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

