/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.diplomacy;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.DiplomacyAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.diplomacy.CityStateFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002J\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0005J\f\u0010\b\u001a\u00020\u0007*\u00020\u0005H\u0002J\f\u0010\t\u001a\u00020\u0007*\u00020\u0005H\u0002J\f\u0010\n\u001a\u00020\u0007*\u00020\u0005H\u0002J\f\u0010\u000b\u001a\u00020\u0007*\u00020\u0005H\u0002J\u0014\u0010\f\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0007*\u00020\u0005H\u0002J\u001c\u0010\u0010\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\f\u0010\u0014\u001a\u00020\u0007*\u00020\u0005H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/unciv/logic/civilization/diplomacy/DiplomacyTurnManager;", "", "()V", "getCityStateInfluenceRecovery", "", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "nextTurn", "", "nextTurnCityStateInfluence", "nextTurnDiplomaticModifiers", "nextTurnFlags", "nextTurnTrades", "remakePeaceTreaty", "durationLeft", "", "removeUntenableTrades", "revertToZero", "modifier", "Lcom/unciv/logic/civilization/diplomacy/DiplomaticModifiers;", "amount", "scienceFromResearchAgreement", "core"})
@SourceDebugExtension(value={"SMAP\nDiplomacyTurnManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiplomacyTurnManager.kt\ncom/unciv/logic/civilization/diplomacy/DiplomacyTurnManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,365:1\n766#2:366\n857#2,2:367\n1549#2:369\n1620#2,3:370\n1747#2,3:373\n223#2,2:376\n1747#2,3:378\n766#2:381\n857#2,2:382\n1726#2,3:384\n766#2:387\n857#2,2:388\n1747#2,3:390\n766#2:393\n857#2,2:394\n*S KotlinDebug\n*F\n+ 1 DiplomacyTurnManager.kt\ncom/unciv/logic/civilization/diplomacy/DiplomacyTurnManager\n*L\n34#1:366\n34#1:367,2\n34#1:369\n34#1:370,3\n46#1:373,3\n47#1:376,2\n144#1:378,3\n234#1:381\n234#1:382,2\n238#1:384,3\n240#1:387\n240#1:388,2\n248#1:390,3\n253#1:393\n253#1:394,2\n*E\n"})
public final class DiplomacyTurnManager {
    @NotNull
    public static final DiplomacyTurnManager INSTANCE = new DiplomacyTurnManager();

    private DiplomacyTurnManager() {
    }

    public final void nextTurn(@NotNull DiplomacyManager $this$nextTurn) {
        Intrinsics.checkNotNullParameter($this$nextTurn, "<this>");
        this.nextTurnTrades($this$nextTurn);
        this.removeUntenableTrades($this$nextTurn);
        $this$nextTurn.updateHasOpenBorders();
        this.nextTurnDiplomaticModifiers($this$nextTurn);
        this.nextTurnFlags($this$nextTurn);
        if ($this$nextTurn.getCivInfo().isCityState() && $this$nextTurn.otherCiv().isMajorCiv()) {
            this.nextTurnCityStateInfluence($this$nextTurn);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeUntenableTrades(DiplomacyManager $this$removeUntenableTrades) {
        for (Trade trade : CollectionsKt.toList((Iterable)$this$removeUntenableTrades.getTrades())) {
            Object object;
            TradeOfferType[] $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Object it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = $this$removeUntenableTrades.getCivInfo().getCivResourceSupply();
            boolean $i$f$filter = false;
            void var7_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                it = (ResourceSupplyList.ResourceSupply)t;
                bl = false;
                if (!(((ResourceSupplyList.ResourceSupply)it).getAmount() < 0 && !((ResourceSupplyList.ResourceSupply)it).getResource().isStockpiled())) continue;
                destination$iv$iv.add(t);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                it = (ResourceSupplyList.ResourceSupply)t;
                object = destination$iv$iv;
                bl = false;
                object.add(((ResourceSupplyList.ResourceSupply)it).getResource().getName());
            }
            List negativeCivResources = (List)destination$iv$iv;
            for (TradeOffer offer : trade.getOurOffers()) {
                boolean bl2;
                Iterable $this$any$iv;
                block9: {
                    $this$mapTo$iv$iv = new TradeOfferType[]{TradeOfferType.Luxury_Resource, TradeOfferType.Strategic_Resource};
                    if (!CollectionsKt.listOf($this$mapTo$iv$iv).contains((Object)offer.getType()) || !negativeCivResources.contains(offer.getName()) && $this$removeUntenableTrades.getCivInfo().getGameInfo().getRuleset().getTileResources().containsKey(offer.getName())) continue;
                    $this$removeUntenableTrades.getTrades().remove(trade);
                    DiplomacyManager diplomacyManager = $this$removeUntenableTrades.otherCiv().getDiplomacyManager($this$removeUntenableTrades.getCivInfo());
                    Intrinsics.checkNotNull(diplomacyManager);
                    ArrayList<Trade> otherCivTrades = diplomacyManager.getTrades();
                    CollectionsKt.removeAll((List)otherCivTrades, (Function1)new Function1<Trade, Boolean>(trade){
                        final /* synthetic */ Trade $trade;
                        {
                            this.$trade = $trade;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull Trade it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return it.equalTrade(this.$trade.reverse());
                        }
                    });
                    $this$any$iv = trade.getTheirOffers();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object t : $this$any$iv) {
                            it = (TradeOffer)t;
                            boolean bl22 = false;
                            if (!Intrinsics.areEqual(((TradeOffer)it).getName(), "Peace Treaty")) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    Object t2;
                    DiplomacyManager diplomacyManager;
                    block10: {
                        void $this$first$iv;
                        $this$any$iv = trade.getTheirOffers();
                        diplomacyManager = $this$removeUntenableTrades;
                        object = this;
                        boolean $i$f$first = false;
                        for (Object t2 : $this$first$iv) {
                            it = (TradeOffer)t2;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(((TradeOffer)it).getName(), "Peace Treaty")) continue;
                            break block10;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Object t3 = t2;
                    super.remakePeaceTreaty(diplomacyManager, ((TradeOffer)t3).getDuration());
                }
                String[] stringArray = new String[]{"StatIcons/Acquire", $this$removeUntenableTrades.getOtherCivName()};
                $this$removeUntenableTrades.getCivInfo().addNotification("One of our trades with [" + $this$removeUntenableTrades.getOtherCivName() + "] has been cut short", new DiplomacyAction($this$removeUntenableTrades.getOtherCivName(), true), Notification.NotificationCategory.Trade, stringArray);
                stringArray = new String[]{"StatIcons/Acquire", $this$removeUntenableTrades.getCivInfo().getCivName()};
                $this$removeUntenableTrades.otherCiv().addNotification("One of our trades with [" + $this$removeUntenableTrades.getCivInfo().getCivName() + "] has been cut short", new DiplomacyAction($this$removeUntenableTrades.getCivInfo().getCivName(), true), Notification.NotificationCategory.Trade, stringArray);
                $this$removeUntenableTrades.otherCivDiplomacy().setFlag(DiplomacyFlags.ResourceTradesCutShort, $this$removeUntenableTrades.getCivInfo().getGameInfo().getSpeed().getDealDuration() * 2);
                $this$removeUntenableTrades.getCivInfo().getCache().updateCivResources();
            }
        }
    }

    private final void remakePeaceTreaty(DiplomacyManager $this$remakePeaceTreaty, int durationLeft) {
        Trade treaty = new Trade();
        treaty.getOurOffers().add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, durationLeft, 4, null));
        treaty.getTheirOffers().add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, durationLeft, 4, null));
        $this$remakePeaceTreaty.getTrades().add(treaty);
        DiplomacyManager diplomacyManager = $this$remakePeaceTreaty.otherCiv().getDiplomacyManager($this$remakePeaceTreaty.getCivInfo());
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.getTrades().add(treaty);
    }

    private final void nextTurnCityStateInfluence(DiplomacyManager $this$nextTurnCityStateInfluence) {
        RelationshipLevel initialRelationshipLevel = $this$nextTurnCityStateInfluence.relationshipIgnoreAfraid();
        float restingPoint = $this$nextTurnCityStateInfluence.getCityStateInfluenceRestingPoint$core();
        if ($this$nextTurnCityStateInfluence.getInfluence$core() > restingPoint) {
            float decrement = $this$nextTurnCityStateInfluence.getCityStateInfluenceDegrade$core();
            $this$nextTurnCityStateInfluence.setInfluence(Math.max(restingPoint, $this$nextTurnCityStateInfluence.getInfluence$core() - decrement));
        } else if ($this$nextTurnCityStateInfluence.getInfluence$core() < restingPoint) {
            float increment = this.getCityStateInfluenceRecovery($this$nextTurnCityStateInfluence);
            $this$nextTurnCityStateInfluence.setInfluence(Math.min(restingPoint, $this$nextTurnCityStateInfluence.getInfluence$core() + increment));
        }
        if (!$this$nextTurnCityStateInfluence.getCivInfo().isDefeated()) {
            String[] stringArray;
            String text2;
            Sequence<NotificationAction> notificationActions2 = $this$nextTurnCityStateInfluence.getCivInfo().getCityStateFunctions().getNotificationActions();
            if ($this$nextTurnCityStateInfluence.getTurnsToRelationshipChange() == 1) {
                text2 = "Your relationship with [" + $this$nextTurnCityStateInfluence.getCivInfo().getCivName() + "] is about to degrade";
                stringArray = new String[]{$this$nextTurnCityStateInfluence.getCivInfo().getCivName(), "OtherIcons/Diplomacy"};
                $this$nextTurnCityStateInfluence.otherCiv().addNotification(text2, notificationActions2, Notification.NotificationCategory.Diplomacy, stringArray);
            }
            if (initialRelationshipLevel.compareTo((Enum)RelationshipLevel.Friend) >= 0 && initialRelationshipLevel != $this$nextTurnCityStateInfluence.relationshipIgnoreAfraid()) {
                text2 = "Your relationship with [" + $this$nextTurnCityStateInfluence.getCivInfo().getCivName() + "] degraded";
                stringArray = new String[]{$this$nextTurnCityStateInfluence.getCivInfo().getCivName(), "OtherIcons/Diplomacy"};
                $this$nextTurnCityStateInfluence.otherCiv().addNotification(text2, notificationActions2, Notification.NotificationCategory.Diplomacy, stringArray);
            }
            if ($this$nextTurnCityStateInfluence.getInfluence() < 30.0f && !$this$nextTurnCityStateInfluence.hasFlag(DiplomacyFlags.NotifiedAfraid) && CityStateFunctions.getTributeWillingness$default($this$nextTurnCityStateInfluence.getCivInfo().getCityStateFunctions(), $this$nextTurnCityStateInfluence.otherCiv(), false, 2, null) > 0 && $this$nextTurnCityStateInfluence.otherCiv().isMajorCiv()) {
                $this$nextTurnCityStateInfluence.setFlag(DiplomacyFlags.NotifiedAfraid, 20);
                text2 = '[' + $this$nextTurnCityStateInfluence.getCivInfo().getCivName() + "] is afraid of your military power!";
                stringArray = new String[]{$this$nextTurnCityStateInfluence.getCivInfo().getCivName(), "OtherIcons/Diplomacy"};
                $this$nextTurnCityStateInfluence.otherCiv().addNotification(text2, notificationActions2, Notification.NotificationCategory.Diplomacy, stringArray);
            }
        }
    }

    private final float getCityStateInfluenceRecovery(DiplomacyManager $this$getCityStateInfluenceRecovery) {
        String religion;
        String string;
        if ($this$getCityStateInfluenceRecovery.getInfluence() >= $this$getCityStateInfluenceRecovery.getCityStateInfluenceRestingPoint$core()) {
            return 0.0f;
        }
        float increment = 1.0f;
        float modifierPercent = 0.0f;
        if (Civilization.hasUnique$default($this$getCityStateInfluenceRecovery.otherCiv(), UniqueType.CityStateInfluenceRecoversTwiceNormalRate, null, 2, null)) {
            modifierPercent += 100.0f;
        }
        if ($this$getCityStateInfluenceRecovery.getCivInfo().getCities().isEmpty() || Civilization.getCapital$default($this$getCityStateInfluenceRecovery.getCivInfo(), false, 1, null) == null) {
            string = null;
        } else {
            City city2 = Civilization.getCapital$default($this$getCityStateInfluenceRecovery.getCivInfo(), false, 1, null);
            Intrinsics.checkNotNull(city2);
            string = religion = city2.getReligion().getMajorityReligionName();
        }
        if (religion != null) {
            Religion religion2 = $this$getCityStateInfluenceRecovery.otherCiv().getReligionManager().getReligion();
            if (Intrinsics.areEqual(religion, religion2 != null ? religion2.getName() : null)) {
                modifierPercent += 50.0f;
            }
        }
        return Math.max(0.0f, increment) * FormattingExtensionsKt.toPercent(Math.max(0.0f, modifierPercent));
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    private final void nextTurnFlags(DiplomacyManager $this$nextTurnFlags) {
        v0 = $this$nextTurnFlags.getFlagsCountdown$core().keySet();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-keys>(...)");
        block29: for (String flag : CollectionsKt.toList((Iterable)v0)) {
            block47: {
                v1 = $this$nextTurnFlags.getFlagsCountdown$core();
                Intrinsics.checkNotNull(flag);
                v2 = $this$nextTurnFlags.getFlagsCountdown$core().get(flag);
                Intrinsics.checkNotNull(v2);
                v1.put(flag, ((Number)v2).intValue() - 1);
                if (Intrinsics.areEqual(flag, "ProvideMilitaryUnit") && $this$nextTurnFlags.getCivInfo().isMajorCiv() && $this$nextTurnFlags.otherCiv().isCityState()) {
                    block46: {
                        $this$any$iv = $this$nextTurnFlags.getCivInfo().getGameInfo().getCivilizations();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v3 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (Civilization)element$iv;
                                $i$a$-any-DiplomacyTurnManager$nextTurnFlags$1 = false;
                                if (!($this$nextTurnFlags.getCivInfo().isAtWarWith(it) != false && $this$nextTurnFlags.otherCiv().isAtWarWith(it) != false)) continue;
                                v3 = true;
                                break block46;
                            }
                            v3 = false;
                        }
                    }
                    if (v3) {
                        var4_4 = Civilization.getMatchingUniques$default($this$nextTurnFlags.getCivInfo(), UniqueType.CityStateMoreGiftedUnits, null, 2, null).iterator();
                        while (var4_4.hasNext()) {
                            unique = (Unique)var4_4.next();
                            v4 = $this$nextTurnFlags.getFlagsCountdown$core();
                            v5 = $this$nextTurnFlags.getFlagsCountdown$core().get("ProvideMilitaryUnit");
                            Intrinsics.checkNotNull(v5);
                            v4.put("ProvideMilitaryUnit", ((Number)v5).intValue() - Integer.parseInt(unique.getParams().get(0)) + 1);
                            v6 = $this$nextTurnFlags.getFlagsCountdown$core().get("ProvideMilitaryUnit");
                            Intrinsics.checkNotNull(v6);
                            if (((Number)v6).intValue() > 0) continue;
                            ((Map)$this$nextTurnFlags.getFlagsCountdown$core()).put("ProvideMilitaryUnit", 0);
                            break;
                        }
                    }
                }
                switch (flag.hashCode()) {
                    case -1616212337: {
                        if (!flag.equals("ResearchAgreement")) break;
                        $this$nextTurnFlags.setTotalOfScienceDuringRA$core($this$nextTurnFlags.getTotalOfScienceDuringRA$core() + (int)$this$nextTurnFlags.getCivInfo().getStats().getStatsForNextTurn().getScience());
                    }
                }
                v7 = $this$nextTurnFlags.getFlagsCountdown$core().get(flag);
                var4_5 = 50;
                if (v7 != null && v7 == var4_5) {
                    var4_6 = flag;
                    switch (var4_6.hashCode()) {
                        case 990578735: {
                            if (var4_6.equals("RememberBulliedProtectedMinor")) break;
                            ** break;
                        }
                        case 151938171: {
                            if (!var4_6.equals("RememberAttackedProtectedMinor")) ** break;
                            $this$nextTurnFlags.addModifier(DiplomaticModifiers.AttackedProtectedMinor, 5.0f);
                            ** break;
                        }
                    }
                    $this$nextTurnFlags.addModifier(DiplomaticModifiers.BulliedProtectedMinor, 5.0f);
                }
lbl57:
                // 7 sources

                v8 = $this$nextTurnFlags.getFlagsCountdown$core().get(flag);
                if (v8 == null || v8 != 0) break block47;
                var4_7 = flag;
                tmp = -1;
                switch (var4_7.hashCode()) {
                    case 408134994: {
                        if (var4_7.equals("ProvideMilitaryUnit")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 990578735: {
                        if (var4_7.equals("RememberBulliedProtectedMinor")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case -1616212337: {
                        if (var4_7.equals("ResearchAgreement")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 151938171: {
                        if (var4_7.equals("RememberAttackedProtectedMinor")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case -440816623: {
                        if (var4_7.equals("AgreedToNotSettleNearUs")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case 1828341171: {
                        if (var4_7.equals("RememberDestroyedProtectedMinor")) {
                            tmp = 6;
                        }
                        break;
                    }
                    case 2011461229: {
                        if (var4_7.equals("RememberSidedWithProtectedMinor")) {
                            tmp = 7;
                        }
                        break;
                    }
                    case 872526415: {
                        if (var4_7.equals("RecentlyAttacked")) {
                            tmp = 8;
                        }
                        break;
                    }
                    case -116723563: {
                        if (var4_7.equals("DefensivePact")) {
                            tmp = 9;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 3: {
                        if ($this$nextTurnFlags.otherCivDiplomacy().hasFlag(DiplomacyFlags.ResearchAgreement)) break;
                        this.scienceFromResearchAgreement($this$nextTurnFlags);
                        break;
                    }
                    case 9: {
                        $this$nextTurnFlags.setDiplomaticStatus(DiplomaticStatus.Peace);
                        break;
                    }
                    case 1: {
                        if ($this$nextTurnFlags.getCivInfo().getCities().isEmpty() || $this$nextTurnFlags.otherCiv().getCities().isEmpty()) continue block29;
                        $this$nextTurnFlags.otherCiv().getCityStateFunctions().giveMilitaryUnitToPatron($this$nextTurnFlags.getCivInfo());
                        break;
                    }
                    case 5: {
                        $this$nextTurnFlags.addModifier(DiplomaticModifiers.FulfilledPromiseToNotSettleCitiesNearUs, 10.0f);
                        break;
                    }
                    case 8: {
                        $this$nextTurnFlags.getCivInfo().getCityStateFunctions().askForUnitGifts($this$nextTurnFlags.otherCiv());
                        break;
                    }
                    case 6: {
                        $this$nextTurnFlags.removeModifier$core(DiplomaticModifiers.DestroyedProtectedMinor);
                        break;
                    }
                    case 4: {
                        $this$nextTurnFlags.removeModifier$core(DiplomaticModifiers.AttackedProtectedMinor);
                        break;
                    }
                    case 2: {
                        $this$nextTurnFlags.removeModifier$core(DiplomaticModifiers.BulliedProtectedMinor);
                        break;
                    }
                    case 7: {
                        $this$nextTurnFlags.removeModifier$core(DiplomaticModifiers.SidedWithProtectedMinor);
                    }
                }
                $this$nextTurnFlags.getFlagsCountdown$core().remove(flag);
                continue;
            }
            if (!Intrinsics.areEqual(flag, "WaryOf")) continue;
            v9 = $this$nextTurnFlags.getFlagsCountdown$core().get(flag);
            Intrinsics.checkNotNull(v9);
            if (((Number)v9).intValue() >= -10) continue;
            $this$nextTurnFlags.getFlagsCountdown$core().remove(flag);
        }
    }

    private final void scienceFromResearchAgreement(DiplomacyManager $this$scienceFromResearchAgreement) {
        int scienceFromResearchAgreement = Math.min($this$scienceFromResearchAgreement.getTotalOfScienceDuringRA$core(), $this$scienceFromResearchAgreement.otherCivDiplomacy().getTotalOfScienceDuringRA$core());
        TechManager techManager = $this$scienceFromResearchAgreement.getCivInfo().getTech();
        techManager.setScienceFromResearchAgreements(techManager.getScienceFromResearchAgreements() + scienceFromResearchAgreement);
        techManager = $this$scienceFromResearchAgreement.otherCiv().getTech();
        techManager.setScienceFromResearchAgreements(techManager.getScienceFromResearchAgreements() + scienceFromResearchAgreement);
        $this$scienceFromResearchAgreement.setTotalOfScienceDuringRA$core(0);
        $this$scienceFromResearchAgreement.otherCivDiplomacy().setTotalOfScienceDuringRA$core(0);
    }

    private final void nextTurnTrades(DiplomacyManager $this$nextTurnTrades) {
        for (Trade trade : CollectionsKt.toList((Iterable)$this$nextTurnTrades.getTrades())) {
            Iterable $this$any$iv;
            TradeOffer it;
            boolean bl;
            boolean $i$f$all;
            Iterable $this$all$iv;
            Object $this$filterTo$iv$iv;
            boolean $i$f$filterTo;
            Collection destination$iv$iv;
            int $i$f$filter;
            Iterable $this$filter$iv;
            block19: {
                $this$filter$iv = CollectionsKt.union(trade.getOurOffers(), trade.getTheirOffers());
                $i$f$filter = 0;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object t : $this$filterTo$iv$iv) {
                    TradeOffer it2 = (TradeOffer)t;
                    boolean bl2 = false;
                    if (!(it2.getDuration() > 0)) continue;
                    destination$iv$iv.add(t);
                }
                for (TradeOffer offer : (List)destination$iv$iv) {
                    $i$f$filter = offer.getDuration();
                    offer.setDuration($i$f$filter + -1);
                }
                $this$all$iv = trade.getOurOffers();
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (TradeOffer)element$iv;
                        boolean bl3 = false;
                        if (it.getDuration() <= 0) continue;
                        bl = false;
                        break block19;
                    }
                    bl = true;
                }
            }
            if (bl) {
                boolean bl2;
                block20: {
                    $this$all$iv = trade.getTheirOffers();
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (TradeOffer)element$iv;
                            boolean bl5 = false;
                            if (it.getDuration() <= 0) continue;
                            bl2 = false;
                            break block20;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    Object element$iv;
                    $this$nextTurnTrades.getTrades().remove(trade);
                    Iterable $this$filter$iv2 = CollectionsKt.union(trade.getOurOffers(), trade.getTheirOffers());
                    $i$f$filter = 0;
                    element$iv = $this$filter$iv2;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object t : $this$filterTo$iv$iv) {
                        TradeOffer it2 = (TradeOffer)t;
                        boolean bl6 = false;
                        if (!(it2.getDuration() == 0)) continue;
                        destination$iv$iv.add(t);
                    }
                    for (TradeOffer offer : (List)destination$iv$iv) {
                        boolean bl3;
                        block21: {
                            String direction = trade.getTheirOffers().contains((Object)offer) ? "from" : "to";
                            $this$filterTo$iv$iv = new String[]{$this$nextTurnTrades.getOtherCivName(), "StatIcons/Acquire"};
                            $this$nextTurnTrades.getCivInfo().addNotification('[' + offer.getName() + "] " + direction + " [" + $this$nextTurnTrades.getOtherCivName() + "] has ended", new DiplomacyAction($this$nextTurnTrades.getOtherCivName(), true), Notification.NotificationCategory.Trade, (String)$this$filterTo$iv$iv);
                            $this$nextTurnTrades.getCivInfo().updateStatsForNextTurn();
                            $this$filterTo$iv$iv = CollectionsKt.union(trade.getTheirOffers(), trade.getOurOffers());
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    TradeOffer tradeOffer = (TradeOffer)element$iv2;
                                    boolean bl8 = false;
                                    if (!(tradeOffer.getType() == TradeOfferType.Luxury_Resource || tradeOffer.getType() == TradeOfferType.Strategic_Resource)) continue;
                                    bl3 = true;
                                    break block21;
                                }
                                bl3 = false;
                            }
                        }
                        if (!bl3) continue;
                        $this$nextTurnTrades.getCivInfo().getCache().updateCivResources();
                    }
                }
            }
            $this$filter$iv = trade.getTheirOffers();
            $i$f$filter = 0;
            $this$any$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                TradeOffer it4 = (TradeOffer)t;
                boolean bl9 = false;
                if (!(it4.getDuration() <= 3)) continue;
                destination$iv$iv.add(t);
            }
            for (TradeOffer offer : (List)destination$iv$iv) {
                if (offer.getDuration() == 3) {
                    String[] stringArray = new String[]{$this$nextTurnTrades.getOtherCivName(), "StatIcons/Acquire"};
                    $this$nextTurnTrades.getCivInfo().addNotification('[' + offer.getName() + "] from [" + $this$nextTurnTrades.getOtherCivName() + "] will end in [3] turns", new DiplomacyAction($this$nextTurnTrades.getOtherCivName(), true), Notification.NotificationCategory.Trade, stringArray);
                    continue;
                }
                if (offer.getDuration() != 1) continue;
                String[] stringArray = new String[]{$this$nextTurnTrades.getOtherCivName(), "StatIcons/Acquire"};
                $this$nextTurnTrades.getCivInfo().addNotification('[' + offer.getName() + "] from [" + $this$nextTurnTrades.getOtherCivName() + "] will end next turn", new DiplomacyAction($this$nextTurnTrades.getOtherCivName(), true), Notification.NotificationCategory.Trade, stringArray);
            }
        }
    }

    private final void nextTurnDiplomaticModifiers(DiplomacyManager $this$nextTurnDiplomaticModifiers) {
        if ($this$nextTurnDiplomaticModifiers.getDiplomaticStatus() == DiplomaticStatus.Peace) {
            if ($this$nextTurnDiplomaticModifiers.getModifier$core(DiplomaticModifiers.YearsOfPeace) < 30.0f) {
                $this$nextTurnDiplomaticModifiers.addModifier(DiplomaticModifiers.YearsOfPeace, 0.5f);
            }
        } else {
            this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.YearsOfPeace, 0.5f);
        }
        int openBorders = 0;
        if ($this$nextTurnDiplomaticModifiers.getHasOpenBorders()) {
            ++openBorders;
        }
        if ($this$nextTurnDiplomaticModifiers.otherCivDiplomacy().getHasOpenBorders()) {
            ++openBorders;
        }
        if (openBorders > 0) {
            $this$nextTurnDiplomaticModifiers.addModifier(DiplomaticModifiers.OpenBorders, (float)openBorders / 8.0f);
        } else {
            this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.OpenBorders, 0.125f);
        }
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.DeclaredWarOnUs, 0.125f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.WarMongerer, 0.5f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.CapturedOurCities, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.BetrayedDeclarationOfFriendship, 0.125f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.BetrayedDefensivePact, 0.0625f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.RefusedToNotSettleCitiesNearUs, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.BetrayedPromiseToNotSettleCitiesNearUs, 0.125f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.BetrayedPromiseToNotSpreadReligionToUs, 0.125f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.UnacceptableDemands, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.StealingTerritory, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.DenouncedOurAllies, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.DenouncedOurEnemies, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.Denunciation, 0.125f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.SpiedOnUs, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.StoleOurAlly, 0.5f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.GaveUsUnits, 0.25f);
        this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.LiberatedCity, 0.125f);
        if ($this$nextTurnDiplomaticModifiers.hasModifier(DiplomaticModifiers.GaveUsGifts)) {
            float giftLoss = ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Ally ? 1.0f : ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Friend ? 1.5f : ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Favorable ? 2.0f : ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Neutral ? 2.5f : ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Competitor ? 5.0f : ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Enemy ? 7.5f : ($this$nextTurnDiplomaticModifiers.relationshipLevel() == RelationshipLevel.Unforgivable ? 10.0f : 2.5f))))))) * $this$nextTurnDiplomaticModifiers.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getGoldGiftDegradationMultiplier();
            float amountLost = RangesKt.coerceAtLeast(Math.abs($this$nextTurnDiplomaticModifiers.getModifier$core(DiplomaticModifiers.GaveUsGifts)) * giftLoss / (float)100, giftLoss / (float)5);
            this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.GaveUsGifts, amountLost);
        }
        $this$nextTurnDiplomaticModifiers.setFriendshipBasedModifier$core();
        $this$nextTurnDiplomaticModifiers.setDefensivePactBasedModifier$core();
        $this$nextTurnDiplomaticModifiers.setReligionBasedModifier$core();
        if (!$this$nextTurnDiplomaticModifiers.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) {
            this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.DeclarationOfFriendship, 0.5f);
        }
        if (!$this$nextTurnDiplomaticModifiers.hasFlag(DiplomacyFlags.DefensivePact)) {
            this.revertToZero($this$nextTurnDiplomaticModifiers, DiplomaticModifiers.DefensivePact, 1.0f);
        }
        if (!$this$nextTurnDiplomaticModifiers.otherCiv().isCityState()) {
            return;
        }
        if ($this$nextTurnDiplomaticModifiers.isRelationshipLevelLT(RelationshipLevel.Friend)) {
            if ($this$nextTurnDiplomaticModifiers.hasFlag(DiplomacyFlags.ProvideMilitaryUnit)) {
                $this$nextTurnDiplomaticModifiers.removeFlag(DiplomacyFlags.ProvideMilitaryUnit);
            }
            return;
        }
        Integer[] amountLost = new Integer[]{-1, 0, 1};
        int variance = ((Number)CollectionsKt.random((Collection)CollectionsKt.listOf(amountLost), Random.Default)).intValue();
        List<Unique> provideMilitaryUnitUniques2 = SequencesKt.toList(SequencesKt.filter($this$nextTurnDiplomaticModifiers.getCivInfo().getCityStateFunctions().getCityStateBonuses($this$nextTurnDiplomaticModifiers.otherCiv().getCityStateType(), $this$nextTurnDiplomaticModifiers.relationshipIgnoreAfraid(), UniqueType.CityStateMilitaryUnits), (Function1)new Function1<Unique, Boolean>($this$nextTurnDiplomaticModifiers){
            final /* synthetic */ DiplomacyManager $this_nextTurnDiplomaticModifiers;
            {
                this.$this_nextTurnDiplomaticModifiers = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Unique it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.conditionalsApply(this.$this_nextTurnDiplomaticModifiers.getCivInfo().getState());
            }
        }));
        if (provideMilitaryUnitUniques2.isEmpty()) {
            $this$nextTurnDiplomaticModifiers.removeFlag(DiplomacyFlags.ProvideMilitaryUnit);
        }
        for (Unique unique : provideMilitaryUnitUniques2) {
            if ($this$nextTurnDiplomaticModifiers.hasFlag(DiplomacyFlags.ProvideMilitaryUnit) && $this$nextTurnDiplomaticModifiers.getFlag(DiplomacyFlags.ProvideMilitaryUnit) <= Integer.parseInt(unique.getParams().get(0))) continue;
            $this$nextTurnDiplomaticModifiers.setFlag(DiplomacyFlags.ProvideMilitaryUnit, Integer.parseInt(unique.getParams().get(0)) + variance);
        }
    }

    private final void revertToZero(DiplomacyManager $this$revertToZero, DiplomaticModifiers modifier, float amount) {
        if (!$this$revertToZero.hasModifier(modifier)) {
            return;
        }
        float currentAmount = $this$revertToZero.getModifier$core(modifier);
        if (amount >= Math.abs(currentAmount)) {
            $this$revertToZero.getDiplomaticModifiers().remove(modifier.name());
        } else if (currentAmount > 0.0f) {
            $this$revertToZero.addModifier(modifier, -amount);
        } else {
            $this$revertToZero.addModifier(modifier, amount);
        }
    }
}

