/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.managers.CityReligionManager;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.ReligionState;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Counter;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.BeliefType;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionModifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010$\u001a\u00020\u001dJ\u0010\u0010%\u001a\u00020\u001d2\b\b\u0002\u0010&\u001a\u00020\u001dJ\u001e\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\b\b\u0002\u0010,\u001a\u00020\u001dJ\u0006\u0010-\u001a\u00020\u0000J\u000e\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020\u001fJ\u0006\u00100\u001a\u00020\u001fJ\u0010\u00101\u001a\u00020\u001f2\b\b\u0002\u00102\u001a\u00020\u001fJ\u0018\u00103\u001a\u00020(2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\u001dH\u0002J\u000e\u00106\u001a\u00020(2\u0006\u00107\u001a\u000208J\u001d\u00106\u001a\u00020(2\u0006\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b;J\b\u0010<\u001a\u00020\u001fH\u0002J\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\fJ\b\u0010?\u001a\u00020(H\u0002J\f\u0010@\u001a\b\u0012\u0004\u0012\u00020>0\fJ\f\u0010A\u001a\b\u0012\u0004\u0012\u00020>0\fJ\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020>0\f2\u0006\u0010C\u001a\u00020\u001dH\u0002J\b\u0010D\u001a\u0004\u0018\u00010EJ\b\u0010F\u001a\u0004\u0018\u00010GJ\b\u0010H\u001a\u0004\u0018\u00010\u0012J\u0010\u0010I\u001a\u0004\u0018\u00010\u00122\u0006\u0010J\u001a\u00020+J\u0006\u0010K\u001a\u00020\u001fJ\u0006\u0010L\u001a\u00020\u001dJ\u000e\u0010M\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010N\u001a\u00020\u001fH\u0002J\u0006\u0010O\u001a\u00020\u001dJ\u000e\u0010P\u001a\u00020\u001d2\u0006\u0010Q\u001a\u00020RJ\u0006\u0010S\u001a\u00020\u001dJ\u000e\u0010T\u001a\u00020\u001d2\u0006\u0010Q\u001a\u00020RJ\u000e\u0010U\u001a\u00020\u001d2\u0006\u0010V\u001a\u000208J\u000e\u0010W\u001a\u00020\u001d2\u0006\u0010V\u001a\u000208J\u000e\u0010X\u001a\u00020\u001f2\u0006\u0010Y\u001a\u00020>J\u0006\u0010Z\u001a\u00020\u001fJ\u000e\u0010[\u001a\u00020\u001f2\u0006\u0010\\\u001a\u00020\nJ\u0006\u0010]\u001a\u00020\u001fJ\u0018\u0010^\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001f0`0_J\u000e\u0010a\u001a\u00020(2\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010b\u001a\u00020(J\u000e\u0010c\u001a\u00020(2\u0006\u00107\u001a\u000208J\u0006\u0010d\u001a\u00020\u001dR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006e"}, d2={"Lcom/unciv/logic/civilization/managers/ReligionManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "foundingCityId", "", "freeBeliefs", "Lcom/unciv/models/Counter;", "getFreeBeliefs", "()Lcom/unciv/models/Counter;", "setFreeBeliefs", "(Lcom/unciv/models/Counter;)V", "religion", "Lcom/unciv/models/Religion;", "getReligion", "()Lcom/unciv/models/Religion;", "setReligion", "(Lcom/unciv/models/Religion;)V", "<set-?>", "Lcom/unciv/logic/civilization/managers/ReligionState;", "religionState", "getReligionState", "()Lcom/unciv/logic/civilization/managers/ReligionState;", "shouldChoosePantheonBelief", "", "storedFaith", "", "getStoredFaith", "()I", "setStoredFaith", "(I)V", "canFoundOrExpandPantheon", "canGenerateProphet", "ignoreFaithAmount", "chooseBeliefs", "", "beliefs", "", "Lcom/unciv/models/ruleset/Belief;", "useFreeBeliefs", "clone", "endTurn", "faithFromNewTurn", "faithForNextGreatProphet", "faithForPantheon", "additionalCivs", "foundPantheon", "beliefName", "useFreeBelief", "foundReligion", "prophet", "Lcom/unciv/logic/map/mapunit/MapUnit;", "displayName", "name", "foundReligion$core", "foundedReligionsCount", "freeBeliefsAsEnums", "Lcom/unciv/models/ruleset/BeliefType;", "generateProphet", "getBeliefsToChooseAtEnhancing", "getBeliefsToChooseAtFounding", "getBeliefsToChooseAtProphetUse", "enhancingReligion", "getGreatProphetEquivalent", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "getHolyCity", "Lcom/unciv/logic/city/City;", "getMajorityReligion", "getReligionWithBelief", "belief", "greatProphetsEarned", "hasFreeBeliefs", "isMajorityReligionForCiv", "maxNumberOfReligions", "mayEnhanceReligionAtAll", "mayEnhanceReligionHere", "tile", "Lcom/unciv/logic/map/tile/Tile;", "mayFoundReligionAtAll", "mayFoundReligionHere", "maySpreadReligionAtAll", "missionary", "maySpreadReligionNow", "numberOfBeliefsAvailable", "type", "numberOfCitiesFollowingThisReligion", "numberOfFollowersFollowingThisReligion", "cityFilter", "remainingFoundableReligions", "remainingFoundableReligionsBreakdown", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "setTransients", "startTurn", "useProphetForEnhancingReligion", "usingFreeBeliefs", "core"})
@SourceDebugExtension(value={"SMAP\nReligionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReligionManager.kt\ncom/unciv/logic/civilization/managers/ReligionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,514:1\n288#2,2:515\n288#2,2:517\n1774#2,4:519\n1774#2,4:523\n1747#2,3:527\n1774#2,4:530\n288#2,2:534\n1774#2,4:536\n1774#2,4:540\n1774#2,4:544\n288#2,2:554\n1747#2,3:556\n766#2:559\n857#2,2:560\n223#2,2:562\n89#3:548\n111#3,5:549\n1268#4,3:564\n179#4,2:568\n1#5:567\n*S KotlinDebug\n*F\n+ 1 ReligionManager.kt\ncom/unciv/logic/civilization/managers/ReligionManager\n*L\n69#1:515,2\n74#1:517,2\n88#1:519,4\n112#1:523,4\n125#1:527,3\n126#1:530,4\n175#1:534,2\n200#1:536,4\n205#1:540,4\n253#1:544,4\n259#1:554,2\n405#1:556,3\n410#1:559\n410#1:560,2\n427#1:562,2\n254#1:548\n254#1:549,5\n461#1:564,3\n473#1:568,2\n*E\n"})
public final class ReligionManager
implements IsPartOfGameInfoSerialization {
    public transient Civilization civInfo;
    private int storedFaith;
    @Nullable
    private transient Religion religion;
    @NotNull
    private ReligionState religionState = ReligionState.None;
    @NotNull
    private Counter<String> freeBeliefs = new Counter(null, 1, null);
    @Nullable
    private String foundingCityId;
    private boolean shouldChoosePantheonBelief;

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    public final int getStoredFaith() {
        return this.storedFaith;
    }

    public final void setStoredFaith(int n) {
        this.storedFaith = n;
    }

    @Nullable
    public final Religion getReligion() {
        return this.religion;
    }

    public final void setReligion(@Nullable Religion religion) {
        this.religion = religion;
    }

    @NotNull
    public final ReligionState getReligionState() {
        return this.religionState;
    }

    @NotNull
    public final Counter<String> getFreeBeliefs() {
        return this.freeBeliefs;
    }

    public final void setFreeBeliefs(@NotNull Counter<String> counter) {
        Intrinsics.checkNotNullParameter(counter, "<set-?>");
        this.freeBeliefs = counter;
    }

    @NotNull
    public final ReligionManager clone() {
        ReligionManager clone2 = new ReligionManager();
        clone2.foundingCityId = this.foundingCityId;
        clone2.shouldChoosePantheonBelief = this.shouldChoosePantheonBelief;
        clone2.storedFaith = this.storedFaith;
        clone2.religionState = this.religionState;
        clone2.freeBeliefs.putAll((Map)this.freeBeliefs);
        return clone2;
    }

    public final void setTransients(@NotNull Civilization civInfo) {
        Object v3;
        block4: {
            Object v1;
            Religion it;
            Iterable $this$firstOrNull$iv;
            boolean $i$f$firstOrNull;
            ReligionManager religionManager;
            block3: {
                Intrinsics.checkNotNullParameter(civInfo, "civInfo");
                this.setCivInfo(civInfo);
                Collection<Religion> collection = civInfo.getGameInfo().getReligions().values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                Iterable iterable = collection;
                religionManager = this;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (Religion)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual(it.getFoundingCivName(), civInfo.getCivName()) && it.isMajorReligion())) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            religionManager.religion = v1;
            if (this.religion != null) {
                return;
            }
            Collection<Religion> collection = civInfo.getGameInfo().getReligions().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            $this$firstOrNull$iv = collection;
            religionManager = this;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Religion)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getFoundingCivName(), civInfo.getCivName())) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        religionManager.religion = v3;
    }

    public final void startTurn() {
        if (ReligionManager.canGenerateProphet$default(this, false, 1, null)) {
            this.generateProphet();
        }
    }

    public final void endTurn(int faithFromNewTurn) {
        this.storedFaith += faithFromNewTurn;
    }

    public final boolean isMajorityReligionForCiv(@NotNull Religion religion) {
        int n;
        Intrinsics.checkNotNullParameter(religion, "religion");
        Iterable $this$count$iv = this.getCivInfo().getCities();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                City it = (City)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getReligion().getMajorityReligion(), religion) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n > this.getCivInfo().getCities().size() / 2;
    }

    @NotNull
    public final Counter<BeliefType> freeBeliefsAsEnums() {
        Counter<BeliefType> toReturn = new Counter<BeliefType>(null, 1, null);
        for (Map.Entry<String, Integer> entry : this.freeBeliefs.entrySet()) {
            String string = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(string, "<get-key>(...)");
            BeliefType beliefType = BeliefType.valueOf(string);
            Integer n = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(n, "<get-value>(...)");
            toReturn.add(beliefType, ((Number)n).intValue());
        }
        return toReturn;
    }

    public final boolean hasFreeBeliefs() {
        return this.freeBeliefs.sumValues() > 0;
    }

    public final boolean usingFreeBeliefs() {
        return this.religionState == ReligionState.None && this.storedFaith < ReligionManager.faithForPantheon$default(this, 0, 1, null) || this.religionState == ReligionState.Pantheon || this.religionState == ReligionState.Religion || this.religionState == ReligionState.EnhancedReligion;
    }

    /*
     * WARNING - void declaration
     */
    public final int faithForPantheon(int additionalCivs) {
        int n;
        void $this$count$iv;
        GameInfo gameInfo = this.getCivInfo().getGameInfo();
        Iterable iterable = gameInfo.getCivilizations();
        int n2 = additionalCivs;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                if (!(it.isMajorCiv() && it.getReligionManager().religion != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n3 = n;
        int numCivs = n2 + n3;
        int cost = gameInfo.getRuleset().getModOptions().getConstants().getPantheonBase() + numCivs * gameInfo.getRuleset().getModOptions().getConstants().getPantheonGrowth();
        return MathKt.roundToInt((float)cost * gameInfo.getSpeed().getFaithCostModifier());
    }

    public static /* synthetic */ int faithForPantheon$default(ReligionManager religionManager, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return religionManager.faithForPantheon(n);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean canFoundOrExpandPantheon() {
        boolean bl;
        block12: {
            if (!this.getCivInfo().getGameInfo().isReligionEnabled()) {
                return false;
            }
            if (this.religionState.compareTo((Enum)ReligionState.Pantheon) > 0) {
                return false;
            }
            if (!this.getCivInfo().isMajorCiv()) {
                return false;
            }
            if (this.numberOfBeliefsAvailable(BeliefType.Pantheon) == 0) {
                return false;
            }
            Iterable $this$any$iv = this.getCivInfo().getGameInfo().getCivilizations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl2 = false;
                    if (!(it.getReligionManager().religionState == ReligionState.EnhancedReligion)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            int n;
            Iterable $this$count$iv = this.getCivInfo().getGameInfo().getCivilizations();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                void var3_4;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl3 = false;
                    if (!(it.getReligionManager().religionState.compareTo((Enum)ReligionState.Pantheon) >= 0) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = var3_4;
            }
            if (n >= this.maxNumberOfReligions()) {
                return false;
            }
        }
        return this.religionState == ReligionState.None && this.storedFaith >= ReligionManager.faithForPantheon$default(this, 0, 1, null) || ((Number)this.freeBeliefs.get((Object)"Pantheon")).intValue() > 0;
    }

    private final void foundPantheon(String beliefName, boolean useFreeBelief) {
        if (!useFreeBelief) {
            this.storedFaith -= ReligionManager.faithForPantheon$default(this, 0, 1, null);
        }
        this.religion = new Religion(beliefName, this.getCivInfo().getGameInfo(), this.getCivInfo().getCivName());
        Map map2 = this.getCivInfo().getGameInfo().getReligions();
        Religion religion = this.religion;
        Intrinsics.checkNotNull(religion);
        map2.put(beliefName, religion);
        for (City city2 : this.getCivInfo().getCities()) {
            CityReligionManager.addPressure$default(city2.getReligion(), beliefName, 200 * city2.getPopulation().getPopulation(), false, 4, null);
        }
    }

    public final int greatProphetsEarned() {
        Counter<String> counter = this.getCivInfo().getCivConstructions().getBoughtItemsWithIncreasingPrice();
        Object object = this.getGreatProphetEquivalent();
        if (object == null || (object = ((RulesetObject)object).getName()) == null) {
            object = "";
        }
        return ((Number)counter.get(object)).intValue();
    }

    public final int faithForNextGreatProphet() {
        int greatProphetsEarned = this.greatProphetsEarned();
        float faithCost = ((float)200 + (float)(100 * greatProphetsEarned * (greatProphetsEarned + 1)) / 2.0f) * this.getCivInfo().getGameInfo().getSpeed().getFaithCostModifier();
        Iterator iterator2 = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.FaithCostOfGreatProphetChange, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            faithCost *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return (int)faithCost;
    }

    public final boolean canGenerateProphet(boolean ignoreFaithAmount) {
        if (!this.getCivInfo().getGameInfo().isReligionEnabled()) {
            return false;
        }
        if (this.religion == null || this.religionState == ReligionState.None) {
            return false;
        }
        if (this.getGreatProphetEquivalent() == null) {
            return false;
        }
        if (!ignoreFaithAmount && this.storedFaith < this.faithForNextGreatProphet()) {
            return false;
        }
        if (!this.getCivInfo().isMajorCiv()) {
            return false;
        }
        if (Civilization.hasUnique$default(this.getCivInfo(), UniqueType.MayNotGenerateGreatProphet, null, 2, null)) {
            return false;
        }
        return this.religionState != ReligionState.Pantheon || this.remainingFoundableReligions() != 0;
    }

    public static /* synthetic */ boolean canGenerateProphet$default(ReligionManager religionManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return religionManager.canGenerateProphet(bl);
    }

    @Nullable
    public final BaseUnit getGreatProphetEquivalent() {
        Object v1;
        block1: {
            Collection<BaseUnit> collection = this.getCivInfo().getGameInfo().getRuleset().getUnits().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BaseUnit it = (BaseUnit)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.MayFoundReligion, null, 2, null)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        BaseUnit baseUnit = v1;
        return baseUnit == null ? null : this.getCivInfo().getEquivalentUnit(baseUnit);
    }

    private final void generateProphet() {
        BaseUnit baseUnit = this.getGreatProphetEquivalent();
        if (baseUnit == null) {
            return;
        }
        BaseUnit prophetUnit = baseUnit;
        float prophetSpawnChange = (5.0f + (float)this.storedFaith - (float)this.faithForNextGreatProphet()) / 100.0f;
        if (RandomKt.Random(this.getCivInfo().getGameInfo().getTurns()).nextFloat() < prophetSpawnChange) {
            City birthCity = this.religionState.compareTo((Enum)ReligionState.Pantheon) <= 0 ? Civilization.getCapital$default(this.getCivInfo(), false, 1, null) : this.getCivInfo().getReligionManager().getHolyCity();
            MapUnit mapUnit = this.getCivInfo().getUnits().addUnit(prophetUnit, birthCity);
            if (mapUnit == null) {
                return;
            }
            MapUnit prophet = mapUnit;
            Religion religion = this.religion;
            Intrinsics.checkNotNull(religion);
            prophet.setReligion(religion.getName());
            this.storedFaith -= this.faithForNextGreatProphet();
            this.getCivInfo().getCivConstructions().getBoughtItemsWithIncreasingPrice().add(prophetUnit.getName(), 1);
        }
    }

    private final int maxNumberOfReligions() {
        int n;
        GameInfo gameInfo = this.getCivInfo().getGameInfo();
        Ruleset ruleset2 = gameInfo.getRuleset();
        float multiplier = ruleset2.getModOptions().getConstants().getReligionLimitMultiplier();
        int base = ruleset2.getModOptions().getConstants().getReligionLimitBase();
        Iterable $this$count$iv = gameInfo.getCivilizations();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                if (!it.isMajorCiv() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int civCount = n;
        return Integer.min(ruleset2.getReligions().size(), base + (int)((float)civCount * multiplier));
    }

    /*
     * WARNING - void declaration
     */
    private final int foundedReligionsCount() {
        int n;
        Iterable $this$count$iv = this.getCivInfo().getGameInfo().getCivilizations();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                if (!(it.getReligionManager().religion != null && it.getReligionManager().religionState.compareTo((Enum)ReligionState.Religion) >= 0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public final int remainingFoundableReligions() {
        int maxNumberOfAdditionalReligions = this.maxNumberOfReligions() - this.foundedReligionsCount();
        int availableBeliefsToFound = Integer.min(this.numberOfBeliefsAvailable(BeliefType.Follower), this.numberOfBeliefsAvailable(BeliefType.Founder));
        return Integer.min(maxNumberOfAdditionalReligions, availableBeliefsToFound);
    }

    @NotNull
    public final Sequence<Pair<String, Integer>> remainingFoundableReligionsBreakdown() {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Pair<? extends String, ? extends Integer>>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ReligionManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        gameInfo = this.this$0.getCivInfo().getGameInfo();
                        ruleset = gameInfo.getRuleset();
                        this.L$0 = $this$sequence;
                        this.L$1 = gameInfo;
                        this.L$2 = ruleset;
                        this.label = 1;
                        v0 = $this$sequence.yield(TuplesKt.to("Available religion symbols", Boxing.boxInt(ruleset.getReligions().size())), this);
                        if (v0 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl22
                    }
                    case 1: {
                        ruleset = (Ruleset)this.L$2;
                        gameInfo = (GameInfo)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        multiplier = ruleset.getModOptions().getConstants().getReligionLimitMultiplier();
                        base = ruleset.getModOptions().getConstants().getReligionLimitBase();
                        $this$count$iv = gameInfo.getCivilizations();
                        $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            v1 = 0;
                        } else {
                            count$iv = 0;
                            for (T element$iv : $this$count$iv) {
                                it = (Civilization)element$iv;
                                $i$a$-count-ReligionManager$remainingFoundableReligionsBreakdown$1$civCount$1 = false;
                                if (!it.isMajorCiv() || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            v1 = count$iv;
                        }
                        civCount = v1;
                        hideCivCount = this.this$0.getCivInfo().hideCivCount();
                        if (!hideCivCount) break;
                        count$iv = this.this$0.getCivInfo().getKnownCivs();
                        var17_22 = 1;
                        $i$f$count = false;
                        count$iv = 0;
                        for (T element$iv : $this$count$iv) {
                            it = (Civilization)element$iv;
                            $i$a$-count-ReligionManager$remainingFoundableReligionsBreakdown$1$knownCivs$1 = false;
                            if (!it.isMajorCiv() || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        var18_25 = count$iv;
                        knownCivs = var17_22 + var18_25;
                        estimatedCivCount = (RangesKt.coerceAtLeast(gameInfo.getGameParameters().getMinNumberOfPlayers(), knownCivs) + gameInfo.getGameParameters().getMaxNumberOfPlayers() - 1) / 2 + 1;
                        civsAndBase = base + (int)((float)estimatedCivCount * multiplier);
                        this.L$0 = $this$sequence;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.label = 2;
                        v2 = $this$sequence.yield(TuplesKt.to("Estimated number of civilizations * [" + multiplier + "] + [" + base + ']', Boxing.boxInt(civsAndBase)), this);
                        if (v2 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl80
                    }
                    case 2: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
                        ** GOTO lbl80
                    }
                }
                civsAndBase = base + (int)((float)civCount * multiplier);
                this.L$0 = $this$sequence;
                this.L$1 = null;
                this.L$2 = null;
                this.label = 3;
                v3 = $this$sequence.yield(TuplesKt.to("Number of civilizations * [" + multiplier + "] + [" + base + ']', Boxing.boxInt(civsAndBase)), this);
                if (v3 == var19_2) {
                    return var19_2;
                }
                ** GOTO lbl80
                {
                    case 3: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl80:
                        // 4 sources

                        this.L$0 = $this$sequence;
                        this.label = 4;
                        v4 = $this$sequence.yield(TuplesKt.to("Religions already founded", Boxing.boxInt(ReligionManager.access$foundedReligionsCount(this.this$0))), this);
                        if (v4 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl90
                    }
                    case 4: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl90:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.label = 5;
                        v5 = $this$sequence.yield(TuplesKt.to("Available founder beliefs", Boxing.boxInt(this.this$0.numberOfBeliefsAvailable(BeliefType.Founder))), this);
                        if (v5 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl100
                    }
                    case 5: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
lbl100:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 6;
                        v6 = $this$sequence.yield(TuplesKt.to("Available follower beliefs", Boxing.boxInt(this.this$0.numberOfBeliefsAvailable(BeliefType.Follower))), this);
                        if (v6 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl109
                    }
                    case 6: {
                        ResultKt.throwOnFailure($result);
                        v6 = $result;
lbl109:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super Pair<? extends String, ? extends Integer>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Pair<String, Integer>> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final int numberOfBeliefsAvailable(@NotNull BeliefType type2) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object $this$count$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        GameInfo gameInfo = this.getCivInfo().getGameInfo();
        if (type2 == BeliefType.Any) {
            Collection<Belief> collection = gameInfo.getRuleset().getBeliefs().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            n = collection.size();
        } else {
            Collection<Belief> collection = gameInfo.getRuleset().getBeliefs().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            $this$count$iv = collection;
            boolean $i$f$count = false;
            if (((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                Iterator iterator2 = $this$count$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    Belief it = (Belief)element$iv;
                    boolean bl = false;
                    if (!(it.getType() == type2) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        }
        int numberOfBeliefs = n;
        $this$count$iv = gameInfo.getReligions();
        int n2 = numberOfBeliefs;
        boolean $i$f$flatMapSequence = false;
        void count$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        Iterator iterator3 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator3.next();
            boolean bl = false;
            Sequence<Belief> list$iv$iv = ((Religion)it.getValue()).getBeliefs(type2);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return n2 - ((Collection)CollectionsKt.distinct(list2)).size();
    }

    @Nullable
    public final Religion getReligionWithBelief(@NotNull Belief belief2) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter(belief2, "belief");
            Collection<Religion> collection = this.getCivInfo().getGameInfo().getReligions().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Religion it = (Religion)element$iv;
                boolean bl = false;
                if (!it.hasBelief(belief2.getName())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    public final boolean mayFoundReligionAtAll() {
        if (!this.getCivInfo().getGameInfo().isReligionEnabled()) {
            return false;
        }
        if (this.religionState.compareTo((Enum)ReligionState.Religion) >= 0) {
            return false;
        }
        if (!this.getCivInfo().isMajorCiv()) {
            return false;
        }
        return this.remainingFoundableReligions() != 0;
    }

    public final boolean mayFoundReligionHere(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!this.mayFoundReligionAtAll()) {
            return false;
        }
        if (!tile.isCityCenter()) {
            return false;
        }
        City city2 = tile.getCity();
        Intrinsics.checkNotNull(city2);
        return !city2.isHolyCity();
    }

    public final void foundReligion(@NotNull MapUnit prophet) {
        Intrinsics.checkNotNullParameter(prophet, "prophet");
        if (!this.mayFoundReligionHere(prophet.getTile())) {
            return;
        }
        if (this.religionState == ReligionState.None) {
            this.shouldChoosePantheonBelief = true;
        }
        this.religionState = ReligionState.FoundingReligion;
        ReligionManager religionManager = this.getCivInfo().getReligionManager();
        City city2 = prophet.getTile().getCity();
        Intrinsics.checkNotNull(city2);
        religionManager.foundingCityId = city2.getId();
    }

    public final boolean mayEnhanceReligionAtAll() {
        if (!this.getCivInfo().getGameInfo().isReligionEnabled()) {
            return false;
        }
        if (this.religion == null) {
            return false;
        }
        if (this.religionState != ReligionState.Religion) {
            return false;
        }
        if (!this.getCivInfo().isMajorCiv()) {
            return false;
        }
        if (this.numberOfBeliefsAvailable(BeliefType.Follower) == 0) {
            return false;
        }
        return this.numberOfBeliefsAvailable(BeliefType.Enhancer) != 0;
    }

    public final boolean mayEnhanceReligionHere(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!this.mayEnhanceReligionAtAll()) {
            return false;
        }
        return tile.isCityCenter();
    }

    public final void useProphetForEnhancingReligion(@NotNull MapUnit prophet) {
        Intrinsics.checkNotNullParameter(prophet, "prophet");
        if (!this.mayEnhanceReligionHere(prophet.getTile())) {
            return;
        }
        this.religionState = ReligionState.EnhancingReligion;
    }

    private final Counter<BeliefType> getBeliefsToChooseAtProphetUse(boolean enhancingReligion) {
        String action2 = enhancingReligion ? "enhancing" : "founding";
        Counter<BeliefType> beliefsToChoose = new Counter<BeliefType>(null, 1, null);
        Counter<BeliefType> availableBeliefs = new Counter<BeliefType>(null, 1, null);
        for (BeliefType beliefType : BeliefType.getEntries()) {
            if (beliefType == BeliefType.None) continue;
            ((Map)availableBeliefs).put(beliefType, this.numberOfBeliefsAvailable(beliefType));
        }
        if (enhancingReligion) {
            ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, BeliefType.Enhancer, 1);
        } else {
            ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, BeliefType.Founder, 1);
            if (this.shouldChoosePantheonBelief) {
                ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, BeliefType.Pantheon, 1);
            }
        }
        ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, BeliefType.Follower, 1);
        Iterator<Object> iterator2 = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.FreeExtraBeliefs, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!Intrinsics.areEqual(unique.getParams().get(2), action2)) continue;
            BeliefType type3 = BeliefType.valueOf(unique.getParams().get(1));
            ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, type3, Integer.parseInt(unique.getParams().get(0)));
        }
        iterator2 = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.FreeExtraAnyBeliefs, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!Intrinsics.areEqual(unique.getParams().get(1), action2)) continue;
            ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, BeliefType.Any, Integer.parseInt(unique.getParams().get(0)));
        }
        for (Map.Entry entry : ((Map)this.freeBeliefsAsEnums()).entrySet()) {
            ReligionManager.getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(availableBeliefs, beliefsToChoose, (BeliefType)((Object)entry.getKey()), ((Number)entry.getValue()).intValue());
        }
        return beliefsToChoose;
    }

    @NotNull
    public final Counter<BeliefType> getBeliefsToChooseAtFounding() {
        return this.getBeliefsToChooseAtProphetUse(false);
    }

    @NotNull
    public final Counter<BeliefType> getBeliefsToChooseAtEnhancing() {
        return this.getBeliefsToChooseAtProphetUse(true);
    }

    /*
     * WARNING - void declaration
     */
    public final void chooseBeliefs(@NotNull List<Belief> beliefs, boolean useFreeBeliefs) {
        Intrinsics.checkNotNullParameter(beliefs, "beliefs");
        this.freeBeliefs.clear();
        if (this.religionState == ReligionState.None) {
            this.foundPantheon(beliefs.get(0).getName(), useFreeBeliefs);
        }
        Religion religion = this.religion;
        Intrinsics.checkNotNull(religion);
        religion.addBeliefs((Iterable<Belief>)beliefs);
        switch (WhenMappings.$EnumSwitchMapping$0[this.religionState.ordinal()]) {
            case 1: {
                this.religionState = ReligionState.Pantheon;
                for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponFoundingPantheon, null, null, 6, null)) {
                    UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
                }
                break;
            }
            case 2: {
                this.religionState = ReligionState.Religion;
                for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponFoundingReligion, null, null, 6, null)) {
                    UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
                }
                break;
            }
            case 3: {
                this.religionState = ReligionState.EnhancedReligion;
                for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponEnhancingReligion, null, null, 6, null)) {
                    UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
                }
                break;
            }
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponAdoptingPolicyOrBelief, null, null, 6, null)) {
            for (Belief belief2 : beliefs) {
                boolean bl;
                block17: {
                    Iterable $this$any$iv = unique.getModifiers(UniqueType.TriggerUponAdoptingPolicyOrBelief);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Unique it = (Unique)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getParams().get(0), belief2.getName())) continue;
                            bl = true;
                            break block17;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, "due to adopting [" + belief2.getName() + ']', 60, null);
            }
        }
        for (Belief belief3 : beliefs) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = belief3.getUniqueObjects();
            boolean $i$f$filter = false;
            Iterable $i$f$any = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Unique it = (Unique)element$iv$iv;
                boolean bl = false;
                if (!(!it.hasTriggerConditional() && it.conditionalsApply(this.getCivInfo().getState()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Unique unique : (List)destination$iv$iv) {
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
            }
        }
        this.getCivInfo().updateStatsForNextTurn();
    }

    public static /* synthetic */ void chooseBeliefs$default(ReligionManager religionManager, List list2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        religionManager.chooseBeliefs(list2, bl);
    }

    public final void foundReligion$core(@NotNull String displayName, @NotNull String name2) {
        Object element$iv2;
        Religion newReligion;
        block3: {
            Intrinsics.checkNotNullParameter(displayName, "displayName");
            Intrinsics.checkNotNullParameter(name2, "name");
            newReligion = new Religion(name2, this.getCivInfo().getGameInfo(), this.getCivInfo().getCivName());
            newReligion.setDisplayName(displayName);
            if (this.religion != null) {
                Religion religion = this.religion;
                Intrinsics.checkNotNull(religion);
                newReligion.addBeliefs(SequencesKt.asIterable(religion.getAllBeliefsOrdered()));
            }
            this.religion = newReligion;
            ((Map)this.getCivInfo().getGameInfo().getReligions()).put(name2, newReligion);
            Iterable $this$first$iv = this.getCivInfo().getCities();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                City it = (City)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), this.foundingCityId)) continue;
                break block3;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        City holyCity = (City)element$iv2;
        holyCity.getReligion().setReligionThisIsTheHolyCityOf(newReligion.getName());
        CityReligionManager.addPressure$default(holyCity.getReligion(), name2, holyCity.getPopulation().getPopulation() * 500, false, 4, null);
        this.foundingCityId = null;
        this.shouldChoosePantheonBelief = false;
        Iterator<MapUnit> iterator2 = this.getCivInfo().getUnits().getCivUnits().iterator();
        while (iterator2.hasNext()) {
            MapUnit unit = iterator2.next();
            if (!MapUnit.hasUnique$default(unit, UniqueType.ReligiousUnit, null, false, 6, null) || !MapUnit.hasUnique$default(unit, UniqueType.TakeReligionOverBirthCity, null, false, 6, null)) continue;
            unit.setReligion(newReligion.getName());
        }
    }

    public final boolean maySpreadReligionAtAll(@NotNull MapUnit missionary) {
        Intrinsics.checkNotNullParameter(missionary, "missionary");
        if (!this.getCivInfo().isMajorCiv()) {
            return false;
        }
        if (!this.getCivInfo().getGameInfo().isReligionEnabled()) {
            return false;
        }
        Religion religion = (Religion)((Map)missionary.getCiv().getGameInfo().getReligions()).get(missionary.getReligion());
        if (religion == null) {
            return false;
        }
        Religion religion2 = religion;
        if (religion2.isPantheon()) {
            return false;
        }
        return !SequencesKt.none(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(missionary, UniqueType.CanSpreadReligion));
    }

    public final boolean maySpreadReligionNow(@NotNull MapUnit missionary) {
        Intrinsics.checkNotNullParameter(missionary, "missionary");
        if (!this.maySpreadReligionAtAll(missionary)) {
            return false;
        }
        if (missionary.getTile().getOwner() == null) {
            return false;
        }
        IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = missionary.getCurrentTile().getOwningCity();
        if (Intrinsics.areEqual(isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((City)isPartOfGameInfoSerialization).getReligion()) != null && (isPartOfGameInfoSerialization = ((CityReligionManager)isPartOfGameInfoSerialization).getMajorityReligion()) != null ? ((Religion)isPartOfGameInfoSerialization).getName() : null, missionary.getReligion())) {
            return false;
        }
        City city2 = missionary.getTile().getCity();
        Intrinsics.checkNotNull(city2);
        return !city2.getReligion().isProtectedByInquisitor(missionary.getReligion());
    }

    /*
     * WARNING - void declaration
     */
    public final int numberOfCitiesFollowingThisReligion() {
        void var3_3;
        if (this.religion == null) {
            return 0;
        }
        Sequence<City> $this$count$iv = this.getCivInfo().getGameInfo().getCities();
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<City> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            City element$iv;
            City it = element$iv = iterator2.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getReligion().getMajorityReligion(), this.religion) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final int numberOfFollowersFollowingThisReligion(@NotNull String cityFilter) {
        Intrinsics.checkNotNullParameter(cityFilter, "cityFilter");
        if (this.religion == null) {
            return 0;
        }
        Sequence<City> sequence = SequencesKt.filter(this.getCivInfo().getGameInfo().getCities(), (Function1)new Function1<City, Boolean>(cityFilter, this){
            final /* synthetic */ String $cityFilter;
            final /* synthetic */ ReligionManager this$0;
            {
                this.$cityFilter = $cityFilter;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull City it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return City.matchesFilter$default(it, this.$cityFilter, this.this$0.getCivInfo(), false, 4, null);
            }
        });
        int n = 0;
        Iterator<City> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            City city2;
            City city3 = city2 = iterator2.next();
            int n2 = n;
            boolean bl = false;
            CityReligionManager cityReligionManager = it.getReligion();
            Religion religion = this.religion;
            Intrinsics.checkNotNull(religion);
            int n3 = cityReligionManager.getFollowersOf(religion.getName());
            n = n2 + n3;
        }
        return n;
    }

    @Nullable
    public final City getHolyCity() {
        City city2;
        block2: {
            if (this.religion == null) {
                return null;
            }
            Sequence<City> $this$firstOrNull$iv = this.getCivInfo().getGameInfo().getCities();
            boolean $i$f$firstOrNull = false;
            Iterator<City> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                City element$iv;
                City it = element$iv = iterator2.next();
                boolean bl = false;
                Religion religion = this.religion;
                Intrinsics.checkNotNull(religion);
                if (!it.isHolyCityOf(religion.getName())) continue;
                city2 = element$iv;
                break block2;
            }
            city2 = null;
        }
        return city2;
    }

    @Nullable
    public final Religion getMajorityReligion() {
        Object v0;
        Counter<Religion> religionCounter = new Counter<Religion>(null, 1, null);
        for (City city2 : this.getCivInfo().getCities()) {
            Religion cityMajorityReligion;
            if (city2.getReligion().getMajorityReligion() == null) continue;
            religionCounter.add(cityMajorityReligion, 1);
        }
        Iterable iterable = ((Map)religionCounter).entrySet();
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator2.next();
            if (!iterator2.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                int n = ((Number)it.getValue()).intValue();
                do {
                    Object t2 = iterator2.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-ReligionManager$getMajorityReligion$maxReligionCounterEntry$1 = false;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator2.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry = v0;
        if (entry == null) {
            return null;
        }
        Map.Entry maxReligionCounterEntry = entry;
        return ((Number)maxReligionCounterEntry.getValue()).intValue() > this.getCivInfo().getCities().size() / 2 ? (Religion)maxReligionCounterEntry.getKey() : null;
    }

    private static final void getBeliefsToChooseAtProphetUse$chooseBeliefToAdd(Counter<BeliefType> availableBeliefs, Counter<BeliefType> beliefsToChoose, BeliefType type2, int number) {
        int numberToAdd = Integer.min(number, ((Number)availableBeliefs.get((Object)type2)).intValue());
        beliefsToChoose.add(type2, numberToAdd);
        ((Map)availableBeliefs).put(type2, ((Number)availableBeliefs.get((Object)type2)).intValue() - numberToAdd);
        if (type2 != BeliefType.Any) {
            ((Map)availableBeliefs).put(BeliefType.Any, ((Number)availableBeliefs.get((Object)BeliefType.Any)).intValue() - numberToAdd);
        }
    }

    public static final /* synthetic */ int access$foundedReligionsCount(ReligionManager $this) {
        return $this.foundedReligionsCount();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReligionState.values().length];
            try {
                nArray[ReligionState.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReligionState.FoundingReligion.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReligionState.EnhancingReligion.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

