/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.transients;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.Proximity;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.transients.CapitalConnectionsFinder;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stats;
import com.unciv.utils.DebugUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020,H\u0002J\u0006\u0010.\u001a\u00020,J\u0010\u0010/\u001a\u00020,2\b\b\u0002\u00100\u001a\u000201J\u0006\u00102\u001a\u00020,J\u0006\u00103\u001a\u00020,J\b\u00104\u001a\u00020,H\u0002J\u0006\u00105\u001a\u00020,J\u001a\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00032\n\b\u0002\u00109\u001a\u0004\u0018\u000107J\u0006\u0010:\u001a\u00020,J\u0006\u0010;\u001a\u00020,J\b\u0010<\u001a\u00020,H\u0002J\u0012\u0010=\u001a\u00020,2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?R,\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR!\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R!\u0010%\u001a\u0012\u0012\u0004\u0012\u00020&0 j\b\u0012\u0004\u0012\u00020&`\"\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010$R!\u0010(\u001a\u0012\u0012\u0004\u0012\u00020)0 j\b\u0012\u0004\u0012\u00020)`\"\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010$\u00a8\u0006@"}, d2={"Lcom/unciv/logic/civilization/transients/CivInfoTransientCache;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/civilization/Civilization;)V", "citiesConnectedToCapitalToMediums", "", "Lcom/unciv/logic/city/City;", "", "", "getCitiesConnectedToCapitalToMediums", "()Ljava/util/Map;", "setCitiesConnectedToCapitalToMediums", "(Ljava/util/Map;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "lastEraResourceUsedForBuilding", "Ljava/util/HashMap;", "", "getLastEraResourceUsedForBuilding", "()Ljava/util/HashMap;", "setLastEraResourceUsedForBuilding", "(Ljava/util/HashMap;)V", "lastEraResourceUsedForUnit", "getLastEraResourceUsedForUnit", "ourTilesAndNeighboringTiles", "Lcom/unciv/logic/map/tile/Tile;", "getOurTilesAndNeighboringTiles", "()Ljava/util/Set;", "setOurTilesAndNeighboringTiles", "(Ljava/util/Set;)V", "uniqueBuildings", "Ljava/util/HashSet;", "Lcom/unciv/models/ruleset/Building;", "Lkotlin/collections/HashSet;", "getUniqueBuildings", "()Ljava/util/HashSet;", "uniqueImprovements", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "getUniqueImprovements", "uniqueUnits", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "getUniqueUnits", "discoverNaturalWonders", "", "setNewViewableTiles", "setTransients", "updateCitiesConnectedToCapital", "initialSetup", "", "updateCivResources", "updateHasActiveEnemyMovementPenalty", "updateLastSeenImprovements", "updateOurTiles", "updateProximity", "Lcom/unciv/logic/civilization/Proximity;", "otherCiv", "preCalculated", "updateSightAndResources", "updateState", "updateViewableInvisibleTiles", "updateViewableTiles", "explorerPosition", "Lcom/badlogic/gdx/math/Vector2;", "core"})
@SourceDebugExtension(value={"SMAP\nCivInfoTransientCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CivInfoTransientCache.kt\ncom/unciv/logic/civilization/transients/CivInfoTransientCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,452:1\n766#2:453\n857#2,2:454\n1271#2,2:456\n1285#2,4:458\n766#2:462\n857#2,2:463\n1271#2,2:465\n1285#2,4:467\n1747#2,3:496\n766#2:499\n857#2,2:500\n1360#2:502\n1446#2,5:503\n766#2:508\n857#2,2:509\n766#2:511\n857#2,2:512\n526#3:471\n511#3,6:472\n526#3:482\n511#3,6:483\n125#4:478\n152#4,3:479\n125#4:489\n152#4,3:490\n1#5:493\n1313#6,2:494\n*S KotlinDebug\n*F\n+ 1 CivInfoTransientCache.kt\ncom/unciv/logic/civilization/transients/CivInfoTransientCache\n*L\n55#1:453\n55#1:454,2\n56#1:456,2\n56#1:458,4\n59#1:462\n59#1:463,2\n60#1:465,2\n60#1:467,4\n156#1:496,3\n239#1:499\n239#1:500,2\n240#1:502\n240#1:503,5\n290#1:508\n290#1:509,2\n293#1:511\n293#1:512,2\n63#1:471\n63#1:472,6\n64#1:482\n64#1:483,6\n63#1:478\n63#1:479,3\n64#1:489\n64#1:490,3\n111#1:494,2\n*E\n"})
public final class CivInfoTransientCache {
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private transient HashMap<String, Integer> lastEraResourceUsedForBuilding;
    @NotNull
    private final transient HashMap<String, Integer> lastEraResourceUsedForUnit;
    @NotNull
    private final transient HashSet<BaseUnit> uniqueUnits;
    @NotNull
    private final transient HashSet<TileImprovement> uniqueImprovements;
    @NotNull
    private final transient HashSet<Building> uniqueBuildings;
    @NotNull
    private transient Map<City, ? extends Set<String>> citiesConnectedToCapitalToMediums;
    @NotNull
    private Set<Tile> ourTilesAndNeighboringTiles;

    public CivInfoTransientCache(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.lastEraResourceUsedForBuilding = new HashMap();
        this.lastEraResourceUsedForUnit = new HashMap();
        this.uniqueUnits = new HashSet();
        this.uniqueImprovements = new HashSet();
        this.uniqueBuildings = new HashSet();
        this.citiesConnectedToCapitalToMediums = MapsKt.emptyMap();
        this.ourTilesAndNeighboringTiles = new HashSet();
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    @NotNull
    public final HashMap<String, Integer> getLastEraResourceUsedForBuilding() {
        return this.lastEraResourceUsedForBuilding;
    }

    public final void setLastEraResourceUsedForBuilding(@NotNull HashMap<String, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.lastEraResourceUsedForBuilding = hashMap;
    }

    @NotNull
    public final HashMap<String, Integer> getLastEraResourceUsedForUnit() {
        return this.lastEraResourceUsedForUnit;
    }

    @NotNull
    public final HashSet<BaseUnit> getUniqueUnits() {
        return this.uniqueUnits;
    }

    @NotNull
    public final HashSet<TileImprovement> getUniqueImprovements() {
        return this.uniqueImprovements;
    }

    @NotNull
    public final HashSet<Building> getUniqueBuildings() {
        return this.uniqueBuildings;
    }

    @NotNull
    public final Map<City, Set<String>> getCitiesConnectedToCapitalToMediums() {
        return this.citiesConnectedToCapitalToMediums;
    }

    public final void setCitiesConnectedToCapitalToMediums(@NotNull Map<City, ? extends Set<String>> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.citiesConnectedToCapitalToMediums = map2;
    }

    public final void updateState() {
        this.civInfo.setState(new StateForConditionals(this.civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null));
    }

    /*
     * Could not resolve type clashes
     * WARNING - void declaration
     */
    public final void setTransients() {
        void $this$associateWith$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Set<String> set2;
        Object object;
        Object object2;
        void $this$associateWith$iv2;
        Building it;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Ruleset ruleset2 = this.civInfo.getGameInfo().getRuleset();
        StateForConditionals state = this.civInfo.getState();
        Collection<Building> collection = ruleset2.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (Building)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!Intrinsics.areEqual(this.civInfo.getEquivalentBuilding(it), it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv2, 10)), 16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv2;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (Building)element$iv$iv;
            object2 = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            set2 = it.requiredResources(state);
            object.put(object2, set2);
        }
        Map buildingsToRequiredResources = result$iv;
        Collection<BaseUnit> collection2 = ruleset2.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterable $i$f$associateWith22 = collection2;
        boolean $i$f$filter2 = false;
        $this$associateWithTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BaseUnit it2 = (BaseUnit)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it2);
            if (!Intrinsics.areEqual(this.civInfo.getEquivalentUnit(it2), it2)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        void $this$associateWithTo$iv$iv2 = $this$associateWith$iv;
        boolean $i$f$associateWithTo2 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv2) {
            BaseUnit it2 = (BaseUnit)element$iv$iv;
            object2 = element$iv$iv;
            object = result$iv2;
            boolean bl = false;
            set2 = it2.requiredResources(state);
            object.put(object2, set2);
        }
        Map unitsToRequiredResources = result$iv2;
        Collection<TileResource> collection3 = ruleset2.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
        Iterator<Object> iterator2 = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection3), setTransients.1.INSTANCE), setTransients.2.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            Comparable comparable;
            Object object3;
            Object object4;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv3;
            Iterator item$iv$iv2;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry it3;
            void $this$filterTo$iv$iv4;
            Object element$iv$iv;
            String resource2 = (String)iterator2.next();
            Map $this$filter$iv3 = buildingsToRequiredResources;
            boolean $i$f$filter3 = false;
            element$iv$iv = $this$filter$iv3;
            Object destination$iv$iv3 = new LinkedHashMap();
            boolean $i$f$filterTo3 = false;
            Iterator bl = $this$filterTo$iv$iv4.entrySet().iterator();
            while (bl.hasNext()) {
                Map.Entry element$iv$iv2;
                it3 = element$iv$iv2 = bl.next();
                boolean bl2 = false;
                if (!((Set)it3.getValue()).contains(resource2)) continue;
                destination$iv$iv3.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
            }
            $this$filter$iv3 = destination$iv$iv3;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv4 = $this$map$iv2;
            destination$iv$iv3 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo = false;
            for (Iterator item$iv$iv2 : $this$mapTo$iv$iv2.entrySet()) {
                it3 = item$iv$iv2;
                object = destination$iv$iv3;
                boolean bl3 = false;
                object.add((Building)it3.getKey());
            }
            List applicableBuildings = (List)destination$iv$iv3;
            Map $this$filter$iv4 = unitsToRequiredResources;
            boolean $i$f$filter4 = false;
            destination$iv$iv3 = $this$filter$iv4;
            Object destination$iv$iv4 = new LinkedHashMap();
            boolean $i$f$filterTo4 = false;
            item$iv$iv2 = $this$filterTo$iv$iv3.entrySet().iterator();
            while (item$iv$iv2.hasNext()) {
                Map.Entry element$iv$iv3;
                Map.Entry it4 = element$iv$iv3 = (Map.Entry)item$iv$iv2.next();
                boolean bl4 = false;
                if (!((Set)it4.getValue()).contains(resource2)) continue;
                destination$iv$iv4.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
            }
            $this$filter$iv4 = destination$iv$iv4;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv3 = $this$map$iv;
            destination$iv$iv4 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo2 = false;
            item$iv$iv2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (item$iv$iv2.hasNext()) {
                Map.Entry item$iv$iv3;
                Map.Entry it4 = item$iv$iv3 = item$iv$iv2.next();
                object = destination$iv$iv4;
                boolean bl5 = false;
                object.add((BaseUnit)it4.getKey());
            }
            List applicableUnits = (List)destination$iv$iv4;
            Iterator iterator3 = ((Iterable)applicableBuildings).iterator();
            if (!iterator3.hasNext()) {
                object4 = null;
            } else {
                Building it5 = (Building)iterator3.next();
                boolean bl6 = false;
                Era era2 = it5.era(ruleset2);
                object3 = era2 != null ? era2.getEraNumber() : 0;
                while (iterator3.hasNext()) {
                    Object it6 = (Building)iterator3.next();
                    $i$a$-maxOfOrNull-CivInfoTransientCache$setTransients$lastEraForBuilding$1 = false;
                    Era era3 = ((RulesetStatsObject)it6).era(ruleset2);
                    it6 = era3 != null ? era3.getEraNumber() : 0;
                    if (object3.compareTo(it6) >= 0) continue;
                    object3 = it6;
                }
                object4 = object3;
            }
            Integer lastEraForBuilding = (Integer)object4;
            object3 = ((Iterable)applicableUnits).iterator();
            if (!object3.hasNext()) {
                comparable = null;
            } else {
                BaseUnit it7 = (BaseUnit)object3.next();
                boolean bl7 = false;
                Era era4 = it7.era(ruleset2);
                Comparable comparable2 = Integer.valueOf(era4 != null ? era4.getEraNumber() : 0);
                while (object3.hasNext()) {
                    BaseUnit it8 = (BaseUnit)object3.next();
                    $i$a$-maxOfOrNull-CivInfoTransientCache$setTransients$lastEraForUnit$1 = false;
                    Era era5 = it8.era(ruleset2);
                    Comparable comparable3 = Integer.valueOf(era5 != null ? era5.getEraNumber() : 0);
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer lastEraForUnit = (Integer)comparable;
            if (lastEraForBuilding != null) {
                ((Map)this.lastEraResourceUsedForBuilding).put(resource2, lastEraForBuilding);
            }
            if (lastEraForUnit == null) continue;
            ((Map)this.lastEraResourceUsedForUnit).put(resource2, lastEraForUnit);
        }
        for (Building building : ruleset2.getBuildings().values()) {
            if (building.getUniqueTo() == null) continue;
            String string = building.getUniqueTo();
            Intrinsics.checkNotNull(string);
            if (!Civilization.matchesFilter$default(this.civInfo, string, null, false, 6, null)) continue;
            this.uniqueBuildings.add(building);
        }
        for (TileImprovement improvement2 : ruleset2.getTileImprovements().values()) {
            if (improvement2.getUniqueTo() == null) continue;
            String string = improvement2.getUniqueTo();
            Intrinsics.checkNotNull(string);
            if (!Civilization.matchesFilter$default(this.civInfo, string, null, false, 6, null)) continue;
            this.uniqueImprovements.add(improvement2);
        }
        for (BaseUnit unit : ruleset2.getUnits().values()) {
            if (unit.getUniqueTo() == null) continue;
            String string = unit.getUniqueTo();
            Intrinsics.checkNotNull(string);
            if (!Civilization.matchesFilter$default(this.civInfo, string, null, false, 6, null)) continue;
            this.uniqueUnits.add(unit);
        }
    }

    public final void updateSightAndResources() {
        CivInfoTransientCache.updateViewableTiles$default(this, null, 1, null);
        this.updateHasActiveEnemyMovementPenalty();
        this.updateCivResources();
    }

    public final void updateViewableTiles(@Nullable Vector2 explorerPosition) {
        this.setNewViewableTiles();
        this.updateViewableInvisibleTiles();
        this.updateLastSeenImprovements();
        Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)this.civInfo.getViewableTiles());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Tile tile = (Tile)element$iv;
            boolean bl = false;
            tile.setExplored(this.civInfo, true, explorerPosition);
        }
        HashMap viewedCivs = new HashMap();
        for (Tile tile : this.civInfo.getViewableTiles()) {
            Civilization tileOwner = tile.getOwner();
            if (tileOwner != null) {
                ((Map)viewedCivs).put(tileOwner, tile);
            }
            MapUnit mapUnit = tile.getFirstUnit();
            Civilization unitOwner = mapUnit != null ? mapUnit.getCiv() : null;
            if (unitOwner == null) continue;
            ((Map)viewedCivs).put(unitOwner, tile);
        }
        if (!this.civInfo.isBarbarian()) {
            for (Map.Entry entry : ((Map)viewedCivs).entrySet()) {
                String[] stringArray;
                Civilization metCiv = (Civilization)entry.getKey();
                if (Intrinsics.areEqual(metCiv, this.civInfo) || metCiv.isBarbarian() || this.civInfo.getDiplomacy().containsKey(metCiv.getCivName())) continue;
                DiplomacyFunctions.makeCivilizationsMeet$default(this.civInfo.getDiplomacyFunctions(), metCiv, false, 2, null);
                if (!this.civInfo.isSpectator()) {
                    stringArray = new String[]{metCiv.getCivName(), "OtherIcons/Diplomacy"};
                    this.civInfo.addNotification("We have encountered [" + metCiv.getCivName() + "]!", ((Tile)entry.getValue()).getPosition(), Notification.NotificationCategory.Diplomacy, stringArray);
                }
                stringArray = new String[]{this.civInfo.getCivName(), "OtherIcons/Diplomacy"};
                metCiv.addNotification("We have encountered [" + this.civInfo.getCivName() + "]!", ((Tile)entry.getValue()).getPosition(), Notification.NotificationCategory.Diplomacy, stringArray);
            }
            this.discoverNaturalWonders();
        }
    }

    public static /* synthetic */ void updateViewableTiles$default(CivInfoTransientCache civInfoTransientCache, Vector2 vector2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = null;
        }
        civInfoTransientCache.updateViewableTiles(vector2);
    }

    private final void updateViewableInvisibleTiles() {
        HashSet<Tile> newViewableInvisibleTiles = new HashSet<Tile>();
        Iterator<MapUnit> iterator2 = this.civInfo.getUnits().getCivUnits().iterator();
        while (iterator2.hasNext()) {
            MapUnit unit = iterator2.next();
            Sequence invisibleUnitUniques = MapUnit.getMatchingUniques$default(unit, UniqueType.CanSeeInvisibleUnits, null, false, 6, null);
            if (SequencesKt.none(invisibleUnitUniques)) continue;
            List visibleUnitTypes2 = SequencesKt.toList(SequencesKt.map(invisibleUnitUniques, updateViewableInvisibleTiles.visibleUnitTypes.1.INSTANCE));
            for (Tile tile : unit.getViewableTiles()) {
                boolean bl;
                block5: {
                    if (tile.getMilitaryUnit() == null || newViewableInvisibleTiles.contains(tile)) continue;
                    Iterable $this$any$iv = visibleUnitTypes2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            MapUnit mapUnit = tile.getMilitaryUnit();
                            Intrinsics.checkNotNull(mapUnit);
                            if (!MapUnit.matchesFilter$default(mapUnit, it, false, 2, null)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                newViewableInvisibleTiles.add(tile);
            }
        }
        this.civInfo.setViewableInvisibleUnitsTiles((Set<Tile>)newViewableInvisibleTiles);
    }

    @NotNull
    public final Set<Tile> getOurTilesAndNeighboringTiles() {
        return this.ourTilesAndNeighboringTiles;
    }

    public final void setOurTilesAndNeighboringTiles(@NotNull Set<Tile> set2) {
        Intrinsics.checkNotNullParameter(set2, "<set-?>");
        this.ourTilesAndNeighboringTiles = set2;
    }

    public final void updateOurTiles() {
        this.ourTilesAndNeighboringTiles = SequencesKt.toSet(SequencesKt.flatMap(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)this.civInfo.getCities()), updateOurTiles.1.INSTANCE), updateOurTiles.2.INSTANCE));
        CivInfoTransientCache.updateViewableTiles$default(this, null, 1, null);
        this.updateCivResources();
    }

    private final void setNewViewableTiles() {
        if (this.civInfo.isDefeated()) {
            this.civInfo.setViewableTiles(SetsKt.emptySet());
            return;
        }
        if (this.civInfo.isSpectator() || DebugUtils.INSTANCE.getVISIBLE_MAP()) {
            Set<Tile> allTiles = CollectionsKt.toSet((Iterable)this.civInfo.getGameInfo().getTileMap().getValues());
            this.civInfo.setViewableTiles(allTiles);
            this.civInfo.setViewableInvisibleUnitsTiles(allTiles);
            return;
        }
        HashSet newViewableTiles = new HashSet(this.ourTilesAndNeighboringTiles);
        CollectionsKt.addAll((Collection)newViewableTiles, SequencesKt.flatMap(this.civInfo.getUnits().getCivUnits(), (Function1)new Function1<MapUnit, Sequence<? extends Tile>>(this){
            final /* synthetic */ CivInfoTransientCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<Tile> invoke(@NotNull MapUnit unit) {
                Intrinsics.checkNotNullParameter(unit, "unit");
                return SequencesKt.filter(CollectionsKt.asSequence((Iterable)unit.getViewableTiles()), (Function1)new Function1<Tile, Boolean>(this.this$0){
                    final /* synthetic */ CivInfoTransientCache this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Tile it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return !Intrinsics.areEqual(it.getOwner(), this.this$0.getCivInfo());
                    }
                });
            }
        }));
        Iterator<Civilization> iterator2 = this.civInfo.getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            Civilization otherCiv = iterator2.next();
            if (!Intrinsics.areEqual(otherCiv.getAllyCivName(), this.civInfo.getCivName()) && !Intrinsics.areEqual(otherCiv.getCivName(), this.civInfo.getAllyCivName())) continue;
            CollectionsKt.addAll((Collection)newViewableTiles, SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)otherCiv.getCities()), setNewViewableTiles.2.INSTANCE));
        }
        CollectionsKt.addAll((Collection)newViewableTiles, this.civInfo.getEspionageManager().getTilesVisibleViaSpies());
        this.civInfo.setViewableTiles(newViewableTiles);
    }

    private final void updateLastSeenImprovements() {
        if (this.civInfo.getPlayerType() == PlayerType.AI) {
            return;
        }
        for (Tile tile : this.civInfo.getViewableTiles()) {
            this.civInfo.setLastSeenImprovement(tile.getPosition(), tile.getImprovement());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void discoverNaturalWonders() {
        HashSet newlyViewedNaturalWonders = new HashSet();
        for (Tile tile : this.civInfo.getViewableTiles()) {
            if (tile.getNaturalWonder() == null) continue;
            ArrayList<String> arrayList = this.civInfo.getNaturalWonders();
            String string = tile.getNaturalWonder();
            Intrinsics.checkNotNull(string);
            if (arrayList.contains(string)) continue;
            ((Collection)newlyViewedNaturalWonders).add(tile);
        }
        for (Tile tile : newlyViewedNaturalWonders) {
            void $this$flatMapTo$iv$iv;
            Iterator $this$flatMap$iv;
            Civilization it;
            void $this$filterTo$iv$iv;
            if (CollectionsKt.contains((Iterable)this.civInfo.getNaturalWonders(), tile.getNaturalWonder())) continue;
            ArrayList<String> arrayList = this.civInfo.getNaturalWonders();
            String string = tile.getNaturalWonder();
            Intrinsics.checkNotNull(string);
            arrayList.add(string);
            if (this.civInfo.isSpectator()) continue;
            String[] stringArray = new String[]{"StatIcons/Happiness"};
            this.civInfo.addNotification("We have discovered [" + tile.getNaturalWonder() + "]!", tile.getPosition(), Notification.NotificationCategory.General, stringArray);
            Stats statsGained = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
            Iterable $this$filter$iv = this.civInfo.getGameInfo().getCivilizations();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Civilization)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it, this.civInfo) && it.isMajorCiv())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (Civilization)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getNaturalWonders();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List discoveredNaturalWonders = (List)destination$iv$iv;
            Intrinsics.checkNotNull(tile);
            if (Tile.terrainHasUnique$default(tile, UniqueType.GrantsStatsToFirstToDiscover, null, 2, null)) {
                String string2 = tile.getNaturalWonder();
                Intrinsics.checkNotNull(string2);
                if (!discoveredNaturalWonders.contains(string2)) {
                    $this$flatMap$iv = Tile.getTerrainMatchingUniques$default(tile, UniqueType.GrantsStatsToFirstToDiscover, null, 2, null).iterator();
                    while ($this$flatMap$iv.hasNext()) {
                        Unique unique = (Unique)$this$flatMap$iv.next();
                        statsGained.add(unique.getStats());
                    }
                }
            }
            $this$flatMap$iv = Civilization.getMatchingUniques$default(this.civInfo, UniqueType.StatBonusWhenDiscoveringNaturalWonder, null, 2, null).iterator();
            while ($this$flatMap$iv.hasNext()) {
                Unique unique = (Unique)$this$flatMap$iv.next();
                Stats normalBonus = Stats.Companion.parse(unique.getParams().get(0));
                Stats firstDiscoveredBonus = Stats.Companion.parse(unique.getParams().get(1));
                String string3 = tile.getNaturalWonder();
                Intrinsics.checkNotNull(string3);
                if (discoveredNaturalWonders.contains(string3)) {
                    statsGained.add(normalBonus);
                    continue;
                }
                statsGained.add(firstDiscoveredBonus);
            }
            String naturalWonder = null;
            if (!statsGained.isEmpty()) {
                String string4 = tile.getNaturalWonder();
                Intrinsics.checkNotNull(string4);
                naturalWonder = string4;
            }
            if (!statsGained.isEmpty() && naturalWonder != null) {
                this.civInfo.addStats(statsGained);
                String[] stringArray2 = new String[]{statsGained.toString()};
                this.civInfo.addNotification("We have received [" + statsGained + "] for discovering [" + naturalWonder + ']', Notification.NotificationCategory.General, stringArray2);
            }
            for (Unique unique : Civilization.getTriggeredUniques$default(this.civInfo, UniqueType.TriggerUponDiscoveringNaturalWonder, new StateForConditionals(this.civInfo, null, null, tile, null, null, null, null, null, null, false, 2038, null), null, 4, null)) {
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.civInfo, null, null, tile, null, "due to discovering a Natural Wonder", 44, null);
            }
        }
    }

    public final void updateHasActiveEnemyMovementPenalty() {
        this.civInfo.setHasActiveEnemyMovementPenalty(Civilization.hasUnique$default(this.civInfo, UniqueType.EnemyUnitsSpendExtraMovement, null, 2, null));
        this.civInfo.setEnemyMovementPenaltyUniques(Civilization.getMatchingUniques$default(this.civInfo, UniqueType.EnemyUnitsSpendExtraMovement, null, 2, null));
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCitiesConnectedToCapital(boolean initialSetup) {
        Collection collection;
        Collection oldConnectedCities;
        Collection collection2;
        Iterable destination$iv$iv;
        if (this.civInfo.getCities().isEmpty()) {
            return;
        }
        if (initialSetup) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.civInfo.getCities();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                City it = (City)element$iv$iv;
                boolean bl = false;
                if (!(it.getConnectedToCapitalStatus() == City.ConnectedToCapitalStatus.true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection2 = (List)destination$iv$iv;
        } else {
            collection2 = oldConnectedCities = (Collection)this.citiesConnectedToCapitalToMediums.keySet();
        }
        if (initialSetup) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.civInfo.getCities();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                City it = (City)element$iv$iv;
                boolean bl = false;
                if (!(it.getConnectedToCapitalStatus() != City.ConnectedToCapitalStatus.false)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv2;
        } else {
            collection = this.citiesConnectedToCapitalToMediums.keySet();
        }
        Collection oldMaybeConnectedCities = collection;
        this.citiesConnectedToCapitalToMediums = Civilization.getCapital$default(this.civInfo, false, 1, null) == null ? MapsKt.emptyMap() : new CapitalConnectionsFinder(this.civInfo).find();
        Set<City> newConnectedCities = this.citiesConnectedToCapitalToMediums.keySet();
        for (City city2 : newConnectedCities) {
            if (oldMaybeConnectedCities.contains(city2) || !Intrinsics.areEqual(city2.getCiv(), this.civInfo) || Intrinsics.areEqual(city2, Civilization.getCapital$default(this.civInfo, false, 1, null))) continue;
            String[] stringArray = new String[]{"StatIcons/Gold"};
            this.civInfo.addNotification('[' + city2.getName() + "] has been connected to your capital!", city2.getLocation(), Notification.NotificationCategory.Cities, stringArray);
        }
        for (City city2 : oldConnectedCities) {
            if (newConnectedCities.contains(city2) || !Intrinsics.areEqual(city2.getCiv(), this.civInfo) || city2.getPopulation().getPopulation() <= 0) continue;
            String[] stringArray = new String[]{"StatIcons/Gold"};
            this.civInfo.addNotification('[' + city2.getName() + "] has been disconnected from your capital!", city2.getLocation(), Notification.NotificationCategory.Cities, stringArray);
        }
        for (City city2 : this.civInfo.getCities()) {
            city2.setConnectedToCapitalStatus(newConnectedCities.contains(city2) ? City.ConnectedToCapitalStatus.true : City.ConnectedToCapitalStatus.false);
        }
    }

    public static /* synthetic */ void updateCitiesConnectedToCapital$default(CivInfoTransientCache civInfoTransientCache, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        civInfoTransientCache.updateCitiesConnectedToCapital(bl);
    }

    public final void updateCivResources() {
        Iterator<IsPartOfGameInfoSerialization> cityStateProvidedResources;
        ResourceSupplyList newDetailedCivResources = new ResourceSupplyList(false, 1, null);
        HashMap<String, Float> resourceModifers = this.civInfo.getResourceModifiers();
        for (City city2 : this.civInfo.getCities()) {
            newDetailedCivResources.add(city2.getResourcesGeneratedByCity(resourceModifers));
        }
        if (!this.civInfo.isCityState()) {
            cityStateProvidedResources = new ResourceSupplyList(false, 1, null);
            float resourceBonusPercentage = 1.0f;
            Iterator<Object> iterator2 = Civilization.getMatchingUniques$default(this.civInfo, UniqueType.CityStateResources, null, 2, null).iterator();
            while (iterator2.hasNext()) {
                Unique unique = (Unique)iterator2.next();
                resourceBonusPercentage += Float.parseFloat(unique.getParams().get(0)) / (float)100;
            }
            iterator2 = SequencesKt.filter(this.civInfo.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(this){
                final /* synthetic */ CivInfoTransientCache this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Civilization it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it.getAllyCivName(), this.this$0.getCivInfo().getCivName());
                }
            }).iterator();
            while (iterator2.hasNext()) {
                Civilization cityStateAlly = (Civilization)iterator2.next();
                for (ResourceSupplyList.ResourceSupply resourceSupply : cityStateAlly.getCityStateFunctions().getCityStateResourcesForAlly()) {
                    if (resourceSupply.getResource().hasUnique(UniqueType.CannotBeTraded, cityStateAlly.getState())) continue;
                    int newAmount = (int)((float)resourceSupply.getAmount() * resourceBonusPercentage);
                    Intrinsics.checkNotNull(resourceSupply);
                    ((ResourceSupplyList)((Object)cityStateProvidedResources)).add(ResourceSupplyList.ResourceSupply.copy$default(resourceSupply, null, null, newAmount, 3, null));
                }
            }
            newDetailedCivResources.addByResource((ResourceSupplyList)((Object)cityStateProvidedResources), "City-States");
        }
        cityStateProvidedResources = Civilization.getMatchingUniques$default(this.civInfo, UniqueType.ProvidesResources, null, 2, null).iterator();
        while (cityStateProvidedResources.hasNext()) {
            TileResource resource2;
            Unique unique = (Unique)cityStateProvidedResources.next();
            if (unique.getSourceObjectType() == UniqueTarget.Building || unique.getSourceObjectType() == UniqueTarget.Wonder) continue;
            Intrinsics.checkNotNull(this.civInfo.getGameInfo().getRuleset().getTileResources().get(unique.getParams().get(1)));
            newDetailedCivResources.add(resource2, unique.getSourceNameForUser(), (int)(Float.parseFloat(unique.getParams().get(0)) * this.civInfo.getResourceModifier(resource2)));
        }
        for (DiplomacyManager diplomacyManager : this.civInfo.getDiplomacy().values()) {
            newDetailedCivResources.add(diplomacyManager.resourcesFromTrade());
        }
        cityStateProvidedResources = this.civInfo.getUnits().getCivUnits().iterator();
        while (cityStateProvidedResources.hasNext()) {
            MapUnit unit = (MapUnit)cityStateProvidedResources.next();
            newDetailedCivResources.subtractResourceRequirements((HashMap<String, Integer>)unit.getResourceRequirementsPerTurn(), this.civInfo.getGameInfo().getRuleset(), "Units");
        }
        CollectionsKt.removeAll(newDetailedCivResources, (Function1)updateCivResources.2.INSTANCE);
        if (Intrinsics.areEqual(this.civInfo.getDetailedCivResources(), newDetailedCivResources)) {
            return;
        }
        ResourceSupplyList summarizedResourceSupply = newDetailedCivResources.sumByResource("All");
        UniqueMap newResourceUniqueMap = new UniqueMap();
        for (ResourceSupplyList.ResourceSupply resource3 : summarizedResourceSupply) {
            if (resource3.getAmount() <= 0) continue;
            newResourceUniqueMap.addUniques((Iterable<Unique>)resource3.getResource().getUniqueObjects());
        }
        this.civInfo.setDetailedCivResources(newDetailedCivResources);
        this.civInfo.setSummarizedCivResourceSupply(summarizedResourceSupply);
        this.civInfo.setCivResourcesUniqueMap(newResourceUniqueMap);
        this.civInfo.updateStatsForNextTurn();
    }

    @NotNull
    public final Proximity updateProximity(@NotNull Civilization otherCiv, @Nullable Proximity preCalculated) {
        int numMajors;
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (Intrinsics.areEqual(otherCiv, this.civInfo)) {
            return Proximity.None;
        }
        if (preCalculated != null) {
            ((Map)this.civInfo.getProximity()).put(otherCiv.getCivName(), preCalculated);
            return preCalculated;
        }
        if (this.civInfo.getCities().isEmpty() || otherCiv.getCities().isEmpty()) {
            ((Map)this.civInfo.getProximity()).put(otherCiv.getCivName(), Proximity.None);
            return Proximity.None;
        }
        MapParameters mapParams = this.civInfo.getGameInfo().getTileMap().getMapParameters();
        int minDistance = 100000;
        int totalDistance = 0;
        int connections = 0;
        Proximity proximity = Proximity.None;
        for (City ourCity : this.civInfo.getCities()) {
            for (City theirCity : otherCiv.getCities()) {
                int distance = ourCity.getCenterTile().aerialDistanceTo(theirCity.getCenterTile());
                totalDistance += distance;
                ++connections;
                if (minDistance <= distance) continue;
                minDistance = distance;
            }
        }
        if (minDistance <= 7) {
            proximity = Proximity.Neighbors;
        } else if (connections > 0) {
            int averageDistance = totalDistance / connections;
            int mapFactor = Intrinsics.areEqual(mapParams.getShape(), "Rectangular") ? (mapParams.getMapSize().getHeight() + mapParams.getMapSize().getWidth()) / 2 : mapParams.getMapSize().getRadius() * 3 / 2;
            int closeDistance = RangesKt.coerceIn(mapFactor * 25 / 100, 10, 20);
            int farDistance = RangesKt.coerceIn(mapFactor * 45 / 100, 20, 50);
            Proximity proximity2 = minDistance <= 11 && averageDistance <= closeDistance ? Proximity.Close : (proximity = averageDistance <= farDistance ? Proximity.Far : Proximity.Distant);
        }
        if (connections > 0 && proximity != Proximity.Distant && !this.civInfo.getGameInfo().getTileMap().isWaterMap()) {
            City city2 = Civilization.getCapital$default(this.civInfo, false, 1, null);
            Intrinsics.checkNotNull(city2);
            int n = city2.getCenterTile().getContinent();
            City city3 = Civilization.getCapital$default(otherCiv, false, 1, null);
            Intrinsics.checkNotNull(city3);
            if (n != city3.getCenterTile().getContinent()) {
                switch (WhenMappings.$EnumSwitchMapping$0[proximity.ordinal()]) {
                    case 1: {
                        Proximity proximity3 = Proximity.Distant;
                        break;
                    }
                    case 2: {
                        Proximity proximity3 = Proximity.Far;
                        break;
                    }
                    case 3: {
                        Proximity proximity3 = Proximity.Close;
                        break;
                    }
                    default: {
                        Proximity proximity3 = proximity = proximity;
                    }
                }
            }
        }
        if ((numMajors = this.civInfo.getGameInfo().getAliveMajorCivs().size()) <= 2 && proximity.compareTo((Enum)Proximity.Close) > 0) {
            proximity = Proximity.Close;
        }
        if (numMajors <= 4 && proximity.compareTo((Enum)Proximity.Far) > 0) {
            proximity = Proximity.Far;
        }
        ((Map)this.civInfo.getProximity()).put(otherCiv.getCivName(), proximity);
        return proximity;
    }

    public static /* synthetic */ Proximity updateProximity$default(CivInfoTransientCache civInfoTransientCache, Civilization civilization, Proximity proximity, int n, Object object) {
        if ((n & 2) != 0) {
            proximity = null;
        }
        return civInfoTransientCache.updateProximity(civilization, proximity);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Proximity.values().length];
            try {
                nArray[Proximity.Far.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proximity.Close.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proximity.Neighbors.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

