/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.files;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.logic.GameInfo;
import com.unciv.logic.files.Autosaves;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.metadata.GameSettings;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0010J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/unciv/logic/files/Autosaves;", "", "files", "Lcom/unciv/logic/files/UncivFiles;", "(Lcom/unciv/logic/files/UncivFiles;)V", "autoSaveJob", "Lkotlinx/coroutines/Job;", "getAutoSaveJob", "()Lkotlinx/coroutines/Job;", "setAutoSaveJob", "(Lkotlinx/coroutines/Job;)V", "getFiles", "()Lcom/unciv/logic/files/UncivFiles;", "autoSave", "", "gameInfo", "Lcom/unciv/logic/GameInfo;", "nextTurn", "", "autosaveExists", "loadLatestAutosave", "requestAutoSave", "requestAutoSaveUnCloned", "core"})
@SourceDebugExtension(value={"SMAP\nUncivFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivFiles.kt\ncom/unciv/logic/files/Autosaves\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,549:1\n1839#2,14:550\n1433#2,14:564\n*S KotlinDebug\n*F\n+ 1 UncivFiles.kt\ncom/unciv/logic/files/Autosaves\n*L\n520#1:550,14\n534#1:564,14\n*E\n"})
public final class Autosaves {
    @NotNull
    private final UncivFiles files;
    @Nullable
    private Job autoSaveJob;

    public Autosaves(@NotNull UncivFiles files2) {
        Intrinsics.checkNotNullParameter(files2, "files");
        this.files = files2;
    }

    @NotNull
    public final UncivFiles getFiles() {
        return this.files;
    }

    @Nullable
    public final Job getAutoSaveJob() {
        return this.autoSaveJob;
    }

    public final void setAutoSaveJob(@Nullable Job job2) {
        this.autoSaveJob = job2;
    }

    @NotNull
    public final Job requestAutoSave(@NotNull GameInfo gameInfo, boolean nextTurn2) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        return this.requestAutoSaveUnCloned(gameInfo.clone(), nextTurn2);
    }

    public static /* synthetic */ Job requestAutoSave$default(Autosaves autosaves2, GameInfo gameInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return autosaves2.requestAutoSave(gameInfo, bl);
    }

    @NotNull
    public final Job requestAutoSaveUnCloned(@NotNull GameInfo gameInfo, boolean nextTurn2) {
        Job job2;
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        this.autoSaveJob = job2 = Concurrency.run$default(Concurrency.INSTANCE, "autoSaveUnCloned", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, gameInfo, nextTurn2, null){
            int label;
            final /* synthetic */ Autosaves this$0;
            final /* synthetic */ GameInfo $gameInfo;
            final /* synthetic */ boolean $nextTurn;
            {
                this.this$0 = $receiver;
                this.$gameInfo = $gameInfo;
                this.$nextTurn = $nextTurn;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.this$0.autoSave(this.$gameInfo, this.$nextTurn);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return job2;
    }

    public static /* synthetic */ Job requestAutoSaveUnCloned$default(Autosaves autosaves2, GameInfo gameInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return autosaves2.requestAutoSaveUnCloned(gameInfo, bl);
    }

    public final void autoSave(@NotNull GameInfo gameInfo, boolean nextTurn2) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        GameSettings settings = this.files.getGeneralSettings();
        try {
            UncivFiles.saveGame$default(this.files, gameInfo, "Autosave", null, 4, null);
        }
        catch (OutOfMemoryError oom) {
            Log.INSTANCE.error("Ran out of memory during autosave", oom);
            return;
        }
        if (nextTurn2) {
            String newAutosaveFilename = "SaveFiles" + File.separator + "Autosave-" + gameInfo.getCurrentPlayer() + '-' + gameInfo.getTurns();
            FileHandle file = this.files.pathToFileHandler(newAutosaveFilename);
            this.files.getSave("Autosave").copyTo(file);
            while (SequencesKt.count(Autosaves.autoSave$getAutosaves(this)) > settings.getMaxAutosavesStored() + 1) {
                FileHandle fileHandle;
                Sequence<FileHandle> $this$minByOrNull$iv = Autosaves.autoSave$getAutosaves(this);
                boolean $i$f$minByOrNull = false;
                Iterator<FileHandle> iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    fileHandle = null;
                } else {
                    FileHandle minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        fileHandle = minElem$iv;
                    } else {
                        FileHandle it = minElem$iv;
                        boolean bl = false;
                        long minValue$iv = it.lastModified();
                        do {
                            FileHandle e$iv;
                            FileHandle it2 = e$iv = iterator$iv.next();
                            $i$a$-minByOrNull-Autosaves$autoSave$saveToDelete$1 = false;
                            long v$iv = it2.lastModified();
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        fileHandle = minElem$iv;
                    }
                }
                Intrinsics.checkNotNull(fileHandle);
                FileHandle saveToDelete = fileHandle;
                String string = saveToDelete.name();
                Intrinsics.checkNotNullExpressionValue(string, "name(...)");
                this.files.deleteSave(string);
            }
        }
    }

    public static /* synthetic */ void autoSave$default(Autosaves autosaves2, GameInfo gameInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        autosaves2.autoSave(gameInfo, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GameInfo loadLatestAutosave() {
        GameInfo gameInfo;
        try {
            gameInfo = this.files.loadGameByName("Autosave");
        }
        catch (Exception _) {
            Object v0;
            void $this$maxByOrNull$iv;
            Sequence autosaves2;
            Sequence sequence = autosaves2 = SequencesKt.filter(UncivFiles.getSaves$default(this.files, false, 1, null), loadLatestAutosave.autosaves.1.INSTANCE);
            UncivFiles uncivFiles = this.files;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    FileHandle it = (FileHandle)maxElem$iv;
                    boolean bl = false;
                    long maxValue$iv = it.lastModified();
                    do {
                        Object e$iv = iterator$iv.next();
                        FileHandle it2 = (FileHandle)e$iv;
                        $i$a$-maxByOrNull-Autosaves$loadLatestAutosave$1 = false;
                        long v$iv = it2.lastModified();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v0);
            gameInfo = uncivFiles.loadGameFromFile(v0);
        }
        return gameInfo;
    }

    public final boolean autosaveExists() {
        return this.files.getSave("Autosave").exists();
    }

    private static final Sequence<FileHandle> autoSave$getAutosaves(Autosaves this$0) {
        return SequencesKt.filter(UncivFiles.getSaves$default(this$0.files, false, 1, null), autoSave.getAutosaves.1.INSTANCE);
    }
}

