/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapunit.movement;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.MovementCost;
import com.unciv.logic.map.mapunit.movement.PathfindingCache;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.UnitMovementMemoryType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0002CDB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J,\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\nJ\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fJ%\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\u0017H\u0082\bJ\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fJ\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ8\u0010\u001e\u001a4\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0 0\u001fj\u001e\u0012\u0004\u0012\u00020\f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f0 j\b\u0012\u0004\u0012\u00020\f`\"`!J~\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\n2$\b\u0002\u0010&\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\u001fj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n`!2<\b\u0002\u0010'\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0(\u0012\u0004\u0012\u00020)0\u001fj\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0(\u0012\u0004\u0012\u00020)`!2\b\b\u0002\u0010\u0010\u001a\u00020\nJ\u00ac\u0001\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020)2\b\b\u0002\u0010%\u001a\u00020\n2\u001c\b\u0002\u0010.\u001a\u0016\u0012\u0004\u0012\u00020\f\u0018\u00010/j\n\u0012\u0004\u0012\u00020\f\u0018\u0001`02$\b\u0002\u0010&\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\u001fj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n`!2<\b\u0002\u0010'\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0(\u0012\u0004\u0012\u00020)0\u001fj\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0(\u0012\u0004\u0012\u00020)`!2\b\b\u0002\u0010\u0010\u001a\u00020\nJ\u001e\u00101\u001a\b\u0012\u0004\u0012\u00020\f022\u0006\u00103\u001a\u00020\f2\u0006\u00104\u001a\u00020\fH\u0002J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\f062\b\b\u0002\u0010\u0010\u001a\u00020\nJ\u001e\u00107\u001a\b\u0012\u0004\u0012\u00020\f082\u0006\u0010\u0012\u001a\u00020\f2\b\b\u0002\u00109\u001a\u00020\nJ\u000e\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\fJ\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\f06J\u000e\u0010=\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fJ\u0010\u0010>\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010?\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010@\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010%\u001a\u00020\nJ\u000e\u0010A\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010B\u001a\u00020\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006E\u00b2\u0006\n\u0010F\u001a\u00020\nX\u008a\u0084\u0002"}, d2={"Lcom/unciv/logic/map/mapunit/movement/UnitMovement;", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "(Lcom/unciv/logic/map/mapunit/MapUnit;)V", "pathfindingCache", "Lcom/unciv/logic/map/mapunit/movement/PathfindingCache;", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "canAirUnitMoveTo", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "canMoveTo", "assumeCanPassThrough", "allowSwap", "includeOtherEscortUnit", "canParadropOn", "destination", "canPassThrough", "canReach", "canReachCommon", "specificFunction", "Lkotlin/Function1;", "canReachInCurrentTurn", "canUnitSwapTo", "canUnitSwapToReachableTile", "reachableTile", "clearPathfindingCache", "", "getAerialPathsToCities", "Ljava/util/HashMap;", "Ljava/util/ArrayList;", "Lkotlin/collections/HashMap;", "Lkotlin/collections/ArrayList;", "getDistanceToTiles", "Lcom/unciv/logic/map/mapunit/movement/PathsToTilesWithinTurn;", "considerZoneOfControl", "passThroughCache", "movementCostCache", "Lkotlin/Pair;", "", "getMovementToTilesAtPosition", "position", "Lcom/badlogic/gdx/math/Vector2;", "unitMovement", "tilesToIgnore", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getPathBetweenTiles", "", "from", "to", "getReachableTilesInCurrentTurn", "Lkotlin/sequences/Sequence;", "getShortestPath", "", "avoidDamagingTerrain", "getTileToMoveToThisTurn", "finalDestination", "getUnitSwappableTiles", "headTowards", "isCityCenterCannotEnter", "isUnknownTileWeShouldAssumeToBePassable", "moveToTile", "swapMoveToTile", "teleportToClosestMoveableTile", "ParentTileAndTotalMovement", "UnreachableDestinationException", "core", "unitSpecificAllowOcean"})
@SourceDebugExtension(value={"SMAP\nUnitMovement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitMovement.kt\ncom/unciv/logic/map/mapunit/movement/UnitMovement\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,868:1\n279#1,10:925\n279#1,10:935\n372#2,7:869\n372#2,7:876\n372#2,7:885\n526#2:945\n511#2,6:946\n2159#3,2:883\n1224#3,2:894\n1839#3,14:911\n179#3,2:952\n819#4:892\n847#4:893\n848#4:896\n2310#4,14:897\n1373#4:954\n1461#4,5:955\n1045#4:960\n288#4,2:961\n959#4,7:963\n533#4,6:970\n766#4:976\n857#4,2:977\n1#5:979\n*S KotlinDebug\n*F\n+ 1 UnitMovement.kt\ncom/unciv/logic/map/mapunit/movement/UnitMovement\n*L\n270#1:925,10\n275#1:935,10\n61#1:869,7\n67#1:876,7\n191#1:885,7\n304#1:945\n304#1:946,6\n110#1:883,2\n210#1:894,2\n247#1:911,14\n373#1:952,2\n210#1:892\n210#1:893\n210#1:896\n233#1:897,14\n379#1:954\n379#1:955,5\n380#1:960\n380#1:961,2\n439#1:963,7\n440#1:970,6\n620#1:976\n620#1:977,2\n*E\n"})
public final class UnitMovement {
    @NotNull
    private final MapUnit unit;
    @NotNull
    private final PathfindingCache pathfindingCache;

    public UnitMovement(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.unit = unit;
        this.pathfindingCache = new PathfindingCache(this.unit);
    }

    @NotNull
    public final MapUnit getUnit() {
        return this.unit;
    }

    public final boolean isUnknownTileWeShouldAssumeToBePassable(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return !this.unit.getCiv().hasExplored(tile);
    }

    @NotNull
    public final PathsToTilesWithinTurn getMovementToTilesAtPosition(@NotNull Vector2 position, float unitMovement, boolean considerZoneOfControl, @Nullable HashSet<Tile> tilesToIgnore, @NotNull HashMap<Tile, Boolean> passThroughCache, @NotNull HashMap<Pair<Tile, Tile>, Float> movementCostCache, boolean includeOtherEscortUnit) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(passThroughCache, "passThroughCache");
        Intrinsics.checkNotNullParameter(movementCostCache, "movementCostCache");
        PathsToTilesWithinTurn distanceToTiles = new PathsToTilesWithinTurn();
        Tile currentUnitTile = this.unit.getCurrentTile();
        Tile unitTile = Intrinsics.areEqual(position, currentUnitTile.getPosition()) ? currentUnitTile : currentUnitTile.getTileMap().get(position);
        ((Map)distanceToTiles).put(unitTile, new ParentTileAndTotalMovement(unitTile, unitTile, 0.0f));
        if (unitMovement == 0.0f || this.unit.getCache().getCannotMove()) {
            return distanceToTiles;
        }
        if (includeOtherEscortUnit && this.unit.isEscorting()) {
            MapUnit mapUnit = this.unit.getOtherEscortUnit();
            if (Intrinsics.areEqual(mapUnit != null ? Float.valueOf(mapUnit.getCurrentMovement()) : null, 0.0f)) {
                return distanceToTiles;
            }
        }
        List tilesToCheck = CollectionsKt.listOf(unitTile);
        while (!((Collection)tilesToCheck).isEmpty()) {
            ArrayList updatedTiles = new ArrayList();
            for (Tile tileToCheck : tilesToCheck) {
                Iterator<Tile> iterator2 = tileToCheck.getNeighbors().iterator();
                while (iterator2.hasNext()) {
                    float usableMovement;
                    float f;
                    ParentTileAndTotalMovement currentBestPath;
                    float totalDistanceToTile;
                    float f2;
                    Tile neighbor = iterator2.next();
                    HashSet<Tile> hashSet = tilesToIgnore;
                    if (hashSet != null ? hashSet.contains(neighbor) : false) continue;
                    if (!neighbor.isExplored(this.unit.getCiv())) {
                        Object object = distanceToTiles.get((Object)tileToCheck);
                        Intrinsics.checkNotNull(object);
                        f2 = ((ParentTileAndTotalMovement)object).getTotalMovement() + 1.0f;
                    } else {
                        Object object;
                        Map $this$getOrPut$iv = passThroughCache;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(neighbor);
                        if (value$iv == null) {
                            boolean bl = false;
                            Boolean answer$iv = UnitMovement.canPassThrough$default(this, neighbor, false, 2, null);
                            $this$getOrPut$iv.put(neighbor, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        if (!((Boolean)object).booleanValue()) {
                            f2 = unitMovement;
                        } else {
                            Object object2;
                            Pair<Tile, Tile> key = new Pair<Tile, Tile>(tileToCheck, neighbor);
                            Map $this$getOrPut$iv2 = movementCostCache;
                            boolean $i$f$getOrPut2 = false;
                            Object value$iv2 = $this$getOrPut$iv2.get(key);
                            if (value$iv2 == null) {
                                boolean bl = false;
                                Float answer$iv = Float.valueOf(MovementCost.INSTANCE.getMovementCostBetweenAdjacentTilesEscort(this.unit, tileToCheck, neighbor, considerZoneOfControl, includeOtherEscortUnit));
                                $this$getOrPut$iv2.put(key, answer$iv);
                                object2 = answer$iv;
                            } else {
                                object2 = value$iv2;
                            }
                            float movementCost = ((Number)object2).floatValue();
                            Object object3 = distanceToTiles.get((Object)tileToCheck);
                            Intrinsics.checkNotNull(object3);
                            f2 = totalDistanceToTile = ((ParentTileAndTotalMovement)object3).getTotalMovement() + movementCost;
                        }
                    }
                    if ((currentBestPath = (ParentTileAndTotalMovement)distanceToTiles.get((Object)neighbor)) != null && !(currentBestPath.getTotalMovement() > totalDistanceToTile)) continue;
                    if (includeOtherEscortUnit && this.unit.isEscorting()) {
                        MapUnit mapUnit = this.unit.getOtherEscortUnit();
                        Intrinsics.checkNotNull(mapUnit);
                        f = Math.min(unitMovement, mapUnit.getCurrentMovement());
                    } else {
                        f = usableMovement = unitMovement;
                    }
                    if (totalDistanceToTile < usableMovement - 0.05f) {
                        ((Collection)updatedTiles).add(neighbor);
                    } else {
                        totalDistanceToTile = usableMovement;
                    }
                    ((Map)distanceToTiles).put(neighbor, new ParentTileAndTotalMovement(neighbor, tileToCheck, totalDistanceToTile));
                }
            }
            tilesToCheck = updatedTiles;
        }
        return distanceToTiles;
    }

    public static /* synthetic */ PathsToTilesWithinTurn getMovementToTilesAtPosition$default(UnitMovement unitMovement, Vector2 vector2, float f, boolean bl, HashSet hashSet, HashMap hashMap, HashMap hashMap2, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            hashSet = null;
        }
        if ((n & 0x10) != 0) {
            hashMap = new HashMap<Tile, Boolean>();
        }
        if ((n & 0x20) != 0) {
            hashMap2 = new HashMap<Pair<Tile, Tile>, Float>();
        }
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        return unitMovement.getMovementToTilesAtPosition(vector2, f, bl, hashSet, hashMap, hashMap2, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Tile> getShortestPath(@NotNull Tile destination2, boolean avoidDamagingTerrain) {
        boolean bl;
        block20: {
            List<Tile> damageFreePath;
            Intrinsics.checkNotNullParameter(destination2, "destination");
            if (this.unit.getCache().getCannotMove()) {
                return CollectionsKt.emptyList();
            }
            if (!avoidDamagingTerrain && this.unit.getCiv().getPassThroughImpassableUnlocked() && this.unit.getBaseUnit().isLandUnit() && !((Collection)(damageFreePath = this.getShortestPath(destination2, true))).isEmpty()) {
                return damageFreePath;
            }
            Sequence<Tile> $this$none$iv = destination2.getNeighbors();
            boolean $i$f$none = false;
            Iterator<Tile> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(this.isUnknownTileWeShouldAssumeToBePassable(it) || UnitMovement.canPassThrough$default(this, it, false, 2, null))) continue;
                bl = false;
                break block20;
            }
            bl = true;
        }
        if (bl) {
            this.pathfindingCache.setShortestPathCache(destination2, CollectionsKt.emptyList());
            return CollectionsKt.emptyList();
        }
        List<Tile> cachedPath = this.pathfindingCache.getShortestPathCache(destination2);
        if (!((Collection)cachedPath).isEmpty()) {
            return cachedPath;
        }
        Tile currentTile = this.unit.getTile();
        if (Intrinsics.areEqual(currentTile.getPosition(), destination2.getPosition())) {
            this.pathfindingCache.setShortestPathCache(destination2, CollectionsKt.listOf(currentTile));
            return CollectionsKt.listOf(currentTile);
        }
        List tilesToCheck = CollectionsKt.listOf(currentTile);
        HashMap movementTreeParents = new HashMap();
        ((Map)movementTreeParents).put(currentTile, null);
        int distance = 1;
        float unitMaxMovement = MapUnit.getMaxMovement$default(this.unit, false, 1, null);
        ArrayList<Tile> newTilesToCheck = new ArrayList<Tile>();
        Tile[] tileArray = new Tile[]{currentTile};
        HashSet<Tile> visitedTiles = SetsKt.hashSetOf(tileArray);
        Civilization civilization = this.unit.getCiv();
        HashMap passThroughCache = new HashMap();
        HashMap movementCostCache = new HashMap();
        HashMap canMoveToCache = new HashMap();
        while (true) {
            void $this$filterNotTo$iv$iv;
            Object distanceToTilesThisTurn;
            Comparator comparator;
            Function1[] function1Array;
            newTilesToCheck.clear();
            if (this.unit.getType().isLandUnit()) {
                function1Array = new Function1[]{getShortestPath.comparison.1.INSTANCE, new Function1<Tile, Comparable<?>>(destination2){
                    final /* synthetic */ Tile $destination;
                    {
                        this.$destination = $destination;
                        super(1);
                    }

                    @Nullable
                    public final Comparable<?> invoke(@NotNull Tile it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return it.aerialDistanceTo(this.$destination);
                    }
                }, new Function1<Tile, Boolean>(this){
                    final /* synthetic */ UnitMovement this$0;
                    {
                        this.this$0 = $receiver;
                        super(1, Intrinsics.Kotlin.class, "isUnfriendlyCityState", "getShortestPath$isUnfriendlyCityState(Lcom/unciv/logic/map/mapunit/movement/UnitMovement;Lcom/unciv/logic/map/tile/Tile;)Z", 0);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Tile p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return UnitMovement.access$getShortestPath$isUnfriendlyCityState(this.this$0, p0);
                    }
                }};
                comparator = ComparisonsKt.compareBy(function1Array);
            } else {
                function1Array = new Function1[]{new Function1<Tile, Comparable<?>>(destination2){
                    final /* synthetic */ Tile $destination;
                    {
                        this.$destination = $destination;
                        super(1);
                    }

                    @Nullable
                    public final Comparable<?> invoke(@NotNull Tile it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return it.aerialDistanceTo(this.$destination);
                    }
                }, new Function1<Tile, Boolean>(this){
                    final /* synthetic */ UnitMovement this$0;
                    {
                        this.this$0 = $receiver;
                        super(1, Intrinsics.Kotlin.class, "isUnfriendlyCityState", "getShortestPath$isUnfriendlyCityState(Lcom/unciv/logic/map/mapunit/movement/UnitMovement;Lcom/unciv/logic/map/tile/Tile;)Z", 0);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Tile p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return UnitMovement.access$getShortestPath$isUnfriendlyCityState(this.this$0, p0);
                    }
                }};
                comparator = ComparisonsKt.compareBy(function1Array);
            }
            Comparator comparison2 = comparator;
            List<Tile> tilesByPreference = CollectionsKt.sortedWith(tilesToCheck, comparison2);
            for (Tile tileToCheck : tilesByPreference) {
                distanceToTilesThisTurn = distance == 1 ? UnitMovement.getDistanceToTiles$default(this, true, passThroughCache, movementCostCache, false, 8, null) : UnitMovement.getMovementToTilesAtPosition$default(this, tileToCheck.getPosition(), unitMaxMovement, false, visitedTiles, passThroughCache, movementCostCache, false, 64, null);
                for (Tile reachableTile : ((PathsToTilesWithinTurn)distanceToTilesThisTurn).keySet()) {
                    Object path;
                    if (avoidDamagingTerrain) {
                        Intrinsics.checkNotNull(reachableTile);
                        if (this.unit.getDamageFromTerrain(reachableTile) > 0) continue;
                    }
                    if (this.unit.isCivilian() && this.unit.isAutomated() && reachableTile.isEnemyTerritory(civilization)) continue;
                    if (Intrinsics.areEqual(reachableTile, destination2)) {
                        Tile[] tileArray2 = new Tile[]{destination2};
                        path = CollectionsKt.mutableListOf(tileArray2);
                        Tile intermediateTile = tileToCheck;
                        while (!Intrinsics.areEqual(intermediateTile, currentTile)) {
                            path.add(intermediateTile);
                            Object v = movementTreeParents.get(intermediateTile);
                            Intrinsics.checkNotNull(v);
                            intermediateTile = (Tile)v;
                        }
                        CollectionsKt.reverse(path);
                        this.pathfindingCache.setShortestPathCache(destination2, (List<Tile>)path);
                        return path;
                    }
                    if (movementTreeParents.containsKey(reachableTile)) continue;
                    Intrinsics.checkNotNull(reachableTile);
                    if (!this.isUnknownTileWeShouldAssumeToBePassable(reachableTile)) {
                        Object object;
                        void $this$getOrPut$iv;
                        path = canMoveToCache;
                        Tile key$iv = reachableTile;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl3 = false;
                            Boolean answer$iv = UnitMovement.canMoveTo$default(this, reachableTile, false, false, false, 14, null);
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        if (!((Boolean)object).booleanValue()) continue;
                    }
                    ((Map)movementTreeParents).put(reachableTile, tileToCheck);
                    newTilesToCheck.add(reachableTile);
                }
            }
            if (newTilesToCheck.isEmpty()) {
                this.pathfindingCache.setShortestPathCache(destination2, CollectionsKt.emptyList());
                return CollectionsKt.emptyList();
            }
            visitedTiles.addAll((Collection<Tile>)newTilesToCheck);
            Iterable $this$filterNot$iv = newTilesToCheck;
            boolean $i$f$filterNot = false;
            distanceToTilesThisTurn = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                boolean bl2;
                block21: {
                    Tile tile = (Tile)element$iv$iv;
                    boolean bl5 = false;
                    Sequence<Tile> $this$all$iv = tile.getNeighbors();
                    boolean $i$f$all = false;
                    Iterator<Tile> iterator3 = $this$all$iv.iterator();
                    while (iterator3.hasNext()) {
                        Tile element$iv;
                        Tile it = element$iv = iterator3.next();
                        boolean bl6 = false;
                        if (visitedTiles.contains(it)) continue;
                        bl2 = false;
                        break block21;
                    }
                    bl2 = true;
                }
                if (bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tilesToCheck = (List)destination$iv$iv;
            ++distance;
        }
    }

    public static /* synthetic */ List getShortestPath$default(UnitMovement unitMovement, Tile tile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return unitMovement.getShortestPath(tile, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Tile getTileToMoveToThisTurn(@NotNull Tile finalDestination) {
        Tile tile;
        Tile tile2;
        Intrinsics.checkNotNullParameter(finalDestination, "finalDestination");
        Tile currentTile = this.unit.getTile();
        if (Intrinsics.areEqual(currentTile, finalDestination)) {
            return currentTile;
        }
        if ((this.unit.getBaseUnit().getMovesLikeAirUnits() || this.unit.isPreparingParadrop()) && UnitMovement.canMoveTo$default(this, finalDestination, false, false, false, 14, null)) {
            return finalDestination;
        }
        PathsToTilesWithinTurn distanceToTiles = UnitMovement.getDistanceToTiles$default(this, false, null, null, false, 15, null);
        if (!distanceToTiles.containsKey((Object)finalDestination)) {
            Tile tile3 = (Tile)CollectionsKt.firstOrNull(UnitMovement.getShortestPath$default(this, finalDestination, false, 2, null));
            if (tile3 == null) {
                throw new UnreachableDestinationException(this.unit + ' ' + this.unit.getCurrentTile() + " cannot reach " + finalDestination);
            }
            Tile shortestDestination = tile3;
            if (!((Map)distanceToTiles).containsKey(shortestDestination)) {
                Object t;
                Set<Tile> set2 = distanceToTiles.keySet();
                Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
                Iterable $this$minBy$iv = set2;
                boolean $i$f$minByOrThrow = false;
                Iterator iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t = minElem$iv;
                } else {
                    Tile it = (Tile)minElem$iv;
                    boolean bl = false;
                    int minValue$iv = it.aerialDistanceTo(finalDestination);
                    do {
                        Object e$iv = iterator$iv.next();
                        Tile it2 = (Tile)e$iv;
                        $i$a$-minByOrThrow-UnitMovement$getTileToMoveToThisTurn$1 = false;
                        int v$iv = it2.aerialDistanceTo(finalDestination);
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t = minElem$iv;
                }
                return (Tile)t;
            }
            return shortestDestination;
        }
        if (UnitMovement.canMoveTo$default(this, finalDestination, false, false, false, 14, null)) {
            return finalDestination;
        }
        Sequence<Tile> destinationNeighbors = finalDestination.getNeighbors();
        if (SequencesKt.contains(destinationNeighbors, tile2 = currentTile)) {
            tile = currentTile;
        } else {
            Object v4;
            void $this$minByOrNull$iv;
            Sequence<Tile> iterator$iv = SequencesKt.filter(destinationNeighbors, (Function1)new Function1<Tile, Boolean>(distanceToTiles, this){
                final /* synthetic */ PathsToTilesWithinTurn $distanceToTiles;
                final /* synthetic */ UnitMovement this$0;
                {
                    this.$distanceToTiles = $distanceToTiles;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$distanceToTiles.containsKey((Object)it) && UnitMovement.canMoveTo$default(this.this$0, it, false, false, false, 14, null);
                }
            });
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv2 = $this$minByOrNull$iv.iterator();
            if (!iterator$iv2.hasNext()) {
                v4 = null;
            } else {
                Object minElem$iv = iterator$iv2.next();
                if (!iterator$iv2.hasNext()) {
                    v4 = minElem$iv;
                } else {
                    Tile it = (Tile)minElem$iv;
                    boolean bl = false;
                    float minValue$iv = ((ParentTileAndTotalMovement)MapsKt.getValue(distanceToTiles, it)).getTotalMovement();
                    do {
                        Object e$iv = iterator$iv2.next();
                        Tile it3 = (Tile)e$iv;
                        $i$a$-minByOrNull-UnitMovement$getTileToMoveToThisTurn$3 = false;
                        float v$iv = ((ParentTileAndTotalMovement)MapsKt.getValue(distanceToTiles, it3)).getTotalMovement();
                        if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv2.hasNext());
                    v4 = minElem$iv;
                }
            }
            if ((tile = (Tile)v4) == null) {
                tile = currentTile;
            }
        }
        return tile;
    }

    @NotNull
    public final Tile headTowards(@NotNull Tile destination2) {
        Intrinsics.checkNotNullParameter(destination2, "destination");
        MapUnit escortUnit = this.unit.isEscorting() ? this.unit.getOtherEscortUnit() : null;
        Tile startTile = this.unit.getTile();
        Tile destinationTileThisTurn = this.getTileToMoveToThisTurn(destination2);
        UnitMovement.moveToTile$default(this, destinationTileThisTurn, false, 2, null);
        if (!Intrinsics.areEqual(startTile, this.unit.getTile()) && escortUnit != null) {
            escortUnit.getMovement().headTowards(this.unit.getTile());
        }
        return this.unit.getCurrentTile();
    }

    public final boolean canReach(@NotNull Tile destination2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(destination2, "destination");
        UnitMovement this_$iv = this;
        boolean $i$f$canReachCommon = false;
        if (this_$iv.unit.getCache().getCannotMove()) {
            bl = Intrinsics.areEqual(destination2, this_$iv.unit.getTile());
        } else if (this_$iv.unit.getBaseUnit().getMovesLikeAirUnits()) {
            bl = this_$iv.unit.getCurrentTile().aerialDistanceTo(destination2) <= this_$iv.unit.getMaxMovementForAirUnits();
        } else if (this_$iv.unit.isPreparingParadrop()) {
            bl = this_$iv.unit.getCurrentTile().aerialDistanceTo(destination2) <= this_$iv.unit.getCache().getParadropRange() && this_$iv.canParadropOn(destination2);
        } else {
            Tile it = destination2;
            boolean bl2 = false;
            bl = CollectionsKt.any(UnitMovement.getShortestPath$default(this, it, false, 2, null));
        }
        return bl;
    }

    public final boolean canReachInCurrentTurn(@NotNull Tile destination2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(destination2, "destination");
        UnitMovement this_$iv = this;
        boolean $i$f$canReachCommon = false;
        if (this_$iv.unit.getCache().getCannotMove()) {
            bl = Intrinsics.areEqual(destination2, this_$iv.unit.getTile());
        } else if (this_$iv.unit.getBaseUnit().getMovesLikeAirUnits()) {
            bl = this_$iv.unit.getCurrentTile().aerialDistanceTo(destination2) <= this_$iv.unit.getMaxMovementForAirUnits();
        } else if (this_$iv.unit.isPreparingParadrop()) {
            bl = this_$iv.unit.getCurrentTile().aerialDistanceTo(destination2) <= this_$iv.unit.getCache().getParadropRange() && this_$iv.canParadropOn(destination2);
        } else {
            Tile it = destination2;
            boolean bl2 = false;
            bl = UnitMovement.getDistanceToTiles$default(this, false, null, null, false, 15, null).containsKey((Object)it);
        }
        return bl;
    }

    private final boolean canReachCommon(Tile destination2, Function1<? super Tile, Boolean> specificFunction) {
        boolean $i$f$canReachCommon = false;
        return this.unit.getCache().getCannotMove() ? Intrinsics.areEqual(destination2, this.unit.getTile()) : (this.unit.getBaseUnit().getMovesLikeAirUnits() ? this.unit.getCurrentTile().aerialDistanceTo(destination2) <= this.unit.getMaxMovementForAirUnits() : (this.unit.isPreparingParadrop() ? this.unit.getCurrentTile().aerialDistanceTo(destination2) <= this.unit.getCache().getParadropRange() && this.canParadropOn(destination2) : specificFunction.invoke(destination2)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Sequence<Tile> getReachableTilesInCurrentTurn(boolean includeOtherEscortUnit) {
        Sequence<Tile> sequence;
        if (this.unit.getCache().getCannotMove()) {
            Tile[] tileArray = new Tile[]{this.unit.getTile()};
            sequence = SequencesKt.sequenceOf(tileArray);
        } else if (this.unit.getBaseUnit().getMovesLikeAirUnits()) {
            sequence = this.unit.getTile().getTilesInDistanceRange(new IntRange(1, this.unit.getMaxMovementForAirUnits()));
        } else if (this.unit.isPreparingParadrop()) {
            sequence = SequencesKt.filter(this.unit.getTile().getTilesInDistance(this.unit.getCache().getParadropRange()), (Function1)new Function1<Tile, Boolean>(this){
                final /* synthetic */ UnitMovement this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return UnitMovement.access$canParadropOn(this.this$0.getUnit().getMovement(), it);
                }
            });
        } else if (includeOtherEscortUnit && this.unit.isEscorting()) {
            void $this$filterTo$iv$iv;
            MapUnit mapUnit = this.unit.getOtherEscortUnit();
            Intrinsics.checkNotNull(mapUnit);
            Set<Tile> otherUnitTiles = SequencesKt.toSet(mapUnit.getMovement().getReachableTilesInCurrentTurn(false));
            Map $this$filter$iv = UnitMovement.getDistanceToTiles$default(this.unit.getMovement(), false, null, null, false, 15, null);
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!otherUnitTiles.contains(it.getKey())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            sequence = CollectionsKt.asSequence(destination$iv$iv.keySet());
        } else {
            Set<Tile> set2 = UnitMovement.getDistanceToTiles$default(this.unit.getMovement(), false, null, null, false, 15, null).keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
            sequence = CollectionsKt.asSequence((Iterable)set2);
        }
        return sequence;
    }

    public static /* synthetic */ Sequence getReachableTilesInCurrentTurn$default(UnitMovement unitMovement, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return unitMovement.getReachableTilesInCurrentTurn(bl);
    }

    public final boolean canUnitSwapTo(@NotNull Tile destination2) {
        Intrinsics.checkNotNullParameter(destination2, "destination");
        return this.canReachInCurrentTurn(destination2) && this.canUnitSwapToReachableTile(destination2);
    }

    @NotNull
    public final Sequence<Tile> getUnitSwappableTiles() {
        return SequencesKt.filter(UnitMovement.getReachableTilesInCurrentTurn$default(this, false, 1, null), (Function1)new Function1<Tile, Boolean>(this){
            final /* synthetic */ UnitMovement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return UnitMovement.access$canUnitSwapToReachableTile(this.this$0, it);
            }
        });
    }

    private final boolean canUnitSwapToReachableTile(Tile reachableTile) {
        if (this.unit.getBaseUnit().getMovesLikeAirUnits()) {
            return false;
        }
        if (Intrinsics.areEqual(reachableTile, this.unit.getTile())) {
            return false;
        }
        if (this.unit.getCache().getCannotMove()) {
            return false;
        }
        MapUnit mapUnit = this.unit.isCivilian() ? reachableTile.getCivilianUnit() : reachableTile.getMilitaryUnit();
        if (mapUnit == null) {
            return false;
        }
        MapUnit otherUnit = mapUnit;
        Tile ourPosition = this.unit.getTile();
        if (!Intrinsics.areEqual(otherUnit.getOwner(), this.unit.getOwner()) || otherUnit.getCache().getCannotMove() || !otherUnit.getMovement().canReachInCurrentTurn(ourPosition)) {
            return false;
        }
        if (!UnitMovement.canMoveTo$default(this, reachableTile, false, true, false, 10, null)) {
            return false;
        }
        return UnitMovement.canMoveTo$default(otherUnit.getMovement(), ourPosition, false, true, false, 10, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void teleportToClosestMoveableTile() {
        Object element$iv;
        this.unit.stopEscorting();
        if (this.unit.isTransported()) {
            return;
        }
        Tile allowedTile = null;
        int distance = 0;
        if (UnitMovement.canPassThrough$default(this, this.unit.getTile(), false, 2, null) && !this.isCityCenterCannotEnter(this.unit.getTile())) {
            return;
        }
        while (allowedTile == null && distance < 5) {
            Object object;
            block11: {
                Sequence<Tile> $this$firstOrNull$iv = SequencesKt.filter(this.unit.getTile().getTilesAtDistance(++distance), (Function1)new Function1<Tile, Boolean>(this){
                    final /* synthetic */ UnitMovement this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull Tile it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (UnitMovement.canMoveTo$default(this.this$0, it, false, false, false, 14, null)) {
                            Civilization civilization = it.getOwner();
                            if (!(civilization != null ? civilization.isAtWarWith(this.this$0.getUnit().getCiv()) : false)) {
                                bl = true;
                                return bl;
                            }
                        }
                        bl = false;
                        return bl;
                    }
                });
                boolean $i$f$firstOrNull = false;
                Iterator<Tile> iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    Tile it = (Tile)element$iv;
                    boolean bl = false;
                    if (!this.getPathBetweenTiles(this.unit.getCurrentTile(), it).contains(it)) continue;
                    object = element$iv;
                    break block11;
                }
                object = null;
            }
            allowedTile = (Tile)object;
        }
        Tile origin2 = this.unit.getTile();
        if (allowedTile == null) {
            Object v1;
            block12: {
                void $this$firstOrNull$iv;
                Iterable $this$sortedBy$iv;
                Iterator $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = this.unit.getCiv().getCities();
                boolean $i$f$flatMapSequence = false;
                element$iv = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapSequenceTo = false;
                Iterator iterator3 = $this$flatMapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    Object element$iv$iv = iterator3.next();
                    City it = (City)element$iv$iv;
                    boolean bl = false;
                    Sequence<Tile> list$iv$iv = it.getTiles();
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(origin2){
                    final /* synthetic */ Tile $origin$inlined;
                    {
                        this.$origin$inlined = tile;
                    }

                    public final int compare(T a, T b) {
                        Tile it = (Tile)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$origin$inlined));
                        it = (Tile)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$origin$inlined));
                    }
                });
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Tile it = (Tile)element$iv2;
                    boolean bl = false;
                    if (!UnitMovement.canMoveTo$default(this, it, false, false, false, 14, null)) continue;
                    v1 = element$iv2;
                    break block12;
                }
                v1 = null;
            }
            allowedTile = v1;
        }
        if (allowedTile != null) {
            this.unit.removeFromTile();
            this.unit.putInTile(allowedTile);
            if (this.unit.isSleeping() || this.unit.isFortified() || this.unit.isGuarding()) {
                this.unit.setAction(null);
            }
            this.unit.setMostRecentMoveType(UnitMovementMemoryType.UnitTeleported);
            List<MapUnit> payloadUnits2 = SequencesKt.toList(SequencesKt.filter(origin2.getUnits(), (Function1)new Function1<MapUnit, Boolean>(this){
                final /* synthetic */ UnitMovement this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull MapUnit it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.isTransported() && this.this$0.getUnit().canTransport(it);
                }
            }));
            for (MapUnit payload : payloadUnits2) {
                payload.removeFromTile();
                payload.putInTile(allowedTile);
                payload.setTransported(true);
                payload.setMostRecentMoveType(UnitMovementMemoryType.UnitTeleported);
            }
        } else {
            MapUnit.destroy$default(this.unit, false, 1, null);
        }
    }

    public final void moveToTile(@NotNull Tile destination2, boolean considerZoneOfControl) {
        Object v2;
        PathsToTilesWithinTurn distanceToTiles;
        MapUnit escortUnit;
        block21: {
            List movableTiles;
            MapUnit mapUnit;
            Intrinsics.checkNotNullParameter(destination2, "destination");
            if (Intrinsics.areEqual(destination2, this.unit.getTile()) || this.unit.isDestroyed()) {
                return;
            }
            if (this.unit.isEscorting()) {
                MapUnit mapUnit2 = this.unit.getOtherEscortUnit();
                mapUnit = mapUnit2;
                Intrinsics.checkNotNull(mapUnit2);
            } else {
                mapUnit = escortUnit = null;
            }
            if (this.unit.getBaseUnit().getMovesLikeAirUnits()) {
                if (!Intrinsics.areEqual(this.unit.getAction(), UnitActionType.Automate.getValue())) {
                    this.unit.setAction(null);
                }
                this.unit.removeFromTile();
                this.unit.setTransported(false);
                this.unit.putInTile(destination2);
                this.unit.setCurrentMovement(0.0f);
                this.unit.setMostRecentMoveType(UnitMovementMemoryType.UnitTeleported);
                return;
            }
            if (this.unit.isPreparingParadrop()) {
                this.unit.setAction(null);
                this.unit.removeFromTile();
                this.unit.putInTile(destination2);
                this.unit.setMostRecentMoveType(UnitMovementMemoryType.UnitTeleported);
                this.unit.useMovementPoints(1.0f);
                MapUnit mapUnit3 = this.unit;
                mapUnit3.setAttacksThisTurn(mapUnit3.getAttacksThisTurn() + 1);
                if (this.unit.canGarrison() && (this.unit.getTile().isCityCenter() || destination2.isCityCenter()) && Civilization.hasUnique$default(this.unit.getCiv(), UniqueType.UnitsInCitiesNoMaintenance, null, 2, null)) {
                    this.unit.getCiv().updateStatsForNextTurn();
                }
                return;
            }
            distanceToTiles = UnitMovement.getDistanceToTiles$default(this, considerZoneOfControl, null, null, false, 14, null);
            List<Tile> pathToDestination = distanceToTiles.getPathToTile(destination2);
            Iterable $this$takeWhile$iv = pathToDestination;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                Tile it = (Tile)item$iv;
                boolean bl = false;
                if (!UnitMovement.canPassThrough$default(this, it, false, 2, null)) break;
                list$iv.add(item$iv);
            }
            List $this$lastOrNull$iv = movableTiles = (List)list$iv;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!UnitMovement.canMoveTo$default(this, it, false, false, false, 14, null)) continue;
                v2 = element$iv;
                break block21;
            }
            v2 = null;
        }
        Tile tile = v2;
        if (tile == null) {
            return;
        }
        Tile lastReachableTile = tile;
        this.unit.setMostRecentMoveType(UnitMovementMemoryType.UnitMoved);
        List<Tile> pathToLastReachableTile = distanceToTiles.getPathToTile(lastReachableTile);
        if (this.unit.isFortified() || this.unit.isGuarding() || this.unit.isSetUpForSiege() || this.unit.isSleeping()) {
            this.unit.setAction(null);
        }
        Tile origin2 = this.unit.getTile();
        boolean needToFindNewRoute = false;
        Tile lastReachedEnterableTile = this.unit.getTile();
        Tile previousTile = this.unit.getTile();
        float passingMovementSpent = 0.0f;
        for (Tile tile2 : pathToLastReachableTile) {
            if (!UnitMovement.canPassThrough$default(this.unit.getMovement(), tile2, false, 2, null)) {
                needToFindNewRoute = true;
                break;
            }
            if (!this.unit.getCiv().getGameInfo().getGameParameters().getGodMode()) {
                passingMovementSpent += MovementCost.getMovementCostBetweenAdjacentTiles$default(MovementCost.INSTANCE, this.unit, previousTile, tile2, false, 8, null);
            }
            if (UnitMovement.canMoveTo$default(this.unit.getMovement(), tile2, true, false, false, 12, null)) {
                lastReachedEnterableTile = tile2;
                this.unit.useMovementPoints(passingMovementSpent);
                this.unit.removeFromTile();
                this.unit.putInTile(tile2);
                if (escortUnit != null) {
                    UnitMovement.moveToTile$default(escortUnit.getMovement(), tile2, false, 2, null);
                    this.unit.startEscorting();
                }
                passingMovementSpent = 0.0f;
            }
            previousTile = tile2;
            if (!this.unit.isDestroyed() && !(this.unit.getCurrentMovement() - passingMovementSpent < 0.05f)) continue;
        }
        Tile finalTileReached = lastReachedEnterableTile;
        if (this.unit.getCurrentMovement() < 0.05f) {
            this.unit.setCurrentMovement(0.0f);
        }
        List<MapUnit> payloadUnits2 = SequencesKt.toList(SequencesKt.filter(origin2.getUnits(), (Function1)new Function1<MapUnit, Boolean>(this){
            final /* synthetic */ UnitMovement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MapUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isTransported() && this.this$0.getUnit().canTransport(it);
            }
        }));
        for (MapUnit payload : payloadUnits2) {
            payload.removeFromTile();
            for (Tile tile3 : pathToLastReachableTile) {
                payload.moveThroughTile(tile3);
                if (!Intrinsics.areEqual(tile3, finalTileReached)) continue;
            }
            payload.putInTile(finalTileReached);
            payload.setTransported(true);
            payload.setMostRecentMoveType(UnitMovementMemoryType.UnitMoved);
        }
        if (this.unit.canGarrison() && (origin2.isCityCenter() || finalTileReached.isCityCenter()) && Civilization.hasUnique$default(this.unit.getCiv(), UniqueType.UnitsInCitiesNoMaintenance, null, 2, null)) {
            this.unit.getCiv().updateStatsForNextTurn();
        }
        if (needToFindNewRoute && !Intrinsics.areEqual(this.unit.getCurrentTile(), origin2)) {
            this.moveToTile(destination2, considerZoneOfControl);
        }
        this.unit.updateUniques();
    }

    public static /* synthetic */ void moveToTile$default(UnitMovement unitMovement, Tile tile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        unitMovement.moveToTile(tile, bl);
    }

    public final void swapMoveToTile(@NotNull Tile destination2) {
        Intrinsics.checkNotNullParameter(destination2, "destination");
        this.unit.stopEscorting();
        MapUnit mapUnit = this.unit.isCivilian() ? destination2.getCivilianUnit() : destination2.getMilitaryUnit();
        if (mapUnit == null) {
            return;
        }
        MapUnit otherUnit = mapUnit;
        otherUnit.stopEscorting();
        Tile ourOldPosition = this.unit.getTile();
        Tile theirOldPosition = otherUnit.getTile();
        List<MapUnit> ourPayload2 = SequencesKt.toList(SequencesKt.filter(ourOldPosition.getUnits(), (Function1)new Function1<MapUnit, Boolean>(this){
            final /* synthetic */ UnitMovement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MapUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isTransported() && this.this$0.getUnit().isTransportTypeOf(it);
            }
        }));
        List<MapUnit> theirPayload2 = SequencesKt.toList(SequencesKt.filter(theirOldPosition.getUnits(), (Function1)new Function1<MapUnit, Boolean>(otherUnit){
            final /* synthetic */ MapUnit $otherUnit;
            {
                this.$otherUnit = $otherUnit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MapUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isTransported() && this.$otherUnit.isTransportTypeOf(it);
            }
        }));
        otherUnit.removeFromTile();
        for (MapUnit payload : theirPayload2) {
            payload.removeFromTile();
        }
        UnitMovement.moveToTile$default(this.unit.getMovement(), destination2, false, 2, null);
        this.unit.removeFromTile();
        for (MapUnit payload : ourPayload2) {
            payload.removeFromTile();
        }
        otherUnit.putInTile(theirOldPosition);
        for (MapUnit payload : theirPayload2) {
            payload.putInTile(theirOldPosition);
            payload.setTransported(true);
        }
        UnitMovement.moveToTile$default(otherUnit.getMovement(), ourOldPosition, false, 2, null);
        this.unit.putInTile(theirOldPosition);
        for (MapUnit payload : ourPayload2) {
            payload.putInTile(theirOldPosition);
            payload.setTransported(true);
        }
        otherUnit.setMostRecentMoveType(UnitMovementMemoryType.UnitMoved);
        this.unit.setMostRecentMoveType(UnitMovementMemoryType.UnitMoved);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCityCenterCannotEnter(Tile tile) {
        if (!tile.isCityCenter()) return false;
        if (Intrinsics.areEqual(tile.getOwner(), this.unit.getCiv())) return false;
        City city2 = tile.getCity();
        Intrinsics.checkNotNull(city2);
        if (city2.getHasJustBeenConquered()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canMoveTo(@NotNull Tile tile, boolean assumeCanPassThrough, boolean allowSwap, boolean includeOtherEscortUnit) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (this.unit.getBaseUnit().getMovesLikeAirUnits()) {
            return this.canAirUnitMoveTo(tile, this.unit);
        }
        if (!assumeCanPassThrough && !UnitMovement.canPassThrough$default(this, tile, false, 2, null)) {
            return false;
        }
        if (this.isCityCenterCannotEnter(tile)) {
            return false;
        }
        if (includeOtherEscortUnit && this.unit.isEscorting()) {
            MapUnit mapUnit = this.unit.getOtherEscortUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (!mapUnit.getMovement().canMoveTo(tile, assumeCanPassThrough, allowSwap, false)) {
                return false;
            }
        }
        if (this.unit.isCivilian()) {
            if (tile.getCivilianUnit() != null) {
                if (!allowSwap) return false;
                MapUnit mapUnit = tile.getCivilianUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (!Intrinsics.areEqual(mapUnit.getOwner(), this.unit.getOwner())) return false;
            }
            if (tile.getMilitaryUnit() == null) return true;
            MapUnit mapUnit = tile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (!Intrinsics.areEqual(mapUnit.getOwner(), this.unit.getOwner())) return false;
            return true;
        }
        if (tile.getMilitaryUnit() != null) {
            if (!allowSwap) return false;
            MapUnit mapUnit = tile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (!Intrinsics.areEqual(mapUnit.getOwner(), this.unit.getOwner())) return false;
        }
        if (tile.getCivilianUnit() == null) return true;
        MapUnit mapUnit = tile.getCivilianUnit();
        Intrinsics.checkNotNull(mapUnit);
        if (Intrinsics.areEqual(mapUnit.getOwner(), this.unit.getOwner())) return true;
        Civilization civilization = this.unit.getCiv();
        MapUnit mapUnit2 = tile.getCivilianUnit();
        Intrinsics.checkNotNull(mapUnit2);
        if (!civilization.isAtWarWith(mapUnit2.getCiv())) return false;
        return true;
    }

    public static /* synthetic */ boolean canMoveTo$default(UnitMovement unitMovement, Tile tile, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return unitMovement.canMoveTo(tile, bl, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canAirUnitMoveTo(Tile tile, MapUnit unit) {
        if (tile.isCityCenter()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = tile.getAirUnits();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MapUnit it = (MapUnit)element$iv$iv;
                boolean bl = false;
                if (!(!it.isTransported())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int n = ((List)destination$iv$iv).size();
            City city2 = tile.getCity();
            Intrinsics.checkNotNull(city2);
            if (n < city2.getMaxAirUnits()) {
                City city3 = tile.getCity();
                if (Intrinsics.areEqual(city3 != null ? city3.getCiv() : null, unit.getCiv())) {
                    return true;
                }
            }
        }
        if (tile.getMilitaryUnit() != null) {
            MapUnit mapUnit = tile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit);
            MapUnit unitAtDestination = mapUnit;
            return unitAtDestination.canTransport(unit);
        }
        return false;
    }

    private final boolean canParadropOn(Tile destination2) {
        if (this.unit.getCache().getCannotMove()) {
            return false;
        }
        return destination2.isLand() && !destination2.isImpassible() && this.unit.getCiv().getViewableTiles().contains(destination2);
    }

    public final boolean canPassThrough(@NotNull Tile tile, boolean includeOtherEscortUnit) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!(!tile.isImpassible() || this.unit.getCache().getCanPassThroughImpassableTiles() || this.unit.getCache().getCanEnterIceTiles() && tile.getTerrainFeatures().contains("Ice") || this.unit.getCiv().getPassThroughImpassableUnlocked() && this.unit.getCiv().getPassableImpassables().contains(tile.getLastTerrain().getName()))) {
            return false;
        }
        if (tile.isLand() && this.unit.getBaseUnit().isWaterUnit() && !tile.isCityCenter()) {
            return false;
        }
        Lazy<Boolean> unitSpecificAllowOcean$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
            final /* synthetic */ UnitMovement this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                if (this.this$0.getUnit().getCiv().getTech().getSpecificUnitsCanEnterOcean()) {
                    boolean bl2;
                    block3: {
                        void $this$any$iv;
                        Sequence sequence = Civilization.getMatchingUniques$default(this.this$0.getUnit().getCiv(), UniqueType.UnitsMayEnterOcean, null, 2, null);
                        UnitMovement unitMovement = this.this$0;
                        boolean $i$f$any = false;
                        for (T element$iv : $this$any$iv) {
                            Unique it = (Unique)element$iv;
                            boolean bl3 = false;
                            if (!MapUnit.matchesFilter$default(unitMovement.getUnit(), it.getParams().get(0), false, 2, null)) continue;
                            bl2 = true;
                            break block3;
                        }
                        bl2 = false;
                    }
                    if (bl2) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        });
        if (tile.isWater() && this.unit.getBaseUnit().isLandUnit() && !this.unit.getCache().getCanMoveOnWater()) {
            if (!this.unit.getCiv().getTech().getUnitsCanEmbark()) {
                return false;
            }
            if (this.unit.getCache().getCannotEmbark()) {
                return false;
            }
            if (tile.isOcean() && !this.unit.getCiv().getTech().getEmbarkedUnitsCanEnterOcean() && !UnitMovement.canPassThrough$lambda$19(unitSpecificAllowOcean$delegate)) {
                return false;
            }
        }
        if (tile.isOcean() && !this.unit.getCiv().getTech().getAllUnitsCanEnterOcean() && !UnitMovement.canPassThrough$lambda$19(unitSpecificAllowOcean$delegate) && this.unit.getCache().getCannotEnterOceanTiles()) {
            return false;
        }
        if (this.unit.getCache().getCanEnterCityStates()) {
            Civilization civilization = tile.getOwner();
            boolean bl = civilization != null ? civilization.isCityState() : false;
            if (bl) {
                return true;
            }
        }
        if (!this.unit.getCache().getCanEnterForeignTerrain() && !tile.canCivPassThrough(this.unit.getCiv())) {
            return false;
        }
        MapUnit firstUnit = tile.getFirstUnit();
        if (firstUnit != null && !Intrinsics.areEqual(this.unit.getCiv(), firstUnit.getCiv())) {
            if ((!this.unit.getBaseUnit().isLandUnit() || !tile.isWater() || this.unit.getCache().getCanMoveOnWater()) && firstUnit.isCivilian() && this.unit.getCiv().isAtWarWith(firstUnit.getCiv())) {
                return true;
            }
            if (this.unit.getCiv().isAtWarWith(firstUnit.getCiv())) {
                return false;
            }
        }
        if (includeOtherEscortUnit && this.unit.isEscorting()) {
            MapUnit mapUnit = this.unit.getOtherEscortUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (!mapUnit.getMovement().canPassThrough(tile, false)) {
                return false;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean canPassThrough$default(UnitMovement unitMovement, Tile tile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return unitMovement.canPassThrough(tile, bl);
    }

    @NotNull
    public final PathsToTilesWithinTurn getDistanceToTiles(boolean considerZoneOfControl, @NotNull HashMap<Tile, Boolean> passThroughCache, @NotNull HashMap<Pair<Tile, Tile>, Float> movementCostCache, boolean includeOtherEscortUnit) {
        Intrinsics.checkNotNullParameter(passThroughCache, "passThroughCache");
        Intrinsics.checkNotNullParameter(movementCostCache, "movementCostCache");
        PathsToTilesWithinTurn distanceToTiles = this.getMovementToTilesAtPosition(this.unit.getCurrentTile().getPosition(), this.unit.getCurrentMovement(), considerZoneOfControl, null, passThroughCache, movementCostCache, includeOtherEscortUnit);
        this.pathfindingCache.setDistanceToTiles(considerZoneOfControl, distanceToTiles);
        return distanceToTiles;
    }

    public static /* synthetic */ PathsToTilesWithinTurn getDistanceToTiles$default(UnitMovement unitMovement, boolean bl, HashMap hashMap, HashMap hashMap2, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            hashMap = new HashMap<Tile, Boolean>();
        }
        if ((n & 4) != 0) {
            hashMap2 = new HashMap<Pair<Tile, Tile>, Float>();
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return unitMovement.getDistanceToTiles(bl, hashMap, hashMap2, bl2);
    }

    @NotNull
    public final HashMap<Tile, ArrayList<Tile>> getAerialPathsToCities() {
        ArrayList<Tile> tilesToCheck = new ArrayList<Tile>();
        HashMap tilesReached = new HashMap();
        Tile startingTile = this.unit.getCurrentTile();
        tilesToCheck.add(startingTile);
        ((Map)tilesReached).put(startingTile, startingTile);
        while (!((Collection)tilesToCheck).isEmpty()) {
            ArrayList<Tile> newTilesToCheck = new ArrayList<Tile>();
            for (Tile currentTileToCheck : tilesToCheck) {
                Sequence<Tile> reachableTiles2 = SequencesKt.filter(currentTileToCheck.getTilesInDistance(this.unit.getRange()), (Function1)new Function1<Tile, Boolean>(this){
                    final /* synthetic */ UnitMovement this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Tile it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return UnitMovement.canMoveTo$default(this.this$0.getUnit().getMovement(), it, false, false, false, 14, null);
                    }
                });
                Iterator<Tile> iterator2 = reachableTiles2.iterator();
                while (iterator2.hasNext()) {
                    Tile reachableTile = iterator2.next();
                    if (tilesReached.containsKey(reachableTile)) continue;
                    Map map2 = tilesReached;
                    Intrinsics.checkNotNull(currentTileToCheck);
                    map2.put(reachableTile, currentTileToCheck);
                    newTilesToCheck.add(reachableTile);
                }
            }
            tilesToCheck = newTilesToCheck;
        }
        HashMap<Tile, ArrayList<Tile>> pathsToCities = new HashMap<Tile, ArrayList<Tile>>();
        for (Tile city2 : tilesReached.keySet()) {
            ArrayList<Tile> path = new ArrayList<Tile>();
            Intrinsics.checkNotNull(city2);
            Tile currentCity = city2;
            while (!Intrinsics.areEqual(currentCity, startingTile)) {
                path.add(currentCity);
                Object v = tilesReached.get(currentCity);
                Intrinsics.checkNotNull(v);
                currentCity = (Tile)v;
            }
            CollectionsKt.reverse((List)path);
            ((Map)pathsToCities).put(city2, path);
        }
        pathsToCities.remove(startingTile);
        return pathsToCities;
    }

    private final Set<Tile> getPathBetweenTiles(Tile from, Tile to) {
        boolean tmp = this.unit.getCache().getCanEnterForeignTerrain();
        this.unit.getCache().setCanEnterForeignTerrain(true);
        BFS bfs2 = new BFS(from, (Function1<? super Tile, Boolean>)new Function1<Tile, Boolean>(this){
            final /* synthetic */ UnitMovement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return UnitMovement.canPassThrough$default(this.this$0, it, false, 2, null);
            }
        });
        bfs2.stepUntilDestination(to);
        this.unit.getCache().setCanEnterForeignTerrain(tmp);
        return bfs2.getReachedTiles();
    }

    public final void clearPathfindingCache() {
        this.pathfindingCache.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getShortestPath$isUnfriendlyCityState(UnitMovement this$0, Tile tile) {
        Civilization it = tile.getOwner();
        boolean bl = false;
        if (it == null) return false;
        if (!it.isCityState()) return false;
        DiplomacyManager diplomacyManager = it.getDiplomacyManager(this$0.unit.getCiv());
        if (diplomacyManager == null) return false;
        if (!diplomacyManager.isRelationshipLevelLT(RelationshipLevel.Friend)) return false;
        return true;
    }

    private static final boolean canPassThrough$lambda$19(Lazy<Boolean> $unitSpecificAllowOcean$delegate) {
        Lazy<Boolean> lazy = $unitSpecificAllowOcean$delegate;
        return lazy.getValue();
    }

    public static final /* synthetic */ boolean access$getShortestPath$isUnfriendlyCityState(UnitMovement this$0, Tile tile) {
        return UnitMovement.getShortestPath$isUnfriendlyCityState(this$0, tile);
    }

    public static final /* synthetic */ boolean access$canParadropOn(UnitMovement $this, Tile destination2) {
        return $this.canParadropOn(destination2);
    }

    public static final /* synthetic */ boolean access$canUnitSwapToReachableTile(UnitMovement $this, Tile reachableTile) {
        return $this.canUnitSwapToReachableTile(reachableTile);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/unciv/logic/map/mapunit/movement/UnitMovement$ParentTileAndTotalMovement;", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "parentTile", "totalMovement", "", "(Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/logic/map/tile/Tile;F)V", "getParentTile", "()Lcom/unciv/logic/map/tile/Tile;", "getTile", "getTotalMovement", "()F", "core"})
    public static final class ParentTileAndTotalMovement {
        @NotNull
        private final Tile tile;
        @NotNull
        private final Tile parentTile;
        private final float totalMovement;

        public ParentTileAndTotalMovement(@NotNull Tile tile, @NotNull Tile parentTile, float totalMovement) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            Intrinsics.checkNotNullParameter(parentTile, "parentTile");
            this.tile = tile;
            this.parentTile = parentTile;
            this.totalMovement = totalMovement;
        }

        @NotNull
        public final Tile getTile() {
            return this.tile;
        }

        @NotNull
        public final Tile getParentTile() {
            return this.parentTile;
        }

        public final float getTotalMovement() {
            return this.totalMovement;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/map/mapunit/movement/UnitMovement$UnreachableDestinationException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "(Ljava/lang/String;)V", "core"})
    public static final class UnreachableDestinationException
    extends Exception {
        public UnreachableDestinationException(@NotNull String msg) {
            Intrinsics.checkNotNullParameter(msg, "msg");
            super(msg);
        }
    }
}

