/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.tile;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileStatFunctionsKt;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.NamedStats;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J@\u0010\u0015\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\u00170\u0016j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\u0017`\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J6\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u000eJ8\u0010!\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\u00170\u0016j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\u0017`\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ.\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u000e0#2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010%\u001a\u00020\u001fJ\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000eJ\u0010\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u000eH\u0002J$\u0010+\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010,\u001a\u00020\u001fJ\u001a\u0010+\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010,\u001a\u00020\u001fJ6\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\u00170.2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010,\u001a\u00020\u001fJ\u0018\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000eH\u0002R\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00062"}, d2={"Lcom/unciv/logic/map/tile/TileStatFunctions;", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "(Lcom/unciv/logic/map/tile/Tile;)V", "riverTerrain", "Lcom/unciv/models/ruleset/tile/Terrain;", "getRiverTerrain", "()Lcom/unciv/models/ruleset/tile/Terrain;", "riverTerrain$delegate", "Lkotlin/Lazy;", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "getExtraImprovementStats", "Lcom/unciv/models/stats/Stats;", "improvement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "observingCiv", "Lcom/unciv/logic/civilization/Civilization;", "city", "Lcom/unciv/logic/city/City;", "getSingleTerrainStats", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "", "Lkotlin/collections/ArrayList;", "terrain", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "getStatDiffForImprovement", "cityUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "currentTileStats", "getTerrainStatsBreakdown", "getTilePercentageStats", "Ljava/util/EnumMap;", "Lcom/unciv/logic/map/tile/TileStatFunctions$TilePercentageCategory;", "uniqueCache", "getTileStartScore", "", "cityCenterMinStats", "getTileStartYield", "minimumStats", "getTileStats", "localUniqueCache", "getTileStatsBreakdown", "", "missingFromMinimum", "current", "TilePercentageCategory", "core"})
@SourceDebugExtension(value={"SMAP\nTileStatFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileStatFunctions.kt\ncom/unciv/logic/map/tile/TileStatFunctions\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n1247#2,2:337\n1247#2,2:346\n1247#2,2:348\n1268#2,3:350\n766#3:339\n857#3,2:340\n1549#3:342\n1620#3,3:343\n*S KotlinDebug\n*F\n+ 1 TileStatFunctions.kt\ncom/unciv/logic/map/tile/TileStatFunctions\n*L\n60#1:337,2\n258#1:346,2\n262#1:348,2\n317#1:350,3\n134#1:339\n134#1:340,2\n134#1:342\n134#1:343,3\n*E\n"})
public final class TileStatFunctions {
    @NotNull
    private final Tile tile;
    @NotNull
    private final Lazy riverTerrain$delegate;

    public TileStatFunctions(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        this.tile = tile;
        this.riverTerrain$delegate = LazyKt.lazy((Function0)new Function0<Terrain>(this){
            final /* synthetic */ TileStatFunctions this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Terrain invoke() {
                return this.this$0.getTile().getRuleset().getTerrains().get("River");
            }
        });
    }

    @NotNull
    public final Tile getTile() {
        return this.tile;
    }

    private final Terrain getRiverTerrain() {
        Lazy lazy = this.riverTerrain$delegate;
        return (Terrain)lazy.getValue();
    }

    @NotNull
    public final Stats getTileStats(@Nullable Civilization observingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        return this.getTileStats(this.tile.getCity(), observingCiv, localUniqueCache);
    }

    public static /* synthetic */ Stats getTileStats$default(TileStatFunctions tileStatFunctions, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 2) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return tileStatFunctions.getTileStats(civilization, localUniqueCache);
    }

    @NotNull
    public final Stats getTileStats(@Nullable City city2, @Nullable Civilization observingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        List<Pair<String, Stats>> statsBreakdown = this.getTileStatsBreakdown(city2, observingCiv, localUniqueCache);
        String improvement2 = this.tile.getUnpillagedImprovement();
        RoadStatus road = this.tile.getUnpillagedRoad();
        EnumMap<TilePercentageCategory, Stats> percentageStats = this.getTilePercentageStats(observingCiv, city2, localUniqueCache);
        for (Pair<String, Stats> stats2 : statsBreakdown) {
            String string = stats2.getFirst();
            TilePercentageCategory tileType = Intrinsics.areEqual(string, improvement2) ? TilePercentageCategory.Improvement : (Intrinsics.areEqual(string, road.name()) ? TilePercentageCategory.Road : TilePercentageCategory.Terrain);
            Stats stats3 = percentageStats.get((Object)tileType);
            Intrinsics.checkNotNull(stats3);
            for (Stats.StatValuePair statValuePair : stats3) {
                Stat stat = statValuePair.component1();
                float value = statValuePair.component2();
                Stats stats4 = stats2.getSecond();
                stats4.set(stat, stats4.get(stat) * FormattingExtensionsKt.toPercent(value));
            }
        }
        return TileStatFunctionsKt.toStats(statsBreakdown);
    }

    public static /* synthetic */ Stats getTileStats$default(TileStatFunctions tileStatFunctions, City city2, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 4) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return tileStatFunctions.getTileStats(city2, civilization, localUniqueCache);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, Stats>> getTileStatsBreakdown(@Nullable City city2, @Nullable Civilization observingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair it;
        void $this$filterTo$iv$iv;
        Stats minimumStats;
        Object unique;
        Stats roadStats;
        TileImprovement road;
        Stats stats2;
        Stats improvementStats;
        TileImprovement improvement2;
        Stats stats3;
        boolean otherYieldsIgnored;
        ArrayList<Pair<String, Stats>> listOfStats;
        StateForConditionals stateForConditionals;
        block20: {
            boolean bl;
            Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
            stateForConditionals = new StateForConditionals(observingCiv, city2, null, this.tile, null, null, null, null, null, null, false, 2036, null);
            listOfStats = this.getTerrainStatsBreakdown(stateForConditionals);
            Sequence<Terrain> $this$any$iv = this.tile.getAllTerrains();
            boolean $i$f$any = false;
            Iterator<Terrain> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Terrain element$iv;
                Terrain it2 = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!it2.hasUnique(UniqueType.NullifyYields, stateForConditionals)) continue;
                bl = true;
                break block20;
            }
            bl = otherYieldsIgnored = false;
        }
        if ((stats3 = (improvement2 = otherYieldsIgnored ? null : this.tile.getUnpillagedTileImprovement())) == null || (stats3 = ((NamedStats)stats3).cloneStats()) == null) {
            stats3 = improvementStats = Stats.Companion.getZERO();
        }
        if ((stats2 = (road = otherYieldsIgnored ? null : this.tile.getUnpillagedRoadImprovement())) == null || (stats2 = ((NamedStats)stats2).cloneStats()) == null) {
            stats2 = roadStats = Stats.Companion.getZERO();
        }
        if (city2 != null) {
            Sequence<Unique> statsFromTilesUniques2 = SequencesKt.filter(localUniqueCache.forCityGetMatchingUniques(city2, UniqueType.StatsFromTiles, stateForConditionals), (Function1)new Function1<Unique, Boolean>(city2){
                final /* synthetic */ City $city;
                {
                    this.$city = $city;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Unique it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return City.matchesFilter$default(this.$city, it.getParams().get(2), null, false, 6, null);
                }
            });
            Sequence<Unique> statsFromObjectsUniques = localUniqueCache.forCityGetMatchingUniques(city2, UniqueType.StatsFromObject, stateForConditionals);
            Sequence<Unique> statsFromTilesWithoutUniques2 = SequencesKt.filter(localUniqueCache.forCityGetMatchingUniques(city2, UniqueType.StatsFromTilesWithout, stateForConditionals), (Function1)new Function1<Unique, Boolean>(city2, this){
                final /* synthetic */ City $city;
                final /* synthetic */ TileStatFunctions this$0;
                {
                    this.$city = $city;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Unique it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return City.matchesFilter$default(this.$city, it.getParams().get(3), null, false, 6, null) && !Tile.matchesFilter$default(this.this$0.getTile(), it.getParams().get(2), null, 2, null);
                }
            });
            Iterator<Unique> iterator3 = SequencesKt.plus(SequencesKt.plus(statsFromTilesUniques2, statsFromObjectsUniques), statsFromTilesWithoutUniques2).iterator();
            while (iterator3.hasNext()) {
                unique = iterator3.next();
                String tileType = ((Unique)unique).getParams().get(1);
                if (improvement2 != null && TileImprovement.matchesFilter$default(improvement2, tileType, stateForConditionals, false, 4, null)) {
                    improvementStats.add(((Unique)unique).getStats());
                    continue;
                }
                if (this.tile.matchesFilter(tileType, observingCiv)) {
                    listOfStats.add(TuplesKt.to('{' + ((Unique)unique).getSourceObjectName() + "} ({" + ((Unique)unique).getDisplayText() + "})", ((Unique)unique).getStats()));
                    continue;
                }
                if (road == null || !TileImprovement.matchesFilter$default(road, tileType, stateForConditionals, false, 4, null)) continue;
                roadStats.add(((Unique)unique).getStats());
            }
        }
        if (this.tile.isAdjacentToRiver()) {
            if (this.getRiverTerrain() == null) {
                listOfStats.add(TuplesKt.to("River", new Stats(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 123, null)));
            } else {
                Collection collection = listOfStats;
                Terrain terrain2 = this.getRiverTerrain();
                Intrinsics.checkNotNull(terrain2);
                CollectionsKt.addAll(collection, (Iterable)this.getSingleTerrainStats(terrain2, stateForConditionals));
            }
        }
        Stats stats4 = minimumStats = this.tile.isCityCenter() ? Stats.Companion.getDefaultCityCenterMinimum() : Stats.Companion.getZERO();
        if (observingCiv != null) {
            Unique ensureMinUnique;
            if (this.tile.hasViewableResource(observingCiv)) {
                listOfStats.add(TuplesKt.to(this.tile.getTileResource().getName(), this.tile.getTileResource()));
            }
            if (improvement2 != null) {
                improvementStats.add(this.getExtraImprovementStats(improvement2, observingCiv, city2));
            }
            if (road != null) {
                roadStats.add(this.getExtraImprovementStats(road, observingCiv, city2));
            }
            if (improvement2 != null && (ensureMinUnique = SequencesKt.firstOrNull(improvement2.getMatchingUniques(UniqueType.EnsureMinimumStats, stateForConditionals))) != null) {
                minimumStats = ensureMinUnique.getStats();
            }
        }
        if (road != null) {
            listOfStats.add(TuplesKt.to(road.getName(), roadStats));
        }
        if (improvement2 != null) {
            listOfStats.add(TuplesKt.to(improvement2.getName(), improvementStats));
        }
        Stats statsFromMinimum = this.missingFromMinimum(TileStatFunctionsKt.toStats((List<? extends Pair<String, ? extends Stats>>)listOfStats), minimumStats);
        listOfStats.add(TuplesKt.to("Minimum", statsFromMinimum));
        if (observingCiv != null && !(TileStatFunctionsKt.toStats((List<? extends Pair<String, ? extends Stats>>)listOfStats).getGold() == 0.0f) && observingCiv.getGoldenAges().isGoldenAge()) {
            listOfStats.add(TuplesKt.to("Golden Age", new Stats(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 123, null)));
        }
        Iterable $this$filter$iv = listOfStats;
        boolean $i$f$filter = false;
        unique = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!((Stats)it.getSecond()).isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getFirst(), ((Stats)it.getSecond()).clone()));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getTileStatsBreakdown$default(TileStatFunctions tileStatFunctions, City city2, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 4) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return tileStatFunctions.getTileStatsBreakdown(city2, civilization, localUniqueCache);
    }

    private final Stats missingFromMinimum(Stats current, Stats minimumStats) {
        Stats missingStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        for (Stat stat : Stat.getEntries()) {
            if (!(current.get(stat) < minimumStats.get(stat))) continue;
            missingStats.set(stat, minimumStats.get(stat) - current.get(stat));
        }
        return missingStats;
    }

    private final ArrayList<Pair<String, Stats>> getSingleTerrainStats(Terrain terrain2, StateForConditionals stateForConditionals) {
        Object object = new Pair[1];
        String string = terrain2.getName();
        Intrinsics.checkNotNull(terrain2, "null cannot be cast to non-null type com.unciv.models.stats.Stats");
        object[0] = TuplesKt.to(string, (Stats)terrain2);
        ArrayList<Pair<String, Stats>> list2 = CollectionsKt.arrayListOf(object);
        object = terrain2.getMatchingUniques(UniqueType.Stats, stateForConditionals).iterator();
        while (object.hasNext()) {
            Unique unique = (Unique)object.next();
            list2.add(TuplesKt.to(terrain2.getName() + ": " + unique.getDisplayText(), unique.getStats()));
        }
        return list2;
    }

    @NotNull
    public final ArrayList<Pair<String, Stats>> getTerrainStatsBreakdown(@NotNull StateForConditionals stateForConditionals) {
        Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
        ArrayList<Pair<String, Stats>> list2 = new ArrayList<Pair<String, Stats>>();
        Iterator<Terrain> iterator2 = this.tile.getAllTerrains().iterator();
        while (iterator2.hasNext()) {
            Terrain terrain2 = iterator2.next();
            ArrayList<Pair<String, Stats>> terrainStats = this.getSingleTerrainStats(terrain2, stateForConditionals);
            if (terrain2.hasUnique(UniqueType.NullifyYields, stateForConditionals)) {
                return terrainStats;
            }
            if (terrain2.getOverrideStats()) {
                list2 = terrainStats;
                continue;
            }
            CollectionsKt.addAll((Collection)list2, (Iterable)terrainStats);
        }
        return list2;
    }

    public static /* synthetic */ ArrayList getTerrainStatsBreakdown$default(TileStatFunctions tileStatFunctions, StateForConditionals stateForConditionals, int n, Object object) {
        if ((n & 1) != 0) {
            stateForConditionals = new StateForConditionals(null, null, null, null, null, null, null, null, null, null, false, 2047, null);
        }
        return tileStatFunctions.getTerrainStatsBreakdown(stateForConditionals);
    }

    @NotNull
    public final EnumMap<TilePercentageCategory, Stats> getTilePercentageStats(@Nullable Civilization observingCiv, @Nullable City city2, @NotNull LocalUniqueCache uniqueCache) {
        EnumMap<TilePercentageCategory, Stats> enumMap;
        Object cachedAllStatPercentFromObjectCityUniques;
        Intrinsics.checkNotNullParameter(uniqueCache, "uniqueCache");
        Stats terrainStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        StateForConditionals stateForConditionals = new StateForConditionals(observingCiv, city2, null, this.tile, null, null, null, null, null, null, false, 2036, null);
        TileImprovement improvement2 = this.tile.getUnpillagedTileImprovement();
        Stats improvementStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        TileImprovement road = this.tile.getUnpillagedRoadImprovement();
        Stats roadStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        if (city2 != null) {
            Object unique;
            Sequence<Unique> cachedStatPercentFromObjectCityUniques = uniqueCache.forCityGetMatchingUniques(city2, UniqueType.StatPercentFromObject, stateForConditionals);
            Iterator<Unique> iterator2 = cachedStatPercentFromObjectCityUniques.iterator();
            while (iterator2.hasNext()) {
                unique = iterator2.next();
                TileStatFunctions.getTilePercentageStats$addStats(improvement2, stateForConditionals, improvementStats, this, observingCiv, terrainStats, road, roadStats, ((Unique)unique).getParams().get(2), Stat.valueOf(((Unique)unique).getParams().get(1)), Float.parseFloat(((Unique)unique).getParams().get(0)));
            }
            cachedAllStatPercentFromObjectCityUniques = uniqueCache.forCityGetMatchingUniques(city2, UniqueType.AllStatsPercentFromObject, stateForConditionals);
            unique = cachedAllStatPercentFromObjectCityUniques.iterator();
            while (unique.hasNext()) {
                Unique unique2 = (Unique)unique.next();
                for (Stat stat : Stat.getEntries()) {
                    TileStatFunctions.getTilePercentageStats$addStats(improvement2, stateForConditionals, improvementStats, this, observingCiv, terrainStats, road, roadStats, unique2.getParams().get(1), stat, Float.parseFloat(unique2.getParams().get(0)));
                }
            }
        } else if (observingCiv != null) {
            Object unique;
            Sequence<Unique> cachedStatPercentFromObjectCivUniques = uniqueCache.forCivGetMatchingUniques(observingCiv, UniqueType.StatPercentFromObject, stateForConditionals);
            cachedAllStatPercentFromObjectCityUniques = cachedStatPercentFromObjectCivUniques.iterator();
            while (cachedAllStatPercentFromObjectCityUniques.hasNext()) {
                unique = cachedAllStatPercentFromObjectCityUniques.next();
                TileStatFunctions.getTilePercentageStats$addStats(improvement2, stateForConditionals, improvementStats, this, observingCiv, terrainStats, road, roadStats, ((Unique)unique).getParams().get(2), Stat.valueOf(((Unique)unique).getParams().get(1)), Float.parseFloat(((Unique)unique).getParams().get(0)));
            }
            Sequence<Unique> cachedAllStatPercentFromObjectCivUniques = uniqueCache.forCivGetMatchingUniques(observingCiv, UniqueType.AllStatsPercentFromObject, stateForConditionals);
            unique = cachedAllStatPercentFromObjectCivUniques.iterator();
            while (unique.hasNext()) {
                Unique unique3 = (Unique)unique.next();
                for (Stat stat : Stat.getEntries()) {
                    TileStatFunctions.getTilePercentageStats$addStats(improvement2, stateForConditionals, improvementStats, this, observingCiv, terrainStats, road, roadStats, unique3.getParams().get(1), stat, Float.parseFloat(unique3.getParams().get(0)));
                }
            }
        }
        EnumMap<TilePercentageCategory, Stats> $this$getTilePercentageStats_u24lambda_u243 = enumMap = new EnumMap<TilePercentageCategory, Stats>(TilePercentageCategory.class);
        boolean bl = false;
        $this$getTilePercentageStats_u24lambda_u243.put((TilePercentageCategory)((Enum)TilePercentageCategory.Terrain), terrainStats);
        $this$getTilePercentageStats_u24lambda_u243.put((TilePercentageCategory)((Enum)TilePercentageCategory.Improvement), improvementStats);
        $this$getTilePercentageStats_u24lambda_u243.put((TilePercentageCategory)((Enum)TilePercentageCategory.Road), roadStats);
        return enumMap;
    }

    public final float getTileStartScore(@NotNull Stats cityCenterMinStats2) {
        boolean bl;
        Tile it;
        Tile element$iv;
        Iterator<Tile> iterator2;
        boolean $i$f$any;
        Sequence<Tile> $this$any$iv;
        float sum;
        block9: {
            Intrinsics.checkNotNullParameter(cityCenterMinStats2, "cityCenterMinStats");
            sum = 0.0f;
            Iterator<Tile> iterator3 = this.tile.getTilesInDistance(2).iterator();
            while (iterator3.hasNext()) {
                Tile closeTile = iterator3.next();
                float tileYield = closeTile.getStats().getTileStartYield(Intrinsics.areEqual(closeTile, this.tile) ? cityCenterMinStats2 : Stats.Companion.getZERO());
                sum += tileYield;
                if (!SequencesKt.contains(this.tile.getNeighbors(), closeTile)) continue;
                sum += tileYield;
            }
            if (this.tile.isHill()) {
                sum -= 2.0f;
            }
            if (this.tile.isAdjacentToRiver()) {
                sum += 2.0f;
            }
            $this$any$iv = this.tile.getNeighbors();
            $i$f$any = false;
            iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getBaseTerrain(), "Mountain")) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            sum += 2.0f;
        }
        if (this.tile.isCoastalTile()) {
            sum += 3.0f;
        }
        if (!this.tile.isCoastalTile()) {
            boolean bl3;
            block10: {
                $this$any$iv = this.tile.getNeighbors();
                $i$f$any = false;
                iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    it = element$iv = iterator2.next();
                    boolean bl4 = false;
                    if (!it.isCoastalTile()) continue;
                    bl3 = true;
                    break block10;
                }
                bl3 = false;
            }
            if (bl3) {
                sum -= 7.0f;
            }
        }
        return sum;
    }

    private final float getTileStartYield(Stats minimumStats) {
        Stats $this$getTileStartYield_u24lambda_u246 = TileStatFunctionsKt.toStats(TileStatFunctions.getTerrainStatsBreakdown$default(this, null, 1, null));
        boolean bl = false;
        if (this.tile.getResource() != null) {
            $this$getTileStartYield_u24lambda_u246.add(this.tile.getTileResource());
        }
        $this$getTileStartYield_u24lambda_u246.add(this.missingFromMinimum($this$getTileStartYield_u24lambda_u246, minimumStats));
        return $this$getTileStartYield_u24lambda_u246.getFood() + $this$getTileStartYield_u24lambda_u246.getProduction() + $this$getTileStartYield_u24lambda_u246.getGold();
    }

    @NotNull
    public final Stats getStatDiffForImprovement(@NotNull TileImprovement improvement2, @NotNull Civilization observingCiv, @Nullable City city2, @NotNull LocalUniqueCache cityUniqueCache, @Nullable Stats currentTileStats) {
        Intrinsics.checkNotNullParameter(improvement2, "improvement");
        Intrinsics.checkNotNullParameter(observingCiv, "observingCiv");
        Intrinsics.checkNotNullParameter(cityUniqueCache, "cityUniqueCache");
        Stats stats2 = currentTileStats;
        if (stats2 == null) {
            stats2 = this.getTileStats(city2, observingCiv, cityUniqueCache);
        }
        Stats currentStats = stats2;
        Tile tileClone = this.tile.clone(false);
        tileClone.setTerrainTransients();
        Tile.setImprovement$default(tileClone, improvement2.getName(), null, null, 6, null);
        Stats futureStats = tileClone.getStats().getTileStats(city2, observingCiv, cityUniqueCache);
        return futureStats.minus(currentStats);
    }

    public static /* synthetic */ Stats getStatDiffForImprovement$default(TileStatFunctions tileStatFunctions, TileImprovement tileImprovement, Civilization civilization, City city2, LocalUniqueCache localUniqueCache, Stats stats2, int n, Object object) {
        if ((n & 8) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        if ((n & 0x10) != 0) {
            stats2 = null;
        }
        return tileStatFunctions.getStatDiffForImprovement(tileImprovement, civilization, city2, localUniqueCache, stats2);
    }

    private final Stats getExtraImprovementStats(TileImprovement improvement2, Civilization observingCiv, City city2) {
        Unique unique;
        Stats stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        if (this.tile.hasViewableResource(observingCiv) && this.tile.getTileResource().isImprovedBy(improvement2.getName()) && this.tile.getTileResource().getImprovementStats() != null) {
            Stats stats3 = this.tile.getTileResource().getImprovementStats();
            Intrinsics.checkNotNull(stats3);
            stats2.add(stats3);
        }
        StateForConditionals conditionalState = new StateForConditionals(observingCiv, city2, null, this.tile, null, null, null, null, null, null, false, 2036, null);
        Iterator<Unique> iterator2 = improvement2.getMatchingUniques(UniqueType.Stats, conditionalState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            stats2.add(unique.getStats());
        }
        iterator2 = improvement2.getMatchingUniques(UniqueType.ImprovementStatsForAdjacencies, conditionalState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            String adjacent = unique.getParams().get(1);
            Sequence<Tile> $this$count$iv = this.tile.getNeighbors();
            boolean $i$f$count = false;
            int count$iv = 0;
            Iterator<Tile> iterator3 = $this$count$iv.iterator();
            while (iterator3.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator3.next();
                boolean bl = false;
                boolean bl2 = it.matchesFilter(adjacent, observingCiv) || Intrinsics.areEqual(it.getUnpillagedRoad().name(), adjacent);
                if (!bl2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            int numberOfBonuses = count$iv;
            stats2.add(unique.getStats().times((float)numberOfBonuses));
        }
        iterator2 = improvement2.getMatchingUniques(UniqueType.ImprovementStatsOnTile, conditionalState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            if (!Tile.matchesFilter$default(this.tile, unique.getParams().get(1), null, 2, null) && (!Intrinsics.areEqual(unique.getParams().get(1), "Fresh water") || !Tile.isAdjacentTo$default(this.tile, "Fresh water", null, 2, null)) && (!Intrinsics.areEqual(unique.getParams().get(1), "non-fresh water") || Tile.isAdjacentTo$default(this.tile, "Fresh water", null, 2, null))) continue;
            stats2.add(unique.getStats());
        }
        return stats2;
    }

    private static final void getTilePercentageStats$addStats(TileImprovement improvement2, StateForConditionals stateForConditionals, Stats improvementStats, TileStatFunctions this$0, Civilization $observingCiv, Stats terrainStats, TileImprovement road, Stats roadStats, String filter2, Stat stat, float amount) {
        if (improvement2 != null && TileImprovement.matchesFilter$default(improvement2, filter2, stateForConditionals, false, 4, null)) {
            improvementStats.add(stat, amount);
        } else if (this$0.tile.matchesFilter(filter2, $observingCiv)) {
            terrainStats.add(stat, amount);
        } else if (road != null && TileImprovement.matchesFilter$default(road, filter2, stateForConditionals, false, 4, null)) {
            roadStats.add(stat, amount);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/map/tile/TileStatFunctions$TilePercentageCategory;", "", "(Ljava/lang/String;I)V", "Terrain", "Improvement", "Road", "core"})
    public static final class TilePercentageCategory
    extends Enum<TilePercentageCategory> {
        public static final /* enum */ TilePercentageCategory Terrain = new TilePercentageCategory();
        public static final /* enum */ TilePercentageCategory Improvement = new TilePercentageCategory();
        public static final /* enum */ TilePercentageCategory Road = new TilePercentageCategory();
        private static final /* synthetic */ TilePercentageCategory[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TilePercentageCategory[] values() {
            return (TilePercentageCategory[])$VALUES.clone();
        }

        public static TilePercentageCategory valueOf(String value) {
            return Enum.valueOf(TilePercentageCategory.class, value);
        }

        @NotNull
        public static EnumEntries<TilePercentageCategory> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tilePercentageCategoryArray = new TilePercentageCategory[]{TilePercentageCategory.Terrain, TilePercentageCategory.Improvement, TilePercentageCategory.Road};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

