/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.event.Event;
import com.unciv.logic.event.EventBus;
import com.unciv.logic.files.UncivFiles;
import com.unciv.logic.multiplayer.MultiplayerGameNameChanged;
import com.unciv.logic.multiplayer.MultiplayerGamePreview;
import com.unciv.utils.LogKt;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0014J2\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00162\u001a\u0010\u001a\u001a\u0016\u0012\f\u0012\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001d\u0012\u0004\u0012\u00020\u000e0\u001bJ\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\nJ\u0010\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010!\u001a\u00020\u0016J\u0010\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020\u0016J\r\u0010$\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b%R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lcom/unciv/logic/multiplayer/MultiplayerFiles;", "", "()V", "files", "Lcom/unciv/logic/files/UncivFiles;", "getFiles$core", "()Lcom/unciv/logic/files/UncivFiles;", "savedGames", "", "Lcom/badlogic/gdx/files/FileHandle;", "Lcom/unciv/logic/multiplayer/MultiplayerGamePreview;", "getSavedGames$core", "()Ljava/util/Map;", "addGame", "", "fileHandle", "preview", "Lcom/unciv/logic/GameInfoPreview;", "newGame", "Lcom/unciv/logic/GameInfo;", "addGame$core", "saveFileName", "", "changeGameName", "game", "newName", "onException", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "deleteGame", "multiplayerGamePreview", "getGameByGameId", "gameId", "getGameByName", "name", "updateSavesFromFiles", "updateSavesFromFiles$core", "core"})
@SourceDebugExtension(value={"SMAP\nMultiplayerFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplayerFiles.kt\ncom/unciv/logic/multiplayer/MultiplayerFiles\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n288#2,2:91\n288#2,2:93\n*S KotlinDebug\n*F\n+ 1 MultiplayerFiles.kt\ncom/unciv/logic/multiplayer/MultiplayerFiles\n*L\n64#1:91,2\n68#1:93,2\n*E\n"})
public final class MultiplayerFiles {
    @NotNull
    private final UncivFiles files = UncivGame.Companion.getCurrent().getFiles();
    @NotNull
    private final Map<FileHandle, MultiplayerGamePreview> savedGames;

    public MultiplayerFiles() {
        Map map2 = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, "synchronizedMap(...)");
        this.savedGames = map2;
    }

    @NotNull
    public final UncivFiles getFiles$core() {
        return this.files;
    }

    @NotNull
    public final Map<FileHandle, MultiplayerGamePreview> getSavedGames$core() {
        return this.savedGames;
    }

    public final void updateSavesFromFiles$core() {
        Sequence<FileHandle> saves = this.files.getMultiplayerSaves();
        Set<FileHandle> removedSaves = SetsKt.minus(this.savedGames.keySet(), (Iterable)SequencesKt.toSet(saves));
        for (FileHandle saveFile : removedSaves) {
            this.deleteGame(saveFile);
        }
        Sequence<FileHandle> newSaves = SequencesKt.minus(saves, (Iterable)this.savedGames.keySet());
        Iterator<FileHandle> iterator2 = newSaves.iterator();
        while (iterator2.hasNext()) {
            FileHandle saveFile = iterator2.next();
            MultiplayerFiles.addGame$default(this, saveFile, null, 2, null);
        }
    }

    public final void deleteGame(@NotNull MultiplayerGamePreview multiplayerGamePreview) {
        Intrinsics.checkNotNullParameter(multiplayerGamePreview, "multiplayerGamePreview");
        this.deleteGame(multiplayerGamePreview.getFileHandle());
    }

    private final void deleteGame(FileHandle fileHandle) {
        this.files.deleteSave(fileHandle);
        MultiplayerGamePreview multiplayerGamePreview = this.savedGames.get(fileHandle);
        if (multiplayerGamePreview == null) {
            return;
        }
        MultiplayerGamePreview game = multiplayerGamePreview;
        Object[] objectArray = new Object[2];
        objectArray[0] = fileHandle.name();
        GameInfoPreview gameInfoPreview = game.getPreview();
        objectArray[1] = gameInfoPreview != null ? gameInfoPreview.getGameId() : null;
        LogKt.debug("Deleting game %s with id %s", objectArray);
        this.savedGames.remove(game.getFileHandle());
    }

    public final void addGame$core(@NotNull GameInfo newGame) {
        Intrinsics.checkNotNullParameter(newGame, "newGame");
        GameInfoPreview newGamePreview = newGame.asPreview();
        this.addGame$core(newGamePreview, newGamePreview.getGameId());
    }

    public final void addGame$core(@NotNull GameInfoPreview preview, @NotNull String saveFileName) {
        Intrinsics.checkNotNullParameter(preview, "preview");
        Intrinsics.checkNotNullParameter(saveFileName, "saveFileName");
        FileHandle fileHandle = UncivFiles.saveMultiplayerGamePreview$default(this.files, preview, saveFileName, null, 4, null);
        this.addGame(fileHandle, preview);
    }

    private final void addGame(FileHandle fileHandle, GameInfoPreview preview) {
        Object[] objectArray = new Object[]{fileHandle.name()};
        LogKt.debug("Adding game %s", objectArray);
        MultiplayerGamePreview game = new MultiplayerGamePreview(fileHandle, preview, preview != null ? Instant.now() : null);
        this.savedGames.put(fileHandle, game);
    }

    static /* synthetic */ void addGame$default(MultiplayerFiles multiplayerFiles, FileHandle fileHandle, GameInfoPreview gameInfoPreview, int n, Object object) {
        if ((n & 2) != 0) {
            gameInfoPreview = null;
        }
        multiplayerFiles.addGame(fileHandle, gameInfoPreview);
    }

    @Nullable
    public final MultiplayerGamePreview getGameByName(@NotNull String name2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(name2, "name");
            Iterable $this$firstOrNull$iv = this.savedGames.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MultiplayerGamePreview it = (MultiplayerGamePreview)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final MultiplayerGamePreview getGameByGameId(@NotNull String gameId) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter(gameId, "gameId");
            Iterable $this$firstOrNull$iv = this.savedGames.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MultiplayerGamePreview it = (MultiplayerGamePreview)element$iv;
                boolean bl = false;
                GameInfoPreview gameInfoPreview = it.getPreview();
                if (!Intrinsics.areEqual(gameInfoPreview != null ? gameInfoPreview.getGameId() : null, gameId)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    public final void changeGameName(@NotNull MultiplayerGamePreview game, @NotNull String newName, @NotNull Function1<? super Exception, Unit> onException) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(newName, "newName");
        Intrinsics.checkNotNullParameter(onException, "onException");
        Object[] objectArray = new Object[]{game.getName(), newName};
        LogKt.debug("Changing name of game %s to", objectArray);
        GameInfoPreview gameInfoPreview = game.getPreview();
        if (gameInfoPreview == null) {
            Throwable throwable = game.getError();
            Intrinsics.checkNotNull(throwable);
            throw throwable;
        }
        GameInfoPreview oldPreview = gameInfoPreview;
        Instant oldLastUpdate = game.getLastUpdate();
        String oldName = game.getName();
        FileHandle newFileHandle = this.files.saveMultiplayerGamePreview(oldPreview, newName, onException);
        MultiplayerGamePreview newGame = new MultiplayerGamePreview(newFileHandle, oldPreview, oldLastUpdate);
        this.savedGames.put(newFileHandle, newGame);
        this.savedGames.remove(game.getFileHandle());
        this.files.deleteSave(game.getFileHandle());
        Intrinsics.checkNotNull(oldName);
        EventBus.INSTANCE.send((Event)new MultiplayerGameNameChanged(oldName, newName));
    }
}

