/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.simulation;

import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameStarter;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.simulation.MutableInt;
import com.unciv.logic.simulation.Simulation;
import com.unciv.logic.simulation.SimulationStep;
import com.unciv.models.metadata.GameSetupInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.ExperimentalTime;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\b\u0007\u0018\u00002\u00020\u0001:\u0001EB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nJ\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020$2\b\b\u0002\u00105\u001a\u00020\u0005J(\u00106\u001a\u0002072\u0006\u00108\u001a\u0002072\u0006\u00109\u001a\u0002072\u0006\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020\u0011H\u0002J\u0010\u0010<\u001a\u0002072\u0006\u0010=\u001a\u000207H\u0002J\u0006\u0010>\u001a\u000203J\u0010\u0010?\u001a\u0002072\u0006\u0010@\u001a\u000207H\u0002J\u0006\u0010A\u001a\u000203J\u0006\u0010B\u001a\u000203J\u0006\u0010C\u001a\u00020\u0011J\u0010\u0010D\u001a\u0002032\b\b\u0002\u00105\u001a\u00020\u0005R\u0016\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020$0#j\b\u0012\u0004\u0012\u00020$`%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u00b3\u0001\u0010*\u001a\u00a6\u0001\u0012\u0004\u0012\u00020\u0011\u0012H\u0012F\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00180+0+j*\u0012\u0004\u0012\u00020\u0005\u0012 \u0012\u001e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00180+j\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u0018`-`-0+jR\u0012\u0004\u0012\u00020\u0011\u0012H\u0012F\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00180+0+j*\u0012\u0004\u0012\u00020\u0005\u0012 \u0012\u001e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00180+j\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u0018`-`-`-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\u00020\fX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010/\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000RB\u00100\u001a6\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u00170+j\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0017`-X\u0082\u000e\u00a2\u0006\u0002\n\u0000RB\u00101\u001a6\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u00170+j\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0017`-X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006F"}, d2={"Lcom/unciv/logic/simulation/Simulation;", "", "newGameInfo", "Lcom/unciv/logic/GameInfo;", "simulationsPerThread", "", "threadsNumber", "maxTurns", "statTurns", "", "(Lcom/unciv/logic/GameInfo;IIILjava/util/List;)V", "avgDuration", "Lkotlin/time/Duration;", "J", "avgSpeed", "", "civilizations", "", "getCivilizations", "()Ljava/util/List;", "majorCivs", "maxSimulations", "numWins", "", "Lcom/unciv/logic/simulation/MutableInt;", "getNumWins", "()Ljava/util/Map;", "setNumWins", "(Ljava/util/Map;)V", "getSimulationsPerThread", "()I", "startTime", "", "stepCounter", "steps", "Ljava/util/ArrayList;", "Lcom/unciv/logic/simulation/SimulationStep;", "Lkotlin/collections/ArrayList;", "getSteps", "()Ljava/util/ArrayList;", "setSteps", "(Ljava/util/ArrayList;)V", "summaryStats", "Ljava/util/HashMap;", "Lcom/unciv/logic/simulation/Simulation$Stat;", "Lkotlin/collections/HashMap;", "totalDuration", "totalTurns", "winRateByVictory", "winTurnByVictory", "add", "", "step", "threadId", "binomialTest", "", "successes", "trials", "p", "alternative", "erf", "x", "getStats", "normalCdf", "z", "print", "start", "text", "updateCounter", "Stat", "core"})
@ExperimentalTime
@SourceDebugExtension(value={"SMAP\nSimulation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Simulation.kt\ncom/unciv/logic/simulation/Simulation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n766#2:243\n857#2,2:244\n1549#2:246\n1620#2,3:247\n766#2:250\n857#2,2:251\n766#2:253\n857#2,2:254\n1855#2,2:284\n1855#2,2:292\n1855#2,2:300\n1855#2:308\n1855#2,2:309\n1856#2:311\n1855#2,2:312\n372#3,7:256\n372#3,7:263\n372#3,7:270\n372#3,7:277\n76#4:286\n96#4,5:287\n76#4:294\n96#4,5:295\n76#4:302\n96#4,5:303\n1#5:314\n*S KotlinDebug\n*F\n+ 1 Simulation.kt\ncom/unciv/logic/simulation/Simulation\n*L\n27#1:243\n27#1:244,2\n27#1:246\n27#1:247,3\n28#1:250\n28#1:251,2\n28#1:253\n28#1:254,2\n131#1:284,2\n132#1:292,2\n133#1:300,2\n134#1:308\n135#1:309,2\n134#1:311\n137#1:312,2\n50#1:256,7\n51#1:263,7\n54#1:270,7\n55#1:277,7\n132#1:286\n132#1:287,5\n133#1:294\n133#1:295,5\n134#1:302\n134#1:303,5\n*E\n"})
public final class Simulation {
    @NotNull
    private final GameInfo newGameInfo;
    private final int simulationsPerThread;
    private final int threadsNumber;
    private final int maxTurns;
    @NotNull
    private final List<Integer> statTurns;
    private final int maxSimulations;
    @NotNull
    private final List<String> civilizations;
    private final int majorCivs;
    private long startTime;
    @NotNull
    private ArrayList<SimulationStep> steps;
    @NotNull
    private Map<String, MutableInt> numWins;
    @NotNull
    private HashMap<String, HashMap<Integer, HashMap<Stat, MutableInt>>> summaryStats;
    @NotNull
    private HashMap<String, Map<String, MutableInt>> winRateByVictory;
    @NotNull
    private HashMap<String, Map<String, MutableInt>> winTurnByVictory;
    private float avgSpeed;
    private long avgDuration;
    private int totalTurns;
    private long totalDuration;
    private int stepCounter;

    public Simulation(@NotNull GameInfo newGameInfo, int simulationsPerThread, int threadsNumber, int maxTurns, @NotNull List<Integer> statTurns) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Civilization it;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(newGameInfo, "newGameInfo");
        Intrinsics.checkNotNullParameter(statTurns, "statTurns");
        this.newGameInfo = newGameInfo;
        this.simulationsPerThread = simulationsPerThread;
        this.threadsNumber = threadsNumber;
        this.maxTurns = maxTurns;
        this.statTurns = statTurns;
        this.maxSimulations = this.threadsNumber * this.simulationsPerThread;
        Iterable iterable = this.newGameInfo.getCivilizations();
        Simulation simulation = this;
        boolean $i$f$filter = false;
        void var8_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Object object = $this$filterTo$iv$iv.iterator();
        while (object.hasNext()) {
            element$iv$iv = object.next();
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getCivName(), "Spectator"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Civilization)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCivName());
        }
        simulation.civilizations = (List)destination$iv$iv;
        $this$map$iv = this.newGameInfo.getCivilizations();
        simulation = this;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        object = $this$filterTo$iv$iv.iterator();
        while (object.hasNext()) {
            element$iv$iv = object.next();
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getCivName(), "Spectator"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        object = $this$filterTo$iv$iv.iterator();
        while (object.hasNext()) {
            element$iv$iv = object.next();
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!it.isMajorCiv()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        simulation.majorCivs = ((List)destination$iv$iv).size();
        this.steps = new ArrayList();
        this.numWins = new LinkedHashMap();
        this.summaryStats = new HashMap();
        this.winRateByVictory = new HashMap();
        this.winTurnByVictory = new HashMap();
        this.avgDuration = Duration.Companion.getZERO-UwyO8pc();
        this.totalDuration = Duration.Companion.getZERO-UwyO8pc();
        for (String civ : this.civilizations) {
            Object object2;
            Object object3;
            Object object4;
            Stat key$iv;
            Object object5;
            HashMap answer$iv;
            HashMap answer$iv2;
            Object value$iv;
            this.numWins.put(civ, new MutableInt(0));
            $this$filterTo$iv$iv = this.statTurns.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object object6;
                Object object7;
                Object object8;
                Stat key$iv2;
                Object object9;
                int turn = ((Number)$this$filterTo$iv$iv.next()).intValue();
                Map $this$getOrPut$iv = this.summaryStats;
                boolean $i$f$getOrPut22 = false;
                value$iv = $this$getOrPut$iv.get(civ);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv2 = new HashMap();
                    $this$getOrPut$iv.put(civ, answer$iv2);
                    object9 = answer$iv2;
                } else {
                    object9 = value$iv;
                }
                $this$getOrPut$iv = (Map)object9;
                Integer $i$f$getOrPut22 = turn;
                boolean $i$f$getOrPut32 = false;
                Object value$iv2 = $this$getOrPut$iv.get((Object)key$iv2);
                if (value$iv2 == null) {
                    boolean bl = false;
                    HashMap answer$iv3 = new HashMap();
                    $this$getOrPut$iv.put(key$iv2, answer$iv3);
                    object8 = answer$iv3;
                } else {
                    object8 = value$iv2;
                }
                $this$getOrPut$iv = (Map)object8;
                key$iv2 = Stat.SUM;
                MutableInt $i$f$getOrPut32 = new MutableInt(0);
                $this$getOrPut$iv.put(key$iv2, $i$f$getOrPut32);
                $this$getOrPut$iv = this.summaryStats;
                boolean $i$f$getOrPut42 = false;
                value$iv = $this$getOrPut$iv.get(civ);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv2 = new HashMap();
                    $this$getOrPut$iv.put(civ, answer$iv2);
                    object7 = answer$iv2;
                } else {
                    object7 = value$iv;
                }
                $this$getOrPut$iv = (Map)object7;
                Integer $i$f$getOrPut42 = turn;
                boolean $i$f$getOrPut52 = false;
                value$iv2 = $this$getOrPut$iv.get((Object)key$iv);
                if (value$iv2 == null) {
                    boolean bl = false;
                    HashMap answer$iv4 = new HashMap();
                    $this$getOrPut$iv.put(key$iv, answer$iv4);
                    object6 = answer$iv4;
                } else {
                    object6 = value$iv2;
                }
                $this$getOrPut$iv = (Map)object6;
                key$iv = Stat.NUM;
                MutableInt $i$f$getOrPut52 = new MutableInt(0);
                $this$getOrPut$iv.put(key$iv, $i$f$getOrPut52);
            }
            int turn = -1;
            Map $this$getOrPut$iv = this.summaryStats;
            boolean $i$f$getOrPut62 = false;
            Object value$iv3 = $this$getOrPut$iv.get(civ);
            if (value$iv3 == null) {
                boolean bl = false;
                answer$iv = new HashMap();
                $this$getOrPut$iv.put(civ, answer$iv);
                object5 = answer$iv;
            } else {
                object5 = value$iv3;
            }
            $this$getOrPut$iv = (Map)object5;
            Integer $i$f$getOrPut62 = turn;
            boolean $i$f$getOrPut72 = false;
            value$iv = $this$getOrPut$iv.get((Object)key$iv);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv2 = new HashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv2);
                object4 = answer$iv2;
            } else {
                object4 = value$iv;
            }
            $this$getOrPut$iv = (Map)object4;
            key$iv = Stat.SUM;
            MutableInt $i$f$getOrPut72 = new MutableInt(0);
            $this$getOrPut$iv.put(key$iv, $i$f$getOrPut72);
            $this$getOrPut$iv = this.summaryStats;
            boolean $i$f$getOrPut82 = false;
            value$iv = $this$getOrPut$iv.get(civ);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new HashMap();
                $this$getOrPut$iv.put(civ, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv;
            }
            $this$getOrPut$iv = (Map)object3;
            Integer $i$f$getOrPut82 = turn;
            boolean $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get((Object)key$iv);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv2 = new HashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv2);
                object2 = answer$iv2;
            } else {
                object2 = value$iv;
            }
            Iterator<String> iterator2 = (Map)object2;
            key$iv = Stat.NUM;
            object = new MutableInt(0);
            iterator2.put(key$iv, object);
            ((Map)this.winRateByVictory).put(civ, (Map)new LinkedHashMap());
            GameInfo gameInfo = UncivGame.Companion.getCurrent().getGameInfo();
            Intrinsics.checkNotNull(gameInfo);
            for (String victory : gameInfo.getRuleset().getVictories().keySet()) {
                Map<String, MutableInt> map2 = this.winRateByVictory.get(civ);
                Intrinsics.checkNotNull(map2);
                Intrinsics.checkNotNull(victory);
                map2.put(victory, new MutableInt(0));
            }
            ((Map)this.winTurnByVictory).put(civ, (Map)new LinkedHashMap());
            GameInfo gameInfo2 = UncivGame.Companion.getCurrent().getGameInfo();
            Intrinsics.checkNotNull(gameInfo2);
            for (String victory : gameInfo2.getRuleset().getVictories().keySet()) {
                Map<String, MutableInt> map3 = this.winTurnByVictory.get(civ);
                Intrinsics.checkNotNull(map3);
                Intrinsics.checkNotNull(victory);
                map3.put(victory, new MutableInt(0));
            }
        }
    }

    public /* synthetic */ Simulation(GameInfo gameInfo, int n, int n2, int n3, List list2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = 1;
        }
        if ((n4 & 4) != 0) {
            n2 = 1;
        }
        if ((n4 & 8) != 0) {
            n3 = 500;
        }
        if ((n4 & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(gameInfo, n, n2, n3, list2);
    }

    public final int getSimulationsPerThread() {
        return this.simulationsPerThread;
    }

    @NotNull
    public final List<String> getCivilizations() {
        return this.civilizations;
    }

    @NotNull
    public final ArrayList<SimulationStep> getSteps() {
        return this.steps;
    }

    public final void setSteps(@NotNull ArrayList<SimulationStep> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.steps = arrayList;
    }

    @NotNull
    public final Map<String, MutableInt> getNumWins() {
        return this.numWins;
    }

    public final void setNumWins(@NotNull Map<String, MutableInt> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.numWins = map2;
    }

    public final void start() {
        BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Simulation this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        Simulation.access$setStartTime$p(this.this$0, System.currentTimeMillis());
                        jobs = new ArrayList<Job>();
                        var4_5 = Simulation.access$getNewGameInfo$p(this.this$0).getCivilizations();
                        var13_8 = new StringBuilder().append("Starting new game with major civs: ");
                        $i$f$filter = 0;
                        var6_11 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (Civilization)element$iv$iv;
                            $i$a$-filter-Simulation$start$1$1 = false;
                            if (!it.isMajorCiv()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = Simulation.access$getNewGameInfo$p(this.this$0).getCivilizations();
                        var13_8 = var13_8.append(CollectionsKt.joinToString$default((List)destination$iv$iv, null, null, null, 0, null, start.2.INSTANCE, 31, null)).append(" and minor civs: ");
                        $i$f$filter = 0;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (Civilization)element$iv$iv;
                            $i$a$-filter-Simulation$start$1$3 = false;
                            if (!it.isCityState()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        System.out.println((Object)var13_8.append(CollectionsKt.joinToString$default((List)destination$iv$iv, null, null, null, 0, null, start.4.INSTANCE, 31, null)).toString());
                        Simulation.access$getNewGameInfo$p(this.this$0).getGameParameters().setShufflePlayerOrder(true);
                        threadId = 1;
                        $i$f$filter = Simulation.access$getThreadsNumber$p(this.this$0);
                        if (threadId <= $i$f$filter) {
                            while (true) {
                                jobs.add(BuildersKt.launch$default($this$runBlocking, new CoroutineName("simulation-" + threadId), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, threadId, null){
                                    int label;
                                    final /* synthetic */ Simulation this$0;
                                    final /* synthetic */ int $threadId;
                                    {
                                        this.this$0 = $receiver;
                                        this.$threadId = $threadId;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure(object);
                                                int n = this.this$0.getSimulationsPerThread();
                                                Simulation simulation = this.this$0;
                                                int n2 = this.$threadId;
                                                for (int i = 0; i < n; ++i) {
                                                    boolean bl = false;
                                                    SimulationStep step = new SimulationStep(Simulation.access$getNewGameInfo$p(simulation), Simulation.access$getStatTurns$p(simulation));
                                                    GameInfo gameInfo = GameStarter.INSTANCE.startNewGame(new GameSetupInfo(Simulation.access$getNewGameInfo$p(simulation)));
                                                    gameInfo.setSimulateUntilWin(true);
                                                    Iterator<E> iterator2 = Simulation.access$getStatTurns$p(simulation).iterator();
                                                    while (iterator2.hasNext()) {
                                                        int turn = ((Number)iterator2.next()).intValue();
                                                        gameInfo.setSimulateMaxTurns(turn);
                                                        GameInfo.nextTurn$default(gameInfo, null, 1, null);
                                                        step.update(gameInfo);
                                                        if (step.getVictoryType() != null) break;
                                                        step.saveTurnStats(gameInfo);
                                                    }
                                                    step.update(gameInfo);
                                                    if (step.getVictoryType() == null) {
                                                        gameInfo.setSimulateMaxTurns(Simulation.access$getMaxTurns$p(simulation));
                                                        GameInfo.nextTurn$default(gameInfo, null, 1, null);
                                                    }
                                                    step.update(gameInfo);
                                                    if (step.getVictoryType() != null) {
                                                        step.saveTurnStats(gameInfo);
                                                        step.setWinner(step.getCurrentPlayer());
                                                        System.out.println((Object)(step.getWinner() + " won " + step.getVictoryType() + " victory on turn " + step.getTurns()));
                                                    } else {
                                                        System.out.println((Object)("Max simulation " + step.getTurns() + " turns reached: Draw"));
                                                    }
                                                    simulation.updateCounter(n2);
                                                    Simulation.add$default(simulation, step, 0, 2, null);
                                                    simulation.print();
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 2, null));
                                if (threadId == $i$f$filter) break;
                                ++threadId;
                            }
                        }
                        var4_7 = jobs.iterator();
lbl46:
                        // 3 sources

                        while (var4_7.hasNext()) {
                            job = (Job)var4_7.next();
                            this.L$0 = var4_7;
                            this.label = 1;
                            v0 = job.join(this);
                            if (v0 != var14_2) continue;
                            return var14_2;
                        }
                        break;
                    }
                    case 1: {
                        var4_7 = (Iterator<E>)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
                        ** GOTO lbl46
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    public final synchronized void add(@NotNull SimulationStep step, int threadId) {
        Intrinsics.checkNotNullParameter(step, "step");
        this.steps.add(step);
    }

    public static /* synthetic */ void add$default(Simulation simulation, SimulationStep simulationStep, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        simulation.add(simulationStep, n);
    }

    public final synchronized void updateCounter(int threadId) {
        int n = this.stepCounter;
        this.stepCounter = n + 1;
        System.out.println((Object)("Simulation step (" + this.stepCounter + '/' + this.maxSimulations + ')'));
    }

    public static /* synthetic */ void updateCounter$default(Simulation simulation, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        simulation.updateCounter(n);
    }

    public final synchronized void print() {
        this.getStats();
        System.out.println((Object)this.text());
    }

    public final void getStats() {
        int n;
        Iterable list$iv$iv;
        Map.Entry it;
        Map.Entry element$iv$iv;
        Object $this$flatMapTo$iv$iv;
        Iterable $this$forEach$iv = this.numWins.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableInt it2 = (MutableInt)element$iv;
            boolean bl = false;
            it2.setValue(0);
        }
        Map $this$flatMap$iv = this.winRateByVictory;
        boolean $i$f$flatMap = false;
        Iterator iterator2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator bl = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (bl.hasNext()) {
            it = element$iv$iv = bl.next();
            boolean bl2 = false;
            list$iv$iv = ((Map)it.getValue()).values();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableInt it3 = (MutableInt)element$iv;
            boolean bl3 = false;
            it3.setValue(0);
        }
        $this$flatMap$iv = this.winTurnByVictory;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl3 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (bl3.hasNext()) {
            it = element$iv$iv = bl3.next();
            boolean bl4 = false;
            list$iv$iv = ((Map)it.getValue()).values();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableInt it4 = (MutableInt)element$iv;
            boolean bl5 = false;
            it4.setValue(0);
        }
        $this$flatMap$iv = this.summaryStats;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl5 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (bl5.hasNext()) {
            it = element$iv$iv = bl5.next();
            boolean bl6 = false;
            Collection collection = ((HashMap)it.getValue()).values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            list$iv$iv = collection;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HashMap it5 = (HashMap)element$iv;
            boolean bl7 = false;
            Collection collection = it5.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MutableInt it6 = (MutableInt)element$iv2;
                boolean bl8 = false;
                it6.setValue(0);
            }
        }
        $this$forEach$iv = this.steps;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SimulationStep it7 = (SimulationStep)element$iv;
            boolean bl9 = false;
            if (it7.getWinner() != null) {
                String string = it7.getWinner();
                Intrinsics.checkNotNull(string);
                MutableInt mutableInt = this.numWins.get(string);
                Intrinsics.checkNotNull(mutableInt);
                mutableInt.inc();
                String string2 = it7.getWinner();
                Intrinsics.checkNotNull(string2);
                Map<String, MutableInt> map2 = this.winRateByVictory.get(string2);
                Intrinsics.checkNotNull(map2);
                MutableInt mutableInt2 = map2.get(it7.getVictoryType());
                Intrinsics.checkNotNull(mutableInt2);
                mutableInt2.inc();
                String string3 = it7.getWinner();
                Intrinsics.checkNotNull(string3);
                Map<String, MutableInt> map3 = this.winTurnByVictory.get(string3);
                Intrinsics.checkNotNull(map3);
                MutableInt mutableInt3 = map3.get(it7.getVictoryType());
                Intrinsics.checkNotNull(mutableInt3);
                mutableInt3.add(it7.getTurns());
            }
            for (String civ : this.civilizations) {
                Iterator<Integer> bl6 = this.statTurns.iterator();
                while (bl6.hasNext()) {
                    int turn = ((Number)bl6.next()).intValue();
                    Map<Integer, MutableInt> map4 = it7.getTurnStats().get(civ);
                    Intrinsics.checkNotNull(map4);
                    MutableInt mutableInt = map4.get(turn);
                    Intrinsics.checkNotNull(mutableInt);
                    if (mutableInt.getValue() == -1) continue;
                    HashMap<Integer, HashMap<Stat, MutableInt>> hashMap = this.summaryStats.get(civ);
                    Intrinsics.checkNotNull(hashMap);
                    HashMap<Stat, MutableInt> hashMap2 = hashMap.get(turn);
                    Intrinsics.checkNotNull(hashMap2);
                    MutableInt mutableInt4 = hashMap2.get((Object)Stat.SUM);
                    Intrinsics.checkNotNull(mutableInt4);
                    Map<Integer, MutableInt> map5 = it7.getTurnStats().get(civ);
                    Intrinsics.checkNotNull(map5);
                    MutableInt mutableInt5 = map5.get(turn);
                    Intrinsics.checkNotNull(mutableInt5);
                    mutableInt4.add(mutableInt5.getValue());
                    HashMap<Integer, HashMap<Stat, MutableInt>> hashMap3 = this.summaryStats.get(civ);
                    Intrinsics.checkNotNull(hashMap3);
                    HashMap<Stat, MutableInt> hashMap4 = hashMap3.get(turn);
                    Intrinsics.checkNotNull(hashMap4);
                    MutableInt mutableInt6 = hashMap4.get((Object)Stat.NUM);
                    Intrinsics.checkNotNull(mutableInt6);
                    mutableInt6.inc();
                }
                int turn = -1;
                HashMap<Integer, HashMap<Stat, MutableInt>> hashMap = this.summaryStats.get(civ);
                Intrinsics.checkNotNull(hashMap);
                HashMap<Stat, MutableInt> hashMap5 = hashMap.get(turn);
                Intrinsics.checkNotNull(hashMap5);
                MutableInt mutableInt = hashMap5.get((Object)Stat.SUM);
                Intrinsics.checkNotNull(mutableInt);
                Map<Integer, MutableInt> map6 = it7.getTurnStats().get(civ);
                Intrinsics.checkNotNull(map6);
                MutableInt mutableInt7 = map6.get(turn);
                Intrinsics.checkNotNull(mutableInt7);
                mutableInt.add(mutableInt7.getValue());
                HashMap<Integer, HashMap<Stat, MutableInt>> hashMap6 = this.summaryStats.get(civ);
                Intrinsics.checkNotNull(hashMap6);
                HashMap<Stat, MutableInt> hashMap7 = hashMap6.get(turn);
                Intrinsics.checkNotNull(hashMap7);
                MutableInt mutableInt8 = hashMap7.get((Object)Stat.NUM);
                Intrinsics.checkNotNull(mutableInt8);
                mutableInt8.inc();
            }
        }
        Iterable iterable = this.steps;
        Simulation simulation = this;
        int n2 = 0;
        for (Object t : iterable) {
            SimulationStep it7 = (SimulationStep)t;
            n = n2;
            boolean bl10 = false;
            int n3 = it7.getTurns();
            n2 = n + n3;
        }
        simulation.totalTurns = n = n2;
        this.totalDuration = DurationKt.toDuration(System.currentTimeMillis() - this.startTime, DurationUnit.MILLISECONDS);
        this.avgSpeed = (float)this.totalTurns / (float)Duration.getInWholeSeconds-impl(this.totalDuration);
        this.avgDuration = Duration.div-UwyO8pc(this.totalDuration, this.steps.size());
    }

    @NotNull
    public final String text() {
        String outString = "";
        for (String civ : this.civilizations) {
            HashMap<Stat, MutableInt> turnStats;
            String winRate;
            int numSteps = Math.max(this.steps.size(), 1);
            float expWinRate = 1.0f / (float)this.majorCivs;
            MutableInt mutableInt = this.numWins.get(civ);
            Intrinsics.checkNotNull(mutableInt);
            if (mutableInt.getValue() == 0) continue;
            String string = "%.1f";
            Object[] objectArray = new Object[1];
            MutableInt mutableInt2 = this.numWins.get(civ);
            Intrinsics.checkNotNull(mutableInt2);
            objectArray[0] = Float.valueOf((float)mutableInt2.getValue() * 100.0f / (float)numSteps);
            Intrinsics.checkNotNullExpressionValue(String.format(string, Arrays.copyOf(objectArray, objectArray.length)), "format(...)");
            outString = outString + '\n' + civ + ":\n";
            outString = outString + winRate + "% total win rate \n";
            if ((float)numSteps * expWinRate >= 10.0f && (float)numSteps * (1.0f - expWinRate) >= 10.0f) {
                MutableInt mutableInt3 = this.numWins.get(civ);
                Intrinsics.checkNotNull(mutableInt3);
                double pval = this.binomialTest(mutableInt3.getValue(), numSteps, expWinRate, "greater");
                outString = outString + "one-tail binomial pval = " + pval + '\n';
            }
            GameInfo gameInfo = UncivGame.Companion.getCurrent().getGameInfo();
            Intrinsics.checkNotNull(gameInfo);
            for (String victory : gameInfo.getRuleset().getVictories().keySet()) {
                Map<String, MutableInt> map2 = this.winRateByVictory.get(civ);
                Intrinsics.checkNotNull(map2);
                MutableInt mutableInt4 = map2.get(victory);
                Intrinsics.checkNotNull(mutableInt4);
                int n = mutableInt4.getValue() * 100;
                MutableInt mutableInt5 = this.numWins.get(civ);
                Intrinsics.checkNotNull(mutableInt5);
                int winsVictory = n / Math.max(mutableInt5.getValue(), 1);
                outString = outString + victory + ": " + winsVictory + "%    ";
            }
            outString = outString + '\n';
            GameInfo gameInfo2 = UncivGame.Companion.getCurrent().getGameInfo();
            Intrinsics.checkNotNull(gameInfo2);
            for (String victory : gameInfo2.getRuleset().getVictories().keySet()) {
                Map<String, MutableInt> map3 = this.winTurnByVictory.get(civ);
                Intrinsics.checkNotNull(map3);
                MutableInt mutableInt6 = map3.get(victory);
                Intrinsics.checkNotNull(mutableInt6);
                int n = mutableInt6.getValue();
                Map<String, MutableInt> map4 = this.winRateByVictory.get(civ);
                Intrinsics.checkNotNull(map4);
                MutableInt mutableInt7 = map4.get(victory);
                Intrinsics.checkNotNull(mutableInt7);
                int winsTurns = n / Math.max(mutableInt7.getValue(), 1);
                outString = outString + victory + ": " + winsTurns + "    ";
            }
            outString = outString + "avg turns\n";
            Iterator<Object> pval = this.statTurns.iterator();
            while (pval.hasNext()) {
                HashMap<Stat, MutableInt> turnStats2;
                int turn = ((Number)pval.next()).intValue();
                HashMap<Integer, HashMap<Stat, MutableInt>> hashMap = this.summaryStats.get(civ);
                Intrinsics.checkNotNull(hashMap);
                Intrinsics.checkNotNull(hashMap.get(turn));
                StringBuilder stringBuilder = new StringBuilder().append(outString).append('@').append(turn).append(": popsum avg=");
                MutableInt mutableInt8 = turnStats2.get((Object)Stat.SUM);
                Intrinsics.checkNotNull(mutableInt8);
                float f = mutableInt8.getValue();
                MutableInt mutableInt9 = turnStats2.get((Object)Stat.NUM);
                Intrinsics.checkNotNull(mutableInt9);
                StringBuilder stringBuilder2 = stringBuilder.append(f / (float)mutableInt9.getValue()).append(" cnt=");
                MutableInt mutableInt10 = turnStats2.get((Object)Stat.NUM);
                Intrinsics.checkNotNull(mutableInt10);
                outString = stringBuilder2.append(mutableInt10.getValue()).append('\n').toString();
            }
            int turn = -1;
            HashMap<Integer, HashMap<Stat, MutableInt>> hashMap = this.summaryStats.get(civ);
            Intrinsics.checkNotNull(hashMap);
            Intrinsics.checkNotNull(hashMap.get(turn));
            StringBuilder stringBuilder = new StringBuilder().append(outString).append("@END: popsum avg=");
            MutableInt mutableInt11 = turnStats.get((Object)Stat.SUM);
            Intrinsics.checkNotNull(mutableInt11);
            float f = mutableInt11.getValue();
            MutableInt mutableInt12 = turnStats.get((Object)Stat.NUM);
            Intrinsics.checkNotNull(mutableInt12);
            StringBuilder stringBuilder3 = stringBuilder.append(f / (float)mutableInt12.getValue()).append(" cnt=");
            MutableInt mutableInt13 = turnStats.get((Object)Stat.NUM);
            Intrinsics.checkNotNull(mutableInt13);
            outString = stringBuilder3.append(mutableInt13.getValue()).append('\n').toString();
        }
        StringBuilder stringBuilder = new StringBuilder().append(outString);
        String string = "\nAverage speed: %.1f turns/s \n";
        Object[] objectArray = new Object[]{Float.valueOf(this.avgSpeed)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        outString = stringBuilder.append(string2).toString();
        outString = outString + "Average game duration: " + Duration.toString-impl(this.avgDuration) + '\n';
        outString = outString + "Total time: " + Duration.toString-impl(this.totalDuration) + '\n';
        return outString;
    }

    private final double binomialTest(double successes, double trials, double p, String alternative) {
        double d;
        double q = 1.0 - p;
        double mean = trials * p;
        double variance = trials * p * q;
        double stdDev = Math.sqrt(variance);
        double z = (successes - mean) / stdDev;
        double pValue = 1.0 - this.normalCdf(z);
        String string = alternative;
        if (Intrinsics.areEqual(string, "greater")) {
            d = pValue;
        } else if (Intrinsics.areEqual(string, "less")) {
            d = 1.0 - pValue;
        } else {
            throw new IllegalArgumentException("Alternative must be 'greater' or 'less'");
        }
        return d;
    }

    private final double normalCdf(double z) {
        return 0.5 * (1.0 + this.erf(z / Math.sqrt(2.0)));
    }

    private final double erf(double x) {
        double t = 1.0 / (1.0 + 0.5 * Math.abs(x));
        double tau = t * Math.exp(-x * x - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277)))))))));
        return x >= 0.0 ? 1.0 - tau : tau - 1.0;
    }

    public static final /* synthetic */ void access$setStartTime$p(Simulation $this, long l) {
        $this.startTime = l;
    }

    public static final /* synthetic */ GameInfo access$getNewGameInfo$p(Simulation $this) {
        return $this.newGameInfo;
    }

    public static final /* synthetic */ int access$getThreadsNumber$p(Simulation $this) {
        return $this.threadsNumber;
    }

    public static final /* synthetic */ List access$getStatTurns$p(Simulation $this) {
        return $this.statTurns;
    }

    public static final /* synthetic */ int access$getMaxTurns$p(Simulation $this) {
        return $this.maxTurns;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/unciv/logic/simulation/Simulation$Stat;", "", "(Ljava/lang/String;I)V", "SUM", "NUM", "core"})
    public static final class Stat
    extends Enum<Stat> {
        public static final /* enum */ Stat SUM = new Stat();
        public static final /* enum */ Stat NUM = new Stat();
        private static final /* synthetic */ Stat[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Stat[] values() {
            return (Stat[])$VALUES.clone();
        }

        public static Stat valueOf(String value) {
            return Enum.valueOf(Stat.class, value);
        }

        @NotNull
        public static EnumEntries<Stat> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statArray = new Stat[]{Stat.SUM, Stat.NUM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

