/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.tile;

import com.badlogic.gdx.graphics.Color;
import com.unciv.Constants;
import com.unciv.logic.MultiFilter;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.objectdescriptions.DescriptionHelpersKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u0002032\u0006\u0010@\u001a\u00020AJ\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u00042\u0006\u0010@\u001a\u00020AH\u0016J\u0006\u0010D\u001a\u00020EJ\b\u0010F\u001a\u00020GH\u0016J\u0006\u0010H\u001a\u00020\u000eJ\b\u0010I\u001a\u00020\rH\u0016J$\u0010J\u001a\u00020\u000e2\u0006\u0010K\u001a\u00020\r2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010M2\b\b\u0002\u0010N\u001a\u00020\u000eJ\u000e\u0010O\u001a\u00020\u000e2\u0006\u0010K\u001a\u00020\rJ\u0006\u0010P\u001a\u00020QR(\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR-\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0014\"\u0004\b$\u0010\u0016R!\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\r0&j\b\u0012\u0004\u0012\u00020\r`'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001f\"\u0004\b,\u0010!R\u001c\u0010-\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u001f\"\u0004\b:\u0010!R\u001a\u0010;\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0014\"\u0004\b=\u0010\u0016\u00a8\u0006R"}, d2={"Lcom/unciv/models/ruleset/tile/Terrain;", "Lcom/unciv/models/ruleset/RulesetStatsObject;", "()V", "RGB", "", "", "getRGB$annotations", "getRGB", "()Ljava/util/List;", "setRGB", "(Ljava/util/List;)V", "cachedMatchesFilterResult", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getCachedMatchesFilterResult", "()Ljava/util/HashMap;", "damagePerTurn", "getDamagePerTurn", "()I", "setDamagePerTurn", "(I)V", "defenceBonus", "", "getDefenceBonus", "()F", "setDefenceBonus", "(F)V", "impassable", "getImpassable", "()Z", "setImpassable", "(Z)V", "movementCost", "getMovementCost", "setMovementCost", "occursOn", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getOccursOn", "()Ljava/util/ArrayList;", "overrideStats", "getOverrideStats", "setOverrideStats", "turnsInto", "getTurnsInto", "()Ljava/lang/String;", "setTurnsInto", "(Ljava/lang/String;)V", "type", "Lcom/unciv/models/ruleset/tile/TerrainType;", "getType", "()Lcom/unciv/models/ruleset/tile/TerrainType;", "setType", "(Lcom/unciv/models/ruleset/tile/TerrainType;)V", "unbuildable", "getUnbuildable", "setUnbuildable", "weight", "getWeight", "setWeight", "displayAs", "asType", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getCivilopediaTextLines", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "getColor", "Lcom/badlogic/gdx/graphics/Color;", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "isRough", "makeLink", "matchesFilter", "filter", "state", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "multiFilter", "matchesSingleFilter", "setTransients", "", "core"})
@SourceDebugExtension(value={"SMAP\nTerrain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Terrain.kt\ncom/unciv/models/ruleset/tile/Terrain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1747#2,2:195\n766#2:197\n857#2,2:198\n1549#2:200\n1620#2,3:201\n1749#2:204\n1855#2,2:205\n766#2:207\n857#2,2:208\n766#2:210\n857#2,2:211\n1855#2,2:213\n372#3,7:215\n1#4:222\n*S KotlinDebug\n*F\n+ 1 Terrain.kt\ncom/unciv/models/ruleset/tile/Terrain\n*L\n57#1:195,2\n59#1:197\n59#1:198,2\n60#1:200\n60#1:201,3\n57#1:204\n97#1:205,2\n104#1:207\n104#1:208,2\n116#1:210\n116#1:211,2\n125#1:213,2\n169#1:215,7\n*E\n"})
public final class Terrain
extends RulesetStatsObject {
    public TerrainType type;
    private boolean overrideStats;
    private boolean unbuildable;
    @NotNull
    private final ArrayList<String> occursOn = new ArrayList();
    @Nullable
    private String turnsInto;
    private int weight = 10;
    @Nullable
    private List<Integer> RGB;
    private int movementCost = 1;
    private float defenceBonus;
    private boolean impassable;
    private transient int damagePerTurn;
    @NotNull
    private final HashMap<String, Boolean> cachedMatchesFilterResult = new HashMap();

    @NotNull
    public final TerrainType getType() {
        TerrainType terrainType = this.type;
        if (terrainType != null) {
            return terrainType;
        }
        Intrinsics.throwUninitializedPropertyAccessException("type");
        return null;
    }

    public final void setType(@NotNull TerrainType terrainType) {
        Intrinsics.checkNotNullParameter((Object)terrainType, "<set-?>");
        this.type = terrainType;
    }

    public final boolean getOverrideStats() {
        return this.overrideStats;
    }

    public final void setOverrideStats(boolean bl) {
        this.overrideStats = bl;
    }

    public final boolean getUnbuildable() {
        return this.unbuildable;
    }

    public final void setUnbuildable(boolean bl) {
        this.unbuildable = bl;
    }

    @NotNull
    public final ArrayList<String> getOccursOn() {
        return this.occursOn;
    }

    @Nullable
    public final String getTurnsInto() {
        return this.turnsInto;
    }

    public final void setTurnsInto(@Nullable String string) {
        this.turnsInto = string;
    }

    @Override
    @NotNull
    public UniqueTarget getUniqueTarget() {
        return UniqueTarget.Terrain;
    }

    public final int getWeight() {
        return this.weight;
    }

    public final void setWeight(int n) {
        this.weight = n;
    }

    @Nullable
    public final List<Integer> getRGB() {
        return this.RGB;
    }

    public final void setRGB(@Nullable List<Integer> list2) {
        this.RGB = list2;
    }

    public static /* synthetic */ void getRGB$annotations() {
    }

    public final int getMovementCost() {
        return this.movementCost;
    }

    public final void setMovementCost(int n) {
        this.movementCost = n;
    }

    public final float getDefenceBonus() {
        return this.defenceBonus;
    }

    public final void setDefenceBonus(float f) {
        this.defenceBonus = f;
    }

    public final boolean getImpassable() {
        return this.impassable;
    }

    public final void setImpassable(boolean bl) {
        this.impassable = bl;
    }

    public final int getDamagePerTurn() {
        return this.damagePerTurn;
    }

    public final void setDamagePerTurn(int n) {
        this.damagePerTurn = n;
    }

    public final boolean isRough() {
        return IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)this, UniqueType.RoughTerrain, null, 2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean displayAs(@NotNull TerrainType asType, @NotNull Ruleset ruleset2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)asType, "asType");
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        if (this.getType() == asType) return true;
        Iterable $this$any$iv = this.occursOn;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Terrain it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                String occursName = (String)element$iv;
                boolean bl2 = false;
                Collection<Terrain> collection = ruleset2.getTerrains().values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                Iterable iterable = collection;
                boolean $i$f$filter = false;
                void var11_11 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Terrain)element$iv$iv;
                    boolean bl3 = false;
                    if (!(it.getType() == asType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Terrain)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl4 = false;
                    collection2.add(it.getName());
                }
                if (!((List)destination$iv$iv).contains(occursName)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        Terrain terrain2 = (Terrain)((Map)ruleset2.getTerrains()).get(this.turnsInto);
        if ((terrain2 != null ? terrain2.getType() : null) != asType) return false;
        return true;
    }

    @NotNull
    public final Color getColor() {
        if (this.RGB == null) {
            Color color = Color.GOLD.cpy();
            Intrinsics.checkNotNullExpressionValue(color, "cpy(...)");
            return color;
        }
        List<Integer> list2 = this.RGB;
        Intrinsics.checkNotNull(list2);
        return Scene2dExtensionsKt.colorFromRGB(list2);
    }

    @Override
    @NotNull
    public String makeLink() {
        return "Terrain/" + this.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FormattedLine> getCivilopediaTextLines(@NotNull Ruleset ruleset2) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterator $this$filter$iv;
        Object element$iv2;
        Stats stats2;
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        ArrayList textList = new ArrayList();
        if (this.getType() == TerrainType.NaturalWonder) {
            ((Collection)textList).add(new FormattedLine("Natural Wonder", null, null, null, 0.0f, 0, 3, 0, 0.0f, "#3A0", false, false, false, false, 15806, null));
        }
        if (!(stats2 = this.cloneStats()).isEmpty() || this.overrideStats) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine(stats2.isEmpty() ? "No yields" : String.valueOf(stats2), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            if (this.overrideStats) {
                ((Collection)textList).add(new FormattedLine("Overrides yields from underlying terrain", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            }
        }
        if (!((Collection)this.occursOn).isEmpty() && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)this, UniqueType.NoNaturalGeneration, null, 2, null)) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            if (this.occursOn.size() == 1) {
                String $this$getCivilopediaTextLines_u24lambda_u243 = this.occursOn.get(0);
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine("Occurs on [" + $this$getCivilopediaTextLines_u24lambda_u243 + ']', "Terrain/" + $this$getCivilopediaTextLines_u24lambda_u243, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            } else {
                ((Collection)textList).add(new FormattedLine("Occurs on:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                Iterable $this$forEach$iv = this.occursOn;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    String it = (String)element$iv2;
                    boolean bl = false;
                    ((Collection)textList).add(new FormattedLine(it, "Terrain/" + it, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
                }
            }
        }
        Collection<TileImprovement> collection = ruleset2.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $i$f$forEach = collection;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            TileImprovement it = (TileImprovement)element$iv$iv;
            boolean bl = false;
            if (!it.getTerrainsCanBeBuiltOn().contains(this.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List improvementsThatCanBePlacedHere = (List)destination$iv$iv;
        if (!((Collection)improvementsThatCanBePlacedHere).isEmpty()) {
            ((Collection)textList).add(new FormattedLine("{Tile Improvements}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            for (TileImprovement improvement2 : improvementsThatCanBePlacedHere) {
                ((Collection)textList).add(new FormattedLine(improvement2.getName(), improvement2.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        if (this.turnsInto != null) {
            ((Collection)textList).add(new FormattedLine("Placed on [" + this.turnsInto + ']', "Terrain/" + this.turnsInto, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        Collection<TileResource> collection2 = ruleset2.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterable $this$filter$iv2 = collection2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileResource it = (TileResource)element$iv$iv;
            boolean bl = false;
            if (!it.getTerrainsCanBeFoundOn().contains(this.getName())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List resourcesFound = (List)destination$iv$iv2;
        if (!((Collection)resourcesFound).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            if (resourcesFound.size() == 1) {
                TileResource $this$getCivilopediaTextLines_u24lambda_u247 = (TileResource)resourcesFound.get(0);
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine("May contain [" + $this$getCivilopediaTextLines_u24lambda_u247 + ']', "Resource/" + $this$getCivilopediaTextLines_u24lambda_u247, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            } else {
                ((Collection)textList).add(new FormattedLine("May contain:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                Iterable $this$forEach$iv = resourcesFound;
                boolean $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    TileResource it = (TileResource)element$iv3;
                    boolean bl = false;
                    ((Collection)textList).add(new FormattedLine(String.valueOf(it), "Resource/" + it, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
                }
            }
        }
        ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        if (this.turnsInto == null && this.displayAs(TerrainType.Land, ruleset2) && !this.isRough()) {
            ((Collection)textList).add(new FormattedLine("Open terrain", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        DescriptionHelpersKt.uniquesToCivilopediaTextLines$default(this, textList, null, false, null, 12, null);
        ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        if (this.impassable) {
            ((Collection)textList).add(new FormattedLine("Impassable", null, null, null, 0.0f, 0, 0, 0, 0.0f, "#A00", false, false, false, false, 15870, null));
        } else if (this.movementCost > 0) {
            ((Collection)textList).add(new FormattedLine("{Movement cost}: " + this.movementCost, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if (!(this.defenceBonus == 0.0f)) {
            ((Collection)textList).add(new FormattedLine("{Defence bonus}: " + (int)(this.defenceBonus * (float)100) + '%', null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        Collection<Building> collection3 = ruleset2.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
        Sequence sequence = CollectionsKt.asSequence((Iterable)collection3);
        Collection<BaseUnit> collection4 = ruleset2.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection4, "<get-values>(...)");
        Sequence<FormattedLine> seeAlso2 = SequencesKt.plus(SequencesKt.map(SequencesKt.filter(SequencesKt.plus(sequence, CollectionsKt.asSequence((Iterable)collection4)), new Function1<?, Boolean>(this){
            final /* synthetic */ Terrain this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull IHasUniques construction2) {
                boolean bl;
                block7: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter(construction2, "construction");
                    Iterable iterable = ((INonPerpetualConstruction)construction2).getUniqueObjects();
                    Terrain terrain2 = this.this$0;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            boolean bl2;
                            block6: {
                                Unique unique = (Unique)element$iv;
                                boolean bl3 = false;
                                Iterable $this$any$iv2 = unique.getParams();
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (T element$iv2 : $this$any$iv2) {
                                        String it = (String)element$iv2;
                                        boolean bl4 = false;
                                        if (!Intrinsics.areEqual(it, terrain2.getName())) continue;
                                        bl2 = true;
                                        break block6;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }), getCivilopediaTextLines.seeAlso.2.INSTANCE), Belief.Companion.getCivilopediaTextMatching(this.getName(), ruleset2, false));
        if (SequencesKt.any(seeAlso2)) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{See also}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            CollectionsKt.addAll((Collection)textList, seeAlso2);
        }
        return textList;
    }

    @NotNull
    public final HashMap<String, Boolean> getCachedMatchesFilterResult() {
        return this.cachedMatchesFilterResult;
    }

    public final boolean matchesFilter(@NotNull String filter2, @Nullable StateForConditionals state, boolean multiFilter) {
        boolean bl;
        Intrinsics.checkNotNullParameter(filter2, "filter");
        if (multiFilter) {
            bl = MultiFilter.multiFilter$default(MultiFilter.INSTANCE, filter2, new Function1<String, Boolean>(this, state){
                final /* synthetic */ Terrain this$0;
                final /* synthetic */ StateForConditionals $state;
                {
                    this.this$0 = $receiver;
                    this.$state = $state;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Object object;
                    void $this$getOrPut$iv;
                    Intrinsics.checkNotNullParameter(it, "it");
                    Map map2 = this.this$0.getCachedMatchesFilterResult();
                    Terrain terrain2 = this.this$0;
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(it);
                    if (value$iv == null) {
                        boolean bl = false;
                        Boolean answer$iv = terrain2.matchesSingleFilter(it);
                        $this$getOrPut$iv.put(it, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    return (Boolean)object != false || this.$state != null && this.this$0.hasUnique(it, this.$state) || this.$state == null && this.this$0.hasTagUnique(it);
                }
            }, false, 4, null);
        } else {
            Object object;
            Map $this$getOrPut$iv = this.cachedMatchesFilterResult;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(filter2);
            if (value$iv == null) {
                boolean bl2 = false;
                Boolean answer$iv = this.matchesSingleFilter(filter2);
                $this$getOrPut$iv.put(filter2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            bl = (Boolean)object != false || state != null && this.hasUnique(filter2, state) || state == null && this.hasTagUnique(filter2);
        }
        return bl;
    }

    public static /* synthetic */ boolean matchesFilter$default(Terrain terrain2, String string, StateForConditionals stateForConditionals, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            stateForConditionals = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return terrain2.matchesFilter(string, stateForConditionals, bl);
    }

    public final boolean matchesSingleFilter(@NotNull String filter2) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        String string = filter2;
        return Constants.INSTANCE.getAll().contains(string) ? true : (Intrinsics.areEqual(string, this.getName()) ? true : (Intrinsics.areEqual(string, "Terrain") ? true : (Intrinsics.areEqual(string, "Open terrain") ? !this.isRough() : (Intrinsics.areEqual(string, "Rough terrain") ? this.isRough() : (Intrinsics.areEqual(string, this.getType().name()) ? true : (Intrinsics.areEqual(string, "Natural Wonder") ? this.getType() == TerrainType.NaturalWonder : (Intrinsics.areEqual(string, "Terrain Feature") ? this.getType() == TerrainType.TerrainFeature : false)))))));
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransients() {
        int n;
        Sequence sequence = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)this, UniqueType.DamagesContainingUnits, null, 2, null);
        Terrain terrain2 = this;
        int n2 = 0;
        Iterator iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object t = iterator2.next();
            Unique unique = (Unique)t;
            n = n2;
            boolean bl = false;
            int n3 = Integer.parseInt(it.getParams().get(0));
            n2 = n + n3;
        }
        terrain2.damagePerTurn = n = n2;
    }
}

