/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.unique.expressions;

import com.unciv.logic.GameInfo;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.unique.Countables;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.expressions.Operator;
import com.unciv.models.ruleset.unique.expressions.Tokenizer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0005\u000b\f\r\u000e\u000fJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH&\u0082\u0001\u0004\u0010\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node;", "", "eval", "", "context", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "getErrors", "", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "BinaryOperation", "Constant", "Countable", "NumericConstant", "UnaryOperation", "Lcom/unciv/models/ruleset/unique/expressions/Node$BinaryOperation;", "Lcom/unciv/models/ruleset/unique/expressions/Node$Constant;", "Lcom/unciv/models/ruleset/unique/expressions/Node$Countable;", "Lcom/unciv/models/ruleset/unique/expressions/Node$UnaryOperation;", "core"})
public interface Node {
    public double eval(@NotNull StateForConditionals var1);

    @NotNull
    public List<String> getErrors(@NotNull Ruleset var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node$BinaryOperation;", "Lcom/unciv/models/ruleset/unique/expressions/Node;", "operator", "Lcom/unciv/models/ruleset/unique/expressions/Operator$Binary;", "left", "right", "(Lcom/unciv/models/ruleset/unique/expressions/Operator$Binary;Lcom/unciv/models/ruleset/unique/expressions/Node;Lcom/unciv/models/ruleset/unique/expressions/Node;)V", "eval", "", "context", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "getErrors", "", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "toString", "core"})
    public static final class BinaryOperation
    implements Node {
        @NotNull
        private final Operator.Binary operator;
        @NotNull
        private final Node left;
        @NotNull
        private final Node right;

        public BinaryOperation(@NotNull Operator.Binary operator, @NotNull Node left, @NotNull Node right) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(left, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            this.operator = operator;
            this.left = left;
            this.right = right;
        }

        @Override
        public double eval(@NotNull StateForConditionals context) {
            Intrinsics.checkNotNullParameter(context, "context");
            return ((Number)this.operator.getImplementation().invoke(this.left.eval(context), this.right.eval(context))).doubleValue();
        }

        @NotNull
        public String toString() {
            return "" + '(' + this.left + ' ' + this.operator + ' ' + this.right + ')';
        }

        @Override
        @NotNull
        public List<String> getErrors(@NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            List<String> leftErrors = this.left.getErrors(ruleset2);
            List<String> rightErrors = this.right.getErrors(ruleset2);
            return CollectionsKt.plus((Collection)leftErrors, (Iterable)rightErrors);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node$Constant;", "Lcom/unciv/models/ruleset/unique/expressions/Node;", "Lcom/unciv/models/ruleset/unique/expressions/Tokenizer$Token;", "value", "", "getValue", "()D", "eval", "context", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "getErrors", "", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "core"})
    public static interface Constant
    extends Node,
    Tokenizer.Token {
        public double getValue();

        @Override
        public double eval(@NotNull StateForConditionals var1);

        @Override
        @NotNull
        public List<String> getErrors(@NotNull Ruleset var1);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static double eval(@NotNull Constant $this, @NotNull StateForConditionals context) {
                Intrinsics.checkNotNullParameter(context, "context");
                return $this.getValue();
            }

            @NotNull
            public static List<String> getErrors(@NotNull Constant $this, @NotNull Ruleset ruleset2) {
                Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
                return CollectionsKt.emptyList();
            }

            public static boolean canBeUnary(@NotNull Constant $this) {
                return Tokenizer.Token.DefaultImpls.canBeUnary($this);
            }

            public static boolean canBeBinary(@NotNull Constant $this) {
                return Tokenizer.Token.DefaultImpls.canBeBinary($this);
            }

            @NotNull
            public static Operator.Unary fetchUnaryOperator(@NotNull Constant $this) {
                return Tokenizer.Token.DefaultImpls.fetchUnaryOperator($this);
            }

            @NotNull
            public static Operator.Binary fetchBinaryOperator(@NotNull Constant $this) {
                return Tokenizer.Token.DefaultImpls.fetchBinaryOperator($this);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node$Countable;", "Lcom/unciv/models/ruleset/unique/expressions/Node;", "Lcom/unciv/models/ruleset/unique/expressions/Tokenizer$Token;", "parameterText", "", "rulesetInvariantCountable", "Lcom/unciv/models/ruleset/unique/Countables;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/Countables;)V", "eval", "", "context", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "getCountable", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getErrors", "", "toString", "core"})
    public static final class Countable
    implements Node,
    Tokenizer.Token {
        @NotNull
        private final String parameterText;
        @Nullable
        private final Countables rulesetInvariantCountable;

        public Countable(@NotNull String parameterText, @Nullable Countables rulesetInvariantCountable) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            this.parameterText = parameterText;
            this.rulesetInvariantCountable = rulesetInvariantCountable;
        }

        @Override
        public double eval(@NotNull StateForConditionals context) {
            Intrinsics.checkNotNullParameter(context, "context");
            Object object = context.getGameInfo();
            if (object == null || (object = ((GameInfo)object).getRuleset()) == null) {
                return 0.0;
            }
            Object ruleset2 = object;
            Countables countables = this.getCountable((Ruleset)ruleset2);
            if (countables == null) {
                return 0.0;
            }
            Countables countable = countables;
            Integer n = countable.eval(this.parameterText, context);
            return n != null ? (double)n.intValue() : 0.0;
        }

        private final Countables getCountable(Ruleset ruleset2) {
            Countables countables = this.rulesetInvariantCountable;
            if (countables == null) {
                countables = Countables.Companion.getMatching(this.parameterText, ruleset2);
            }
            return countables;
        }

        @Override
        @NotNull
        public List<String> getErrors(@NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            if (this.getCountable(ruleset2) == null) {
                return CollectionsKt.listOf("Unknown countable: " + this.parameterText);
            }
            return CollectionsKt.emptyList();
        }

        @NotNull
        public String toString() {
            return "[Countable: " + this.parameterText + ']';
        }

        @Override
        public boolean canBeUnary() {
            return Tokenizer.Token.DefaultImpls.canBeUnary(this);
        }

        @Override
        public boolean canBeBinary() {
            return Tokenizer.Token.DefaultImpls.canBeBinary(this);
        }

        @Override
        @NotNull
        public Operator.Unary fetchUnaryOperator() {
            return Tokenizer.Token.DefaultImpls.fetchUnaryOperator(this);
        }

        @Override
        @NotNull
        public Operator.Binary fetchBinaryOperator() {
            return Tokenizer.Token.DefaultImpls.fetchBinaryOperator(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node$NumericConstant;", "Lcom/unciv/models/ruleset/unique/expressions/Node$Constant;", "value", "", "(D)V", "getValue", "()D", "toString", "", "core"})
    public static final class NumericConstant
    implements Constant {
        private final double value;

        public NumericConstant(double value) {
            this.value = value;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.getValue());
        }

        @Override
        public double eval(@NotNull StateForConditionals context) {
            return Constant.DefaultImpls.eval(this, context);
        }

        @Override
        @NotNull
        public List<String> getErrors(@NotNull Ruleset ruleset2) {
            return Constant.DefaultImpls.getErrors(this, ruleset2);
        }

        @Override
        public boolean canBeUnary() {
            return Constant.DefaultImpls.canBeUnary(this);
        }

        @Override
        public boolean canBeBinary() {
            return Constant.DefaultImpls.canBeBinary(this);
        }

        @Override
        @NotNull
        public Operator.Unary fetchUnaryOperator() {
            return Constant.DefaultImpls.fetchUnaryOperator(this);
        }

        @Override
        @NotNull
        public Operator.Binary fetchBinaryOperator() {
            return Constant.DefaultImpls.fetchBinaryOperator(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node$UnaryOperation;", "Lcom/unciv/models/ruleset/unique/expressions/Node;", "operator", "Lcom/unciv/models/ruleset/unique/expressions/Operator$Unary;", "operand", "(Lcom/unciv/models/ruleset/unique/expressions/Operator$Unary;Lcom/unciv/models/ruleset/unique/expressions/Node;)V", "eval", "", "context", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "getErrors", "", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "toString", "core"})
    public static final class UnaryOperation
    implements Node {
        @NotNull
        private final Operator.Unary operator;
        @NotNull
        private final Node operand;

        public UnaryOperation(@NotNull Operator.Unary operator, @NotNull Node operand) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.operator = operator;
            this.operand = operand;
        }

        @Override
        public double eval(@NotNull StateForConditionals context) {
            Intrinsics.checkNotNullParameter(context, "context");
            return ((Number)this.operator.getImplementation().invoke(this.operand.eval(context))).doubleValue();
        }

        @NotNull
        public String toString() {
            return "" + '(' + this.operator + ' ' + this.operand + ')';
        }

        @Override
        @NotNull
        public List<String> getErrors(@NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return this.operand.getErrors(ruleset2);
        }
    }
}

