/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Json;
import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.GameInfo;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.BeliefType;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Event;
import com.unciv.models.ruleset.EventChoice;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.Milestone;
import com.unciv.models.ruleset.MilestoneType;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.RuinReward;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.RulesetFile;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.CityStateType;
import com.unciv.models.ruleset.nation.Difficulty;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.nation.NationKt;
import com.unciv.models.ruleset.nation.Personality;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.ruleset.unit.UnitMovementType;
import com.unciv.models.ruleset.unit.UnitType;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.RulesetValidator;
import com.unciv.models.ruleset.validation.TextSimilarityKt;
import com.unciv.models.ruleset.validation.UniqueValidator;
import com.unciv.models.stats.INamed;
import com.unciv.models.stats.Stats;
import com.unciv.models.tilesets.TileSetCache;
import com.unciv.models.tilesets.TileSetConfig;
import com.unciv.ui.images.AtlasPreview;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.images.PortraitPromotion;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.ICivilopediaText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001lB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010&\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010(\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010)\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010-\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010.\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010/\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u00100\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u0002032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u00104\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u00105\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u00106\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u00107\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u00108\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u00109\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010:\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010;\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010<\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010=\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010>\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010?\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010@\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010A\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010B\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010C\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010D\u001a\u00020\u00182\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020F2\u0006\u0010+\u001a\u00020H2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010I\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010J\u001a\u00020\u00182\u0006\u0010K\u001a\u00020L2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010M\u001a\u00020\u00182\u0006\u0010K\u001a\u00020L2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010N\u001a\u00020\u00182\u0006\u0010K\u001a\u00020L2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010O\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010P\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010Q\u001a\u00020\u00182\u0006\u0010R\u001a\u00020S2\b\u0010T\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010U\u001a\u00020\u00182\u0006\u0010V\u001a\u00020W2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010X\u001a\u00020\u00182\u0006\u0010V\u001a\u00020W2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010Y\u001a\u00020\u00182\u0006\u0010Z\u001a\u00020\u00072\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00180\\H\u0002J\u0018\u0010]\u001a\u00020\u00182\u0006\u0010K\u001a\u00020L2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010^\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010_\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010`\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00070b2\u0006\u0010c\u001a\u00020\u00072\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00070bH\u0002J\u0016\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010f\u001a\u00020\u0007H\u0002J\u0018\u0010g\u001a\u00020h2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020FH\u0002J\u000e\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0002J\u000e\u0010j\u001a\u00020\u001c2\u0006\u0010k\u001a\u00020\u0007RJ\u0010\u0005\u001a>\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\bj\b\u0012\u0004\u0012\u00020\u0007`\t0\u0006j\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\bj\b\u0012\u0004\u0012\u00020\u0007`\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0014\u0010\f\u00a8\u0006m"}, d2={"Lcom/unciv/models/ruleset/validation/RulesetValidator;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "(Lcom/unciv/models/ruleset/Ruleset;)V", "prereqsHashMap", "Ljava/util/HashMap;", "", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "Lkotlin/collections/HashMap;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "textureNamesCache", "Lcom/unciv/ui/images/AtlasPreview;", "uniqueValidator", "Lcom/unciv/models/ruleset/validation/UniqueValidator;", "unitMovementTypes", "", "vanillaRuleset", "getVanillaRuleset", "vanillaRuleset$delegate", "Lkotlin/Lazy;", "addBeliefErrors", "", "lines", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "tryFixUnknownUniques", "", "addBuildingErrorRulesetInvariant", "building", "Lcom/unciv/models/ruleset/Building;", "addBuildingErrors", "addBuildingErrorsRulesetInvariant", "addCityStateTypeErrors", "addDifficultyErrors", "addEraErrors", "addEventErrors", "addGlobalUniqueErrors", "reportRulesetSpecificErrors", "addImprovementErrors", "addModOptionsErrors", "addNationErrorRulesetInvariant", "nation", "Lcom/unciv/models/ruleset/nation/Nation;", "addNationErrors", "addNationErrorsRulesetInvariant", "addPersonalityErrors", "addPolicyErrors", "addPromotionErrorRulesetInvariant", "promotion", "Lcom/unciv/models/ruleset/unit/Promotion;", "addPromotionErrors", "addPromotionErrorsRulesetInvariant", "addResourceErrors", "addResourceErrorsRulesetInvariant", "addRuinsErrors", "addSpecialistErrors", "addSpeedErrors", "addTechColumnErrorsRulesetInvariant", "addTechErrors", "addTechErrorsRulesetInvariant", "addTerrainErrors", "addUnitErrorsBaseRuleset", "addUnitErrorsRulesetInvariant", "addUnitTypeErrors", "addVictoryTypeErrors", "checkCivilopediaText", "checkContrasts", "innerColor", "Lcom/badlogic/gdx/graphics/Color;", "outerColor", "Lcom/unciv/models/ruleset/RulesetObject;", "checkFileNames", "checkImagesFolders", "folder", "Lcom/badlogic/gdx/files/FileHandle;", "checkMisplacedJsonFiles", "checkMisspelledFolders", "checkPromotionCircularReferences", "checkTilesetSanity", "checkUniqueToMisspelling", "obj", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "uniqueTo", "checkUnitRulesetInvariant", "unit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "checkUnitRulesetSpecific", "checkUnitType", "type", "reportError", "Lkotlin/Function0;", "checkUnknownJsonFilenames", "getBaseRulesetErrorList", "getErrorList", "getNonBaseRulesetErrorList", "getPossibleMisspellings", "", "originalText", "possibleMisspellings", "getPrereqTree", "technologyName", "getSuggestedColors", "Lcom/unciv/models/ruleset/validation/RulesetValidator$SuggestedColors;", "getTilesetNamesFromAtlases", "uncachedImageExists", "name", "SuggestedColors", "core"})
@SourceDebugExtension(value={"SMAP\nRulesetValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RulesetValidator.kt\ncom/unciv/models/ruleset/validation/RulesetValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1096:1\n1549#2:1097\n1620#2,3:1098\n766#2:1101\n857#2,2:1102\n1549#2:1104\n1620#2,3:1105\n1360#2:1108\n1446#2,5:1109\n1549#2:1117\n1620#2,3:1118\n1549#2:1121\n1620#2,3:1122\n1774#2,4:1125\n1360#2:1133\n1446#2,5:1134\n2624#2,3:1139\n2624#2,3:1142\n1747#2,3:1145\n2624#2,3:1148\n1549#2:1151\n1620#2,3:1152\n766#2:1155\n857#2,2:1156\n2624#2,3:1160\n766#2:1163\n857#2:1164\n1549#2:1165\n1620#2,3:1166\n858#2:1169\n766#2:1170\n857#2,2:1171\n766#2:1173\n857#2,2:1174\n1360#2:1176\n1446#2,5:1177\n766#2:1182\n857#2,2:1183\n1549#2:1185\n1620#2,3:1186\n3792#3:1114\n4307#3,2:1115\n11065#3:1129\n11400#3,3:1130\n1247#4,2:1158\n*S KotlinDebug\n*F\n+ 1 RulesetValidator.kt\ncom/unciv/models/ruleset/validation/RulesetValidator\n*L\n317#1:1097\n317#1:1098,3\n118#1:1101\n118#1:1102,2\n166#1:1104\n166#1:1105,3\n166#1:1108\n166#1:1109,5\n198#1:1117\n198#1:1118,3\n201#1:1121\n201#1:1122,3\n222#1:1125,4\n396#1:1133\n396#1:1134,5\n474#1:1139,3\n478#1:1142,3\n515#1:1145,3\n535#1:1148,3\n577#1:1151\n577#1:1152,3\n586#1:1155\n586#1:1156,2\n703#1:1160,3\n850#1:1163\n850#1:1164\n851#1:1165\n851#1:1166,3\n850#1:1169\n854#1:1170\n854#1:1171,2\n861#1:1173\n861#1:1174,2\n920#1:1176\n920#1:1177,5\n1051#1:1182\n1051#1:1183,2\n1052#1:1185\n1052#1:1186,3\n169#1:1114\n169#1:1115,2\n231#1:1129\n231#1:1130,3\n589#1:1158,2\n*E\n"})
public final class RulesetValidator {
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final UniqueValidator uniqueValidator;
    private AtlasPreview textureNamesCache;
    @NotNull
    private final Set<String> unitMovementTypes;
    @NotNull
    private final HashMap<String, HashSet<String>> prereqsHashMap;
    @NotNull
    private final Lazy vanillaRuleset$delegate;

    /*
     * WARNING - void declaration
     */
    public RulesetValidator(@NotNull Ruleset ruleset2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        this.ruleset = ruleset2;
        this.uniqueValidator = new UniqueValidator(this.ruleset);
        Iterable iterable = UnitMovementType.getEntries();
        RulesetValidator rulesetValidator = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UnitMovementType unitMovementType2 = (UnitMovementType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        rulesetValidator.unitMovementTypes = CollectionsKt.toSet((List)destination$iv$iv);
        this.prereqsHashMap = new HashMap();
        this.vanillaRuleset$delegate = LazyKt.lazy(vanillaRuleset.2.INSTANCE);
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    @NotNull
    public final RulesetErrorList getErrorList(boolean tryFixUnknownUniques) {
        if (!this.ruleset.getModOptions().isBaseRuleset()) {
            return this.getNonBaseRulesetErrorList(tryFixUnknownUniques);
        }
        return this.getBaseRulesetErrorList(tryFixUnknownUniques);
    }

    public static /* synthetic */ RulesetErrorList getErrorList$default(RulesetValidator rulesetValidator, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return rulesetValidator.getErrorList(bl);
    }

    private final RulesetErrorList getNonBaseRulesetErrorList(boolean tryFixUnknownUniques) {
        RulesetErrorList lines2 = new RulesetErrorList(this.ruleset);
        this.addModOptionsErrors(lines2, tryFixUnknownUniques);
        this.addGlobalUniqueErrors(lines2, false, tryFixUnknownUniques);
        this.addUnitErrorsRulesetInvariant(lines2, tryFixUnknownUniques);
        this.addTechErrorsRulesetInvariant(lines2, tryFixUnknownUniques);
        this.addTechColumnErrorsRulesetInvariant(lines2);
        this.addBuildingErrorsRulesetInvariant(lines2, tryFixUnknownUniques);
        this.addNationErrorsRulesetInvariant(lines2, tryFixUnknownUniques);
        this.addPromotionErrorsRulesetInvariant(lines2, tryFixUnknownUniques);
        this.addResourceErrorsRulesetInvariant(lines2, tryFixUnknownUniques);
        if (this.textureNamesCache == null) {
            this.textureNamesCache = new AtlasPreview(this.ruleset, lines2);
        }
        this.checkTilesetSanity(lines2);
        this.checkCivilopediaText(lines2);
        this.checkFileNames(lines2);
        return lines2;
    }

    private final RulesetErrorList getBaseRulesetErrorList(boolean tryFixUnknownUniques) {
        this.uniqueValidator.populateFilteringUniqueHashsets();
        RulesetErrorList lines2 = new RulesetErrorList(this.ruleset);
        this.addModOptionsErrors(lines2, tryFixUnknownUniques);
        this.addGlobalUniqueErrors(lines2, true, tryFixUnknownUniques);
        this.addUnitErrorsBaseRuleset(lines2, tryFixUnknownUniques);
        this.addBuildingErrors(lines2, tryFixUnknownUniques);
        this.addSpecialistErrors(lines2);
        this.addResourceErrors(lines2, tryFixUnknownUniques);
        this.addImprovementErrors(lines2, tryFixUnknownUniques);
        this.addTerrainErrors(lines2, tryFixUnknownUniques);
        this.addTechErrors(lines2, tryFixUnknownUniques);
        this.addTechColumnErrorsRulesetInvariant(lines2);
        this.addEraErrors(lines2, tryFixUnknownUniques);
        this.addSpeedErrors(lines2);
        this.addPersonalityErrors(lines2);
        this.addBeliefErrors(lines2, tryFixUnknownUniques);
        this.addNationErrors(lines2, tryFixUnknownUniques);
        this.addPolicyErrors(lines2, tryFixUnknownUniques);
        this.addRuinsErrors(lines2, tryFixUnknownUniques);
        this.addPromotionErrors(lines2, tryFixUnknownUniques);
        this.addUnitTypeErrors(lines2, tryFixUnknownUniques);
        this.addVictoryTypeErrors(lines2);
        this.addDifficultyErrors(lines2);
        this.addEventErrors(lines2, tryFixUnknownUniques);
        this.addCityStateTypeErrors(tryFixUnknownUniques, lines2);
        if (this.textureNamesCache == null) {
            this.textureNamesCache = new AtlasPreview(this.ruleset, lines2);
        }
        if (this.ruleset.getFolderLocation() != null || Intrinsics.areEqual(this.ruleset.getName(), BaseRuleset.Civ_V_GnK.getFullName())) {
            this.checkTilesetSanity(lines2);
        }
        this.checkCivilopediaText(lines2);
        this.checkFileNames(lines2);
        return lines2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPossibleMisspellings(String originalText, List<String> possibleMisspellings) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = possibleMisspellings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = TextSimilarityKt.getRelativeTextDistance(it, originalText) <= RulesetCache.INSTANCE.getUniqueMisspellingThreshold();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void checkFileNames(RulesetErrorList lines2) {
        FileHandle fileHandle = this.ruleset.getFolderLocation();
        if (fileHandle == null) {
            return;
        }
        FileHandle folder = fileHandle;
        this.checkMisplacedJsonFiles(folder, lines2);
        this.checkMisspelledFolders(folder, lines2);
        this.checkImagesFolders(folder, lines2);
        this.checkUnknownJsonFilenames(folder, lines2);
    }

    private final void checkMisspelledFolders(FileHandle folder, RulesetErrorList lines2) {
        Object[] objectArray = new String[]{"jsons", "maps", "sounds", "Images", "fonts"};
        List<String> knownFolderNames = CollectionsKt.listOf(objectArray);
        FileHandle[] fileHandleArray = folder.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        for (FileHandle child : fileHandleArray) {
            if (!child.isDirectory() || knownFolderNames.contains(child.name())) continue;
            String string = child.name();
            Intrinsics.checkNotNullExpressionValue(string, "name(...)");
            List<String> possibleMisspellings = this.getPossibleMisspellings(string, knownFolderNames);
            if (!(!((Collection)possibleMisspellings).isEmpty())) continue;
            RulesetErrorList.add$default(lines2, "Folder \"" + child.name() + "\" is probably a misspelling of " + CollectionsKt.joinToString$default(possibleMisspellings, "/", null, null, 0, null, null, 62, null), RulesetErrorSeverity.OK, null, null, 12, null);
        }
    }

    private final void checkMisplacedJsonFiles(FileHandle folder, RulesetErrorList lines2) {
        FileHandle[] fileHandleArray = folder.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        for (FileHandle child : fileHandleArray) {
            String string = child.name();
            Intrinsics.checkNotNullExpressionValue(string, "name(...)");
            if (!StringsKt.endsWith$default(string, "json", false, 2, null)) continue;
            String string2 = child.name();
            Intrinsics.checkNotNullExpressionValue(string2, "name(...)");
            if (StringsKt.startsWith$default(string2, "Atlas", false, 2, null)) continue;
            RulesetErrorList.add$default(lines2, "File " + child.name() + " is located in the root folder - it should be moved to a 'jsons' folder", null, null, null, 14, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkImagesFolders(FileHandle folder, RulesetErrorList lines2) {
        void $this$filterTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        String[] $this$flatMap$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = Portrait.Type.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Portrait.Type type2 = (Portrait.Type)((Object)item$iv$iv);
            Object[] objectArray = destination$iv$iv;
            boolean bl = false;
            objectArray.add(((Portrait.Type)((Object)it)).getDirectory());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{it + "Icons", it + "Portraits"};
            Iterable list$iv$iv = CollectionsKt.listOf(stringArray);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = new String[]{"CityStateIcons", "PolicyBranchIcons", "PolicyIcons", "OtherIcons", "EmojiIcons", "StatIcons", "TileIcons", "TileSets"};
        List<String> knownImageFolders = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf($this$flatMap$iv));
        FileHandle[] fileHandleArray = folder.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        Object[] $this$filter$iv = fileHandleArray;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            FileHandle it2 = (FileHandle)element$iv$iv;
            boolean bl = false;
            String string = it2.name();
            Intrinsics.checkNotNullExpressionValue(string, "name(...)");
            if (!StringsKt.startsWith$default(string, "Images", false, 2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List imageFolders2 = (List)destination$iv$iv2;
        for (FileHandle imageFolder : imageFolders2) {
            FileHandle[] fileHandleArray2;
            Intrinsics.checkNotNullExpressionValue(imageFolder.list(), "list(...)");
            for (FileHandle child : fileHandleArray2) {
                if (!child.isDirectory()) {
                    RulesetErrorList.add$default(lines2, "File \"" + imageFolder + '/' + child.name() + "\" is misplaced - Images folders should not contain any files directly - only subfolders", RulesetErrorSeverity.OK, null, null, 12, null);
                    continue;
                }
                if (knownImageFolders.contains(child.name())) continue;
                String string = child.name();
                Intrinsics.checkNotNullExpressionValue(string, "name(...)");
                List<String> possibleMisspellings = this.getPossibleMisspellings(string, knownImageFolders);
                if (!(!((Collection)possibleMisspellings).isEmpty())) continue;
                RulesetErrorList.add$default(lines2, "Folder \"" + imageFolder + '/' + child.name() + "\" is probably a misspelling of " + CollectionsKt.joinToString$default(possibleMisspellings, "/", null, null, 0, null, null, 62, null), RulesetErrorSeverity.OK, null, null, 12, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkUnknownJsonFilenames(FileHandle folder, RulesetErrorList lines2) {
        FileHandle jsonFolder = folder.child("jsons");
        if (!jsonFolder.exists()) {
            return;
        }
        FileHandle[] fileHandleArray = jsonFolder.list("json");
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        for (FileHandle file : fileHandleArray) {
            String string;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = RulesetFile.getEntries();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                RulesetFile rulesetFile = (RulesetFile)((Object)item$iv$iv);
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getFilename());
            }
            if (((List)destination$iv$iv).contains(file.name())) continue;
            String text2 = "File " + file.name() + " is in the jsons folder but is not a recognized ruleset file";
            Intrinsics.checkNotNullExpressionValue(file.name(), "name(...)");
            $this$mapTo$iv$iv2 = RulesetFile.getEntries();
            object = this;
            boolean $i$f$map2 = false;
            void $i$f$mapTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RulesetFile rulesetFile = (RulesetFile)((Object)item$iv$iv);
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getFilename());
            }
            collection = (List)destination$iv$iv2;
            List<String> possibleMisspellings = super.getPossibleMisspellings(string, (List<String>)collection);
            if (!((Collection)possibleMisspellings).isEmpty()) {
                text2 = text2 + "\nPossible misspelling of: " + CollectionsKt.joinToString$default(possibleMisspellings, "/", null, null, 0, null, null, 62, null);
            }
            RulesetErrorList.add$default(lines2, text2, RulesetErrorSeverity.OK, null, null, 12, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addModOptionsErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        List<Unique> mapSelectUniques;
        Object[] it;
        int n;
        this.uniqueValidator.checkUniques(this.ruleset.getModOptions(), lines2, true, tryFixUnknownUniques);
        if (StringsKt.isBlank(this.ruleset.getName())) {
            return;
        }
        UniqueType[] uniqueTypeArray = new UniqueType[]{UniqueType.ModIsAudioVisual, UniqueType.ModIsAudioVisualOnly, UniqueType.ModIsNotAudioVisual};
        Set<UniqueType> audioVisualUniqueTypes = SetsKt.setOf(uniqueTypeArray);
        Iterable $this$count$iv = this.ruleset.getModOptions().getUniqueObjects();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Object[])element$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)audioVisualUniqueTypes, it.getType()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n > 1) {
            RulesetErrorList.add$default(lines2, "A mod should only specify one of the 'can/should/cannot be used as permanent audiovisual mod' options.", null, null, null, 10, null);
        }
        if ((mapSelectUniques = SequencesKt.toList(IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)this.ruleset.getModOptions(), UniqueType.ModMapPreselection, null, 2, null))).size() > 1) {
            RulesetErrorList.add$default(lines2, "Specifying more than one map as preselection makes no sense", RulesetErrorSeverity.WarningOptionsOnly, null, null, 8, null);
        }
        if (!((Collection)mapSelectUniques).isEmpty()) {
            FileHandle mapsFolder = UncivGame.Companion.getCurrent().getFiles().getModFolder(this.ruleset.getName()).child("maps");
            if (mapsFolder.exists()) {
                void $this$mapTo$iv$iv;
                FileHandle[] fileHandleArray = mapsFolder.list();
                Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
                Object[] $this$map$iv = fileHandleArray;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    FileHandle fileHandle = (FileHandle)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it2.name();
                    Intrinsics.checkNotNullExpressionValue(string, "name(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                    collection.add(string2);
                }
                List maps = (List)destination$iv$iv;
                for (Unique unique : mapSelectUniques) {
                    String string = unique.getParams().get(0).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                    if (maps.contains(string)) continue;
                    RulesetErrorList.add$default(lines2, "Mod names map '" + unique.getParams().get(0) + "' as preselection, which does not exist.", RulesetErrorSeverity.WarningOptionsOnly, null, null, 8, null);
                }
            } else {
                RulesetErrorList.add$default(lines2, "Mod option for map preselection exists but Mod has no 'maps' folder.", RulesetErrorSeverity.WarningOptionsOnly, null, null, 8, null);
            }
        }
        if (!this.ruleset.getModOptions().isBaseRuleset()) {
            return;
        }
        Iterator iterator2 = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)this.ruleset.getModOptions(), UniqueType.ModRequires, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            RulesetErrorList.add$default(lines2, "Mod option '" + unique.getText() + "' is invalid for a base ruleset.", null, null, null, 10, null);
        }
    }

    private final void addCityStateTypeErrors(boolean tryFixUnknownUniques, RulesetErrorList lines2) {
        for (CityStateType cityStateType2 : this.ruleset.getCityStateTypes().values()) {
            Iterator<Unique> iterator2 = SequencesKt.plus(cityStateType2.getAllyBonusUniqueMap().getAllUniques(), cityStateType2.getFriendBonusUniqueMap().getAllUniques()).iterator();
            while (iterator2.hasNext()) {
                Unique unique = iterator2.next();
                RulesetErrorList errors = this.uniqueValidator.checkUnique(unique, tryFixUnknownUniques, null, true);
                lines2.addAll(errors);
            }
        }
    }

    private final void addDifficultyErrors(RulesetErrorList lines2) {
        for (Difficulty difficulty : this.ruleset.getDifficulties().values()) {
            for (String unitName : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)difficulty.getAiCityStateBonusStartingUnits(), (Iterable)difficulty.getAiMajorCivBonusStartingUnits()), (Iterable)difficulty.getPlayerBonusStartingUnits())) {
                if (Intrinsics.areEqual(unitName, "Era Starting Unit") || this.ruleset.getUnits().containsKey(unitName)) continue;
                RulesetErrorList.add$default(lines2, "Difficulty " + difficulty.getName() + " contains starting unit " + unitName + " which does not exist!", null, null, null, 10, null);
            }
        }
    }

    private final void addEventErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Event event : this.ruleset.getEvents().values()) {
            for (EventChoice choice2 : event.getChoices()) {
                Intrinsics.checkNotNull(choice2);
                this.uniqueValidator.checkUniques(choice2, lines2, true, tryFixUnknownUniques);
            }
            Intrinsics.checkNotNull(event);
            this.uniqueValidator.checkUniques(event, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addVictoryTypeErrors(RulesetErrorList lines2) {
        for (Victory victoryType : this.ruleset.getVictories().values()) {
            for (String requiredUnit : victoryType.getRequiredSpaceshipParts()) {
                Map map2 = this.ruleset.getUnits();
                Intrinsics.checkNotNull(requiredUnit);
                if (map2.containsKey(requiredUnit)) continue;
                RulesetErrorList.add$default(lines2, "Victory type " + victoryType.getName() + " requires adding the non-existant unit " + requiredUnit + " to the capital to win!", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
            for (Milestone milestone : victoryType.getMilestoneObjects()) {
                MilestoneType[] milestoneTypeArray;
                if (milestone.getType() == null) {
                    RulesetErrorList.add$default(lines2, "Victory type " + victoryType.getName() + " has milestone \"" + milestone.getUniqueDescription() + "\" that is of an unknown type!", RulesetErrorSeverity.Error, null, null, 8, null);
                }
                if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf(milestoneTypeArray = new MilestoneType[]{MilestoneType.BuiltBuilding, MilestoneType.BuildingBuiltGlobally}), milestone.getType()) || ((Map)this.ruleset.getBuildings()).containsKey(milestone.getParams().get(0))) continue;
                RulesetErrorList.add$default(lines2, "Victory type " + victoryType.getName() + " has milestone \"" + milestone.getUniqueDescription() + "\" that references an unknown building " + milestone.getParams().get(0) + '!', RulesetErrorSeverity.Error, null, null, 12, null);
            }
            for (Victory victory : this.ruleset.getVictories().values()) {
                if (Intrinsics.areEqual(victory.getName(), victoryType.getName()) || !Intrinsics.areEqual(victory.getMilestones(), victoryType.getMilestones())) continue;
                RulesetErrorList.add$default(lines2, "Victory types " + victoryType.getName() + " and " + victory.getName() + " have the same requirements!", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
        }
    }

    private final void addUnitTypeErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (UnitType unitType2 : this.ruleset.getUnitTypes().values()) {
            if (!CollectionsKt.contains((Iterable)this.unitMovementTypes, unitType2.getMovementType$core())) {
                RulesetErrorList.add$default(lines2, "Unit type " + unitType2.getName() + " has an invalid movement type " + unitType2.getMovementType$core(), null, unitType2, null, 10, null);
            }
            Intrinsics.checkNotNull(unitType2);
            this.uniqueValidator.checkUniques(unitType2, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addPromotionErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Promotion promotion2 : this.ruleset.getUnitPromotions().values()) {
            Intrinsics.checkNotNull(promotion2);
            this.addPromotionErrorRulesetInvariant(promotion2, lines2);
            for (String prereq : promotion2.getPrerequisites()) {
                if (this.ruleset.getUnitPromotions().containsKey(prereq)) continue;
                RulesetErrorList.add$default(lines2, promotion2.getName() + " requires promotion " + prereq + " which does not exist!", RulesetErrorSeverity.Warning, promotion2, null, 8, null);
            }
            for (String unitType2 : promotion2.getUnitTypes()) {
                this.checkUnitType(unitType2, new Function0<Unit>(lines2, promotion2, unitType2){
                    final /* synthetic */ RulesetErrorList $lines;
                    final /* synthetic */ Promotion $promotion;
                    final /* synthetic */ String $unitType;
                    {
                        this.$lines = $lines;
                        this.$promotion = $promotion;
                        this.$unitType = $unitType;
                        super(0);
                    }

                    public final void invoke() {
                        RulesetErrorList.add$default(this.$lines, this.$promotion.getName() + " references unit type " + this.$unitType + ", which does not exist!", RulesetErrorSeverity.Warning, this.$promotion, null, 8, null);
                    }
                });
            }
            this.uniqueValidator.checkUniques(promotion2, lines2, true, tryFixUnknownUniques);
        }
        this.checkPromotionCircularReferences(lines2);
    }

    private final void addRuinsErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (RuinReward reward : this.ruleset.getRuinRewards().values()) {
            if (reward.getWeight() < 0) {
                RulesetErrorList.add$default(lines2, reward.getName() + " has a negative weight, which is not allowed!", null, reward, null, 10, null);
            }
            for (String difficulty : reward.getExcludedDifficulties()) {
                if (this.ruleset.getDifficulties().containsKey(difficulty)) continue;
                RulesetErrorList.add$default(lines2, reward.getName() + " references difficulty " + difficulty + ", which does not exist!", null, reward, null, 10, null);
            }
            Intrinsics.checkNotNull(reward);
            this.uniqueValidator.checkUniques(reward, lines2, true, tryFixUnknownUniques);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addPolicyErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        void $this$flatMapTo$iv$iv;
        Iterator<Policy> prereq22;
        for (Policy policy2 : this.ruleset.getPolicies().values()) {
            ArrayList<String> arrayList = policy2.getRequires();
            for (Iterator<Policy> prereq22 : arrayList != null ? (List<Iterator<Policy>>)arrayList : CollectionsKt.emptyList()) {
                if (this.ruleset.getPolicies().containsKey(prereq22)) continue;
                RulesetErrorList.add$default(lines2, policy2.getName() + " requires policy " + prereq22 + " which does not exist!", null, policy2, null, 10, null);
            }
            Intrinsics.checkNotNull(policy2);
            this.uniqueValidator.checkUniques(policy2, lines2, true, tryFixUnknownUniques);
        }
        for (PolicyBranch branch : this.ruleset.getPolicyBranches().values()) {
            if (!((Map)this.ruleset.getEras()).containsKey(branch.getEra())) {
                RulesetErrorList.add$default(lines2, branch.getName() + " requires era " + branch.getEra() + " which does not exist!", null, branch, null, 10, null);
            }
            HashMap policyLocations = new HashMap();
            for (Policy policy3 : branch.getPolicies()) {
                String policyLocation = "" + policy3.getRow() + '/' + policy3.getColumn();
                Policy existingPolicyInLocation = (Policy)policyLocations.get(policyLocation);
                if (existingPolicyInLocation == null) {
                    Map map2 = policyLocations;
                    Intrinsics.checkNotNull(policy3);
                    map2.put(policyLocation, policy3);
                    continue;
                }
                RulesetErrorList.add$default(lines2, "Policies " + policy3.getName() + " and " + existingPolicyInLocation.getName() + " in branch " + branch.getName() + " are both located at column " + policy3.getColumn() + " row " + policy3.getRow() + '!', null, policy3, null, 10, null);
            }
        }
        Collection<PolicyBranch> collection = this.ruleset.getPolicyBranches().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        prereq22 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PolicyBranch it = (PolicyBranch)element$iv$iv;
            boolean bl = false;
            Collection collection2 = it.getPolicies();
            Intrinsics.checkNotNull(it);
            Iterable list$iv$iv = CollectionsKt.plus(collection2, it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        for (Policy policy2 : (List)destination$iv$iv) {
            if (Intrinsics.areEqual(policy2, this.ruleset.getPolicies().get(policy2.getName()))) continue;
            RulesetErrorList.add$default(lines2, "More than one policy with the name " + policy2.getName() + " exists!", null, policy2, null, 10, null);
        }
    }

    private final void addNationErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Nation nation2 : this.ruleset.getNations().values()) {
            Intrinsics.checkNotNull(nation2);
            this.addNationErrorRulesetInvariant(nation2, lines2);
            this.uniqueValidator.checkUniques(nation2, lines2, true, tryFixUnknownUniques);
            if (!Intrinsics.areEqual(nation2.getPreferredVictoryType(), "Neutral") && !((Map)this.ruleset.getVictories()).containsKey(nation2.getPreferredVictoryType())) {
                RulesetErrorList.add$default(lines2, nation2.getName() + "'s preferredVictoryType is " + nation2.getPreferredVictoryType() + " which does not exist!", null, nation2, null, 10, null);
            }
            if (nation2.getCityStateType() != null && !((Map)this.ruleset.getCityStateTypes()).containsKey(nation2.getCityStateType())) {
                RulesetErrorList.add$default(lines2, nation2.getName() + " is of city-state type " + nation2.getCityStateType() + " which does not exist!", null, nation2, null, 10, null);
            }
            if (nation2.getFavoredReligion() == null || CollectionsKt.contains((Iterable)this.ruleset.getReligions(), nation2.getFavoredReligion())) continue;
            RulesetErrorList.add$default(lines2, nation2.getName() + " has " + nation2.getFavoredReligion() + " as their favored religion, which does not exist!", null, nation2, null, 10, null);
        }
    }

    private final void addBeliefErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Belief belief2 : this.ruleset.getBeliefs().values()) {
            if (belief2.getType() == BeliefType.Any || belief2.getType() == BeliefType.None) {
                RulesetErrorList.add$default(lines2, belief2.getName() + " type is " + (Object)((Object)belief2.getType()) + ", which is not allowed!", null, belief2, null, 10, null);
            }
            Intrinsics.checkNotNull(belief2);
            this.uniqueValidator.checkUniques(belief2, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addSpeedErrors(RulesetErrorList lines2) {
        for (Speed speed : this.ruleset.getSpeeds().values()) {
            if (speed.getModifier() < 0.0f) {
                RulesetErrorList.add$default(lines2, "Negative speed modifier for game speed " + speed.getName(), null, speed, null, 10, null);
            }
            if (!speed.getYearsPerTurn().isEmpty()) continue;
            RulesetErrorList.add$default(lines2, "Empty turn increment list for game speed " + speed.getName(), null, speed, null, 10, null);
        }
    }

    private final void addPersonalityErrors(RulesetErrorList lines2) {
        for (Personality personality : this.ruleset.getPersonalities().values()) {
            if (Intrinsics.areEqual(personality.getPreferredVictoryType(), "Neutral") || ((Map)this.ruleset.getVictories()).containsKey(personality.getPreferredVictoryType())) continue;
            RulesetErrorList.add$default(lines2, "Preferred victory type " + personality.getPreferredVictoryType() + " does not exist in ruleset", RulesetErrorSeverity.Warning, personality, null, 8, null);
        }
    }

    private final void addEraErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        if (this.ruleset.getEras().isEmpty()) {
            RulesetErrorList.add$default(lines2, "Eras file is empty! This will likely lead to crashes. Ask the mod maker to update this mod!", null, null, null, 10, null);
        }
        HashSet allDifficultiesStartingUnits = new HashSet();
        for (Difficulty difficulty : this.ruleset.getDifficulties().values()) {
            allDifficultiesStartingUnits.addAll(difficulty.getAiCityStateBonusStartingUnits());
            allDifficultiesStartingUnits.addAll(difficulty.getAiMajorCivBonusStartingUnits());
            allDifficultiesStartingUnits.addAll(difficulty.getPlayerBonusStartingUnits());
        }
        for (Era era2 : this.ruleset.getEras().values()) {
            boolean grantsStartingMilitaryUnit;
            BaseUnit it;
            Iterable $this$none$iv;
            for (String wonder : era2.getStartingObsoleteWonders()) {
                Map map2 = this.ruleset.getBuildings();
                Intrinsics.checkNotNull(wonder);
                if (map2.containsKey(wonder)) continue;
                RulesetErrorList.add$default(lines2, "Nonexistent wonder " + wonder + " obsoleted when starting in " + era2.getName() + '!', null, era2, null, 10, null);
            }
            for (String building : era2.getSettlerBuildings()) {
                Map map3 = this.ruleset.getBuildings();
                Intrinsics.checkNotNull(building);
                if (map3.containsKey(building)) continue;
                RulesetErrorList.add$default(lines2, "Nonexistent building " + building + " built by settlers when starting in " + era2.getName(), null, era2, null, 10, null);
            }
            if (!((Map)this.ruleset.getUnits()).containsKey(era2.getStartingSettlerUnit())) {
                boolean bl;
                block20: {
                    Collection<BaseUnit> collection = this.ruleset.getUnits().values();
                    Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                    $this$none$iv = collection;
                    boolean $i$f$none = false;
                    if (((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (BaseUnit)element$iv;
                            boolean bl2 = false;
                            if (!it.isCityFounder()) continue;
                            bl = false;
                            break block20;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    RulesetErrorList.add$default(lines2, "Nonexistent unit " + era2.getStartingSettlerUnit() + " marked as starting unit when starting in " + era2.getName(), null, era2, null, 10, null);
                }
            }
            if (era2.getStartingWorkerCount() != 0 && !((Map)this.ruleset.getUnits()).containsKey(era2.getStartingWorkerUnit())) {
                boolean bl;
                block21: {
                    Collection<BaseUnit> collection = this.ruleset.getUnits().values();
                    Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                    $this$none$iv = collection;
                    boolean $i$f$none = false;
                    if (((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (BaseUnit)element$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull(it);
                            if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.BuildImprovements, null, 2, null)) continue;
                            bl = false;
                            break block21;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    RulesetErrorList.add$default(lines2, "Nonexistent unit " + era2.getStartingWorkerUnit() + " marked as starting unit when starting in " + era2.getName(), null, era2, null, 10, null);
                }
            }
            boolean bl = grantsStartingMilitaryUnit = era2.getStartingMilitaryUnitCount() != 0 || allDifficultiesStartingUnits.contains("Era Starting Unit");
            if (grantsStartingMilitaryUnit && !((Map)this.ruleset.getUnits()).containsKey(era2.getStartingMilitaryUnit())) {
                RulesetErrorList.add$default(lines2, "Nonexistent unit " + era2.getStartingMilitaryUnit() + " marked as starting unit when starting in " + era2.getName(), null, era2, null, 10, null);
            }
            if (era2.getResearchAgreementCost() < 0 || era2.getStartingSettlerCount() < 0 || era2.getStartingWorkerCount() < 0 || era2.getStartingMilitaryUnitCount() < 0 || era2.getStartingGold() < 0 || era2.getStartingCulture() < 0) {
                RulesetErrorList.add$default(lines2, "Unexpected negative number found while parsing era " + era2.getName(), null, era2, null, 10, null);
            }
            if (era2.getSettlerPopulation() <= 0) {
                RulesetErrorList.add$default(lines2, "Population in cities from settlers must be strictly positive! Found value " + era2.getSettlerPopulation() + " for era " + era2.getName(), null, era2, null, 10, null);
            }
            if (!((Map)era2.getAllyBonus()).isEmpty()) {
                RulesetErrorList.add$default(lines2, "Era " + era2.getName() + " contains city-state bonuses. City-state bonuses are now defined in CityStateType.json", RulesetErrorSeverity.WarningOptionsOnly, era2, null, 8, null);
            }
            if (!((Map)era2.getFriendBonus()).isEmpty()) {
                RulesetErrorList.add$default(lines2, "Era " + era2.getName() + " contains city-state bonuses. City-state bonuses are now defined in CityStateType.json", RulesetErrorSeverity.WarningOptionsOnly, era2, null, 8, null);
            }
            Intrinsics.checkNotNull(era2);
            this.uniqueValidator.checkUniques(era2, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addTechErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Technology tech : this.ruleset.getTechnologies().values()) {
            for (String prereq : tech.getPrerequisites()) {
                boolean bl;
                block8: {
                    if (!this.ruleset.getTechnologies().containsKey(prereq)) {
                        RulesetErrorList.add$default(lines2, tech.getName() + " requires tech " + prereq + " which does not exist!", null, tech, null, 10, null);
                    }
                    Iterable $this$any$iv = tech.getPrerequisites();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!(!Intrinsics.areEqual(it, prereq) && this.getPrereqTree(it).contains(prereq))) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    RulesetErrorList.add$default(lines2, "No need to add " + prereq + " as a prerequisite of " + tech.getName() + " - it is already implicit from the other prerequisites!", RulesetErrorSeverity.Warning, tech, null, 8, null);
                }
                Intrinsics.checkNotNull(prereq);
                if (!this.getPrereqTree(prereq).contains(tech.getName())) continue;
                RulesetErrorList.add$default(lines2, "Techs " + tech.getName() + " and " + prereq + " require each other!", null, tech, null, 10, null);
            }
            if (!((Map)this.ruleset.getEras()).containsKey(tech.era())) {
                RulesetErrorList.add$default(lines2, "Unknown era " + tech.era() + " referenced in column of tech " + tech.getName(), null, tech, null, 10, null);
            }
            Intrinsics.checkNotNull(tech);
            this.uniqueValidator.checkUniques(tech, lines2, true, tryFixUnknownUniques);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void addTerrainErrors(RulesetErrorList lines, boolean tryFixUnknownUniques) {
        block11: {
            block12: {
                v0 = this.ruleset.getTerrains().values();
                Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
                $this$none$iv = v0;
                $i$f$none = false;
                if (!((Collection)$this$none$iv).isEmpty()) break block12;
                v1 = true;
                break block11;
            }
            for (T element$iv : $this$none$iv) {
                it = (Terrain)element$iv;
                $i$a$-none-RulesetValidator$addTerrainErrors$1 = false;
                if (it.getType() != TerrainType.Land || it.getImpassable()) ** GOTO lbl-1000
                Intrinsics.checkNotNull(it);
                if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.NoNaturalGeneration, null, 2, null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v1 = false;
                break block11;
            }
            v1 = true;
        }
        if (v1) {
            RulesetErrorList.add$default(lines, "No passable land terrains exist!", null, null, null, 10, null);
        }
        for (Terrain terrain : this.ruleset.getTerrains().values()) {
            for (String baseTerrainName : terrain.getOccursOn()) {
                baseTerrain = this.ruleset.getTerrains().get(baseTerrainName);
                if (baseTerrain == null) {
                    RulesetErrorList.add$default(lines, terrain.getName() + " occurs on terrain " + baseTerrainName + " which does not exist!", null, terrain, null, 10, null);
                    continue;
                }
                if (baseTerrain.getType() != TerrainType.NaturalWonder) continue;
                RulesetErrorList.add$default(lines, terrain.getName() + " occurs on natural wonder " + baseTerrainName + ": Unsupported.", RulesetErrorSeverity.WarningOptionsOnly, terrain, null, 8, null);
            }
            if (terrain.getType() == TerrainType.NaturalWonder && terrain.getTurnsInto() != null) {
                baseTerrain = (Terrain)((Map)this.ruleset.getTerrains()).get(terrain.getTurnsInto());
                if (baseTerrain == null) {
                    RulesetErrorList.add$default(lines, terrain.getName() + " turns into terrain " + terrain.getTurnsInto() + " which does not exist!", null, terrain, null, 10, null);
                } else if (!baseTerrain.getType().isBaseTerrain()) {
                    RulesetErrorList.add$default(lines, terrain.getName() + " turns into terrain " + terrain.getTurnsInto() + " which is not a base terrain!", RulesetErrorSeverity.Warning, terrain, null, 8, null);
                }
            }
            Intrinsics.checkNotNull(terrain);
            this.uniqueValidator.checkUniques(terrain, lines, true, tryFixUnknownUniques);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addImprovementErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (TileImprovement improvement2 : this.ruleset.getTileImprovements().values()) {
            boolean hasPillageUnique;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterator item$iv$iv2;
            Collection destination$iv$iv;
            if (improvement2.getTechRequired() != null) {
                LinkedHashMap<String, Technology> linkedHashMap = this.ruleset.getTechnologies();
                String string = improvement2.getTechRequired();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, improvement2.getName() + " requires tech " + improvement2.getTechRequired() + " which does not exist!", null, improvement2, null, 10, null);
                }
            }
            if (improvement2.getReplaces() != null && !((Map)this.ruleset.getTileImprovements()).containsKey(improvement2.getReplaces())) {
                RulesetErrorList.add$default(lines2, improvement2.getName() + " replaces " + improvement2.getReplaces() + " which does not exist!", null, improvement2, null, 10, null);
            }
            if (improvement2.getReplaces() != null && improvement2.getUniqueTo() == null) {
                RulesetErrorList.add$default(lines2, improvement2.getName() + " should replace " + improvement2.getReplaces() + " but does not have uniqueTo assigned!", null, null, null, 14, null);
            }
            Intrinsics.checkNotNull(improvement2);
            this.checkUniqueToMisspelling(improvement2, improvement2.getUniqueTo(), lines2);
            for (String terrain2 : improvement2.getTerrainsCanBeBuiltOn()) {
                if (this.ruleset.getTerrains().containsKey(terrain2) || Intrinsics.areEqual(terrain2, "Land") || Intrinsics.areEqual(terrain2, "Water")) continue;
                RulesetErrorList.add$default(lines2, improvement2.getName() + " can be built on terrain " + terrain2 + " which does not exist!", null, improvement2, null, 10, null);
            }
            if (improvement2.getTerrainsCanBeBuiltOn().isEmpty() && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)improvement2, UniqueType.CanOnlyImproveResource, null, 2, null) && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)improvement2, UniqueType.Unbuildable, null, 2, null) && !StringsKt.startsWith$default(improvement2.getName(), "Remove ", false, 2, null)) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = RoadStatus.getEntries();
                boolean $i$f$map = false;
                Object object = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Iterator item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    RoadStatus roadStatus = (RoadStatus)((Object)item$iv$iv2);
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getRemoveAction());
                }
                if (!((List)destination$iv$iv).contains(improvement2.getName()) && !Intrinsics.areEqual(improvement2.getName(), "Cancel improvement order")) {
                    RulesetErrorList.add$default(lines2, improvement2.getName() + " has an empty `terrainsCanBeBuiltOn`, isn't allowed to only improve resources. As such it isn't buildable! Either give this the unique \"Unbuildable\", \"Can only be built to improve a resource\", or add \"Land\", \"Water\" or any other value to `terrainsCanBeBuiltOn`.", RulesetErrorSeverity.Warning, improvement2, null, 8, null);
                }
            }
            Iterable $i$f$map = improvement2.getUniqueObjects();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            item$iv$iv2 = $this$filterTo$iv$iv.iterator();
            while (item$iv$iv2.hasNext()) {
                Object element$iv$iv = item$iv$iv2.next();
                Unique it = (Unique)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == UniqueType.PillageYieldRandom || it.getType() == UniqueType.PillageYieldFixed)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (Unique unique : (List)destination$iv$iv2) {
                boolean bl;
                block13: {
                    if (!Stats.Companion.isStats(unique.getParams().get(0))) continue;
                    Stats params = Stats.Companion.parse(unique.getParams().get(0));
                    Sequence<Float> $this$any$iv = params.getValues();
                    boolean $i$f$any = false;
                    Iterator<Float> iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        Float element$iv = iterator2.next();
                        float it = ((Number)element$iv).floatValue();
                        boolean bl2 = false;
                        if (!(it < 0.0f)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
                if (!bl) continue;
                RulesetErrorList.add$default(lines2, improvement2.getName() + " cannot have a negative value for a pillage yield!", RulesetErrorSeverity.Error, improvement2, null, 8, null);
            }
            boolean bl = hasPillageUnique = improvement2.hasUnique(UniqueType.PillageYieldRandom, StateForConditionals.Companion.getIgnoreConditionals()) || improvement2.hasUnique(UniqueType.PillageYieldFixed, StateForConditionals.Companion.getIgnoreConditionals());
            if (hasPillageUnique && improvement2.hasUnique(UniqueType.Unpillagable, StateForConditionals.Companion.getIgnoreConditionals())) {
                RulesetErrorList.add$default(lines2, improvement2.getName() + " has both an `Unpillagable` unique type and a `PillageYieldRandom` or `PillageYieldFixed` unique type!", RulesetErrorSeverity.Warning, improvement2, null, 8, null);
            }
            this.uniqueValidator.checkUniques(improvement2, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addResourceErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (TileResource resource2 : this.ruleset.getTileResources().values()) {
            if (resource2.getRevealedBy() != null) {
                LinkedHashMap<String, Technology> linkedHashMap = this.ruleset.getTechnologies();
                String string = resource2.getRevealedBy();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, resource2.getName() + " revealed by tech " + resource2.getRevealedBy() + " which does not exist!", null, resource2, null, 10, null);
                }
            }
            if (resource2.getImprovement() != null) {
                LinkedHashMap<String, TileImprovement> linkedHashMap = this.ruleset.getTileImprovements();
                String string = resource2.getImprovement();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, resource2.getName() + " improved by improvement " + resource2.getImprovement() + " which does not exist!", null, resource2, null, 10, null);
                }
            }
            for (String improvement2 : resource2.getImprovedBy()) {
                if (this.ruleset.getTileImprovements().containsKey(improvement2)) continue;
                RulesetErrorList.add$default(lines2, resource2.getName() + " improved by improvement " + improvement2 + " which does not exist!", null, resource2, null, 10, null);
            }
            for (String terrain2 : resource2.getTerrainsCanBeFoundOn()) {
                if (this.ruleset.getTerrains().containsKey(terrain2)) continue;
                RulesetErrorList.add$default(lines2, resource2.getName() + " can be found on terrain " + terrain2 + " which does not exist!", null, resource2, null, 10, null);
            }
            Intrinsics.checkNotNull(resource2);
            this.uniqueValidator.checkUniques(resource2, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addSpecialistErrors(RulesetErrorList lines2) {
        for (Specialist specialist : this.ruleset.getSpecialists().values()) {
            for (Map.Entry gpp : ((Map)specialist.getGreatPersonPoints()).entrySet()) {
                if (((Map)this.ruleset.getUnits()).containsKey(gpp.getKey())) continue;
                RulesetErrorList.add$default(lines2, "Specialist " + specialist.getName() + " has greatPersonPoints for " + (String)gpp.getKey() + ", which is not a unit in the ruleset!", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
        }
    }

    private final void addBuildingErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Building building : this.ruleset.getBuildings().values()) {
            Intrinsics.checkNotNull(building);
            this.addBuildingErrorRulesetInvariant(building, lines2);
            Iterator<String> iterator2 = building.requiredTechs().iterator();
            while (iterator2.hasNext()) {
                String requiredTech = iterator2.next();
                if (this.ruleset.getTechnologies().containsKey(requiredTech)) continue;
                RulesetErrorList.add$default(lines2, building.getName() + " requires tech " + requiredTech + " which does not exist!", null, building, null, 10, null);
            }
            for (String specialistName : building.getSpecialistSlots().keySet()) {
                if (this.ruleset.getSpecialists().containsKey(specialistName)) continue;
                RulesetErrorList.add$default(lines2, building.getName() + " provides specialist " + specialistName + " which does not exist!", null, building, null, 10, null);
            }
            for (String resource2 : building.getResourceRequirementsPerTurn(StateForConditionals.Companion.getIgnoreConditionals()).keySet()) {
                if (this.ruleset.getTileResources().containsKey(resource2)) continue;
                RulesetErrorList.add$default(lines2, building.getName() + " requires resource " + resource2 + " which does not exist!", null, building, null, 10, null);
            }
            if (building.getReplaces() != null) {
                LinkedHashMap<String, Building> linkedHashMap = this.ruleset.getBuildings();
                String string = building.getReplaces();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, building.getName() + " replaces " + building.getReplaces() + " which does not exist!", null, building, null, 10, null);
                }
            }
            if (building.getRequiredBuilding() != null) {
                LinkedHashMap<String, Building> linkedHashMap = this.ruleset.getBuildings();
                String string = building.getRequiredBuilding();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, building.getName() + " requires " + building.getRequiredBuilding() + " which does not exist!", null, building, null, 10, null);
                }
            }
            this.checkUniqueToMisspelling(building, building.getUniqueTo(), lines2);
            this.uniqueValidator.checkUniques(building, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addGlobalUniqueErrors(RulesetErrorList lines2, boolean reportRulesetSpecificErrors, boolean tryFixUnknownUniques) {
        this.uniqueValidator.checkUniques(this.ruleset.getGlobalUniques(), lines2, reportRulesetSpecificErrors, tryFixUnknownUniques);
        IHasUniques fakeUniqueContainer2 = new IHasUniques(){
            @NotNull
            private ArrayList<String> uniques;
            @NotNull
            private final List<Unique> uniqueObjects;
            @NotNull
            private final UniqueMap uniqueMap;
            @NotNull
            private String name;
            {
                this.uniques = new ArrayList<E>();
                this.uniqueObjects = CollectionsKt.emptyList();
                this.uniqueMap = UniqueMap.Companion.getEMPTY();
                this.name = "Global unit uniques";
            }

            @NotNull
            public ArrayList<String> getUniques() {
                return this.uniques;
            }

            public void setUniques(@NotNull ArrayList<String> arrayList) {
                Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
                this.uniques = arrayList;
            }

            @NotNull
            public List<Unique> getUniqueObjects() {
                return this.uniqueObjects;
            }

            @NotNull
            public UniqueMap getUniqueMap() {
                return this.uniqueMap;
            }

            @NotNull
            public UniqueTarget getUniqueTarget() {
                return UniqueTarget.Unit;
            }

            @NotNull
            public String getName() {
                return this.name;
            }

            public void setName(@NotNull String string) {
                Intrinsics.checkNotNullParameter(string, "<set-?>");
                this.name = string;
            }

            @NotNull
            public List<Unique> uniqueObjectsProvider() {
                return IHasUniques.DefaultImpls.uniqueObjectsProvider(this);
            }

            @NotNull
            public List<Unique> uniqueObjectsProvider(@NotNull List<String> uniques2) {
                return IHasUniques.DefaultImpls.uniqueObjectsProvider(this, uniques2);
            }

            @NotNull
            public UniqueMap uniqueMapProvider() {
                return IHasUniques.DefaultImpls.uniqueMapProvider(this);
            }

            @NotNull
            public UniqueMap uniqueMapProvider(@NotNull List<Unique> uniqueObjects2) {
                return IHasUniques.DefaultImpls.uniqueMapProvider(this, uniqueObjects2);
            }

            @NotNull
            public Sequence<Unique> getMatchingUniques(@NotNull UniqueType uniqueType, @NotNull StateForConditionals state) {
                return IHasUniques.DefaultImpls.getMatchingUniques((IHasUniques)this, uniqueType, state);
            }

            @NotNull
            public Sequence<Unique> getMatchingUniques(@NotNull String uniqueTag, @NotNull StateForConditionals state) {
                return IHasUniques.DefaultImpls.getMatchingUniques((IHasUniques)this, uniqueTag, state);
            }

            public boolean hasUnique(@NotNull UniqueType uniqueType, @Nullable StateForConditionals state) {
                return IHasUniques.DefaultImpls.hasUnique((IHasUniques)this, uniqueType, state);
            }

            public boolean hasUnique(@NotNull String uniqueTag, @Nullable StateForConditionals state) {
                return IHasUniques.DefaultImpls.hasUnique((IHasUniques)this, uniqueTag, state);
            }

            public boolean hasTagUnique(@NotNull String tagUnique) {
                return IHasUniques.DefaultImpls.hasTagUnique(this, tagUnique);
            }

            @NotNull
            public Sequence<Unique> availabilityUniques() {
                return IHasUniques.DefaultImpls.availabilityUniques(this);
            }

            @NotNull
            public Sequence<String> techsRequiredByUniques() {
                return IHasUniques.DefaultImpls.techsRequiredByUniques(this);
            }

            @NotNull
            public Sequence<String> legacyRequiredTechs() {
                return IHasUniques.DefaultImpls.legacyRequiredTechs(this);
            }

            @NotNull
            public Sequence<String> requiredTechs() {
                return IHasUniques.DefaultImpls.requiredTechs(this);
            }

            @NotNull
            public Sequence<Technology> requiredTechnologies(@NotNull Ruleset ruleset2) {
                return IHasUniques.DefaultImpls.requiredTechnologies(this, ruleset2);
            }

            @Nullable
            public Era era(@NotNull Ruleset ruleset2) {
                return IHasUniques.DefaultImpls.era(this, ruleset2);
            }

            @Nullable
            public TechColumn techColumn(@NotNull Ruleset ruleset2) {
                return IHasUniques.DefaultImpls.techColumn(this, ruleset2);
            }

            public boolean availableInEra(@NotNull Ruleset ruleset2, @NotNull String requestedEra) {
                return IHasUniques.DefaultImpls.availableInEra(this, ruleset2, requestedEra);
            }

            public float getWeightForAiDecision(@NotNull StateForConditionals stateForConditionals) {
                return IHasUniques.DefaultImpls.getWeightForAiDecision(this, stateForConditionals);
            }

            public boolean isUnavailableBySettings(@NotNull GameInfo gameInfo) {
                return IHasUniques.DefaultImpls.isUnavailableBySettings(this, gameInfo);
            }

            public boolean isHiddenFromCivilopedia(@Nullable GameInfo gameInfo, @Nullable Ruleset ruleset2) {
                return IHasUniques.DefaultImpls.isHiddenFromCivilopedia(this, gameInfo, ruleset2);
            }

            public boolean isHiddenFromCivilopedia(@NotNull Ruleset ruleset2) {
                return IHasUniques.DefaultImpls.isHiddenFromCivilopedia(this, ruleset2);
            }
        };
        for (String uniqueText : this.ruleset.getGlobalUniques().getUnitUniques()) {
            Intrinsics.checkNotNull(uniqueText);
            Unique unique = new Unique(uniqueText, null, null, 6, null);
            RulesetErrorList errors = this.uniqueValidator.checkUnique(unique, tryFixUnknownUniques, fakeUniqueContainer2, reportRulesetSpecificErrors);
            lines2.addAll(errors);
        }
    }

    private final void addUnitErrorsRulesetInvariant(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (BaseUnit unit : this.ruleset.getUnits().values()) {
            Intrinsics.checkNotNull(unit);
            this.checkUnitRulesetInvariant(unit, lines2);
            this.uniqueValidator.checkUniques(unit, lines2, false, tryFixUnknownUniques);
        }
    }

    private final void addUnitErrorsBaseRuleset(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        boolean bl;
        block5: {
            Collection<BaseUnit> collection = this.ruleset.getUnits().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$none$iv = collection;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    BaseUnit it = (BaseUnit)element$iv;
                    boolean bl2 = false;
                    if (!it.isCityFounder()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            RulesetErrorList.add$default(lines2, "No city-founding units in ruleset!", null, null, null, 10, null);
        }
        for (BaseUnit unit : this.ruleset.getUnits().values()) {
            Intrinsics.checkNotNull(unit);
            this.checkUnitRulesetInvariant(unit, lines2);
            this.checkUnitRulesetSpecific(unit, lines2);
            this.uniqueValidator.checkUniques(unit, lines2, true, tryFixUnknownUniques);
            this.checkUniqueToMisspelling(unit, unit.getUniqueTo(), lines2);
        }
    }

    private final void addResourceErrorsRulesetInvariant(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (TileResource resource2 : this.ruleset.getTileResources().values()) {
            Intrinsics.checkNotNull(resource2);
            this.uniqueValidator.checkUniques(resource2, lines2, false, tryFixUnknownUniques);
        }
    }

    private final void addPromotionErrorsRulesetInvariant(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Promotion promotion2 : this.ruleset.getUnitPromotions().values()) {
            Color color;
            Intrinsics.checkNotNull(promotion2);
            this.uniqueValidator.checkUniques(promotion2, lines2, false, tryFixUnknownUniques);
            Color color2 = promotion2.getInnerColorObject();
            if (color2 == null) {
                color2 = PortraitPromotion.Companion.getDefaultInnerColor();
            }
            if ((color = promotion2.getOuterColorObject()) == null) {
                color = PortraitPromotion.Companion.getDefaultOuterColor();
            }
            this.checkContrasts(color2, color, promotion2, lines2);
            this.addPromotionErrorRulesetInvariant(promotion2, lines2);
        }
    }

    private final void addPromotionErrorRulesetInvariant(Promotion promotion2, RulesetErrorList lines2) {
        if (promotion2.getRow() < -1) {
            RulesetErrorList.add$default(lines2, "Promotion " + promotion2.getName() + " has invalid row value: " + promotion2.getRow(), null, promotion2, null, 10, null);
        }
        if (promotion2.getColumn() < 0) {
            RulesetErrorList.add$default(lines2, "Promotion " + promotion2.getName() + " has invalid column value: " + promotion2.getColumn(), null, promotion2, null, 10, null);
        }
        if (promotion2.getRow() == -1) {
            return;
        }
        for (Promotion otherPromotion : this.ruleset.getUnitPromotions().values()) {
            if (Intrinsics.areEqual(promotion2, otherPromotion) || promotion2.getColumn() != otherPromotion.getColumn() || promotion2.getRow() != otherPromotion.getRow()) continue;
            RulesetErrorList.add$default(lines2, "Promotions " + promotion2.getName() + " and " + otherPromotion.getName() + " have the same position: " + promotion2.getRow() + '/' + promotion2.getColumn(), null, promotion2, null, 10, null);
        }
    }

    private final void addNationErrorsRulesetInvariant(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Nation nation2 : this.ruleset.getNations().values()) {
            Intrinsics.checkNotNull(nation2);
            this.addNationErrorRulesetInvariant(nation2, lines2);
            this.uniqueValidator.checkUniques(nation2, lines2, false, tryFixUnknownUniques);
        }
    }

    private final void addNationErrorRulesetInvariant(Nation nation2, RulesetErrorList lines2) {
        if (nation2.getCities().isEmpty() && !nation2.isSpectator() && !nation2.isBarbarian()) {
            RulesetErrorList.add$default(lines2, nation2.getName() + " can settle cities, but has no city names!", null, nation2, null, 10, null);
        }
        this.checkContrasts(nation2.getInnerColor(), nation2.getOuterColor(), nation2, lines2);
    }

    private final void checkContrasts(Color innerColor, Color outerColor, RulesetObject nation2, RulesetErrorList lines2) {
        double constrastRatio = NationKt.getContrastRatio(innerColor, outerColor);
        if (constrastRatio < 3.0) {
            SuggestedColors suggestedColors = this.getSuggestedColors(innerColor, outerColor);
            Color newInnerColor = suggestedColors.component1();
            Color newOuterColor = suggestedColors.component2();
            String text2 = nation2.getName() + "'s colors do not contrast enough - it is unreadable!";
            text2 = text2 + "\nSuggested colors: ";
            text2 = text2 + "\n\t\t\"outerColor\": [" + (int)(newOuterColor.r * (float)255) + ", " + (int)(newOuterColor.g * (float)255) + ", " + (int)(newOuterColor.b * (float)255) + "],";
            text2 = text2 + "\n\t\t\"innerColor\": [" + (int)(newInnerColor.r * (float)255) + ", " + (int)(newInnerColor.g * (float)255) + ", " + (int)(newInnerColor.b * (float)255) + "],";
            RulesetErrorList.add$default(lines2, text2, RulesetErrorSeverity.WarningOptionsOnly, nation2, null, 8, null);
        }
    }

    private final SuggestedColors getSuggestedColors(Color innerColor, Color outerColor) {
        double innerColorLuminance = NationKt.getRelativeLuminance(innerColor);
        double outerColorLuminance = NationKt.getRelativeLuminance(outerColor);
        Color innerLerpColor = null;
        Color outerLerpColor = null;
        if (innerColorLuminance > outerColorLuminance) {
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            innerLerpColor = color;
            outerLerpColor = ImageGetter.INSTANCE.getCHARCOAL();
        } else {
            innerLerpColor = ImageGetter.INSTANCE.getCHARCOAL();
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            outerLerpColor = color;
        }
        for (int i = 1; i < 11; ++i) {
            Color newInnerColor = innerColor.cpy().lerp(innerLerpColor, 0.05f * (float)i);
            Color newOuterColor = outerColor.cpy().lerp(outerLerpColor, 0.05f * (float)i);
            Intrinsics.checkNotNull(newInnerColor);
            Intrinsics.checkNotNull(newOuterColor);
            if (!(NationKt.getContrastRatio(newInnerColor, newOuterColor) > 3.0)) continue;
            return new SuggestedColors(newInnerColor, newOuterColor);
        }
        throw new Exception("Error getting suggested colors");
    }

    private final void addBuildingErrorsRulesetInvariant(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Building building : this.ruleset.getBuildings().values()) {
            Intrinsics.checkNotNull(building);
            this.addBuildingErrorRulesetInvariant(building, lines2);
            this.uniqueValidator.checkUniques(building, lines2, false, tryFixUnknownUniques);
        }
    }

    private final void addBuildingErrorRulesetInvariant(Building building, RulesetErrorList lines2) {
        if (SequencesKt.none(building.requiredTechs()) && building.getCost() == -1 && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)building, UniqueType.Unbuildable, null, 2, null)) {
            RulesetErrorList.add$default(lines2, building.getName() + " is buildable and therefore should either have an explicit cost or reference an existing tech!", RulesetErrorSeverity.Warning, building, null, 8, null);
        }
        for (Map.Entry gpp : ((Map)building.getGreatPersonPoints()).entrySet()) {
            if (((Map)this.ruleset.getUnits()).containsKey(gpp.getKey())) continue;
            RulesetErrorList.add$default(lines2, "Building " + building.getName() + " has greatPersonPoints for " + (String)gpp.getKey() + ", which is not a unit in the ruleset!", RulesetErrorSeverity.Warning, building, null, 8, null);
        }
        if (building.getReplaces() != null && building.getUniqueTo() == null) {
            RulesetErrorList.add$default(lines2, building.getName() + " should replace " + building.getReplaces() + " but does not have uniqueTo assigned!", null, null, null, 14, null);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void addTechColumnErrorsRulesetInvariant(RulesetErrorList lines) {
        for (TechColumn techColumn : this.ruleset.getTechColumns()) {
            if (techColumn.getColumnNumber() < 0) {
                RulesetErrorList.add$default(lines, "Tech Column number " + techColumn.getColumnNumber() + " is negative", null, null, null, 10, null);
            }
            v0 = this.ruleset.getBuildings().values();
            Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
            $this$filter$iv = v0;
            $i$f$filter = false;
            var7_8 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                building = (Building)element$iv$iv;
                $i$a$-filter-RulesetValidator$addTechColumnErrorsRulesetInvariant$buildingsWithoutAssignedCost$1 = false;
                if (building.getCost() != -1) ** GOTO lbl-1000
                $this$map$iv = techColumn.getTechs();
                $i$f$map = false;
                var16_26 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var21_31 = (Technology)item$iv$iv;
                    var22_32 = destination$iv$iv;
                    $i$a$-map-RulesetValidator$addTechColumnErrorsRulesetInvariant$buildingsWithoutAssignedCost$1$1 = false;
                    var22_32.add(it.getName());
                }
                if (CollectionsKt.contains((List)destination$iv$iv, building.getRequiredTech())) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            buildingsWithoutAssignedCost = CollectionsKt.toList((List)destination$iv$iv);
            $this$filter$iv = buildingsWithoutAssignedCost;
            $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            destination$iv$iv /* !! */  = new ArrayList<E>();
            $i$f$filterTo = false;
            element$iv$iv = $this$filterTo$iv$iv.iterator();
            while (element$iv$iv.hasNext()) {
                element$iv$iv = element$iv$iv.next();
                it = (Building)element$iv$iv;
                $i$a$-filter-RulesetValidator$addTechColumnErrorsRulesetInvariant$nonWondersWithoutAssignedCost$1 = false;
                if (!(it.isAnyWonder() == false)) continue;
                destination$iv$iv /* !! */ .add(element$iv$iv);
            }
            nonWondersWithoutAssignedCost = (List)destination$iv$iv /* !! */ ;
            if (techColumn.getBuildingCost() == -1 && CollectionsKt.any(nonWondersWithoutAssignedCost)) {
                RulesetErrorList.add$default(lines, "Tech Column number " + techColumn.getColumnNumber() + " has no explicit building cost leaving " + CollectionsKt.joinToString$default(nonWondersWithoutAssignedCost, null, null, null, 0, null, null, 63, null) + " unassigned", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
            $this$filter$iv = buildingsWithoutAssignedCost;
            $i$f$filter = false;
            destination$iv$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Building)element$iv$iv;
                $i$a$-filter-RulesetValidator$addTechColumnErrorsRulesetInvariant$wondersWithoutAssignedCost$1 = false;
                if (!it.isAnyWonder()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            wondersWithoutAssignedCost = (List)destination$iv$iv;
            if (techColumn.getWonderCost() != -1 || !CollectionsKt.any(wondersWithoutAssignedCost)) continue;
            RulesetErrorList.add$default(lines, "Tech Column number " + techColumn.getColumnNumber() + " has no explicit wonder cost leaving " + CollectionsKt.joinToString$default(wondersWithoutAssignedCost, null, null, null, 0, null, null, 63, null) + " unassigned", RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        for (Technology tech : this.ruleset.getTechnologies().values()) {
            for (Technology otherTech : this.ruleset.getTechnologies().values()) {
                if (Intrinsics.areEqual(tech, otherTech)) continue;
                v2 = otherTech.getColumn();
                v3 = tech.getColumn();
                if (!Intrinsics.areEqual(v2 != null ? Integer.valueOf(v2.getColumnNumber()) : null, v3 != null ? Integer.valueOf(v3.getColumnNumber()) : null) || otherTech.getRow() != tech.getRow()) continue;
                RulesetErrorList.add$default(lines, tech.getName() + " is in the same row and column as " + otherTech.getName() + '!', null, tech, null, 10, null);
            }
        }
    }

    private final void addTechErrorsRulesetInvariant(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Technology tech : this.ruleset.getTechnologies().values()) {
            if (tech.getRow() < 1) {
                RulesetErrorList.add$default(lines2, "Tech " + tech.getName() + " has a row value below 1: " + tech.getRow(), null, tech, null, 10, null);
            }
            Intrinsics.checkNotNull(tech);
            this.uniqueValidator.checkUniques(tech, lines2, false, tryFixUnknownUniques);
        }
    }

    private final Set<String> getPrereqTree(String technologyName) {
        if (this.prereqsHashMap.containsKey(technologyName)) {
            HashSet<String> hashSet = this.prereqsHashMap.get(technologyName);
            Intrinsics.checkNotNull(hashSet);
            return hashSet;
        }
        Technology technology2 = this.ruleset.getTechnologies().get(technologyName);
        if (technology2 == null) {
            return SetsKt.emptySet();
        }
        Technology technology3 = technology2;
        HashSet techHashSet = new HashSet();
        CollectionsKt.addAll((Collection)techHashSet, (Iterable)technology3.getPrerequisites());
        ((Map)this.prereqsHashMap).put(technologyName, techHashSet);
        for (String prerequisite : technology3.getPrerequisites()) {
            Collection collection = techHashSet;
            Intrinsics.checkNotNull(prerequisite);
            CollectionsKt.addAll(collection, (Iterable)this.getPrereqTree(prerequisite));
        }
        return techHashSet;
    }

    private final void checkUnitRulesetInvariant(BaseUnit unit, RulesetErrorList lines2) {
        Iterator<String> iterator2 = unit.getUpgradeUnits(StateForConditionals.Companion.getIgnoreConditionals()).iterator();
        while (iterator2.hasNext()) {
            String upgradesTo = iterator2.next();
            if (!Intrinsics.areEqual(upgradesTo, unit.getName()) && !Intrinsics.areEqual(upgradesTo, unit.getReplaces())) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " upgrades to itself!", null, unit, null, 10, null);
        }
        if (unit.getReplaces() != null && unit.getUniqueTo() == null) {
            RulesetErrorList.add$default(lines2, unit.getName() + " should replace " + unit.getReplaces() + " but does not have uniqueTo assigned!", null, null, null, 14, null);
        }
        if (unit.isMilitary() && unit.getStrength() == 0) {
            RulesetErrorList.add$default(lines2, unit.getName() + " is a military unit but has no assigned strength!", null, unit, null, 10, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkUniqueToMisspelling(IHasUniques obj, String uniqueTo, RulesetErrorList lines2) {
        void $this$flatMapTo$iv$iv;
        if (uniqueTo == null || ((Map)this.ruleset.getNations()).containsKey(uniqueTo)) {
            return;
        }
        Collection<Nation> collection = this.ruleset.getNations().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Object object = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Nation it = (Nation)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getUniques();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Set civUniques = CollectionsKt.toSet((List)destination$iv$iv);
        if (civUniques.contains(uniqueTo)) {
            return;
        }
        Collection collection2 = CollectionsKt.toList(civUniques);
        Set<String> set2 = this.ruleset.getNations().keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        List<String> possibleMisspellings = this.getPossibleMisspellings(uniqueTo, CollectionsKt.plus(collection2, (Iterable)set2));
        if (possibleMisspellings.isEmpty()) {
            return;
        }
        String string = obj.getName() + " has uniqueTo \"" + uniqueTo + "\" does not match any nation/unique - may be a misspelling of " + CollectionsKt.joinToString$default(possibleMisspellings, " OR ", null, null, 0, null, checkUniqueToMisspelling.1.INSTANCE, 30, null);
        object = RulesetErrorSeverity.OK;
        RulesetErrorList.add$default(lines2, string, (RulesetErrorSeverity)((Object)object), obj, null, 8, null);
    }

    private final void checkUnitRulesetSpecific(BaseUnit unit, RulesetErrorList lines2) {
        String obsoleteTech;
        Iterator<Object> iterator2 = unit.requiredTechs().iterator();
        while (iterator2.hasNext()) {
            String requiredTech = iterator2.next();
            if (this.ruleset.getTechnologies().containsKey(requiredTech)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " requires tech " + requiredTech + " which does not exist!", null, unit, null, 10, null);
        }
        iterator2 = unit.techsAtWhichNoLongerAvailable().iterator();
        while (iterator2.hasNext()) {
            obsoleteTech = iterator2.next();
            if (this.ruleset.getTechnologies().containsKey(obsoleteTech)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " obsoletes at tech " + obsoleteTech + " which does not exist!", null, unit, null, 10, null);
        }
        iterator2 = unit.getUpgradeUnits(StateForConditionals.Companion.getIgnoreConditionals()).iterator();
        while (iterator2.hasNext()) {
            String upgradesTo = iterator2.next();
            if (this.ruleset.getUnits().containsKey(upgradesTo)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " upgrades to unit " + upgradesTo + " which does not exist!", null, unit, null, 10, null);
        }
        iterator2 = unit.techsAtWhichAutoUpgradeInProduction().iterator();
        while (iterator2.hasNext()) {
            obsoleteTech = iterator2.next();
            Iterator<String> iterator3 = unit.getUpgradeUnits(StateForConditionals.Companion.getIgnoreConditionals()).iterator();
            while (iterator3.hasNext()) {
                BaseUnit upgradedUnit;
                String upgradesTo = iterator3.next();
                if (!this.ruleset.getUnits().containsKey(upgradesTo) || !this.ruleset.getTechnologies().containsKey(obsoleteTech)) continue;
                Intrinsics.checkNotNull(this.ruleset.getUnits().get(upgradesTo));
                Iterator<String> iterator4 = upgradedUnit.requiredTechs().iterator();
                while (iterator4.hasNext()) {
                    String requiredTech = iterator4.next();
                    if (Intrinsics.areEqual(requiredTech, obsoleteTech) || this.getPrereqTree(obsoleteTech).contains(requiredTech)) continue;
                    RulesetErrorList.add$default(lines2, unit.getName() + " is supposed to automatically upgrade at tech " + obsoleteTech + ", and therefore " + requiredTech + " for its upgrade " + upgradedUnit.getName() + " may not yet be researched!", RulesetErrorSeverity.Warning, unit, null, 8, null);
                }
            }
        }
        for (String resource2 : unit.getResourceRequirementsPerTurn(StateForConditionals.Companion.getIgnoreConditionals()).keySet()) {
            if (this.ruleset.getTileResources().containsKey(resource2)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " requires resource " + resource2 + " which does not exist!", null, unit, null, 10, null);
        }
        if (unit.getReplaces() != null) {
            LinkedHashMap<String, BaseUnit> linkedHashMap = this.ruleset.getUnits();
            String string = unit.getReplaces();
            Intrinsics.checkNotNull(string);
            if (!linkedHashMap.containsKey(string)) {
                RulesetErrorList.add$default(lines2, unit.getName() + " replaces " + unit.getReplaces() + " which does not exist!", null, unit, null, 10, null);
            }
        }
        for (String promotion2 : unit.getPromotions()) {
            if (this.ruleset.getUnitPromotions().containsKey(promotion2)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " contains promotion " + promotion2 + " which does not exist!", null, unit, null, 10, null);
        }
        this.checkUnitType(unit.getUnitType(), new Function0<Unit>(lines2, unit){
            final /* synthetic */ RulesetErrorList $lines;
            final /* synthetic */ BaseUnit $unit;
            {
                this.$lines = $lines;
                this.$unit = $unit;
                super(0);
            }

            public final void invoke() {
                RulesetErrorList.add$default(this.$lines, this.$unit.getName() + " is of type " + this.$unit.getUnitType() + ", which does not exist!", null, this.$unit, null, 10, null);
            }
        });
        iterator2 = unit.getMatchingUniques(UniqueType.ConstructImprovementInstantly, StateForConditionals.Companion.getIgnoreConditionals()).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            String improvementName = unique.getParams().get(0);
            if (this.ruleset.getTileImprovements().get(improvementName) == null) continue;
            TileImprovement tileImprovement = this.ruleset.getTileImprovements().get(improvementName);
            Intrinsics.checkNotNull(tileImprovement, "null cannot be cast to non-null type com.unciv.models.stats.Stats");
            if (!((Stats)tileImprovement).isEmpty() || !unit.isCivilian() || unit.isGreatPersonOfType("War")) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " can place improvement " + improvementName + " which has no stats, preventing unit automation!", RulesetErrorSeverity.WarningOptionsOnly, unit, null, 8, null);
        }
    }

    private final Ruleset getVanillaRuleset() {
        Lazy lazy = this.vanillaRuleset$delegate;
        return (Ruleset)lazy.getValue();
    }

    private final void checkUnitType(String type2, Function0<Unit> reportError) {
        if (this.ruleset.getUnitTypes().containsKey(type2)) {
            return;
        }
        if (this.ruleset.getUnitTypes().isEmpty() && this.getVanillaRuleset().getUnitTypes().containsKey(type2)) {
            return;
        }
        reportError.invoke();
    }

    private final void checkTilesetSanity(RulesetErrorList lines2) {
        Set<String> atlasOnlyTilesets;
        Set<String> atlasTilesets;
        Set configOnlyTilesets;
        FileHandle tilesetConfigFolder;
        FileHandle fileHandle;
        if (this.ruleset.getFolderLocation() == null) {
            Package package_ = this.getClass().getPackage();
            if ((package_ != null ? package_.getSpecificationVersion() : null) != null) {
                return;
            }
        }
        if ((fileHandle = this.ruleset.getFolderLocation()) == null) {
            fileHandle = Gdx.files.internal("");
        }
        if (!(tilesetConfigFolder = fileHandle.child("jsons/TileSets")).exists()) {
            return;
        }
        Set configTilesets = new LinkedHashSet();
        Set allFallbacks = new LinkedHashSet();
        FileHandle[] folderContent = tilesetConfigFolder.list();
        boolean folderContentBad = false;
        Intrinsics.checkNotNull(folderContent);
        for (FileHandle file : folderContent) {
            if (file.isDirectory() || !Intrinsics.areEqual(file.extension(), "json")) {
                folderContentBad = true;
                continue;
            }
            try {
                Json json = UncivJsonKt.json();
                Intrinsics.checkNotNull(file);
                TileSetConfig config2 = UncivJsonKt.fromJsonFile(json, TileSetConfig.class, file);
                Collection collection = configTilesets;
                String string = file.nameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
                collection.add(StringsKt.removeSuffix(string, (CharSequence)"Config"));
                String string2 = config2.getFallbackTileSet();
                boolean bl = string2 != null ? ((CharSequence)string2).length() > 0 : false;
                if (!bl) continue;
                String string3 = config2.getFallbackTileSet();
                Intrinsics.checkNotNull(string3);
                allFallbacks.add(string3);
            }
            catch (Exception ex) {
                Throwable throwable = ex.getCause();
                RulesetErrorList.add$default(lines2, "Tileset config '" + file.name() + "' cannot be loaded (" + (throwable != null ? throwable.getMessage() : null) + ')', RulesetErrorSeverity.Warning, null, null, 8, null);
            }
        }
        if (folderContentBad) {
            RulesetErrorList.add$default(lines2, "The Mod tileset config folder contains non-json files or subdirectories", RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        if (configTilesets.isEmpty()) {
            RulesetErrorList.add$default(lines2, "The Mod tileset config folder contains no json files", RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        if (!((Collection)(configOnlyTilesets = SetsKt.minus(configTilesets, (Iterable)(atlasTilesets = this.getTilesetNamesFromAtlases())))).isEmpty()) {
            RulesetErrorList.add$default(lines2, "Mod has no graphics for configured tilesets: " + CollectionsKt.joinToString$default(configOnlyTilesets, null, null, null, 0, null, null, 63, null), RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        if (!((Collection)(atlasOnlyTilesets = SetsKt.minus(atlasTilesets, configTilesets))).isEmpty()) {
            RulesetErrorList.add$default(lines2, "Mod has no configuration for tileset graphics: " + CollectionsKt.joinToString$default(atlasOnlyTilesets, null, null, null, 0, null, null, 63, null), RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        Set<String> set2 = TileSetCache.INSTANCE.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Set<String> unknownFallbacks = SetsKt.minus(SetsKt.minus(allFallbacks, (Iterable)set2), "FantasyHex");
        if (!((Collection)unknownFallbacks).isEmpty()) {
            RulesetErrorList.add$default(lines2, "Fallback tileset invalid: " + CollectionsKt.joinToString$default(unknownFallbacks, null, null, null, 0, null, null, 63, null), RulesetErrorSeverity.Warning, null, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getTilesetNamesFromAtlases() {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        AtlasPreview atlasPreview = this.textureNamesCache;
        if (atlasPreview == null) {
            Intrinsics.throwUninitializedPropertyAccessException("textureNamesCache");
            atlasPreview = null;
        }
        Iterable $this$filter$iv = atlasPreview;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default(it, "TileSets/", false, 2, null) && !StringsKt.contains$default((CharSequence)it, "/Units/", false, 2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"/"};
            collection.add((String)StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null).get(1));
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    private final void checkPromotionCircularReferences(RulesetErrorList lines2) {
        for (Promotion promotion2 : this.ruleset.getUnitPromotions().values()) {
            if (promotion2.getPrerequisites().isEmpty()) continue;
            HashSet<Promotion> hashSet = new HashSet<Promotion>();
            Intrinsics.checkNotNull(promotion2);
            RulesetValidator.checkPromotionCircularReferences$recursiveCheck(lines2, this, hashSet, promotion2, 0);
        }
    }

    private final void checkCivilopediaText(RulesetErrorList lines2) {
        Iterator<ICivilopediaText> iterator2 = this.ruleset.allICivilopediaText().iterator();
        while (iterator2.hasNext()) {
            ICivilopediaText sourceObject = iterator2.next();
            Iterator<FormattedLine> iterator3 = sourceObject.getCivilopediaText().iterator();
            int n = 0;
            while (iterator3.hasNext()) {
                int index = n++;
                FormattedLine line = iterator3.next();
                Iterator<String> iterator4 = line.unsupportedReasons(this).iterator();
                while (iterator4.hasNext()) {
                    String string;
                    String string2;
                    String error2 = iterator4.next();
                    INamed iNamed = sourceObject instanceof INamed ? (INamed)((Object)sourceObject) : null;
                    String nameText = iNamed != null && (string2 = iNamed.getName()) != null && (string = string2 + "'s ") != null ? string : "";
                    String text2 = '(' + sourceObject.getClass().getSimpleName() + ") " + nameText + "civilopediaText line " + (index + 1) + ": " + error2;
                    lines2.add(text2, RulesetErrorSeverity.WarningOptionsOnly, sourceObject instanceof IRulesetObject ? (IRulesetObject)sourceObject : null, null);
                }
            }
        }
    }

    public final boolean uncachedImageExists(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        if (this.ruleset.getFolderLocation() == null) {
            return false;
        }
        AtlasPreview atlasPreview = this.textureNamesCache;
        if (atlasPreview == null) {
            Intrinsics.throwUninitializedPropertyAccessException("textureNamesCache");
            atlasPreview = null;
        }
        return atlasPreview.imageExists(name2);
    }

    private static final void checkPromotionCircularReferences$recursiveCheck(RulesetErrorList $lines, RulesetValidator this$0, HashSet<Promotion> history, Promotion promotion2, int level) {
        if (history.contains(promotion2)) {
            RulesetErrorList.add$default($lines, "Circular Reference in Promotions: " + CollectionsKt.joinToString$default(history, "\u2192", null, null, 0, null, checkPromotionCircularReferences.recursiveCheck.1.INSTANCE, 30, null) + '\u2192' + promotion2.getName(), RulesetErrorSeverity.Warning, promotion2, null, 8, null);
            return;
        }
        if (level > 99) {
            return;
        }
        history.add((Promotion)promotion2);
        for (String prerequisiteName : promotion2.getPrerequisites()) {
            Promotion prerequisite;
            if (this$0.ruleset.getUnitPromotions().get(prerequisiteName) == null) continue;
            HashSet linkedSetToPass = promotion2.getPrerequisites().size() == 1 ? history : (HashSet)CollectionsKt.toCollection(history, (Collection)new HashSet());
            RulesetValidator.checkPromotionCircularReferences$recursiveCheck($lines, this$0, linkedSetToPass, prerequisite, level + 1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/unciv/models/ruleset/validation/RulesetValidator$SuggestedColors;", "", "innerColor", "Lcom/badlogic/gdx/graphics/Color;", "outerColor", "(Lcom/badlogic/gdx/graphics/Color;Lcom/badlogic/gdx/graphics/Color;)V", "getInnerColor", "()Lcom/badlogic/gdx/graphics/Color;", "getOuterColor", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    public static final class SuggestedColors {
        @NotNull
        private final Color innerColor;
        @NotNull
        private final Color outerColor;

        public SuggestedColors(@NotNull Color innerColor, @NotNull Color outerColor) {
            Intrinsics.checkNotNullParameter(innerColor, "innerColor");
            Intrinsics.checkNotNullParameter(outerColor, "outerColor");
            this.innerColor = innerColor;
            this.outerColor = outerColor;
        }

        @NotNull
        public final Color getInnerColor() {
            return this.innerColor;
        }

        @NotNull
        public final Color getOuterColor() {
            return this.outerColor;
        }

        @NotNull
        public final Color component1() {
            return this.innerColor;
        }

        @NotNull
        public final Color component2() {
            return this.outerColor;
        }

        @NotNull
        public final SuggestedColors copy(@NotNull Color innerColor, @NotNull Color outerColor) {
            Intrinsics.checkNotNullParameter(innerColor, "innerColor");
            Intrinsics.checkNotNullParameter(outerColor, "outerColor");
            return new SuggestedColors(innerColor, outerColor);
        }

        public static /* synthetic */ SuggestedColors copy$default(SuggestedColors suggestedColors, Color color, Color color2, int n, Object object) {
            if ((n & 1) != 0) {
                color = suggestedColors.innerColor;
            }
            if ((n & 2) != 0) {
                color2 = suggestedColors.outerColor;
            }
            return suggestedColors.copy(color, color2);
        }

        @NotNull
        public String toString() {
            return "SuggestedColors(innerColor=" + this.innerColor + ", outerColor=" + this.outerColor + ')';
        }

        public int hashCode() {
            int result2 = this.innerColor.hashCode();
            result2 = result2 * 31 + this.outerColor.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SuggestedColors)) {
                return false;
            }
            SuggestedColors suggestedColors = (SuggestedColors)other;
            if (!Intrinsics.areEqual(this.innerColor, suggestedColors.innerColor)) {
                return false;
            }
            return Intrinsics.areEqual(this.outerColor, suggestedColors.outerColor);
        }
    }
}

