/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetFile;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.validation.RulesetError;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.UniqueAutoUpdater;
import com.unciv.models.ruleset.validation.UniqueValidator;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062$\b\u0002\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\nJ*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lcom/unciv/models/ruleset/validation/UniqueAutoUpdater;", "", "()V", "autoupdateUniques", "", "mod", "Lcom/unciv/models/ruleset/Ruleset;", "replaceableUniques", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getDeprecatedReplaceableUniques", "core"})
@SourceDebugExtension(value={"SMAP\nUniqueAutoUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniqueAutoUpdater.kt\ncom/unciv/models/ruleset/validation/UniqueAutoUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1549#2:85\n1620#2,3:86\n*S KotlinDebug\n*F\n+ 1 UniqueAutoUpdater.kt\ncom/unciv/models/ruleset/validation/UniqueAutoUpdater\n*L\n15#1:85\n15#1:86,3\n*E\n"})
public final class UniqueAutoUpdater {
    @NotNull
    public static final UniqueAutoUpdater INSTANCE = new UniqueAutoUpdater();

    private UniqueAutoUpdater() {
    }

    /*
     * WARNING - void declaration
     */
    public final void autoupdateUniques(@NotNull Ruleset mod, @NotNull HashMap<String, String> replaceableUniques) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(mod, "mod");
        Intrinsics.checkNotNullParameter(replaceableUniques, "replaceableUniques");
        Iterable $this$map$iv = RulesetFile.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object entry : $this$mapTo$iv$iv) {
            void it;
            RulesetFile rulesetFile = (RulesetFile)((Object)entry);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFilename());
        }
        List filesToReplace = (List)destination$iv$iv;
        FileHandle fileHandle = mod.getFolderLocation();
        Intrinsics.checkNotNull(fileHandle);
        FileHandle jsonFolder = fileHandle.child("jsons");
        for (String fileName : filesToReplace) {
            FileHandle file = jsonFolder.child(fileName);
            if (!file.exists() || file.isDirectory()) continue;
            String newFileText = file.readString();
            for (Map.Entry entry : ((Map)replaceableUniques).entrySet()) {
                String original = (String)entry.getKey();
                String replacement = (String)entry.getValue();
                String string = newFileText;
                Intrinsics.checkNotNull(string);
                string = newFileText = StringsKt.replace$default(string, '\"' + original + '\"', '\"' + replacement + '\"', false, 4, null);
                Intrinsics.checkNotNull(string);
                newFileText = StringsKt.replace$default(string, '<' + original + '>', '<' + replacement + '>', false, 4, null);
            }
            file.writeString(newFileText, false);
        }
    }

    public static /* synthetic */ void autoupdateUniques$default(UniqueAutoUpdater uniqueAutoUpdater, Ruleset ruleset2, HashMap hashMap, int n, Object object) {
        if ((n & 2) != 0) {
            hashMap = uniqueAutoUpdater.getDeprecatedReplaceableUniques(ruleset2);
        }
        uniqueAutoUpdater.autoupdateUniques(ruleset2, hashMap);
    }

    @NotNull
    public final HashMap<String, String> getDeprecatedReplaceableUniques(@NotNull Ruleset mod) {
        Intrinsics.checkNotNullParameter(mod, "mod");
        Sequence<Unique> allUniques2 = mod.allUniques();
        HashSet<String> allDeprecatedUniques = new HashSet<String>();
        HashMap<String, String> deprecatedUniquesToReplacementText = new HashMap<String, String>();
        Sequence<Unique> deprecatedUniques2 = SequencesKt.filter(allUniques2, getDeprecatedReplaceableUniques.deprecatedUniques.1.INSTANCE);
        Sequence deprecatedConditionals2 = SequencesKt.filter(SequencesKt.flatMapIterable(allUniques2, getDeprecatedReplaceableUniques.deprecatedConditionals.1.INSTANCE), getDeprecatedReplaceableUniques.deprecatedConditionals.2.INSTANCE);
        Iterator<Unique> iterator2 = SequencesKt.plus(deprecatedUniques2, deprecatedConditionals2).iterator();
        while (iterator2.hasNext()) {
            Unique deprecatedUnique = iterator2.next();
            if (allDeprecatedUniques.contains(deprecatedUnique.getText())) continue;
            allDeprecatedUniques.add(deprecatedUnique.getText());
            String uniqueReplacementText = deprecatedUnique.getReplacementText(mod);
            while (new Unique(uniqueReplacementText, null, null, 6, null).getDeprecationAnnotation() != null) {
                uniqueReplacementText = new Unique(uniqueReplacementText, null, null, 6, null).getReplacementText(mod);
            }
            for (Unique conditional : deprecatedUnique.getModifiers()) {
                uniqueReplacementText = uniqueReplacementText + " <" + conditional.getText() + '>';
            }
            Unique replacementUnique = new Unique(uniqueReplacementText, null, null, 6, null);
            RulesetErrorList modInvariantErrors = new UniqueValidator(mod).checkUnique(replacementUnique, false, null, true);
            for (RulesetError error2 : modInvariantErrors) {
                Object[] objectArray = new Object[]{error2.getText(), error2.getErrorSeverityToReport()};
                Log.INSTANCE.error("ModInvariantError: %s - %s", objectArray);
            }
            if (!((Collection)modInvariantErrors).isEmpty()) continue;
            if (mod.getModOptions().isBaseRuleset()) {
                RulesetErrorList modSpecificErrors = new UniqueValidator(mod).checkUnique(replacementUnique, false, null, true);
                for (RulesetError error3 : modSpecificErrors) {
                    Object[] objectArray = new Object[]{error3.getText(), error3.getErrorSeverityToReport()};
                    Log.INSTANCE.error("ModSpecificError: %s - %s", objectArray);
                }
                if (!((Collection)modSpecificErrors).isEmpty()) continue;
            }
            ((Map)deprecatedUniquesToReplacementText).put(deprecatedUnique.getText(), uniqueReplacementText);
            Object[] objectArray = new Object[]{deprecatedUnique.getText(), uniqueReplacementText};
            LogKt.debug("Replace \"%s\" with \"%s\"", objectArray);
        }
        return deprecatedUniquesToReplacementText;
    }
}

