/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.AutoPlay;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CharIterator;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0006J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0002J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u000eJ\u000e\u0010'\u001a\u00020\"2\u0006\u0010%\u001a\u00020&J\u000e\u0010(\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u000eR%\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/unciv/ui/components/MayaCalendar;", "", "()V", "allSymbols", "", "Lkotlin/Pair;", "", "", "getAllSymbols", "()[Lkotlin/Pair;", "[Lkotlin/Pair;", "baktun", "baktunIcon", "daysOn30000101BCE", "", "digits", "Lkotlin/ranges/CharRange;", "getDigits", "()Lkotlin/ranges/CharRange;", "iconFolder", "katun", "katunIcon", "nineteen", "notificationIcon", "tun", "tunIcon", "zero", "digitIcon", "ch", "isNewCycle", "", "year", "otherYear", "openPopup", "", "previousScreen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "startTurnForMaya", "yearToMayaDate", "MayaYear", "core"})
public final class MayaCalendar {
    @NotNull
    public static final MayaCalendar INSTANCE = new MayaCalendar();
    @NotNull
    private static final String iconFolder = "MayaCalendar/";
    @NotNull
    public static final String notificationIcon = "MayaCalendar/Maya";
    @NotNull
    public static final String tunIcon = "MayaCalendar/Tun";
    @NotNull
    public static final String katunIcon = "MayaCalendar/Katun";
    @NotNull
    public static final String baktunIcon = "MayaCalendar/Baktun";
    public static final char tun = '\u0db8';
    public static final char katun = '\u0db9';
    public static final char baktun = '\u0dba';
    public static final char zero = '\u2170';
    public static final char nineteen = '\u2183';
    @NotNull
    private static final CharRange digits = new CharRange('\u2170', '\u2183');
    @NotNull
    private static final Pair<Character, String>[] allSymbols;
    private static final int daysOn30000101BCE = 41291;

    private MayaCalendar() {
    }

    @NotNull
    public final CharRange getDigits() {
        return digits;
    }

    @NotNull
    public final String digitIcon(char ch) {
        return iconFolder + (KeyCharAndCode.Companion.toCode(ch) - KeyCharAndCode.Companion.toCode('\u2170'));
    }

    @NotNull
    public final Pair<Character, String>[] getAllSymbols() {
        return allSymbols;
    }

    @NotNull
    public final String yearToMayaDate(int year2) {
        return new MayaYear(year2).toString();
    }

    private final boolean isNewCycle(int year2, int otherYear) {
        return new MayaYear(year2).getBaktuns() != new MayaYear(otherYear).getBaktuns();
    }

    public final void startTurnForMaya(@NotNull Civilization civInfo) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(civInfo, "civInfo");
                GameInfo game = civInfo.getGameInfo();
                int year2 = GameInfo.getYear$default(game, 0, 1, null);
                if (!this.isNewCycle(year2, game.getYear(-1))) {
                    return;
                }
                civInfo.getGreatPeople().triggerMayanGreatPerson();
                if (civInfo.isAI()) break block4;
                Object object = UncivGame.Companion.getCurrent().getWorldScreen();
                boolean bl = object != null && (object = ((WorldScreen)object).getAutoPlay()) != null ? ((AutoPlay)object).isAutoPlayingAndFullAutoPlayAI() : false;
                if (!bl) break block5;
            }
            NextTurnAutomation.INSTANCE.chooseGreatPerson(civInfo);
        }
    }

    public final void openPopup(@NotNull BaseScreen previousScreen, @NotNull Civilization civInfo, int year2) {
        Cell cell2;
        Popup popup2;
        Intrinsics.checkNotNullParameter(previousScreen, "previousScreen");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Popup $this$openPopup_u24lambda_u242 = popup2 = new Popup(previousScreen, null, 0.0f, 6, null);
        boolean bl = false;
        $this$openPopup_u24lambda_u242.setName("MayaCalendar");
        Cell $this$openPopup_u24lambda_u242_u24lambda_u241 = cell2 = Popup.addGoodSizedLabel$default($this$openPopup_u24lambda_u242, "The Mayan Long Count", 24, false, 4, null);
        boolean bl2 = false;
        ((Label)$this$openPopup_u24lambda_u242_u24lambda_u241.getActor()).setColor(civInfo.getNation().getOuterColor());
        cell2.row();
        Color color = Color.DARK_GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "DARK_GRAY");
        Popup.addSeparator$default($this$openPopup_u24lambda_u242, color, 0, 0.0f, 6, null);
        Popup.addGoodSizedLabel$default($this$openPopup_u24lambda_u242, "Your scientists and theologians have devised a systematic approach to measuring long time spans - the Long Count. During the festivities whenever the current b'ak'tun ends, a Great Person will join you.", 0, false, 6, null).row();
        String yearText = TranslationsKt.tr$default("" + '[' + Math.abs(year2) + "] " + (year2 < 0 ? "BC" : "AD"), false, false, 3, null);
        Popup.addGoodSizedLabel$default($this$openPopup_u24lambda_u242, "While the rest of the world calls the current year [" + yearText + "], in the Maya Calendar that is:", 0, false, 6, null).padTop(10.0f).row();
        MayaYear mayaYear = new MayaYear(year2);
        Popup.addGoodSizedLabel$default($this$openPopup_u24lambda_u242, mayaYear.toString(), 42, false, 4, null).row();
        Popup.addGoodSizedLabel$default($this$openPopup_u24lambda_u242, "" + '[' + mayaYear.getBaktuns() + "] b'ak'tun, [" + mayaYear.getKatuns() + "] k'atun, [" + mayaYear.getTuns() + "] tun", 0, false, 6, null).padBottom(10.0f).row();
        Popup.addCloseButton$default($this$openPopup_u24lambda_u242, null, null, null, null, 15, null);
        popup2.open(true);
    }

    static {
        Iterator $this$allSymbols_u24lambda_u240 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Pair<? extends Character, ? extends String>>, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yield(TuplesKt.to(Boxing.boxChar('\u0db8'), "MayaCalendar/Tun"), this);
                        if (v0 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.label = 2;
                        v1 = $this$sequence.yield(TuplesKt.to(Boxing.boxChar('\u0db9'), "MayaCalendar/Katun"), this);
                        if (v1 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl26
                    }
                    case 2: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl26:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.label = 3;
                        v2 = $this$sequence.yield(TuplesKt.to(Boxing.boxChar('\u0dba'), "MayaCalendar/Baktun"), this);
                        if (v2 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl36
                    }
                    case 3: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl36:
                        // 2 sources

                        var3_4 = MayaCalendar.INSTANCE.getDigits();
                        var12_5 = $this$sequence;
                        $i$f$map = false;
                        var5_7 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        var8_10 = $this$mapTo$iv$iv.iterator();
                        while (var8_10.hasNext()) {
                            var10_12 = item$iv$iv = ((CharIterator)var8_10).nextChar();
                            var13_14 = destination$iv$iv;
                            $i$a$-map-MayaCalendar$allSymbols$1$1 = false;
                            var13_14.add(TuplesKt.to(Boxing.boxChar((char)it), MayaCalendar.INSTANCE.digitIcon((char)it)));
                        }
                        this.L$0 = null;
                        this.label = 4;
                        v3 = var12_5.yieldAll((List)destination$iv$iv, (Continuation<Unit>)this);
                        if (v3 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl59
                    }
                    case 4: {
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl59:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super Pair<? extends Character, ? extends String>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Pair<Character, String>> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }).iterator();
        boolean bl = false;
        int n = 0;
        Pair[] pairArray = new Pair[23];
        while (n < 23) {
            int n2 = n++;
            pairArray[n2] = $this$allSymbols_u24lambda_u240.next();
        }
        allSymbols = pairArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/components/MayaCalendar$MayaYear;", "", "year", "", "(I)V", "baktuns", "getBaktuns", "()I", "katuns", "getKatuns", "tuns", "getTuns", "toString", "", "core"})
    private static final class MayaYear {
        private final int baktuns;
        private final int katuns;
        private final int tuns;

        public MayaYear(int year2) {
            int mayaDays = (year2 + 3000) * 365 + (year2 + 3000) / 4 + 41291;
            int totalTuns = mayaDays >= 0 ? mayaDays / 360 : 5200 + mayaDays / 360;
            int totalKatuns = totalTuns / 20;
            this.baktuns = totalKatuns / 20;
            this.katuns = totalKatuns - this.baktuns * 20;
            this.tuns = totalTuns - totalKatuns * 20;
        }

        public final int getBaktuns() {
            return this.baktuns;
        }

        public final int getKatuns() {
            return this.katuns;
        }

        public final int getTuns() {
            return this.tuns;
        }

        @NotNull
        public String toString() {
            char baktunDigit = KeyCharAndCode.Companion.makeChar(KeyCharAndCode.Companion.toCode('\u2170') + this.baktuns);
            char katunDigit = KeyCharAndCode.Companion.makeChar(KeyCharAndCode.Companion.toCode('\u2170') + this.katuns);
            char tunDigit = KeyCharAndCode.Companion.makeChar(KeyCharAndCode.Companion.toCode('\u2170') + this.tuns);
            return "" + baktunDigit + '\u0dba' + katunDigit + '\u0db9' + tunDigit + '\u0db8';
        }
    }
}

