/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components;

import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B3\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/unciv/ui/components/ZoomGestureListener;", "Lcom/badlogic/gdx/scenes/scene2d/EventListener;", "stageSize", "Lkotlin/Function0;", "Lcom/badlogic/gdx/math/Vector2;", "(Lkotlin/jvm/functions/Function0;)V", "halfTapSquareSize", "", "tapCountInterval", "longPressDuration", "maxFlingDelay", "(FFFFLkotlin/jvm/functions/Function0;)V", "detector", "Lcom/badlogic/gdx/input/GestureDetector;", "handle", "", "event", "Lcom/badlogic/gdx/scenes/scene2d/Event;", "pinch", "", "translation", "scaleChange", "pinchStop", "scrolled", "amountX", "amountY", "core"})
public class ZoomGestureListener
implements EventListener {
    @NotNull
    private final GestureDetector detector;

    public ZoomGestureListener(float halfTapSquareSize, float tapCountInterval, float longPressDuration, float maxFlingDelay, final @NotNull Function0<? extends Vector2> stageSize) {
        Intrinsics.checkNotNullParameter(stageSize, "stageSize");
        this.detector = new GestureDetector(halfTapSquareSize, tapCountInterval, longPressDuration, maxFlingDelay, new GestureDetector.GestureAdapter(){
            @Nullable
            private Vector2 lastFocus;
            private float lastDistance;

            @Override
            public boolean pinch(@NotNull Vector2 stageInitialPointer1, @NotNull Vector2 stageInitialPointer2, @NotNull Vector2 stagePointer1, @NotNull Vector2 stagePointer2) {
                Intrinsics.checkNotNullParameter(stageInitialPointer1, "stageInitialPointer1");
                Intrinsics.checkNotNullParameter(stageInitialPointer2, "stageInitialPointer2");
                Intrinsics.checkNotNullParameter(stagePointer1, "stagePointer1");
                Intrinsics.checkNotNullParameter(stagePointer2, "stagePointer2");
                if (this.lastFocus == null) {
                    this.lastFocus = stageInitialPointer1.cpy().add(stageInitialPointer2).scl(0.5f);
                    this.lastDistance = stageInitialPointer1.dst(stageInitialPointer2);
                }
                Vector2 currentFocus = stagePointer1.cpy().add(stagePointer2).scl(0.5f);
                Vector2 translation2 = currentFocus.cpy().sub(this.lastFocus);
                this.lastFocus = currentFocus.cpy();
                float currentDistance = stagePointer1.dst(stagePointer2);
                float scaleChange = currentDistance / this.lastDistance;
                this.lastDistance = currentDistance;
                float dx = (stageSize.invoke().x / (float)2 - currentFocus.x) * (scaleChange - 1.0f);
                float dy = (stageSize.invoke().y / (float)2 - currentFocus.y) * (scaleChange - 1.0f);
                translation2.add(dx, dy);
                Intrinsics.checkNotNull(translation2);
                this.pinch(translation2, scaleChange);
                return true;
            }

            @Override
            public void pinchStop() {
                this.lastFocus = null;
                this.pinchStop();
            }
        });
    }

    public ZoomGestureListener(@NotNull Function0<? extends Vector2> stageSize) {
        Intrinsics.checkNotNullParameter(stageSize, "stageSize");
        this(20.0f, 0.4f, 1.1f, 2.1474836E9f, stageSize);
    }

    @Override
    public boolean handle(@Nullable Event event) {
        if (!(event instanceof InputEvent)) {
            return false;
        }
        InputEvent.Type type2 = ((InputEvent)event).getType();
        switch (type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                this.detector.touchDown(((InputEvent)event).getStageX(), ((InputEvent)event).getStageY(), ((InputEvent)event).getPointer(), ((InputEvent)event).getButton());
                if (((InputEvent)event).getTouchFocus()) {
                    ((InputEvent)event).getStage().addTouchFocus(this, ((InputEvent)event).getListenerActor(), ((InputEvent)event).getTarget(), ((InputEvent)event).getPointer(), ((InputEvent)event).getButton());
                }
                return true;
            }
            case 2: {
                if (((InputEvent)event).isTouchFocusCancel()) {
                    this.detector.reset();
                    return false;
                }
                this.detector.touchUp(((InputEvent)event).getStageX(), ((InputEvent)event).getStageY(), ((InputEvent)event).getPointer(), ((InputEvent)event).getButton());
                return true;
            }
            case 3: {
                this.detector.touchDragged(((InputEvent)event).getStageX(), ((InputEvent)event).getStageY(), ((InputEvent)event).getPointer());
                return true;
            }
            case 4: {
                return this.scrolled(((InputEvent)event).getScrollAmountX(), ((InputEvent)event).getScrollAmountY());
            }
        }
        return false;
    }

    public boolean scrolled(float amountX, float amountY) {
        return false;
    }

    public void pinch(@NotNull Vector2 translation2, float scaleChange) {
        Intrinsics.checkNotNullParameter(translation2, "translation");
    }

    public void pinchStop() {
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InputEvent.Type.values().length];
            try {
                nArray[InputEvent.Type.touchDown.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InputEvent.Type.touchUp.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InputEvent.Type.touchDragged.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InputEvent.Type.scrolled.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

