/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.fonts;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.unciv.ui.components.fonts.DiacriticSupport;
import com.unciv.ui.components.fonts.FontImplementation;
import com.unciv.ui.components.fonts.FontRulesetIcons;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.images.ImageGetter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J2\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010&\u001a\u00020\u0007*\u00020\"H\u0002J\u0014\u0010'\u001a\u00020\u0016*\u00020\u00122\u0006\u0010(\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/unciv/ui/components/fonts/NativeBitmapFontData;", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont$BitmapFontData;", "Lcom/badlogic/gdx/utils/Disposable;", "fontImplementation", "Lcom/unciv/ui/components/fonts/FontImplementation;", "(Lcom/unciv/ui/components/fonts/FontImplementation;)V", "dirty", "", "filter", "Lcom/badlogic/gdx/graphics/Texture$TextureFilter;", "packer", "Lcom/badlogic/gdx/graphics/g2d/PixmapPacker;", "regions", "Lcom/badlogic/gdx/utils/Array;", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "getRegions", "()Lcom/badlogic/gdx/utils/Array;", "createAndCacheGlyph", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont$Glyph;", "ch", "", "dispose", "", "getGlyph", "getGlyphs", "run", "Lcom/badlogic/gdx/graphics/g2d/GlyphLayout$GlyphRun;", "str", "", "start", "", "end", "lastGlyph", "getPixmapForTextureName", "Lcom/badlogic/gdx/graphics/Pixmap;", "regionName", "", "getPixmapFromChar", "guessIsRoundSurroundedByTransparency", "setRulesetIconGeometry", "assumeRoundIcon", "Companion", "core"})
public final class NativeBitmapFontData
extends BitmapFont.BitmapFontData
implements Disposable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final FontImplementation fontImplementation;
    @NotNull
    private final Array<TextureRegion> regions;
    private boolean dirty;
    @NotNull
    private final PixmapPacker packer;
    @NotNull
    private final Texture.TextureFilter filter;
    @Deprecated
    public static final int alphaChannelMask = 255;
    @Deprecated
    public static final float nearCornerRelativeOffset = 0.1f;
    @Deprecated
    public static final float nearCenterRelativeOffset = 0.4f;
    @Deprecated
    public static final float relativeAdvanceExtra = 0.039f;
    @Deprecated
    public static final float relativeKerning = -0.055f;
    @NotNull
    private static final Map<Character, Float> kerningMap;

    public NativeBitmapFontData(@NotNull FontImplementation fontImplementation) {
        Intrinsics.checkNotNullParameter(fontImplementation, "fontImplementation");
        this.fontImplementation = fontImplementation;
        this.filter = Texture.TextureFilter.Linear;
        this.flipped = false;
        this.capHeight = this.lineHeight = (float)this.fontImplementation.getFontSize();
        this.ascent = -this.lineHeight;
        this.down = -this.lineHeight;
        int size2 = 1024;
        PixmapPacker.GuillotineStrategy packStrategy = new PixmapPacker.GuillotineStrategy();
        this.packer = new PixmapPacker(size2, size2, Pixmap.Format.RGBA8888, 1, false, packStrategy);
        this.packer.setTransparentColor(Color.WHITE);
        this.packer.getTransparentColor().a = 0.0f;
        this.regions = new Array();
        this.packer.updateTextureRegions(this.regions, this.filter, this.filter, false);
        BitmapFont.Glyph spaceGlyph = this.getGlyph(' ');
        this.spaceXadvance = spaceGlyph.xadvance;
        this.setScale(0.36f);
    }

    @NotNull
    public final Array<TextureRegion> getRegions() {
        return this.regions;
    }

    @Override
    @NotNull
    public BitmapFont.Glyph getGlyph(char ch) {
        BitmapFont.Glyph glyph = super.getGlyph(ch);
        if (glyph == null) {
            glyph = this.createAndCacheGlyph(ch);
        }
        return glyph;
    }

    private final BitmapFont.Glyph createAndCacheGlyph(char ch) {
        Pixmap charPixmap = this.getPixmapFromChar(ch);
        BitmapFont.Glyph glyph = new BitmapFont.Glyph();
        glyph.id = ch;
        glyph.width = charPixmap.getWidth();
        glyph.height = charPixmap.getHeight();
        glyph.xadvance = glyph.width;
        boolean isFontRulesetIcon = ch >= '\ue000' && Intrinsics.compare(ch, DiacriticSupport.Companion.getCurrentFreeCode()) <= 0;
        boolean assumeRoundIcon = isFontRulesetIcon && this.guessIsRoundSurroundedByTransparency(charPixmap);
        PixmapPacker.PixmapPackerRectangle rect = this.packer.pack(charPixmap);
        charPixmap.dispose();
        glyph.page = this.packer.getPages().size - 1;
        glyph.srcX = (int)rect.x;
        glyph.srcY = (int)rect.y;
        if (isFontRulesetIcon) {
            this.setRulesetIconGeometry(glyph, assumeRoundIcon);
        }
        if (this.regions.size <= glyph.page) {
            this.packer.updateTextureRegions(this.regions, this.filter, this.filter, false);
        }
        this.setGlyphRegion(glyph, this.regions.get(glyph.page));
        this.setGlyph(ch, glyph);
        this.dirty = true;
        return glyph;
    }

    private final boolean guessIsRoundSurroundedByTransparency(Pixmap $this$guessIsRoundSurroundedByTransparency) {
        int nearCenterOffset = (int)((float)$this$guessIsRoundSurroundedByTransparency.getWidth() * 0.4f);
        if (($this$guessIsRoundSurroundedByTransparency.getPixel(nearCenterOffset, nearCenterOffset) & 0xFF) == 0) {
            return false;
        }
        int nearCornerOffset = (int)((float)$this$guessIsRoundSurroundedByTransparency.getWidth() * 0.1f);
        return ($this$guessIsRoundSurroundedByTransparency.getPixel(nearCornerOffset, nearCornerOffset) & 0xFF) == 0;
    }

    private final void setRulesetIconGeometry(BitmapFont.Glyph $this$setRulesetIconGeometry, boolean assumeRoundIcon) {
        $this$setRulesetIconGeometry.xadvance += MathKt.roundToInt((float)$this$setRulesetIconGeometry.width * 0.039f);
        if (!assumeRoundIcon) {
            return;
        }
        float defaultKerning = (float)$this$setRulesetIconGeometry.width * -0.055f;
        for (Map.Entry<Character, Float> entry : kerningMap.entrySet()) {
            char c = entry.getKey().charValue();
            float kerning = ((Number)entry.getValue()).floatValue();
            $this$setRulesetIconGeometry.setKerning(c, MathKt.roundToInt(defaultKerning * kerning));
        }
    }

    private final Pixmap getPixmapForTextureName(String regionName) {
        TextureRegion textureRegion = ImageGetter.INSTANCE.getDrawable(regionName).getRegion();
        Intrinsics.checkNotNullExpressionValue(textureRegion, "getRegion(...)");
        return Fonts.INSTANCE.extractPixmapFromTextureRegion(textureRegion);
    }

    private final Pixmap getPixmapFromChar(char ch) {
        String textureName = Fonts.INSTANCE.getAllSymbols().get(Character.valueOf(ch));
        if (textureName != null && ImageGetter.INSTANCE.imageExists(textureName)) {
            return this.getPixmapForTextureName(textureName);
        }
        Actor actor = FontRulesetIcons.INSTANCE.getCharToRulesetImageActor().get(Character.valueOf(ch));
        if (actor != null) {
            Pixmap pixmap;
            try {
                pixmap = FontRulesetIcons.INSTANCE.getPixmapFromActor(actor);
            }
            catch (Exception _) {
                pixmap = new Pixmap(0, 0, Pixmap.Format.RGBA8888);
            }
            return pixmap;
        }
        if (DiacriticSupport.Companion.isEmpty()) {
            return this.fontImplementation.getCharPixmap(ch);
        }
        return this.fontImplementation.getCharPixmap(DiacriticSupport.Companion.getStringFor(ch));
    }

    @Override
    public void getGlyphs(@NotNull GlyphLayout.GlyphRun run, @NotNull CharSequence str, int start2, int end2, @Nullable BitmapFont.Glyph lastGlyph) {
        Intrinsics.checkNotNullParameter(run, "run");
        Intrinsics.checkNotNullParameter(str, "str");
        this.packer.setPackToTexture(true);
        super.getGlyphs(run, str, start2, end2, lastGlyph);
        if (this.dirty) {
            this.dirty = false;
            this.packer.updateTextureRegions(this.regions, this.filter, this.filter, false);
        }
    }

    @Override
    public void dispose() {
        this.packer.dispose();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Character.valueOf('A'), Float.valueOf(1.0f)), TuplesKt.to(Character.valueOf('T'), Float.valueOf(0.6f)), TuplesKt.to(Character.valueOf('V'), Float.valueOf(1.0f)), TuplesKt.to(Character.valueOf('Y'), Float.valueOf(1.2f))};
        kerningMap = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/components/fonts/NativeBitmapFontData$Companion;", "", "()V", "alphaChannelMask", "", "kerningMap", "", "", "", "getKerningMap", "()Ljava/util/Map;", "nearCenterRelativeOffset", "nearCornerRelativeOffset", "relativeAdvanceExtra", "relativeKerning", "core"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Character, Float> getKerningMap() {
            return kerningMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

