/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.components.tilegroups.layers.TileLayerBorders;
import com.unciv.ui.components.tilegroups.layers.TileLayerCityButton;
import com.unciv.ui.components.tilegroups.layers.TileLayerFeatures;
import com.unciv.ui.components.tilegroups.layers.TileLayerImprovement;
import com.unciv.ui.components.tilegroups.layers.TileLayerMisc;
import com.unciv.ui.components.tilegroups.layers.TileLayerOverlay;
import com.unciv.ui.components.tilegroups.layers.TileLayerResource;
import com.unciv.ui.components.tilegroups.layers.TileLayerTerrain;
import com.unciv.ui.components.tilegroups.layers.TileLayerUnitFlag;
import com.unciv.ui.components.tilegroups.layers.TileLayerUnitSprite;
import com.unciv.ui.components.tilegroups.layers.TileLayerYield;
import com.unciv.utils.DebugUtils;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u0007H\u0016J\b\u0010]\u001a\u00020\u0000H\u0016J\u001a\u0010^\u001a\u00020[2\b\u0010_\u001a\u0004\u0018\u00010`2\u0006\u0010a\u001a\u00020\u0007H\u0016J\u000e\u0010b\u001a\u00020\u00162\u0006\u0010c\u001a\u00020dJ\b\u0010e\u001a\u00020[H\u0002J\u0010\u0010f\u001a\u00020[2\u0006\u0010g\u001a\u00020hH\u0002J\u0010\u0010i\u001a\u00020[2\u0006\u0010j\u001a\u00020\u0016H\u0002J\u001e\u0010k\u001a\u00020[2\n\b\u0002\u0010c\u001a\u0004\u0018\u00010d2\b\b\u0002\u0010g\u001a\u00020hH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\u0017\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\u00020#\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010\u001f\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\u00020(\u00a2\u0006\u000e\n\u0000\u0012\u0004\b)\u0010\u001f\u001a\u0004\b*\u0010+R\u0017\u0010,\u001a\u00020-\u00a2\u0006\u000e\n\u0000\u0012\u0004\b.\u0010\u001f\u001a\u0004\b/\u00100R\u0017\u00101\u001a\u000202\u00a2\u0006\u000e\n\u0000\u0012\u0004\b3\u0010\u001f\u001a\u0004\b4\u00105R\u0017\u00106\u001a\u000207\u00a2\u0006\u000e\n\u0000\u0012\u0004\b8\u0010\u001f\u001a\u0004\b9\u0010:R\u0017\u0010;\u001a\u00020<\u00a2\u0006\u000e\n\u0000\u0012\u0004\b=\u0010\u001f\u001a\u0004\b>\u0010?R\u0017\u0010@\u001a\u00020A\u00a2\u0006\u000e\n\u0000\u0012\u0004\bB\u0010\u001f\u001a\u0004\bC\u0010DR\u0017\u0010E\u001a\u00020F\u00a2\u0006\u000e\n\u0000\u0012\u0004\bG\u0010\u001f\u001a\u0004\bH\u0010IR\u0017\u0010J\u001a\u00020K\u00a2\u0006\u000e\n\u0000\u0012\u0004\bL\u0010\u001f\u001a\u0004\bM\u0010NR\u0017\u0010O\u001a\u00020P\u00a2\u0006\u000e\n\u0000\u0012\u0004\bQ\u0010\u001f\u001a\u0004\bR\u0010SR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010Y\u00a8\u0006l"}, d2={"Lcom/unciv/ui/components/tilegroups/TileGroup;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "tileSetStrings", "Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "groupSize", "", "(Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/ui/components/tilegroups/TileSetStrings;F)V", "allLayers", "", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "hexagonImageOrigin", "Lkotlin/Pair;", "getHexagonImageOrigin", "()Lkotlin/Pair;", "hexagonImagePosition", "getHexagonImagePosition", "hexagonImageWidth", "getHexagonImageWidth", "()F", "isForMapEditorIcon", "", "()Z", "setForMapEditorIcon", "(Z)V", "isForceVisible", "setForceVisible", "layerBorders", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerBorders;", "getLayerBorders$annotations", "()V", "getLayerBorders", "()Lcom/unciv/ui/components/tilegroups/layers/TileLayerBorders;", "layerCityButton", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerCityButton;", "getLayerCityButton$annotations", "getLayerCityButton", "()Lcom/unciv/ui/components/tilegroups/layers/TileLayerCityButton;", "layerFeatures", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerFeatures;", "getLayerFeatures$annotations", "getLayerFeatures", "()Lcom/unciv/ui/components/tilegroups/layers/TileLayerFeatures;", "layerImprovement", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerImprovement;", "getLayerImprovement$annotations", "getLayerImprovement", "()Lcom/unciv/ui/components/tilegroups/layers/TileLayerImprovement;", "layerMisc", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerMisc;", "getLayerMisc$annotations", "getLayerMisc", "()Lcom/unciv/ui/components/tilegroups/layers/TileLayerMisc;", "layerOverlay", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerOverlay;", "getLayerOverlay$annotations", "getLayerOverlay", "()Lcom/unciv/ui/components/tilegroups/layers/TileLayerOverlay;", "layerResource", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerResource;", "getLayerResource$annotations", "getLayerResource", "()Lcom/unciv/ui/components/tilegroups/layers/TileLayerResource;", "layerTerrain", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerTerrain;", "getLayerTerrain$annotations", "getLayerTerrain", "()Lcom/unciv/ui/components/tilegroups/layers/TileLayerTerrain;", "layerUnitArt", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerUnitSprite;", "getLayerUnitArt$annotations", "getLayerUnitArt", "()Lcom/unciv/ui/components/tilegroups/layers/TileLayerUnitSprite;", "layerUnitFlag", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerUnitFlag;", "getLayerUnitFlag$annotations", "getLayerUnitFlag", "()Lcom/unciv/ui/components/tilegroups/layers/TileLayerUnitFlag;", "layerYield", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerYield;", "getLayerYield$annotations", "getLayerYield", "()Lcom/unciv/ui/components/tilegroups/layers/TileLayerYield;", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "setTile", "(Lcom/unciv/logic/map/tile/Tile;)V", "getTileSetStrings", "()Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "act", "", "delta", "clone", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "isViewable", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "removeMissingModReferences", "reset", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "setAllLayersVisible", "isVisible", "update", "core"})
@SourceDebugExtension(value={"SMAP\nTileGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileGroup.kt\ncom/unciv/ui/components/tilegroups/TileGroup\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,144:1\n2159#2,2:145\n*S KotlinDebug\n*F\n+ 1 TileGroup.kt\ncom/unciv/ui/components/tilegroups/TileGroup\n*L\n116#1:145,2\n*E\n"})
public class TileGroup
extends Group {
    @NotNull
    private Tile tile;
    @NotNull
    private final TileSetStrings tileSetStrings;
    private final float hexagonImageWidth;
    @NotNull
    private final Pair<Float, Float> hexagonImageOrigin;
    @NotNull
    private final Pair<Float, Float> hexagonImagePosition;
    private boolean isForceVisible;
    private boolean isForMapEditorIcon;
    @NotNull
    private final TileLayerTerrain layerTerrain;
    @NotNull
    private final TileLayerFeatures layerFeatures;
    @NotNull
    private final TileLayerBorders layerBorders;
    @NotNull
    private final TileLayerMisc layerMisc;
    @NotNull
    private final TileLayerResource layerResource;
    @NotNull
    private final TileLayerImprovement layerImprovement;
    @NotNull
    private final TileLayerYield layerYield;
    @NotNull
    private final TileLayerOverlay layerOverlay;
    @NotNull
    private final TileLayerUnitSprite layerUnitArt;
    @NotNull
    private final TileLayerUnitFlag layerUnitFlag;
    @NotNull
    private final TileLayerCityButton layerCityButton;
    @NotNull
    private final List<TileLayer> allLayers;

    public TileGroup(@NotNull Tile tile, @NotNull TileSetStrings tileSetStrings, float groupSize) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(tileSetStrings, "tileSetStrings");
        this.tile = tile;
        this.tileSetStrings = tileSetStrings;
        this.hexagonImageWidth = groupSize * 1.5f;
        this.hexagonImageOrigin = new Pair<Float, Float>(Float.valueOf(this.hexagonImageWidth / 2.0f), Float.valueOf((float)Math.sqrt((float)Math.pow(this.hexagonImageWidth / 2.0f, 2) - (float)Math.pow(this.hexagonImageWidth / 4.0f, 2))));
        this.hexagonImagePosition = new Pair<Float, Float>(Float.valueOf(-((Number)this.hexagonImageOrigin.getFirst()).floatValue() / 3.0f), Float.valueOf(-((Number)this.hexagonImageOrigin.getSecond()).floatValue() / 4.0f));
        this.isForceVisible = DebugUtils.INSTANCE.getVISIBLE_MAP();
        this.layerTerrain = new TileLayerTerrain(this, groupSize);
        this.layerFeatures = new TileLayerFeatures(this, groupSize);
        this.layerBorders = new TileLayerBorders(this, groupSize);
        this.layerMisc = new TileLayerMisc(this, groupSize);
        this.layerResource = new TileLayerResource(this, groupSize);
        this.layerImprovement = new TileLayerImprovement(this, groupSize);
        this.layerYield = new TileLayerYield(this, groupSize);
        this.layerOverlay = new TileLayerOverlay(this, groupSize);
        this.layerUnitArt = new TileLayerUnitSprite(this, groupSize);
        this.layerUnitFlag = new TileLayerUnitFlag(this, groupSize);
        this.layerCityButton = new TileLayerCityButton(this, groupSize);
        TileLayer[] tileLayerArray = new TileLayer[]{this.layerTerrain, this.layerFeatures, this.layerBorders, this.layerResource, this.layerImprovement, this.layerMisc, this.layerYield, this.layerOverlay, this.layerUnitArt, this.layerUnitFlag, this.layerCityButton};
        this.allLayers = CollectionsKt.listOf(tileLayerArray);
        this.setSize(groupSize, groupSize);
        this.setTransform(false);
        for (TileLayer layer : this.allLayers) {
            this.addActor(layer);
        }
        TileLayer.update$default(this.layerTerrain, null, null, 2, null);
    }

    public /* synthetic */ TileGroup(Tile tile, TileSetStrings tileSetStrings, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f = 54.0f;
        }
        this(tile, tileSetStrings, f);
    }

    @NotNull
    public final Tile getTile() {
        return this.tile;
    }

    public final void setTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "<set-?>");
        this.tile = tile;
    }

    @NotNull
    public final TileSetStrings getTileSetStrings() {
        return this.tileSetStrings;
    }

    public final float getHexagonImageWidth() {
        return this.hexagonImageWidth;
    }

    @NotNull
    public final Pair<Float, Float> getHexagonImageOrigin() {
        return this.hexagonImageOrigin;
    }

    @NotNull
    public final Pair<Float, Float> getHexagonImagePosition() {
        return this.hexagonImagePosition;
    }

    public final boolean isForceVisible() {
        return this.isForceVisible;
    }

    public final void setForceVisible(boolean bl) {
        this.isForceVisible = bl;
    }

    public final boolean isForMapEditorIcon() {
        return this.isForMapEditorIcon;
    }

    public final void setForMapEditorIcon(boolean bl) {
        this.isForMapEditorIcon = bl;
    }

    @NotNull
    public final TileLayerTerrain getLayerTerrain() {
        return this.layerTerrain;
    }

    public static /* synthetic */ void getLayerTerrain$annotations() {
    }

    @NotNull
    public final TileLayerFeatures getLayerFeatures() {
        return this.layerFeatures;
    }

    public static /* synthetic */ void getLayerFeatures$annotations() {
    }

    @NotNull
    public final TileLayerBorders getLayerBorders() {
        return this.layerBorders;
    }

    public static /* synthetic */ void getLayerBorders$annotations() {
    }

    @NotNull
    public final TileLayerMisc getLayerMisc() {
        return this.layerMisc;
    }

    public static /* synthetic */ void getLayerMisc$annotations() {
    }

    @NotNull
    public final TileLayerResource getLayerResource() {
        return this.layerResource;
    }

    public static /* synthetic */ void getLayerResource$annotations() {
    }

    @NotNull
    public final TileLayerImprovement getLayerImprovement() {
        return this.layerImprovement;
    }

    public static /* synthetic */ void getLayerImprovement$annotations() {
    }

    @NotNull
    public final TileLayerYield getLayerYield() {
        return this.layerYield;
    }

    public static /* synthetic */ void getLayerYield$annotations() {
    }

    @NotNull
    public final TileLayerOverlay getLayerOverlay() {
        return this.layerOverlay;
    }

    public static /* synthetic */ void getLayerOverlay$annotations() {
    }

    @NotNull
    public final TileLayerUnitSprite getLayerUnitArt() {
        return this.layerUnitArt;
    }

    public static /* synthetic */ void getLayerUnitArt$annotations() {
    }

    @NotNull
    public final TileLayerUnitFlag getLayerUnitFlag() {
        return this.layerUnitFlag;
    }

    public static /* synthetic */ void getLayerUnitFlag$annotations() {
    }

    @NotNull
    public final TileLayerCityButton getLayerCityButton() {
        return this.layerCityButton;
    }

    public static /* synthetic */ void getLayerCityButton$annotations() {
    }

    @NotNull
    public TileGroup clone() {
        return new TileGroup(this.tile, this.tileSetStrings, 0.0f, 4, null);
    }

    public final boolean isViewable(@NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        return this.isForceVisible || viewingCiv.getViewableTiles().contains(this.tile) || viewingCiv.isSpectator();
    }

    private final void reset(LocalUniqueCache localUniqueCache) {
        this.layerTerrain.reset();
        this.layerBorders.reset();
        this.layerMisc.reset();
        this.layerResource.reset();
        this.layerImprovement.reset();
        this.layerYield.reset(localUniqueCache);
        this.layerOverlay.reset();
        this.layerUnitArt.reset();
        this.layerUnitFlag.reset();
    }

    private final void setAllLayersVisible(boolean isVisible) {
        for (TileLayer layer : this.allLayers) {
            layer.setVisible(isVisible);
        }
    }

    public void update(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        this.layerMisc.removeHexOutline();
        this.layerMisc.hideTerrainOverlay();
        this.layerOverlay.hideHighlight();
        this.layerOverlay.hideCrosshair();
        this.layerOverlay.hideGoodCityLocationIndicator();
        boolean wasPreviouslyVisible = this.layerTerrain.isVisible();
        this.setAllLayersVisible(true);
        if (viewingCiv != null && !this.isForceVisible && !viewingCiv.hasExplored(this.tile)) {
            boolean bl;
            block6: {
                this.reset(localUniqueCache);
                Sequence<Tile> $this$none$iv = this.tile.getNeighbors();
                boolean $i$f$none = false;
                Iterator<Tile> iterator2 = $this$none$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!viewingCiv.hasExplored(it)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            if (bl) {
                this.setAllLayersVisible(false);
            } else {
                this.layerOverlay.setUnexplored(viewingCiv);
            }
            return;
        }
        this.removeMissingModReferences();
        for (TileLayer layer : this.allLayers) {
            layer.update(viewingCiv, localUniqueCache);
        }
        if (!wasPreviouslyVisible) {
            this.layerTerrain.getParent().addAction(Actions.sequence(Actions.targeting(this.layerTerrain, Actions.alpha(0.0f)), Actions.targeting(this.layerTerrain, Actions.fadeIn(0.5f))));
        }
    }

    public static /* synthetic */ void update$default(TileGroup tileGroup, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 1) != 0) {
            civilization = null;
        }
        if ((n & 2) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        tileGroup.update(civilization, localUniqueCache);
    }

    private final void removeMissingModReferences() {
        Iterator<MapUnit> iterator2 = this.tile.getUnits().iterator();
        while (iterator2.hasNext()) {
            MapUnit unit = iterator2.next();
            if (this.tile.getRuleset().getNations().containsKey(unit.getOwner())) continue;
            unit.removeFromTile();
        }
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    @Override
    public void act(float delta) {
    }
}

