/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.tilegroups.CityButton;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.utils.DebugUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u001a\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\nJ\u0006\u0010\u001c\u001a\u00020\nR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerCityButton;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "cityButton", "Lcom/unciv/ui/components/tilegroups/CityButton;", "act", "", "delta", "doUpdate", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "hit", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "x", "y", "touchable", "", "moveDown", "moveUp", "core"})
public final class TileLayerCityButton
extends TileLayer {
    @Nullable
    private CityButton cityButton;

    public TileLayerCityButton(@NotNull TileGroup tileGroup, float size2) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size2);
        this.setTouchable(Touchable.childrenOnly);
        this.setOrigin(1);
    }

    @Override
    public void act(float delta) {
        if (this.getTile().isCityCenter()) {
            super.act(delta);
        }
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        if (this.getTile().isCityCenter()) {
            return super.hit(x, y, touchable);
        }
        return null;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        if (this.getTile().isCityCenter()) {
            super.draw(batch, parentAlpha);
        }
    }

    public final void moveUp() {
        block0: {
            CityButton cityButton = this.cityButton;
            if (cityButton == null) break block0;
            cityButton.moveButtonUp();
        }
    }

    public final void moveDown() {
        block0: {
            CityButton cityButton = this.cityButton;
            if (cityButton == null) break block0;
            cityButton.moveButtonDown();
        }
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        if (!(this.getTileGroup() instanceof WorldTileGroup)) {
            return;
        }
        City city2 = this.getTile().getCity();
        if (city2 == null && this.cityButton != null) {
            CityButton cityButton = this.cityButton;
            Intrinsics.checkNotNull(cityButton);
            cityButton.remove();
            this.cityButton = null;
        }
        if (viewingCiv == null) {
            return;
        }
        if (city2 == null || !this.getTileGroup().getTile().isCityCenter()) {
            return;
        }
        if (this.cityButton == null) {
            this.cityButton = new CityButton(city2, this.getTileGroup());
            this.addActor(this.cityButton);
        }
        CityButton cityButton = this.cityButton;
        Intrinsics.checkNotNull(cityButton);
        cityButton.update(DebugUtils.INSTANCE.getVISIBLE_MAP() || this.isViewable(viewingCiv));
    }
}

