/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.objectdescriptions;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.NamedStats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.PortraitUnavailableWonderForTechTree;
import com.unciv.ui.objectdescriptions.DescriptionHelpersKt;
import com.unciv.ui.objectdescriptions.TechnologyDescriptions;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0002J(\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0002J4\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0002J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00042\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u0004\u0018\u00010\u001e*\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000b*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010%\u001a\u00020\u001a*\u00020&2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010'\u001a\u00020\u001a*\u00020&2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\f\u0010(\u001a\u00020\u001a*\u00020&H\u0002\u00a8\u0006*"}, d2={"Lcom/unciv/ui/objectdescriptions/TechnologyDescriptions;", "", "()V", "getAffectedImprovements", "Lkotlin/sequences/Sequence;", "Lcom/unciv/ui/objectdescriptions/TechnologyDescriptions$ImprovementAndUnique;", "techName", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getCivilopediaTextLines", "", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "technology", "Lcom/unciv/models/ruleset/tech/Technology;", "getDescription", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "getEnabledBuildings", "Lcom/unciv/models/ruleset/Building;", "civInfo", "getEnabledUnits", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "getFilteredBuildings", "predicate", "Lkotlin/Function1;", "", "getObsoletedObjects", "Lcom/unciv/models/ruleset/RulesetStatsObject;", "getTechEnabledIcons", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "tech", "techIconSize", "", "getObsoletedIcon", "getSeeAlsoObjects", "Lcom/unciv/models/ruleset/IRulesetObject;", "isImprovementStatsEnabledByTech", "Lcom/unciv/models/ruleset/unique/Unique;", "isRelatedToTech", "isTechConditional", "ImprovementAndUnique", "core"})
@SourceDebugExtension(value={"SMAP\nTechnologyDescriptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TechnologyDescriptions.kt\ncom/unciv/ui/objectdescriptions/TechnologyDescriptions\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,378:1\n2707#2,10:379\n2707#2,10:397\n1313#2,2:409\n1313#2,2:411\n1#3:389\n1855#4,2:390\n766#4:392\n857#4,2:393\n1855#4,2:395\n1855#4,2:407\n1855#4,2:413\n766#4:415\n857#4,2:416\n1747#4,3:418\n1747#4,3:421\n*S KotlinDebug\n*F\n+ 1 TechnologyDescriptions.kt\ncom/unciv/ui/objectdescriptions/TechnologyDescriptions\n*L\n57#1:379,10\n213#1:397,10\n240#1:409,2\n249#1:411,2\n175#1:390,2\n181#1:392\n181#1:393,2\n188#1:395,2\n232#1:407,2\n258#1:413,2\n286#1:415\n286#1:416,2\n339#1:418,3\n348#1:421,3\n*E\n"})
public final class TechnologyDescriptions {
    @NotNull
    public static final TechnologyDescriptions INSTANCE = new TechnologyDescriptions();

    private TechnologyDescriptions() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getDescription(@NotNull Technology technology2, @NotNull Civilization viewingCiv) {
        Object obj;
        void $this$partition$iv;
        Object unit;
        Object object;
        Intrinsics.checkNotNullParameter(technology2, "technology");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        Technology $this$getDescription_u24lambda_u241 = technology2;
        boolean bl = false;
        Ruleset ruleset2 = viewingCiv.getGameInfo().getRuleset();
        ArrayList lineList = new ArrayList();
        for (FormattedLine pediaText : technology2.getCivilopediaText()) {
            if (((CharSequence)pediaText.getText()).length() == 0 || pediaText.getHeader() != 0) continue;
            ((Collection)lineList).add(pediaText.getText());
        }
        DescriptionHelpersKt.uniquesToDescription$default($this$getDescription_u24lambda_u241, lineList, null, 2, null);
        CollectionsKt.addAll((Collection)lineList, SequencesKt.map(SequencesKt.filter(INSTANCE.getAffectedImprovements($this$getDescription_u24lambda_u241.getName(), ruleset2), (Function1)new Function1<ImprovementAndUnique, Boolean>(viewingCiv){
            final /* synthetic */ Civilization $viewingCiv;
            {
                this.$viewingCiv = $viewingCiv;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull ImprovementAndUnique it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getImprovement().getUniqueTo() != null) {
                    String string = it.getImprovement().getUniqueTo();
                    Intrinsics.checkNotNull(string);
                    if (!Civilization.matchesFilter$default(this.$viewingCiv, string, null, false, 6, null)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        }), getDescription.1.2.INSTANCE));
        Sequence<BaseUnit> enabledUnits = INSTANCE.getEnabledUnits($this$getDescription_u24lambda_u241.getName(), ruleset2, viewingCiv);
        if (SequencesKt.any(enabledUnits)) {
            ((Collection)lineList).add("{Units enabled}: ");
            object = enabledUnits.iterator();
            while (object.hasNext()) {
                unit = object.next();
                ((Collection)lineList).add(" \u2022 " + TranslationsKt.tr$default(((RulesetObject)unit).getName(), false, false, 3, null) + " (" + ((BaseUnit)unit).getShortDescription((Function1<? super Unique, Boolean>)new Function1<Unique, Boolean>((Object)technology2){

                    @NotNull
                    public final Boolean invoke(@NotNull Unique p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Technology)this.receiver).uniqueIsRequirementForThisTech(p0);
                    }
                }) + ")\n");
            }
        }
        unit = INSTANCE.getEnabledBuildings($this$getDescription_u24lambda_u241.getName(), ruleset2, viewingCiv);
        boolean $i$f$partition = false;
        Iterator<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Building it = (Building)element$iv;
            boolean bl2 = false;
            if (it.isAnyWonder()) {
                ((ArrayList)((Object)first$iv)).add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        object = new Pair(first$iv, second$iv);
        List wonders = (List)((Pair)object).component1();
        List regularBuildings = (List)((Pair)object).component2();
        if (!((Collection)regularBuildings).isEmpty()) {
            ((Collection)lineList).add("{Buildings enabled}: ");
            for (Building building : regularBuildings) {
                ((Collection)lineList).add(" \u2022 " + TranslationsKt.tr$default(building.getName(), false, false, 3, null) + " (" + Building.getShortDescription$default(building, false, new Function1<Unique, Boolean>((Object)technology2){

                    @NotNull
                    public final Boolean invoke(@NotNull Unique p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Technology)this.receiver).uniqueIsNotRequirementForThisTech(p0);
                    }
                }, 1, null) + ")\n");
            }
        }
        if (!((Collection)wonders).isEmpty()) {
            ((Collection)lineList).add("{Wonders enabled}: ");
            for (Building wonder : wonders) {
                ((Collection)lineList).add(" \u2022 " + TranslationsKt.tr$default(wonder.getName(), false, false, 3, null) + " (" + Building.getShortDescription$default(wonder, false, new Function1<Unique, Boolean>((Object)technology2){

                    @NotNull
                    public final Boolean invoke(@NotNull Unique p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Technology)this.receiver).uniqueIsNotRequirementForThisTech(p0);
                    }
                }, 1, null) + ")\n");
            }
        }
        first$iv = INSTANCE.getObsoletedObjects($this$getDescription_u24lambda_u241.getName(), ruleset2, viewingCiv).iterator();
        while (first$iv.hasNext()) {
            obj = (RulesetStatsObject)first$iv.next();
            ((Collection)lineList).add('[' + ((NamedStats)obj).getName() + "] obsoleted");
        }
        Collection<TileResource> collection = ruleset2.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Sequence resourcesRevealed2 = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<TileResource, Boolean>($this$getDescription_u24lambda_u241){
            final /* synthetic */ Technology $this_run;
            {
                this.$this_run = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TileResource it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getRevealedBy(), this.$this_run.getName());
            }
        }), getDescription.1.resourcesRevealed.2.INSTANCE);
        obj = resourcesRevealed2.iterator();
        while (obj.hasNext()) {
            String resource2 = (String)obj.next();
            ((Collection)lineList).add("Reveals [" + resource2 + "] on the map");
        }
        Collection<TileImprovement> collection2 = ruleset2.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        List tileImprovements2 = SequencesKt.toList(SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), (Function1)new Function1<TileImprovement, Boolean>($this$getDescription_u24lambda_u241){
            final /* synthetic */ Technology $this_run;
            {
                this.$this_run = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TileImprovement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getTechRequired(), this.$this_run.getName());
            }
        }), (Function1)new Function1<TileImprovement, Boolean>(viewingCiv){
            final /* synthetic */ Civilization $viewingCiv;
            {
                this.$viewingCiv = $viewingCiv;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull TileImprovement it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getUniqueTo() != null) {
                    String string = it.getUniqueTo();
                    Intrinsics.checkNotNull(string);
                    if (!Civilization.matchesFilter$default(this.$viewingCiv, string, null, false, 6, null)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        }));
        if (!((Collection)tileImprovements2).isEmpty()) {
            ((Collection)lineList).add("{Tile improvements enabled}: " + CollectionsKt.joinToString$default(tileImprovements2, null, null, null, 0, null, getDescription.1.7.INSTANCE, 31, null));
        }
        return CollectionsKt.joinToString$default(lineList, "\n", null, null, 0, null, getDescription.1.8.INSTANCE, 30, null);
    }

    @NotNull
    public final Sequence<Group> getTechEnabledIcons(@NotNull Technology tech, @NotNull Civilization viewingCiv, float techIconSize) {
        Intrinsics.checkNotNullParameter(tech, "tech");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Group>, Continuation<? super Unit>, Object>(viewingCiv, tech, techIconSize, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Civilization $viewingCiv;
            final /* synthetic */ Technology $tech;
            final /* synthetic */ float $techIconSize;
            {
                this.$viewingCiv = $viewingCiv;
                this.$tech = $tech;
                this.$techIconSize = $techIconSize;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block20: {
                    var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            ruleset = this.$viewingCiv.getGameInfo().getRuleset();
                            techName = this.$tech.getName();
                            var5_6 /* !! */  = TechnologyDescriptions.access$getEnabledUnits(TechnologyDescriptions.INSTANCE, techName, ruleset, this.$viewingCiv).iterator();
lbl9:
                            // 3 sources

                            while (var5_6 /* !! */ .hasNext()) {
                                unit = (BaseUnit)var5_6 /* !! */ .next();
                                this.L$0 = $this$sequence;
                                this.L$1 = ruleset;
                                this.L$2 = techName;
                                this.L$3 = var5_6 /* !! */ ;
                                this.label = 1;
                                v0 = $this$sequence.yield(ImageGetter.INSTANCE.getConstructionPortrait(unit.getName(), this.$techIconSize), this);
                                if (v0 != var15_2) continue;
                                return var15_2;
                            }
                            break;
                        }
                        case 1: {
                            var5_6 /* !! */  = (Iterator<Unique>)this.L$3;
                            techName = (String)this.L$2;
                            ruleset = (Ruleset)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
                            ** GOTO lbl9
                        }
                    }
                    var5_6 /* !! */  = TechnologyDescriptions.access$getEnabledBuildings(TechnologyDescriptions.INSTANCE, techName, ruleset, this.$viewingCiv).iterator();
lbl29:
                    // 5 sources

                    while (var5_6 /* !! */ .hasNext()) {
                        block21: {
                            building = (Building)var5_6 /* !! */ .next();
                            if (!building.isWonder() || this.$viewingCiv.getTech().isResearched(techName)) break block20;
                            $this$any$iv = SequencesKt.filter(this.$viewingCiv.getGameInfo().getCities(), (Function1)new Function1<City, Boolean>(this.$viewingCiv){
                                final /* synthetic */ Civilization $viewingCiv;
                                {
                                    this.$viewingCiv = $viewingCiv;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull City it) {
                                    Intrinsics.checkNotNullParameter(it, "it");
                                    return !Intrinsics.areEqual(it.getCiv(), this.$viewingCiv);
                                }
                            });
                            $i$f$any = false;
                            var10_12 = $this$any$iv.iterator();
                            while (var10_12.hasNext()) {
                                it = element$iv = var10_12.next();
                                $i$a$-any-TechnologyDescriptions$getTechEnabledIcons$1$isAlreadyBuilt$2 = false;
                                if (!it.getCityConstructions().isBuilt(building.getName())) continue;
                                v1 = true;
                                break block21;
                            }
                            v1 = false;
                        }
                        isAlreadyBuilt = v1;
                        wonderConstructionPortrait = isAlreadyBuilt != false ? (Group)new PortraitUnavailableWonderForTechTree(building.getName(), this.$techIconSize) : ImageGetter.INSTANCE.getConstructionPortrait(building.getName(), this.$techIconSize);
                        this.L$0 = $this$sequence;
                        this.L$1 = ruleset;
                        this.L$2 = techName;
                        this.L$3 = var5_6 /* !! */ ;
                        this.label = 2;
                        v2 = $this$sequence.yield(wonderConstructionPortrait, this);
                        if (v2 != var15_2) continue;
                        return var15_2;
                    }
                    {
                        break;
                        case 2: {
                            var5_6 /* !! */  = (Iterator)this.L$3;
                            techName = (String)this.L$2;
                            ruleset = (Ruleset)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
                            ** GOTO lbl29
                        }
                    }
                }
                this.L$0 = $this$sequence;
                this.L$1 = ruleset;
                this.L$2 = techName;
                this.L$3 = var5_6 /* !! */ ;
                this.label = 3;
                v3 = $this$sequence.yield(ImageGetter.INSTANCE.getConstructionPortrait(building.getName(), this.$techIconSize), this);
                if (v3 != var15_2) ** GOTO lbl29
                return var15_2;
                {
                    case 3: {
                        var5_6 /* !! */  = (Iterator)this.L$3;
                        techName = (String)this.L$2;
                        ruleset = (Ruleset)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
                        ** GOTO lbl29
                    }
                }
                this.L$0 = $this$sequence;
                this.L$1 = ruleset;
                this.L$2 = techName;
                this.L$3 = null;
                this.label = 4;
                v4 = $this$sequence.yieldAll(SequencesKt.mapNotNull(TechnologyDescriptions.access$getObsoletedObjects(TechnologyDescriptions.INSTANCE, techName, ruleset, this.$viewingCiv), (Function1)new Function1<RulesetStatsObject, Group>(this.$techIconSize){
                    final /* synthetic */ float $techIconSize;
                    {
                        this.$techIconSize = $techIconSize;
                        super(1);
                    }

                    @Nullable
                    public final Group invoke(@NotNull RulesetStatsObject it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return TechnologyDescriptions.access$getObsoletedIcon(TechnologyDescriptions.INSTANCE, it, this.$techIconSize);
                    }
                }), (Continuation<Unit>)this);
                if (v4 == var15_2) {
                    return var15_2;
                }
                ** GOTO lbl94
                {
                    case 4: {
                        techName = (String)this.L$2;
                        ruleset = (Ruleset)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl94:
                        // 2 sources

                        v5 = ruleset.getTileResources().values();
                        Intrinsics.checkNotNullExpressionValue(v5, "<get-values>(...)");
                        $this$filter$iv = v5;
                        $i$f$filter = false;
                        wonderConstructionPortrait = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (TileResource)element$iv$iv;
                            $i$a$-filter-TechnologyDescriptions$getTechEnabledIcons$1$2 = false;
                            if (!Intrinsics.areEqual(it.getRevealedBy(), techName)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        var5_6 /* !! */  = ((List)destination$iv$iv).iterator();
lbl109:
                        // 3 sources

                        while (var5_6 /* !! */ .hasNext()) {
                            resource = (TileResource)var5_6 /* !! */ .next();
                            this.L$0 = $this$sequence;
                            this.L$1 = ruleset;
                            this.L$2 = techName;
                            this.L$3 = var5_6 /* !! */ ;
                            this.label = 5;
                            v6 = $this$sequence.yield(ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, resource.getName(), this.$techIconSize, 0, 4, null), this);
                            if (v6 != var15_2) continue;
                            return var15_2;
                        }
                        break;
                    }
                    case 5: {
                        var5_6 /* !! */  = (Iterator)this.L$3;
                        techName = (String)this.L$2;
                        ruleset = (Ruleset)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v6 = $result;
                        ** GOTO lbl109
                    }
                }
                v7 = ruleset.getTileImprovements().values();
                Intrinsics.checkNotNullExpressionValue(v7, "<get-values>(...)");
                var5_6 /* !! */  = SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence((Iterable)v7), (Function1)new Function1<TileImprovement, Boolean>(techName){
                    final /* synthetic */ String $techName;
                    {
                        this.$techName = $techName;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull TileImprovement it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return Intrinsics.areEqual(it.getTechRequired(), this.$techName);
                    }
                }), (Function1)new Function1<TileImprovement, Boolean>(this.$viewingCiv){
                    final /* synthetic */ Civilization $viewingCiv;
                    {
                        this.$viewingCiv = $viewingCiv;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull TileImprovement it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (it.getUniqueTo() != null) {
                            String string = it.getUniqueTo();
                            Intrinsics.checkNotNull(string);
                            if (!Civilization.matchesFilter$default(this.$viewingCiv, string, null, false, 6, null)) {
                                bl = false;
                                return bl;
                            }
                        }
                        bl = true;
                        return bl;
                    }
                }).iterator();
lbl131:
                // 3 sources

                while (var5_6 /* !! */ .hasNext()) {
                    improvement = (TileImprovement)var5_6 /* !! */ .next();
                    this.L$0 = $this$sequence;
                    this.L$1 = ruleset;
                    this.L$2 = techName;
                    this.L$3 = var5_6 /* !! */ ;
                    this.label = 6;
                    v8 = $this$sequence.yield(ImageGetter.getImprovementPortrait$default(ImageGetter.INSTANCE, improvement.getName(), this.$techIconSize, false, 4, null), this);
                    if (v8 != var15_2) continue;
                    return var15_2;
                }
                {
                    break;
                    case 6: {
                        var5_6 /* !! */  = (Iterator)this.L$3;
                        techName = (String)this.L$2;
                        ruleset = (Ruleset)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v8 = $result;
                        ** GOTO lbl131
                    }
                }
                improvement = ruleset.getTileImprovements().values();
                Intrinsics.checkNotNullExpressionValue(improvement, "<get-values>(...)");
                var5_6 /* !! */  = SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence(improvement), (Function1)new Function1<TileImprovement, Boolean>(techName){
                    final /* synthetic */ String $techName;
                    {
                        this.$techName = $techName;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull TileImprovement it) {
                        boolean bl;
                        block3: {
                            void $this$any$iv;
                            Intrinsics.checkNotNullParameter(it, "it");
                            Iterable iterable = it.getUniqueObjects();
                            String string = this.$techName;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    Unique u = (Unique)element$iv;
                                    boolean bl2 = false;
                                    if (!u.getAllParams().contains(string)) continue;
                                    bl = true;
                                    break block3;
                                }
                                bl = false;
                            }
                        }
                        return bl;
                    }
                }), (Function1)new Function1<TileImprovement, Boolean>(this.$viewingCiv){
                    final /* synthetic */ Civilization $viewingCiv;
                    {
                        this.$viewingCiv = $viewingCiv;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull TileImprovement it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (it.getUniqueTo() != null) {
                            String string = it.getUniqueTo();
                            Intrinsics.checkNotNull(string);
                            if (!Civilization.matchesFilter$default(this.$viewingCiv, string, null, false, 6, null)) {
                                bl = false;
                                return bl;
                            }
                        }
                        bl = true;
                        return bl;
                    }
                }).iterator();
lbl153:
                // 3 sources

                while (var5_6 /* !! */ .hasNext()) {
                    improvement = (TileImprovement)var5_6 /* !! */ .next();
                    this.L$0 = $this$sequence;
                    this.L$1 = var5_6 /* !! */ ;
                    this.L$2 = null;
                    this.L$3 = null;
                    this.label = 7;
                    v9 = $this$sequence.yield(ImageGetter.INSTANCE.getUniquePortrait(improvement.getName(), this.$techIconSize), this);
                    if (v9 != var15_2) continue;
                    return var15_2;
                }
                {
                    break;
                    case 7: {
                        var5_6 /* !! */  = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v9 = $result;
                        ** GOTO lbl153
                    }
                }
                var5_6 /* !! */  = this.$tech.getUniqueObjects().iterator();
lbl171:
                // 4 sources

                while (var5_6 /* !! */ .hasNext()) {
                    unique = (Unique)var5_6 /* !! */ .next();
                    if (unique.isHiddenToUsers()) continue;
                    this.L$0 = $this$sequence;
                    this.L$1 = var5_6 /* !! */ ;
                    this.L$2 = null;
                    this.L$3 = null;
                    this.label = 8;
                    v10 = $this$sequence.yield(unique.getType() == UniqueType.EnablesCivWideStatProduction ? ImageGetter.INSTANCE.getConstructionPortrait(unique.getParams().get(0), this.$techIconSize) : ImageGetter.INSTANCE.getUniquePortrait(unique.getText(), this.$techIconSize), this);
                    if (v10 != var15_2) continue;
                    return var15_2;
                }
                {
                    break;
                    case 8: {
                        var5_6 /* !! */  = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v10 = $result;
                        ** GOTO lbl171
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super Group>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Group> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FormattedLine> getCivilopediaTextLines(@NotNull Technology technology2, @NotNull Ruleset ruleset2) {
        List<IRulesetObject> seeAlsoObjects;
        List<RulesetStatsObject> obsoletedObjects;
        void $this$partition$iv;
        Object unit;
        Sequence<BaseUnit> enabledUnits;
        void $this$filterTo$iv$iv;
        Iterable element$iv2;
        Intrinsics.checkNotNullParameter(technology2, "technology");
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        Technology $this$getCivilopediaTextLines_u24lambda_u2412 = technology2;
        boolean bl = false;
        ArrayList lineList = new ArrayList();
        Object object = ruleset2.getEras().get($this$getCivilopediaTextLines_u24lambda_u2412.era());
        if (object == null || (object = ((Era)object).getHexColor()) == null) {
            object = "";
        }
        Object eraColor = object;
        ((Collection)lineList).add(new FormattedLine($this$getCivilopediaTextLines_u24lambda_u2412.era(), null, null, null, 0.0f, 0, 3, 0, 0.0f, (String)eraColor, false, false, false, false, 15806, null));
        ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        ((Collection)lineList).add(new FormattedLine("{Cost}: " + $this$getCivilopediaTextLines_u24lambda_u2412.getCost() + '\u237e', null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        if (!((Collection)$this$getCivilopediaTextLines_u24lambda_u2412.getPrerequisites()).isEmpty()) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            if ($this$getCivilopediaTextLines_u24lambda_u2412.getPrerequisites().size() == 1) {
                String it = (String)CollectionsKt.first((Iterable)$this$getCivilopediaTextLines_u24lambda_u2412.getPrerequisites());
                boolean bl2 = false;
                ((Collection)lineList).add(new FormattedLine("Required tech: [" + it + ']', "Technology/" + it, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            } else {
                ((Collection)lineList).add(new FormattedLine("Requires all of the following:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                Iterable $this$forEach$iv = $this$getCivilopediaTextLines_u24lambda_u2412.getPrerequisites();
                boolean $i$f$forEach = false;
                for (Iterable element$iv2 : $this$forEach$iv) {
                    String it = (String)((Object)element$iv2);
                    boolean bl3 = false;
                    ((Collection)lineList).add(new FormattedLine(it, "Technology/" + it, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
                }
            }
        }
        Collection<Technology> collection = ruleset2.getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Technology it = (Technology)element$iv$iv;
            boolean bl4 = false;
            if (!it.getPrerequisites().contains($this$getCivilopediaTextLines_u24lambda_u2412.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List leadsTo = (List)destination$iv$iv;
        if (!((Collection)leadsTo).isEmpty()) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            if (leadsTo.size() == 1) {
                Technology it = (Technology)CollectionsKt.first(leadsTo);
                boolean bl5 = false;
                ((Collection)lineList).add(new FormattedLine("Leads to [" + it.getName() + ']', it.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            } else {
                ((Collection)lineList).add(new FormattedLine("Leads to:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                Iterable $this$forEach$iv = leadsTo;
                boolean $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    Technology it = (Technology)element$iv3;
                    boolean bl6 = false;
                    ((Collection)lineList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
                }
            }
        }
        DescriptionHelpersKt.uniquesToCivilopediaTextLines$default($this$getCivilopediaTextLines_u24lambda_u2412, lineList, null, false, null, 14, null);
        Sequence<ImprovementAndUnique> affectedImprovements = INSTANCE.getAffectedImprovements($this$getCivilopediaTextLines_u24lambda_u2412.getName(), ruleset2);
        if (SequencesKt.any(affectedImprovements)) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            Iterator<ImprovementAndUnique> $i$f$forEach = affectedImprovements.iterator();
            while ($i$f$forEach.hasNext()) {
                ImprovementAndUnique entry = $i$f$forEach.next();
                ((Collection)lineList).add(new FormattedLine(entry.getText(), entry.getImprovement().makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        if (SequencesKt.any(enabledUnits = INSTANCE.getEnabledUnits($this$getCivilopediaTextLines_u24lambda_u2412.getName(), ruleset2, null))) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lineList).add(new FormattedLine("{Units enabled}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterator<BaseUnit> iterator2 = enabledUnits.iterator();
            while (iterator2.hasNext()) {
                unit = iterator2.next();
                ((Collection)lineList).add(new FormattedLine(TranslationsKt.tr$default(((RulesetObject)unit).getName(), true, false, 2, null) + " (" + ((BaseUnit)unit).getShortDescription((Function1<? super Unique, Boolean>)new Function1<Unique, Boolean>((Object)technology2){

                    @NotNull
                    public final Boolean invoke(@NotNull Unique p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Technology)this.receiver).uniqueIsRequirementForThisTech(p0);
                    }
                }) + ')', ((BaseUnit)unit).makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        unit = INSTANCE.getEnabledBuildings($this$getCivilopediaTextLines_u24lambda_u2412.getName(), ruleset2, null);
        boolean $i$f$partition = false;
        Iterator first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv4 : $this$partition$iv) {
            Building it = (Building)element$iv4;
            boolean bl7 = false;
            if (it.isAnyWonder()) {
                ((ArrayList)((Object)first$iv)).add(element$iv4);
                continue;
            }
            second$iv.add(element$iv4);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List wonders = pair.component1();
        List regularBuildings = pair.component2();
        if (!((Collection)wonders).isEmpty()) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lineList).add(new FormattedLine("{Wonders enabled}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            for (Building wonder : wonders) {
                ((Collection)lineList).add(new FormattedLine(TranslationsKt.tr$default(wonder.getName(), true, false, 2, null) + " (" + Building.getShortDescription$default(wonder, false, new Function1<Unique, Boolean>((Object)technology2){

                    @NotNull
                    public final Boolean invoke(@NotNull Unique p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Technology)this.receiver).uniqueIsNotRequirementForThisTech(p0);
                    }
                }, 1, null) + ')', wonder.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        if (!((Collection)regularBuildings).isEmpty()) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lineList).add(new FormattedLine("{Buildings enabled}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            for (Building building : regularBuildings) {
                ((Collection)lineList).add(new FormattedLine(TranslationsKt.tr$default(building.getName(), true, false, 2, null) + " (" + Building.getShortDescription$default(building, false, new Function1<Unique, Boolean>((Object)technology2){

                    @NotNull
                    public final Boolean invoke(@NotNull Unique p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Technology)this.receiver).uniqueIsNotRequirementForThisTech(p0);
                    }
                }, 1, null) + ')', building.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        if (!((Collection)(obsoletedObjects = SequencesKt.toList(INSTANCE.getObsoletedObjects($this$getCivilopediaTextLines_u24lambda_u2412.getName(), ruleset2, null)))).isEmpty()) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            Iterable $this$forEach$iv = obsoletedObjects;
            boolean $i$f$forEach = false;
            for (Object element$iv5 : $this$forEach$iv) {
                RulesetStatsObject it = (RulesetStatsObject)element$iv5;
                boolean bl8 = false;
                ((Collection)lineList).add(new FormattedLine('[' + it.getName() + "] obsoleted", it.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        Collection<TileResource> collection2 = ruleset2.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Sequence revealedResources2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), (Function1)new Function1<TileResource, Boolean>($this$getCivilopediaTextLines_u24lambda_u2412){
            final /* synthetic */ Technology $this_run;
            {
                this.$this_run = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TileResource it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getRevealedBy(), this.$this_run.getName());
            }
        });
        if (SequencesKt.any(revealedResources2)) {
            Object element$iv5;
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            Sequence $this$forEach$iv = revealedResources2;
            boolean $i$f$forEach = false;
            element$iv5 = $this$forEach$iv.iterator();
            while (element$iv5.hasNext()) {
                Object element$iv6 = element$iv5.next();
                TileResource it = (TileResource)element$iv6;
                boolean bl9 = false;
                ((Collection)lineList).add(new FormattedLine("Reveals [" + it.getName() + "] on the map", it.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        Collection<TileImprovement> collection3 = ruleset2.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
        Sequence tileImprovements2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection3), (Function1)new Function1<TileImprovement, Boolean>($this$getCivilopediaTextLines_u24lambda_u2412){
            final /* synthetic */ Technology $this_run;
            {
                this.$this_run = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TileImprovement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getTechRequired(), this.$this_run.getName());
            }
        });
        if (SequencesKt.any(tileImprovements2)) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lineList).add(new FormattedLine("{Tile improvements enabled}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Sequence $this$forEach$iv = tileImprovements2;
            boolean $i$f$forEach = false;
            Iterator element$iv6 = $this$forEach$iv.iterator();
            while (element$iv6.hasNext()) {
                Object element$iv7 = element$iv6.next();
                TileImprovement it = (TileImprovement)element$iv7;
                boolean bl10 = false;
                ((Collection)lineList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        if (!((Collection)(seeAlsoObjects = INSTANCE.getSeeAlsoObjects($this$getCivilopediaTextLines_u24lambda_u2412, ruleset2))).isEmpty()) {
            ((Collection)lineList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lineList).add(new FormattedLine("{See also}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            Iterable $this$forEach$iv = seeAlsoObjects;
            boolean $i$f$forEach = false;
            for (Object element$iv8 : $this$forEach$iv) {
                IRulesetObject it = (IRulesetObject)element$iv8;
                boolean bl11 = false;
                ((Collection)lineList).add(new FormattedLine(it.getName(), it.makeLink(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            }
        }
        return lineList;
    }

    private final Sequence<Building> getEnabledBuildings(String techName, Ruleset ruleset2, Civilization civInfo) {
        return this.getFilteredBuildings(ruleset2, civInfo, (Function1<? super Building, Boolean>)new Function1<Building, Boolean>(techName){
            final /* synthetic */ String $techName;
            {
                this.$techName = $techName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Building it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return SequencesKt.contains(it.requiredTechs(), this.$techName);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private final Sequence<RulesetStatsObject> getObsoletedObjects(String techName, Ruleset ruleset, Civilization civInfo) {
        v0 = this.getFilteredBuildings(ruleset, civInfo, getObsoletedObjects.1.INSTANCE);
        v1 = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(v1, "<get-values>(...)");
        v2 = SequencesKt.plus(v0, CollectionsKt.asSequence((Iterable)v1));
        v3 = ruleset.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(v3, "<get-values>(...)");
        var4_4 = v3;
        var13_5 = v2;
        $i$f$filter = false;
        var6_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileImprovement)element$iv$iv;
            $i$a$-filter-TechnologyDescriptions$getObsoletedObjects$2 = false;
            if (it.getUniqueTo() == null) ** GOTO lbl-1000
            v4 = civInfo;
            if (v4 != null) {
                v5 = it.getUniqueTo();
                Intrinsics.checkNotNull(v5);
                v6 = Civilization.matchesFilter$default(v4, v5, null, false, 6, null);
            } else {
                v6 = false;
            }
            if (v6) lbl-1000:
            // 2 sources

            {
                v7 = true;
            } else {
                v7 = false;
            }
            if (!v7) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return SequencesKt.filter(SequencesKt.plus(var13_5, (List)destination$iv$iv), (Function1)new Function1<RulesetStatsObject, Boolean>(techName){
            final /* synthetic */ String $techName;
            {
                this.$techName = $techName;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull RulesetStatsObject obj) {
                boolean bl;
                block1: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter(obj, "obj");
                    Sequence sequence = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)obj, UniqueType.ObsoleteWith, null, 2, null);
                    String string = this.$techName;
                    boolean $i$f$any = false;
                    for (T element$iv : $this$any$iv) {
                        Unique it = (Unique)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getParams().get(0), string)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
        });
    }

    private final Group getObsoletedIcon(RulesetStatsObject $this$getObsoletedIcon, float techIconSize) {
        Object object;
        Group group;
        Object object2 = $this$getObsoletedIcon;
        Group group2 = object2 instanceof Building ? ImageGetter.INSTANCE.getConstructionPortrait($this$getObsoletedIcon.getName(), techIconSize) : (object2 instanceof TileResource ? ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, $this$getObsoletedIcon.getName(), techIconSize, 0, 4, null) : (group = object2 instanceof TileImprovement ? (Group)ImageGetter.getImprovementPortrait$default(ImageGetter.INSTANCE, $this$getObsoletedIcon.getName(), techIconSize, false, 4, null) : null));
        if (group != null) {
            Object it = object2 = group;
            boolean bl = false;
            Actor closeImage = ImageGetter.INSTANCE.getRedCross(techIconSize / (float)2, 1.0f);
            Scene2dExtensionsKt.center(closeImage, (Actor)it);
            ((Group)it).addActor(closeImage);
            object = object2;
        } else {
            object = null;
        }
        return object;
    }

    private final Sequence<Building> getFilteredBuildings(Ruleset ruleset2, Civilization civInfo, Function1<? super Building, Boolean> predicate) {
        Collection<Building> collection = ruleset2.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<Building, Boolean>(predicate, civInfo, ruleset2){
            final /* synthetic */ Function1<Building, Boolean> $predicate;
            final /* synthetic */ Civilization $civInfo;
            final /* synthetic */ Ruleset $ruleset;
            {
                this.$predicate = $predicate;
                this.$civInfo = $civInfo;
                this.$ruleset = $ruleset;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Building it) {
                boolean bl;
                block6: {
                    block8: {
                        block7: {
                            boolean bl2;
                            Intrinsics.checkNotNullParameter(it, "it");
                            if (!this.$predicate.invoke(it).booleanValue()) break block6;
                            if (it.getUniqueTo() == null) break block7;
                            Civilization civilization = this.$civInfo;
                            if (civilization != null) {
                                String string = it.getUniqueTo();
                                Intrinsics.checkNotNull(string);
                                bl2 = Civilization.matchesFilter$default(civilization, string, null, false, 6, null);
                            } else {
                                bl2 = false;
                            }
                            if (bl2) break block8;
                        }
                        if (it.getUniqueTo() != null || this.$civInfo != null && !Intrinsics.areEqual(this.$civInfo.getEquivalentBuilding(it), it)) break block6;
                    }
                    if (!it.isHiddenFromCivilopedia(this.$ruleset)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        });
    }

    private final Sequence<BaseUnit> getEnabledUnits(String techName, Ruleset ruleset2, Civilization civInfo) {
        Collection<BaseUnit> collection = ruleset2.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<BaseUnit, Boolean>(techName, civInfo, ruleset2){
            final /* synthetic */ String $techName;
            final /* synthetic */ Civilization $civInfo;
            final /* synthetic */ Ruleset $ruleset;
            {
                this.$techName = $techName;
                this.$civInfo = $civInfo;
                this.$ruleset = $ruleset;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull BaseUnit it) {
                boolean bl;
                block6: {
                    block8: {
                        block7: {
                            boolean bl2;
                            Intrinsics.checkNotNullParameter(it, "it");
                            if (!SequencesKt.contains(it.requiredTechs(), this.$techName)) break block6;
                            if (it.getUniqueTo() == null) break block7;
                            Civilization civilization = this.$civInfo;
                            if (civilization != null) {
                                String string = it.getUniqueTo();
                                Intrinsics.checkNotNull(string);
                                bl2 = Civilization.matchesFilter$default(civilization, string, null, false, 6, null);
                            } else {
                                bl2 = false;
                            }
                            if (bl2) break block8;
                        }
                        if (it.getUniqueTo() != null || this.$civInfo != null && !Intrinsics.areEqual(this.$civInfo.getEquivalentUnit(it), it)) break block6;
                    }
                    if (!it.isHiddenFromCivilopedia(this.$ruleset)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isImprovementStatsEnabledByTech(Unique $this$isImprovementStatsEnabledByTech, String techName) {
        Unique it;
        if ($this$isImprovementStatsEnabledByTech.getType() != UniqueType.Stats) {
            if ($this$isImprovementStatsEnabledByTech.getType() != UniqueType.ImprovementStatsOnTile) return false;
        }
        Iterable $this$any$iv = $this$isImprovementStatsEnabledByTech.getModifiers(UniqueType.ConditionalTech);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (Unique)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual(it.getParams().get(0), techName));
        return true;
    }

    private final boolean isTechConditional(Unique $this$isTechConditional) {
        return $this$isTechConditional.getType() == UniqueType.ConditionalTech || $this$isTechConditional.getType() == UniqueType.ConditionalNoTech;
    }

    private final boolean isRelatedToTech(Unique $this$isRelatedToTech, String techName) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$isRelatedToTech.getModifiers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Unique it = (Unique)element$iv;
                    boolean bl2 = false;
                    if (!(INSTANCE.isTechConditional(it) && Intrinsics.areEqual(it.getParams().get(0), techName))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Sequence<ImprovementAndUnique> getAffectedImprovements(String techName, Ruleset ruleset2) {
        Collection<TileImprovement> collection = ruleset2.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<TileImprovement, Sequence<? extends ImprovementAndUnique>>(techName){
            final /* synthetic */ String $techName;
            {
                this.$techName = $techName;
                super(1);
            }

            @NotNull
            public final Sequence<ImprovementAndUnique> invoke(@NotNull TileImprovement improvement2) {
                Intrinsics.checkNotNullParameter(improvement2, "improvement");
                return SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)improvement2.getUniqueObjects()), (Function1)new Function1<Unique, Boolean>(this.$techName){
                    final /* synthetic */ String $techName;
                    {
                        this.$techName = $techName;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Unique it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return TechnologyDescriptions.access$isImprovementStatsEnabledByTech(TechnologyDescriptions.INSTANCE, it, this.$techName);
                    }
                }), (Function1)new Function1<Unique, ImprovementAndUnique>(improvement2){
                    final /* synthetic */ TileImprovement $improvement;
                    {
                        this.$improvement = $improvement;
                        super(1);
                    }

                    @NotNull
                    public final ImprovementAndUnique invoke(@NotNull Unique it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        TileImprovement tileImprovement = this.$improvement;
                        Intrinsics.checkNotNullExpressionValue(tileImprovement, "$improvement");
                        return new ImprovementAndUnique(tileImprovement, it);
                    }
                });
            }
        });
    }

    private final List<IRulesetObject> getSeeAlsoObjects(Technology $this$getSeeAlsoObjects, Ruleset ruleset2) {
        return SequencesKt.toList(SequencesKt.filter(ruleset2.allRulesetObjects(), (Function1)new Function1<IRulesetObject, Boolean>($this$getSeeAlsoObjects){
            final /* synthetic */ Technology $this_getSeeAlsoObjects;
            {
                this.$this_getSeeAlsoObjects = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull IRulesetObject iRulesetObject) {
                boolean bl;
                block3: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter(iRulesetObject, "iRulesetObject");
                    Iterable iterable = iRulesetObject.getUniqueObjects();
                    Technology technology2 = this.$this_getSeeAlsoObjects;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Unique it = (Unique)element$iv;
                            boolean bl2 = false;
                            if (!(TechnologyDescriptions.access$isRelatedToTech(TechnologyDescriptions.INSTANCE, it, technology2.getName()) && !TechnologyDescriptions.access$isImprovementStatsEnabledByTech(TechnologyDescriptions.INSTANCE, it, technology2.getName()))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
    }

    public static final /* synthetic */ Sequence access$getEnabledUnits(TechnologyDescriptions $this, String techName, Ruleset ruleset2, Civilization civInfo) {
        return $this.getEnabledUnits(techName, ruleset2, civInfo);
    }

    public static final /* synthetic */ Sequence access$getEnabledBuildings(TechnologyDescriptions $this, String techName, Ruleset ruleset2, Civilization civInfo) {
        return $this.getEnabledBuildings(techName, ruleset2, civInfo);
    }

    public static final /* synthetic */ Sequence access$getObsoletedObjects(TechnologyDescriptions $this, String techName, Ruleset ruleset2, Civilization civInfo) {
        return $this.getObsoletedObjects(techName, ruleset2, civInfo);
    }

    public static final /* synthetic */ Group access$getObsoletedIcon(TechnologyDescriptions $this, RulesetStatsObject $receiver, float techIconSize) {
        return $this.getObsoletedIcon($receiver, techIconSize);
    }

    public static final /* synthetic */ boolean access$isImprovementStatsEnabledByTech(TechnologyDescriptions $this, Unique $receiver, String techName) {
        return $this.isImprovementStatsEnabledByTech($receiver, techName);
    }

    public static final /* synthetic */ boolean access$isRelatedToTech(TechnologyDescriptions $this, Unique $receiver, String techName) {
        return $this.isRelatedToTech($receiver, techName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/objectdescriptions/TechnologyDescriptions$ImprovementAndUnique;", "", "improvement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "(Lcom/unciv/models/ruleset/tile/TileImprovement;Lcom/unciv/models/ruleset/unique/Unique;)V", "getImprovement", "()Lcom/unciv/models/ruleset/tile/TileImprovement;", "getUnique", "()Lcom/unciv/models/ruleset/unique/Unique;", "component1", "component2", "copy", "equals", "", "other", "getText", "", "hashCode", "", "toString", "core"})
    private static final class ImprovementAndUnique {
        @NotNull
        private final TileImprovement improvement;
        @NotNull
        private final Unique unique;

        public ImprovementAndUnique(@NotNull TileImprovement improvement2, @NotNull Unique unique) {
            Intrinsics.checkNotNullParameter(improvement2, "improvement");
            Intrinsics.checkNotNullParameter(unique, "unique");
            this.improvement = improvement2;
            this.unique = unique;
        }

        @NotNull
        public final TileImprovement getImprovement() {
            return this.improvement;
        }

        @NotNull
        public final Unique getUnique() {
            return this.unique;
        }

        @NotNull
        public final String getText() {
            return '[' + this.unique.getParams().get(0) + "] from every [" + this.improvement.getName() + ']' + (this.unique.getType() == UniqueType.Stats ? "" : " on [" + this.unique.getParams().get(1) + "] tiles");
        }

        @NotNull
        public final TileImprovement component1() {
            return this.improvement;
        }

        @NotNull
        public final Unique component2() {
            return this.unique;
        }

        @NotNull
        public final ImprovementAndUnique copy(@NotNull TileImprovement improvement2, @NotNull Unique unique) {
            Intrinsics.checkNotNullParameter(improvement2, "improvement");
            Intrinsics.checkNotNullParameter(unique, "unique");
            return new ImprovementAndUnique(improvement2, unique);
        }

        public static /* synthetic */ ImprovementAndUnique copy$default(ImprovementAndUnique improvementAndUnique, TileImprovement tileImprovement, Unique unique, int n, Object object) {
            if ((n & 1) != 0) {
                tileImprovement = improvementAndUnique.improvement;
            }
            if ((n & 2) != 0) {
                unique = improvementAndUnique.unique;
            }
            return improvementAndUnique.copy(tileImprovement, unique);
        }

        @NotNull
        public String toString() {
            return "ImprovementAndUnique(improvement=" + this.improvement + ", unique=" + this.unique + ')';
        }

        public int hashCode() {
            int result2 = this.improvement.hashCode();
            result2 = result2 * 31 + this.unique.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ImprovementAndUnique)) {
                return false;
            }
            ImprovementAndUnique improvementAndUnique = (ImprovementAndUnique)other;
            if (!Intrinsics.areEqual(this.improvement, improvementAndUnique.improvement)) {
                return false;
            }
            return Intrinsics.areEqual(this.unique, improvementAndUnique.unique);
        }
    }
}

