/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups.options;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.LanguageTable;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.popups.options.LanguageTab$3$invoke$;
import com.unciv.ui.popups.options.OptionsPopup;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0002J\b\u0010\u0018\u001a\u00020\u0007H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/unciv/ui/popups/options/LanguageTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "optionsPopup", "Lcom/unciv/ui/popups/options/OptionsPopup;", "onLanguageSelected", "Lkotlin/Function0;", "", "(Lcom/unciv/ui/popups/options/OptionsPopup;Lkotlin/jvm/functions/Function0;)V", "chosenLanguage", "", "languageTables", "Ljava/util/ArrayList;", "Lcom/unciv/ui/components/widgets/LanguageTable;", "Lkotlin/collections/ArrayList;", "settings", "Lcom/unciv/models/metadata/GameSettings;", "activated", "index", "", "caption", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "selectLanguage", "updateSelection", "core"})
@SourceDebugExtension(value={"SMAP\nLanguageTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageTab.kt\ncom/unciv/ui/popups/options/LanguageTab\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1855#2,2:55\n288#2,2:57\n*S KotlinDebug\n*F\n+ 1 LanguageTab.kt\ncom/unciv/ui/popups/options/LanguageTab\n*L\n27#1:55,2\n49#1:57,2\n*E\n"})
public final class LanguageTab
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final Function0<Unit> onLanguageSelected;
    @NotNull
    private final ArrayList<LanguageTable> languageTables;
    @NotNull
    private final GameSettings settings;
    @NotNull
    private String chosenLanguage;

    public LanguageTab(@NotNull OptionsPopup optionsPopup, @NotNull Function0<Unit> onLanguageSelected) {
        Intrinsics.checkNotNullParameter(optionsPopup, "optionsPopup");
        Intrinsics.checkNotNullParameter(onLanguageSelected, "onLanguageSelected");
        this.onLanguageSelected = onLanguageSelected;
        this.languageTables = LanguageTable.Companion.addLanguageTables(this, optionsPopup.getTabs().getPrefWidth() * 0.9f - 10.0f);
        this.settings = optionsPopup.getSettings();
        this.chosenLanguage = this.settings.getLanguage();
        for (final LanguageTable langTable : this.languageTables) {
            Intrinsics.checkNotNull(langTable);
            ActivationExtensionsKt.onClick(langTable, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    chosenLanguage = langTable.getLanguage();
                    this.updateSelection();
                }
            });
        }
        LanguageTable.Companion.addLanguageKeyShortcuts(this, this.languageTables, new Function0<String>(){

            @Override
            @NotNull
            public final String invoke() {
                return chosenLanguage;
            }
        }, (Function1<? super String, Unit>)new Function1<String, Unit>(){

            @Override
            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                chosenLanguage = it;
                Actor $this$getAscendant$iv = this;
                boolean $i$f$getAscendant = false;
                Actor actor = Scene2dExtensionsKt.getAscendant($this$getAscendant$iv, 3$invoke$$inlined$getAscendant$1.INSTANCE);
                if (!(actor instanceof TabbedPager)) {
                    actor = null;
                }
                TabbedPager tabbedPager = (TabbedPager)actor;
                if (tabbedPager == null) {
                    return;
                }
                TabbedPager pager = tabbedPager;
                this.activated(pager.getActivePage(), "", pager);
            }
        });
    }

    private final void selectLanguage() {
        this.settings.setLanguage(this.chosenLanguage);
        this.settings.updateLocaleFromLanguage();
        UncivGame.Companion.getCurrent().getTranslations().tryReadTranslationForCurrentLanguage();
        this.onLanguageSelected.invoke();
    }

    private final void updateSelection() {
        Iterable $this$forEach$iv = this.languageTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LanguageTable it = (LanguageTable)element$iv;
            boolean bl = false;
            it.update(this.chosenLanguage);
        }
        if (!Intrinsics.areEqual(this.chosenLanguage, this.settings.getLanguage())) {
            this.selectLanguage();
        }
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(caption, "caption");
            Intrinsics.checkNotNullParameter(pager, "pager");
            this.updateSelection();
            Iterable $this$firstOrNull$iv = this.languageTables;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LanguageTable it = (LanguageTable)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getLanguage(), this.chosenLanguage)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        LanguageTable languageTable = v0;
        if (languageTable == null) {
            return;
        }
        LanguageTable selectedTable = languageTable;
        pager.pageScrollTo(selectedTable, true);
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        TabbedPager.IPageExtensions.DefaultImpls.deactivated(this, index, caption, pager);
    }

    @Override
    @Nullable
    public Actor getFixedContent() {
        return TabbedPager.IPageExtensions.DefaultImpls.getFixedContent(this);
    }
}

