/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.PerpetualStatConversion;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.PopupKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.BuyButtonFactory;
import com.unciv.ui.screens.cityscreen.CityScreen;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/screens/cityscreen/ConstructionInfoTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "buyButtonFactory", "Lcom/unciv/ui/screens/cityscreen/BuyButtonFactory;", "getCityScreen", "()Lcom/unciv/ui/screens/cityscreen/CityScreen;", "selectedConstructionTable", "sellBuildingClicked", "", "construction", "Lcom/unciv/models/ruleset/Building;", "sellText", "", "sellBuildingConfirmed", "showSellButton", "Lcom/unciv/models/ruleset/IConstruction;", "update", "selectedConstruction", "updateSelectedConstructionTable", "core"})
public final class ConstructionInfoTable
extends Table {
    @NotNull
    private final CityScreen cityScreen;
    @NotNull
    private final Table selectedConstructionTable;
    @NotNull
    private final BuyButtonFactory buyButtonFactory;

    public ConstructionInfoTable(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        this.cityScreen = cityScreen;
        this.selectedConstructionTable = new Table();
        this.buyButtonFactory = new BuyButtonFactory(this.cityScreen);
        this.selectedConstructionTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/ConstructionInfoTable/SelectedConstructionTable", null, Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.5f), 2, null));
        this.add((Actor)this.selectedConstructionTable).pad(2.0f).fill();
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/ConstructionInfoTable/Background", null, Color.WHITE, 2, null));
    }

    @NotNull
    public final CityScreen getCityScreen() {
        return this.cityScreen;
    }

    public final void update(@Nullable IConstruction selectedConstruction) {
        this.selectedConstructionTable.clear();
        if (selectedConstruction == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.updateSelectedConstructionTable(selectedConstruction);
        this.pack();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelectedConstructionTable(IConstruction construction2) {
        Object link;
        Group group;
        City city2 = this.cityScreen.getCity$core();
        CityConstructions cityConstructions = city2.getCityConstructions();
        Table $this$updateSelectedConstructionTable_u24lambda_u241 = this.selectedConstructionTable;
        boolean bl = false;
        $this$updateSelectedConstructionTable_u24lambda_u241.pad(10.0f);
        Group group2 = group = ImageGetter.INSTANCE.getConstructionPortrait(construction2.getName(), 50.0f);
        Table table2 = $this$updateSelectedConstructionTable_u24lambda_u241;
        boolean bl2 = false;
        Object object = construction2 instanceof IRulesetObject ? (IRulesetObject)((Object)construction2) : null;
        if (object != null && (object = object.makeLink()) != null && !(((CharSequence)(link = object)).length() == 0)) {
            void $this$updateSelectedConstructionTable_u24lambda_u241_u24lambda_u240;
            $this$updateSelectedConstructionTable_u24lambda_u241_u24lambda_u240.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onClick((Actor)$this$updateSelectedConstructionTable_u24lambda_u241_u24lambda_u240, new Function0<Unit>(this, (String)link){
                final /* synthetic */ ConstructionInfoTable this$0;
                final /* synthetic */ String $link;
                {
                    this.this$0 = $receiver;
                    this.$link = $link;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getCityScreen().openCivilopedia(this.$link);
                }
            });
        }
        table2.add((Actor)group).pad(5.0f);
        String buildingText = TranslationsKt.tr$default(construction2.getName(), true, false, 2, null);
        PerpetualConstruction specialConstruction = PerpetualConstruction.Companion.getPerpetualConstructionsMap().get(construction2.getName());
        StringBuilder stringBuilder = new StringBuilder().append(buildingText);
        Object object2 = specialConstruction;
        if (object2 == null || (object2 = PerpetualConstruction.getProductionTooltip$default((PerpetualConstruction)object2, city2, false, 2, null)) == null) {
            object2 = CityConstructions.getTurnsToConstructionString$core$default(cityConstructions, construction2, false, 2, null);
        }
        buildingText = stringBuilder.append((String)object2).toString();
        $this$updateSelectedConstructionTable_u24lambda_u241.add((Actor)new Label((CharSequence)buildingText, BaseScreen.Companion.getSkin())).expandX().row();
        link = construction2;
        String description2 = link instanceof BaseUnit ? ((BaseUnit)construction2).getDescription(city2) : (link instanceof Building ? ((Building)construction2).getDescription(city2, true) : (link instanceof PerpetualStatConversion ? TranslationsKt.tr$default(StringsKt.replace$default(((PerpetualStatConversion)construction2).getDescription(), "[rate]", "" + '[' + ((PerpetualStatConversion)construction2).getConversionRate(city2) + ']', false, 4, null), false, false, 3, null) : (link instanceof PerpetualConstruction ? TranslationsKt.tr$default(((PerpetualConstruction)construction2).getDescription(), false, false, 3, null) : "")));
        Label descriptionLabel = new Label((CharSequence)description2, BaseScreen.Companion.getSkin());
        descriptionLabel.setWrap(true);
        $this$updateSelectedConstructionTable_u24lambda_u241.add((Actor)descriptionLabel).colspan(2).width($this$updateSelectedConstructionTable_u24lambda_u241.getStage().getWidth() / (float)(this.cityScreen.isCrampedPortrait() ? 3 : 4));
        if (cityConstructions.isBuilt(construction2.getName())) {
            this.showSellButton(construction2);
        } else if (this.buyButtonFactory.hasBuyButtons(construction2)) {
            $this$updateSelectedConstructionTable_u24lambda_u241.row();
            for (TextButton button : this.buyButtonFactory.getBuyButtons(construction2)) {
                this.selectedConstructionTable.add((Actor)button).padTop(5.0f).colspan(2).center().row();
            }
        }
        if (construction2 instanceof BaseUnit) {
            String baseUnit = construction2.getName();
            Boolean buildUnitWithPromotions = city2.getUnitShouldUseSavedPromotion().get(baseUnit);
            if (buildUnitWithPromotions != null) {
                $this$updateSelectedConstructionTable_u24lambda_u241.row();
                $this$updateSelectedConstructionTable_u24lambda_u241.add((Actor)Scene2dExtensionsKt.toCheckBox("Use default promotions", buildUnitWithPromotions, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(city2, baseUnit){
                    final /* synthetic */ City $city;
                    final /* synthetic */ String $baseUnit;
                    {
                        this.$city = $city;
                        this.$baseUnit = $baseUnit;
                        super(1);
                    }

                    public final void invoke(boolean it) {
                        Boolean bl = it;
                        ((Map)this.$city.getUnitShouldUseSavedPromotion()).put(this.$baseUnit, bl);
                    }
                })).colspan(2).center();
            }
        }
    }

    private final void showSellButton(IConstruction construction2) {
        if (construction2 instanceof Building && ((Building)construction2).isSellable()) {
            Table $this$showSellButton_u24lambda_u242 = this.selectedConstructionTable;
            boolean bl = false;
            int sellAmount = this.cityScreen.getCity$core().getGoldForSellingBuilding(construction2.getName());
            String sellText = "{Sell} " + sellAmount + " \u00a4";
            TextButton sellBuildingButton = Scene2dExtensionsKt.toTextButton$default(sellText, null, false, 3, null);
            $this$showSellButton_u24lambda_u242.row();
            $this$showSellButton_u24lambda_u242.add((Actor)sellBuildingButton).padTop(5.0f).colspan(2).center();
            boolean isFree = this.cityScreen.hasFreeBuilding$core((Building)construction2);
            boolean enableSell = !isFree && !this.cityScreen.getCity$core().isPuppet() && this.cityScreen.getCanChangeState() && (!this.cityScreen.getCity$core().getHasSoldBuildingThisTurn() || this.cityScreen.getCity$core().getCiv().getGameInfo().getGameParameters().getGodMode());
            Scene2dExtensionsKt.setEnabled(sellBuildingButton, enableSell);
            if (enableSell) {
                ActivationExtensionsKt.onClick(sellBuildingButton, UncivSound.Companion.getCoin(), new Function0<Unit>(sellBuildingButton, this, construction2, sellText){
                    final /* synthetic */ TextButton $sellBuildingButton;
                    final /* synthetic */ ConstructionInfoTable this$0;
                    final /* synthetic */ IConstruction $construction;
                    final /* synthetic */ String $sellText;
                    {
                        this.$sellBuildingButton = $sellBuildingButton;
                        this.this$0 = $receiver;
                        this.$construction = $construction;
                        this.$sellText = $sellText;
                        super(0);
                    }

                    public final void invoke() {
                        Scene2dExtensionsKt.disable(this.$sellBuildingButton);
                        ConstructionInfoTable.access$sellBuildingClicked(this.this$0, (Building)this.$construction, this.$sellText);
                    }
                });
            }
            if (this.cityScreen.getCity$core().getHasSoldBuildingThisTurn() && !this.cityScreen.getCity$core().getCiv().getGameInfo().getGameParameters().getGodMode() || this.cityScreen.getCity$core().isPuppet() || !this.cityScreen.getCanChangeState()) {
                Scene2dExtensionsKt.disable(sellBuildingButton);
            }
        }
    }

    private final void sellBuildingClicked(Building construction2, String sellText) {
        PopupKt.closeAllPopups(this.cityScreen);
        Popup.open$default(new ConfirmPopup(this.cityScreen, "Are you sure you want to sell this [" + construction2.getName() + "]?", sellText, false, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ConstructionInfoTable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getCityScreen().update$core();
            }
        }, (Function0)new Function0<Unit>(this, construction2){
            final /* synthetic */ ConstructionInfoTable this$0;
            final /* synthetic */ Building $construction;
            {
                this.this$0 = $receiver;
                this.$construction = $construction;
                super(0);
            }

            public final void invoke() {
                ConstructionInfoTable.access$sellBuildingConfirmed(this.this$0, this.$construction);
            }
        }, 8, null), false, 1, null);
    }

    private final void sellBuildingConfirmed(Building construction2) {
        this.cityScreen.getCity$core().sellBuilding(construction2);
        this.cityScreen.clearSelection();
        this.cityScreen.update$core();
    }

    public static final /* synthetic */ void access$sellBuildingConfirmed(ConstructionInfoTable $this, Building construction2) {
        $this.sellBuildingConfirmed(construction2);
    }

    public static final /* synthetic */ void access$sellBuildingClicked(ConstructionInfoTable $this, Building construction2, String sellText) {
        $this.sellBuildingClicked(construction2, sellText);
    }
}

