/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.devconsole;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.UniqueValidator;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.devconsole.CliInput;
import com.unciv.ui.screens.devconsole.ConsoleAction;
import com.unciv.ui.screens.devconsole.ConsoleErrorException;
import com.unciv.ui.screens.devconsole.ConsoleTriggerAction;
import com.unciv.ui.screens.devconsole.DevConsolePopup;
import com.unciv.ui.screens.devconsole.DevConsoleResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleTriggerAction;", "Lcom/unciv/ui/screens/devconsole/ConsoleAction;", "topLevelCommand", "", "(Ljava/lang/String;)V", "Companion", "core"})
public final class ConsoleTriggerAction
extends ConsoleAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ConsoleTriggerAction(@NotNull String topLevelCommand) {
        Intrinsics.checkNotNullParameter(topLevelCommand, "topLevelCommand");
        super(topLevelCommand + " activatetrigger <triggeredUnique|triggeredUniqueTemplate> [uniqueParam]...", ConsoleTriggerAction.Companion.getAction(topLevelCommand));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleTriggerAction$Companion;", "", "()V", "getAction", "Lkotlin/Function2;", "Lcom/unciv/ui/screens/devconsole/DevConsolePopup;", "", "Lcom/unciv/ui/screens/devconsole/CliInput;", "Lcom/unciv/ui/screens/devconsole/DevConsoleResponse;", "topLevelCommand", "", "getCiv", "Lcom/unciv/logic/civilization/Civilization;", "console", "paramStack", "Lkotlin/collections/ArrayDeque;", "getUnique", "Lcom/unciv/models/ruleset/unique/Unique;", "getUniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "param", "ConsoleRulesetObject", "core"})
    @SourceDebugExtension(value={"SMAP\nConsoleTriggerAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleTriggerAction.kt\ncom/unciv/ui/screens/devconsole/ConsoleTriggerAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,102:1\n1549#2:103\n1620#2,3:104\n37#3,2:107\n*S KotlinDebug\n*F\n+ 1 ConsoleTriggerAction.kt\ncom/unciv/ui/screens/devconsole/ConsoleTriggerAction$Companion\n*L\n69#1:103\n69#1:104,3\n69#1:107,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Function2<DevConsolePopup, List<CliInput>, DevConsoleResponse> getAction(String topLevelCommand) {
            return new Function2<DevConsolePopup, List<? extends CliInput>, DevConsoleResponse>(topLevelCommand){
                final /* synthetic */ String $topLevelCommand;
                {
                    this.$topLevelCommand = $topLevelCommand;
                    super(2);
                }

                @NotNull
                public final DevConsoleResponse invoke(@NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
                    Tile ex3;
                    MapUnit ex22;
                    City city2;
                    Intrinsics.checkNotNullParameter(console, "console");
                    Intrinsics.checkNotNullParameter(params, "params");
                    ArrayDeque<E> paramStack = new ArrayDeque<E>(params);
                    try {
                        city2 = console.getSelectedCity$core();
                    }
                    catch (ConsoleErrorException ex22) {
                        if (Intrinsics.areEqual(this.$topLevelCommand, "city")) {
                            throw ex22;
                        }
                        city2 = null;
                    }
                    City city3 = city2;
                    try {
                        ex22 = console.getSelectedUnit$core();
                    }
                    catch (ConsoleErrorException ex3) {
                        if (Intrinsics.areEqual(this.$topLevelCommand, "unit")) {
                            throw ex3;
                        }
                        ex22 = null;
                    }
                    MapUnit unit = ex22;
                    try {
                        ex3 = console.getSelectedTile$core();
                    }
                    catch (ConsoleErrorException ex4) {
                        if (Intrinsics.areEqual(this.$topLevelCommand, "tile")) {
                            throw ex4;
                        }
                        ex3 = null;
                    }
                    Tile tile = ex3;
                    Civilization civilization = com.unciv.ui.screens.devconsole.ConsoleTriggerAction$Companion.access$getCiv(ConsoleTriggerAction.Companion, console, this.$topLevelCommand, paramStack);
                    if (civilization == null) {
                        City city4 = city3;
                        civilization = city4 != null ? city4.getCiv() : null;
                        if (civilization == null) {
                            MapUnit mapUnit = unit;
                            civilization = mapUnit != null ? mapUnit.getCiv() : null;
                            if (civilization == null) {
                                Tile tile2 = tile;
                                civilization = tile2 != null ? tile2.getOwner() : null;
                                if (civilization == null) {
                                    throw new ConsoleErrorException("A trigger command needs a Civilization from some source");
                                }
                            }
                        }
                    }
                    Civilization civ = civilization;
                    Unique unique = com.unciv.ui.screens.devconsole.ConsoleTriggerAction$Companion.access$getUnique(ConsoleTriggerAction.Companion, console, paramStack);
                    return UniqueTriggerActivation.INSTANCE.triggerUnique(unique, civ, city3, unit, tile, null, "due to cheating") ? DevConsoleResponse.Companion.getOK() : DevConsoleResponse.Companion.error("The `triggerUnique` call failed");
                }
            };
        }

        private final Civilization getCiv(DevConsolePopup console, String topLevelCommand, ArrayDeque<CliInput> paramStack) {
            if (!Intrinsics.areEqual(topLevelCommand, "civ")) {
                return null;
            }
            CliInput cliInput = paramStack.firstOrNull();
            if (cliInput == null) {
                return null;
            }
            CliInput name2 = cliInput;
            Civilization civilization = console.getCivByNameOrNull$core(name2);
            if (civilization == null) {
                return console.getScreen().getSelectedCiv();
            }
            Civilization civ = civilization;
            paramStack.removeFirst();
            return civ;
        }

        /*
         * WARNING - void declaration
         */
        private final Unique getUnique(DevConsolePopup console, ArrayDeque<CliInput> paramStack) {
            CliInput cliInput = paramStack.removeFirstOrNull();
            if (cliInput == null || (cliInput = cliInput.toMethod(CliInput.Method.Quoted)) == null) {
                throw new ConsoleErrorException("Parameter triggeredUnique missing");
            }
            CliInput uniqueText = cliInput;
            UniqueType uniqueType = this.getUniqueType(uniqueText);
            if (!((Collection)paramStack).isEmpty() && uniqueText.equals(uniqueType.getText())) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = paramStack;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CliInput cliInput2 = (CliInput)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.originalUnquoted());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] params = thisCollection$iv.toArray(new String[0]);
                uniqueText = new CliInput(TranslationsKt.fillPlaceholders(uniqueType.getPlaceholderText(), Arrays.copyOf(params, params.length)), CliInput.Method.Quoted);
            }
            Unique unique = new Unique(uniqueText.getContent(), UniqueTarget.Triggerable, "DevConsole");
            UniqueValidator validator = new UniqueValidator(console.getGameInfo$core().getRuleset());
            RulesetErrorList errors = validator.checkUnique(unique, false, new ConsoleRulesetObject(), true);
            if (errors.isNotOK()) {
                throw new ConsoleErrorException(errors.getErrorText(true));
            }
            return unique;
        }

        private final UniqueType getUniqueType(CliInput param) {
            CliInput filterText = new CliInput(TranslationsKt.getPlaceholderText(param.getContent()), param.getMethod());
            List<UniqueType> uniqueTypes2 = SequencesKt.toList(SequencesKt.take(SequencesKt.filter(ArraysKt.asSequence(UniqueType.values()), (Function1)new Function1<UniqueType, Boolean>(param, filterText){
                final /* synthetic */ CliInput $param;
                final /* synthetic */ CliInput $filterText;
                {
                    this.$param = $param;
                    this.$filterText = $filterText;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull UniqueType it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), "it");
                    return Intrinsics.areEqual(new CliInput(it.getPlaceholderText(), this.$param.getMethod()), this.$filterText);
                }
            }), 4));
            if (uniqueTypes2.isEmpty()) {
                throw new ConsoleErrorException("" + '`' + param + "` not found in UniqueTypes");
            }
            if (uniqueTypes2.size() > 1) {
                throw new ConsoleErrorException("" + '`' + param + "` has ambiguous UniqueType: " + CollectionsKt.joinToString$default(uniqueTypes2, null, null, null, 3, null, getUniqueType.1.INSTANCE, 23, null) + '?');
            }
            UniqueType uniqueType = CollectionsKt.first(uniqueTypes2);
            if (uniqueType.canAcceptUniqueTarget(UniqueTarget.Triggerable)) {
                return uniqueType;
            }
            throw new ConsoleErrorException("" + '`' + param + "` is not a Triggerable");
        }

        public static final /* synthetic */ Civilization access$getCiv(Companion $this, DevConsolePopup console, String topLevelCommand, ArrayDeque paramStack) {
            return $this.getCiv(console, topLevelCommand, paramStack);
        }

        public static final /* synthetic */ Unique access$getUnique(Companion $this, DevConsolePopup console, ArrayDeque paramStack) {
            return $this.getUnique(console, paramStack);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleTriggerAction$Companion$ConsoleRulesetObject;", "Lcom/unciv/models/ruleset/RulesetObject;", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "makeLink", "core"})
        private static final class ConsoleRulesetObject
        extends RulesetObject {
            @NotNull
            private String name = "DevConsole";

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @Override
            public void setName(@NotNull String string) {
                Intrinsics.checkNotNullParameter(string, "<set-?>");
                this.name = string;
            }

            @Override
            @NotNull
            public UniqueTarget getUniqueTarget() {
                return UniqueTarget.Triggerable;
            }

            @Override
            @NotNull
            public String makeLink() {
                return "";
            }
        }
    }
}

