/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileDescription;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.components.widgets.WrappableLabel;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import com.unciv.ui.screens.mapeditorscreen.MapEditorScreen;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorViewTab;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u001d\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u000eH\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u000eH\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020\u0014H\u0002J\u001e\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100)0(*\u00020*H\u0002J\u0014\u0010+\u001a\u00020\u000e*\u00020*2\u0006\u0010%\u001a\u00020 H\u0002J\u0014\u0010,\u001a\u00020\u0014*\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorViewTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "editorScreen", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "(Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;)V", "collator", "Ljava/text/Collator;", "labelWidth", "", "mockCiv", "Lcom/unciv/logic/civilization/Civilization;", "naturalWonders", "Lcom/unciv/models/Counter;", "", "roundRobinIndex", "", "tileDataCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "activated", "", "index", "caption", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "createMockCiv", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "deactivated", "scrollToNextTileOf", "tiles", "", "Lcom/unciv/logic/map/tile/Tile;", "scrollToStartOfNation", "name", "scrollToWonder", "tileClickHandler", "tile", "update", "getStartingLocationSummary", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "Lcom/unciv/logic/map/TileMap;", "getTileStartingLocationSummary", "updateMockCiv", "core"})
@SourceDebugExtension(value={"SMAP\nMapEditorViewTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapEditorViewTab.kt\ncom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorViewTab\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,276:1\n1#2:277\n1774#3,4:278\n1774#3,4:282\n766#3:292\n857#3,2:293\n1313#4,2:286\n125#5:288\n152#5,3:289\n*S KotlinDebug\n*F\n+ 1 MapEditorViewTab.kt\ncom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorViewTab\n*L\n99#1:278,4\n100#1:282,4\n248#1:292\n248#1:293,2\n115#1:286,2\n121#1:288\n121#1:289,3\n*E\n"})
public final class MapEditorViewTab
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final MapEditorScreen editorScreen;
    @Nullable
    private Cell<Table> tileDataCell;
    @NotNull
    private final Civilization mockCiv;
    @NotNull
    private final Counter<String> naturalWonders;
    private int roundRobinIndex;
    @NotNull
    private final Collator collator;
    private final float labelWidth;

    public MapEditorViewTab(@NotNull MapEditorScreen editorScreen) {
        Intrinsics.checkNotNullParameter(editorScreen, "editorScreen");
        super(BaseScreen.Companion.getSkin());
        this.editorScreen = editorScreen;
        this.mockCiv = this.createMockCiv(this.editorScreen.getRuleset());
        this.naturalWonders = new Counter(null, 1, null);
        this.collator = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
        this.labelWidth = this.editorScreen.getToolsWidth() - 40.0f;
        this.top();
        Cell cell2 = this.defaults();
        Intrinsics.checkNotNullExpressionValue(cell2, "defaults(...)");
        Scene2dExtensionsKt.pad(cell2, 5.0f, 20.0f);
        this.update();
    }

    private final Civilization createMockCiv(Ruleset ruleset2) {
        Civilization civilization;
        Civilization $this$createMockCiv_u24lambda_u240 = civilization = new Civilization();
        boolean bl = false;
        $this$createMockCiv_u24lambda_u240.setNation(new Nation());
        $this$createMockCiv_u24lambda_u240.getNation().setName("Test");
        $this$createMockCiv_u24lambda_u240.setGameInfo(new GameInfo());
        $this$createMockCiv_u24lambda_u240.getGameInfo().setRuleset(ruleset2);
        $this$createMockCiv_u24lambda_u240.getCache().updateState();
        $this$createMockCiv_u24lambda_u240.getTech().getTechsResearched().addAll((Collection<String>)ruleset2.getTechnologies().keySet());
        return civilization;
    }

    private final void updateMockCiv(Civilization $this$updateMockCiv, Ruleset ruleset2) {
        if ($this$updateMockCiv.getGameInfo().getRuleset() == ruleset2) {
            return;
        }
        $this$updateMockCiv.getGameInfo().setRuleset(ruleset2);
        $this$updateMockCiv.getTech().getTechsResearched().addAll((Collection<String>)ruleset2.getTechnologies().keySet());
    }

    /*
     * WARNING - void declaration
     */
    private final void update() {
        void $this$update_u24lambda_u248;
        TextButton textButton;
        Object lines2;
        void $this$update_u24lambda_u244;
        Object element$iv3;
        int n;
        Object element$iv22;
        int n2;
        CharSequence charSequence;
        this.clear();
        this.updateMockCiv(this.mockCiv, this.editorScreen.getRuleset());
        TileMap tileMap = this.editorScreen.getTileMap();
        CharSequence charSequence2 = tileMap.getMapParameters().getName();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "New map";
        } else {
            charSequence = charSequence2;
        }
        String headerText = (String)charSequence;
        this.add((Actor)new ExpanderTab(headerText, 0, null, false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, null, null, null, new Function1<Table, Unit>(tileMap, this){
            final /* synthetic */ TileMap $tileMap;
            final /* synthetic */ MapEditorViewTab this$0;
            {
                this.$tileMap = $tileMap;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Table it) {
                void $this$invoke_u24lambda_u240;
                WrappableLabel mapParameterLabel;
                WrappableLabel wrappableLabel;
                Intrinsics.checkNotNullParameter(it, "it");
                String mapParameterText = StringsKt.replace$default(this.$tileMap.getMapParameters().toString(), '\"' + this.$tileMap.getMapParameters().getName() + "\" ", "", false, 4, null);
                WrappableLabel wrappableLabel2 = wrappableLabel = (mapParameterLabel = new WrappableLabel(mapParameterText, MapEditorViewTab.access$getLabelWidth$p(this.this$0), null, 0, false, 28, null));
                Table table2 = it;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setWrap(true);
                table2.add((Actor)wrappableLabel).row();
            }
        }, 4070, null)).row();
        try {
            tileMap.assignContinents(TileMap.AssignContinentsMode.Ensure);
        }
        catch (Exception ex) {
            new ToastPopup("Error assigning continents: " + ex.getMessage(), this.editorScreen, 0L, 4, null);
        }
        int area = tileMap.getValues().size();
        Iterable $this$count$iv = tileMap.getValues();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv22 : $this$count$iv) {
                Tile it = (Tile)element$iv22;
                boolean bl = false;
                if (!it.isWater() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int waterPercent = (int)((float)n2 * 100.0f / (float)area);
        Iterable $this$count$iv2 = tileMap.getValues();
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv3 : $this$count$iv2) {
                Tile it = (Tile)element$iv3;
                boolean bl = false;
                if (!it.isImpassible() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int impassablePercent = (int)((float)n * 100.0f / (float)area);
        int continents = tileMap.getContinentSizes().size();
        String statsText = "Area: [" + area + "] tiles, [" + waterPercent + "]% water, [" + impassablePercent + "]% impassable, [" + continents + "] continents/islands";
        WrappableLabel statsLabel = new WrappableLabel(statsText, this.labelWidth, null, 0, false, 28, null);
        element$iv22 = statsLabel;
        element$iv3 = element$iv22;
        Object object = this;
        boolean bl = false;
        $this$update_u24lambda_u244.setWrap(true);
        ((Table)object).add((Actor)element$iv22).row();
        this.add((Actor)this.editorScreen.getDescriptionTextField()).growX().row();
        if (this.editorScreen.getNaturalWondersNeedRefresh()) {
            void $this$forEach$iv;
            this.naturalWonders.clear();
            element$iv22 = this.collator;
            element$iv22 = SequencesKt.sortedWith(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)tileMap.getValues()), update.3.INSTANCE), new Comparator((Comparator)element$iv22){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    String string = (String)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    String it = (String)b;
                    String string2 = TranslationsKt.tr$default(it, true, false, 2, null);
                    bl = false;
                    String string3 = TranslationsKt.tr$default(it, true, false, 2, null);
                    return comparator.compare(string2, string3);
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv4 : $this$forEach$iv) {
                String it = (String)element$iv4;
                boolean bl2 = false;
                this.naturalWonders.add(it, 1);
            }
            this.editorScreen.setNaturalWondersNeedRefresh(false);
        }
        if (!((Map)this.naturalWonders).isEmpty()) {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = this.naturalWonders;
            boolean $i$f$map = false;
            Map element$iv4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                object = destination$iv$iv;
                boolean bl3 = false;
                object.add(new FormattedLine(((Number)it.getValue()).intValue() == 1 ? (String)it.getKey() : '{' + (String)it.getKey() + "} (" + ((Number)it.getValue()).intValue() + ')', (String)it.getKey(), "Terrain/" + (String)it.getKey(), null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16376, null));
            }
            lines2 = (List)destination$iv$iv;
            this.add((Actor)new ExpanderTab("{Natural Wonders} (" + this.naturalWonders.size() + ')', 21, null, false, 0.0f, 0.0f, 5.0f, 0.0f, 0.0f, null, null, null, new Function1<Table, Unit>((List<FormattedLine>)lines2, this){
                final /* synthetic */ List<FormattedLine> $lines;
                final /* synthetic */ MapEditorViewTab this$0;
                {
                    this.$lines = $lines;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Table it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    it.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, this.$lines, 0.0f, 0.0f, FormattedLine.IconDisplay.NoLink, new Function1<String, Unit>(this.this$0){
                        final /* synthetic */ MapEditorViewTab this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull String name2) {
                            Intrinsics.checkNotNullParameter(name2, "name");
                            MapEditorViewTab.access$scrollToWonder(this.this$0, name2);
                        }
                    }, 6, null));
                }
            }, 4020, null)).row();
        }
        if (!((Map)tileMap.getStartingLocationsByNation()).isEmpty()) {
            lines2 = SequencesKt.map(this.getStartingLocationSummary(tileMap), update.lines.2.INSTANCE);
            this.add((Actor)new ExpanderTab("{Starting locations} (" + tileMap.getStartingLocationsByNation().size() + ')', 21, null, false, 0.0f, 0.0f, 5.0f, 0.0f, 0.0f, null, null, null, new Function1<Table, Unit>((Sequence<FormattedLine>)lines2, this){
                final /* synthetic */ Sequence<FormattedLine> $lines;
                final /* synthetic */ MapEditorViewTab this$0;
                {
                    this.$lines = $lines;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Table it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    it.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, SequencesKt.asIterable(this.$lines), 0.0f, 0.0f, FormattedLine.IconDisplay.NoLink, new Function1<String, Unit>(this.this$0){
                        final /* synthetic */ MapEditorViewTab this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull String name2) {
                            Intrinsics.checkNotNullParameter(name2, "name");
                            MapEditorViewTab.access$scrollToStartOfNation(this.this$0, name2);
                        }
                    }, 6, null));
                }
            }, 4020, null)).row();
        }
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        this.tileDataCell = this.add((Actor)new Table()).fillX();
        this.row();
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        TextButton $this$map$iv = textButton = Scene2dExtensionsKt.toTextButton$default("Exit map editor", null, false, 3, null);
        object = this;
        boolean bl4 = false;
        ActivationExtensionsKt.onClick((Actor)$this$update_u24lambda_u248, new Function0<Unit>((Object)this.editorScreen){

            public final void invoke() {
                ((MapEditorScreen)this.receiver).closeEditor$core();
            }
        });
        ((Table)object).add((Actor)textButton).row();
        this.invalidateHierarchy();
        this.validate();
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.editorScreen.setTileClickHandler((Function1<? super Tile, Unit>)new Function1<Tile, Unit>((Object)this){

            public final void invoke(@NotNull Tile p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                MapEditorViewTab.access$tileClickHandler((MapEditorViewTab)this.receiver, p0);
            }
        });
        this.update();
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.editorScreen.hideSelection();
        Cell<Table> cell2 = this.tileDataCell;
        if (cell2 != null) {
            cell2.setActor(null);
        }
        this.editorScreen.setTileClickHandler(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void tileClickHandler(Tile tile) {
        int continent;
        String nations2;
        Stats stats2;
        if (this.tileDataCell == null) {
            return;
        }
        ArrayList lines2 = new ArrayList();
        Collection collection = lines2;
        StringBuilder stringBuilder = new StringBuilder().append("Position: [");
        String string = tile.getPosition().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        collection.add(new FormattedLine(stringBuilder.append(StringsKt.replace$default(string, ".0", "", false, 4, null)).append(']').toString(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        ((Collection)lines2).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        lines2.addAll(TileDescription.INSTANCE.toMarkup(tile, null));
        try {
            stats2 = TileStatFunctions.getTileStats$default(tile.getStats(), null, this.mockCiv, null, 4, null);
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                String string2 = ex.getMessage();
                Intrinsics.checkNotNull(string2);
                new ToastPopup(string2, this.editorScreen, 0L, 4, null);
            }
            stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        }
        Stats stats3 = stats2;
        if (!stats3.isEmpty()) {
            ((Collection)lines2).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lines2).add(new FormattedLine(stats3.toString(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if (((CharSequence)(nations2 = this.getTileStartingLocationSummary(tile.getTileMap(), tile))).length() > 0) {
            ((Collection)lines2).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lines2).add(new FormattedLine("Starting location(s): [" + nations2 + ']', null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if ((continent = tile.getContinent()) >= 0) {
            ((Collection)lines2).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)lines2).add(new FormattedLine("Continent: [" + continent + "] ([" + tile.getTileMap().getContinentSizes().get(continent) + "] tiles)", "continent", null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        Table renderedInfo2 = MarkupRenderer.render$default(MarkupRenderer.INSTANCE, lines2, this.labelWidth, 0.0f, null, new Function1<String, Unit>(this, tile, continent){
            final /* synthetic */ MapEditorViewTab this$0;
            final /* synthetic */ Tile $tile;
            final /* synthetic */ int $continent;
            {
                this.this$0 = $receiver;
                this.$tile = $tile;
                this.$continent = $continent;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (Intrinsics.areEqual(it, "continent")) {
                    MapEditorViewTab.access$getEditorScreen$p(this.this$0).hideSelection();
                    Color color = Color.BROWN;
                    Intrinsics.checkNotNullExpressionValue(color, "BROWN");
                    Color color2 = Scene2dExtensionsKt.darken(color, 0.5f);
                    for (Tile markTile : this.$tile.getTileMap().getValues()) {
                        if (markTile.getContinent() != this.$continent) continue;
                        MapEditorViewTab.access$getEditorScreen$p(this.this$0).highlightTile(markTile, color2);
                    }
                } else {
                    MapEditorViewTab.access$getEditorScreen$p(this.this$0).openCivilopedia(it);
                }
            }
        }, 12, null);
        if (tile.getResource() != null && (tile.getResourceAmount() > 0 || tile.getTileResource().getResourceType() == ResourceType.Strategic)) {
            void $this$tileClickHandler_u24lambda_u249;
            Table table2;
            Color color = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "GRAY");
            Scene2dExtensionsKt.addSeparator$default(renderedInfo2, color, 0, 0.0f, 6, null);
            Table table3 = table2 = new Table();
            Table table4 = renderedInfo2;
            boolean bl = false;
            $this$tileClickHandler_u24lambda_u249.add((Actor)Scene2dExtensionsKt.toLabel$default("Resource abundance", null, 0, 8, false, 11, null)).left().growX();
            UncivSlider slider2 = new UncivSlider(0.0f, 42.0f, 1.0f, false, false, tile.getResourceAmount(), null, null, null, new Function1<Float, Unit>(tile, this){
                final /* synthetic */ Tile $tile;
                final /* synthetic */ MapEditorViewTab this$0;
                {
                    this.$tile = $tile;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(float it) {
                    this.$tile.setResourceAmount((int)it);
                    MapEditorViewTab.access$getEditorScreen$p(this.this$0).updateTile(this.$tile);
                    MapEditorViewTab.access$getEditorScreen$p(this.this$0).setDirty(true);
                }
            }, 472, null);
            float[] fArray = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 12.0f, 15.0f, 20.0f, 30.0f, 40.0f};
            slider2.setSnapToValues(5.0f, fArray);
            $this$tileClickHandler_u24lambda_u249.add((Actor)slider2).right().minWidth(80.0f).fillX().padTop(15.0f);
            table4.add((Actor)table2).fillX();
        }
        Cell<Table> cell2 = this.tileDataCell;
        if (cell2 != null) {
            cell2.setActor((Actor)renderedInfo2);
        }
        this.editorScreen.hideSelection();
        Color color = Color.CORAL;
        Intrinsics.checkNotNullExpressionValue(color, "CORAL");
        this.editorScreen.highlightTile(tile, color);
    }

    /*
     * WARNING - void declaration
     */
    private final void scrollToWonder(String name2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.editorScreen.getTileMap().getValues();
        MapEditorViewTab mapEditorViewTab = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getNaturalWonder(), name2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mapEditorViewTab.scrollToNextTileOf((List)destination$iv$iv);
    }

    private final void scrollToStartOfNation(String name2) {
        HashSet<Tile> hashSet = this.editorScreen.getTileMap().getStartingLocationsByNation().get(name2);
        if (hashSet == null) {
            return;
        }
        HashSet<Tile> tiles2 = hashSet;
        this.scrollToNextTileOf(CollectionsKt.toList((Iterable)tiles2));
    }

    private final void scrollToNextTileOf(List<Tile> tiles2) {
        if (tiles2.isEmpty()) {
            return;
        }
        if (this.roundRobinIndex >= tiles2.size()) {
            this.roundRobinIndex = 0;
        }
        int n = this.roundRobinIndex;
        this.roundRobinIndex = n + 1;
        Tile tile = tiles2.get(n);
        this.editorScreen.getMapHolder().setCenterPosition(tile.getPosition(), true);
        this.tileClickHandler(tile);
    }

    private final String getTileStartingLocationSummary(TileMap $this$getTileStartingLocationSummary, Tile tile) {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(((Nation)it.getFirst()).isCityState());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, ((Nation)it.getFirst()).isCityState());
            }
        };
        Comparator comparator2 = this.collator;
        return SequencesKt.joinToString$default(SequencesKt.sortedWith(SequencesKt.mapNotNull(SequencesKt.filter(CollectionsKt.asSequence((Iterable)$this$getTileStartingLocationSummary.getStartingLocations()), (Function1)new Function1<TileMap.StartingLocation, Boolean>(tile){
            final /* synthetic */ Tile $tile;
            {
                this.$tile = $tile;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TileMap.StartingLocation it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getPosition(), this.$tile.getPosition());
            }
        }), (Function1)new Function1<TileMap.StartingLocation, Pair<? extends Nation, ? extends TileMap.StartingLocation.Usage>>($this$getTileStartingLocationSummary){
            final /* synthetic */ TileMap $this_getTileStartingLocationSummary;
            {
                this.$this_getTileStartingLocationSummary = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<Nation, TileMap.StartingLocation.Usage> invoke(@NotNull TileMap.StartingLocation it) {
                Pair<Nation, TileMap.StartingLocation.Usage> pair;
                Intrinsics.checkNotNullParameter(it, "it");
                Ruleset ruleset2 = this.$this_getTileStartingLocationSummary.getRuleset();
                Intrinsics.checkNotNull(ruleset2);
                if (((Map)ruleset2.getNations()).containsKey(it.getNation())) {
                    Ruleset ruleset3 = this.$this_getTileStartingLocationSummary.getRuleset();
                    Intrinsics.checkNotNull(ruleset3);
                    Nation nation2 = ruleset3.getNations().get(it.getNation());
                    Intrinsics.checkNotNull(nation2);
                    pair = TuplesKt.to(nation2, it.getUsage());
                } else {
                    pair = null;
                }
                return pair;
            }
        }), new Comparator(comparator, comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Pair pair = (Pair)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Pair it = (Pair)b;
                    String string = TranslationsKt.tr$default(((Nation)it.getFirst()).getName(), true, false, 2, null);
                    bl = false;
                    String string2 = TranslationsKt.tr$default(((Nation)it.getFirst()).getName(), true, false, 2, null);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        }), null, null, null, 0, null, getTileStartingLocationSummary.5.INSTANCE, 31, null);
    }

    private final Sequence<Pair<String, Integer>> getStartingLocationSummary(TileMap $this$getStartingLocationSummary) {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(((Nation)it.getFirst()).isCityState());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, ((Nation)it.getFirst()).isCityState());
            }
        };
        Comparator comparator2 = this.collator;
        return SequencesKt.map(SequencesKt.sortedWith(SequencesKt.mapNotNull(MapsKt.asSequence((Map)$this$getStartingLocationSummary.getStartingLocationsByNation()), (Function1)new Function1<Map.Entry<? extends String, ? extends HashSet<Tile>>, Pair<? extends Nation, ? extends Integer>>($this$getStartingLocationSummary){
            final /* synthetic */ TileMap $this_getStartingLocationSummary;
            {
                this.$this_getStartingLocationSummary = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<Nation, Integer> invoke(@NotNull Map.Entry<String, ? extends HashSet<Tile>> it) {
                Pair<Nation, Integer> pair;
                Intrinsics.checkNotNullParameter(it, "it");
                Ruleset ruleset2 = this.$this_getStartingLocationSummary.getRuleset();
                Intrinsics.checkNotNull(ruleset2);
                if (((Map)ruleset2.getNations()).containsKey(it.getKey())) {
                    Ruleset ruleset3 = this.$this_getStartingLocationSummary.getRuleset();
                    Intrinsics.checkNotNull(ruleset3);
                    Nation nation2 = ruleset3.getNations().get(it.getKey());
                    Intrinsics.checkNotNull(nation2);
                    pair = TuplesKt.to(nation2, it.getValue().size());
                } else {
                    pair = null;
                }
                return pair;
            }
        }), new Comparator(comparator, comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Pair pair = (Pair)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Pair it = (Pair)b;
                    String string = TranslationsKt.tr$default(((Nation)it.getFirst()).getName(), true, false, 2, null);
                    bl = false;
                    String string2 = TranslationsKt.tr$default(((Nation)it.getFirst()).getName(), true, false, 2, null);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        }), getStartingLocationSummary.4.INSTANCE);
    }

    @Override
    @Nullable
    public Actor getFixedContent() {
        return TabbedPager.IPageExtensions.DefaultImpls.getFixedContent(this);
    }

    public static final /* synthetic */ float access$getLabelWidth$p(MapEditorViewTab $this) {
        return $this.labelWidth;
    }

    public static final /* synthetic */ void access$scrollToWonder(MapEditorViewTab $this, String name2) {
        $this.scrollToWonder(name2);
    }

    public static final /* synthetic */ void access$scrollToStartOfNation(MapEditorViewTab $this, String name2) {
        $this.scrollToStartOfNation(name2);
    }

    public static final /* synthetic */ void access$tileClickHandler(MapEditorViewTab $this, Tile tile) {
        $this.tileClickHandler(tile);
    }

    public static final /* synthetic */ MapEditorScreen access$getEditorScreen$p(MapEditorViewTab $this) {
        return $this.editorScreen;
    }
}

