/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.multiplayerscreens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.civilization.CivilizationInfoPreview;
import com.unciv.logic.multiplayer.FriendList;
import com.unciv.logic.multiplayer.Multiplayer;
import com.unciv.logic.multiplayer.MultiplayerGamePreview;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.multiplayerscreens.MultiplayerHelpers;
import com.unciv.ui.screens.savescreens.LoadGameScreen;
import com.unciv.ui.screens.savescreens.LoadOrSaveScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/screens/multiplayerscreens/MultiplayerHelpers;", "", "()V", "buildDescriptionText", "", "multiplayerGamePreview", "Lcom/unciv/logic/multiplayer/MultiplayerGamePreview;", "loadMultiplayerGame", "", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "selectedGame", "showDropboxWarning", "core"})
@SourceDebugExtension(value={"SMAP\nMultiplayerHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplayerHelpers.kt\ncom/unciv/ui/screens/multiplayerscreens/MultiplayerHelpers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n288#2,2:97\n288#2,2:99\n*S KotlinDebug\n*F\n+ 1 MultiplayerHelpers.kt\ncom/unciv/ui/screens/multiplayerscreens/MultiplayerHelpers\n*L\n56#1:97,2\n64#1:99,2\n*E\n"})
public final class MultiplayerHelpers {
    @NotNull
    public static final MultiplayerHelpers INSTANCE = new MultiplayerHelpers();

    private MultiplayerHelpers() {
    }

    public final void loadMultiplayerGame(@NotNull BaseScreen screen, @NotNull MultiplayerGamePreview selectedGame) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        Intrinsics.checkNotNullParameter(selectedGame, "selectedGame");
        Popup loadingGamePopup = new Popup(screen, null, 0.0f, 6, null);
        Popup.addGoodSizedLabel$default(loadingGamePopup, "Loading latest game state...", 0, false, 6, null);
        Popup.open$default(loadingGamePopup, false, 1, null);
        Concurrency.run$default(Concurrency.INSTANCE, "JoinMultiplayerGame", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(selectedGame, loadingGamePopup, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MultiplayerGamePreview $selectedGame;
            final /* synthetic */ Popup $loadingGamePopup;
            {
                this.$selectedGame = $selectedGame;
                this.$loadingGamePopup = $loadingGamePopup;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        this.L$0 = $this$run;
                        this.label = 1;
                        Object object3 = UncivGame.Companion.getCurrent().getOnlineMultiplayer().downloadGame(this.$selectedGame, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        try {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception ex) {
                            String message2 = (String)LoadOrSaveScreen.Helpers.DefaultImpls.getLoadExceptionMessage$default(LoadGameScreen.Companion, ex, null, null, 6, null).component1();
                            ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$loadingGamePopup, message2, null){
                                int label;
                                final /* synthetic */ Popup $loadingGamePopup;
                                final /* synthetic */ String $message;
                                {
                                    this.$loadingGamePopup = $loadingGamePopup;
                                    this.$message = $message;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.$loadingGamePopup.reuseWith(this.$message, true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildDescriptionText(@NotNull MultiplayerGamePreview multiplayerGamePreview) {
        GameInfoPreview preview;
        CharSequence message2;
        Intrinsics.checkNotNullParameter(multiplayerGamePreview, "multiplayerGamePreview");
        StringBuilder descriptionText = new StringBuilder();
        Throwable ex = multiplayerGamePreview.getError();
        if (ex != null) {
            message2 = (String)LoadOrSaveScreen.Helpers.DefaultImpls.getLoadExceptionMessage$default(LoadGameScreen.Companion, ex, "Error while refreshing:", null, 4, null).component1();
            StringBuilder stringBuilder = descriptionText.append((String)message2);
            Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append(...)");
        }
        Instant lastUpdate = multiplayerGamePreview.getLastUpdate();
        message2 = descriptionText;
        StringBuilder stringBuilder = new StringBuilder().append("Last refresh: [");
        Duration duration = Duration.between(lastUpdate, Instant.now());
        Intrinsics.checkNotNullExpressionValue(duration, "between(...)");
        StringBuilder stringBuilder2 = ((StringBuilder)message2).append(TranslationsKt.tr$default(stringBuilder.append(FormattingExtensionsKt.formatShort(duration)).append("] ago").toString(), false, false, 3, null));
        Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(...)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append(...)");
        GameInfoPreview gameInfoPreview = preview = multiplayerGamePreview.getPreview();
        if ((gameInfoPreview != null ? gameInfoPreview.getCurrentPlayer() : null) != null) {
            Object object;
            Object v10;
            block10: {
                void $this$firstOrNull$iv;
                Object object2;
                StringBuilder $this$firstOrNull$iv2;
                Object object3;
                Instant currentTurnStartTime = Instant.ofEpochMilli(preview.getCurrentTurnStartTime());
                CivilizationInfoPreview currentPlayer = preview.getCurrentPlayerCiv();
                if (Intrinsics.areEqual(currentPlayer.getPlayerId(), UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getUserId())) {
                    object3 = "You";
                } else {
                    FriendList.Friend friend;
                    Object v6;
                    block9: {
                        Iterable iterable = UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getFriendList();
                        boolean $i$f$firstOrNull = false;
                        object2 = $this$firstOrNull$iv2.iterator();
                        while (object2.hasNext()) {
                            Object element$iv = object2.next();
                            FriendList.Friend it = (FriendList.Friend)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(it.getPlayerID(), currentPlayer.getPlayerId())) continue;
                            v6 = element$iv;
                            break block9;
                        }
                        v6 = null;
                    }
                    if ((object3 = (friend = (FriendList.Friend)v6)) == null || (object3 = ((FriendList.Friend)object3).getName()) == null) {
                        object3 = "Unknown";
                    }
                }
                String playerDescriptor = object3;
                String playerText = '{' + preview.getCurrentPlayer() + "}{ }({" + playerDescriptor + "})";
                $this$firstOrNull$iv2 = descriptionText;
                StringBuilder stringBuilder3 = new StringBuilder().append("Current Turn: [").append(playerText).append("] since [");
                Duration duration2 = Duration.between(currentTurnStartTime, Instant.now());
                Intrinsics.checkNotNullExpressionValue(duration2, "between(...)");
                StringBuilder stringBuilder4 = $this$firstOrNull$iv2.append(TranslationsKt.tr$default(stringBuilder3.append(FormattingExtensionsKt.formatShort(duration2)).append("] ago").toString(), false, false, 3, null));
                Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append(...)");
                object2 = preview.getCivilizations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CivilizationInfoPreview it = (CivilizationInfoPreview)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getPlayerId(), UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getUserId())) continue;
                    v10 = element$iv;
                    break block10;
                }
                v10 = null;
            }
            if ((object = (CivilizationInfoPreview)v10) == null || (object = ((CivilizationInfoPreview)object).getCivName()) == null) {
                object = "Unknown";
            }
            Object playerCivName = object;
            StringBuilder stringBuilder5 = descriptionText.append('{' + (String)playerCivName + "}, " + TranslationsKt.tr$default(preview.getDifficulty(), false, false, 3, null) + ", \u23f3" + preview.getTurns());
            Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder5.append('\n'), "append(...)");
            StringBuilder stringBuilder6 = descriptionText.append("{Base ruleset:} " + preview.getGameParameters().getBaseRuleset());
            Intrinsics.checkNotNullExpressionValue(stringBuilder6, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder6.append('\n'), "append(...)");
            if (!((Collection)preview.getGameParameters().getMods()).isEmpty()) {
                StringBuilder stringBuilder7 = descriptionText.append("{Mods:} " + CollectionsKt.joinToString$default(preview.getGameParameters().getMods(), null, null, null, 0, null, null, 63, null));
                Intrinsics.checkNotNullExpressionValue(stringBuilder7, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder7.append('\n'), "append(...)");
            }
        }
        String string = descriptionText.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return TranslationsKt.tr$default(string, false, false, 3, null);
    }

    public final void showDropboxWarning(@NotNull BaseScreen screen) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        if (!Multiplayer.Companion.usesDropbox() || UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getHideDropboxWarning()) {
            return;
        }
        Popup dropboxWarning = new Popup(screen, null, 0.0f, 6, null);
        Popup.addGoodSizedLabel$default(dropboxWarning, "You're currently using the default multiplayer server, which is based on a free Dropbox account. Because a lot of people use this, it is uncertain if you'll actually be able to access it consistently. Consider using a custom server instead.", 0, false, 6, null).colspan(2).row();
        Popup.addButton$default(dropboxWarning, "Open Documentation", null, null, (Function0)showDropboxWarning.1.INSTANCE, 6, null).colspan(2).row();
        CheckBox checkBox2 = Scene2dExtensionsKt.toCheckBox$default("Don't show again", false, null, 3, null);
        dropboxWarning.add((Actor)checkBox2);
        Popup.addCloseButton$default(dropboxWarning, null, null, null, new Function0<Unit>(checkBox2){
            final /* synthetic */ CheckBox $checkBox;
            {
                this.$checkBox = $checkBox;
                super(0);
            }

            public final void invoke() {
                UncivGame.Companion.getCurrent().getSettings().getMultiplayer().setHideDropboxWarning(this.$checkBox.isChecked());
            }
        }, 7, null);
        Popup.open$default(dropboxWarning, false, 1, null);
    }
}

