/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.victoryscreen.DataPoint;
import com.unciv.ui.screens.victoryscreen.VictoryScreenCivGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000f0\u000e2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000f0\u000e2\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\nH\u0016J8\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\nH\u0002J(\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010+\u001a\u00020,J\u001a\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0.H\u0002J\u0010\u0010/\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0010H\u0002J\u0010\u00100\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0010H\u0002J\u0010\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\nJ2\u00104\u001a\u00020\n2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002J\b\u00108\u001a\u00020\u001eH\u0002J\"\u00109\u001a\u00020\u001e2\u0012\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010;\u001a\u00020\u0003J\u001c\u0010<\u001a\u00020\u001e2\u0012\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eH\u0002J\u0010\u0010=\u001a\u00020,2\u0006\u0010>\u001a\u00020\u0003H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/unciv/ui/screens/victoryscreen/LineChart;", "Lcom/badlogic/gdx/scenes/scene2d/ui/WidgetGroup;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/civilization/Civilization;)V", "axisColor", "Lcom/badlogic/gdx/graphics/Color;", "kotlin.jvm.PlatformType", "axisLabelColor", "axisLineWidth", "", "axisToLabelPadding", "chartLineWidth", "dataPoints", "", "Lcom/unciv/ui/screens/victoryscreen/DataPoint;", "", "maxLabels", "orientationLineColor", "orientationLineWidth", "selectedCiv", "xLabels", "xLabelsAsLabels", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "yLabels", "yLabelsAsLabels", "douglasPeucker", "points", "epsilon", "draw", "", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "drawLine", "x1", "y1", "x2", "y2", "lineColor", "width", "generateLabels", "value", "yAxis", "", "getLastTurnDataPoints", "", "getNextNumberDivisibleByPowOfTen", "getPrevNumberDivisibleByPowOfTen", "getTurnAt", "Lkotlin/ranges/IntRange;", "x", "perpendicularDistance", "point", "start", "end", "prepareForDraw", "update", "newData", "newSelectedCiv", "updateLabels", "useActualColor", "civ", "core"})
@SourceDebugExtension(value={"SMAP\nLineChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineChart.kt\ncom/unciv/ui/screens/victoryscreen/LineChart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,379:1\n1#2:380\n1549#3:381\n1620#3,3:382\n1549#3:385\n1620#3,3:386\n1549#3:389\n1620#3,3:390\n1549#3:393\n1620#3,3:394\n1549#3:397\n1620#3,3:398\n1549#3:401\n1620#3,3:402\n1864#3,3:405\n1864#3,3:408\n1045#3:411\n1477#3:412\n1502#3,3:413\n1505#3,3:423\n1045#3:426\n1549#3:427\n1620#3,3:428\n372#4,7:416\n*S KotlinDebug\n*F\n+ 1 LineChart.kt\ncom/unciv/ui/screens/victoryscreen/LineChart\n*L\n76#1:381\n76#1:382,3\n78#1:385\n78#1:386,3\n96#1:389\n96#1:390,3\n98#1:393\n98#1:394,3\n104#1:397\n104#1:398,3\n107#1:401\n107#1:402,3\n171#1:405,3\n198#1:408,3\n225#1:411\n226#1:412\n226#1:413,3\n226#1:423,3\n231#1:426\n240#1:427\n240#1:428,3\n226#1:416,7\n*E\n"})
public final class LineChart
extends WidgetGroup {
    @NotNull
    private final Civilization viewingCiv;
    private final float axisLineWidth;
    private final Color axisColor;
    private final Color axisLabelColor;
    private final float axisToLabelPadding;
    private final float chartLineWidth;
    private final float orientationLineWidth;
    private final Color orientationLineColor;
    private final int maxLabels;
    @NotNull
    private List<Integer> xLabels;
    @NotNull
    private List<Integer> yLabels;
    @NotNull
    private List<? extends Label> xLabelsAsLabels;
    @NotNull
    private List<? extends Label> yLabelsAsLabels;
    @NotNull
    private List<DataPoint<Integer>> dataPoints;
    @NotNull
    private Civilization selectedCiv;

    public LineChart(@NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        this.viewingCiv = viewingCiv;
        this.axisLineWidth = 2.0f;
        this.axisLabelColor = this.axisColor = Color.WHITE;
        this.axisToLabelPadding = 5.0f;
        this.chartLineWidth = 3.0f;
        this.orientationLineWidth = 0.5f;
        this.orientationLineColor = Color.LIGHT_GRAY;
        this.maxLabels = 10;
        this.xLabels = CollectionsKt.emptyList();
        this.yLabels = CollectionsKt.emptyList();
        this.xLabelsAsLabels = CollectionsKt.emptyList();
        this.yLabelsAsLabels = CollectionsKt.emptyList();
        this.dataPoints = CollectionsKt.emptyList();
        this.selectedCiv = new Civilization();
    }

    @Nullable
    public final IntRange getTurnAt(float x) {
        if (this.xLabels.isEmpty() || this.xLabelsAsLabels.isEmpty() || this.yLabelsAsLabels.isEmpty()) {
            return null;
        }
        Iterator iterator2 = ((Iterable)this.yLabelsAsLabels).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Label it22 = (Label)iterator2.next();
        boolean bl = false;
        float it22 = it22.getWidth();
        while (iterator2.hasNext()) {
            Label it32 = (Label)iterator2.next();
            $i$a$-maxOf-LineChart$getTurnAt$widestYLabelWidth$1 = false;
            float it32 = it32.getWidth();
            it22 = Math.max(it22, it32);
        }
        float widestYLabelWidth = it22;
        float linesMinX = widestYLabelWidth + this.axisToLabelPadding + this.axisLineWidth;
        float linesMaxX = this.getWidth() - CollectionsKt.last(this.xLabelsAsLabels).getWidth() / (float)2;
        if (Float.compare(linesMinX, linesMaxX) == 0) {
            return new IntRange(((Number)CollectionsKt.first(this.xLabels)).intValue(), ((Number)CollectionsKt.last(this.xLabels)).intValue());
        }
        float ratio = (x - linesMinX) / (linesMaxX - linesMinX);
        int turn = Math.max(1, (int)MathUtils.lerp(((Number)CollectionsKt.first(this.xLabels)).intValue(), ((Number)CollectionsKt.last(this.xLabels)).intValue(), ratio));
        return new IntRange(this.getPrevNumberDivisibleByPowOfTen(turn - 1), this.getNextNumberDivisibleByPowOfTen(turn + 1));
    }

    public final void update(@NotNull List<DataPoint<Integer>> newData, @NotNull Civilization newSelectedCiv) {
        Intrinsics.checkNotNullParameter(newData, "newData");
        Intrinsics.checkNotNullParameter(newSelectedCiv, "newSelectedCiv");
        this.selectedCiv = newSelectedCiv;
        this.dataPoints = newData;
        this.updateLabels(this.dataPoints);
        this.prepareForDraw();
    }

    private final void updateLabels(List<DataPoint<Integer>> newData) {
        int it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        this.xLabels = this.generateLabels(newData, false);
        this.yLabels = this.generateLabels(newData, true);
        Iterable iterable = this.xLabels;
        LineChart lineChart = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Label((CharSequence)TranslationsKt.tr(it), new Label.LabelStyle(Fonts.INSTANCE.getFont(), this.axisLabelColor)));
        }
        lineChart.xLabelsAsLabels = (List)destination$iv$iv;
        $this$map$iv = this.yLabels;
        lineChart = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Label((CharSequence)TranslationsKt.tr(it), new Label.LabelStyle(Fonts.INSTANCE.getFont(), this.axisLabelColor)));
        }
        lineChart.yLabelsAsLabels = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> generateLabels(@NotNull List<DataPoint<Integer>> value, boolean yAxis) {
        List list2;
        int it322;
        Intrinsics.checkNotNullParameter(value, "value");
        if (value.isEmpty()) {
            return CollectionsKt.listOf(0);
        }
        Iterable iterable = value;
        Object object = this;
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        DataPoint it322 = (DataPoint)iterator2.next();
        boolean bl = false;
        int n = it322 = yAxis ? ((Number)it322.getY()).intValue() : ((Number)it322.getX()).intValue();
        while (iterator2.hasNext()) {
            DataPoint it22 = (DataPoint)iterator2.next();
            $i$a$-minOf-LineChart$generateLabels$minLabelValue$1 = false;
            int it22 = yAxis ? ((Number)it22.getY()).intValue() : ((Number)it22.getX()).intValue();
            if (it322 <= it22) continue;
            it322 = it22;
        }
        int n2 = it322;
        int minLabelValue = ((LineChart)object).getPrevNumberDivisibleByPowOfTen(n2);
        iterator2 = value;
        object = this;
        Iterator it322 = iterator2.iterator();
        if (!it322.hasNext()) {
            throw new NoSuchElementException();
        }
        Object it = (DataPoint)it322.next();
        boolean bl2 = false;
        it = yAxis ? ((Number)((DataPoint)it).getY()).intValue() : ((Number)((DataPoint)it).getX()).intValue();
        while (it322.hasNext()) {
            Object it2 = (DataPoint)it322.next();
            $i$a$-maxOf-LineChart$generateLabels$maxLabelValue$1 = false;
            it2 = yAxis ? ((Number)((DataPoint)it2).getY()).intValue() : ((Number)((DataPoint)it2).getX()).intValue();
            if (it.compareTo(it2) >= 0) continue;
            it = it2;
        }
        int maxLabelValue = ((LineChart)object).getNextNumberDivisibleByPowOfTen(((Number)it).intValue());
        int stepSizePositive = 0;
        stepSizePositive = (int)Math.ceil((float)maxLabelValue / (float)this.maxLabels);
        if (minLabelValue < 0) {
            List list3;
            int it4;
            int item$iv$iv;
            Iterable $this$mapTo$iv$iv;
            int stepSizeNegative = 0;
            stepSizeNegative = (int)Math.ceil(-((float)minLabelValue) / (float)this.maxLabels);
            int maxStep = Math.max(stepSizePositive, stepSizeNegative);
            int stepCountNegative = (int)Math.floor((double)minLabelValue / (double)maxStep);
            stepSizeNegative = Math.abs(stepCountNegative) < 2 ? Math.abs(minLabelValue) : maxStep;
            int stepCountPositive = (int)Math.ceil((double)maxLabelValue / (double)maxStep);
            stepSizePositive = Math.abs(stepCountPositive) < 2 ? Math.abs(maxLabelValue) : maxStep;
            Iterable $this$map$iv = RangesKt.until(stepCountNegative, 0);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                int n3 = item$iv$iv = ((IntIterator)iterator3).nextInt();
                object = destination$iv$iv;
                boolean bl3 = false;
                object.add((int)(it4 * stepSizeNegative));
            }
            Object object2 = (List)destination$iv$iv;
            if (maxLabelValue != 0) {
                $this$map$iv = RangesKt.until(0, stepCountPositive + 1);
                object = object2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    it4 = item$iv$iv = ((IntIterator)iterator3).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it4 * stepSizePositive);
                }
                list3 = (List)destination$iv$iv;
                object2 = object;
            } else {
                list3 = CollectionsKt.listOf(0);
            }
            list2 = CollectionsKt.plus(object2, (Iterable)list3);
        } else if (maxLabelValue != 0) {
            Iterable $this$map$iv;
            if (minLabelValue < stepSizePositive) {
                void $this$mapTo$iv$iv;
                $this$map$iv = RangesKt.until(0, this.maxLabels + 1);
                boolean $i$f$map = false;
                Iterable stepCountNegative = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator4 = $this$mapTo$iv$iv.iterator();
                while (iterator4.hasNext()) {
                    void it5;
                    int item$iv$iv;
                    int destination$iv$iv2 = item$iv$iv = ((IntIterator)iterator4).nextInt();
                    object = destination$iv$iv;
                    boolean bl5 = false;
                    object.add((int)(it5 * stepSizePositive));
                }
                list2 = (List)destination$iv$iv;
            } else {
                stepSizePositive = (int)Math.ceil((float)(maxLabelValue - minLabelValue) / (float)this.maxLabels);
                $this$map$iv = RangesKt.until(0, this.maxLabels + 1);
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator5 = $this$mapTo$iv$iv.iterator();
                while (iterator5.hasNext()) {
                    int item$iv$iv;
                    int it5 = item$iv$iv = ((IntIterator)iterator5).nextInt();
                    object = destination$iv$iv;
                    boolean bl6 = false;
                    object.add(minLabelValue + it5 * stepSizePositive);
                }
                list2 = (List)destination$iv$iv;
            }
        } else {
            Integer[] integerArray = new Integer[]{0, 1};
            list2 = CollectionsKt.listOf(integerArray);
        }
        return list2;
    }

    private final int getNextNumberDivisibleByPowOfTen(int value) {
        if (value == 0) {
            return 0;
        }
        int numberOfDigits = Math.max(2, Math.min((int)Math.ceil(Math.log10(Math.abs(value))), 3));
        double oneWithZeros = Math.pow(10.0, numberOfDigits - 1);
        return (int)(Math.ceil((double)value / oneWithZeros) * oneWithZeros);
    }

    private final int getPrevNumberDivisibleByPowOfTen(int value) {
        if (value == 0) {
            return 0;
        }
        int numberOfDigits = RangesKt.coerceIn((int)Math.ceil(Math.log10(Math.abs(value))), 2, 3);
        double oneWithZeros = Math.pow(10.0, numberOfDigits - 1);
        return (int)(Math.floor((double)value / oneWithZeros) * oneWithZeros);
    }

    @Override
    public void draw(@NotNull Batch batch, float parentAlpha) {
        Intrinsics.checkNotNullParameter(batch, "batch");
        super.draw(batch, parentAlpha);
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareForDraw() {
        Object value$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        this.clearChildren();
        if (this.xLabels.isEmpty() || this.yLabels.isEmpty()) {
            return;
        }
        Map<Civilization, DataPoint<Integer>> lastTurnDataPoints = this.getLastTurnDataPoints();
        float labelHeight = CollectionsKt.first(this.yLabelsAsLabels).getHeight();
        Iterator iterator2 = ((Iterable)this.yLabelsAsLabels).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Label it232 = (Label)iterator2.next();
        boolean bl = false;
        float it232 = it232.getWidth();
        while (iterator2.hasNext()) {
            Label it332 = (Label)iterator2.next();
            boolean bl2 = false;
            float it332 = it332.getWidth();
            it232 = Math.max(it232, it332);
        }
        float widestYLabelWidth = it232;
        float yAxisLabelMaxY = this.getHeight() - labelHeight;
        float xAxisLabelsHeight = labelHeight;
        float zeroYAxisLabelHeight = labelHeight;
        float yAxisLabelMinY = xAxisLabelsHeight + this.axisToLabelPadding + this.axisLineWidth / (float)2 - zeroYAxisLabelHeight / (float)2;
        float yAxisLabelYRange = yAxisLabelMaxY - yAxisLabelMinY;
        float yAxisYPosition = 0.0f;
        Iterable $this$forEachIndexed$iv = this.yLabels;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = ((Number)item$iv).intValue();
            int index = n;
            boolean bl2 = false;
            Label label2 = this.yLabelsAsLabels.get(index);
            float yPos = yAxisLabelMinY + (float)index * (yAxisLabelYRange / (float)(this.yLabels.size() - 1));
            label2.setPosition((widestYLabelWidth - label2.getWidth()) / (float)2, yPos);
            this.addActor(label2);
            boolean zeroIndex = value == false;
            float f = yPos + labelHeight / (float)2;
            float f2 = this.getWidth();
            float f3 = yPos + labelHeight / (float)2;
            Color color = zeroIndex ? this.axisColor : this.orientationLineColor;
            Intrinsics.checkNotNull(color);
            this.drawLine(widestYLabelWidth + this.axisToLabelPadding + this.axisLineWidth, f, f2, f3, color, zeroIndex ? this.axisLineWidth : this.orientationLineWidth);
            if (!zeroIndex) continue;
            yAxisYPosition = yPos + labelHeight / (float)2;
        }
        float lastXAxisLabelWidth = CollectionsKt.last(this.xLabelsAsLabels).getWidth();
        float xAxisLabelMinX = widestYLabelWidth + this.axisToLabelPadding + this.axisLineWidth / (float)2;
        float xAxisLabelMaxX = this.getWidth() - lastXAxisLabelWidth / (float)2;
        float xAxisLabelXRange = xAxisLabelMaxX - xAxisLabelMinX;
        Iterable $this$forEachIndexed$iv2 = this.xLabelsAsLabels;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv2) {
            void label3;
            int label2;
            if ((label2 = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Label yPos = (Label)item$iv;
            int index = label2;
            boolean bl3 = false;
            float xPos = xAxisLabelMinX + (float)index * (xAxisLabelXRange / (float)(this.xLabels.size() - 1));
            label3.setPosition(xPos - label3.getWidth() / (float)2, 0.0f);
            this.addActor((Actor)label3);
            float f = this.getHeight();
            Color color = index > 0 ? this.orientationLineColor : this.axisColor;
            Intrinsics.checkNotNull(color);
            this.drawLine(xPos, labelHeight + this.axisToLabelPadding + this.axisLineWidth, xPos, f, color, index > 0 ? this.orientationLineWidth : this.axisLineWidth);
        }
        float linesMinX = widestYLabelWidth + this.axisToLabelPadding + this.axisLineWidth;
        float linesMaxX = this.getWidth() - lastXAxisLabelWidth / (float)2;
        float linesMinY = yAxisYPosition;
        float linesMaxY = this.getHeight() - labelHeight / (float)2;
        float scaleX = (linesMaxX - linesMinX) / (float)(((Number)CollectionsKt.maxOrThrow((Iterable)this.xLabels)).intValue() - ((Number)CollectionsKt.minOrThrow((Iterable)this.xLabels)).intValue());
        float scaleY = (linesMaxY - linesMinY) / (float)(((Number)CollectionsKt.maxOrThrow((Iterable)this.yLabels)).intValue() - ((Number)CollectionsKt.minOrThrow((Iterable)this.yLabels)).intValue());
        float negativeOrientationLineYPosition = yAxisLabelMinY + labelHeight / (float)2;
        int minXLabel = ((Number)CollectionsKt.minOrThrow((Iterable)this.xLabels)).intValue();
        int minYLabel = ((Number)CollectionsKt.minOrThrow((Iterable)this.yLabels)).intValue();
        float negativeScaleY = (negativeOrientationLineYPosition - linesMinY) / (float)(minYLabel < 0 ? minYLabel : 1);
        Iterable $this$sortedBy$iv = this.dataPoints;
        boolean $i$f$sortedBy = false;
        List sortedPoints = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                DataPoint it = (DataPoint)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getX();
                it = (DataPoint)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getX()));
            }
        });
        Iterable $this$groupBy$iv = sortedPoints;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataPoint it = (DataPoint)element$iv$iv;
            boolean bl4 = false;
            Civilization key$iv$iv = it.getCiv();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map pointsByCiv = destination$iv$iv;
        Iterable $this$sortedBy$iv2 = CollectionsKt.toList(pointsByCiv.keySet());
        boolean $i$f$sortedBy2 = false;
        List<Civilization> civIterationOrder = CollectionsKt.toMutableList(CollectionsKt.sortedWith($this$sortedBy$iv2, new Comparator(lastTurnDataPoints){
            final /* synthetic */ Map $lastTurnDataPoints$inlined;
            {
                this.$lastTurnDataPoints$inlined = map2;
            }

            public final int compare(T a, T b) {
                Civilization it = (Civilization)a;
                boolean bl = false;
                V v = this.$lastTurnDataPoints$inlined.get(it);
                Intrinsics.checkNotNull(v);
                it = (Civilization)b;
                Comparable comparable = (Integer)((DataPoint)v).getY();
                bl = false;
                V v2 = this.$lastTurnDataPoints$inlined.get(it);
                Intrinsics.checkNotNull(v2);
                return ComparisonsKt.compareValues(comparable, (Comparable)((Integer)((DataPoint)v2).getY()));
            }
        }));
        if (civIterationOrder.contains(this.selectedCiv)) {
            civIterationOrder.remove(this.selectedCiv);
            civIterationOrder.add(this.selectedCiv);
        }
        for (Civilization civ : civIterationOrder) {
            DataPoint<Float> a;
            int i;
            void $this$mapTo$iv$iv;
            Object v = pointsByCiv.get(civ);
            Intrinsics.checkNotNull(v);
            List points = (List)v;
            Iterable $this$map$iv = points;
            boolean $i$f$map = false;
            Iterable list$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                value$iv$iv$iv = (DataPoint)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl6 = false;
                collection.add((float)((Number)it.getY()).intValue() < 0.0f ? new DataPoint<Float>(Float.valueOf(linesMinX + (float)(((Number)it.getX()).intValue() - minXLabel) * scaleX), Float.valueOf(linesMinY + ((Number)it.getY()).floatValue() * negativeScaleY), it.getCiv()) : new DataPoint<Float>(Float.valueOf(linesMinX + (float)(((Number)it.getX()).intValue() - minXLabel) * scaleX), Float.valueOf(linesMinY + (float)(((Number)it.getY()).intValue() - minYLabel) * scaleY), it.getCiv()));
            }
            List scaledPoints = (List)destination$iv$iv2;
            List<DataPoint<Float>> simplifiedScaledPoints = this.douglasPeucker(scaledPoints, 1.0f);
            if (Intrinsics.areEqual(civ, this.selectedCiv)) {
                int n = simplifiedScaledPoints.size();
                for (i = 1; i < n; ++i) {
                    a = simplifiedScaledPoints.get(i - 1);
                    DataPoint<Float> b = simplifiedScaledPoints.get(i);
                    Color selectedCivBackgroundColor = this.useActualColor(civ) ? civ.getNation().getInnerColor() : Color.LIGHT_GRAY;
                    float f = ((Number)a.getX()).floatValue();
                    float f4 = ((Number)a.getY()).floatValue();
                    float f5 = ((Number)b.getX()).floatValue();
                    float f6 = ((Number)b.getY()).floatValue();
                    Intrinsics.checkNotNull(selectedCivBackgroundColor);
                    this.drawLine(f, f4, f5, f6, selectedCivBackgroundColor, this.chartLineWidth * (float)3);
                }
            }
            int n = simplifiedScaledPoints.size();
            for (i = 1; i < n; ++i) {
                Actor selectedCivIcon;
                Actor actor;
                a = simplifiedScaledPoints.get(i - 1);
                DataPoint<Float> b = simplifiedScaledPoints.get(i);
                Color civLineColor = this.useActualColor(civ) ? civ.getNation().getOuterColor() : Color.DARK_GRAY;
                float f = ((Number)a.getX()).floatValue();
                float f7 = ((Number)a.getY()).floatValue();
                float f8 = ((Number)b.getX()).floatValue();
                float f9 = ((Number)b.getY()).floatValue();
                Intrinsics.checkNotNull(civLineColor);
                this.drawLine(f, f7, f8, f9, civLineColor, this.chartLineWidth);
                if (i != simplifiedScaledPoints.size() - 1 || !Intrinsics.areEqual(this.selectedCiv, civ) || !lastTurnDataPoints.containsKey(this.selectedCiv)) continue;
                Actor $this$prepareForDraw_u24lambda_u2416 = actor = (selectedCivIcon = VictoryScreenCivGroup.Companion.getCivImageAndColors(this.selectedCiv, this.viewingCiv, VictoryScreenCivGroup.DefeatedPlayerStyle.REGULAR).getFirst());
                boolean bl7 = false;
                $this$prepareForDraw_u24lambda_u2416.setPosition(((Number)b.getX()).floatValue(), ((Number)b.getY()).floatValue(), 1);
                $this$prepareForDraw_u24lambda_u2416.setSize(33.0f, 33.0f);
                this.addActor(selectedCivIcon);
            }
        }
    }

    private final boolean useActualColor(Civilization civ) {
        return this.viewingCiv.isSpectator() || this.viewingCiv.isDefeated() || this.viewingCiv.getVictoryManager().hasWon() || Intrinsics.areEqual(this.viewingCiv, civ) || this.viewingCiv.knows(civ) || civ.isDefeated();
    }

    private final Map<Civilization, DataPoint<Integer>> getLastTurnDataPoints() {
        Map lastDataPoints = new LinkedHashMap();
        for (DataPoint<Integer> dataPoint : this.dataPoints) {
            if (lastDataPoints.containsKey(dataPoint.getCiv())) {
                Object v = lastDataPoints.get(dataPoint.getCiv());
                Intrinsics.checkNotNull(v);
                if (((Number)((DataPoint)v).getX()).intValue() >= ((Number)dataPoint.getX()).intValue()) continue;
            }
            lastDataPoints.put(dataPoint.getCiv(), dataPoint);
        }
        return lastDataPoints;
    }

    private final void drawLine(float x1, float y1, float x2, float y2, Color lineColor, float width) {
        Image line = ImageGetter.INSTANCE.getLine(x1, y1, x2, y2, width);
        line.setColor(lineColor);
        this.addActor(line);
        Image edgeRounding = ImageGetter.INSTANCE.getCircle(lineColor, Float.valueOf(width));
        edgeRounding.setPosition(x1 - width / 2.0f, y1 - width / 2.0f);
        this.addActor(edgeRounding);
    }

    private final List<DataPoint<Float>> douglasPeucker(List<DataPoint<Float>> points, float epsilon) {
        if (points.size() < 3) {
            return points;
        }
        float[] dMax = new float[points.size()];
        int index = 0;
        float maxDistance = 0.0f;
        int n = CollectionsKt.getLastIndex(points);
        for (int i = 1; i < n; ++i) {
            float distance;
            dMax[i] = distance = this.perpendicularDistance(points.get(i), points.get(0), CollectionsKt.last(points));
            if (!(distance > maxDistance)) continue;
            index = i;
            maxDistance = distance;
        }
        List resultList = new ArrayList();
        if (maxDistance > epsilon) {
            List<DataPoint<Float>> recursiveList1 = this.douglasPeucker(points.subList(0, index + 1), epsilon);
            List<DataPoint<Float>> recursiveList2 = this.douglasPeucker(points.subList(index, points.size()), epsilon);
            resultList.addAll((Collection)recursiveList1.subList(0, CollectionsKt.getLastIndex(recursiveList1)));
            resultList.addAll((Collection)recursiveList2);
        } else {
            resultList.add(CollectionsKt.first(points));
            resultList.add(CollectionsKt.last(points));
        }
        return resultList;
    }

    private final float perpendicularDistance(DataPoint<Float> point, DataPoint<Float> start2, DataPoint<Float> end2) {
        float xx;
        float param;
        float x = ((Number)point.getX()).floatValue();
        float y = ((Number)point.getY()).floatValue();
        float x1 = ((Number)start2.getX()).floatValue();
        float y1 = ((Number)start2.getY()).floatValue();
        float x2 = ((Number)end2.getX()).floatValue();
        float y2 = ((Number)end2.getY()).floatValue();
        float a = x - x1;
        float b = y - y1;
        float c = x2 - x1;
        float d = y2 - y1;
        float dot = a * c + b * d;
        float lenSq = c * c + d * d;
        float f = param = lenSq == 0.0f ? 0.0f : dot / lenSq;
        float f2 = param < 0.0f ? x1 : (xx = param > 1.0f ? x2 : x1 + param * c);
        float yy = param < 0.0f ? y1 : (param > 1.0f ? y2 : y1 + param * d);
        float dx = x - xx;
        float dy = y - yy;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }
}

