/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.VictoryData;
import com.unciv.logic.battle.BattleUnitCapture;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.CivilopediaAction;
import com.unciv.logic.civilization.DiplomacyAction;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.DeclareWarReason;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.diplomacy.WarType;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Event;
import com.unciv.models.ruleset.EventChoice;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.audio.MusicMood;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.diplomacyscreen.LeaderIntroTable;
import com.unciv.ui.screens.victoryscreen.VictoryScreen;
import com.unciv.ui.screens.worldscreen.AlertPopup;
import com.unciv.ui.screens.worldscreen.RenderEvent;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b!\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0 H\u0002J\b\u0010!\u001a\u00020\u001eH\u0002J\b\u0010\"\u001a\u00020\u001eH\u0002J\b\u0010#\u001a\u00020\u001aH\u0002J\b\u0010$\u001a\u00020\u001eH\u0002J\b\u0010%\u001a\u00020\u001aH\u0002J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\b\b\u0002\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\u001eH\u0002J\b\u0010,\u001a\u00020\u001aH\u0002J\b\u0010-\u001a\u00020\u001eH\u0002J\b\u0010.\u001a\u00020\u001eH\u0002J\u0016\u0010/\u001a\u00020\u001a2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001a0 H\u0002J\b\u00101\u001a\u00020\u001aH\u0002J\b\u00102\u001a\u00020\u001eH\u0002J\b\u00103\u001a\u00020\u001aH\u0002J\b\u00104\u001a\u00020\u001aH\u0002J\b\u00105\u001a\u00020\u001aH\u0002J\u0010\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u0016H\u0002J\u0018\u00108\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u0016H\u0002J\u001e\u0010:\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001a0 H\u0002J\u0010\u0010<\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020*H\u0002J \u0010>\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00109\u001a\u00020\u0016H\u0002J\b\u0010?\u001a\u00020\u001eH\u0002J\b\u0010@\u001a\u00020\u001eH\u0002J\b\u0010A\u001a\u00020\u001aH\u0002J\b\u0010B\u001a\u00020\u001aH\u0002J\b\u0010C\u001a\u00020\u001eH\u0002J\b\u0010D\u001a\u00020\u001eH\u0002J\b\u0010E\u001a\u00020\u001aH\u0002J\b\u0010F\u001a\u00020\u001aH\u0016J\u0010\u0010G\u001a\u00020\u001c2\u0006\u0010H\u001a\u00020*H\u0002J\u0010\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020*H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/unciv/ui/screens/worldscreen/AlertPopup;", "Lcom/unciv/ui/popups/Popup;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "popupAlert", "Lcom/unciv/logic/civilization/PopupAlert;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;Lcom/unciv/logic/civilization/PopupAlert;)V", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "music", "Lcom/unciv/ui/audio/MusicController;", "getMusic", "()Lcom/unciv/ui/audio/MusicController;", "stageHeight", "", "getStageHeight", "()F", "stageWidth", "getStageWidth", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "getViewingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "addAnnexOption", "", "city", "Lcom/unciv/logic/city/City;", "mayAnnex", "", "annexAction", "Lkotlin/Function0;", "addBorderConflict", "addBulliedOrAttackedProtectedOrAlliedMinor", "addCityConquered", "addCitySettledNearOtherCivDespiteOurPromise", "addCityTraded", "addCloseButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "text", "", "addDeclarationOfFriendship", "addDefeated", "addDemandToStopSettlingCitiesNear", "addDemandToStopSpreadingReligion", "addDestroyOption", "destroyAction", "addDiplomaticMarriage", "addEvent", "addFirstContact", "addGameHasBeenWon", "addGoldenAge", "addLeaderName", "civInfo", "addLiberateOption", "conqueringCiv", "addPuppetOption", "puppetAction", "addQuestionAboutTheCity", "cityName", "addRazeOption", "addRecapturedCivilian", "addReligionSpreadDespiteOurPromise", "addStartIntro", "addTechResearched", "addTilesStolen", "addWarDeclaration", "addWonderBuilt", "close", "getCity", "cityId", "getCiv", "civName", "core"})
@SourceDebugExtension(value={"SMAP\nAlertPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertPopup.kt\ncom/unciv/ui/screens/worldscreen/AlertPopup\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,595:1\n123#2,2:596\n1#3:598\n*S KotlinDebug\n*F\n+ 1 AlertPopup.kt\ncom/unciv/ui/screens/worldscreen/AlertPopup\n*L\n71#1:596,2\n*E\n"})
public final class AlertPopup
extends Popup {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final PopupAlert popupAlert;

    public AlertPopup(@NotNull WorldScreen worldScreen, @NotNull PopupAlert popupAlert) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        Intrinsics.checkNotNullParameter(popupAlert, "popupAlert");
        super(worldScreen, null, 0.0f, 6, null);
        this.worldScreen = worldScreen;
        this.popupAlert = popupAlert;
        boolean shouldOpen = true;
        this.getBottomTable().defaults().growX();
        switch (WhenMappings.$EnumSwitchMapping$0[this.popupAlert.getType().ordinal()]) {
            case 1: {
                this.addCityConquered();
                break;
            }
            case 2: {
                this.addCityTraded();
                break;
            }
            case 3: {
                this.addDiplomaticMarriage();
                break;
            }
            case 4: {
                this.addFirstContact();
                break;
            }
            case 5: {
                shouldOpen = this.addWarDeclaration();
                break;
            }
            case 6: {
                shouldOpen = this.addBorderConflict();
                break;
            }
            case 7: {
                shouldOpen = this.addTilesStolen();
                break;
            }
            case 8: {
                shouldOpen = this.addDemandToStopSettlingCitiesNear();
                break;
            }
            case 9: {
                shouldOpen = this.addCitySettledNearOtherCivDespiteOurPromise();
                break;
            }
            case 10: {
                shouldOpen = this.addDemandToStopSpreadingReligion();
                break;
            }
            case 11: {
                shouldOpen = this.addReligionSpreadDespiteOurPromise();
                break;
            }
            case 12: {
                shouldOpen = this.addDeclarationOfFriendship();
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                shouldOpen = this.addBulliedOrAttackedProtectedOrAlliedMinor();
                break;
            }
            case 16: {
                this.addDefeated();
                break;
            }
            case 17: {
                this.addWonderBuilt();
                break;
            }
            case 18: {
                this.addTechResearched();
                break;
            }
            case 19: {
                this.addGoldenAge();
                break;
            }
            case 20: {
                this.addStartIntro();
                break;
            }
            case 21: {
                shouldOpen = this.addRecapturedCivilian();
                break;
            }
            case 22: {
                this.addGameHasBeenWon();
                break;
            }
            case 23: {
                shouldOpen = this.addEvent();
            }
        }
        if (shouldOpen) {
            Popup.open$default(this, false, 1, null);
        } else {
            this.getViewingCiv().getPopupAlerts().remove(this.popupAlert);
        }
    }

    private final MusicController getMusic() {
        return UncivGame.Companion.getCurrent().getMusicController();
    }

    private final GameInfo getGameInfo() {
        return this.worldScreen.getGameInfo();
    }

    private final Civilization getViewingCiv() {
        return this.worldScreen.getViewingCiv();
    }

    private final float getStageWidth() {
        return this.worldScreen.getStage().getWidth();
    }

    private final float getStageHeight() {
        return this.worldScreen.getStage().getHeight();
    }

    private final Civilization getCiv(String civName) {
        return this.getGameInfo().getCivilization(civName);
    }

    private final City getCity(String cityId) {
        City element$iv;
        block1: {
            Sequence<City> $this$first$iv = this.getGameInfo().getCities();
            boolean $i$f$first = false;
            Iterator<City> iterator2 = $this$first$iv.iterator();
            while (iterator2.hasNext()) {
                City it = element$iv = iterator2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), cityId)) continue;
                break block1;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return element$iv;
    }

    private final Cell<TextButton> addCloseButton(String text2) {
        return this.addCloseButton(text2, KeyboardBinding.NextTurnAlternate, null);
    }

    static /* synthetic */ Cell addCloseButton$default(AlertPopup alertPopup, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "Close";
        }
        return alertPopup.addCloseButton(string);
    }

    private final boolean addBorderConflict() {
        Civilization civInfo = this.getCiv(this.popupAlert.getValue());
        if (civInfo.isDefeated()) {
            return false;
        }
        this.addLeaderName(civInfo);
        Popup.addGoodSizedLabel$default(this, "Remove your troops in our border immediately!", 0, false, 6, null);
        Popup.addCloseButton$default(this, "Sorry.", KeyboardBinding.Confirm, null, 4, null);
        Popup.addCloseButton$default(this, "Never!", KeyboardBinding.Cancel, null, 4, null);
        return true;
    }

    private final boolean addTilesStolen() {
        Civilization civInfo = this.getCiv(this.popupAlert.getValue());
        if (civInfo.isDefeated()) {
            return false;
        }
        this.addLeaderName(civInfo);
        Popup.addGoodSizedLabel$default(this, "Those lands were not yours to take. This has not gone unnoticed.", 0, false, 6, null);
        AlertPopup.addCloseButton$default(this, null, 1, null);
        return true;
    }

    private final boolean addBulliedOrAttackedProtectedOrAlliedMinor() {
        char[] cArray = new char[]{'@'};
        List involvedCivs = StringsKt.split$default((CharSequence)this.popupAlert.getValue(), cArray, false, 0, 6, null);
        Civilization bullyOrAttacker = this.getCiv((String)involvedCivs.get(0));
        if (bullyOrAttacker.isDefeated()) {
            return false;
        }
        Civilization cityState = this.getCiv((String)involvedCivs.get(1));
        Civilization player = this.getViewingCiv();
        this.addLeaderName(bullyOrAttacker);
        DiplomacyManager diplomacyManager = bullyOrAttacker.getDiplomacyManager(player);
        Intrinsics.checkNotNull(diplomacyManager);
        boolean isAtLeastNeutral = diplomacyManager.isRelationshipLevelGE(RelationshipLevel.Neutral);
        String text2 = this.popupAlert.getType() == AlertType.BulliedProtectedMinor && isAtLeastNeutral ? "I've been informed that my armies have taken tribute from [" + cityState.getCivName() + "], a city-state under your protection.\nI assure you, this was quite unintentional, and I hope that this does not serve to drive us apart." : (this.popupAlert.getType() == AlertType.BulliedProtectedMinor ? "We asked [" + cityState.getCivName() + "] for a tribute recently and they gave in.\nYou promised to protect them from such things, but we both know you cannot back that up." : (isAtLeastNeutral ? "It's come to my attention that I may have attacked [" + cityState.getCivName() + "].\nWhile it was not my goal to be at odds with your empire, this was deemed a necessary course of action." : "I thought you might like to know that I've launched an invasion of one of your little pet states.\nThe lands of [" + cityState.getCivName() + "] will make a fine addition to my own."));
        Popup.addGoodSizedLabel$default(this, text2, 0, false, 6, null).row();
        if (!player.isAtWarWith(bullyOrAttacker)) {
            this.addCloseButton("THIS MEANS WAR!", KeyboardBinding.Confirm, new Function0<Unit>(player, bullyOrAttacker, this, cityState){
                final /* synthetic */ Civilization $player;
                final /* synthetic */ Civilization $bullyOrAttacker;
                final /* synthetic */ AlertPopup this$0;
                final /* synthetic */ Civilization $cityState;
                {
                    this.$player = $player;
                    this.$bullyOrAttacker = $bullyOrAttacker;
                    this.this$0 = $receiver;
                    this.$cityState = $cityState;
                    super(0);
                }

                public final void invoke() {
                    DiplomacyManager diplomacyManager = this.$player.getDiplomacyManager(this.$bullyOrAttacker);
                    Intrinsics.checkNotNull(diplomacyManager);
                    diplomacyManager.sideWithCityState();
                    WarType warReason = AlertPopup.access$getPopupAlert$p(this.this$0).getType() == AlertType.AttackedAllyMinor ? WarType.AlliedCityStateWar : WarType.ProtectedCityStateWar;
                    DiplomacyManager diplomacyManager2 = this.$player.getDiplomacyManager(this.$bullyOrAttacker);
                    Intrinsics.checkNotNull(diplomacyManager2);
                    diplomacyManager2.declareWar(new DeclareWarReason(warReason, this.$cityState));
                    DiplomacyManager diplomacyManager3 = this.$cityState.getDiplomacyManager(this.$player);
                    Intrinsics.checkNotNull(diplomacyManager3);
                    DiplomacyManager diplomacyManager4 = diplomacyManager3;
                    diplomacyManager4.setInfluence$core(diplomacyManager4.getInfluence$core() + 20.0f);
                }
            }).row();
        }
        this.addCloseButton("You'll pay for this!", KeyboardBinding.Confirm, new Function0<Unit>(player, bullyOrAttacker){
            final /* synthetic */ Civilization $player;
            final /* synthetic */ Civilization $bullyOrAttacker;
            {
                this.$player = $player;
                this.$bullyOrAttacker = $bullyOrAttacker;
                super(0);
            }

            public final void invoke() {
                DiplomacyManager diplomacyManager = this.$player.getDiplomacyManager(this.$bullyOrAttacker);
                Intrinsics.checkNotNull(diplomacyManager);
                diplomacyManager.sideWithCityState();
            }
        }).row();
        this.addCloseButton("Very well.", KeyboardBinding.Cancel, new Function0<Unit>(player, cityState){
            final /* synthetic */ Civilization $player;
            final /* synthetic */ Civilization $cityState;
            {
                this.$player = $player;
                this.$cityState = $cityState;
                super(0);
            }

            public final void invoke() {
                String[] stringArray = new String[]{this.$cityState.getCivName()};
                this.$player.addNotification("You have broken your Pledge to Protect [" + this.$cityState.getCivName() + "]!", this.$cityState.getCityStateFunctions().getNotificationActions(), Notification.NotificationCategory.Diplomacy, stringArray);
                this.$cityState.getCityStateFunctions().removeProtectorCiv(this.$player, true);
            }
        }).row();
        return true;
    }

    private final void addCityConquered() {
        City city2 = this.getCity(this.popupAlert.getValue());
        this.addQuestionAboutTheCity(city2.getName());
        Civilization conqueringCiv = this.getGameInfo().getCurrentPlayerCivilization();
        if (!(Intrinsics.areEqual(city2.getFoundingCiv(), "") || Intrinsics.areEqual(city2.getCiv().getCivName(), city2.getFoundingCiv()) || Intrinsics.areEqual(conqueringCiv.getCivName(), city2.getFoundingCiv()))) {
            this.addLiberateOption(city2, conqueringCiv);
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        }
        if (conqueringCiv.isOneCityChallenger()) {
            this.addDestroyOption(new Function0<Unit>(city2, conqueringCiv){
                final /* synthetic */ City $city;
                final /* synthetic */ Civilization $conqueringCiv;
                {
                    this.$city = $city;
                    this.$conqueringCiv = $conqueringCiv;
                    super(0);
                }

                public final void invoke() {
                    this.$city.puppetCity(this.$conqueringCiv);
                    City.destroyCity$default(this.$city, false, 1, null);
                }
            });
        } else {
            boolean mayAnnex = !Civilization.hasUnique$default(conqueringCiv, UniqueType.MayNotAnnexCities, null, 2, null);
            this.addAnnexOption(city2, mayAnnex, new Function0<Unit>(city2, conqueringCiv){
                final /* synthetic */ City $city;
                final /* synthetic */ Civilization $conqueringCiv;
                {
                    this.$city = $city;
                    this.$conqueringCiv = $conqueringCiv;
                    super(0);
                }

                public final void invoke() {
                    this.$city.puppetCity(this.$conqueringCiv);
                }
            });
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
            this.addPuppetOption(mayAnnex, new Function0<Unit>(city2, conqueringCiv){
                final /* synthetic */ City $city;
                final /* synthetic */ Civilization $conqueringCiv;
                {
                    this.$city = $city;
                    this.$conqueringCiv = $conqueringCiv;
                    super(0);
                }

                public final void invoke() {
                    this.$city.puppetCity(this.$conqueringCiv);
                }
            });
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
            this.addRazeOption(city2, mayAnnex, conqueringCiv);
        }
    }

    private final boolean addCitySettledNearOtherCivDespiteOurPromise() {
        Civilization otherciv = this.getCiv(this.popupAlert.getValue());
        if (otherciv.isDefeated()) {
            return false;
        }
        this.addLeaderName(otherciv);
        Popup.addGoodSizedLabel$default(this, "We noticed your new city near our borders, despite your promise. This will have....implications.", 0, false, 6, null).row();
        this.addCloseButton("Very well.");
        return true;
    }

    private final void addCityTraded() {
        City city2 = this.getCity(this.popupAlert.getValue());
        this.addQuestionAboutTheCity(city2.getName());
        Civilization conqueringCiv = this.getGameInfo().getCurrentPlayerCivilization();
        if (!conqueringCiv.isAtWarWith(this.getCiv(city2.getFoundingCiv()))) {
            this.addLiberateOption(city2, conqueringCiv);
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        }
        this.addCloseButton("Keep it").row();
    }

    private final boolean addDeclarationOfFriendship() {
        Civilization otherciv = this.getCiv(this.popupAlert.getValue());
        if (otherciv.isDefeated()) {
            return false;
        }
        DiplomacyManager diplomacyManager = this.getViewingCiv().getDiplomacyManager(otherciv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager playerDiploManager = diplomacyManager;
        this.addLeaderName(otherciv);
        Popup.addGoodSizedLabel$default(this, "My friend, shall we declare our friendship to the world?", 0, false, 6, null).row();
        this.addCloseButton("Declare Friendship ([30] turns)", KeyboardBinding.Confirm, new Function0<Unit>(playerDiploManager){
            final /* synthetic */ DiplomacyManager $playerDiploManager;
            {
                this.$playerDiploManager = $playerDiploManager;
                super(0);
            }

            public final void invoke() {
                this.$playerDiploManager.signDeclarationOfFriendship();
            }
        }).row();
        this.addCloseButton("We are not interested.", KeyboardBinding.Cancel, new Function0<Unit>(playerDiploManager){
            final /* synthetic */ DiplomacyManager $playerDiploManager;
            {
                this.$playerDiploManager = $playerDiploManager;
                super(0);
            }

            public final void invoke() {
                this.$playerDiploManager.otherCivDiplomacy().setFlag(DiplomacyFlags.DeclinedDeclarationOfFriendship, 20);
            }
        }).row();
        return true;
    }

    private final void addDefeated() {
        Civilization civInfo = this.getCiv(this.popupAlert.getValue());
        this.addLeaderName(civInfo);
        Popup.addGoodSizedLabel$default(this, civInfo.getNation().getDefeated(), 0, false, 6, null).row();
        this.addCloseButton("Farewell.");
        MusicController musicController = this.getMusic();
        String string = civInfo.getCivName();
        EnumSet<Enum> enumSet = EnumSet.of((Enum)MusicTrackChooserFlags.SuffixMustMatch);
        Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
        musicController.chooseTrack(string, "Defeat", enumSet);
        this.getMusic().playVoice(civInfo.getCivName() + ".defeated");
    }

    private final boolean addDemandToStopSettlingCitiesNear() {
        Civilization otherciv = this.getCiv(this.popupAlert.getValue());
        if (otherciv.isDefeated()) {
            return false;
        }
        DiplomacyManager diplomacyManager = this.getViewingCiv().getDiplomacyManager(otherciv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager playerDiploManager = diplomacyManager;
        this.addLeaderName(otherciv);
        Popup.addGoodSizedLabel$default(this, "Please don't settle new cities near us.", 0, false, 6, null).row();
        this.addCloseButton("Very well, we shall look for new lands to settle.", KeyboardBinding.Confirm, new Function0<Unit>(playerDiploManager){
            final /* synthetic */ DiplomacyManager $playerDiploManager;
            {
                this.$playerDiploManager = $playerDiploManager;
                super(0);
            }

            public final void invoke() {
                this.$playerDiploManager.agreeNotToSettleNear();
            }
        }).row();
        this.addCloseButton("We shall do as we please.", KeyboardBinding.Cancel, new Function0<Unit>(playerDiploManager){
            final /* synthetic */ DiplomacyManager $playerDiploManager;
            {
                this.$playerDiploManager = $playerDiploManager;
                super(0);
            }

            public final void invoke() {
                this.$playerDiploManager.refuseDemandNotToSettleNear();
            }
        });
        return true;
    }

    private final boolean addDemandToStopSpreadingReligion() {
        Civilization otherciv = this.getCiv(this.popupAlert.getValue());
        if (otherciv.isDefeated()) {
            return false;
        }
        DiplomacyManager diplomacyManager = this.getViewingCiv().getDiplomacyManager(otherciv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager playerDiploManager = diplomacyManager;
        this.addLeaderName(otherciv);
        Popup.addGoodSizedLabel$default(this, "Please don't spread religion to us.", 0, false, 6, null).row();
        this.addCloseButton("Very well, we shall spread our faith elsewhere.", KeyboardBinding.Confirm, new Function0<Unit>(playerDiploManager){
            final /* synthetic */ DiplomacyManager $playerDiploManager;
            {
                this.$playerDiploManager = $playerDiploManager;
                super(0);
            }

            public final void invoke() {
                this.$playerDiploManager.agreeNotToSpreadReligionTo();
            }
        }).row();
        this.addCloseButton("We shall do as we please.", KeyboardBinding.Cancel, new Function0<Unit>(playerDiploManager){
            final /* synthetic */ DiplomacyManager $playerDiploManager;
            {
                this.$playerDiploManager = $playerDiploManager;
                super(0);
            }

            public final void invoke() {
                this.$playerDiploManager.refuseNotToSpreadReligionTo();
            }
        });
        return true;
    }

    private final boolean addReligionSpreadDespiteOurPromise() {
        Civilization otherciv = this.getCiv(this.popupAlert.getValue());
        if (otherciv.isDefeated()) {
            return false;
        }
        this.addLeaderName(otherciv);
        Popup.addGoodSizedLabel$default(this, "We noticed you have continued spreading your faith, despite your promise. This will have....consequences.", 0, false, 6, null).row();
        this.addCloseButton("Very well.");
        return true;
    }

    private final void addDiplomaticMarriage() {
        City city2 = this.getCity(this.popupAlert.getValue());
        Popup.addGoodSizedLabel$default(this, TranslationsKt.tr$default(city2.getName(), false, false, 3, null) + ": " + TranslationsKt.tr$default("What would you like to do with the city?", false, false, 3, null), 24, false, 4, null).padBottom(20.0f).row();
        Civilization marryingCiv = this.getGameInfo().getCurrentPlayerCivilization();
        if (marryingCiv.isOneCityChallenger()) {
            this.addDestroyOption(new Function0<Unit>(city2){
                final /* synthetic */ City $city;
                {
                    this.$city = $city;
                    super(0);
                }

                public final void invoke() {
                    this.$city.destroyCity(true);
                }
            });
        } else {
            boolean mayAnnex = !Civilization.hasUnique$default(marryingCiv, UniqueType.MayNotAnnexCities, null, 2, null);
            this.addAnnexOption(city2, mayAnnex, addDiplomaticMarriage.2.INSTANCE);
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
            this.addPuppetOption(mayAnnex, new Function0<Unit>(city2){
                final /* synthetic */ City $city;
                {
                    this.$city = $city;
                    super(0);
                }

                public final void invoke() {
                    this.$city.setPuppet(true);
                    CityStats.update$default(this.$city.getCityStats(), null, false, false, null, 15, null);
                }
            });
        }
    }

    private final void addFirstContact() {
        Civilization civInfo = this.getCiv(this.popupAlert.getValue());
        Nation nation2 = civInfo.getNation();
        this.addLeaderName(civInfo);
        this.getMusic().chooseTrack(civInfo.getCivName(), MusicMood.INSTANCE.getThemeOrPeace(), MusicTrackChooserFlags.Companion.getSetSpecific());
        this.getMusic().playVoice(civInfo.getCivName() + ".introduction");
        if (civInfo.isCityState()) {
            Popup.addGoodSizedLabel$default(this, "We have encountered the City-State of [" + nation2.getName() + "]!", 0, false, 6, null).row();
            this.addCloseButton("Excellent!");
        } else {
            Popup.addGoodSizedLabel$default(this, nation2.getIntroduction(), 0, false, 6, null).row();
            this.addCloseButton("A pleasure to meet you.");
        }
    }

    private final void addGameHasBeenWon() {
        VictoryData victoryData = this.getGameInfo().getVictoryData();
        Intrinsics.checkNotNull(victoryData);
        VictoryData victoryData2 = victoryData;
        Popup.addGoodSizedLabel$default(this, '[' + victoryData2.getWinningCiv() + "] has won a [" + victoryData2.getVictoryType() + "] Victory!", 0, false, 6, null).row();
        Popup.addButton$default((Popup)this, "Victory status", null, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ AlertPopup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.close();
                AlertPopup.access$getWorldScreen$p(this.this$0).getGame().pushScreen(new VictoryScreen(AlertPopup.access$getWorldScreen$p(this.this$0), 0, 2, null));
            }
        }, 6, null).row();
        AlertPopup.addCloseButton$default(this, null, 1, null);
    }

    private final void addGoldenAge() {
        Popup.addGoodSizedLabel$default(this, "GOLDEN AGE", 0, false, 6, null);
        Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        Popup.addGoodSizedLabel$default(this, "Your citizens have been happy with your rule for so long that the empire enters a Golden Age!", 0, false, 6, null).row();
        AlertPopup.addCloseButton$default(this, null, 1, null);
        this.getMusic().chooseTrack(this.getViewingCiv().getCivName(), "Golden", MusicTrackChooserFlags.Companion.getSetSpecific());
    }

    private final boolean addRecapturedCivilian() {
        Vector2 position = new Vector2().fromString(this.popupAlert.getValue());
        TileMap tileMap = this.getGameInfo().getTileMap();
        Intrinsics.checkNotNull(position);
        Tile tile = tileMap.get(position);
        MapUnit mapUnit = tile.getCivilianUnit();
        if (mapUnit == null) {
            return false;
        }
        MapUnit capturedUnit = mapUnit;
        String string = capturedUnit.getOriginalOwner();
        Intrinsics.checkNotNull(string);
        Civilization originalOwner = this.getCiv(string);
        if (originalOwner.isDefeated()) {
            return false;
        }
        Civilization captor = this.getViewingCiv();
        Popup.addGoodSizedLabel$default(this, "Return [" + capturedUnit.getName() + "] to [" + originalOwner.getCivName() + "]?", 0, false, 6, null);
        Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        Popup.addGoodSizedLabel$default(this, "The [" + capturedUnit.getName() + "] we liberated originally belonged to [" + originalOwner.getCivName() + "]. They will be grateful if we return it to them.", 0, false, 6, null).row();
        Cell cell2 = this.getBottomTable().defaults();
        Intrinsics.checkNotNullExpressionValue(cell2, "defaults(...)");
        Scene2dExtensionsKt.pad(cell2, 0.0f, 30.0f);
        this.addCloseButton("Yes", KeyboardBinding.Confirm, new Function0<Unit>(capturedUnit, originalOwner, captor, tile){
            final /* synthetic */ MapUnit $capturedUnit;
            final /* synthetic */ Civilization $originalOwner;
            final /* synthetic */ Civilization $captor;
            final /* synthetic */ Tile $tile;
            {
                this.$capturedUnit = $capturedUnit;
                this.$originalOwner = $originalOwner;
                this.$captor = $captor;
                this.$tile = $tile;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                Object v0;
                void $this$minByOrNull$iv;
                String unitName = this.$capturedUnit.getBaseUnit().getName();
                MapUnit.destroy$default(this.$capturedUnit, false, 1, null);
                Iterable iterable = this.$originalOwner.getCities();
                String[] stringArray = this.$tile;
                boolean $i$f$minByOrNull = false;
                Iterator<T> iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    T minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        City it = (City)minElem$iv;
                        boolean bl = false;
                        int minValue$iv = it.getCenterTile().aerialDistanceTo((Tile)stringArray);
                        do {
                            T e$iv = iterator$iv.next();
                            City it2 = (City)e$iv;
                            $i$a$-minByOrNull-AlertPopup$addRecapturedCivilian$1$closestCity$1 = false;
                            int v$iv = it2.getCenterTile().aerialDistanceTo((Tile)stringArray);
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                City closestCity = v0;
                if (closestCity != null) {
                    this.$originalOwner.getUnits().placeUnitNearTile(closestCity.getLocation(), unitName);
                }
                if (this.$originalOwner.isCityState()) {
                    this.$originalOwner.getDiplomacyManagerOrMeet(this.$captor).addInfluence(45.0f);
                } else if (this.$originalOwner.isMajorCiv()) {
                    this.$originalOwner.getDiplomacyManagerOrMeet(this.$captor).setModifier(DiplomaticModifiers.ReturnedCapturedUnits, 20.0f);
                }
                Sequence<T> notificationSequence2 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super NotificationAction>, Continuation<? super Unit>, Object>(this.$tile, closestCity, this.$captor, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Tile $tile;
                    final /* synthetic */ City $closestCity;
                    final /* synthetic */ Civilization $captor;
                    {
                        this.$tile = $tile;
                        this.$closestCity = $closestCity;
                        this.$captor = $captor;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(var1_1);
                                $this$sequence = (SequenceScope)this.L$0;
                                this.L$0 = $this$sequence;
                                this.label = 1;
                                v0 = $this$sequence.yield(new LocationAction(this.$tile.getPosition()), this);
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure($result);
                                v0 = $result;
lbl16:
                                // 2 sources

                                if (this.$closestCity != null) {
                                    this.L$0 = $this$sequence;
                                    this.label = 2;
                                    v1 = $this$sequence.yield(new LocationAction(this.$closestCity.getLocation()), this);
                                    if (v1 == var3_2) {
                                        return var3_2;
                                    }
                                }
                                ** GOTO lbl27
                            }
                            case 2: {
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure($result);
                                v1 = $result;
lbl27:
                                // 2 sources

                                this.L$0 = $this$sequence;
                                this.label = 3;
                                v2 = $this$sequence.yield(new DiplomacyAction(this.$captor.getCivName(), false, 2, null), this);
                                if (v2 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl37
                            }
                            case 3: {
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure($result);
                                v2 = $result;
lbl37:
                                // 2 sources

                                this.L$0 = null;
                                this.label = 4;
                                v3 = $this$sequence.yield(new CivilopediaAction("Tutorial/Barbarians"), this);
                                if (v3 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl46
                            }
                            case 4: {
                                ResultKt.throwOnFailure($result);
                                v3 = $result;
lbl46:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<SequenceScope<? super NotificationAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)((Object)function2);
                    }

                    @Nullable
                    public final Object invoke(@NotNull SequenceScope<? super NotificationAction> p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                });
                stringArray = new String[]{"StatIcons/Acquire", unitName, this.$captor.getCivName()};
                this.$originalOwner.addNotification("Your captured [" + unitName + "] has been returned by [" + this.$captor.getCivName() + ']', notificationSequence2, Notification.NotificationCategory.Diplomacy, stringArray);
            }
        });
        this.addCloseButton("No", KeyboardBinding.Cancel, new Function0<Unit>(capturedUnit, captor){
            final /* synthetic */ MapUnit $capturedUnit;
            final /* synthetic */ Civilization $captor;
            {
                this.$capturedUnit = $capturedUnit;
                this.$captor = $captor;
                super(0);
            }

            public final void invoke() {
                BattleUnitCapture.INSTANCE.captureOrConvertToWorker(this.$capturedUnit, this.$captor);
            }
        });
        return true;
    }

    private final void addStartIntro() {
        Civilization civInfo = this.getViewingCiv();
        this.addLeaderName(civInfo);
        Popup.addGoodSizedLabel$default(this, civInfo.getNation().getStartIntroPart1(), 0, false, 6, null).row();
        Popup.addGoodSizedLabel$default(this, civInfo.getNation().getStartIntroPart2(), 0, false, 6, null).row();
        this.addCloseButton("Let's begin!");
    }

    /*
     * WARNING - void declaration
     */
    private final void addTechResearched() {
        void $this$addTechResearched_u24lambda_u241;
        Label label2;
        Technology technology2 = this.getGameInfo().getRuleset().getTechnologies().get(this.popupAlert.getValue());
        Intrinsics.checkNotNull(technology2);
        Technology tech = technology2;
        Popup.addGoodSizedLabel$default(this, tech.getName(), 0, false, 6, null);
        Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        Table centerTable = new Table();
        Label label3 = label2 = Scene2dExtensionsKt.toLabel(tech.getQuote());
        Table table2 = centerTable;
        boolean bl = false;
        $this$addTechResearched_u24lambda_u241.setWrap(true);
        table2.add((Actor)label2).width(this.getStageWidth() / (float)3);
        centerTable.add((Actor)ImageGetter.INSTANCE.getTechIconPortrait(tech.getName(), 100.0f)).pad(20.0f);
        Label $this$addTechResearched_u24lambda_u242 = label3 = Scene2dExtensionsKt.toLabel(tech.getDescription(this.getViewingCiv()));
        boolean bl2 = false;
        $this$addTechResearched_u24lambda_u242.setWrap(true);
        Actor actor = label3;
        ScrollPane descriptionScroll = new ScrollPane(actor);
        centerTable.add((Actor)descriptionScroll).width(this.getStageWidth() / (float)3).maxHeight(this.getStageHeight() / (float)2);
        this.add((Actor)centerTable).row();
        AlertPopup.addCloseButton$default(this, null, 1, null);
        this.getMusic().chooseTrack(tech.getName(), "Researched", MusicTrackChooserFlags.Companion.getSetSpecific());
    }

    private final boolean addWarDeclaration() {
        Civilization civInfo = this.getCiv(this.popupAlert.getValue());
        if (civInfo.isDefeated()) {
            return false;
        }
        this.addLeaderName(civInfo);
        Popup.addGoodSizedLabel$default(this, civInfo.getNation().getDeclaringWar(), 0, false, 6, null).row();
        Cell cell2 = this.getBottomTable().defaults();
        Intrinsics.checkNotNullExpressionValue(cell2, "defaults(...)");
        Scene2dExtensionsKt.pad(cell2, 0.0f, 5.0f);
        this.addCloseButton("You'll pay for this!");
        this.addCloseButton("Very well.");
        this.getMusic().chooseTrack(civInfo.getCivName(), "War", MusicTrackChooserFlags.Companion.getSetSpecific());
        this.getMusic().playVoice(civInfo.getCivName() + ".declaringWar");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void addWonderBuilt() {
        void $this$addWonderBuilt_u24lambda_u244;
        Label $this$addWonderBuilt_u24lambda_u243;
        Label label2;
        Building building = this.getGameInfo().getRuleset().getBuildings().get(this.popupAlert.getValue());
        Intrinsics.checkNotNull(building);
        Building wonder = building;
        Popup.addGoodSizedLabel$default(this, wonder.getName(), 0, false, 6, null);
        Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        if (ImageGetter.INSTANCE.wonderImageExists(wonder.getName())) {
            if (this.getStageHeight() * (float)3 > this.getStageWidth() * (float)4) {
                this.add((Actor)ImageGetter.INSTANCE.getWonderImage(wonder.getName())).width(this.getStageWidth() / 1.5f).height(this.getStageWidth() / (float)3).row();
            } else {
                this.add((Actor)ImageGetter.INSTANCE.getWonderImage(wonder.getName())).width(this.getStageWidth() / 2.5f).height(this.getStageWidth() / (float)5).row();
            }
        } else {
            this.add((Actor)ImageGetter.INSTANCE.getConstructionPortrait(wonder.getName(), 100.0f)).pad(20.0f).row();
        }
        Table centerTable = new Table();
        Label label3 = label2 = Scene2dExtensionsKt.toLabel(wonder.getQuote());
        Table table2 = centerTable;
        boolean bl = false;
        $this$addWonderBuilt_u24lambda_u243.setWrap(true);
        table2.add((Actor)label2).width(this.getStageWidth() / (float)3).pad(10.0f);
        $this$addWonderBuilt_u24lambda_u243 = label2 = Scene2dExtensionsKt.toLabel(Building.getShortDescription$default(wonder, false, null, 3, null));
        table2 = centerTable;
        boolean bl2 = false;
        $this$addWonderBuilt_u24lambda_u244.setWrap(true);
        table2.add((Actor)label2).width(this.getStageWidth() / (float)3).pad(10.0f);
        this.add((Actor)centerTable).row();
        AlertPopup.addCloseButton$default(this, null, 1, null);
        this.getMusic().chooseTrack(wonder.getName(), "Wonder", MusicTrackChooserFlags.Companion.getSetSpecific());
    }

    private final void addLeaderName(Civilization civInfo) {
        this.add((Actor)new LeaderIntroTable(civInfo, null, 2, null));
        Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
    }

    private final void addQuestionAboutTheCity(String cityName) {
        this.addGoodSizedLabel("What would you like to do with the city of [" + cityName + "]?", 24, true).padBottom(20.0f).row();
    }

    private final void addDestroyOption(Function0<Unit> destroyAction) {
        TextButton button = Scene2dExtensionsKt.toTextButton$default("Destroy", null, false, 3, null);
        ActivationExtensionsKt.onActivation(button, new Function0<Unit>(destroyAction, this){
            final /* synthetic */ Function0<Unit> $destroyAction;
            final /* synthetic */ AlertPopup this$0;
            {
                this.$destroyAction = $destroyAction;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$destroyAction.invoke();
                this.this$0.close();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(button).add(Character.valueOf('d'));
        this.add((Actor)button).row();
        Popup.addGoodSizedLabel$default(this, "Destroying the city instantly razes the city to the ground.", 0, false, 6, null).row();
    }

    private final void addAnnexOption(City city2, boolean mayAnnex, Function0<Unit> annexAction) {
        TextButton button;
        TextButton textButton;
        TextButton $this$addAnnexOption_u24lambda_u245 = textButton = (button = Scene2dExtensionsKt.toTextButton$default("Annex", null, false, 3, null));
        boolean bl = false;
        if (!mayAnnex) {
            Scene2dExtensionsKt.disable($this$addAnnexOption_u24lambda_u245);
        } else {
            ActivationExtensionsKt.onActivation(button, new Function0<Unit>(annexAction, city2, this){
                final /* synthetic */ Function0<Unit> $annexAction;
                final /* synthetic */ City $city;
                final /* synthetic */ AlertPopup this$0;
                {
                    this.$annexAction = $annexAction;
                    this.$city = $city;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.$annexAction.invoke();
                    this.$city.annexCity();
                    this.this$0.close();
                }
            });
            ActivationExtensionsKt.getKeyShortcuts(button).add(Character.valueOf('a'));
        }
        this.add((Actor)button).row();
        if (mayAnnex) {
            Popup.addGoodSizedLabel$default(this, "Annexed cities become part of your regular empire.", 0, false, 6, null).row();
            Popup.addGoodSizedLabel$default(this, "Their citizens generate 2x the unhappiness, unless you build a courthouse.", 0, false, 6, null).row();
        } else {
            Popup.addGoodSizedLabel$default(this, "Your civilization may not annex this city.", 0, false, 6, null).row();
        }
    }

    private final void addPuppetOption(boolean mayAnnex, Function0<Unit> puppetAction) {
        TextButton button = Scene2dExtensionsKt.toTextButton$default("Puppet", null, false, 3, null);
        ActivationExtensionsKt.onActivation(button, new Function0<Unit>(puppetAction, this){
            final /* synthetic */ Function0<Unit> $puppetAction;
            final /* synthetic */ AlertPopup this$0;
            {
                this.$puppetAction = $puppetAction;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$puppetAction.invoke();
                this.this$0.close();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(button).add(Character.valueOf('p'));
        this.add((Actor)button).row();
        Popup.addGoodSizedLabel$default(this, "Puppeted cities do not increase your tech or policy cost.", 0, false, 6, null).row();
        Popup.addGoodSizedLabel$default(this, "You have no control over the the production of puppeted cities.", 0, false, 6, null).row();
        Popup.addGoodSizedLabel$default(this, "Puppeted cities also generate 25% less Science and Culture.", 0, false, 6, null).row();
        if (mayAnnex) {
            Popup.addGoodSizedLabel$default(this, "A puppeted city can be annexed at any time.", 0, false, 6, null).row();
        }
    }

    private final void addLiberateOption(City city2, Civilization conqueringCiv) {
        String[] stringArray = new String[]{city2.getFoundingCiv()};
        TextButton button = Scene2dExtensionsKt.toTextButton$default(TranslationsKt.fillPlaceholders("Liberate (city returns to [originalOwner])", stringArray), null, false, 3, null);
        ActivationExtensionsKt.onActivation(button, new Function0<Unit>(city2, conqueringCiv, this){
            final /* synthetic */ City $city;
            final /* synthetic */ Civilization $conqueringCiv;
            final /* synthetic */ AlertPopup this$0;
            {
                this.$city = $city;
                this.$conqueringCiv = $conqueringCiv;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$city.liberateCity(this.$conqueringCiv);
                this.this$0.close();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(button).add(Character.valueOf('l'));
        this.add((Actor)button).row();
        Popup.addGoodSizedLabel$default(this, "Liberating a city returns it to its original owner, giving you a massive relationship boost with them!", 0, false, 6, null);
    }

    private final void addRazeOption(City city2, boolean mayAnnex, Civilization conqueringCiv) {
        TextButton button;
        TextButton textButton;
        boolean canRaze = city2.canBeDestroyed(true);
        TextButton $this$addRazeOption_u24lambda_u246 = textButton = (button = Scene2dExtensionsKt.toTextButton$default("Raze", null, false, 3, null));
        boolean bl = false;
        if (!canRaze) {
            Scene2dExtensionsKt.disable($this$addRazeOption_u24lambda_u246);
        } else {
            ActivationExtensionsKt.onActivation($this$addRazeOption_u24lambda_u246, new Function0<Unit>(city2, conqueringCiv, mayAnnex, this){
                final /* synthetic */ City $city;
                final /* synthetic */ Civilization $conqueringCiv;
                final /* synthetic */ boolean $mayAnnex;
                final /* synthetic */ AlertPopup this$0;
                {
                    this.$city = $city;
                    this.$conqueringCiv = $conqueringCiv;
                    this.$mayAnnex = $mayAnnex;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.$city.puppetCity(this.$conqueringCiv);
                    if (this.$mayAnnex) {
                        this.$city.annexCity();
                    }
                    this.$city.setBeingRazed(true);
                    this.this$0.close();
                }
            });
            ActivationExtensionsKt.getKeyShortcuts($this$addRazeOption_u24lambda_u246).add(Character.valueOf('r'));
        }
        this.add((Actor)button).row();
        if (canRaze) {
            if (mayAnnex) {
                Popup.addGoodSizedLabel$default(this, "Razing the city annexes it, and starts burning the city to the ground.", 0, false, 6, null).row();
            } else {
                Popup.addGoodSizedLabel$default(this, "Razing the city puppets it, and starts burning the city to the ground.", 0, false, 6, null).row();
            }
            Popup.addGoodSizedLabel$default(this, "The population will gradually dwindle until the city is destroyed.", 0, false, 6, null).row();
        } else {
            Popup.addGoodSizedLabel$default(this, "Original capitals and holy cities cannot be razed.", 0, false, 6, null).row();
        }
    }

    private final boolean addEvent() {
        char[] cArray = new char[]{'\u241f'};
        List splitString = StringsKt.split$default((CharSequence)this.popupAlert.getValue(), cArray, false, 0, 6, null);
        String eventName = (String)splitString.get(0);
        MapUnit unit = null;
        int n = splitString.size();
        for (int i = 1; i < n; ++i) {
            if (!StringsKt.startsWith$default((String)splitString.get(i), "unitId=", false, 2, null)) continue;
            int unitId = Integer.parseInt(StringsKt.substringAfter$default((String)splitString.get(i), "unitId=", null, 2, null));
            unit = this.getViewingCiv().getUnits().getUnitById(unitId);
        }
        Event event = this.getGameInfo().getRuleset().getEvents().get(eventName);
        if (event == null) {
            return false;
        }
        Event event2 = event;
        RenderEvent render2 = new RenderEvent(event2, this.worldScreen, unit, (Function1<? super EventChoice, Unit>)new Function1<EventChoice, Unit>(this){
            final /* synthetic */ AlertPopup this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull EventChoice it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.this$0.close();
            }
        });
        if (!render2.isValid()) {
            return false;
        }
        this.add((Actor)render2).pad(0.0f).row();
        return true;
    }

    @Override
    public void close() {
        this.getViewingCiv().getPopupAlerts().remove(this.popupAlert);
        this.worldScreen.setShouldUpdate(true);
        super.close();
    }

    public static final /* synthetic */ PopupAlert access$getPopupAlert$p(AlertPopup $this) {
        return $this.popupAlert;
    }

    public static final /* synthetic */ WorldScreen access$getWorldScreen$p(AlertPopup $this) {
        return $this.worldScreen;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AlertType.values().length];
            try {
                nArray[AlertType.CityConquered.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.CityTraded.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.DiplomaticMarriage.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.FirstContact.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.WarDeclaration.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.BorderConflict.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.TilesStolen.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.DemandToStopSettlingCitiesNear.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.CitySettledNearOtherCivDespiteOurPromise.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.DemandToStopSpreadingReligion.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ReligionSpreadDespiteOurPromise.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.DeclarationOfFriendship.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.BulliedProtectedMinor.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.AttackedProtectedMinor.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.AttackedAllyMinor.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.Defeated.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.WonderBuilt.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.TechResearched.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.GoldenAge.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.StartIntro.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.RecapturedCivilian.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.GameHasBeenWon.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.Event.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

