/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.minimap;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.ExploredRegion;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.minimap.MapOverlayToggleButton;
import com.unciv.ui.screens.worldscreen.minimap.Minimap;
import com.unciv.ui.screens.worldscreen.minimap.MinimapHolder;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001=B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u001a\u0010'\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020&H\u0016J\b\u0010+\u001a\u00020,H\u0002J\u0012\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u0010\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020&H\u0002J\b\u00103\u001a\u00020\u0001H\u0002J\"\u00104\u001a\u0004\u0018\u00010.2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020\u0010H\u0016J\u0012\u00108\u001a\u00020$2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u0012\u00109\u001a\u00020$2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u0010\u0010:\u001a\u00020$2\u0006\u0010/\u001a\u000200H\u0002J\b\u0010;\u001a\u00020\u0010H\u0002J\u000e\u0010<\u001a\u00020$2\u0006\u0010/\u001a\u000200R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0011\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u0011\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\fR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\f\u00a8\u0006>"}, d2={"Lcom/unciv/ui/screens/worldscreen/minimap/MinimapHolder;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "mapHolder", "Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;", "(Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;)V", "buttons", "", "Lcom/unciv/ui/screens/worldscreen/minimap/MapOverlayToggleButton;", "getButtons", "()Ljava/util/List;", "improvementsImageButton", "getImprovementsImageButton", "()Lcom/unciv/ui/screens/worldscreen/minimap/MapOverlayToggleButton;", "getMapHolder", "()Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;", "maximized", "", "minimap", "Lcom/unciv/ui/screens/worldscreen/minimap/Minimap;", "getMinimap", "()Lcom/unciv/ui/screens/worldscreen/minimap/Minimap;", "setMinimap", "(Lcom/unciv/ui/screens/worldscreen/minimap/Minimap;)V", "minimapSize", "", "movementsImageButton", "getMovementsImageButton", "populationImageButton", "getPopulationImageButton", "resourceImageButton", "getResourceImageButton", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "yieldImageButton", "getYieldImageButton", "act", "", "delta", "", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "getCornerHandleIcon", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getMaximizeToggleButton", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getToggleIcons", "minimapHeight", "getWrappedMinimap", "hit", "x", "y", "touchable", "rebuild", "rebuildAndUpdateMap", "rebuildIfSizeChanged", "shouldShowMapButtons", "update", "ResizeDragListener", "core"})
@SourceDebugExtension(value={"SMAP\nMinimapHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinimapHolder.kt\ncom/unciv/ui/screens/worldscreen/minimap/MinimapHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
public final class MinimapHolder
extends Table {
    @NotNull
    private final WorldMapHolder mapHolder;
    @NotNull
    private final WorldScreen worldScreen;
    private int minimapSize;
    private boolean maximized;
    public Minimap minimap;
    @NotNull
    private final MapOverlayToggleButton movementsImageButton;
    @NotNull
    private final MapOverlayToggleButton yieldImageButton;
    @NotNull
    private final MapOverlayToggleButton populationImageButton;
    @NotNull
    private final MapOverlayToggleButton resourceImageButton;
    @NotNull
    private final MapOverlayToggleButton improvementsImageButton;
    @NotNull
    private final List<MapOverlayToggleButton> buttons;

    public MinimapHolder(@NotNull WorldMapHolder mapHolder2) {
        Intrinsics.checkNotNullParameter(mapHolder2, "mapHolder");
        this.mapHolder = mapHolder2;
        this.worldScreen = this.mapHolder.getWorldScreen$core();
        this.minimapSize = Integer.MIN_VALUE;
        this.movementsImageButton = new MapOverlayToggleButton("TileIcons/MapOverlayToggleMovement", 0.0f, movementsImageButton.1.INSTANCE, movementsImageButton.2.INSTANCE, 2, null);
        this.yieldImageButton = new MapOverlayToggleButton("TileIcons/MapOverlayToggleYields", 0.0f, yieldImageButton.1.INSTANCE, yieldImageButton.2.INSTANCE, 2, null);
        this.populationImageButton = new MapOverlayToggleButton("TileIcons/MapOverlayToggleWorkedTiles", 0.0f, populationImageButton.1.INSTANCE, populationImageButton.2.INSTANCE, 2, null);
        this.resourceImageButton = new MapOverlayToggleButton("TileIcons/MapOverlayToggleResources", 0.0f, resourceImageButton.1.INSTANCE, resourceImageButton.2.INSTANCE, 2, null);
        this.improvementsImageButton = new MapOverlayToggleButton("TileIcons/MapOverlayToggleImprovements", 0.0f, improvementsImageButton.1.INSTANCE, improvementsImageButton.2.INSTANCE, 2, null);
        MapOverlayToggleButton[] mapOverlayToggleButtonArray = new MapOverlayToggleButton[]{this.movementsImageButton, this.yieldImageButton, this.populationImageButton, this.resourceImageButton, this.improvementsImageButton};
        this.buttons = CollectionsKt.listOf(mapOverlayToggleButtonArray);
    }

    @NotNull
    public final WorldMapHolder getMapHolder() {
        return this.mapHolder;
    }

    @NotNull
    public final Minimap getMinimap() {
        Minimap minimap = this.minimap;
        if (minimap != null) {
            return minimap;
        }
        Intrinsics.throwUninitializedPropertyAccessException("minimap");
        return null;
    }

    public final void setMinimap(@NotNull Minimap minimap) {
        Intrinsics.checkNotNullParameter(minimap, "<set-?>");
        this.minimap = minimap;
    }

    @NotNull
    public final MapOverlayToggleButton getMovementsImageButton() {
        return this.movementsImageButton;
    }

    @NotNull
    public final MapOverlayToggleButton getYieldImageButton() {
        return this.yieldImageButton;
    }

    @NotNull
    public final MapOverlayToggleButton getPopulationImageButton() {
        return this.populationImageButton;
    }

    @NotNull
    public final MapOverlayToggleButton getResourceImageButton() {
        return this.resourceImageButton;
    }

    @NotNull
    public final MapOverlayToggleButton getImprovementsImageButton() {
        return this.improvementsImageButton;
    }

    @NotNull
    public final List<MapOverlayToggleButton> getButtons() {
        return this.buttons;
    }

    private final void rebuildIfSizeChanged(Civilization civInfo) {
        Civilization civilization;
        Civilization it = civilization = civInfo;
        boolean bl = false;
        Civilization civ = !GUI.INSTANCE.getViewingPlayer().isSpectator() ? civilization : null;
        int newMinimapSize = this.worldScreen.getGame().getSettings().getMinimapSize();
        if (newMinimapSize == this.minimapSize) {
            IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = civ;
            if (!(isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((Civilization)isPartOfGameInfoSerialization).getExploredRegion()) != null ? ((ExploredRegion)isPartOfGameInfoSerialization).shouldUpdateMinimap() : false)) {
                return;
            }
        }
        this.minimapSize = newMinimapSize;
        this.rebuild(civ);
    }

    private final void rebuild(Civilization civInfo) {
        this.clear();
        this.setMinimap(new Minimap(this.mapHolder, this.minimapSize, civInfo));
        Table wrappedMinimap = this.getWrappedMinimap();
        this.add((Actor)this.getToggleIcons(wrappedMinimap.getHeight())).bottom().padRight(5.0f);
        Stack stack = new Stack();
        stack.add(wrappedMinimap);
        Scene2dExtensionsKt.addInTable(stack, (Actor)this.getCornerHandleIcon()).size(20.0f).pad(8.0f).top().left();
        Scene2dExtensionsKt.addInTable(stack, this.getMaximizeToggleButton(civInfo)).size(40.0f).bottom().right();
        this.add((Actor)stack).bottom();
        this.pack();
        if (this.getStage() != null) {
            this.setX(this.getStage().getWidth() - this.getWidth());
        }
        this.addListener(new ResizeDragListener(civInfo));
    }

    private final void rebuildAndUpdateMap(Civilization civInfo) {
        this.rebuild(civInfo);
        Civilization civilization = civInfo;
        if (civilization != null) {
            Civilization it = civilization;
            boolean bl = false;
            this.getMinimap().update(it);
        }
        this.getMinimap().getMapHolder().onViewportChanged();
    }

    private final Actor getMaximizeToggleButton(Civilization civInfo) {
        if (this.maximized) {
            ActivationExtensionsKt.onClick(this.getMinimap(), new Function0<Unit>(this){
                final /* synthetic */ MinimapHolder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    MinimapHolder.access$setMaximized$p(this.this$0, false);
                }
            });
        }
        Function0 toggle2 = new Function0<Unit>(this, civInfo){
            final /* synthetic */ MinimapHolder this$0;
            final /* synthetic */ Civilization $civInfo;
            {
                this.this$0 = $receiver;
                this.$civInfo = $civInfo;
                super(0);
            }

            public final void invoke() {
                MinimapHolder.access$setMaximized$p(this.this$0, !MinimapHolder.access$getMaximized$p(this.this$0));
                MinimapHolder.access$setMinimapSize$p(this.this$0, MinimapHolder.access$getMaximized$p(this.this$0) && this.this$0.getStage() != null ? this.this$0.getMinimap().getClosestMinimapSize(new Vector2(this.this$0.getStage().getWidth(), this.this$0.getStage().getHeight()), true) : MinimapHolder.access$getWorldScreen$p(this.this$0).getGame().getSettings().getMinimapSize());
                MinimapHolder.access$rebuildAndUpdateMap(this.this$0, this.$civInfo);
            }
        };
        Table table2 = new Table();
        if (this.shouldShowMapButtons()) {
            String name2 = this.maximized ? "Reduce" : "Increase";
            Image image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/" + name2, null, 2, null);
            table2.add((Actor)image2).expand().size(20.0f).pad(8.0f).bottom().right();
            table2.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onActivation(table2, toggle2);
        } else {
            table2.setVisible(false);
            this.getMinimap().setTouchable(Touchable.disabled);
            this.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onActivation(this, toggle2);
        }
        return table2;
    }

    private final Image getCornerHandleIcon() {
        Image image2;
        Image $this$getCornerHandleIcon_u24lambda_u242 = image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Corner", null, 2, null);
        boolean bl = false;
        $this$getCornerHandleIcon_u24lambda_u242.setTouchable(Touchable.disabled);
        $this$getCornerHandleIcon_u24lambda_u242.setVisible(!this.maximized && this.shouldShowMapButtons());
        return image2;
    }

    private final boolean shouldShowMapButtons() {
        return this.minimapSize > 0 && (this.getMinimap().getWidth() > 100.0f || this.getMinimap().getHeight() > 100.0f);
    }

    private final Table getWrappedMinimap() {
        Table internalMinimapWrapper = new Table();
        internalMinimapWrapper.add((Actor)this.getMinimap());
        internalMinimapWrapper.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/Minimap/Background", null, Color.GRAY, 2, null));
        internalMinimapWrapper.pack();
        Table externalMinimapWrapper = new Table();
        externalMinimapWrapper.add((Actor)internalMinimapWrapper).pad(5.0f);
        externalMinimapWrapper.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/Minimap/Border", null, Color.WHITE, 2, null));
        externalMinimapWrapper.pack();
        return externalMinimapWrapper;
    }

    /*
     * WARNING - void declaration
     */
    private final Table getToggleIcons(float minimapHeight) {
        double d;
        Table toggleIconTable = new Table();
        Iterable iterable = this.buttons;
        float f = minimapHeight;
        double d2 = 0.0;
        for (Object t : iterable) {
            void it;
            MapOverlayToggleButton mapOverlayToggleButton = (MapOverlayToggleButton)t;
            d = d2;
            boolean bl = false;
            double d3 = it.getHeight();
            d2 = d + d3;
        }
        d = d2;
        float availableForPadding = f - (float)d;
        float paddingBetweenElements = RangesKt.coerceIn(availableForPadding / (float)3, 0.0f, 5.0f);
        toggleIconTable.defaults().padTop(paddingBetweenElements);
        for (MapOverlayToggleButton button : this.buttons) {
            toggleIconTable.add((Actor)button).row();
        }
        return toggleIconTable;
    }

    public final void update(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.rebuildIfSizeChanged(civInfo);
        this.setVisible(UncivGame.Companion.getCurrent().getSettings().getShowMinimap());
        if (this.isVisible()) {
            this.getMinimap().update(civInfo);
            for (MapOverlayToggleButton button : this.buttons) {
                button.update();
            }
        }
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        return super.hit(x, y, touchable);
    }

    @Override
    public void act(float delta) {
    }

    public static final /* synthetic */ void access$setMaximized$p(MinimapHolder $this, boolean bl) {
        $this.maximized = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/screens/worldscreen/minimap/MinimapHolder$ResizeDragListener;", "Lcom/badlogic/gdx/scenes/scene2d/utils/DragListener;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/ui/screens/worldscreen/minimap/MinimapHolder;Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "dragged", "", "touchDragged", "", "event", "Lcom/badlogic/gdx/scenes/scene2d/InputEvent;", "x", "", "y", "pointer", "", "touchUp", "button", "core"})
    public final class ResizeDragListener
    extends DragListener {
        @Nullable
        private final Civilization civInfo;
        private boolean dragged;

        public ResizeDragListener(Civilization civInfo) {
            this.civInfo = civInfo;
        }

        @Nullable
        public final Civilization getCivInfo() {
            return this.civInfo;
        }

        @Override
        public void touchDragged(@NotNull InputEvent event, float x, float y, int pointer) {
            Intrinsics.checkNotNullParameter(event, "event");
            super.touchDragged(event, x, y, pointer);
            if (!this.isDragging() || MinimapHolder.this.maximized) {
                return;
            }
            this.dragged = true;
            Vector2 targetSize = new Vector2(MinimapHolder.this.getStage().getWidth() - event.getStageX(), event.getStageY());
            MinimapHolder.this.minimapSize = Minimap.getClosestMinimapSize$default(MinimapHolder.this.getMinimap(), targetSize, false, 2, null);
            MinimapHolder.this.rebuildAndUpdateMap(this.civInfo);
        }

        @Override
        public void touchUp(@NotNull InputEvent event, float x, float y, int pointer, int button) {
            Intrinsics.checkNotNullParameter(event, "event");
            super.touchUp(event, x, y, pointer, button);
            if (this.dragged) {
                MinimapHolder.this.worldScreen.getGame().getSettings().setMinimapSize(MinimapHolder.this.minimapSize);
                GUI.INSTANCE.setUpdateWorldOnNextRender();
            }
        }
    }
}

