/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit.actions;

import com.unciv.logic.city.City;
import com.unciv.logic.city.managers.CityReligionManager;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.UncivSound;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionModifiers;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ#\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0010J#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsReligion;", "", "()V", "getEnhanceReligionActions", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/UnitAction;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "getEnhanceReligionActions$core", "getFoundReligionActions", "getFoundReligionActions$core", "getPressureAddedFromSpread", "", "getRemoveHeresyActions", "getRemoveHeresyActions$core", "getSpreadReligionActions", "getSpreadReligionActions$core", "core"})
@SourceDebugExtension(value={"SMAP\nUnitActionsReligion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitActionsReligion.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsReligion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,159:1\n1747#2,3:160\n1747#2,3:164\n1#3:163\n553#4,3:167\n*S KotlinDebug\n*F\n+ 1 UnitActionsReligion.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsReligion\n*L\n22#1:160,3\n51#1:164,3\n129#1:167,3\n*E\n"})
public final class UnitActionsReligion {
    @NotNull
    public static final UnitActionsReligion INSTANCE = new UnitActionsReligion();

    private UnitActionsReligion() {
    }

    @NotNull
    public final Sequence<UnitAction> getFoundReligionActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        boolean bl;
        Unique unique;
        block5: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (!unit.getCiv().getReligionManager().mayFoundReligionAtAll()) {
                return SequencesKt.emptySequence();
            }
            Unique unique2 = SequencesKt.firstOrNull(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(unit, UniqueType.MayFoundReligion));
            if (unique2 == null) {
                return SequencesKt.emptySequence();
            }
            unique = unique2;
            Iterable $this$any$iv = unique.getModifiers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Unique it = (Unique)element$iv;
                    boolean bl2 = false;
                    Object object = it.getType();
                    boolean bl3 = object != null && (object = object.getTargetTypes()) != null ? ((HashSet)object).contains((Object)UniqueTarget.UnitActionModifier) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean hasActionModifiers = bl;
        UnitAction[] unitActionArray = new UnitAction[1];
        Function0<Unit> function0 = new Function0<Unit>(unit, hasActionModifiers, unique){
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ boolean $hasActionModifiers;
            final /* synthetic */ Unique $unique;
            {
                this.$unit = $unit;
                this.$hasActionModifiers = $hasActionModifiers;
                this.$unique = $unique;
                super(0);
            }

            public final void invoke() {
                this.$unit.getCiv().getReligionManager().foundReligion(this.$unit);
                if (this.$hasActionModifiers) {
                    UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, this.$unit, this.$unique, false, 4, null);
                } else {
                    this.$unit.consume();
                }
            }
        };
        Function0 function02 = function0;
        Unique unique3 = null;
        UncivSound uncivSound = null;
        boolean bl4 = false;
        String string = hasActionModifiers ? UnitActionModifiers.INSTANCE.actionTextWithSideEffects(UnitActionType.FoundReligion.getValue(), unique, unit) : UnitActionType.FoundReligion.getValue();
        float f = 80.0f;
        UnitActionType unitActionType = UnitActionType.FoundReligion;
        int n = 0;
        UnitAction[] unitActionArray2 = unitActionArray;
        boolean bl5 = false;
        boolean bl6 = unit.getCiv().getReligionManager().mayFoundReligionHere(tile) && UnitActionModifiers.INSTANCE.canActivateSideEffects(unit, unique);
        Function0<Unit> function03 = bl6 ? function0 : null;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 56;
        Function0 function04 = function03;
        Unique unique4 = unique3;
        UncivSound uncivSound2 = uncivSound;
        boolean bl7 = bl4;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        unitActionArray2[n] = new UnitAction(unitActionType2, f2, string2, bl7, uncivSound2, unique4, function04, n2, defaultConstructorMarker);
        return SequencesKt.sequenceOf(unitActionArray);
    }

    @NotNull
    public final Sequence<UnitAction> getEnhanceReligionActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Object element$iv2;
        boolean bl;
        Unique unique;
        block5: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (!unit.getCiv().getReligionManager().mayEnhanceReligionAtAll()) {
                return SequencesKt.emptySequence();
            }
            Unique unique2 = SequencesKt.firstOrNull(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(unit, UniqueType.MayEnhanceReligion));
            if (unique2 == null) {
                return SequencesKt.emptySequence();
            }
            unique = unique2;
            Iterable $this$any$iv = unique.getModifiers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    Unique it = (Unique)element$iv2;
                    boolean bl2 = false;
                    Object object = it.getType();
                    boolean bl3 = object != null && (object = object.getTargetTypes()) != null ? ((HashSet)object).contains((Object)UniqueTarget.UnitActionModifier) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean hasActionModifiers = bl;
        StringBuilder stringBuilder = new StringBuilder().append("Enhance [");
        Religion religion = unit.getCiv().getReligionManager().getReligion();
        Intrinsics.checkNotNull(religion);
        String baseTitle = stringBuilder.append(religion.getReligionDisplayName()).append(']').toString();
        UnitAction[] unitActionArray = new UnitAction[1];
        Function0<Unit> function0 = new Function0<Unit>(unit, hasActionModifiers, unique){
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ boolean $hasActionModifiers;
            final /* synthetic */ Unique $unique;
            {
                this.$unit = $unit;
                this.$hasActionModifiers = $hasActionModifiers;
                this.$unique = $unique;
                super(0);
            }

            public final void invoke() {
                this.$unit.getCiv().getReligionManager().useProphetForEnhancingReligion(this.$unit);
                if (this.$hasActionModifiers) {
                    UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, this.$unit, this.$unique, false, 4, null);
                } else {
                    this.$unit.consume();
                }
            }
        };
        element$iv2 = function0;
        Unique unique3 = null;
        UncivSound uncivSound = null;
        boolean bl4 = false;
        String string = hasActionModifiers ? UnitActionModifiers.INSTANCE.actionTextWithSideEffects(baseTitle, unique, unit) : baseTitle;
        float f = 79.0f;
        UnitActionType unitActionType = UnitActionType.EnhanceReligion;
        int n = 0;
        UnitAction[] unitActionArray2 = unitActionArray;
        boolean bl5 = false;
        boolean bl6 = unit.getCiv().getReligionManager().mayEnhanceReligionHere(tile) && UnitActionModifiers.INSTANCE.canActivateSideEffects(unit, unique);
        Function0<Unit> function02 = bl6 ? function0 : null;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 56;
        Function0 function03 = function02;
        Unique unique4 = unique3;
        UncivSound uncivSound2 = uncivSound;
        boolean bl7 = bl4;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        unitActionArray2[n] = new UnitAction(unitActionType2, f2, string2, bl7, uncivSound2, unique4, function03, n2, defaultConstructorMarker);
        return SequencesKt.sequenceOf(unitActionArray);
    }

    private final int getPressureAddedFromSpread(MapUnit unit) {
        float pressureAdded = unit.getBaseUnit().getReligiousStrength();
        Iterator iterator2 = MapUnit.getMatchingUniques$default(unit, UniqueType.SpreadReligionStrength, null, true, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            pressureAdded *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return (int)pressureAdded;
    }

    @NotNull
    public final Sequence<UnitAction> getSpreadReligionActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!unit.getCiv().getReligionManager().maySpreadReligionAtAll(unit)) {
            return SequencesKt.emptySequence();
        }
        City city2 = tile.getCity();
        if (city2 == null) {
            return SequencesKt.emptySequence();
        }
        City city3 = city2;
        Unique unique = SequencesKt.firstOrNull(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(unit, UniqueType.CanSpreadReligion));
        if (unique == null) {
            return SequencesKt.emptySequence();
        }
        Unique newStyleUnique = unique;
        StringBuilder stringBuilder = new StringBuilder().append("Spread [");
        String string = unit.getReligionDisplayName();
        Intrinsics.checkNotNull(string);
        String title = UnitActionModifiers.INSTANCE.actionTextWithSideEffects(stringBuilder.append(string).append(']').toString(), newStyleUnique, unit);
        UnitAction[] unitActionArray = new UnitAction[1];
        Function0<Unit> function0 = new Function0<Unit>(city3, unit, newStyleUnique){
            final /* synthetic */ City $city;
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ Unique $newStyleUnique;
            {
                this.$city = $city;
                this.$unit = $unit;
                this.$newStyleUnique = $newStyleUnique;
                super(0);
            }

            public final void invoke() {
                Religion newReligion;
                CityReligionManager cityReligionManager = this.$city.getReligion();
                String string = this.$unit.getReligion();
                Intrinsics.checkNotNull(string);
                int followersOfOtherReligions = cityReligionManager.getFollowersOfOtherReligionsThan(string);
                Iterator<T> iterator2 = MapUnit.getMatchingUniques$default(this.$unit, UniqueType.StatsWhenSpreading, null, true, 2, null).iterator();
                while (iterator2.hasNext()) {
                    Unique unique = (Unique)iterator2.next();
                    this.$unit.getCiv().addStat(Stat.valueOf(unique.getParams().get(1)), followersOfOtherReligions * Integer.parseInt(unique.getParams().get(0)));
                }
                Religion previousReligion = this.$city.getReligion().getMajorityReligion();
                CityReligionManager cityReligionManager2 = this.$city.getReligion();
                String string2 = this.$unit.getReligion();
                Intrinsics.checkNotNull(string2);
                CityReligionManager.addPressure$default(cityReligionManager2, string2, UnitActionsReligion.access$getPressureAddedFromSpread(UnitActionsReligion.INSTANCE, this.$unit), false, 4, null);
                if (MapUnit.hasUnique$default(this.$unit, UniqueType.RemoveOtherReligions, null, false, 6, null)) {
                    CityReligionManager cityReligionManager3 = this.$city.getReligion();
                    String string3 = this.$unit.getReligion();
                    Intrinsics.checkNotNull(string3);
                    cityReligionManager3.removeAllPressuresExceptFor(string3);
                }
                if (!Intrinsics.areEqual(previousReligion, newReligion = this.$city.getReligion().getMajorityReligion()) && newReligion != null && !Intrinsics.areEqual(this.$city.getCiv(), this.$unit.getCiv())) {
                    this.$city.getCiv().addNotification('[' + this.$unit.getCiv().getCivName() + "]'s [" + this.$unit.getName() + "] has converted [" + this.$city.getName() + "] to [" + newReligion.getName() + "]!", Notification.NotificationCategory.Religion, new String[0]);
                }
                UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, this.$unit, this.$newStyleUnique, false, 4, null);
                if (!Intrinsics.areEqual(this.$city.getCiv(), this.$unit.getCiv())) {
                    DiplomacyManager diplomacyManager = this.$city.getCiv().getDiplomacyManager(this.$unit.getCiv());
                    Intrinsics.checkNotNull(diplomacyManager);
                    diplomacyManager.setFlag(DiplomacyFlags.SpreadReligionInOurCities, 30);
                }
            }
        };
        Function0 function02 = function0;
        Unique unique2 = null;
        UncivSound uncivSound = null;
        boolean bl = false;
        String string2 = title;
        float f = 68.0f;
        UnitActionType unitActionType = UnitActionType.SpreadReligion;
        int n = 0;
        UnitAction[] unitActionArray2 = unitActionArray;
        boolean bl2 = false;
        boolean bl3 = unit.getCiv().getReligionManager().maySpreadReligionNow(unit) && UnitActionModifiers.INSTANCE.canActivateSideEffects(unit, newStyleUnique);
        Function0<Unit> function03 = bl3 ? function0 : null;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 56;
        Function0 function04 = function03;
        Unique unique3 = unique2;
        UncivSound uncivSound2 = uncivSound;
        boolean bl4 = bl;
        String string3 = string2;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        unitActionArray2[n] = new UnitAction(unitActionType2, f2, string3, bl4, uncivSound2, unique3, function04, n2, defaultConstructorMarker);
        return SequencesKt.sequenceOf(unitActionArray);
    }

    @NotNull
    public final Sequence<UnitAction> getRemoveHeresyActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        boolean hasNewStyleAbility;
        boolean bl;
        City city2;
        block10: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (!unit.getCiv().getGameInfo().isReligionEnabled()) {
                return SequencesKt.emptySequence();
            }
            Religion religion = (Religion)((Map)unit.getCiv().getGameInfo().getReligions()).get(unit.getReligion());
            if (religion == null) {
                return SequencesKt.emptySequence();
            }
            Religion religion2 = religion;
            if (religion2.isPantheon()) {
                return SequencesKt.emptySequence();
            }
            City city3 = tile.getCity();
            if (city3 == null) {
                return SequencesKt.emptySequence();
            }
            city2 = city3;
            if (!Intrinsics.areEqual(city2.getCiv(), unit.getCiv())) {
                return SequencesKt.emptySequence();
            }
            Map $this$none$iv = city2.getReligion().getPressures();
            boolean $i$f$none = false;
            if ($this$none$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$none$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Object k = it.getKey();
                    String string = unit.getReligion();
                    Intrinsics.checkNotNull(string);
                    if (!(!Intrinsics.areEqual(k, string))) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (bl) {
            return SequencesKt.emptySequence();
        }
        Unique newStyleUnique = SequencesKt.firstOrNull(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(unit, UniqueType.CanRemoveHeresy));
        boolean bl3 = hasNewStyleAbility = newStyleUnique != null;
        if (!hasNewStyleAbility) {
            return SequencesKt.emptySequence();
        }
        Unique unique = newStyleUnique;
        Intrinsics.checkNotNull(unique);
        String title = UnitActionModifiers.INSTANCE.actionTextWithSideEffects("Remove Heresy", unique, unit);
        UnitAction[] unitActionArray = new UnitAction[1];
        Function0<Unit> function0 = new Function0<Unit>(city2, unit, newStyleUnique){
            final /* synthetic */ City $city;
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ Unique $newStyleUnique;
            {
                this.$city = $city;
                this.$unit = $unit;
                this.$newStyleUnique = $newStyleUnique;
                super(0);
            }

            public final void invoke() {
                CityReligionManager cityReligionManager = this.$city.getReligion();
                String string = this.$unit.getReligion();
                Intrinsics.checkNotNull(string);
                cityReligionManager.removeAllPressuresExceptFor(string);
                if (this.$city.getReligion().getReligionThisIsTheHolyCityOf() != null) {
                    V v = ((Map)this.$unit.getCiv().getGameInfo().getReligions()).get(this.$city.getReligion().getReligionThisIsTheHolyCityOf());
                    Intrinsics.checkNotNull(v);
                    Religion holyCityReligion = (Religion)v;
                    if (!Intrinsics.areEqual(this.$city.getReligion().getReligionThisIsTheHolyCityOf(), this.$unit.getReligion()) && !this.$city.getReligion().isBlockedHolyCity()) {
                        holyCityReligion.getFounder().addNotification("An [" + this.$unit.getBaseUnit().getName() + "] has removed your religion [" + holyCityReligion.getReligionDisplayName() + "] from its Holy City [" + this.$city.getName() + "]!", Notification.NotificationCategory.Religion, new String[0]);
                        this.$city.getReligion().setBlockedHolyCity(true);
                    } else if (Intrinsics.areEqual(this.$city.getReligion().getReligionThisIsTheHolyCityOf(), this.$unit.getReligion()) && this.$city.getReligion().isBlockedHolyCity()) {
                        holyCityReligion.getFounder().addNotification("An [" + this.$unit.getBaseUnit().getName() + "] has restored [" + this.$city.getName() + "] as the Holy City of your religion [" + holyCityReligion.getReligionDisplayName() + "]!", Notification.NotificationCategory.Religion, new String[0]);
                        this.$city.getReligion().setBlockedHolyCity(false);
                    }
                }
                UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, this.$unit, this.$newStyleUnique, false, 4, null);
            }
        };
        Function0 bl2 = function0;
        Unique unique2 = null;
        UncivSound uncivSound = null;
        boolean bl4 = false;
        String string = title;
        float f = 69.0f;
        UnitActionType unitActionType = UnitActionType.RemoveHeresy;
        int n = 0;
        UnitAction[] unitActionArray2 = unitActionArray;
        boolean bl5 = false;
        boolean bl6 = UnitActionModifiers.INSTANCE.canActivateSideEffects(unit, newStyleUnique);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 56;
        Function0 function02 = bl6 ? function0 : null;
        Unique unique3 = unique2;
        UncivSound uncivSound2 = uncivSound;
        boolean bl7 = bl4;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        unitActionArray2[n] = new UnitAction(unitActionType2, f2, string2, bl7, uncivSound2, unique3, function02, n2, defaultConstructorMarker);
        return SequencesKt.sequenceOf(unitActionArray);
    }

    public static final /* synthetic */ int access$getPressureAddedFromSpread(UnitActionsReligion $this, MapUnit unit) {
        return $this.getPressureAddedFromSpread(unit);
    }
}

