/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.CaseInsensitiveMap;
import io.ktor.util.InternalAPI;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;

@InternalAPI
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0016\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0011\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0016\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0096\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0016\u0010\u001b\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0016\u0010\u001c\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lio/ktor/util/CaseInsensitiveSet;", "", "", "initial", "", "(Ljava/lang/Iterable;)V", "()V", "backingMap", "Lio/ktor/util/CaseInsensitiveMap;", "", "size", "", "getSize", "()I", "add", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "isEmpty", "iterator", "", "remove", "removeAll", "retainAll", "ktor-utils"})
public final class CaseInsensitiveSet
implements Set<String>,
KMutableSet {
    @NotNull
    private final CaseInsensitiveMap<Boolean> backingMap;

    public CaseInsensitiveSet() {
        this.backingMap = new CaseInsensitiveMap();
    }

    public CaseInsensitiveSet(@NotNull Iterable<String> initial) {
        Intrinsics.checkNotNullParameter(initial, "initial");
        this();
        CollectionsKt.addAll((Collection)this, initial);
    }

    @Override
    public boolean add(@NotNull String element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (((Map)this.backingMap).containsKey(element)) {
            return false;
        }
        ((Map)this.backingMap).put(element, true);
        return true;
    }

    public int getSize() {
        return this.backingMap.size();
    }

    public boolean remove(@NotNull String element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return Intrinsics.areEqual(this.backingMap.remove((Object)element), true);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends String> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean added = false;
        for (String string : elements) {
            if (!this.add(string)) continue;
            added = true;
        }
        return added;
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this.backingMap.keySet().removeAll(elements);
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this.backingMap.keySet().retainAll(elements);
    }

    public boolean contains(@NotNull String element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ((Map)this.backingMap).containsKey(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this.backingMap.keySet().containsAll(elements);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.backingMap.keySet().iterator();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return CollectionToArray.toArray(this, array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }
}

